/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.classfile;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.graalvm.visualvm.lib.jfluid.TargetAppRunner;
import org.graalvm.visualvm.lib.jfluid.classfile.BaseClassInfo;
import org.graalvm.visualvm.lib.jfluid.classfile.ClassFileCache;
import org.graalvm.visualvm.lib.jfluid.classfile.ClassInfo;
import org.graalvm.visualvm.lib.jfluid.classfile.ClassLoaderTable;
import org.graalvm.visualvm.lib.jfluid.classfile.ClassPath;
import org.graalvm.visualvm.lib.jfluid.classfile.DynamicClassInfo;
import org.graalvm.visualvm.lib.jfluid.classfile.LazyDynamicClassInfo;
import org.graalvm.visualvm.lib.jfluid.classfile.PlaceholderClassInfo;
import org.graalvm.visualvm.lib.jfluid.classfile.SameNameClassGroup;
import org.graalvm.visualvm.lib.jfluid.global.CommonConstants;
import org.graalvm.visualvm.lib.jfluid.instrumentation.BadLocationException;
import org.graalvm.visualvm.lib.jfluid.utils.MiscUtils;

public abstract class ClassRepository
implements CommonConstants {
    static final String LOCATION_VMSUPPLIED = "<VM_SUPPLIED>";
    private static ClassPath classPath;
    private static Hashtable classes;
    private static Set notFoundClasses;
    private static Map definingClassLoaderMap;

    public static List getAllClassVersions(String className) {
        Object entry = classes.get(className = className.replace('.', '/').intern());
        if (entry != null) {
            List<Object> ret = new ArrayList();
            if (entry instanceof BaseClassInfo) {
                ret.add(entry);
            } else {
                ret = ((SameNameClassGroup)entry).getAll();
            }
            return ret;
        }
        return null;
    }

    public static Enumeration getClassEnumerationWithAllVersions() {
        class ClassesEnumeration
        implements Enumeration {
            private Enumeration baseEnum;
            private Object nextElement;
            private List classes;
            private int idx;

            ClassesEnumeration(Enumeration baseEnum) {
                this.baseEnum = baseEnum;
            }

            @Override
            public boolean hasMoreElements() {
                if (this.nextElement == null) {
                    return this.baseEnum.hasMoreElements();
                }
                return true;
            }

            public Object nextElement() {
                if (this.nextElement != null) {
                    Object ret = this.nextElement;
                    ++this.idx;
                    this.nextElement = this.idx == this.classes.size() ? null : this.classes.get(this.idx);
                    return ret;
                }
                Object next = this.baseEnum.nextElement();
                if (next instanceof SameNameClassGroup) {
                    SameNameClassGroup g = (SameNameClassGroup)next;
                    this.classes = g.getAll();
                    next = this.classes.get(0);
                    if (this.classes.size() > 1) {
                        this.idx = 1;
                        this.nextElement = this.classes.get(1);
                    } else {
                        this.classes = null;
                    }
                }
                return next;
            }
        }
        return new ClassesEnumeration(classes.elements());
    }

    public static ClassPath getClassPath() {
        return classPath;
    }

    public static List getClassesOnClasspath(List classPathElementList) {
        ArrayList list = new ArrayList();
        list.addAll(classPathElementList);
        ArrayList res = new ArrayList();
        for (String dirOrJar : list) {
            if (!dirOrJar.endsWith(".jar") && !dirOrJar.endsWith(".zip")) {
                MiscUtils.getAllClassesInDir(dirOrJar, "", true, res);
                continue;
            }
            MiscUtils.getAllClassesInJar(dirOrJar, true, res);
        }
        return res;
    }

    public static CodeRegionBCI getMethodForSourceRegion(ClassInfo clazz, int startLine, int endLine) throws ClassNotFoundException, IOException, BadLocationException {
        if (startLine > endLine) {
            return null;
        }
        int[] idxAndBCI0 = clazz.methodIdxAndBestBCIForLineNo(startLine);
        int methodIdx = idxAndBCI0[0];
        if (methodIdx >= 0) {
            byte[] codeBytes;
            int[] idxAndBCI1;
            CodeRegionBCI res;
            String methodName = clazz.getMethodNames()[methodIdx];
            if ((methodName == "<init>" || methodName == "<clinit>") && (res = ClassRepository.getMethodForSourceRegionInNestedClasses(clazz, startLine, endLine)) != null) {
                return res;
            }
            int[] minAndMaxLines = clazz.getMinAndMaxLinesForMethod(methodIdx);
            if (endLine == minAndMaxLines[1]) {
                idxAndBCI1 = new int[2];
                idxAndBCI1[0] = methodIdx;
                codeBytes = clazz.getMethodBytecode(methodIdx);
                idxAndBCI1[1] = ClassInfo.findPreviousBCI(codeBytes, codeBytes.length);
            } else {
                if (endLine < minAndMaxLines[1]) {
                    ++endLine;
                }
                if (methodIdx != (idxAndBCI1 = clazz.methodIdxAndBestBCIForLineNo(endLine))[0]) {
                    if (idxAndBCI1[0] != -1) {
                        return null;
                    }
                    idxAndBCI1[0] = methodIdx;
                    codeBytes = clazz.getMethodBytecode(methodIdx);
                    idxAndBCI1[1] = ClassInfo.findPreviousBCI(codeBytes, codeBytes.length);
                }
            }
            int bestBCI0 = idxAndBCI0[1];
            for (int lineNo = startLine + 1; lineNo < endLine - 1; ++lineNo) {
                int otherBestBCI0 = clazz.bciForMethodAndLineNo(methodIdx, lineNo);
                if (otherBestBCI0 >= bestBCI0) continue;
                bestBCI0 = otherBestBCI0;
            }
            return new CodeRegionBCI(clazz.getName(), clazz.getMethodNames()[methodIdx], clazz.getMethodSignatures()[methodIdx], bestBCI0, idxAndBCI1[1]);
        }
        if (methodIdx == -2) {
            throw new BadLocationException("Class does not have source line number tables.\nRecompile it with appropriate options.");
        }
        return ClassRepository.getMethodForSourceRegionInNestedClasses(clazz, startLine, endLine);
    }

    public static CodeRegionBCI getMethodMinAndMaxBCI(ClassInfo clazz, String methodName, String methodSignature) {
        int idx = clazz.getMethodIndex(methodName = methodName.intern(), methodSignature = methodSignature.intern());
        if (idx == -1) {
            return null;
        }
        return new CodeRegionBCI(clazz.getName(), methodName, methodSignature, 0, clazz.getMethodBytecode(idx).length - 1);
    }

    public static void addClassInfo(BaseClassInfo pci) {
        String className = pci.getName();
        Object entry = classes.get(className);
        if (entry != null) {
            if (entry instanceof BaseClassInfo) {
                BaseClassInfo singleExistingClazzOrPCI = (BaseClassInfo)entry;
                SameNameClassGroup classGroup = new SameNameClassGroup();
                classGroup.add(singleExistingClazzOrPCI);
                classGroup.add(pci);
                classes.put(className, classGroup);
            } else {
                SameNameClassGroup classGroup = (SameNameClassGroup)entry;
                classGroup.add(pci);
            }
        } else {
            classes.put(className, pci);
        }
    }

    public static void addVMSuppliedClassFile(String className, int classLoaderId, byte[] buf) {
        assert (buf != null && buf.length > 0);
        ClassRepository.addVMSuppliedClassFile(className, classLoaderId, buf, null, null);
    }

    public static void addVMSuppliedClassFile(String className, int classLoaderId, byte[] buf, String superClassName, String[] interfaceNames) {
        ClassFileCache.getDefault().addVMSuppliedClassFile(className, classLoaderId, buf);
        if (buf != null && buf.length == 0) {
            try {
                String location = ClassRepository.getClassFileLoc(classLoaderId);
                LazyDynamicClassInfo lazyClass = new LazyDynamicClassInfo(className, classLoaderId, location, superClassName, interfaceNames);
                ClassRepository.addClassInfo(lazyClass);
            }
            catch (IOException ex) {
                Logger.getLogger(ClassRepository.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public static void cleanup() {
        ClassRepository.clearCache();
        if (classPath != null) {
            classPath.close();
            classPath = null;
        }
    }

    public static void clearCache() {
        classes = new Hashtable();
        ClassFileCache.resetDefaultCache();
        notFoundClasses = new HashSet();
        definingClassLoaderMap = new HashMap();
    }

    public static void initClassPaths(String workingDir, String[] classPaths) {
        List userClassPathElementList = MiscUtils.getPathComponents(classPaths[0], true, workingDir);
        List bootClassPathElementList = MiscUtils.getPathComponents(classPaths[2], true, workingDir);
        String extPath = classPaths[1];
        ArrayList extClassPathElementList = new ArrayList();
        List dirs = MiscUtils.getPathComponents(extPath, true, workingDir);
        Iterator e = dirs.iterator();
        while (e.hasNext()) {
            File extDir = new File((String)e.next());
            String[] extensions = extDir.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return (name = name.toLowerCase(Locale.ENGLISH)).endsWith(".zip") || name.endsWith(".jar");
                }
            });
            if (extensions == null) continue;
            for (String extension : extensions) {
                String extJar = extDir.getAbsolutePath() + File.separatorChar + extension;
                List allJarComponents = MiscUtils.getPathComponents(extJar, true, workingDir);
                extClassPathElementList.addAll(allJarComponents);
            }
        }
        ArrayList list = new ArrayList();
        list.addAll(bootClassPathElementList);
        list.addAll(extClassPathElementList);
        list.addAll(userClassPathElementList);
        StringBuilder buf = new StringBuilder();
        Iterator e2 = list.iterator();
        while (e2.hasNext()) {
            buf.append((String)e2.next());
            if (!e2.hasNext()) continue;
            buf.append(File.pathSeparatorChar);
        }
        classPath = new ClassPath(buf.toString(), true);
        notFoundClasses = new HashSet();
    }

    public static DynamicClassInfo lookupClass(String className, int classLoaderId) throws IOException, ClassFormatError {
        return ClassRepository.lookupClass(className, classLoaderId, true);
    }

    public static BaseClassInfo lookupClassOrCreatePlaceholder(String className, int classLoaderId) {
        BaseClassInfo singleExistingClazzOrPCI = null;
        BaseClassInfo clazzOrPCI = null;
        SameNameClassGroup classGroup = null;
        Object entry = classes.get(className = className.replace('.', '/').intern());
        if (entry != null) {
            if (entry instanceof BaseClassInfo) {
                singleExistingClazzOrPCI = (BaseClassInfo)entry;
                clazzOrPCI = SameNameClassGroup.checkForCompatibility(singleExistingClazzOrPCI, classLoaderId);
            } else {
                classGroup = (SameNameClassGroup)entry;
                clazzOrPCI = classGroup.findCompatibleClass(classLoaderId);
            }
            if (clazzOrPCI != null) {
                return clazzOrPCI;
            }
            clazzOrPCI = new PlaceholderClassInfo(className, classLoaderId);
            if (classGroup != null) {
                classGroup.add(clazzOrPCI);
            } else {
                classGroup = new SameNameClassGroup();
                classGroup.add(singleExistingClazzOrPCI);
                classGroup.add(clazzOrPCI);
                classes.put(className, classGroup);
            }
            return clazzOrPCI;
        }
        clazzOrPCI = new PlaceholderClassInfo(className, classLoaderId);
        classes.put(className, clazzOrPCI);
        return clazzOrPCI;
    }

    public static BaseClassInfo lookupLoadedClass(String className, int classLoaderId, boolean allowExistingPlaceholder) {
        BaseClassInfo singleExistingClazzOrPCI = null;
        BaseClassInfo clazzOrPCI = null;
        Object entry = classes.get(className = className.replace('.', '/').intern());
        if (entry != null) {
            if (entry instanceof BaseClassInfo) {
                singleExistingClazzOrPCI = (BaseClassInfo)entry;
                clazzOrPCI = SameNameClassGroup.checkForCompatibility(singleExistingClazzOrPCI, classLoaderId);
            } else {
                SameNameClassGroup classGroup = (SameNameClassGroup)entry;
                clazzOrPCI = classGroup.findCompatibleClass(classLoaderId);
            }
            if (clazzOrPCI != null) {
                if (!(clazzOrPCI instanceof PlaceholderClassInfo)) {
                    return clazzOrPCI;
                }
                if (allowExistingPlaceholder) {
                    return clazzOrPCI;
                }
            }
        }
        return null;
    }

    public static BaseClassInfo lookupSpecialClass(String className) {
        BaseClassInfo clazz;
        if (className.indexOf(46) != -1) {
            className = className.replace('.', '/').intern();
        }
        if ((clazz = (BaseClassInfo)classes.get(className)) == null) {
            clazz = new BaseClassInfo(className, 0);
            classes.put(className, clazz);
        }
        return clazz;
    }

    static int getDefiningClassLoaderId(String className, int classLoaderId) {
        String classId = className + "#" + classLoaderId;
        Integer loaderInt = (Integer)definingClassLoaderMap.get(classId);
        if (loaderInt != null) {
            return loaderInt;
        }
        int loader = -1;
        try {
            loader = TargetAppRunner.getDefault().getProfilerClient().getDefiningClassLoaderId(className, classLoaderId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        definingClassLoaderMap.put(classId, loader);
        return loader;
    }

    private static CodeRegionBCI getMethodForSourceRegionInNestedClasses(ClassInfo clazz, int startLine, int endLine) throws ClassNotFoundException, IOException, ClassFormatError {
        String className = clazz.getName();
        String[] nestedClassNames = clazz.getNestedClassNames();
        int classNameLen = className.length();
        if (nestedClassNames != null) {
            for (String nestedClassName : nestedClassNames) {
                if (!nestedClassName.startsWith(className) || nestedClassName.length() <= classNameLen) continue;
                try {
                    CodeRegionBCI res;
                    DynamicClassInfo nestedClass = ClassRepository.lookupClass(nestedClassName, clazz.getLoaderId());
                    if (nestedClass == null || (res = ClassRepository.getMethodForSourceRegion(nestedClass, startLine, endLine)) == null) continue;
                    return res;
                }
                catch (BadLocationException ex) {
                    return null;
                }
            }
        }
        return null;
    }

    private static DynamicClassInfo checkForVMSuppliedClass(String className, int classLoaderId) throws IOException, ClassFormatError {
        int realLoaderId = ClassFileCache.getDefault().hasVMSuppliedClassFile(className, classLoaderId);
        if (realLoaderId != -1) {
            String classFileLoc = ClassRepository.getClassFileLoc(realLoaderId);
            return new DynamicClassInfo(className, classLoaderId, classFileLoc);
        }
        return null;
    }

    static String getClassFileLoc(int realLoaderId) {
        return (LOCATION_VMSUPPLIED + realLoaderId).intern();
    }

    private static DynamicClassInfo lookupClass(String className, int classLoaderId, boolean reportIfNotFound) throws IOException, ClassFormatError {
        BaseClassInfo singleExistingClazzOrPCI = null;
        SameNameClassGroup classGroup = null;
        Object entry = classes.get(className = className.replace('.', '/').intern());
        if (entry != null) {
            BaseClassInfo clazzOrPCI;
            if (entry instanceof BaseClassInfo) {
                singleExistingClazzOrPCI = (BaseClassInfo)entry;
                clazzOrPCI = SameNameClassGroup.checkForCompatibility(singleExistingClazzOrPCI, classLoaderId);
            } else {
                classGroup = (SameNameClassGroup)entry;
                clazzOrPCI = classGroup.findCompatibleClass(classLoaderId);
            }
            if (clazzOrPCI != null) {
                if (!(clazzOrPCI instanceof PlaceholderClassInfo)) {
                    return (DynamicClassInfo)clazzOrPCI;
                }
                PlaceholderClassInfo pci = (PlaceholderClassInfo)clazzOrPCI;
                DynamicClassInfo clazz = ClassRepository.tryLoadRealClass(className, classLoaderId, reportIfNotFound);
                if (clazz != null) {
                    pci.transferDataIntoRealClass(clazz);
                    if (classGroup != null) {
                        classGroup.replace(pci, clazz);
                    } else {
                        classes.put(className, clazz);
                    }
                    return clazz;
                }
                return null;
            }
            DynamicClassInfo clazz = ClassRepository.tryLoadRealClass(className, classLoaderId, reportIfNotFound);
            if (clazz != null) {
                if (classGroup != null) {
                    classGroup.add(clazz);
                } else {
                    classGroup = new SameNameClassGroup();
                    classGroup.add(singleExistingClazzOrPCI);
                    classGroup.add(clazz);
                    classes.put(className, classGroup);
                }
                return clazz;
            }
            return null;
        }
        DynamicClassInfo clazz = ClassRepository.tryLoadRealClass(className, classLoaderId, reportIfNotFound);
        if (clazz != null) {
            classes.put(className, clazz);
            return clazz;
        }
        return null;
    }

    private static DynamicClassInfo tryLoadRealClass(String className, int classLoaderId, boolean reportIfNotFound) throws IOException, ClassFormatError {
        DynamicClassInfo clazz = null;
        int loader = classLoaderId;
        do {
            if ((clazz = ClassRepository.checkForVMSuppliedClass(className, loader)) != null || loader != 0 && loader != -1 || classPath == null) continue;
            clazz = classPath.getClassInfoForClass(className, loader);
        } while (clazz == null && loader != 0 && (loader = ClassLoaderTable.getParentLoader(loader)) >= 0);
        if (clazz == null && (loader = ClassRepository.getDefiningClassLoaderId(className, classLoaderId)) != -1 && (clazz = ClassRepository.checkForVMSuppliedClass(className, loader)) == null && loader == 0) {
            clazz = classPath.getClassInfoForClass(className, loader);
        }
        if (clazz == null && reportIfNotFound && !notFoundClasses.contains(className)) {
            MiscUtils.printWarningMessage("class " + className + ", ldr = " + classLoaderId + " not found anywhere");
            notFoundClasses.add(className);
        }
        return clazz;
    }

    static {
        ClassRepository.clearCache();
    }

    public static class CodeRegionBCI {
        public String className;
        public String methodName;
        public String methodSignature;
        public int bci0;
        public int bci1;

        public CodeRegionBCI(String className, String methodName, String methodSignature, int bci0, int bci1) {
            this.className = className;
            this.methodName = methodName;
            this.methodSignature = methodSignature;
            this.bci0 = bci0;
            this.bci1 = bci1;
        }

        public String toString() {
            return "CodeRegionBCI [className: " + this.className + ", methodName: " + this.methodName + ", methodSignature: " + this.methodSignature + ", bci0: " + this.bci0 + ", bci1: " + this.bci1 + "]";
        }
    }
}

