
// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyfalkon_python.h"

// main header
#include "bookmarkitem_wrapper.h"

// inner classes

// Extra includes
#include <QList>
#include <bookmarkitem.h>
#include <qicon.h>
#include <qurl.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_BookmarkItem_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::BookmarkItem >()))
        return -1;

    ::BookmarkItem *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.BookmarkItem.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_BookmarkItem_Init_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_BookmarkItem_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:BookmarkItem", &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: BookmarkItem::BookmarkItem(BookmarkItem::Type,BookmarkItem*)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPyFalkonTypes[SBK_BOOKMARKITEM_TYPE_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // BookmarkItem(BookmarkItem::Type,BookmarkItem*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_BOOKMARKITEM_IDX]), (pyArgs[1])))) {
            overloadId = 0; // BookmarkItem(BookmarkItem::Type,BookmarkItem*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_BookmarkItem_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            PyObject *kwds_dup = PyDict_Copy(kwds);
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[1]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_BookmarkItem_Init_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_BOOKMARKITEM_IDX]), (pyArgs[1]))))
                        goto Sbk_BookmarkItem_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup;
                goto Sbk_BookmarkItem_Init_TypeError;
            } else {
                Py_DECREF(kwds_dup);
            }
        }
        ::BookmarkItem::Type cppArg0{BookmarkItem::Root};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return -1;
        ::BookmarkItem *cppArg1 = nullptr;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // BookmarkItem(BookmarkItem::Type,BookmarkItem*)
            cptr = new ::BookmarkItem(cppArg0, cppArg1);
            Shiboken::Object::setParent(pyArgs[1], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::BookmarkItem >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_BookmarkItem_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_BookmarkItem_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_BookmarkItemFunc_addChild(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::BookmarkItem *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_BOOKMARKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.BookmarkItem.addChild";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_BookmarkItemFunc_addChild_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_BookmarkItemFunc_addChild_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:addChild", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: BookmarkItem::addChild(BookmarkItem*,int)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_BOOKMARKITEM_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // addChild(BookmarkItem*,int)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 0; // addChild(BookmarkItem*,int)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_BookmarkItemFunc_addChild_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            PyObject *kwds_dup = PyDict_Copy(kwds);
            static PyObject *const key_index = Shiboken::String::createStaticString("index");
            if (PyDict_Contains(kwds, key_index)) {
                value = PyDict_GetItem(kwds, key_index);
                if (value && pyArgs[1]) {
                    errInfo = key_index;
                    Py_INCREF(errInfo);
                    goto Sbk_BookmarkItemFunc_addChild_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                        goto Sbk_BookmarkItemFunc_addChild_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_index);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup;
                goto Sbk_BookmarkItemFunc_addChild_TypeError;
            } else {
                Py_DECREF(kwds_dup);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::BookmarkItem *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1 = -1;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // addChild(BookmarkItem*,int)
            cppSelf->addChild(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_BookmarkItemFunc_addChild_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_BookmarkItemFunc_children(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::BookmarkItem *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_BOOKMARKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.BookmarkItem.children";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // children()const
            QList<BookmarkItem* > cppResult = const_cast<const ::BookmarkItem *>(cppSelf)->children();
            pyResult = Shiboken::Conversions::copyToPython(SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_BOOKMARKITEMPTR_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_BookmarkItemFunc_description(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::BookmarkItem *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_BOOKMARKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.BookmarkItem.description";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // description()const
            QString cppResult = const_cast<const ::BookmarkItem *>(cppSelf)->description();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_BookmarkItemFunc_icon(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::BookmarkItem *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_BOOKMARKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.BookmarkItem.icon";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // icon()
            QIcon cppResult = cppSelf->icon();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QICON_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_BookmarkItemFunc_isExpanded(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::BookmarkItem *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_BOOKMARKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.BookmarkItem.isExpanded";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isExpanded()const
            bool cppResult = const_cast<const ::BookmarkItem *>(cppSelf)->isExpanded();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_BookmarkItemFunc_isFolder(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::BookmarkItem *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_BOOKMARKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.BookmarkItem.isFolder";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isFolder()const
            bool cppResult = const_cast<const ::BookmarkItem *>(cppSelf)->isFolder();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_BookmarkItemFunc_isSeparator(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::BookmarkItem *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_BOOKMARKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.BookmarkItem.isSeparator";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isSeparator()const
            bool cppResult = const_cast<const ::BookmarkItem *>(cppSelf)->isSeparator();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_BookmarkItemFunc_isSidebarExpanded(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::BookmarkItem *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_BOOKMARKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.BookmarkItem.isSidebarExpanded";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isSidebarExpanded()const
            bool cppResult = const_cast<const ::BookmarkItem *>(cppSelf)->isSidebarExpanded();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_BookmarkItemFunc_isUrl(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::BookmarkItem *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_BOOKMARKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.BookmarkItem.isUrl";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isUrl()const
            bool cppResult = const_cast<const ::BookmarkItem *>(cppSelf)->isUrl();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_BookmarkItemFunc_keyword(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::BookmarkItem *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_BOOKMARKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.BookmarkItem.keyword";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // keyword()const
            QString cppResult = const_cast<const ::BookmarkItem *>(cppSelf)->keyword();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_BookmarkItemFunc_parent(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::BookmarkItem *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_BOOKMARKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.BookmarkItem.parent";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // parent()const
            BookmarkItem * cppResult = const_cast<const ::BookmarkItem *>(cppSelf)->parent();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_BOOKMARKITEM_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_BookmarkItemFunc_removeChild(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::BookmarkItem *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_BOOKMARKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.BookmarkItem.removeChild";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: BookmarkItem::removeChild(BookmarkItem*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_BOOKMARKITEM_IDX]), (pyArg)))) {
        overloadId = 0; // removeChild(BookmarkItem*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_BookmarkItemFunc_removeChild_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::BookmarkItem *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // removeChild(BookmarkItem*)
            cppSelf->removeChild(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_BookmarkItemFunc_removeChild_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_BookmarkItemFunc_setDescription(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::BookmarkItem *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_BOOKMARKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.BookmarkItem.setDescription";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: BookmarkItem::setDescription(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setDescription(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_BookmarkItemFunc_setDescription_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDescription(QString)
            cppSelf->setDescription(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_BookmarkItemFunc_setDescription_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_BookmarkItemFunc_setExpanded(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::BookmarkItem *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_BOOKMARKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.BookmarkItem.setExpanded";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: BookmarkItem::setExpanded(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setExpanded(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_BookmarkItemFunc_setExpanded_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setExpanded(bool)
            cppSelf->setExpanded(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_BookmarkItemFunc_setExpanded_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_BookmarkItemFunc_setIcon(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::BookmarkItem *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_BOOKMARKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.BookmarkItem.setIcon";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: BookmarkItem::setIcon(QIcon)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QICON_IDX]), (pyArg)))) {
        overloadId = 0; // setIcon(QIcon)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_BookmarkItemFunc_setIcon_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QIcon cppArg0_local;
        ::QIcon *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QICON_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setIcon(QIcon)
            cppSelf->setIcon(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_BookmarkItemFunc_setIcon_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_BookmarkItemFunc_setKeyword(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::BookmarkItem *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_BOOKMARKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.BookmarkItem.setKeyword";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: BookmarkItem::setKeyword(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setKeyword(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_BookmarkItemFunc_setKeyword_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setKeyword(QString)
            cppSelf->setKeyword(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_BookmarkItemFunc_setKeyword_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_BookmarkItemFunc_setSidebarExpanded(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::BookmarkItem *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_BOOKMARKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.BookmarkItem.setSidebarExpanded";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: BookmarkItem::setSidebarExpanded(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setSidebarExpanded(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_BookmarkItemFunc_setSidebarExpanded_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSidebarExpanded(bool)
            cppSelf->setSidebarExpanded(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_BookmarkItemFunc_setSidebarExpanded_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_BookmarkItemFunc_setTitle(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::BookmarkItem *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_BOOKMARKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.BookmarkItem.setTitle";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: BookmarkItem::setTitle(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setTitle(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_BookmarkItemFunc_setTitle_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setTitle(QString)
            cppSelf->setTitle(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_BookmarkItemFunc_setTitle_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_BookmarkItemFunc_setType(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::BookmarkItem *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_BOOKMARKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.BookmarkItem.setType";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: BookmarkItem::setType(BookmarkItem::Type)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPyFalkonTypes[SBK_BOOKMARKITEM_TYPE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setType(BookmarkItem::Type)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_BookmarkItemFunc_setType_TypeError;

    // Call function/method
    {
        ::BookmarkItem::Type cppArg0{BookmarkItem::Root};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setType(BookmarkItem::Type)
            cppSelf->setType(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_BookmarkItemFunc_setType_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_BookmarkItemFunc_setUrl(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::BookmarkItem *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_BOOKMARKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.BookmarkItem.setUrl";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: BookmarkItem::setUrl(QUrl)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArg)))) {
        overloadId = 0; // setUrl(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_BookmarkItemFunc_setUrl_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setUrl(QUrl)
            cppSelf->setUrl(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_BookmarkItemFunc_setUrl_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_BookmarkItemFunc_setVisitCount(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::BookmarkItem *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_BOOKMARKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.BookmarkItem.setVisitCount";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: BookmarkItem::setVisitCount(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setVisitCount(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_BookmarkItemFunc_setVisitCount_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setVisitCount(int)
            cppSelf->setVisitCount(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_BookmarkItemFunc_setVisitCount_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_BookmarkItemFunc_title(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::BookmarkItem *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_BOOKMARKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.BookmarkItem.title";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // title()const
            QString cppResult = const_cast<const ::BookmarkItem *>(cppSelf)->title();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_BookmarkItemFunc_type(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::BookmarkItem *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_BOOKMARKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.BookmarkItem.type";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // type()const
            BookmarkItem::Type cppResult = BookmarkItem::Type(const_cast<const ::BookmarkItem *>(cppSelf)->type());
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPyFalkonTypes[SBK_BOOKMARKITEM_TYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_BookmarkItemFunc_typeFromString(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.BookmarkItem.typeFromString";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static BookmarkItem::typeFromString(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // typeFromString(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_BookmarkItemFunc_typeFromString_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // typeFromString(QString)
            BookmarkItem::Type cppResult = BookmarkItem::Type(::BookmarkItem::typeFromString(cppArg0));
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPyFalkonTypes[SBK_BOOKMARKITEM_TYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_BookmarkItemFunc_typeFromString_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_BookmarkItemFunc_typeToString(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.BookmarkItem.typeToString";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static BookmarkItem::typeToString(BookmarkItem::Type)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPyFalkonTypes[SBK_BOOKMARKITEM_TYPE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // typeToString(BookmarkItem::Type)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_BookmarkItemFunc_typeToString_TypeError;

    // Call function/method
    {
        ::BookmarkItem::Type cppArg0{BookmarkItem::Root};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // typeToString(BookmarkItem::Type)
            QString cppResult = ::BookmarkItem::typeToString(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_BookmarkItemFunc_typeToString_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_BookmarkItemFunc_updateVisitCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::BookmarkItem *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_BOOKMARKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.BookmarkItem.updateVisitCount";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // updateVisitCount()
            cppSelf->updateVisitCount();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_BookmarkItemFunc_url(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::BookmarkItem *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_BOOKMARKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.BookmarkItem.url";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // url()const
            QUrl cppResult = const_cast<const ::BookmarkItem *>(cppSelf)->url();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_BookmarkItemFunc_urlString(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::BookmarkItem *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_BOOKMARKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.BookmarkItem.urlString";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // urlString()const
            QString cppResult = const_cast<const ::BookmarkItem *>(cppSelf)->urlString();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_BookmarkItemFunc_visitCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::BookmarkItem *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_BOOKMARKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.BookmarkItem.visitCount";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // visitCount()const
            int cppResult = const_cast<const ::BookmarkItem *>(cppSelf)->visitCount();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_BookmarkItem_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_BookmarkItem_methods[] = {
    {"addChild", reinterpret_cast<PyCFunction>(Sbk_BookmarkItemFunc_addChild), METH_VARARGS|METH_KEYWORDS},
    {"children", reinterpret_cast<PyCFunction>(Sbk_BookmarkItemFunc_children), METH_NOARGS},
    {"description", reinterpret_cast<PyCFunction>(Sbk_BookmarkItemFunc_description), METH_NOARGS},
    {"icon", reinterpret_cast<PyCFunction>(Sbk_BookmarkItemFunc_icon), METH_NOARGS},
    {"isExpanded", reinterpret_cast<PyCFunction>(Sbk_BookmarkItemFunc_isExpanded), METH_NOARGS},
    {"isFolder", reinterpret_cast<PyCFunction>(Sbk_BookmarkItemFunc_isFolder), METH_NOARGS},
    {"isSeparator", reinterpret_cast<PyCFunction>(Sbk_BookmarkItemFunc_isSeparator), METH_NOARGS},
    {"isSidebarExpanded", reinterpret_cast<PyCFunction>(Sbk_BookmarkItemFunc_isSidebarExpanded), METH_NOARGS},
    {"isUrl", reinterpret_cast<PyCFunction>(Sbk_BookmarkItemFunc_isUrl), METH_NOARGS},
    {"keyword", reinterpret_cast<PyCFunction>(Sbk_BookmarkItemFunc_keyword), METH_NOARGS},
    {"parent", reinterpret_cast<PyCFunction>(Sbk_BookmarkItemFunc_parent), METH_NOARGS},
    {"removeChild", reinterpret_cast<PyCFunction>(Sbk_BookmarkItemFunc_removeChild), METH_O},
    {"setDescription", reinterpret_cast<PyCFunction>(Sbk_BookmarkItemFunc_setDescription), METH_O},
    {"setExpanded", reinterpret_cast<PyCFunction>(Sbk_BookmarkItemFunc_setExpanded), METH_O},
    {"setIcon", reinterpret_cast<PyCFunction>(Sbk_BookmarkItemFunc_setIcon), METH_O},
    {"setKeyword", reinterpret_cast<PyCFunction>(Sbk_BookmarkItemFunc_setKeyword), METH_O},
    {"setSidebarExpanded", reinterpret_cast<PyCFunction>(Sbk_BookmarkItemFunc_setSidebarExpanded), METH_O},
    {"setTitle", reinterpret_cast<PyCFunction>(Sbk_BookmarkItemFunc_setTitle), METH_O},
    {"setType", reinterpret_cast<PyCFunction>(Sbk_BookmarkItemFunc_setType), METH_O},
    {"setUrl", reinterpret_cast<PyCFunction>(Sbk_BookmarkItemFunc_setUrl), METH_O},
    {"setVisitCount", reinterpret_cast<PyCFunction>(Sbk_BookmarkItemFunc_setVisitCount), METH_O},
    {"title", reinterpret_cast<PyCFunction>(Sbk_BookmarkItemFunc_title), METH_NOARGS},
    {"type", reinterpret_cast<PyCFunction>(Sbk_BookmarkItemFunc_type), METH_NOARGS},
    {"typeFromString", reinterpret_cast<PyCFunction>(Sbk_BookmarkItemFunc_typeFromString), METH_O|METH_STATIC},
    {"typeToString", reinterpret_cast<PyCFunction>(Sbk_BookmarkItemFunc_typeToString), METH_O|METH_STATIC},
    {"updateVisitCount", reinterpret_cast<PyCFunction>(Sbk_BookmarkItemFunc_updateVisitCount), METH_NOARGS},
    {"url", reinterpret_cast<PyCFunction>(Sbk_BookmarkItemFunc_url), METH_NOARGS},
    {"urlString", reinterpret_cast<PyCFunction>(Sbk_BookmarkItemFunc_urlString), METH_NOARGS},
    {"visitCount", reinterpret_cast<PyCFunction>(Sbk_BookmarkItemFunc_visitCount), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_BookmarkItem_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_BookmarkItem_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_BookmarkItem_Type = nullptr;
static SbkObjectType *Sbk_BookmarkItem_TypeF(void)
{
    return _Sbk_BookmarkItem_Type;
}

static PyType_Slot Sbk_BookmarkItem_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_BookmarkItem_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_BookmarkItem_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_BookmarkItem_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_BookmarkItem_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_BookmarkItem_spec = {
    "1:PyFalkon.BookmarkItem",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_BookmarkItem_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void BookmarkItem_Type_PythonToCpp_BookmarkItem_Type(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::BookmarkItem::Type *>(cppOut) =
        static_cast<::BookmarkItem::Type>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_BookmarkItem_Type_PythonToCpp_BookmarkItem_Type_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPyFalkonTypes[SBK_BOOKMARKITEM_TYPE_IDX]))
        return BookmarkItem_Type_PythonToCpp_BookmarkItem_Type;
    return {};
}
static PyObject *BookmarkItem_Type_CppToPython_BookmarkItem_Type(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::BookmarkItem::Type *>(cppIn));
    return Shiboken::Enum::newItem(SbkPyFalkonTypes[SBK_BOOKMARKITEM_TYPE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void BookmarkItem_PythonToCpp_BookmarkItem_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_BookmarkItem_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_BookmarkItem_PythonToCpp_BookmarkItem_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_BookmarkItem_TypeF())))
        return BookmarkItem_PythonToCpp_BookmarkItem_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *BookmarkItem_PTR_CppToPython_BookmarkItem(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::BookmarkItem *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_BookmarkItem_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *BookmarkItem_SignatureStrings[] = {
    "PyFalkon.BookmarkItem(self,type:PyFalkon.BookmarkItem.Type,parent:PyFalkon.BookmarkItem=nullptr)",
    "PyFalkon.BookmarkItem.addChild(self,child:PyFalkon.BookmarkItem,index:int=-1)",
    "PyFalkon.BookmarkItem.children(self)->QList[PyFalkon.BookmarkItem]",
    "PyFalkon.BookmarkItem.description(self)->QString",
    "PyFalkon.BookmarkItem.icon(self)->PySide2.QtGui.QIcon",
    "PyFalkon.BookmarkItem.isExpanded(self)->bool",
    "PyFalkon.BookmarkItem.isFolder(self)->bool",
    "PyFalkon.BookmarkItem.isSeparator(self)->bool",
    "PyFalkon.BookmarkItem.isSidebarExpanded(self)->bool",
    "PyFalkon.BookmarkItem.isUrl(self)->bool",
    "PyFalkon.BookmarkItem.keyword(self)->QString",
    "PyFalkon.BookmarkItem.parent(self)->PyFalkon.BookmarkItem",
    "PyFalkon.BookmarkItem.removeChild(self,child:PyFalkon.BookmarkItem)",
    "PyFalkon.BookmarkItem.setDescription(self,description:QString)",
    "PyFalkon.BookmarkItem.setExpanded(self,expanded:bool)",
    "PyFalkon.BookmarkItem.setIcon(self,icon:PySide2.QtGui.QIcon)",
    "PyFalkon.BookmarkItem.setKeyword(self,keyword:QString)",
    "PyFalkon.BookmarkItem.setSidebarExpanded(self,expanded:bool)",
    "PyFalkon.BookmarkItem.setTitle(self,title:QString)",
    "PyFalkon.BookmarkItem.setType(self,type:PyFalkon.BookmarkItem.Type)",
    "PyFalkon.BookmarkItem.setUrl(self,url:PySide2.QtCore.QUrl)",
    "PyFalkon.BookmarkItem.setVisitCount(self,count:int)",
    "PyFalkon.BookmarkItem.title(self)->QString",
    "PyFalkon.BookmarkItem.type(self)->PyFalkon.BookmarkItem.Type",
    "PyFalkon.BookmarkItem.typeFromString(string:QString)->PyFalkon.BookmarkItem.Type",
    "PyFalkon.BookmarkItem.typeToString(type:PyFalkon.BookmarkItem.Type)->QString",
    "PyFalkon.BookmarkItem.updateVisitCount(self)",
    "PyFalkon.BookmarkItem.url(self)->PySide2.QtCore.QUrl",
    "PyFalkon.BookmarkItem.urlString(self)->QString",
    "PyFalkon.BookmarkItem.visitCount(self)->int",
    nullptr}; // Sentinel

void init_BookmarkItem(PyObject *module)
{
    _Sbk_BookmarkItem_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "BookmarkItem",
        "BookmarkItem*",
        &Sbk_BookmarkItem_spec,
        &Shiboken::callCppDestructor< ::BookmarkItem >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_BookmarkItem_Type);
    InitSignatureStrings(pyType, BookmarkItem_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_BookmarkItem_Type), Sbk_BookmarkItem_PropertyStrings);
    SbkPyFalkonTypes[SBK_BOOKMARKITEM_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_BookmarkItem_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_BookmarkItem_TypeF(),
        BookmarkItem_PythonToCpp_BookmarkItem_PTR,
        is_BookmarkItem_PythonToCpp_BookmarkItem_PTR_Convertible,
        BookmarkItem_PTR_CppToPython_BookmarkItem);

    Shiboken::Conversions::registerConverterName(converter, "BookmarkItem");
    Shiboken::Conversions::registerConverterName(converter, "BookmarkItem*");
    Shiboken::Conversions::registerConverterName(converter, "BookmarkItem&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::BookmarkItem).name());


    // Initialization of enums.

    // Initialization of enum 'Type'.
    SbkPyFalkonTypes[SBK_BOOKMARKITEM_TYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_BookmarkItem_TypeF(),
        "Type",
        "1:PyFalkon.BookmarkItem.Type",
        "BookmarkItem::Type");
    if (!SbkPyFalkonTypes[SBK_BOOKMARKITEM_TYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPyFalkonTypes[SBK_BOOKMARKITEM_TYPE_IDX],
        Sbk_BookmarkItem_TypeF(), "Root", (long) BookmarkItem::Type::Root))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPyFalkonTypes[SBK_BOOKMARKITEM_TYPE_IDX],
        Sbk_BookmarkItem_TypeF(), "Url", (long) BookmarkItem::Type::Url))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPyFalkonTypes[SBK_BOOKMARKITEM_TYPE_IDX],
        Sbk_BookmarkItem_TypeF(), "Folder", (long) BookmarkItem::Type::Folder))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPyFalkonTypes[SBK_BOOKMARKITEM_TYPE_IDX],
        Sbk_BookmarkItem_TypeF(), "Separator", (long) BookmarkItem::Type::Separator))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPyFalkonTypes[SBK_BOOKMARKITEM_TYPE_IDX],
        Sbk_BookmarkItem_TypeF(), "Invalid", (long) BookmarkItem::Type::Invalid))
        return;
    // Register converter for enum 'BookmarkItem::Type'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPyFalkonTypes[SBK_BOOKMARKITEM_TYPE_IDX],
            BookmarkItem_Type_CppToPython_BookmarkItem_Type);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            BookmarkItem_Type_PythonToCpp_BookmarkItem_Type,
            is_BookmarkItem_Type_PythonToCpp_BookmarkItem_Type_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPyFalkonTypes[SBK_BOOKMARKITEM_TYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "BookmarkItem::Type");
        Shiboken::Conversions::registerConverterName(converter, "Type");
    }
    // End of 'Type' enum.

    qRegisterMetaType< ::BookmarkItem::Type >("BookmarkItem::Type");
}
