
// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyfalkon_python.h"

// main header
#include "passwordmanager_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void PasswordManagerWrapper::pysideInitQtMetaTypes()
{
}

void PasswordManagerWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

PasswordManagerWrapper::PasswordManagerWrapper(QObject * parent) : PasswordManager(parent)
{
    resetPyMethodCache();
    // ... middle
}

void PasswordManagerWrapper::childEvent(QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void PasswordManagerWrapper::connectNotify(const QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void PasswordManagerWrapper::customEvent(QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void PasswordManagerWrapper::disconnectNotify(const QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool PasswordManagerWrapper::event(QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "PasswordManager.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool PasswordManagerWrapper::eventFilter(QObject * watched, QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "PasswordManager.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void PasswordManagerWrapper::timerEvent(QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *PasswordManagerWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return PasswordManager::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int PasswordManagerWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = PasswordManager::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *PasswordManagerWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< PasswordManagerWrapper *>(this));
        return PasswordManager::qt_metacast(_clname);
}

PasswordManagerWrapper::~PasswordManagerWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_PasswordManager_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::PasswordManager >()))
        return -1;

    ::PasswordManagerWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.PasswordManager.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|O:PasswordManager", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: PasswordManager::PasswordManager(QObject*)
    if (numArgs == 0) {
        overloadId = 0; // PasswordManager(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // PasswordManager(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_PasswordManager_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            PyObject *kwds_dup = PyDict_Copy(kwds);
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[0]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_PasswordManager_Init_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0]))))
                        goto Sbk_PasswordManager_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup;
                // fall through to handle extra keyword signals and properties
            } else {
                Py_DECREF(kwds_dup);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // PasswordManager(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::PasswordManagerWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::PasswordManagerWrapper(cppArg0);
            }

            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::PasswordManager >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_PasswordManager_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_PasswordManager_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_PasswordManager_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_PasswordManagerFunc_activeBackend(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<PasswordManagerWrapper *>(reinterpret_cast< ::PasswordManager *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PASSWORDMANAGER_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.PasswordManager.activeBackend";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // activeBackend()
            PasswordBackend * cppResult = cppSelf->activeBackend();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_PASSWORDBACKEND_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_PasswordManagerFunc_addEntry(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<PasswordManagerWrapper *>(reinterpret_cast< ::PasswordManager *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PASSWORDMANAGER_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.PasswordManager.addEntry";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: PasswordManager::addEntry(PasswordEntry)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_PASSWORDENTRY_IDX]), (pyArg)))) {
        overloadId = 0; // addEntry(PasswordEntry)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_PasswordManagerFunc_addEntry_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::PasswordEntry cppArg0_local;
        ::PasswordEntry *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_PASSWORDENTRY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // addEntry(PasswordEntry)
            cppSelf->addEntry(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_PasswordManagerFunc_addEntry_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_PasswordManagerFunc_availableBackends(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<PasswordManagerWrapper *>(reinterpret_cast< ::PasswordManager *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PASSWORDMANAGER_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.PasswordManager.availableBackends";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // availableBackends()
            QHash<QString,PasswordBackend* > cppResult = cppSelf->availableBackends();
            pyResult = Shiboken::Conversions::copyToPython(SbkPyFalkonTypeConverters[SBK_PYFALKON_QHASH_QSTRING_PASSWORDBACKENDPTR_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_PasswordManagerFunc_createHost(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.PasswordManager.createHost";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static PasswordManager::createHost(QUrl)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArg)))) {
        overloadId = 0; // createHost(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_PasswordManagerFunc_createHost_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // createHost(QUrl)
            QString cppResult = ::PasswordManager::createHost(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_PasswordManagerFunc_createHost_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_PasswordManagerFunc_getAllEntries(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<PasswordManagerWrapper *>(reinterpret_cast< ::PasswordManager *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PASSWORDMANAGER_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.PasswordManager.getAllEntries";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // getAllEntries()
            QVector<PasswordEntry > cppResult = cppSelf->getAllEntries();
            pyResult = Shiboken::Conversions::copyToPython(SbkPyFalkonTypeConverters[SBK_PYFALKON_QVECTOR_PASSWORDENTRY_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_PasswordManagerFunc_getEntries(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<PasswordManagerWrapper *>(reinterpret_cast< ::PasswordManager *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PASSWORDMANAGER_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.PasswordManager.getEntries";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: PasswordManager::getEntries(QUrl)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArg)))) {
        overloadId = 0; // getEntries(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_PasswordManagerFunc_getEntries_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // getEntries(QUrl)
            QVector<PasswordEntry > cppResult = cppSelf->getEntries(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPyFalkonTypeConverters[SBK_PYFALKON_QVECTOR_PASSWORDENTRY_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_PasswordManagerFunc_getEntries_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_PasswordManagerFunc_getUsernames(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<PasswordManagerWrapper *>(reinterpret_cast< ::PasswordManager *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PASSWORDMANAGER_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.PasswordManager.getUsernames";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: PasswordManager::getUsernames(QUrl)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArg)))) {
        overloadId = 0; // getUsernames(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_PasswordManagerFunc_getUsernames_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // getUsernames(QUrl)
            QStringList cppResult = cppSelf->getUsernames(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_PasswordManagerFunc_getUsernames_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_PasswordManagerFunc_loadSettings(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<PasswordManagerWrapper *>(reinterpret_cast< ::PasswordManager *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PASSWORDMANAGER_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.PasswordManager.loadSettings";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // loadSettings()
            cppSelf->loadSettings();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_PasswordManagerFunc_registerBackend(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<PasswordManagerWrapper *>(reinterpret_cast< ::PasswordManager *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PASSWORDMANAGER_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.PasswordManager.registerBackend";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "registerBackend", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: PasswordManager::registerBackend(QString,PasswordBackend*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_PASSWORDBACKEND_IDX]), (pyArgs[1])))) {
        overloadId = 0; // registerBackend(QString,PasswordBackend*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_PasswordManagerFunc_registerBackend_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::PasswordBackend *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // registerBackend(QString,PasswordBackend*)
            bool cppResult = cppSelf->registerBackend(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_PasswordManagerFunc_registerBackend_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_PasswordManagerFunc_removeAllEntries(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<PasswordManagerWrapper *>(reinterpret_cast< ::PasswordManager *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PASSWORDMANAGER_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.PasswordManager.removeAllEntries";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // removeAllEntries()
            cppSelf->removeAllEntries();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_PasswordManagerFunc_removeEntry(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<PasswordManagerWrapper *>(reinterpret_cast< ::PasswordManager *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PASSWORDMANAGER_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.PasswordManager.removeEntry";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: PasswordManager::removeEntry(PasswordEntry)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_PASSWORDENTRY_IDX]), (pyArg)))) {
        overloadId = 0; // removeEntry(PasswordEntry)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_PasswordManagerFunc_removeEntry_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::PasswordEntry cppArg0_local;
        ::PasswordEntry *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_PASSWORDENTRY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // removeEntry(PasswordEntry)
            cppSelf->removeEntry(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_PasswordManagerFunc_removeEntry_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_PasswordManagerFunc_switchBackend(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<PasswordManagerWrapper *>(reinterpret_cast< ::PasswordManager *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PASSWORDMANAGER_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.PasswordManager.switchBackend";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: PasswordManager::switchBackend(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // switchBackend(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_PasswordManagerFunc_switchBackend_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // switchBackend(QString)
            cppSelf->switchBackend(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_PasswordManagerFunc_switchBackend_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_PasswordManagerFunc_unregisterBackend(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<PasswordManagerWrapper *>(reinterpret_cast< ::PasswordManager *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PASSWORDMANAGER_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.PasswordManager.unregisterBackend";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: PasswordManager::unregisterBackend(PasswordBackend*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_PASSWORDBACKEND_IDX]), (pyArg)))) {
        overloadId = 0; // unregisterBackend(PasswordBackend*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_PasswordManagerFunc_unregisterBackend_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::PasswordBackend *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // unregisterBackend(PasswordBackend*)
            cppSelf->unregisterBackend(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_PasswordManagerFunc_unregisterBackend_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_PasswordManagerFunc_updateEntry(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<PasswordManagerWrapper *>(reinterpret_cast< ::PasswordManager *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PASSWORDMANAGER_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.PasswordManager.updateEntry";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: PasswordManager::updateEntry(PasswordEntry)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_PASSWORDENTRY_IDX]), (pyArg)))) {
        overloadId = 0; // updateEntry(PasswordEntry)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_PasswordManagerFunc_updateEntry_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::PasswordEntry cppArg0_local;
        ::PasswordEntry *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_PASSWORDENTRY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // updateEntry(PasswordEntry)
            bool cppResult = cppSelf->updateEntry(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_PasswordManagerFunc_updateEntry_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_PasswordManagerFunc_updateLastUsed(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<PasswordManagerWrapper *>(reinterpret_cast< ::PasswordManager *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PASSWORDMANAGER_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.PasswordManager.updateLastUsed";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: PasswordManager::updateLastUsed(PasswordEntry&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_PASSWORDENTRY_IDX]), (pyArg)))) {
        overloadId = 0; // updateLastUsed(PasswordEntry&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_PasswordManagerFunc_updateLastUsed_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::PasswordEntry cppArg0_local;
        ::PasswordEntry *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_PASSWORDENTRY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // updateLastUsed(PasswordEntry&)
            cppSelf->updateLastUsed(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_PasswordManagerFunc_updateLastUsed_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_PasswordManagerFunc_urlEncodePassword(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.PasswordManager.urlEncodePassword";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static PasswordManager::urlEncodePassword(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // urlEncodePassword(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_PasswordManagerFunc_urlEncodePassword_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // urlEncodePassword(QString)
            QByteArray cppResult = ::PasswordManager::urlEncodePassword(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_PasswordManagerFunc_urlEncodePassword_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_PasswordManager_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_PasswordManager_methods[] = {
    {"activeBackend", reinterpret_cast<PyCFunction>(Sbk_PasswordManagerFunc_activeBackend), METH_NOARGS},
    {"addEntry", reinterpret_cast<PyCFunction>(Sbk_PasswordManagerFunc_addEntry), METH_O},
    {"availableBackends", reinterpret_cast<PyCFunction>(Sbk_PasswordManagerFunc_availableBackends), METH_NOARGS},
    {"createHost", reinterpret_cast<PyCFunction>(Sbk_PasswordManagerFunc_createHost), METH_O|METH_STATIC},
    {"getAllEntries", reinterpret_cast<PyCFunction>(Sbk_PasswordManagerFunc_getAllEntries), METH_NOARGS},
    {"getEntries", reinterpret_cast<PyCFunction>(Sbk_PasswordManagerFunc_getEntries), METH_O},
    {"getUsernames", reinterpret_cast<PyCFunction>(Sbk_PasswordManagerFunc_getUsernames), METH_O},
    {"loadSettings", reinterpret_cast<PyCFunction>(Sbk_PasswordManagerFunc_loadSettings), METH_NOARGS},
    {"registerBackend", reinterpret_cast<PyCFunction>(Sbk_PasswordManagerFunc_registerBackend), METH_VARARGS},
    {"removeAllEntries", reinterpret_cast<PyCFunction>(Sbk_PasswordManagerFunc_removeAllEntries), METH_NOARGS},
    {"removeEntry", reinterpret_cast<PyCFunction>(Sbk_PasswordManagerFunc_removeEntry), METH_O},
    {"switchBackend", reinterpret_cast<PyCFunction>(Sbk_PasswordManagerFunc_switchBackend), METH_O},
    {"unregisterBackend", reinterpret_cast<PyCFunction>(Sbk_PasswordManagerFunc_unregisterBackend), METH_O},
    {"updateEntry", reinterpret_cast<PyCFunction>(Sbk_PasswordManagerFunc_updateEntry), METH_O},
    {"updateLastUsed", reinterpret_cast<PyCFunction>(Sbk_PasswordManagerFunc_updateLastUsed), METH_O},
    {"urlEncodePassword", reinterpret_cast<PyCFunction>(Sbk_PasswordManagerFunc_urlEncodePassword), METH_O|METH_STATIC},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_PasswordManager_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::PasswordManager *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PASSWORDMANAGER_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<PasswordManagerWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_PasswordManager_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_PasswordManager_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_PasswordManager_Type = nullptr;
static SbkObjectType *Sbk_PasswordManager_TypeF(void)
{
    return _Sbk_PasswordManager_Type;
}

static PyType_Slot Sbk_PasswordManager_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_PasswordManager_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_PasswordManager_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_PasswordManager_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_PasswordManager_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_PasswordManager_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_PasswordManager_spec = {
    "1:PyFalkon.PasswordManager",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_PasswordManager_slots
};

} //extern "C"

static void *Sbk_PasswordManager_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::PasswordManager *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void PasswordManager_PythonToCpp_PasswordManager_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_PasswordManager_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_PasswordManager_PythonToCpp_PasswordManager_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_PasswordManager_TypeF())))
        return PasswordManager_PythonToCpp_PasswordManager_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *PasswordManager_PTR_CppToPython_PasswordManager(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::PasswordManager *>(const_cast<void *>(cppIn)), Sbk_PasswordManager_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *PasswordManager_SignatureStrings[] = {
    "PyFalkon.PasswordManager(self,parent:PySide2.QtCore.QObject=nullptr)",
    "PyFalkon.PasswordManager.activeBackend(self)->PyFalkon.PasswordBackend",
    "PyFalkon.PasswordManager.addEntry(self,entry:PyFalkon.PasswordEntry)",
    "PyFalkon.PasswordManager.availableBackends(self)->QHash[QString, PyFalkon.PasswordBackend]",
    "PyFalkon.PasswordManager.createHost(url:PySide2.QtCore.QUrl)->QString",
    "PyFalkon.PasswordManager.getAllEntries(self)->QVector[PyFalkon.PasswordEntry]",
    "PyFalkon.PasswordManager.getEntries(self,url:PySide2.QtCore.QUrl)->QVector[PyFalkon.PasswordEntry]",
    "PyFalkon.PasswordManager.getUsernames(self,url:PySide2.QtCore.QUrl)->QStringList",
    "PyFalkon.PasswordManager.loadSettings(self)",
    "PyFalkon.PasswordManager.registerBackend(self,id:QString,backend:PyFalkon.PasswordBackend)->bool",
    "PyFalkon.PasswordManager.removeAllEntries(self)",
    "PyFalkon.PasswordManager.removeEntry(self,entry:PyFalkon.PasswordEntry)",
    "PyFalkon.PasswordManager.switchBackend(self,backendID:QString)",
    "PyFalkon.PasswordManager.unregisterBackend(self,backend:PyFalkon.PasswordBackend)",
    "PyFalkon.PasswordManager.updateEntry(self,entry:PyFalkon.PasswordEntry)->bool",
    "PyFalkon.PasswordManager.updateLastUsed(self,entry:PyFalkon.PasswordEntry)",
    "PyFalkon.PasswordManager.urlEncodePassword(password:QString)->PySide2.QtCore.QByteArray",
    nullptr}; // Sentinel

void init_PasswordManager(PyObject *module)
{
    _Sbk_PasswordManager_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "PasswordManager",
        "PasswordManager*",
        &Sbk_PasswordManager_spec,
        &Shiboken::callCppDestructor< ::PasswordManager >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_PasswordManager_Type);
    InitSignatureStrings(pyType, PasswordManager_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_PasswordManager_Type), Sbk_PasswordManager_PropertyStrings);
    SbkPyFalkonTypes[SBK_PASSWORDMANAGER_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_PasswordManager_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_PasswordManager_TypeF(),
        PasswordManager_PythonToCpp_PasswordManager_PTR,
        is_PasswordManager_PythonToCpp_PasswordManager_PTR_Convertible,
        PasswordManager_PTR_CppToPython_PasswordManager);

    Shiboken::Conversions::registerConverterName(converter, "PasswordManager");
    Shiboken::Conversions::registerConverterName(converter, "PasswordManager*");
    Shiboken::Conversions::registerConverterName(converter, "PasswordManager&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::PasswordManager).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::PasswordManagerWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_PasswordManager_TypeF(), &Sbk_PasswordManager_typeDiscovery);

    PySide::Signal::registerSignals(Sbk_PasswordManager_TypeF(), &::PasswordManager::staticMetaObject);
    PasswordManagerWrapper::pysideInitQtMetaTypes();
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_PasswordManager_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_PasswordManager_TypeF(), &::PasswordManager::staticMetaObject, sizeof(PasswordManagerWrapper));
}
