/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.directive;

import java.io.IOException;
import java.io.Writer;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MacroOverflowException;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.Renderable;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.directive.Macro;
import org.apache.velocity.runtime.parser.node.ASTReference;
import org.apache.velocity.runtime.parser.node.ASTStringLiteral;
import org.apache.velocity.runtime.parser.node.Node;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import org.apache.velocity.util.StringUtils;

public class VelocimacroProxy
extends Directive {
    private String macroName;
    private List<Macro.MacroArg> macroArgs = null;
    private String[] literalArgArray = null;
    private SimpleNode nodeTree = null;
    private int numMacroArgs = 0;
    private boolean strictArguments;
    private int maxCallDepth;
    private String bodyReference;
    private boolean enableBCmode;
    private static final Object NULL_VALUE_MARKER = new Object();

    @Override
    public String getName() {
        return this.macroName;
    }

    @Override
    public int getType() {
        return 2;
    }

    public void setName(String name) {
        this.macroName = name;
    }

    public void setMacroArgs(List<Macro.MacroArg> args2) {
        this.macroArgs = args2;
        if (this.enableBCmode) {
            this.literalArgArray = new String[this.macroArgs.size()];
            for (int i = 0; i < this.macroArgs.size(); ++i) {
                this.literalArgArray[i] = ".literal.$" + this.macroArgs.get((int)i).name;
            }
        }
        this.numMacroArgs = this.macroArgs.size() - 1;
    }

    public List<Macro.MacroArg> getMacroArgs() {
        return this.macroArgs;
    }

    public void setNodeTree(SimpleNode tree) {
        this.nodeTree = tree;
    }

    public int getNumArgs() {
        return this.numMacroArgs;
    }

    public void init(RuntimeServices rs) {
        this.rsvc = rs;
        this.log = rs.getLog("macro");
        this.strictArguments = this.rsvc.getBoolean("velocimacro.arguments.strict", false);
        this.maxCallDepth = this.rsvc.getInt("velocimacro.max_depth");
        this.bodyReference = this.rsvc.getString("velocimacro.body_reference", "bodyContent");
        this.enableBCmode = this.rsvc.getBoolean("velocimacro.enable_bc_mode", false);
    }

    @Override
    public boolean render(InternalContextAdapter context, Writer writer, Node node) throws IOException {
        return this.render(context, writer, node, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean render(InternalContextAdapter context, Writer writer, Node node, Renderable body) throws IOException {
        boolean bl;
        int callArgNum = node.jjtGetNumChildren();
        Object oldBodyRef = null;
        if (body != null) {
            oldBodyRef = context.get(this.bodyReference);
            context.put(this.bodyReference, body);
            --callArgNum;
        }
        this.checkArgumentCount(node, callArgNum);
        this.checkDepth(context);
        Object[] values2 = this.handleArgValues(context, node, callArgNum);
        try {
            context.pushCurrentMacroName(this.macroName);
            this.nodeTree.render(context, writer);
            context.popCurrentMacroName();
            bl = true;
        }
        catch (RuntimeException e) {
            try {
                throw e;
                catch (Exception e2) {
                    String msg = "VelocimacroProxy.render() : exception VM = #" + this.macroName + "()";
                    this.log.error(msg, e2);
                    throw new VelocityException(msg, e2, this.rsvc.getLogContext().getStackTrace());
                }
            }
            catch (Throwable throwable) {
                Object current = context.get(this.bodyReference);
                if (current == body) {
                    if (oldBodyRef != null) {
                        context.put(this.bodyReference, oldBodyRef);
                    } else {
                        context.remove(this.bodyReference);
                    }
                }
                int i = 1;
                while (true) {
                    Deque literalsStack;
                    if (i >= this.macroArgs.size()) {
                        throw throwable;
                    }
                    Macro.MacroArg macroArg = this.macroArgs.get(i);
                    current = context.get(macroArg.name);
                    Object given = values2[(i - 1) * 2 + 1];
                    Object old = values2[(i - 1) * 2];
                    if (current == given || current == null && given == NULL_VALUE_MARKER) {
                        if (old == null) {
                            context.remove(macroArg.name);
                        } else if (old == NULL_VALUE_MARKER) {
                            context.put(macroArg.name, null);
                        } else {
                            context.put(macroArg.name, old);
                        }
                    }
                    if (this.enableBCmode && (literalsStack = (Deque)context.get(this.literalArgArray[i])) != null) {
                        literalsStack.removeFirst();
                        if (literalsStack.size() == 0) {
                            context.remove(this.literalArgArray[i]);
                        }
                    }
                    ++i;
                }
            }
        }
        Object current = context.get(this.bodyReference);
        if (current == body) {
            if (oldBodyRef != null) {
                context.put(this.bodyReference, oldBodyRef);
            } else {
                context.remove(this.bodyReference);
            }
        }
        int i = 1;
        while (i < this.macroArgs.size()) {
            Deque literalsStack;
            Macro.MacroArg macroArg = this.macroArgs.get(i);
            current = context.get(macroArg.name);
            Object given = values2[(i - 1) * 2 + 1];
            Object old = values2[(i - 1) * 2];
            if (current == given || current == null && given == NULL_VALUE_MARKER) {
                if (old == null) {
                    context.remove(macroArg.name);
                } else if (old == NULL_VALUE_MARKER) {
                    context.put(macroArg.name, null);
                } else {
                    context.put(macroArg.name, old);
                }
            }
            if (this.enableBCmode && (literalsStack = (Deque)context.get(this.literalArgArray[i])) != null) {
                literalsStack.removeFirst();
                if (literalsStack.size() == 0) {
                    context.remove(this.literalArgArray[i]);
                }
            }
            ++i;
        }
        return bl;
    }

    protected void checkArgumentCount(Node node, int callArgNum) {
        if (callArgNum > this.macroArgs.size() - 1) {
            if (this.strictArguments) {
                throw new VelocityException("Provided " + callArgNum + " arguments but macro #" + this.macroArgs.get((int)0).name + " accepts at most " + (this.macroArgs.size() - 1) + " at " + StringUtils.formatFileString(node), null, this.rsvc.getLogContext().getStackTrace());
            }
            this.log.debug("VM #{}: too many arguments to macro. Wanted {} got {}", this.macroArgs.get((int)0).name, this.macroArgs.size() - 1, callArgNum);
        }
    }

    protected void checkDepth(InternalContextAdapter context) {
        if (this.maxCallDepth > 0 && this.maxCallDepth == context.getCurrentMacroCallDepth()) {
            String[] stack = context.getMacroNameStack();
            StringBuilder out = new StringBuilder(100).append("Max calling depth of ").append(this.maxCallDepth).append(" was exceeded in macro '").append(this.macroName).append("' with Call Stack:");
            for (int i = 0; i < stack.length; ++i) {
                if (i != 0) {
                    out.append("->");
                }
                out.append(stack[i]);
            }
            out.append(" at ").append(StringUtils.formatFileString(this));
            this.log.error(out.toString());
            while (context.getCurrentMacroCallDepth() > 0) {
                context.popCurrentMacroName();
            }
            throw new MacroOverflowException(out.toString(), null, this.rsvc.getLogContext().getStackTrace());
        }
    }

    protected Object[] handleArgValues(InternalContextAdapter context, Node node, int callArgNum) {
        Macro.MacroArg macroArg;
        int i;
        Object[] values2 = new Object[this.macroArgs.size() * 2];
        boolean warnedMissingArguments = false;
        for (i = 1; i < this.macroArgs.size(); ++i) {
            macroArg = this.macroArgs.get(i);
            Object oldVal = context.get(macroArg.name);
            values2[(i - 1) * 2] = oldVal == null ? (context.containsKey(macroArg.name) ? NULL_VALUE_MARKER : null) : oldVal;
            Object newVal = null;
            Node argNode = null;
            if (i - 1 < callArgNum) {
                argNode = node.jjtGetChild(i - 1);
                newVal = argNode.value(context);
            } else if (macroArg.defaultVal != null) {
                newVal = macroArg.defaultVal.value(context);
            } else {
                if (this.strictArguments) {
                    int minArgNum = -1;
                    for (Macro.MacroArg marg : this.macroArgs) {
                        if (marg.defaultVal != null) continue;
                        ++minArgNum;
                    }
                    throw new VelocityException("Need at least " + minArgNum + " argument for macro #" + this.macroArgs.get((int)0).name + " but only " + callArgNum + " where provided at " + StringUtils.formatFileString(node), null, this.rsvc.getLogContext().getStackTrace());
                }
                if (!warnedMissingArguments) {
                    this.log.debug("VM #{}: too few arguments to macro. Wanted {} got {}", this.macroArgs.get((int)0).name, this.macroArgs.size() - 1, callArgNum);
                    warnedMissingArguments = true;
                }
                if (this.enableBCmode) {
                    newVal = oldVal;
                }
            }
            values2[(i - 1) * 2 + 1] = newVal;
            if (!this.enableBCmode || argNode == null) continue;
            LinkedList<String> literalsStack = (LinkedList<String>)context.get(this.literalArgArray[i]);
            if (literalsStack == null) {
                literalsStack = new LinkedList<String>();
                context.put(this.literalArgArray[i], literalsStack);
            }
            if (argNode != null && (argNode instanceof ASTReference || argNode instanceof ASTStringLiteral)) {
                literalsStack.addFirst(argNode.literal());
                continue;
            }
            literalsStack.addFirst('$' + macroArg.name);
        }
        for (i = 1; i < this.macroArgs.size(); ++i) {
            macroArg = this.macroArgs.get(i);
            Object value = values2[(i - 1) * 2 + 1];
            context.put(macroArg.name, value);
        }
        return values2;
    }
}

