
#***************************************************************************
#*                                                                         *
#*   (c) Yorik van Havre (yorik@uncreated.net 2015                         *
#*                                                                         *
#*   This file is part of the FreeCAD CAx development system.              *
#*                                                                         *
#*   This program is free software; you can redistribute it and/or modify  *
#*   it under the terms of the GNU Lesser General Public License (LGPL)    *
#*   as published by the Free Software Foundation; either version 2 of     *
#*   the License, or (at your option) any later version.                   *
#*   for detail see the LICENCE text file.                                 *
#*                                                                         *
#*   FreeCAD is distributed in the hope that it will be useful,            *
#*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
#*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
#*   GNU Lesser General Public License for more details.                   *
#*                                                                         *
#*   You should have received a copy of the GNU Library General Public     *
#*   License along with FreeCAD; if not, write to the Free Software        *
#*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  *
#*   USA                                                                   *
#*                                                                         *
#***************************************************************************/

"""An SVG patterns generator, able to generate different variants of a pattern
definition, by modifying scale, line thickness and color. The module can generate
<pattern>  entities to be embedded inside SVG files, and complete SVG images to
be used as image textures."""

# list of available patterns
    
Patterns = {
    "simple":        "M0,0 L10,10",
    "line":          "M0,5 L10,5",
    "vertical":      "M5,0 L5,10",
    "square":        "M5,0 L5,10 M0,5 L10,5",
    "cross":         "M0,0 L10,10 M0,10 L10,0",
    "satellite":     "M5,3 L5,7 M3,5 L7,5",
    "double":        "M0,0 L10,10 M3,0 L10,7 M0,7 L3,10",
    "dashed":        "M1,1 L4,4 M6,6 L9,9",
    "concrete":      "m 3.0195888,9.7208875 0.011544,0 0,0.01154 -0.011544,0 0,-0.01154 m 0,0 0.011544,0 0,0.01154 -0.011544,0 0,-0.01154 M 2.197994,8.9680359 l 0.011544,0 0,0.01154 -0.011544,0 0,-0.01154 m -1.95678361,-1.793061 0.0115436,0 0,0.01154 -0.0115436,0 0,-0.01154 m 0,0 0.0115436,0 0,0.01154 -0.0115436,0 0,-0.01154 m 0,0 0.0115436,0 0,0.01154 -0.0115436,0 0,-0.01154 m 7.98595231,2.5459126 0.011544,0 0,0.01154 -0.011544,0 0,-0.01154 m 0,0 0.011544,0 0,0.01154 -0.011544,0 0,-0.01154 m -1.6431895,-1.5057156 0.011544,0 0,0.01154 -0.011544,0 0,-0.01154 m -4.0754671,-3.73448 0.011544,0 0,0.01154 -0.011544,0 0,-0.01154 m -2.26729571,-2.077588 0.0115436,0 0,0.01154 -0.0115436,0 0,-0.01154 m 0,0 0.0115436,0 0,0.01154 -0.0115436,0 0,-0.01154 m 6.65326331,1.324736 0.011544,0 0,0.01154 -0.011544,0 0,-0.01154 m -2.8722283,-2.631917 0.011544,0 0,0.01154 -0.011544,0 0,-0.01154 m -0.9275653,-0.84995403 0.011544,0 0,0.01154 -0.011544,0 0,-0.01154 m 6.6214955,1.29557603 0.011544,0 0,0.01154 -0.011544,0 0,-0.01154 m -1.3080087,-1.19847803 0.011544,0 0,0.01154 -0.011544,0 0,-0.01154 m -0.1059706,-0.0971 0.011544,0 0,0.01154 -0.011544,0 0,-0.01154 m -8.06098591,8.15533203 0.0115436,0 0,0.01154 -0.0115436,0 0,-0.01154 m 0,0 0.0115436,0 0,0.01154 -0.0115436,0 0,-0.01154 m 0,0 0.0115436,0 0,0.01154 -0.0115436,0 0,-0.01154 m 0,-2.388042 0.0115436,0 0,0.01154 -0.0115436,0 0,-0.01154 m 0,0 0.0115436,0 0,0.01154 -0.0115436,0 0,-0.01154 m 0,0 0.0115436,0 0,0.01154 -0.0115436,0 0,-0.01154 m 3.80212531,0.03419 0.011544,0 0,0.01154 -0.011544,0 0,-0.01154 m -3.80212531,-2.422223 0.0115436,0 0,0.01154 -0.0115436,0 0,-0.01154 m 0,0 0.0115436,0 0,0.01154 -0.0115436,0 0,-0.01154 m 7.81683821,2.591845 0.011544,0 0,0.01154 -0.011544,0 0,-0.01154 m -4.9474613,-3.151884 0.011544,0 0,0.01154 -0.011544,0 0,-0.01154 m -1.5857254,-1.010218 0.011544,0 0,0.01154 -0.011544,0 0,-0.01154 m -1.28365151,-0.817778 0.0115436,0 0,0.01154 -0.0115436,0 0,-0.01154 m 0,0 0.0115436,0 0,0.01154 -0.0115436,0 0,-0.01154 m 0,0 0.0115436,0 0,0.01154 -0.0115436,0 0,-0.01154 m 9.47496521,3.64815 0.011544,0 0,0.01154 -0.011544,0 0,-0.01154 m -2.5908524,-1.650532 0.011544,0 0,0.01154 -0.011544,0 0,-0.01154 m -1.5857484,-1.010217 0.011544,0 0,0.01154 -0.011544,0 0,-0.01154 m -3.1058137,-1.97862503 0.011544,0 0,0.01154 -0.011544,0 0,-0.01154 m 0,0 0.011544,0 0,0.01154 -0.011544,0 0,-0.01154 m 0,0 0.011544,0 0,0.01154 -0.011544,0 0,-0.01154 m 6.3663898,2.29151953 0.011544,0 0,0.01154 -0.011544,0 0,-0.01154 m 0,0 0.011544,0 0,0.01154 -0.011544,0 0,-0.01154 m -0.1618417,-0.103096 0.011544,0 0,0.01154 -0.011544,0 0,-0.01154 m -2.4560774,-2.18842353 0.011544,0 0,0.01154 -0.011544,0 0,-0.01154 m 0,0 0.011544,0 0,0.01154 -0.011544,0 0,-0.01154 m 0,0 0.011544,0 0,0.01154 -0.011544,0 0,-0.01154 m 1.657065,8.47461803 0.011544,0 0,0.01154 -0.011544,0 0,-0.01154 m -4.7497536,0.625307 0.011544,0 0,0.01154 -0.011544,0 0,-0.01154 m -2.84833281,0.3749936 0.0115436,0 0,0.01154 -0.0115436,0 0,-0.01154 m 7.59808641,-1.0003006 0.011544,0 0,0.01154 -0.011544,0 0,-0.01154 m -4.7497536,0.625307 0.011544,0 0,0.01154 -0.011544,0 0,-0.01154 m -2.84833281,0.3749936 0.0115436,0 0,0.01154 -0.0115436,0 0,-0.01154 m 9.47496521,-3.9531846 0.011544,0 0,0.01154 -0.011544,0 0,-0.01154 m -4.6481581,0.611939 0.011544,0 0,0.01154 -0.011544,0 0,-0.01154 m -2.848333,0.374984 0.011544,0 0,0.01154 -0.011544,0 0,-0.01154 m -1.88274279,0.247876 0.0115436,0 0,0.01154 -0.0115436,0 0,-0.01154 m -0.0957313,0.01259 0.0115436,0 0,0.01154 -0.0115436,0 0,-0.01154 m 0,0 0.0115436,0 0,0.01154 -0.0115436,0 0,-0.01154 m 9.47496519,-3.953185 0.011544,0 0,0.01154 -0.011544,0 0,-0.01154 m -2.6696838,0.351469 0.011532,0 0,0.01154 -0.011532,0 0,-0.01154 m -2.848333,0.374995 0.011544,0 0,0.01154 -0.011544,0 0,-0.01154 m -1.8827429,0.247864 0.011544,0 0,0.01154 -0.011544,0 0,-0.01154 m 7.4007597,-3.68011203 0.011544,0 0,0.01154 -0.011544,0 0,-0.01154 m -0.6912326,0.09099 0.011544,0 0,0.01154 -0.011544,0 0,-0.01154 m -2.8483214,0.37499205 0.011544,0 0,0.01154 -0.011544,0 0,-0.01154 m -1.8827315,0.24786598 0.011544,0 0,0.01154 -0.011544,0 0,-0.01154 m -4.05267969,0.533545 0.0115436,0 0,0.01154 -0.0115436,0 0,-0.01154 m 0,0 0.0115436,0 0,0.01154 -0.0115436,0 0,-0.01154 m 7.70498039,7.07202 0.011544,0 0,0.01154 -0.011544,0 0,-0.01154 m -1.3623677,1.0453446 0.011544,0 0,0.01154 -0.011544,0 0,-0.01154 m 0,0 0.011544,0 0,0.01154 -0.011544,0 0,-0.01154 m 1.4537932,-3.5489386 0.011544,0 0,0.01154 -0.011544,0 0,-0.01154 m -3.9976398,3.067478 0.011544,0 0,0.01154 -0.011544,0 0,-0.01154 m -0.6274656,0.4814606 0.011544,0 0,0.01154 -0.011544,0 0,-0.01154 m 4.716531,-6.0525436 0.011544,0 0,0.01154 -0.011544,0 0,-0.01154 m -3.9976168,3.067477 0.011544,0 0,0.01154 -0.011544,0 0,-0.01154 m -3.89021469,2.9850666 0.0115436,0 0,0.01154 -0.0115436,0 0,-0.01154 m 7.97925699,-8.5561426 0.011544,0 0,0.01154 -0.011544,0 0,-0.01154 m -3.9975937,3.067482 0.011544,0 0,0.01154 -0.011544,0 0,-0.01154 m -3.89021466,2.985056 0.0115436,0 0,0.01154 -0.0115436,0 0,-0.01154 m -0.0914486,0.07017 0.0115436,0 0,0.01154 -0.0115436,0 0,-0.01154 m 0,0 0.0115436,0 0,0.01154 -0.0115436,0 0,-0.01154 m 0,0 0.0115436,0 0,0.01154 -0.0115436,0 0,-0.01154 M 6.246553,0.24595387 l 0.011544,0 0,0.01154 -0.011544,0 0,-0.01154 m -1.9322305,1.48265303 0.011544,0 0,0.01154 -0.011544,0 0,-0.01154 m -1.8674875,3.110067 0.011544,0 0,0.01154 -0.011544,0 0,-0.01154 m -0.1828973,0.140347 0.011544,0 0,0.01154 -0.011544,0 0,-0.01154 m 0,0 0.011544,0 0,0.01154 -0.011544,0 0,-0.01154 m 0,0 0.011544,0 0,0.01154 -0.011544,0 0,-0.01154 m 0.8113146,-4.73306703 0.011544,0 0,0.01154 -0.011544,0 0,-0.01154 m 0,0 0.011544,0 0,0.01154 -0.011544,0 0,-0.01154 m -2.55968441,1.96411403 0.0115436,0 0,0.01154 -0.0115436,0 0,-0.01154 m -0.27435745,0.210521 0.0115436,0 0,0.01154 -0.0115436,0 0,-0.01154 m 0,0 0.0115436,0 0,0.01154 -0.0115436,0 0,-0.01154 m 0,0 0.0115436,0 0,0.01154 -0.0115436,0 0,-0.01154 M 9.5221271,0.97157592 9.6746185,0.51710592 M 7.6922309,6.4252169 7.8447223,5.9707549 m -4.641659,-2.573513 0.1524913,-0.454473 m -1.9823991,5.908111 0.1524914,-0.454462 m -0.52659724,0.202129 0.37410584,0.252333 m 5.9449464,-2.677984 0.374129,0.252332 m -4.8632736,-3.280318 0.3740944,0.252332 m 5.9449464,-2.67799498 0.374129,0.252332 M 7.3181019,6.1728839 7.8447223,5.9707439 M 0.99904966,8.5985469 1.5256469,8.3964179 M 9.1479981,0.71922892 9.6746185,0.51708992 M 2.8289458,3.1448979 3.3555315,2.9427569 m 4.9179212,6.52461 0.6688379,0.1037426 M 4.0637517,8.0738607 4.7326243,8.1776027 M 5.3501775,3.2317032 6.3826519,3.4831684 m 0,-1.5e-5 L 6.1688561,2.4450488 M 8.9422906,9.5710865 8.8591766,8.8568479 M 4.7326128,8.1776027 4.6495332,7.4633637 M 8.2733373,9.4673559 8.8591765,8.8568479 M 5.3388139,3.2259913 6.1688559,2.4450308 M 4.0637517,8.0738607 4.6495332,7.4633527 M 5.0473429,4.5809369 4.9603962,4.1095179 m -4.3508401,5.185053 0.0796972,0.4320886 -0.4422711,0 0.36256233,-0.4320886 m 3.98824317,-4.752986 0.4495205,0.03933 M 4.5977877,4.5415729 4.9603501,4.1094839 m -0.3625624,0.432089 0.3625624,-0.432089",
    "wood":          "M 6.2129651,5.9683816 8.1300885,5.5526108 9.9360743,4.5824788 M 6.0393127,3.9311043 7.2757184,4.9843905 M 8.6996689,5.0883331 9.1720036,6.3079276 M 3.0038669,4.1736373 5.4072175,5.6704125 M 0.07372108,3.3995004 0.68341515,3.5995685 m 0,0 0.71044535,0.519949 m 0,0 0.5657546,0.7198747 m 0,0 0.1578467,0.2828733 M 0.07372108,2.2129903 0.74918461,2.4130571 m 0,0 0.81567599,0.4533082 m 0,0 0.842124,0.6665612 m 0,0 0.6183704,0.6798892 M 0.07372108,1.1331915 1.170246,1.4398152 m 0,0 1.4735077,0.7998312 m 0,0 1.2367386,1.0532273 m 0,0 0.9340615,1.0398976 M 0.49926135,0.0837655 2.0253844,0.43994569 m 0,0 1.1841232,0.59991971 m 0,0 1.4603551,1.2132516 m 0,0 1.3945847,1.7063186 M 4.3147096,0.0837655 5.354,0.78656801 m 0,0 1.052586,0.99987129 m 0,0 1.012984,1.1598961 m 0,0 0.8288308,1.3064667 m 0,0 0.4473708,0.8694634 m -1.4603541,-5.0385 1.1183543,0.9560999 m 0,0 0.986676,1.1198115 m 0,0 0.5667329,0.8932851 M 1.6562374,3.2455148 2.8592533,1.9121085 m 0,0 0.6881969,-1.11694767 M 4.1097046,3.9417114 5.5620813,2.8079473 m 0,0 1.594413,-0.8025546 M 0.08707424,8.2343956 0.696835,8.4313932 m 0,0 0.7105236,0.51197 m 0,0 0.5658161,0.7088272 m 0,0 0.1578638,0.2785327 M 0.08707424,7.0660943 0.76261147,7.2630908 m 0,0 0.81576543,0.4463514 m 0,0 0.8422166,0.6563322 m 0,0 0.6184382,0.6694553 m 0,0 0.671058,0.8954934 M 0.08707424,6.0028664 1.1837191,6.3047846 m 0,0 1.4736693,0.7875567 m 0,0 1.236874,1.037064 m 0,0 0.9341642,1.0239391 m 0,0 0.6052815,0.7773787 M 0.51266105,4.9695451 2.0389511,5.3202594 m 0,0 1.1842535,0.5907131 m 0,0 1.4605148,1.1946327 m 0,0 1.3947379,1.6801328 m 0,0 0.8420764,1.1449851 M 5.3679316,5.6615623 6.420633,6.6460892 m 0,0 1.0130953,1.1420957 m 0,0 0.828922,1.2864173 m 0,0 L 8.71007,9.9307231 M 7.2495555,4.9695451 8.3680329,5.9109725 m 0,0 0.9867843,1.1026266 m 0,0 0.5667962,0.8795761 M 1.6697641,8.0827733 2.8729119,6.7698298 m 0,0 L 3.561184,5.6700232 M 4.1235,8.7682858 5.5760364,7.6519207 m 0,0 1.5945878,-0.7902383",
    "ridgestone":    "m 4.9661745,7.7148143 -0.068997,0.1578604 0.00493,0.1825336 0.3401035,0.059203 0.1725095,0.073999 0.2070247,0.1874556 0.1774514,0.1776105 0.2513793,0.034531 L 6.1885818,8.5288051 6.2477382,8.3808043 6.2674516,8.218006 6.1392961,8.035473 6.0357845,7.9170817 5.7498931,7.9269369 5.4245725,7.8825461 5.1830519,7.8628108 4.9661716,7.7148099 m 1.2815647,1.0655875 0.1133688,0.064142 0.00493,0.098657 -0.2711069,0.054265 -0.3253219,0.098673 -0.4879712,0.019734 -0.5224865,0.049328 -0.4041728,-0.029593 -0.6259963,-0.014798 0.00493,-0.128267 0.010469,-0.2726485 0.1324628,-0.087496 0,-0.1430629 0,-0.2022675 0.088728,-0.039469 0.1971659,-0.00492 0.3006774,0.059188 0.3647466,-0.029594 0.3709737,-0.030102 0.3190921,0.3902296 0.2760356,0.034531 0.3166823,0.039628 0.13679,0.073842 M 6.7890842,8.1179039 6.966537,8.0867385 7.2486584,8.0372035 7.5674021,8.0929767 7.6421204,8.1521815 7.7604325,8.4014591 7.7292937,8.5603684 7.7106106,8.6476254 7.6109949,8.8688478 7.4272975,8.9467554 7.2840909,8.981032 6.9945528,8.9654423 6.8482231,8.8688488 6.5960528,8.7816077 6.3283054,8.5790707 6.3843557,8.4045714 6.5649139,8.2269595 6.7486112,8.1179034 l 0.040471,0 m 1.8231467,0.3439501 -0.060377,-0.060411 -0.217292,0 -0.2836579,0 -0.1086461,0.1026893 -0.09657,0.1812313 0,0.1268542 0.042248,0.1691327 0.1026087,0.1389516 0.3259204,-0.048328 0.1485485,-0.02202 0.2557684,0.088464 -0.03011,-0.096655 -0.126774,-0.1993463 0,-0.259741 0.048334,-0.1208205 M 8.3225021,7.277859 8.3587106,7.1630886 8.5035201,7.1147606 8.7207799,7.1812045 8.793199,7.3322222 8.8635589,7.4787146 8.8535745,7.6886349 8.8234664,7.8457012 8.7027135,8.020884 8.587983,8.1537707 8.5035202,8.2625087 8.268178,8.2806235 8.189721,8.2987543 8.0689988,8.099408 8.0750438,7.8215375 8.2199003,7.5617803 8.2983584,7.4047139 8.3225092,7.2778596 m -3.3944374,-0.2903494 0.1201191,0.018035 0.5225012,0.1743239 0.7747507,0 0.330311,-0.078144 0.263026,-0.06222 0.5657795,0.068222 0.4203996,0.060109 0.2282272,0.1803416 -0.1681675,0.2524501 -0.096095,0.1081988 -0.2161983,0.16229 -0.330327,0.084162 L 6.8859632,7.9733134 6.3814783,7.9132046 6.2433428,7.8050057 5.8649675,7.6487172 5.3785019,7.7148438 5.3026433,7.7251409 5.1022441,7.6186568 4.8259702,7.2700236 4.9280718,6.987501 m 1.6095465,-0.1382532 -0.06006,-0.3606524 -0.06605,-0.1322356 -0.3123094,-0.084162 -0.3603415,0 -0.4564512,-0.01202 -0.1681513,0.00601 -0.240237,0.1743092 -0.1081078,0.1202164 -0.04204,0.1021988 0.090089,0.048073 0.1201193,0.1021973 0.2222192,0.096165 0.3603414,0.072143 0.1801788,-0.036073 0.2822627,-0.018035 0.3243207,0.00603 0.132132,0.048089 0.1020853,0.018018 0,-0.150271 m 3.2547305,0.2648837 0.027738,0.083559 -0.046275,0.3713677 -0.028528,0.2285272 0.047065,0.207824 0,0.2599634 L 9.616132,8.3953534 9.4955382,8.6088916 9.3377044,8.9152625 9.198569,8.9709728 8.9667293,9.0359563 8.8369439,8.9245506 8.6703939,8.7817247 8.7534307,8.2932193 9.0038116,8.0889661 9.1152146,7.485499 8.9481881,7.318383 8.9111072,7.0584196 9.0966733,6.9191661 9.4305661,6.9377257 9.654006,6.9501584 9.7923484,7.1141308 M 0.40526143,8.6609691 0.33057619,8.62358 0.12984474,8.5161266 l 0.009337,-0.088765 0.15872193,-0.1121202 0.0764437,-0.054012 0.4276911,0.00729 0.55081863,-0.056061 0.3267614,-0.00469 0.4714593,0.00935 0.653523,-0.018687 0.3547629,0.046724 0.3501034,0.1261398 0.1213559,0.084097 -0.00465,0.158846 -0.00934,0.3083537 -0.056019,0.23826 -0.074685,0.1027851 -0.1680558,0.018687 -0.1867071,0.014025 -0.2660844,0 L 2.5011801,9.235631 2.4264951,9.1982412 2.3051245,9.2449655 2.1464172,9.2636534 2.0390563,9.2823403 1.9130101,9.2916927 1.7092673,9.3067909 1.5815848,9.3524197 1.3388439,9.3430773 1.0587676,9.3337249 0.78336571,9.3477485 0.60131659,9.2870205 0.44259467,9.1889038 0.42859686,8.9179229 0.43793336,8.759077 0.40525619,8.6609762 M 2.8943326,7.954581 2.9000955,7.66569 3.0501806,7.3537007 l 0,-0.2542154 0.051963,-0.2542153 0.092355,-0.3119909 0.075052,-0.069332 0.1453314,-0.1342684 0.2702983,0.00132 0.2366891,-0.040453 0.2346436,-0.040088 0.3022155,0.2480871 0.126996,0.2542154 0.1501012,0.3466636 0.028857,0.4968727 0,0.2831118 -0.069267,0.231114 -0.2828655,0.063555 -0.508002,-0.040453 -0.1096767,-0.023101 -0.4964479,-0.069332 -0.2251364,0 -0.1789585,-0.08667 m -1.5932711,0.00578 0.00576,-0.5373257 0,-0.323549 0.086604,-0.1502238 0.3348102,-0.034658 0.1385502,-0.057775 0.3405799,-0.017338 0.5195531,0.011564 0.1039084,0.086654 0,0.1328868 -0.04041,0.306228 L 2.7326848,7.682978 2.536407,7.9487514 2.1554173,8.0007478 1.87832,8.0065284 1.4915461,7.9603116 l -0.190495,0 m 6.3354547,-1.9035338 -0.1691953,0.2257798 0.092291,0.3438235 0,0.210396 0.1384384,0.1539552 0.4511903,0.051313 0.3588828,-0.061586 0.071786,-0.09237 0.00508,-0.251437 L 8.538861,6.4672975 8.5441,6.087561 8.2569089,6.113219 l -0.086461,0.00773 -0.067348,-0.053917 -0.1640784,0 -0.2204608,0 -0.08204,-0.010253 m -0.9761858,-0.144431 0.020299,0.3150388 0,0.2997818 0.025387,0.3099417 0.3147649,0.055886 0.294449,-0.00508 L 7.4116882,6.735482 7.3964441,6.5220852 7.3558446,6.0800183 7.2441565,5.9326687 7.0055516,5.9072662 6.6603284,5.9123484 m -2.4114433,-0.1168665 -0.030473,0.2083322 0.050772,0.1829136 0.3959814,0.025403 0.3096775,-0.025403 0.6955178,-0.050804 0.6041278,-0.015242 0.2386063,-0.071143 0,-0.1219473 -0.1167595,-0.071128 -0.258906,0 -0.3959961,-0.00508 -0.2436761,-0.030484 -0.5025984,0 -0.3299933,0 -0.4162812,-0.025419 M 2.5490272,6.2415908 2.3849811,6.2352829 2.1515416,6.3300019 2.1199907,6.5131218 2.1578496,6.7151992 2.5048623,6.772037 2.9023493,6.7467766 3.0285368,6.6141594 3.1484178,6.4436613 3.079009,6.273163 2.9338996,6.2100213 l -0.1514334,0 -0.2334395,0.031563 m -0.550676,-1.0236878 0.029522,0.25612 0.049205,0.4334139 0.1279474,0.1182012 0.3444778,0.059109 0.5609935,-0.049249 0.324781,0.059092 0.4035229,0.029563 L 4.0159529,5.8483299 4.1340592,5.4740248 4.1746586,5.3453453 3.9569078,5.2868553 3.7895975,5.20806 3.3959143,5.2179003 3.0907994,5.1587915 2.8652675,5.1151152 2.4609197,5.1587915 2.3132916,5.188354 1.9983517,5.2179003 m 6.2057262,0.2001241 0.168816,-0.017783 0.093227,0.075588 0.040094,0.1556213 0.084305,0.1245047 -0.00887,0.1511754 L 8.4484269,6.013854 8.3462461,6.018294 8.2707219,5.911581 8.1951956,5.7559597 8.2262863,5.5291944 8.2040853,5.4180273 M 8.0919369,4.6247228 7.85864,4.377493 7.4126165,4.2607369 7.0352072,4.1577294 6.6097833,4.2470032 6.2392377,4.3500269 5.9441858,4.4324259 5.676565,4.5217159 5.669695,4.920043 l 0,0.3296446 0.1098033,0.370861 0.3979766,0.054949 0.4803327,-0.08929 0.34199,-0.063569 0.5431817,0.2215254 0.4597492,0.1922959 0.075478,-0.096148 0,-0.3433786 0.08234,-0.5906246 -0.068617,-0.2815858 M 4.516918,4.1714631 4.475747,4.3225443 4.408762,4.5683614 4.386529,4.9200424 4.31105,5.3458358 l 0.1303719,0.3090535 0.4117173,0.027466 0.5352256,0 0.00687,-0.240371 L 5.5118851,5.0230648 5.4089588,4.6865465 5.3746511,4.3912268 5.0589981,4.2195369 4.5169266,4.1714632 M 3.3281295,4.0114433 3.1847315,4.2096301 3.1710869,4.3736349 3.1164633,4.7426692 3.1505974,4.9681809 3.3895831,5.0775229 3.6831777,5.0706976 3.8402191,5.0091925 3.9699574,4.9613559 4.2157566,4.7905129 4.2225938,4.4829841 4.1338343,4.2984663 4.0314167,4.2027949 3.5398004,4.1959744 3.4510276,4.0661356 3.3281353,4.0114565 m -1.6182305,0.034166 -0.1775321,0.1366815 -0.068283,0.2323528 0.034149,0.2596777 -0.00682,0.2050133 -0.00364,0.1089927 0.2494296,0.020863 0.669147,-0.01367 0.1372033,-0.00282 L 2.8092028,4.8861873 2.9321113,4.687999 3.0806275,4.4485177 3.04819,4.2506328 3.0269227,4.1209206 2.8296936,4.1207954 2.351737,4.0797874 2.1742048,4.0319508 l -0.2662888,0 -0.1980068,0.01367 M 4.1023834,3.2352969 3.8946163,3.3030099 3.7277176,3.3573869 3.6385466,3.4674271 3.5475866,3.579643 3.4508896,3.6989549 3.4452796,3.892967 3.6771988,3.970348 4.3246361,3.9365 4.8271388,3.950996 5.2184916,3.975176 5.3247924,4.1105862 5.4248976,4.2381078 5.672773,4.2674488 5.984481,4.3043298 6.2498286,4.1727595 6.7808077,3.9094787 6.9133986,3.8437336 6.8552709,3.6993522 6.5241675,3.5762617 6.1079202,3.4342461 5.8334371,3.3405899 5.5686997,3.5005142 5.360584,3.4815906 4.9443353,3.3490368 4.7104518,3.2745443 4.3483517,3.2732185 4.1023774,3.2352255 m -2.483467,-0.1740853 -0.03865,0.1402375 -0.033833,0.2611375 -0.02377,0.1836119 0.1977202,0.1790718 0.2464022,0.058029 0.7295874,0.072541 0.1966437,0.019544 0.3928115,-0.1356015 0.1111339,-0.1209 0.019332,-0.2321157 -0.048317,-0.2176041 -0.1062993,-0.1160739 -0.4348533,0 L 2.454784,3.0901617 2.0682481,3.0804984 1.6189104,3.0611446 M 3.2382349,1.6511782 3.0058731,1.7146065 3.0428434,1.9260191 3.2751889,2.4017112 3.3174365,2.708256 3.2435111,2.9672354 3.3755303,3.083514 3.6184462,3.2367872 3.9036099,3.1363679 4.0092298,3.0253745 4.0673233,2.7822562 4.1095547,2.4915563 4.1834962,2.1215851 4.2098978,1.8255996 4.0673233,1.6670394 3.739912,1.6247615 l -0.3696591,0 -0.1320188,0.026418 m 0.1152375,-0.4419549 0,0.1967417 0,0.072858 0.3931276,0.0583 0.560598,0 0.5969819,0 L 5.1662693,1.3913901 5.3170998,1.3075154 5.2317971,1.2019358 5.0206688,1.1946439 4.6202513,1.1654938 4.1615813,1.2019314 3.75389,1.2237939 3.4917991,1.1946439 3.3534724,1.209213 m 1.3104529,0.5537747 -0.2475271,0.3716225 -0.1310527,0.3643351 0.00729,0.5100496 0.2111283,0.1165985 0.5241802,0.0073 0.4222699,0.036421 L 5.6904716,2.877845 5.8579083,2.4042152 6.0617628,2.0763176 6.251052,1.7994295 6.1345631,1.6391238 5.4793286,1.6026878 4.9915469,1.6464113 4.6639298,1.7629936 m 1.550722,0.797924 0.3796267,0.096593 0.5211704,0.057966 0.1672956,-0.064395 0.4439796,-0.012875 0.1979908,-0.00575 0.091548,0.3406165 0.00643,0.2318284 -0.1994625,0.1352364 -0.3024051,0 L 7.0704045,3.4303041 6.9095447,3.5591102 6.626441,3.4496255 6.1824599,3.185583 5.8929233,3.0503467 5.8350031,2.8056417 5.8800548,2.6317612 6.2146445,2.5609206 m 0.2351363,-0.6492087 -0.1707024,0.2521824 0,0.154559 0.081278,0.1383004 0.2844975,0.016274 0.2844829,-0.097624 0.4429813,0 0.2275772,0.032546 0.2479079,0.073206 0.3535733,-0.00407 0.1666297,-0.081351 0.3332897,0.00407 0.2194785,0.048821 0.3982311,0.040676 L 9.5099592,2.4526904 9.5506869,2.3347269 9.6156585,2.1557656 9.4449889,2.0459317 9.1117298,2.0988164 8.7947933,1.7246071 8.5711949,1.557824 8.3111169,1.5171469 7.8356172,1.4846161 7.6230626,1.4700765 7.1975594,1.557827 6.9171348,1.6188405 6.6042078,1.8425564 6.4497808,1.9117147 M 5.6326704,0.51468819 5.5653531,0.72646605 5.549316,0.91258668 5.5909933,1.1243646 5.6775648,1.38747 l 0.1378517,0.060966 0.3270144,0.080225 0.2372434,0.070587 0.291739,0.012846 0.323815,-0.1828975 0.3494534,-0.1411907 0.359074,-0.0032 0.2564801,0.00962 0.057698,-0.099466 0.00961,-0.23424288 L 8.0339637,0.7008149 7.9153311,0.57244311 7.6075547,0.51790694 7.3222324,0.54999433 6.9022444,0.46335604 6.4918756,0.47618688 6.3187486,0.54999727 6.0590661,0.62699843 5.8827235,0.57244606 5.6326602,0.51468672 M 9.7967772,9.950077 9.7004287,9.8271129 M 8.170053,9.950077 8.213015,9.3796795 l 0.0088,-0.1167709 0.067064,-0.040518 0.1002463,0.048821 0.1571854,0.027117 0.195075,-0.035262 0.2058498,-0.00814 0.2926904,-0.00544 0.2031561,0.051521 0.051502,0.1437303 0.019017,0.2006633 0.09207,0.1410153 0.094767,0.040679 m -4.24743,0.122968 -0.045575,-0.2150321 0,-0.2266211 0.054338,-0.185851 0.5706243,-0.06798 0.2581445,-0.08159 0.5796759,-0.086114 0.2400326,0.1269176 0.4347577,-0.099721 0.2173698,-0.1087866 0.072468,0.1541144 0.02412,0.7906679 m -2.5022449,0 -0.214281,-0.421966 M 2.554746,9.9500683 2.6805541,9.5654746 3.0783249,9.4471142 l 0.7740377,0 0.591277,-0.1398722 0.2902672,0.1398722 0.1680397,0.080988 0.2404913,0 M 2.3584712,9.9500587 C 2.3802473,9.764453 2.3230298,9.587782 2.2134398,9.4538213 M 0.38758188,9.9500664 0.49491341,9.5439288 0.7695067,9.4622122 l 0.6085654,0 0.2077994,0 0.2504428,0.075493 0.2133147,0 0.1638079,-0.083876 m 7.7204145,-0.6872166 -0.089694,-0.040723 -0.1166327,-0.052885 -0.070829,0 -0.057365,0.170164 0,0.1719919 0,0.2032662 0,0.2058721 0.106807,0.1720068 0.1614805,-0.039088 0.066238,-0.037771 m -9.85664536,0 0.20062118,-0.040422 0.0520726,-0.044296 -0.0260356,-0.1615755 0,-0.067762 0.0468588,-0.1224719 0,-0.1016418 -0.0468588,-0.1537476 -0.22665823,-0.060919 m 0.14032484,-1.8393629 -0.0630871,0.4030425 0,0.3933421 0.0533723,0.3302163 0,0.06314 0.10189563,0.058268 0.16496506,-0.1116914 0.15040118,0 0.30082148,0 0.16011592,-0.1019748 0.067935,-0.286509 0,-0.5438827 -0.1115926,-0.2379581 -0.29597077,-0.053409 -0.20379126,0 -0.32506471,0.087416 m 9.54818534,-2.5767643 0,0.42138 L 9.5552701,4.926359 9.198559,4.998582 8.7141209,5.18329 8.378755,5.259878 l -0.1330981,0 0,-0.288636 0.067064,-0.3191194 0.041851,-0.1991384 0.01938,-0.09218 0.2194152,0 0.6460756,0.08232 0.5262728,-0.09264 m -9.68851017,0.7006162 0.19941695,-0.06187 0.28240676,0.1435712 0.29585903,0 0.36756833,0 0.4751658,0 0.09413,0.1166457 0.089644,0.2153501 0,0.2063789 0,0.2557238 0.085178,0.2422757 0.04483,0.2377828 L 1.8993381,6.6402496 1.6527932,6.7165201 1.0117727,6.6402496 0.80500401,6.6156398 0.55454515,6.7075503 0.2452456,6.770358 0.07720601,6.829228 m 9.85664539,-1.7781269 -0.494738,0.1217573 -0.2641671,0 -0.3834923,0.102324 -0.1789112,0.2813972 0.2513307,0.5914642 -0.1944413,0.2845557 0.1413542,0.2564381 0.2524394,0.097927 0.4671657,-0.091607 0.1893686,0 0.100944,0.060014 0.1131473,0.073858 M 9.8241907,4.0846001 9.6769743,3.4956122 l -0.2648008,0 -0.3825425,0 -0.5085237,0.06311 -0.2270068,0 -0.5632432,-0.046281 -0.1807493,0.054695 -0.3572817,0.1598609 -0.1303088,0.1178035 0.088267,0.1219959 0.2353891,0.096768 0.1723492,0 0.1597204,0 0.079868,0.1051655 0.2017622,-0.058901 0.3068411,0.067316 0.2143926,0 0.3825422,0 0.3025154,0.06311 0.3194715,-0.1135962 0.2985542,-0.042057 m -0.1521293,-0.8209283 -0.4785738,0 -0.1966586,0.075794 -0.4097998,0 -0.250997,-0.079542 -0.079473,-0.1423337 0,-0.1800073 0.071104,-0.1925668 0.2132516,-0.083718 0.4852291,0 0.3262866,0 0.259253,0.1130247 L 9.7790262,3.038049 9.8877351,3.2093575 9.7915409,3.343657 9.6720563,3.263671 m -8.231046,-0.095038 0,0.2643445 0,0.3720674 0,0.3426802 -0.2347862,0.4797581 0,0.2056158 -0.37010175,0.07054 -0.18288869,0 -0.26565647,0 -0.17681558,-0.046787 -0.0682363,-0.15024 0.0545767,-0.1775486 0.0410273,-0.1334097 0.0665733,-0.2165875 -0.0712005,-0.1234883 0,-0.2959398 0,-0.268615 0,-0.3050363 0,-0.086496 0.0818811,-0.072841 0.21833748,0 0.22744928,0.05463 0.14556959,0 0.17285654,0 0.2547376,-0.059188 0.1066801,0.146541 m 8.4928364,-1.0289596 -0.2093375,0.082955 -0.06022,0.090545 0.073211,0.1897076 -0.077648,0.215589 0.1369171,0.1832464 0.1370752,0 m -9.54626612,0.01015 -0.31037587,-0.01015 M 2.7401535,2.9696848 0.38758188,2.9118621 m 2.48245242,0.057823 -0.1298808,0 M 3.0249054,2.7746887 2.8700343,2.9696848 m 0.1548711,-0.3299938 0,0.1349977 M 3.0898466,2.4696995 3.0249054,2.639691 m 0.064941,-0.4299858 0,0.2599943 M 2.9000167,2.0390964 3.0898469,2.2097052 m -0.4740426,-0.1706088 0.2842124,0 M 2.437194,2.0748505 2.615804,2.0390964 M 2.248396,2.0186629 2.437194,2.0748504 M 2.0315157,2.0544168 2.248396,2.0186629 M 1.5314375,2.2382836 2.0315157,2.0544168 m -0.5740664,0.1838668 0.073989,0 M 1.3400876,2.199878 1.4574498,2.2382836 m -0.2801879,-0.038406 0.1628257,0 M 1.0160521,2.2306146 1.1772619,2.199878 M 0.85530252,2.2612567 1.0160521,2.2306146 m -0.33679229,0.030642 0.17604271,0 M 0.48023926,2.0799458 0.67925922,2.2612568 m -0.38271735,-0.181311 0.18369739,0 M 0.07720601,2.1396732 0.29654187,2.0799458 M 1.4210799,1.884029 1.7941944,1.8191103 m -0.5128673,0.064919 0.1397528,0 M 1.0775844,2.0120589 1.2813271,1.884029 M 0.88919804,2.0671975 1.0775844,2.0120589 m 0.9702375,-0.1929486 -0.2536275,0 m 0.3920188,0.0633 -0.1383913,-0.0633 M 2.6415559,1.697957 2.1862132,1.88241 M 2.883663,1.5998712 2.6415559,1.697957 m 0.3977384,-0.098086 -0.1556313,0 M 3.203214,1.507565 3.0392943,1.599871 m 0.1639197,-0.2898589 0,0.197552 m 0,-0.2957322 0,0.098181 m -2.56766109,0.7571852 0.25364513,0 M 0.38758188,1.9581252 0.63555291,2.0671975 m -0.5583469,-0.1090723 0.31037587,0 m 2.74341852,-0.7613924 0.072214,0.0151 m -0.3482183,-0.072825 0.2760048,0.057727 m -0.514942,-0.057727 0.2389372,0 m -0.4965273,0.065967 0.2575901,-0.065967 m -0.4984623,0.065967 0.2408722,0 m -0.4550897,0 0.2142175,0 m -0.4243152,0 0.2100977,0 m -0.683854,0.053598 0.4737559,-0.053599 m -0.82392395,0.053599 0.35016805,0 m -0.4861171,0 0.13594905,0 M 0.46564412,1.2049738 0.7334076,1.2585731 m -0.42431516,-0.053599 0.15655168,0 m -0.15655168,0.053599 0,-0.053599 m -0.23188643,0.1050385 0.23188683,-0.05144 m 8.80801276,0.5905125 0.067983,0.10904 M 8.9800302,1.6295441 9.1171056,1.8490852 m 0.07765,-0.2195411 -0.2147248,0 m 0.3472038,0 -0.132479,0 M 9.7066079,1.455743 9.327234,1.6295441 M 9.9338514,1.3100123 9.7066079,1.455743 M 9.8492297,0.65423189 9.7967762,0.07487961 m 0.052456,0.84020399 0,-0.26085171 M 9.7318042,1.2514281 9.8492297,0.9150836 M 9.5682649,1.3957623 9.7318042,1.2514281 m -1.5617517,-1.17654849 0.034576,0.29725678 0,0.15306689 0,0.14031709 0,0.17219675 0.057365,0.18175428 0,0.1658314 0.066906,0.079716 0.1370592,0.1084213 0.3632087,0.057393 0.4286571,0.067745 0.3104391,-0.102816 M 7.9174373,0.36972373 7.8589628,0.46401479 M 7.9500499,0.24253647 7.9174371,0.3697237 m -0.00177,-0.19047074 0.034387,0.0632836 m -0.091087,-0.16765661 0.0567,0.1043731 m -2.3317645,-0.1043731 0,0.2063951 0.082039,0.0848455 0.2478124,0 0.3651744,-0.10443645 0.2021577,0 0.5412481,0 0.3260645,0.0717937 0.2477962,0 0.1565031,0.13053707 0.10627,0 M 5.3986604,0.34555994 5.3567141,0.07487961 m 0.091167,0.45459423 -0.04922,-0.1839139 m -0.00329,0.41053633 0.052517,-0.22662243 M 5.2247277,1.0517016 5.3953668,0.75609627 m -0.3314357,0.29560533 0.1607966,0 M 4.5913942,1.0024363 5.0639311,1.0517016 M 4.3485576,0.94988447 4.5913942,1.0024364 m -0.580833,-0.0525519 0.3379964,0 M 3.7414817,1.0024364 4.0105612,0.94988446 m -0.8203907,0.0525519 0.5513112,0 m -0.9089899,0 0.3576787,0 M 2.6815348,0.92360856 2.8324918,1.0024364 M 2.5994963,0.71340395 2.6815348,0.92360853 M 2.5547446,0.07487961 2.5994963,0.71340395 M 2.485954,0.27387672 2.3584668,0.07487961 m -1.97088639,0 -0.068173,0.17132466 -0.0427535,0.10745191 0,0.12666425 0,0.11926334 0,0.19877468 0,0.0971975 0,0.0927503 0.0471748,0.0927663 0.17653381,0 0.16772344,0 0.38396864,0 0.097094,0 0.2383358,-0.075096 0.1147465,0 0.2471623,0.048598 0.1279959,0 0.2250878,0 0.3133549,-0.16786288 0.075035,-0.21203124 0,-0.14134826 0,-0.24295927 -0.00491,-0.016496 m 7.447896,1.68424855 -0.7487626,0",
    "brick":         "m 0.02411255,0.01228561 c 0.06308656,0.0078801 9.93991135,0 9.93991135,0 m -1.5713116,1.58136809 0,-1.581516 m 0,4.9369793 0,-1.677732 m 0,5.0331827 0,-1.677731 m -3.351586,-5.033183 0,-1.581516 m 0,4.9369793 0,-1.677732 m 0,5.0331827 0,-1.677731 m -3.3515507,-5.033183 0,-1.581516 m 0,4.9369793 0,-1.677732 m 0,5.0331827 0,-1.677731 m 5.0273316,-3.3554517 0,-1.6777313 m 0,5.033183 0,-1.6777197 m 0,5.0331828 0,-1.6777321 M 3.3653574,3.271385 l 0,-1.6777313 m 0,5.033183 0,-1.6777197 m 0,5.0331828 0,-1.6777321 m -3.35156278,0 9.95861828,0 m -9.95861828,-1.677731 9.95861828,0 M 0.01379462,4.949117 l 9.95861828,0 m -9.95861828,-1.677732 9.95861828,0 m -9.95861828,-1.6777313 9.95861828,0",
    "inca":          "m 9.9279116,3.0680636 -9.09719397,0 m 4.83879577,-0.7693463 0,0.7693463 m -2.8806407,-2.61969653 -2.73141663,0 m 2.73141663,0.89057253 0,-1.2837775 m -1.95815507,2.5376962 -0.77326156,0 m 2.73141663,-1.70291137 -2.73141663,0 m 0.77326156,2.17811667 0,-2.17811667 m 2.32174507,0.44899267 0,1.729124 m 5.2121384,-0.4752053 1.5633105,0 m -3.1257921,-1.70291137 3.1257921,0 m -1.5633105,1.40877037 -5.2121384,0 m 2.1181539,-0.387003 -2.1181539,0 m 5.2121384,-0.5727747 -7.53388347,0 m 7.53388347,1.7029137 0,-2.15190637 M 6.58506,1.3389396 6.8019393,0.889859 m 1.802e-4,8.793e-5 L 6.549633,0.0551621 M 5.5181728,1.3389396 5.2701957,1.9115339 m 4.209e-4,1.804e-4 0,0.387003 M 3.5257934,3.83741 l 0,-0.7693464 m -2.69507577,6.5902811 0,0.2788749 m 4.07868997,-3.715692 0,0.4179331 m 3.4551935,3.018884 1.5633105,0 m -3.5214775,-3.9705834 2.8011524,0 m -2.8011524,-0.8905616 0,1.4243279 m -0.7369207,2.817545 0,0.898147 m 1.815665,-3.715692 0,0.4179331 m -1.4921318,1.0217695 0,-1.0217695 m 2.3715545,-3.0961917 1.5633105,0 m -3.5214775,1.7029138 3.5214775,0 M 8.3646011,3.094286 l 0,2.1518968 m 0,3.2046082 0,1.4864286 M 6.817657,7.6612302 l 0,1.3778424 m 1.8066942,-2.3996119 0,1.0217695 m 0.5832353,-2.4150474 0,1.3932779 m 0.7203251,0.5109143 -1.3035604,0 M 6.042844,4.7971997 l 0,-1.7291361 m -2.8903813,5.971009 0,0.898147 m -3.09500663,-0.2788749 5.61205733,0 m -3.9593252,-3.4368171 0,0.4179331 m 1.492072,1.0217695 0.3474397,-1.0211195 m 0.8387284,1.8106803 0,0.5882816 m -4.33097223,-1.3778424 9.87045553,0 m -9.87045553,1.3778424 8.30714503,0 m -8.30714503,-2.817545 9.15013043,0 m -9.15013043,0.4179331 9.87045553,0 M 0.83071763,3.543269 l -0.77326156,0 m 2.33573053,1.7029138 -2.33573053,0 m 2.32019373,3.2046082 7.5502618,0 M 0.83071763,3.83741 l 5.21212637,0 m -2.1181538,0.3870028 2.1181538,0 m -5.21212637,0.5727869 7.53388347,0 m -7.53388347,-1.7291361 0,2.1781192 m -0.63933393,3.7928898 0,0.6192721 m 2.1862661,-1.9971145 0,1.3778424 m -1.56236078,-2.3996119 0,1.0217695 M 0.05745607,7.150375 l 0.75783295,0 M 2.6102464,4.7971997 2.3933671,5.246267 m -1.805e-4,-8.42e-5 0.2949127,0.9750559 M 3.6771459,4.7971997 3.925111,4.2245934 m -4.208e-4,-1.806e-4 0,-0.3870028",
    "earth":         "M 9.904881,0.70770528 9.25824,0.06103371 M 4.9842264,0.70770528 4.3376453,0.06103371 M 9.904881,5.6289687 7.4444935,3.1683287 m -2.4602671,2.46064 -2.4603036,-2.46064 M 9.2897542,9.9350646 7.4444935,8.0895966 M 4.3691474,9.9350646 2.5239228,8.0895966 M 8.9821907,1.6304405 7.4129795,0.06103371 M 4.0616199,1.6304405 2.4924087,0.06103371 M 8.9821907,6.5516967 6.5219233,4.0910685 M 4.0616199,6.5516967 1.6013045,4.0910685 M 7.4444935,9.9350646 6.5219233,9.0123247 M 2.5239228,9.9350646 1.6013045,9.0123247 M 8.0596206,2.5531805 5.599305,0.09254743 M 3.1390016,2.5531805 0.67869824,0.09254743 M 8.0596206,7.4744367 5.599305,5.0138086 M 3.1390016,7.4744367 0.67869824,5.0138086 M 8.0596206,8.0895966 9.9363953,6.2126103 M 8.0596206,3.1683287 9.9363953,1.2913542 M 3.1390016,8.0895966 5.599305,5.6289687 M 3.1390016,3.1683287 5.599305,0.70770528 M 0.06361936,6.2441165 0.67869824,5.6289687 M 0.06361936,1.3228605 0.67869824,0.70770528 M 8.9821907,9.0123247 9.9363953,8.0580785 M 8.9821907,4.0910685 9.9363953,3.1368223 M 4.0616199,9.0123247 6.5219233,6.5516967 M 4.0616199,4.0910685 6.5219233,1.6304405 M 0.06361936,8.0895966 1.6013045,6.5516967 M 0.06361936,3.1683287 1.6013045,1.6304405 M 9.904881,9.9350646 9.9363949,9.9035463 M 9.904881,5.0138086 9.9363949,4.9822903 M 4.9842264,9.9350646 7.4444935,7.4744367 M 9.904881,0.09254743 9.9363953,0.06103371 M 4.9842264,5.0138086 7.4444935,2.5531805 M 0.06361936,9.9350646 2.5239228,7.4744367 M 9.904881,0.09254743 9.9363953,0.06103371 M 4.9842264,5.0138086 7.4444935,2.5531805 M 0.06361936,9.9350646 2.5239228,7.4744367 M 4.9842264,0.09254743 5.0157404,0.06103371 M 0.06361936,5.0138086 2.5239228,2.5531805 M 0.06361936,0.09254743 0.0951335,0.06103371",
    "fieldstone":    "m 8.482695,7.1413606 -0.4464317,0.05293 M 8.9565009,7.3222945 8.4829347,7.1409031 M 8.9565009,1.219942 9.1702305,0.61174555 m 0.00527,0.001897 L 8.9729427,0.055363 m 0.077567,9.878222 -0.094256,-0.2597992 m 1.844e-4,-9.65e-5 -0.8493939,0 M 8.9564381,2.1975432 9.1604417,2.0443496 m 0,-7.21e-5 0.1205529,-0.8288496 M 8.6755872,2.4085525 8.9565581,2.1976513 M 8.6755872,2.4085525 8.3573963,2.7421262 M 8.277308,1.9726211 8.9570376,1.2205309 m -4.964833,6.9617709 0.9350766,0 M 8.9564381,7.3222936 9.3084905,7.4677364 m -0.3520524,-0.7717918 0,0.626349 M 9.1449515,5.9706321 8.9564381,5.5145904 m 0,1.1813661 0.1887533,-0.7252522 M 9.1249002,4.9619316 9.265866,5.4802064 M 8.9564381,4.4455463 9.1240589,4.9621963 M 9.2348858,3.7744996 8.9572792,4.4458835 m -9.222e-4,3.3896662 0.0664,0.2125019 M 0.24170174,8.3236527 0.29585442,8.1824221 M 6.7826581,3.0642307 7.1815626,2.8023374 M 6.3907646,3.2101789 6.7826471,3.0641704 M 6.177793,3.547941 5.9497152,3.8994467 M 6.3907646,3.2101789 6.1778651,3.5479891 M 5.9408284,2.6548365 6.3910542,3.2099382 M 5.2297238,3.4897638 4.9518517,3.0681059 m -7.36e-5,4.82e-5 -0.7620405,0.4742988 M 5.2268538,3.0742317 4.9517781,3.0681215 M 3.5536287,3.1821734 4.1206851,2.6857303 m 5.5849244,0.9591764 0.093416,0.1919941 m -0.107824,-0.6161553 0,0.4243776 m 0.00565,-0.7813112 0,0.3569817 M 0.07463432,9.0710492 0.5019736,8.8177248 m 7.3779e-4,0.0014 0.67366851,0.077288 m 2.4e-5,-2.027e-4 0.1815615,0.6887744 M 1.3437997,0.05536097 1.2535299,0.89007086 M 1.3583657,9.5848813 1.3206622,9.9335829 M 1.2509844,0.8897904 0.47270875,1.0063373 m 7.194e-5,4.807e-4 -0.39823306,-0.14908951 m 0.39823306,0.14908951 0,0.3257173 M 0.4809522,1.332427 0.35826345,1.8997441 m 2.397e-5,0 0.65271508,0.4642979 m 0.00147,-0.00219 0.3589928,-0.2127854 m 1.844e-4,4.621e-4 0.6198019,-0.077806 m 1.29e-5,1.083e-4 0.1408728,-0.9351682 M 2.133076,1.1367699 1.2507225,0.8902007 M 0.35815055,1.8997365 0.08578985,2.287215 m -0.0093516,-0.00839 0.0120077,0 0,0.012035 -0.0120077,0 0,-0.012035 m 9.85348285,-1.0734005 -0.973909,0 M 9.929921,0.18670382 9.355374,0.05534987 M 9.929921,9.8509155 9.3131072,9.7098895 M 9.3129874,9.7101299 8.956132,9.6738688 M 9.929921,8.4630644 9.786915,8.4420273 m 0,1.685e-4 -0.1970405,-0.1400993 m 5.533e-4,-7.58e-4 -0.3243165,0.011529 m 0,-7.21e-5 L 8.9559642,8.1824323 M 0.07435948,8.36256 0.24127382,8.3229768 m 1.5494e-4,6.655e-4 0.2611941,0.4954324 M 1.1762195,8.8962067 1.7021842,8.7261403 m 1.845e-4,6.1e-4 0.5006784,0.041894 m 0,6.01e-5 0.5252452,-0.3424796 m 8.31e-5,1.203e-4 0.3343543,-0.00744 m 0,8.44e-5 0.5325348,0.2051843 m -1.29e-5,4.82e-5 0.2666225,0.3793188 m -0.00242,0.00169 0,0.6099453 M 3.8291988,0.05535302 3.7738822,0.34386222 M 3.8492281,9.6151052 3.7881696,9.9335749 M 3.7739118,0.34386591 3.2306549,0.1274659 M 3.5868628,9.9335749 3.2306549,9.7916826 M 3.2306788,0.12740451 2.8689115,0.05535302 M 3.2306788,9.7916343 2.4710031,9.6403425 m 0,4.81e-5 L 2.2286247,9.1519025 M 2.2293626,9.1515512 2.2037276,8.768658 M 2.4480151,0.05535061 2.1334375,1.1368728 m 0.337619,8.5035154 -0.085275,0.2931844 M 9.929932,2.8347351 9.2285867,2.9214834 m 1.218e-4,5.731e-4 -0.2725654,-0.056553 M 0.08245131,2.2848401 0.29973524,3.096251 m 1.8445e-4,-7.22e-5 0,0.4273744 M 1.0123228,2.361852 1.253801,3.2206686 M 2.039807,3.0345836 2.2768547,2.8322395 M 2.2764858,2.8318882 1.9915161,2.0717705 M 2.7282813,8.4263522 2.7126769,8.1822828 M 3.5951502,8.6242315 3.9910666,8.181693 M 3.8491175,9.6151082 4.6283283,9.3883569 m -4.79e-5,-1.564e-4 0.8342876,-0.06594 m 7.19e-5,9.804e-4 -0.145852,-0.6916869 m -0.00111,2.219e-4 -0.3888667,-0.4494827 m 0.3888667,0.4494827 0.388603,-0.1658423 m 9.59e-5,2.22e-4 0.7467439,-0.2782248 m -2.39e-5,-9.63e-5 0.757335,0.1405325 m -1.199e-4,3.512e-4 0.015844,-0.1464537 m -0.015844,0.1464537 0.098218,0.5412133 m 3.689e-4,-8.41e-5 -0.364938,0.1298093 m 1.568e-4,4.252e-4 -0.8820768,0.50979 M 6.0599111,9.5096497 5.4624905,9.3237334 m 0.5974206,0.1859163 0.047681,0.4239205 m -0.024062,-9.87822199 0.03625,0.32231062 m 5.533e-4,-6.619e-5 -0.2529214,0.29062085 m 8.48e-5,8.079e-5 L 5.446294,1.067774 M 5.4455562,1.066942 4.7044563,1.0339949 M 4.7044674,1.03393 3.8511963,0.79548687 m 2.39e-5,-1.1555e-4 -0.079285,-0.45118095 m 0.079285,0.45118095 -0.244612,0.26099788 m 5.533e-4,4.991e-4 -0.2102361,0.2430033 m 3.69e-4,2.589e-4 L 2.764367,1.1560693 m -5.89e-5,2.772e-4 -0.595873,-0.1412823 M 3.3972944,1.300131 3.7948062,2.289792 m -0.0019,7.58e-4 -0.5641256,0.3370759 m 8.49e-5,1.325e-4 -0.4509452,0.1663115 m 6.08e-5,1.684e-4 -0.5014236,0.037537 m 2.874622,-1.7779576 -0.036346,0.5429152 m 3.689e-4,2.4e-5 -0.7484612,0.5323918 m 0.00147,0.0021 -0.3077443,0.2357448 m -9.3e-6,-2.54e-5 L 3.792757,2.2908024 M 5.1151767,1.5967568 5.5188603,1.8670145 m -9.59e-5,1.443e-4 0.1533573,0.2578255 M 5.6723061,2.12484 6.138319,2.2669009 m -3.51e-5,1.082e-4 0.6681442,0.095053 m -3.688e-4,0.00254 0.4463929,-0.4869356 m 1.218e-4,2.41e-5 0,-0.516999 m 0.01945,3.689e-4 -0.2006041,-0.37110356 m 5.91e-5,-3.256e-5 -0.103094,-0.26889055 m 5.529e-4,-2.2185e-4 -0.6580697,-0.0520104 m 0,-6.859e-5 -0.1908799,-0.29096508 m 0.8489496,0.34304407 0.9802613,0.12304583 m -1.199e-4,3.8822e-4 0.534204,0.0723772 m 0,3.5126e-4 0.4727251,0.30265971 M 7.9490793,0.84423994 8.1120187,0.46772537 m 7.379e-4,3.3278e-4 0,-0.41273435 m 0,9.8782219 0,-0.2552379 m -0.00625,3.59e-5 L 7.9811473,8.9946603 M 7.9817006,8.9945761 7.8306517,8.835955 m 1.198e-4,-9.64e-5 -0.5238766,0.033878 M 7.8307693,8.8358586 8.0916868,8.5573691 M 8.0911335,8.556833 8.5971185,8.3968759 m 0,4.83e-5 0.3586576,-0.2148487 M 7.2525462,1.8776796 7.8626349,2.2186549 m -1.197e-4,3.6e-5 0.4144903,-0.2456821 M 8.2768211,1.9725835 8.675222,2.4084668 M 7.8700148,3.402629 8.3637524,3.7788908 m 1.845e-4,-2.772e-4 0.5919589,0.05808 M 6.8060316,2.3645866 7.400715,3.0595953 M 7.4012684,3.059281 7.8679915,3.12569 M 6.1383338,2.2669937 5.9401532,2.6546527 m 3.689e-4,1.445e-4 -0.7139155,0.4195035 M 4.0605211,2.3669563 4.185794,3.0352832 m 5.534e-4,-1.081e-4 0,0.054373 M 3.2380125,3.9637704 3.5521585,3.1816767 m 0.6376824,0.3614589 0,-0.4539959 M 4.0731911,4.2130272 4.1908849,3.5433163 M 5.9490492,3.8992027 5.2293936,3.4896762 M 6.1522597,4.2842383 5.9492282,3.8991067 M 7.3173841,3.5787351 7.4015562,3.0593293 M 6.8186388,4.1774157 7.3173841,3.5787712 M 8.356854,2.7419785 8.9560158,2.8902134 M 7.8681574,3.1247512 8.3570938,2.7422315 m -0.4800514,1.5664497 0,-1.1839659 M 8.2946557,4.549032 8.9558958,4.4445201 M 7.8770424,4.3086812 8.2946557,4.5491162 M 7.2717568,4.6581051 7.8769225,4.3083682 M 8.728838,7.7025116 8.9560158,7.8355343 M 8.151408,7.6313006 l 0.57743,0.07144 M 7.8759615,7.4710668 8.1512882,7.6313488 M 7.8759615,7.4710668 7.3517251,7.4444334 M 8.0358999,7.1951165 7.8760832,7.4711511 M 8.151408,6.5096758 8.0357782,7.1950925 m 0.1156298,-1.1394004 0,0.4539837 M 7.9825865,5.6818133 8.1515298,6.0556319 M 8.5157097,5.6016962 8.9560158,5.5146829 M 7.9825865,5.6818133 8.5157097,5.601973 M 7.0052192,5.8954581 7.9824666,5.6815605 M 6.4632368,5.993375 6.2767026,6.2871731 M 7.0052192,5.8954581 6.4629713,5.9918826 M 7.1029463,5.5482849 7.005328,5.8954824 M 7.2984136,5.1744181 7.1016736,5.547611 M 7.2717568,4.6581051 7.2986537,5.1744062 M 6.8186388,4.1774157 7.2704361,4.6594168 M 6.1522597,4.2842383 6.8186038,4.1772109 M 5.779099,4.6937166 6.1519001,4.2839012 M 5.325968,4.6581051 5.779086,4.6939214 M 4.9261505,4.9340673 5.32203,4.6524606 M 4.0731911,4.2130272 3.8066775,4.2932283 M 4.3841663,4.444472 4.0731062,4.2131475 M 4.9261505,4.9340673 4.3846957,4.4438823 M 4.9652705,5.4230128 4.9270746,4.9339951 M 2.7848836,3.8035366 2.2830154,3.7724984 M 3.2380125,3.9637704 2.7851712,3.8027185 M 3.8066405,4.2931441 3.2380974,3.9636141 M 3.5667486,5.4147568 3.8092229,4.2936976 M 2.7937685,5.4414624 2.1998063,5.5905759 M 3.5667486,5.4147568 2.7937444,5.4409448 M 3.7799856,5.6551075 3.5666636,5.4148411 m 0.559839,0.2669722 -0.3464579,-0.02738 M 4.1265026,5.681813 3.8130889,6.2391532 M 4.6773718,5.3880512 4.1265505,5.6819095 M 5.2637714,5.4592742 4.677167,5.389724 M 5.903481,5.8865524 5.2634578,5.4597435 M 6.2766547,6.287137 5.9022801,5.8876836 M 6.338853,6.8568491 6.277232,6.2870647 M 6.338853,6.8568491 5.5125853,6.9020531 M 6.9963343,7.2040104 6.3387681,6.8569815 M 7.3517251,7.444361 6.9962512,7.2041427 M 7.2717568,7.8716391 7.3518448,7.4443853 M 7.2717568,7.8716391 7.2249284,8.1823224 M 5.1127309,7.7826285 4.925706,8.1817208 M 5.5125484,6.9013545 5.1128636,7.7826887 M 4.6773718,6.8479432 5.5125133,6.9019443 M 3.8951581,6.6318431 4.6772998,6.848196 M 3.7399286,7.8262673 3.9907013,8.1830326 M 2.6740677,7.9755735 2.7128041,8.182202 M 2.2829914,3.7728474 2.0138253,4.5387301 M 2.039772,3.0345491 2.2838916,3.7725466 M 1.5582691,2.9712331 2.0397609,3.0346579 M 1.0147372,3.4171895 1.5582098,2.9711367 m -0.5328464,1.289188 0,-0.8431953 M 0.30288565,3.5324968 1.0147722,3.4174181 M 0.09411592,4.1739376 0.30227328,3.5323042 M 9.2344633,3.7744601 8.9560158,3.836344 M 9.9298047,3.8513152 9.2343434,3.7752059 M 2.5167135,6.6256206 2.1634124,5.4695999 m 0.1670195,1.6474695 0,0.5539824 M 2.5167135,6.6256206 2.3306607,7.1171657 M 3.2742275,6.4638705 2.5166895,6.6255242 M 3.8144335,6.2399112 3.2742994,6.4640389 M 3.8951581,6.6318428 3.8163669,6.2395261 m 0.097416,1.0019728 0,-0.6099452 M 3.7399286,7.826267 3.9130608,7.2412825 m -0.787856,0.5974286 0.6148438,0 M 2.6740677,7.9755732 3.1250259,7.8380973 M 2.3117969,7.6707388 2.6742116,7.9754046 M 1.5725823,7.5523989 2.3117379,7.6711239 M 1.2323088,7.3876398 1.5726431,7.5522665 M 0.30549192,7.9730819 0.29534718,8.1822739 M 0.30549192,7.9730819 0.56042949,7.474388 M 9.308188,7.4676168 8.9563754,8.1824832 M 9.6847371,7.3955273 9.308188,7.4676408 m 0.6111696,-0.078938 -0.2346205,0.00695 m 0.2390638,-0.014731 0.012009,0 0,0.012036 -0.012009,0 0,-0.012036 M 9.3583787,6.6491736 8.9561357,6.6968562 M 9.9298047,6.5097843 9.3575375,6.6454788 m 0.5722672,-1.1652876 -0.9737889,0 m -8.86189988,-1.3062534 -0.01982468,0 M 0.5597341,4.6749904 0.09199106,4.1759235 M 2.1627872,5.4697808 1.2839033,5.7284729 M 2.008349,4.5367686 2.1626673,5.469805 M 1.3875144,4.4676637 2.0083619,4.5366602 M 1.0253634,4.2603249 1.3880548,4.4667129 M 0.5597341,4.6749904 1.025688,4.260698 M 0.50800696,5.2970066 0.55944636,4.6749663 M 0.24932138,5.7635068 0.51077924,5.2985592 M 0.24932138,5.7635068 0.07429124,5.8294225 M 1.2840471,5.7289542 0.24934535,5.7640003 M 1.4047568,6.6965192 1.2811531,5.7293154 M 1.2323091,7.3876405 1.40382,6.6962905 M 0.5597341,7.4740275 1.232237,7.3870628 M 0.07429124,7.1940335 0.56135543,7.4711873",
    "riverstone":    "m 0.13413781,9.9511007 -0.09907119,0.021832 m 0.25738195,-0.04304 -0.15831076,0.02103 m 0.34828187,0.021297 -0.1900424,-0.041881 m 0.19682359,0.053287 -0.007129,-0.011317 m 0.0529307,-0.021208 0.0185346,0.032525 M 0.50693352,9.6977999 0.53437904,9.9511453 M 0.52903251,9.497314 0.50746818,9.6977376 M 0.69445415,9.3566111 0.52903251,9.4971981 M 0.95828758,9.3038587 0.69437395,9.3562547 M 1.3135823,9.3285418 0.95820738,9.3051062 M 1.5105752,9.4305982 1.3136982,9.3283191 M 1.6547889,9.5888466 1.5108693,9.4302952 m 0.1650295,0.4118165 0,-0.2541384 m 0.024059,0.3949571 -0.023703,-0.1408811 m 0.5310975,0.095551 0.2060285,0 m -0.4682045,0.012475 0.262176,-0.012475 M 1.7984764,9.8687193 1.94531,9.9496303 m -0.2123909,-0.2338127 0.06603,0.1527237 m -0.072267,-0.3056522 0,0.1530444 m 0.034307,-0.3995997 -0.03395,0.2466176 M 1.8733105,9.1883647 1.7606591,9.3160488 M 2.0887133,9.0385639 1.869862,9.1832143 M 2.2291667,8.9886184 2.0887222,9.0386084 M 2.4070813,9.0105392 2.2291845,8.9885293 M 2.5943436,9.1042015 2.4067606,9.0112253 M 2.8440532,9.2009647 2.5941921,9.1046737 M 3.0594293,9.3289607 2.8441245,9.2009024 M 3.1811519,9.556803 3.0583511,9.3295488 m 0.1290474,0.3989046 0,-0.1717573 M 3.0906352,9.8907562 3.1884411,9.7291039 M 2.7847157,9.9032314 3.0905996,9.8906671 M 2.4132922,9.9407461 2.7846978,9.9030531 M 2.570498,9.9715781 2.477745,9.9838751 m 0.6541479,-0.00713 -0.5614659,0 m 1.1176743,0 -0.5562084,0 m 0.5726579,0.00713 -0.016574,-0.00713 m 0.4522005,-0.00535 -0.00446,0.012297 M 4.3446371,9.7825424 4.1402392,9.9716848 M 4.774908,9.7510603 4.344646,9.7826939 m 0.8552844,0.00535 -0.4249601,-0.037337 m 0.4564511,0.1213929 -0.031723,-0.083851 m 0.011495,0.1958256 0.021119,-0.1118673 m 4.7463552,0.084208 -0.00356,0.027713 M 9.9594202,9.742194 9.9796479,9.956367 M 9.855555,9.4889912 9.9599281,9.741989 M 9.6478066,9.3786121 9.855849,9.488608 M 9.2972347,9.4240041 9.6476908,9.3776675 M 8.9790716,9.501912 9.2969941,9.4231398 M 8.8231935,9.6577633 8.9796775,9.502616 M 8.738754,9.8719988 8.8202885,9.6566227 M 8.7228302,9.9840888 8.738246,9.8719275 m -3.4547939,0.00178 0.032881,0.1088286 M 5.3172243,9.7698444 5.2823828,9.8736295 M 5.5077301,9.7265554 5.3169926,9.7686147 M 5.940603,9.795882 5.5080954,9.7244167 M 6.2133027,9.8261701 5.9405673,9.7961404 M 6.5466054,9.8607443 6.2132314,9.826883 M 6.6937597,9.91707 6.5463737,9.861377 M 6.7522686,9.9835452 6.6937241,9.91707 M 6.8550645,9.7610316 6.911114,9.9834739 M 6.8982823,9.5056635 6.8553319,9.7610939 M 7.097396,9.3109072 6.8995833,9.5070179 M 7.3571037,9.1161242 7.0980732,9.3117983 M 7.5908451,9.0641916 7.3569789,9.1157856 m 0.6754093,-0.064604 -0.4417837,0 m 0.84002,-0.03903 -0.3983521,0.037604 M 8.6296937,9.1203302 8.4303839,9.0125263 M 8.7466223,9.3151042 8.6289541,9.1207668 M 8.7682133,9.5401753 8.7470054,9.3150686 M 8.6341224,9.8517978 8.7687836,9.5403625 M 8.539872,9.9833492 8.637562,9.8543107 m -2.6148363,-8.90707826 0,0.20396116 m 0,0 0.092067,0.1672573 m 7.04e-4,-3.564e-4 0.1196286,0.1129633 m 8.02e-5,-9.81e-5 0.2140483,0 m -8.9e-6,-0.00178 0.1670256,0.055158 m -1.337e-4,4.634e-4 0.1670078,-0.055158 m -1.158e-4,-4.723e-4 0.2394087,-0.31647 m 8.91e-4,8.911e-4 0.036089,-0.16708795 m 8.911e-4,2.3168e-4 0,-0.16687411 m 0,0 -0.1477335,-0.16739985 m -5.792e-4,4.7227e-4 -0.069416,-0.0733366 M 6.8423571,0.53982012 6.675688,0.57653292 M 6.6754479,0.5756397 6.5360727,0.71895343 m -6.23e-5,-5.346e-5 -0.2545394,0.11648306 m 4.45e-5,9.802e-5 -0.1668741,0.014703 m 0,3.564e-5 -0.092851,0.0963801 M 7.030404,3.2993046 6.9154447,3.2081997 m 0.2329037,0.060772 -0.117784,0.031099 M 7.3370364,3.107988 7.1480722,3.2685888 m 0.4560679,-0.255181 -0.2672285,0.094224 m 0.580553,-0.09164 -0.3133245,0 M 8.094809,2.9515663 7.9177141,3.0167049 M 8.1347119,2.7793813 8.0946129,2.9516198 M 8.0217219,2.602028 8.133803,2.7798625 M 7.8486191,2.4053915 8.0219625,2.601832 m -0.4113442,-0.193286 0.2380008,0 M 7.4090185,2.4407143 7.6103777,2.4074767 M 7.2236632,2.5536152 7.4089027,2.4405539 M 7.0785228,2.7471061 7.2243939,2.5542122 M 6.9748179,2.9486346 7.0768832,2.7462506 M 6.9150972,3.2084582 6.9755129,2.948795 M 6.7399448,2.1666512 6.5948222,2.1506116 M 7.0301545,2.2955827 6.7395349,2.1675155 M 7.0704584,2.4568162 7.0298248,2.2956629 m 0.016485,0.3304423 0.023168,-0.1694137 M 6.9252645,2.7470437 7.046702,2.6266399 M 6.852721,3.0211425 6.9219585,2.7462061 m -0.093555,0.460354 0.023436,-0.1855335 M 6.7397666,3.2871769 6.828519,3.2066225 m -0.3305225,0.1209029 0.241886,-0.039921 m -0.3869908,0.015861 0.1451405,0.02397 m -0.411166,-0.096594 0.2658384,0.073247 m -0.3383908,-0.1860949 0.07298,0.112589 M 5.9417347,2.9970742 6.0148039,3.1177275 m -0.073069,-0.2980066 0,0.1773533 m 0.072624,-0.362771 -0.070485,0.1862286 M 6.1110593,2.3118362 6.0136009,2.6340715 M 6.2239601,2.198962 6.1106226,2.3113461 M 6.4416174,2.1183542 6.2240582,2.199265 M 6.5947776,2.1506116 6.4419203,2.1169284 m 0.00802,1.6782669 0.1612959,0.04001 m -0.1935354,-0.1125355 0.031544,0.072891 m -0.031544,-0.2502354 0,0.1773622 m 0.032168,-0.2902275 -0.03199,0.1129277 M 6.6595063,3.4002204 6.4498689,3.4322104 M 6.8046111,3.4324421 6.6594439,3.4005412 M 6.9255407,3.4970371 6.8043705,3.433057 M 7.0303327,3.5696697 6.924008,3.4993629 M 7.0706544,3.6421954 7.0305554,3.5694824 M 6.9980304,3.722812 7.0709214,3.642525 M 6.7803824,3.8114933 6.9980931,3.7230082 M 6.6110935,3.8357487 6.7804092,3.8117784 M 7.2156612,3.4326827 7.248186,3.6261291 M 7.2401662,3.2633938 7.2169979,3.4328075 M 7.3853601,3.1585839 7.2401662,3.263269 M 7.5062986,3.0860315 7.3853601,3.1586552 m 0.4110947,-0.096799 -0.2901562,0.02397 m 0.6045856,-0.02397 -0.3144294,0 M 8.3284969,3.0940246 8.1108842,3.0621236 M 8.52197,3.1666394 8.3287375,3.0935701 m 0.2900403,0.1213752 -0.096888,-0.04803 m 0.096888,0.04803 0.4110858,0 M 9.207208,3.2390938 9.0297478,3.2156582 m 0.2499948,0.071822 -0.072713,-0.04803 m 0.088931,0.2576671 0,-0.2102166 M 9.1831843,3.642231 9.2939911,3.4956292 M 8.9331181,3.7228567 9.1825249,3.640431 M 8.6993589,3.7470052 8.933234,3.7232131 m -0.6208212,0.039832 0.3869461,-0.01604 m -0.6529538,-1.158e-4 0.2660077,0.01604 m -0.5159045,0.032346 0.2501374,-0.047228 m -0.4354838,0.087505 0.1852216,-0.040812 m -0.362566,-0.023703 0.1770949,0.065049 M 7.2483464,3.6259241 7.4339422,3.7708686 m 2.432484,-1.2651494 0.059347,0.1471097 M 9.6780769,2.5266508 9.8664619,2.5058885 M 9.5525315,2.6940774 9.6788076,2.5271588 m -0.1891068,0.449456 0.061129,-0.2829116 m -0.092522,0.4922015 0.031634,-0.2092632 m -0.042148,0.5232025 0,-0.3141175 m 0.073337,0.418758 -0.073248,-0.1047207 m 0.219689,0.1047207 -0.1465395,0 M 9.803551,3.437049 9.6673304,3.6043152 M 9.8663906,3.1859047 9.8031233,3.4369243 m 0.063267,-0.533557 0,0.2825374 M 9.9251133,2.6530428 9.866747,2.9034743 M 9.897668,3.0603236 9.962896,3.4052105 M 9.991589,2.8020417 9.894362,3.0590494 m 0.066119,0.7338023 0.031099,0.081891 m -0.031099,-0.4691669 0,0.3871957 M 1.004642,2.7758437 0.8052788,2.8197743 m 0.3812254,-0.00624 -0.1814345,-0.04001 m -0.75923396,-0.21289 -0.21078695,0.034753 m 0.4560501,-0.05302 -0.24528098,0.018 m 0.43604516,0.054624 -0.19098696,-0.072089 m 0.24548592,0.1902384 -0.054891,-0.1179266 m 0.009267,0.2178444 0.0453564,-0.099998 m -0.290646,0.1817128 0.24548592,-0.081089 M 0.24560405,2.9784059 0.44473556,2.9125545 M 0.11841902,3.0328781 0.24504267,2.977096 m -0.21021665,0.055782 0.08349498,0 m 0.24526315,0.2180315 0.081891,0.054089 M 0.32717428,3.1599651 0.3637089,3.250669 M 0.35444158,3.0055039 0.3284218,3.1601523 M 0.47251969,2.9509871 0.35448613,3.0056108 M 0.80541247,2.8214852 0.47336623,2.9531703 M 1.2809863,3.0781721 1.1814517,2.8149446 m 0.06202,0.4306987 0.036178,-0.1677563 M 1.017536,3.3325333 1.24332,3.245474 m -0.47105602,0.07797 0.24543242,0 m -0.57246183,-0.018178 0.32702941,0.018 M 1.9927342,3.5243846 2.0989341,3.5644836 M 1.9130085,3.4446411 1.9931174,3.523948 M 1.7371344,3.2308245 1.9133382,3.4443381 M 1.554292,3.1522305 1.7364215,3.2325175 M 1.362806,3.1141186 1.5543276,3.1521681 M 1.315115,3.0327534 1.362521,3.1143774 m -0.028426,-0.3329017 0,0.2520532 M 1.4819713,2.6491577 1.3331061,2.7803615 M 1.7800849,2.5278538 1.4819445,2.6491131 m 0.5904708,-0.1212593 -0.2923304,0 M 2.25843,2.6474468 2.0739391,2.5254924 M 2.3913091,2.8334793 2.2534043,2.6511626 M 2.4577486,3.0062257 2.3923427,2.833105 M 2.417917,3.2055443 2.4581051,3.006297 M 2.2717429,3.3915768 2.4144596,3.2029067 M 2.0989876,3.5643232 2.2724914,3.3923253 m -0.040634,0.6503876 0.1598791,0.1056652 m -0.1731652,-0.464453 0,0.3590284 M 2.3115478,3.4447391 2.2207637,3.6847805 M 2.6304594,3.2055443 2.3123854,3.4458352 m 0.5040887,-0.2402909 -0.1860147,0 M 3.0290877,3.3251373 2.8168661,3.2048849 M 3.2283975,3.4846153 3.0284283,3.3259838 M 3.308132,3.790223 3.2308747,3.4839648 m 0.06398,0.4790224 0,-0.1732632 M 3.1354035,4.0427129 3.29514,3.9635842 m -0.5849371,0.079129 0.4252006,0 M 2.3913002,4.1490019 2.710488,4.0435148 M 4.2182273,2.3873024 4.1707323,2.2930788 M 4.2810846,2.5995151 4.2170154,2.3876232 m 0.040545,0.5420669 0,-0.3310215 M 4.116064,3.0712038 4.2581748,2.9303049 M 3.8881058,3.0476167 4.1161264,3.070785 M 3.8173534,3.000389 3.888284,3.0472603 M 3.7858801,2.788114 3.8179593,3.0002821 m -0.032079,-0.3851284 0,0.1729603 M 3.8409494,2.4029054 3.787395,2.615528 M 3.9274741,2.2928471 3.8429989,2.4044737 m 0.084475,-0.1116266 0.2436948,0 M 3.5551684,4.2269899 3.7221138,4.190188 M 3.4624774,4.134317 3.5555604,4.226571 m -0.1116088,-0.5002213 0,0.4083501 M 3.5181794,3.4482144 3.4476943,3.7273389 M 3.7776465,3.2257096 3.5183398,3.4485263 M 3.9630819,3.1144573 3.7777267,3.2258255 M 4.3524341,3.244271 3.9627344,3.115482 M 4.5007825,3.5038539 4.353245,3.2438076 m 0.1475375,0.5010946 0,-0.2410483 M 4.3895034,4.0601247 4.4997399,3.744528 m -0.369766,0.3155967 0.2595829,0 m -0.5562351,0.055693 0.2965809,-0.05596 M 3.7220693,4.1900543 3.8335712,4.1162722 M 4.55922,4.4433551 4.8266624,4.5759312 M 4.4535993,4.150089 4.5638359,4.4416353 M 4.5007468,3.9489526 4.4538756,4.1501692 M 4.5748765,3.7820606 4.5023419,3.9496832 M 4.7416704,3.6337301 4.5741814,3.7813656 M 4.9641662,3.4668559 4.7422585,3.6344964 M 5.397048,3.3192026 4.962785,3.4627124 M 5.5453697,3.2450462 5.3967807,3.3187392 M 5.9097802,3.2814026 5.545432,3.2443334 M 6.1879067,3.3369976 5.9096911,3.2818393 M 6.3547719,3.6151241 6.1868463,3.3376214 m 0.1679256,0.5741906 0,-0.2966879 M 6.2435017,4.1713949 6.3555828,3.9121595 M 5.9097713,4.3568215 6.2441879,4.1726157 M 5.7428972,4.4680561 5.9102079,4.357472 M 5.6131102,4.449521 5.7429239,4.467967 m -0.5006312,-0.018446 0.3708175,0 M 4.8265109,4.5759045 5.2421679,4.4491026 M 0.20824072,3.1322077 0.03451414,3.0862276 M 0.29174461,3.2813225 0.20735854,3.1326444 m 0.0843861,0.4453481 0,-0.29667 m -0.0185346,0.8900368 0,-0.5936431 m 0,0.8717607 0,-0.2781176 m -0.0927356,0.3522918 0.0929762,-0.073782 m -0.2389988,0.03698 0.14613849,0.036356 M 1.3299962,3.3000086 1.4606921,3.559146 M 1.4041971,3.1887473 1.329613,3.2997145 m 0.1858454,-0.1109672 -0.1112702,0 M 1.7193928,3.3370957 1.5154138,3.1887829 M 1.9975104,3.6708528 1.717976,3.3382719 M 2.0716757,3.8377269 1.9991411,3.6700954 M 2.182839,4.0787752 2.0707579,3.8380923 m 0.09344,0.407557 0.018089,-0.1669276 M 1.9973678,4.30128 2.1643756,4.2461216 M 1.904659,4.2270523 1.9976263,4.3008344 M 1.6821186,4.0601782 1.9040442,4.2278097 M 1.6635751,3.856217 1.6829117,4.0601158 M 1.4596762,3.559538 1.6636642,3.8561903 m 1.6476936,-2.2144971 0.1112702,0 m 0,0 0.2594225,-0.1486068 m 1.159e-4,2.406e-4 0.1679612,-0.2960641 m -8.911e-4,-5.881e-4 0,-0.20396121 m 0,0 0.075743,-0.50039956 m -8.911e-4,-2.406e-4 0,-0.47061047 m -0.6767459,0 -0.00927,0.08126725 m -4.723e-4,-7.128e-5 -0.090445,0.53811932 M 3.1444837,0.64043073 3.0279204,1.102665 m 0.00535,8.911e-4 0,0.2595918 m 0,0 0.1120811,0.2406741 m -8.376e-4,3.475e-4 0.1669454,0.036713 m -1.2831315,-1.61991835 0.040901,0.0071287 m -5.35e-5,3.5643e-4 0.2782067,0.05515837 m -8.02e-5,4.8119e-4 0.241084,-0.03671284 m -4.46e-5,-3.5644e-4 0.129092,-0.02557423 M 3.1445639,0.08408865 3.097158,0.02144514 m -0.1357752,0 -0.094821,0.02610889 M 2.8664552,0.04709066 2.6248633,0.10028863 m 5.882e-4,0.001782 -0.1459247,0.096496 m -0.00267,-0.004455 0,0.12979593 m 0,0 0.09344,0.27788589 m -7.218e-4,2.3168e-4 0.2413958,0.25927106 m -3.564e-4,3.4752e-4 0.1670078,0.0551584 m -1.159e-4,4.7228e-4 0.093092,-0.0923613 m -3.564e-4,-3.4752e-4 0.072267,-0.33418485 m 0.00267,4.6336e-4 0,-0.40792241 M 0.45185536,0.0201887 0.68329772,0.23873703 m 8.1981e-4,-8.2872e-4 0.10631574,0 m -8.91e-6,0.001782 0.16721273,-0.19342854 m -3.3862e-4,-2.315e-4 0.0388515,-0.02566335 M 0.03514681,0.72835441 0.06642401,0.58347236 M 0.0673151,0.58370405 0.0349686,0.48774275 M 1.1679963,0.0204293 0.90142723,0.21264596 m 2.2278e-4,2.4059e-4 -0.1118405,0.16644639 m 7.0396e-4,4.6337e-4 -0.0919425,0.22282554 m -8.2871e-4,-3.5643e-4 0,0.16687411 m 0,0 0.0559603,0.0924593 M 0.753364,0.86183944 0.90176585,0.82512661 M 0.90167674,0.82477908 1.1807389,0.60343274 M 1.1798478,0.60254165 1.471697,0.40962994 m 0.00446,0.007129 0.1118494,-0.14787611 m -5.881e-4,-4.6336e-4 0.093199,-0.1108603 m -4.723e-4,-3.4753e-4 0,-0.13686225 m -1.00122683,0.69312414 0,-0.18542657 m 0,0 -0.0356435,-0.25978789 m -8.9109e-4,2.406e-4 -0.0745841,-0.11094941 M 0.56824931,0.15720244 0.4124247,0.02475999 m 7.128e-5,-6.238e-5 -0.003564,-0.0044554 M 0.03509335,0.32203596 0.23678228,0.54421101 m -0.002673,0.001782 0.16788104,0.25893244 M 0.40109923,0.8056205 0.56811592,0.8607789 M 0.56799981,0.86124241 0.67984921,0.7133574 M 2.3106567,0.15662324 2.0325035,0.1199104 m 2.67e-5,-3.4753e-4 -0.1668652,0 m 0,0 -0.1860325,0.14755532 m 5.881e-4,8.2871e-4 -0.1493464,0.2961532 m 8.911e-4,4.7228e-4 0,0.16687411 m 0,0 L 1.63948,1.1588124 m 0.00356,-8.91e-4 0.1676583,0.1847047 m -8.109e-4,7.04e-4 0.2219255,0.1676494 m 5.792e-4,-7.129e-4 0.1675959,0.1661612 m -6.95e-4,7.129e-4 0.093083,0.092361 m -3.476e-4,3.475e-4 0.1854088,0 m 0,0 0.1482147,-0.05596 m 1.069e-4,3.475e-4 0.1675068,-0.1476266 M 2.792682,1.5658972 2.9046472,1.3994776 m -7.217e-4,-4.723e-4 0,-0.3522918 m 0,0 -0.054624,-0.12654341 M 2.8488206,0.92040177 2.6636079,0.77076131 M 2.6637148,0.77063655 2.5133793,0.62156639 M 2.5142704,0.6206753 2.422916,0.49991501 m -0.00267,8.9109e-4 0,-0.2410483 m 0,0 L 2.3091953,0.15696185 M 1.4566555,0.79667416 1.1970903,0.74989202 m 0,4.455e-5 -0.1668919,0.0184455 m 8.9e-6,1.1584e-4 -0.18529289,0.16700778 M 0.84479857,0.93538987 0.78874912,1.083569 m 4.7227e-4,1.158e-4 0,0.1854176 m 0,0 0.13734345,0.1134891 m 4.7227e-4,-7.04e-4 0.16473549,-0.054445 m 5.97e-4,0.00178 0.2201078,-0.089563 m 0,0 0.088574,-0.1003187 m 3.57e-5,3.56e-5 0.1244494,-0.1069484 m 1.069e-4,1.247e-4 -0.071109,-0.23515816 m -1.20297818,-0.0287822 -0.1297781,0 m 0,0 -0.08795042,0.0580099 m 0,1.70340446 0.05079204,0 m 0,0 0.2227899,-0.092049 m -2.406e-4,-6.95e-4 0.16687411,0 m 0,0 0.0929762,-0.073782 M 0.56667209,2.363145 0.67862842,2.1595759 m -7.0396e-4,-3.475e-4 0,-0.4083501 m 0.0185346,4.722e-4 0,-0.4821055 m 0,0 -0.074495,-0.073871 m 3.4752e-4,-3.475e-4 0,-0.20395232 m 0,0 L 0.47445336,0.86075232 M 0.47397217,0.86134043 0.30696439,0.80618207 M 0.30708024,0.80570979 0.251209,0.76890784 M 1.5307227,1.7514218 1.6977305,1.6962635 m -1.159e-4,-4.634e-4 0.093083,-0.092352 M 1.790359,1.6030917 1.808983,1.5289527 M 1.8088759,1.5289171 1.6971424,1.418137 m 4.722e-4,-4.723e-4 -0.074584,-0.1109494 m 4.633e-4,-2.406e-4 -0.093208,-0.1108603 m 4.723e-4,-3.475e-4 -0.1112702,0 m 0,0 -0.2445681,0.1616612 m 0.00356,0.00535 -0.22268296,0.073693 m 2.3169e-4,5.971e-4 -0.11161773,0.092254 m 3.5644e-4,4.722e-4 -0.0920583,0.1672484 m -6.9504e-4,-3.564e-4 0,0.1854354 m 0,0 0.0373366,0.1111544 m -2.406e-4,8.02e-5 0.1112702,0 m 0,0 0.1271761,-0.094527 m 1.158e-4,2.406e-4 0.095159,-0.072535 m 3.57e-5,5.35e-5 0.2415651,-0.053198 m -5.881e-4,-0.00178 0.166883,-0.018446 m 0.5376916,0.018446 -0.5006401,0.036713 m 2.67e-5,3.475e-4 -0.482658,0.1276217 m 5.971e-4,0.00178 -0.24061167,0.204478 m -4.7228e-4,-4.723e-4 -0.20287408,0.223485 m -8.9109e-4,-8.911e-4 0,0.1668741 m 0,0 0.11150188,0.073782 m -2.3168e-4,4.723e-4 0.50061342,0 m 0,0 L 1.6980067,2.494937 M 1.697775,2.4940459 2.0306411,2.3620401 m 8.109e-4,0.00178 0.2592354,-0.2784473 m 3.653e-4,3.475e-4 -0.037337,-0.2224513 m 3.48e-4,-5.12e-5 L 2.068343,1.7711683 M 2.9030076,1.6592833 2.568805,1.8065535 m 4.633e-4,8.91e-4 -0.20168,0.1333158 m -0.00267,-0.00267 -0.056049,0.2038454 m 4.723e-4,1.069e-4 0,0.2232711 m -0.018535,-7.04e-4 0.026644,0.1402752 m 8.91e-5,-1.79e-5 0.1039098,0.1373435 m -7.04e-4,5.881e-4 0.091363,0.241574 m 8.911e-4,-4.812e-4 0.1296979,0.092878 m 1.069e-4,-1.248e-4 0.1665979,0.1301435 m 2.406e-4,-3.475e-4 0.2039701,0.1483127 m -2.67e-5,2.67e-5 0.1670256,0.055158 m -1.159e-4,4.634e-4 0.2966523,0 m 0,0 0.111386,-0.036713 m -8.91e-5,-2.406e-4 0.056049,-0.1667493 M 3.644022,3.1065915 3.735394,2.8650353 m 8.911e-4,4.634e-4 0,-0.4450006 m 0,-8.9e-6 -0.036713,-0.3152582 m -3.475e-4,5.35e-5 -0.05605,-0.1667404 m 4.7e-4,-1.185e-4 -0.2408255,-0.1857117 m -2.317e-4,2.317e-4 -0.2039434,0 m 0,0 -0.1672216,-0.092049 m 3.475e-4,-5.882e-4 -0.129787,0 M 5.0591206,0.11571337 5.1489958,0.08595102 m -8.02e-5,-2.3168e-4 0.064782,-0.06433658 m -1.1727881,0 0,0.06433658 m 0,0 0.1198425,0.02976235 m -6.24e-5,2.3168e-4 0.3051977,0 m -8.91e-5,-0.00802 0.082247,0.0218317 m -8.02e-5,3.5644e-4 0.076901,0.0457128 m 1.78e-5,-4.456e-5 0.2096464,0 m 0,0 0.2247235,-0.0593465 M 4.5350537,0.220541 4.4449558,0.1610163 m 2.317e-4,-3.4752e-4 -0.1947028,0.0142574 m 4.45e-5,7.0396e-4 -0.1799018,0.0743168 m 2.317e-4,5.8811e-4 -0.090437,0.19436419 m 5.792e-4,3.5643e-4 -0.073693,0.38954817 m -8.911e-4,-2.3168e-4 0,0.0598811 m 0,0 0.030119,0.0897682 m -2.406e-4,8.02e-5 0.059703,0.0451782 m 1.158e-4,-2.406e-4 0.2096374,0 m 0,0 0.089866,0.029762 m -7.13e-5,2.228e-4 0.1048276,-0.029762 m -7.13e-5,-2.495e-4 0.1341623,-0.19506822 m 5.881e-4,4.6336e-4 0.028871,-0.20978892 m 8.911e-4,1.0693e-4 0,-0.2245899 m 0,-8.91e-6 -0.030297,-0.1796434 M 4.8791742,1.6109328 5.0736631,1.50803 m 1.159e-4,3.564e-4 0.1353385,-0.1341801 m -5.792e-4,-5.881e-4 0.075475,-0.2244206 m -5.882e-4,-2.317e-4 0,-0.26994627 m 0.01497,3.5643e-4 0,-0.26953639 m 0,0 -0.090561,-0.26930472 M 5.2085472,0.34029436 5.0732087,0.20612319 m 5.881e-4,-5.8812e-4 -0.1347771,0.0147921 m 8.9e-6,1.0693e-4 -0.1945246,0.12001178 m -1.158e-4,-2.3169e-4 -0.090321,0.10443555 m 4.633e-4,3.4753e-4 -0.045356,0.26947402 m 3.387e-4,7.128e-5 -0.074228,0.17993747 m -5.881e-4,-2.4059e-4 0,0.22460765 m 0,0 0.030297,0.1796613 m -2.406e-4,3.56e-5 0.1355791,0.2090939 m -8.109e-4,5.97e-4 0.1047118,0.089982 m 1.069e-4,-1.247e-4 0.074941,0.012475 M 4.1254917,2.2166234 3.9022295,2.0321414 M 3.9030493,2.0312503 3.7354713,1.8650891 M 3.7361752,1.864394 3.6442327,1.6415685 m -8.109e-4,3.475e-4 0.037337,-0.1111544 m -2.406e-4,-8.91e-5 0.1298673,-0.036713 m -6.24e-5,-3.565e-4 0.092735,0 m 0,0 0.2409325,0.1114752 m 1.069e-4,-2.317e-4 0.037247,0.03698 m -1.158e-4,1.158e-4 0.2226919,0.073693 M 4.40368,1.7162234 4.478353,1.8642956 m -4.723e-4,2.317e-4 0.037337,0.1853552 m -3.475e-4,6.24e-5 -0.05605,0.1481791 m 4.634e-4,1.248e-4 -0.2225137,0.018446 m 8.9e-6,1.158e-4 -0.1112702,0 m 0.5798758,-0.403663 -0.1348663,0.00624 m 0,-3.56e-5 L 4.4595875,1.6605843 M 4.459231,1.6608071 4.3662549,1.5870249 M 4.3666024,1.5866774 4.1435273,1.4392379 M 4.1441155,1.4384092 3.9388176,1.384142 m -3.653e-4,8.91e-4 -0.050703,-0.1676048 m 4.723e-4,-1.158e-4 0.086792,-0.1146207 m 0.00267,0.00178 0.2781532,0.036713 m -3.56e-5,3.565e-4 0.1675959,0.1661612 m -7.04e-4,7.04e-4 0.1665979,0.1301345 m 2.316e-4,-3.564e-4 0.1601108,0.2419126 m 3.56e-5,-2.67e-5 -0.043307,0.1334048 M 4.6265239,3.106981 4.9049801,3.2174136 m -3.653e-4,8.287e-4 0.3518818,0.058099 m 4.723e-4,-0.00178 0.389263,-0.2412176 m 9.81e-5,1.069e-4 0.2550918,-0.3371967 m 0.00446,0.00267 0.112081,-0.2592354 M 6.0171385,2.4393331 6.0942177,2.0319453 M 6.0915444,2.0313572 6.035495,1.7533109 m 4.722e-4,-8.02e-5 -0.2219166,-0.1676493 m -5.881e-4,7.039e-4 -0.2415741,-0.053198 m 5.882e-4,-0.00178 -0.2781265,0 m 0,0 -0.2597434,0.073604 m 1.07e-4,5.881e-4 -0.2219078,0.1676404 m -5.97e-4,-8.287e-4 -0.1673196,0.110593 M 4.6453615,1.883617 4.5334052,2.1057297 M 4.534225,2.106075 4.4035291,2.3652213 m 8.911e-4,4.723e-4 0,0.446551 m -0.03698,-8.91e-4 0.056049,0.1667404 m -4.812e-4,1.158e-4 0.2016889,0.1333069 m 1.1889079,-2.0802457 -0.2781176,0 m 0,0 -0.1624187,0.017911 m -8.9e-6,-1.159e-4 -0.075921,0.1505226 m -0.00267,-8.91e-4 0.018089,0.1669364 m 4.723e-4,-6.23e-5 0.1671147,0.073693 m -2.317e-4,5.881e-4 0.4264481,0 m 0,0 0.074495,-0.073871 m -3.475e-4,-3.476e-4 0,-0.1668741 m 0,0 -0.074584,-0.1109583 m 4.723e-4,-2.317e-4 -0.092638,-0.055693 m -0.4635441,-0.37078183 0,-0.61189253 m 0,0.61189253 0.086257,0.28474727 m -8.109e-4,2.3168e-4 0.2025354,0.0446435 m -2.406e-4,8.2871e-4 0.3070602,-0.0737821 m 1.78e-5,6.237e-5 0.1864335,-0.1232286 M 6.1287971,0.7901432 6.4251107,0.65957203 M 6.425453,0.6603822 6.5930489,0.49422096 M 6.5923271,0.49352591 6.7599319,0.32736467 M 6.759228,0.32666071 6.7948715,0.06687282 m 8.911e-4,2.4951e-4 -0.00927,-0.04410888 m -1.4090691,0 -0.02798,0.02593067 M 7.8647122,2.0075473 7.7715043,1.896687 m 4.812e-4,0.3704344 0.097458,-0.2578186 m -0.4869084,0.2578186 0.3893966,0 M 6.8633962,2.1187908 7.3829096,2.2659451 M 6.3627917,1.9333731 6.8631556,2.1194057 M 6.2515215,1.7664901 6.3634868,1.9329098 M 6.2701631,1.5995982 6.252074,1.7665347 M 6.325767,1.5625378 6.269896,1.5993398 m 0.055871,-0.036802 0.3893699,0 M 7.0303416,1.5996071 6.715226,1.5616467 M 7.1972603,1.6551397 7.0301901,1.5999814 M 7.5309639,1.7664278 7.1969038,1.6560219 M 7.7720033,1.8962237 7.5308481,1.766704 M 7.5865411,0.11617674 7.6873321,0.02298672 M 7.4197294,0.20889448 7.5868886,0.11674703 M 7.0741208,0.40608341 7.4203353,0.20993705 m -0.5229975,0.19677012 0.176783,0 M 6.8174071,0.25166672 6.895912,0.40742896 m -0.059079,-0.38448679 0,0.22930375 M 9.0741507,0.09495101 9.1068536,0.02295108 M 8.8666786,0.16947273 9.0740972,0.09471042 m -0.6416905,0.11971772 0.4342719,-0.044198 m -0.673841,0.044198 0.2395691,0 m -0.4042957,-0.0898752 0.1643613,0.09049 M 7.9383428,0.07959756 8.028209,0.12424109 M 7.938343,0.0228887 l 0,0.05667322 m 0.5689064,0.23958692 -0.045089,0.0746732 M 8.687053,0.22928258 8.5070354,0.31852507 m 0.1800176,-0.0892425 0.3592957,0 m 0.089866,0.0898752 -0.090214,-0.0894653 m 0.090214,0.2991027 0,-0.20964634 m -0.089866,0.34441454 0.09033,-0.13442067 m -0.539554,0.13442067 0.4491798,0 m -0.5390728,-0.0749405 0.090098,0.074495 M 8.4623205,0.39396461 8.5075878,0.58853375 M 8.4950238,1.0616838 8.662183,1.1353768 m -0.1744394,-0.25827301 0,0.18476711 M 8.6062669,0.80214544 8.4893205,0.8794919 M 8.8844023,0.7836108 8.6062669,0.80205633 m 0.5377362,-0.0184455 -0.2596008,0 M 9.3850336,0.89487209 9.1441279,0.78338803 M 9.4221474,0.96903737 9.3848108,0.89498793 M 9.3850425,1.1173768 9.4223791,0.96911757 M 9.1439853,1.1730075 9.3856217,1.1198095 m -0.4641055,0.053198 0.2224691,0 m -0.4820521,-0.037158 0.259583,0.036713 m -1.8170806,3.743e-4 0,-0.53773616 M 7.3640007,0.30144291 7.1089356,0.63865746 M 7.6606975,0.19019053 7.3642324,0.30213796 m 0.5746183,-0.11194743 -0.2781532,0 M 8.2725455,0.33853001 7.9383606,0.19125093 m 0.426858,0.3141621 -0.091933,-0.1672751 M 8.4394641,0.74645242 8.3663949,0.5050655 m 0.073069,0.5195312 0,-0.27814428 M 8.3281939,1.2841797 8.4401592,1.0249443 M 8.2168435,1.3398192 8.3283454,1.2845717 M 8.1056268,1.4139845 8.2172445,1.3402024 M 8.0315328,1.6178833 8.1082555,1.4148934 M 7.8645518,1.6920575 8.031711,1.6183645 m -0.3896283,0.073693 0.2224691,0 M 7.4381749,1.6178299 7.6418421,1.6926813 M 7.21559,1.4509825 7.4375779,1.6186229 M 7.1043821,1.1728649 7.2164543,1.4506528 M 8.6062224,2.6933111 8.4391968,2.7484695 M 8.8102638,2.6191191 8.606463,2.6938814 M 8.9310776,2.4622073 8.8116004,2.620126 M 9.1399576,2.4065856 8.9309617,2.4618331 M 9.2737545,2.5078132 9.1398417,2.4066747 M 9.351395,2.5819696 9.2736921,2.5077419 M 9.4775998,2.8044209 9.3514485,2.5819072 m 0.096193,0.3893967 0.031366,-0.1666157 M 9.3293227,3.0471177 9.4465009,2.969593 m -0.3026404,0.1516454 0.185587,-0.073693 m -0.4113353,0.099383 0.2258731,-0.024861 m -0.5225877,0.024861 0.2967146,0 M 8.4763195,3.0638794 8.6213976,3.1469284 M 8.4393305,2.859891 8.4777365,3.063576 m -0.038406,-0.3149552 0,0.1112702 m 1.5388471,-2.46611362 0.010337,0.0419703 m -0.047673,-0.20886219 0,-0.2044513 M 9.885148,0.57918623 9.9385242,0.22653803 M 9.8666134,0.74606034 9.8847024,0.57914167 M 9.6998373,0.85731272 9.8671035,0.74672865 m -0.5010947,0.11058407 0.3338285,0 M 9.2176605,0.69043861 9.3654029,0.85784737 M 9.1621011,0.4493903 l 0.05605,0.24094137 m -0.05605,-0.5746985 0,0.33375713 m 0.016129,-0.42695605 -0.017554,0.09287813 m 0.05694,1.94718842 0.091934,0.2228344 m -0.091934,-0.2228344 0,-0.556253 M 9.3845257,1.1724817 9.2165199,1.5056597 M 9.5328651,1.0055987 9.3851227,1.1730075 M 9.8851391,0.85725925 9.5327582,1.0054651 M 9.9884875,0.8421553 9.8851569,0.85685826 M 9.755361,2.4519509 9.9885142,2.3748718 m -0.437061,0.09556 0.2039078,-0.019248 M 9.3104317,2.2850055 9.5512126,2.4707261 M 7.9198081,2.3962312 8.10601,2.5808557 M 7.8641419,2.2478917 7.9201913,2.3960708 M 7.9754388,1.9697652 7.8633666,2.2475531 M 8.1980416,1.5803863 7.9766596,1.9704424 M 8.3833879,1.339338 8.1999841,1.5818566 M 8.605866,1.2837074 8.3832632,1.3388658 M 8.9396855,1.302242 8.605866,1.2837965 M 9.05092,1.4505191 8.9390795,1.3026341 M 9.1435932,1.6173843 9.0515438,1.4501449 m 0.092049,0.6678885 0,-0.5006491 M 9.0879002,2.2849075 9.1441279,2.118176 M 8.7542589,2.470343 9.0886933,2.2861372 M 8.494667,2.6186735 8.7541341,2.4700667 M 8.1052882,2.5815864 8.494667,2.6182993 m -2.0005645,5.926566 0,-0.156484 M 6.6004271,8.8165403 6.4972035,8.5436534 M 6.7834834,8.9759917 6.601345,8.8154621 M 7.0669564,9.0409609 6.7829488,8.9783174 m 0.504151,-0.071376 -0.2199919,0.134189 M 6.6843766,4.009903 6.6936466,3.919092 m -0.00446,0.2308008 0,-0.1400791 M 6.7292874,4.389872 6.6890102,4.1499553 m 0.09033,0.4499105 -0.048921,-0.2102255 M 6.8193497,4.8498339 6.7772903,4.6001866 M 6.9161041,5.0687209 6.8211764,4.8490141 M 7.0967901,5.8929597 7.1670078,5.6919124 M 7.0023347,5.9933587 7.0970307,5.8931558 m -0.2482662,0.088396 0.1535969,0.011317 m -0.330763,-0.087951 0.1766939,0.077881 m -0.1944177,-0.2904681 0,0.2133533 M 6.7069835,5.5151561 6.65334,5.6921975 M 6.8427586,5.3084504 6.7081865,5.5159759 M 7.0789772,5.3616038 6.8425002,5.3095642 M 7.1675425,5.467973 7.0784336,5.3620315 m 0.089109,0.3303621 0,-0.2244206 M 6.2815957,8.1807221 6.4000481,8.0688727 M 6.1044206,8.145328 6.2816581,8.1804369 M 6.0512672,7.8795253 6.1049107,8.1452211 M 6.1044563,7.5960612 6.0509019,7.8794451 M 6.2048909,7.3834386 6.1044474,7.5960077 m 0.3485314,-0.2184681 -0.2481058,0 m 0.3544126,0.106289 -0.106788,-0.1058434 m 0.1126514,0.3361809 0,-0.2304088 M 6.4884262,7.9090649 6.5625648,7.7131413 M 6.3998699,8.0685251 6.4878203,7.9086995 M 6.7074112,5.9900973 6.5957935,5.8978518 M 6.8186814,6.0086319 6.7074023,5.9901864 M 6.929916,6.2310832 6.8179596,6.0089616 m 0.1119564,0.6671311 0,-0.4450095 m -0.03698,0.760232 0.036713,-0.3152581 m -0.036713,0.5563064 0,-0.2410483 M 6.7631666,7.343607 6.8928021,7.2322031 m -0.2965185,0.1114039 0.166883,0 M 6.4850312,7.288003 6.5964172,7.34325 m -0.25977,-0.1294038 0.14858,0.073693 M 6.2624819,7.1026121 6.337066,7.2135883 m -0.1302415,-0.2036761 0.05605,0.092459 m 0.055247,-0.389165 -0.1120721,0.2963582 m 0.1120721,-0.2963582 0,-0.4264659 m 0.055604,-0.1854177 -0.056049,0.185284 M 6.4849777,5.9344399 6.3730214,6.1008774 M 6.5961856,5.8973528 6.4847995,5.9340656 M 9.9886212,4.8271825 9.9030767,4.940315 m -8.911e-4,-8.91e-4 -0.036089,0.1671057 m -8.911e-4,-2.405e-4 0,0.166883 m 0,0 0.1243336,0.1408454 m 0,-1.2649801 -0.088307,-0.1360781 m 8.911e-4,-7.039e-4 -0.092058,-0.1672484 m -7.04e-4,3.475e-4 -0.072445,-0.1676315 M 9.7360244,3.678427 9.587676,3.6599815 m 0,-1.247e-4 -0.352274,0.017911 m 0,5.971e-4 -0.2035424,0.1120811 m -3.564e-4,-8.29e-4 -0.056228,0.1667405 m 4.812e-4,1.247e-4 0,0.2225048 m 0,0 -0.1117335,0.1107623 m 4.722e-4,4.901e-4 -0.056049,0.2594849 m 3.564e-4,9.8e-5 0.028426,0.205779 m 8.911e-4,-1.158e-4 0.1119564,0.2221216 M 8.9493805,4.9779546 9.1525486,5.1458 m 7.129e-4,-8.911e-4 0.1928583,0.036356 m 1.158e-4,-8.911e-4 0.2968483,-0.073604 m -1.248e-4,-5.97e-4 0.167284,-0.1105841 M 9.8097708,4.9948764 9.9217361,4.8284389 M 9.9210232,4.8279755 9.9898152,4.7069301 M 8.790143,4.216083 8.9017518,4.1238286 m -3.475e-4,-4.812e-4 0,-0.2072582 m -0.00535,8.02e-5 -0.097467,-0.076099 m 1.159e-4,-2.406e-4 -0.1566088,-0.012921 m -0.6675143,-2.406e-4 0.6675143,0 m -0.6675143,0 -0.1670434,0.055158 m 1.28e-4,4.64e-4 L 7.69594,3.9930703 m 4.634e-4,4.634e-4 0,0.2225226 m 0,0 0.056049,0.1110474 m -3.387e-4,2.406e-4 0.222585,0.055158 m -1.159e-4,4.722e-4 0.1116089,-0.092254 m -3.56e-4,-4.633e-4 0.1671593,-0.073693 m -2.406e-4,-5.792e-4 0.5377361,0 M 8.6791045,4.382868 8.5860125,4.290516 m 3.654e-4,-3.475e-4 -0.1853553,0 m 0,0 -0.1670345,0.055158 m 1.158e-4,4.633e-4 -0.1670345,0.055158 m 1.158e-4,4.634e-4 -0.1459246,0.096496 m -0.00267,-0.00446 0,0.1668741 m 0,0 0.096202,0.1272028 m -0.00356,0.00267 0.1857117,0.092041 m -3.564e-4,5.881e-4 0.1482325,-0.05596 m 1.07e-4,3.564e-4 0.1669186,-0.036713 m 0,-3.475e-4 0.1667939,0 m 0,0 0.074673,-0.1852038 M 8.7528332,4.6047223 8.67816,4.3824136 m 0.1118404,0.5746183 -0.278269,-0.055158 m 1.158e-4,-4.812e-4 -0.1669186,0 m 0,0 -0.2037919,0.056049 m -1.07e-4,-4.634e-4 -0.071733,0.094732 m -0.00267,-0.00178 0.05596,0.07396 m -2.317e-4,2.406e-4 0.2228256,0.1105039 m -3.476e-4,7.04e-4 0.278278,0.055158 m -1.247e-4,4.812e-4 0.1671592,0.092156 m -2.406e-4,5.881e-4 0.129787,0 m 0,0 0.093092,-0.092361 m -3.386e-4,-3.475e-4 0,-0.1112524 m 0,0 -0.096202,-0.1272029 m 0.00356,-0.00267 -0.129787,-0.092869 m 0.8483873,0.2730473 -0.1623028,0.061218 m -1.158e-4,-4.723e-4 -0.2225939,0 m 1.248e-4,0.00802 -0.1112702,-0.00446 m 0,1.158e-4 -0.1117336,0.088574 m 4.634e-4,4.723e-4 -0.056228,0.1667315 m 4.634e-4,1.069e-4 0,0.1668741 m 0,0 0.1120721,0.2778146 m -8.109e-4,3.565e-4 0.081802,0.1756068 m -7.04e-4,3.564e-4 0.1848563,0.3665848 m -0.00267,8.911e-4 0.1623028,0.2360404 M 9.5124147,6.774656 9.79456,7.0411538 m 8.108e-4,-8.198e-4 0.1064405,0 m 0,0.00178 0.087238,-0.1008356 m 0,-0.7968112 -0.014079,-0.018535 m 8.911e-4,-6.951e-4 0,-0.5191748 m 0,0 -0.127854,-0.2365991 M 9.8488985,5.368982 9.6379601,5.2295534 M 8.8568944,5.56716 8.7180005,5.4295404 M 8.7188916,5.4286493 8.4735037,5.3843622 M 8.4736195,5.383783 8.0650734,5.2938009 m 5.792e-4,-0.00267 -0.2595741,0 m 0,0 -0.3506967,0.1159217 m -8.911e-4,-0.00535 -0.2224691,0.3151868 m 0,2.67e-5 -0.09344,0.2778948 m 7.218e-4,2.406e-4 0,0.2232711 m -0.018535,-8.198e-4 0.018089,0.1669365 m 4.723e-4,-5.35e-5 0.093092,0.073782 m -3.653e-4,3.475e-4 0.074584,0.1109494 m -4.634e-4,3.564e-4 0.037337,0.092557 m -2.406e-4,1.158e-4 0.2221127,0.1304732 M 7.5657336,6.792272 7.8067641,6.717866 m 0,1.07e-4 0.500854,-0.1103435 M 8.3073959,6.6067393 8.5861462,6.4593979 M 8.5855491,6.4585068 8.807546,6.2908485 m 4.633e-4,8.376e-4 0.1583108,-0.2092899 m -0.00535,-0.00446 -0.03698,-0.293676 M 8.9248845,5.7841489 8.8587657,5.5659838 M 8.6837293,6.5961532 8.4004879,6.6812521 m -1.158e-4,-4.723e-4 -0.2783849,0.091943 m 2.406e-4,7.129e-4 -0.2595919,0 m 0,0 L 7.640648,6.9410756 M 7.6401757,6.9402558 7.5282105,7.1066844 m 7.128e-4,4.723e-4 -0.1295553,0.2226384 m -2.406e-4,-1.247e-4 0,0.1112612 m 0,0 0.074673,0.2222998 m -5.881e-4,2.495e-4 0.167284,0.1105841 m -3.653e-4,7.04e-4 0.1667939,0 m 0,0 0.1863265,-0.054713 m 0,-8.91e-5 0.2224692,-0.018445 m 0,-1.158e-4 0.1669186,0 m 0,0 0.3720294,0.1229612 m -0.00267,0.00624 0.092745,-0.036713 M 8.8446242,7.7936511 9.0112933,7.6635255 m 2.228e-4,3.475e-4 0.129689,-0.1114127 m 1.158e-4,1.247e-4 0.036,-0.1670969 M 9.178212,7.3857198 9.122162,7.2189883 M 9.1226259,7.2188635 9.0305765,7.0516062 M 9.0299973,7.0519716 8.9023845,6.8833688 m -0.00267,0.00178 -0.065138,-0.2582374 M 8.8336854,6.6271431 8.682539,6.5964901 m 1.3057117,0.4542679 -0.08795,0.130687 m 7.04e-4,4.723e-4 -0.091943,0.2228166 m -8.109e-4,-3.475e-4 0,0.166883 m 0,0 0.056049,0.092468 M 9.863949,7.663971 9.9882826,7.6332285 m -0.1984543,-0.1175346 0,-0.1854354 m 0,0 -0.035733,-0.259779 M 9.7532045,7.0707112 9.6786205,6.9597618 M 9.6789769,6.9595123 9.5232236,6.8270876 m 0,-7.13e-5 -0.123496,-0.1632919 M 9.4006187,6.6629135 9.2329694,6.4967523 m 7.128e-4,-7.129e-4 -0.092504,-0.2040058 m -1.248e-4,5.35e-5 -0.074495,-0.073871 m 2.317e-4,-3.475e-4 -0.09262,0 m 0,0 -0.05605,0.1296177 m 4.634e-4,1.247e-4 0,0.259583 m 0,0 0.1104682,0.3896105 m 7.04e-4,-2.406e-4 0.3176908,0.3500284 m -0.00267,0.00178 0.16789,0.2589414 m -8.911e-4,7.039e-4 0.1670256,0.055158 m -2.228e-4,4.723e-4 0.1119563,-0.1478762 m 0.1978484,0.1938207 -0.031545,0.028426 m -1.158e-4,-1.248e-4 -0.056049,0.1481702 m 4.722e-4,1.337e-4 0,0.1854087 m 0,0 0.087238,0.072 m -0.624947,-0.5726935 -0.1297959,0 m 0,0 -0.1672751,0.1106019 m 3.564e-4,6.95e-4 -0.2234582,0.2215513 m 8.911e-4,8.911e-4 -0.037426,0.3708086 m 2.495e-4,2.67e-5 -0.1264009,0.5015045 m -0.00356,-8.198e-4 0,0.2410483 m 0,0 0.1606098,0.3184572 m 0.00535,-0.00267 0.3522651,0 m 0,0 0.2228255,-0.092049 m -2.317e-4,-7.04e-4 0.1667939,0 m 0,0 0.092967,-0.073782 M 9.6772482,9.1661232 9.7893204,8.9625719 m -7.04e-4,-3.475e-4 0,-0.408368 m 0.018356,4.812e-4 0,-0.4820966 m 0,0 -0.074495,-0.073871 m 3.654e-4,-3.476e-4 0,-0.2039701 m 0,0 L 9.5849671,7.6637305 M 9.5844948,7.6642027 9.4174692,7.6090444 M 9.4177098,7.608581 9.3618386,7.571779 M 8.3421573,7.7940699 8.059406,7.887456 M 8.0590674,7.8865649 7.8591518,8.0715192 m 8.911e-4,8.911e-4 -0.1117336,0.1107712 m 4.723e-4,4.723e-4 0,0.223271 m -0.018535,-6.95e-4 0.05596,0.092459 m -2.406e-4,2.317e-4 0.2224691,0.018446 m 0,1.07e-4 0.2410305,0 m 0,0 0.2037919,-0.05605 m 1.158e-4,4.634e-4 0.2219879,-0.1676316 m 4.634e-4,6.951e-4 0.073871,-0.1300098 m 3.475e-4,2.228e-4 0,-0.1668741 m 0,0 L 8.67546,7.8873402 m 3.564e-4,-3.476e-4 -0.1671593,-0.092156 m 3.565e-4,-5.792e-4 -0.1669187,0 m 1.6447441,0.5108163 -0.03199,0.026465 m 3.565e-4,4.722e-4 -0.091934,0.1672662 m -7.129e-4,-3.564e-4 0,0.1854355 m 0,0 0.037426,0.1111543 m -2.495e-4,9.81e-5 0.087238,0 m 0,0.122382 -0.031188,0.026465 M 9.9553123,8.9439838 9.7524917,9.1674865 m -8.911e-4,-8.91e-4 0,0.1668919 m 0,0 0.111493,0.073782 m -2.317e-4,4.634e-4 0.1243335,0 M 8.5128809,8.5548009 8.3610216,8.5731574 m -0.7787666,2.317e-4 0.7787666,0 m -0.7787666,0 -0.1296801,0.1114216 m -1.248e-4,-1.336e-4 0,0.1483484 m 0,0 0.1407207,0.1673642 m 5.881e-4,-4.723e-4 0.1925108,0 m 0,0 0.3136809,-0.01595 m 0,-2.317e-4 0.3307987,-0.062465 m 2.228e-4,8.911e-4 0.1899711,-0.12559 M 8.6205867,8.7958582 8.6008046,8.6133276 m -2.317e-4,3.57e-5 -0.08795,-0.058099 M 7.2856384,6.7192036 7.1185594,6.6640452 m 1.247e-4,-4.723e-4 -0.111493,0.055248 m 2.317e-4,3.564e-4 -0.056049,0.2223889 m 4.722e-4,0.5007471 0,-0.5006401 m 0,0.5006401 0.018089,0.1669365 m 4.812e-4,-4.45e-5 0.1668563,0 m 0,0 L 7.28628,7.461498 M 7.285683,7.460794 7.3603562,7.2755991 M 7.359777,7.2753585 7.4718491,7.016132 M 7.4710293,7.0157578 7.4524056,6.904541 m 1.158e-4,-1.78e-5 -0.037337,-0.1111544 M 7.4155413,6.793253 7.2857453,6.7189362 M 7.248587,5.2542455 7.4710561,5.2357999 m 0,-1.158e-4 0.3710581,-0.091943 m -2.228e-4,-7.04e-4 0.072356,-0.1676315 m 0.00267,7.04e-4 0,-0.1854177 m 0,0 -0.056139,-0.2224067 m 4.633e-4,-9.81e-5 0,-0.1112612 m 0,0 -0.1671503,-0.09205 m 2.317e-4,-5.881e-4 -0.16789,-0.2960552 M 7.5273283,4.0676544 7.3608908,3.8633368 m -4.633e-4,3.475e-4 -0.2968127,-0.073604 m 1.248e-4,-5.792e-4 -0.1669008,0.018445 m 2.67e-5,1.159e-4 -0.2034978,0.1120989 m 0.2220324,1.1487732 0.1432603,0.1893741 m 0.00446,-0.00446 0.1854355,0 m 0.037158,3.6528027 0.167881,-0.2589325 m -8.91e-4,-6.95e-4 0.1295642,-0.185587 m 2.228e-4,1.248e-4 0.036713,-0.315276 M 7.619547,8.146335 7.5634976,7.8682887 M 7.5638451,7.8681996 7.3419819,7.700568 m -0.5382886,6.951e-4 0.5376916,0 m -0.5376916,0 -0.2406028,0.2044691 m -4.722e-4,-4.633e-4 -0.093324,0.1851057 m 5.881e-4,3.476e-4 0.032079,0.2975076 M 6.6661895,4.3942739 6.3877422,4.2838325 m 0.371165,0.4071026 -0.089991,-0.2974988 m 0.1085167,0.7425172 0,-0.4454016 M 6.7032053,5.4511671 6.7766309,5.1357842 M 6.6105232,5.6365936 6.7038379,5.4514879 M 6.369457,5.8405548 6.6100598,5.6360768 m -0.7783033,0.204478 0.5377005,0 M 5.6092607,5.6736718 5.8311684,5.8413301 M 5.553639,5.3955364 5.6096884,5.6735827 M 5.5907082,5.0803228 5.5539954,5.3955899 M 5.7204863,4.8949052 5.5909132,5.0804743 M 5.8873604,4.6353222 5.7194794,4.8942458 M 6.0913127,4.3386344 5.8873159,4.6352777 m 0.500658,-0.352265 -0.2965899,0.05596 m 0.018535,3.9490718 -0.1854177,0 M 6.2582581,8.4734713 6.1149979,8.2840972 M 6.4992886,8.7886849 6.2598888,8.4722149 M 6.7032409,8.9741115 6.4992619,8.7887295 M 6.7774062,9.1966073 6.7026439,8.9743075 m 0.074762,0.426261 0,-0.2039612 M 6.6105499,9.6230733 6.778324,9.4012636 m -0.2975789,0.2218097 0.1298048,0 M 6.2767928,9.7343435 6.4802906,9.6222446 M 6.1099187,9.752887 6.2768106,9.7344415 M 5.8132575,9.6786594 6.1100791,9.7522633 M 5.6463923,9.474716 5.8128298,9.6790336 M 5.4795093,9.178037 5.6474884,9.4741011 M 5.3126352,9.0853371 5.4798568,9.1773861 M 5.3126352,8.974022 l 0,0.1112612 m -0.055604,-0.333766 0.056049,0.2223978 m -0.056049,-0.4078155 0,0.1854177 M 5.331259,8.3992258 5.2587244,8.5668485 M 5.7020141,8.306517 5.3310005,8.3984595 M 5.9245099,8.2879556 5.7019963,8.3064012 M 0.08399628,5.6364778 0.0307983,5.6293491 M 0.17306946,5.5235413 0.08636657,5.6381619 m 0.03644551,-0.282368 0.0507029,0.1676137 M 0.0307983,5.3326791 0.12250911,5.3570058 m 0.0356435,-0.109898 -0.12744346,-0.05899 m 0.22014337,0.05899 -0.0927445,0 M 0.38061284,5.2100386 0.25072781,5.2467514 M 0.41769103,5.0987149 0.38035443,5.2098782 m -0.0554257,-0.333677 0.0919336,0.2228523 M 0.15805463,4.709336 0.32564161,4.8754973 M 0.03061117,4.60245 0.15883878,4.7083826 m -0.09354645,1.0029733 -0.03457423,0 m 0.09458903,0.045 -0.05970292,-0.045178 M 0.15535463,5.846142 0.12523584,5.7563648 m 0.0301188,0.149685 0,-0.059881 M 0.0804141,6.295393 0.1541071,5.9058449 M 0.03080721,6.4036514 0.08106459,6.2956871 M 0.26951195,7.694669 0.03081612,7.5842276 M 0.30659905,7.7688432 0.26935155,7.6947942 M 0.26958323,7.9171653 0.30691983,7.768906 M 0.03083395,7.9722876 0.27007334,7.9196243 M 5.7577784,6.7490639 5.8874763,6.8233807 m -0.166785,-0.1855602 0.037337,0.1111543 m -0.05596,-0.2224067 0.018713,0.1112256 M 5.8132932,6.2669762 5.701221,6.5262117 M 5.8874406,6.0815497 5.8127674,6.2667624 M 6.0357979,5.9332191 5.8868436,6.080917 m 0.3158374,-0.1476979 -0.1668831,0 m 0.1854266,0.166883 -0.018089,-0.1669454 m 0.018089,0.6675767 0,-0.5006313 M 6.1656206,6.8232381 6.22167,6.6008403 M 6.0543415,6.8788688 6.1657275,6.8236213 M 5.887405,6.8232738 6.0544306,6.8784321 m -5.024847,-1.7981627 0.1297959,0 M 0.86270945,4.9875962 1.0299222,5.0797525 m -0.37115614,-0.092156 0.20394339,0 M 0.41771776,4.8021874 0.65853438,4.9878813 M 0.36207821,4.6353044 0.41812766,4.802036 m -0.093092,-0.4819541 0.0367128,0.3152582 m -0.0367128,-0.7602677 0,0.4450095 M 0.41778905,3.6340241 0.32641685,3.8755803 M 0.47339296,3.46715 0.4173435,3.6338815 M 0.58464534,3.430054 0.47336623,3.4667668 m 0.40800261,-0.036713 -0.29667004,0 M 1.048234,3.485747 0.88122626,3.4305887 M 1.2521952,3.6341221 1.0482251,3.4858094 M 1.4190783,3.763927 1.2524537,3.6337746 M 1.5488475,3.8566269 1.4191763,3.7637577 M 1.6415563,4.0976663 1.550193,3.856119 M 1.7447265,4.2355444 1.6408256,4.0982009 m 0.1305088,0.2776097 -0.026644,-0.140284 m 0.00802,0.3627887 0,-0.22328 m -0.055604,0.4272412 0.05605,-0.2038364 M 1.4931366,4.9320547 1.6948166,4.7987478 M 1.1593973,5.080403 1.4936178,4.9331418 m 3.0788527,-0.00446 0.08795,0.058099 M 4.5524923,4.746138 4.5721854,4.9286774 M 4.7420446,4.6198886 4.55202,4.7454786 M 5.0730572,4.55835 4.7422318,4.6208153 m 0.6445865,-0.078594 -0.31377,0.015951 m 0.5062807,-0.015951 -0.1925107,0 M 5.7205754,4.7090954 5.5798993,4.5417401 m 0.1406761,0.3156948 0,-0.1483395 M 5.5907884,4.9686962 5.7204418,4.8572834 m -0.9084022,0.1114128 0.7787488,0 M 4.6601625,4.9872308 4.8120753,4.9688744 M 1.8083502,4.8758894 1.9940797,4.9679388 M 1.7712631,4.6533579 1.8085997,4.8758181 M 2.0307926,4.3752403 1.7715572,4.6536965 M 2.3645408,4.2454355 2.0316747,4.377468 M 2.8095414,4.134192 2.364318,4.2445355 m 0.4452234,-0.1103435 0.5005956,0 M 3.4214072,4.20842 3.3099053,4.134638 m 0.1115019,0.2406117 0,-0.1668919 M 3.2174549,4.597754 3.4203111,4.3742423 M 2.9764066,4.8017152 3.2170183,4.5972371 M 2.4943367,4.9315022 2.9769947,4.8038894 M 1.9937233,4.9685893 2.4943634,4.9317873 m 0.2039256,0.036802 -0.1668919,0.018446 m 0.4079313,-0.074049 -0.241583,0.053198 M 3.0345234,4.840424 2.9393551,4.9129586 M 3.1618064,4.7460311 3.0346481,4.8405577 m 0.2384018,-0.094527 -0.1112613,0 M 3.3101103,4.8572834 3.2727737,4.7461291 m 0.037337,0.2965898 0,-0.1854355 M 3.2173747,5.2095841 3.3094241,5.0423179 M 3.106158,5.3022929 3.2177757,5.2100386 M 2.8836532,5.3764404 3.1063362,5.3028365 M 2.6426049,5.5433056 2.8871908,5.3816622 m -0.3558383,0.1616434 0.1112791,0 M 2.4386704,5.4320621 2.5318783,5.5429135 M 2.3645408,5.3208008 2.4391249,5.4317592 M 2.2532706,5.2095574 2.3650042,5.3203286 M 2.2717962,5.1353743 2.2531722,5.2096023 M 2.3645582,5.042755 2.2714662,5.135116 m 0.259975,-0.1479385 -0.1670167,0.055158 m 2.2992574,0.7050291 0.166892,0 M 4.496826,5.6547005 4.6640388,5.7468569 M 4.4226518,5.5434927 4.4972359,5.65446 m -0.074584,-0.2778414 0,0.1668741 m 0.074228,-0.29667 -0.073782,0.1300276 M 4.7193753,5.0799397 4.4974498,5.2475979 m 0.4258778,-0.22328 -0.2038186,0.05605 m 0.444858,-0.05605 -0.2410394,0 M 5.386845,5.0428526 5.1643581,5.024407 M 5.4424846,5.135499 5.3864346,5.04304 m 0.037337,0.3149908 0,-0.2232711 M 5.3125015,5.4692918 5.4242262,5.3585206 M 5.1135928,5.6553154 5.3134817,5.4703433 m -0.48305,0.2770839 0.2827334,-0.093404 m -1.3581255,0.2788661 0.055871,0.036891 m -0.222656,-0.092459 0.1670166,0.055158 M 3.4399329,5.7474807 3.5877912,5.8778112 m -0.1478583,-0.3342917 0,0.2039612 m -0.074228,-0.2781265 0.074495,0.073871 m -0.074495,-0.073871 0,-0.4820966 m 0.018535,-0.4079313 0,0.408359 M 3.4955012,4.375374 3.3835448,4.5789164 m 0.204683,-0.2777166 -0.092976,0.073782 m 0.2598948,-0.073782 -0.166883,0 m 0.3893788,-0.092664 -0.222781,0.092049 m 0.222781,-0.092049 0.3522829,0 M 4.4967993,4.523758 4.3361985,4.2052919 m 0.1606008,0.5595144 0,-0.2410483 M 4.3670123,5.2654464 4.4934488,4.7639598 M 4.3299252,5.6362818 4.3672618,5.2654732 M 4.107367,5.8587865 4.3308341,5.6372441 M 3.9405018,5.9700389 4.1078125,5.8594548 m -0.2971067,0.1105841 0.129796,0 M 2.5365921,5.7060183 2.607701,5.9411676 M 2.6610772,5.5991947 2.5366367,5.7061431 M 2.7496959,5.4988759 2.6611217,5.5991857 M 2.9698036,5.4092859 2.7496959,5.4988492 M 3.1350827,5.3565424 2.9703383,5.4109879 M 3.272943,5.4693542 3.1356173,5.355883 m 0.1373257,0.2988977 0,-0.1854265 M 3.217339,5.8031202 3.2733885,5.6549411 M 3.0319303,5.9699943 3.2172232,5.8029866 M 2.8650562,5.988529 3.0319481,5.9700834 M 2.6054822,5.9417468 2.8650473,5.988529 m -1.223188,0.4901075 0.1110474,0.1027959 m -0.1110474,-0.3438443 0,0.2410484 m -0.09319,-0.3603473 0.091354,0.1207603 M 1.3995902,5.9679359 1.5499435,6.117015 M 1.2144844,5.8181529 1.3997149,5.9677933 M 1.159326,5.6918144 1.2140388,5.8183667 m -0.054713,-0.478853 0,0.3523007 M 1.2705873,5.1726307 1.158631,5.3390682 M 1.437399,5.0243001 1.2699101,5.1719178 m 0.3158284,-0.2032483 -0.1481969,0.05596 m 0.3336146,-0.05596 -0.1854177,0 m 0.2781176,0.092664 -0.093092,-0.092352 M 2.030748,5.2281722 1.8631521,5.062011 M 2.2532439,5.3950374 2.0313094,5.2274059 M 2.420118,5.5804729 2.2524508,5.3957592 M 2.5313703,6.0069388 2.4236556,5.5795729 m 0.1077147,0.5942401 0,-0.1668742 M 2.3830398,6.4704919 2.5323862,6.1743298 M 2.1976132,6.6188225 2.3836457,6.4712672 m -0.3528977,0.1475553 0.1668652,0 M 1.7526215,6.5817532 2.0307837,6.618466 M 3.4955101,5.8770895 3.3836607,6.0249567 M 3.662402,5.9327023 3.4953942,5.8775439 M 3.8292761,6.1923387 3.6613951,5.9334152 M 4.1444897,6.5446305 3.8267543,6.1946199 M 4.2557332,6.9340182 4.145265,6.5444166 m 0.1104682,0.6492024 0,-0.2596008 M 4.2001293,7.323406 4.2561787,7.1937794 m -0.1487404,0.1296266 0.092744,0 M 4.0333082,7.249178 4.1078032,7.323049 M 3.9406176,7.045226 4.0332373,7.2492496 M 3.7737791,6.8783519 3.9413572,7.0445132 M 3.6514238,6.7141867 3.7749554,6.8774698 M 3.4956616,6.5816819 3.6514773,6.7141155 M 3.4214963,6.4704206 3.4960804,6.5813789 M 3.3843468,6.2108288 3.4199904,6.4706167 m -0.035644,-0.4452056 0,0.1854177 m -0.9641486,0.6675231 0.111386,0.036713 m -0.166981,-0.092459 0.055871,0.055337 m -0.037247,-0.2964294 0,0.2417433 M 2.4759714,6.4702513 2.3827725,6.5811205 M 2.587197,6.3219118 2.4753565,6.4697879 M 2.883876,6.1364942 2.5920178,6.329397 M 3.1619846,5.9139894 2.8829492,6.1353179 M 3.3103241,5.8769023 3.1619134,5.9137043 m 0.2040324,0.055871 -0.05596,-0.092459 m 0.05596,0.259378 0,-0.166883 M 3.2731925,6.3589989 3.365135,6.1361734 M 3.1619401,6.525882 3.2738964,6.3594445 M 2.8282364,6.7669303 3.1621807,6.5261315 M 2.5315931,6.9152608 2.8287533,6.767955 m 1.5118115,0.1457197 0.1511375,0.030743 M 4.2744639,6.655669 4.3396024,6.9139242 M 4.1446947,6.4887949 4.2722361,6.6573888 M 4.0519858,6.3219118 4.1440353,6.4891691 M 3.9963997,6.1550288 4.0524492,6.3217604 M 4.033469,5.9881547 3.9973799,6.1552427 M 4.1632739,5.8768934 4.0336205,5.9883062 M 4.330148,5.7471064 4.1635501,5.8772409 M 4.4228479,5.7100193 4.3299965,5.7467321 M 4.7928099,5.8388885 4.4207627,5.7159272 m 0.5389213,0.1229613 -0.1668741,0 m 0.38937,-0.018535 -0.2225137,0.018446 M 5.3684263,5.765641 5.1821621,5.8203539 m 0.3531293,-0.054713 -0.1668651,0 M 5.7021566,5.8768845 5.5348459,5.7662915 m 0.241476,0.3330978 -0.074673,-0.2222998 m 0.074673,0.3335611 0,-0.1112613 M 5.6465349,6.4331553 5.7760992,6.2105169 M 5.5352914,6.6000294 5.6472567,6.4336008 M 5.3128491,6.7669213 5.5347746,6.599272 m -0.4814996,0.1676493 0.2595741,0 M 4.7751486,6.8595856 5.0535245,6.7676431 M 4.4917914,6.9442568 4.7750149,6.8591579 m -0.5243698,0.8970943 0.06603,0.2181651 m -0.1020653,-0.511957 0.037069,0.293676 M 4.3672885,7.249009 4.2089867,7.45829 M 4.5897844,7.082126 4.3678588,7.2497754 M 4.8679019,6.9337955 4.5892675,7.0811369 M 5.3685243,6.8225431 4.867697,6.9328955 M 5.6095547,6.7483867 5.3685777,6.8227926 M 5.8320506,6.8782183 5.6099557,6.7477451 M 5.8691466,6.970936 5.8317209,6.8783698 M 5.9432228,7.0822151 5.8686387,6.9712657 M 6.0359405,7.1563893 5.9429733,7.0826072 M 6.0544662,7.3232634 6.0363771,7.1563269 m -4.722e-4,0.3894413 0,-0.22328 M 5.9431604,7.8239036 6.0365999,7.5460177 M 5.7206824,8.1391172 5.9432049,7.8239214 m -0.5748143,0.426457 0.350768,-0.1159395 m -0.6103331,0.1159395 0.2595651,0 M 4.7008942,8.1577053 5.1094047,8.2476874 M 4.4556488,8.1128568 4.70101,8.1570548 M 4.3180024,7.974052 4.4568073,8.1116627 m -4.2985299,1.1956 -0.12744345,-0.096282 M 0.23595357,9.3814369 0.15825066,9.3072983 M 0.36220296,9.6039594 0.23595357,9.3814458 m 0.0962019,0.3894056 0.0315445,-0.1666157 M 0.21390804,9.8466562 0.33111289,9.7691316 M 0.03084286,9.9198413 0.2141219,9.8471285 M 3.3259984,8.1721587 3.5369635,8.3115962 M 3.1990539,7.9351025 3.3268984,8.1716864 m -0.1278445,-0.2365839 0,-0.5191748 M 3.0321976,7.193414 3.1999806,7.4152237 M 2.9209542,7.0265221 3.0329105,7.1929685 m -0.1119563,-0.2776899 0,0.1112435 m 0.074228,-0.259574 -0.074673,0.1480721 M 3.1064342,6.6927739 2.9949323,6.766556 M 3.273335,6.4991226 3.1061312,6.6925422 m 0.2735909,-0.1918335 -0.1064405,0 M 3.6626604,6.7663956 3.3804349,6.4998978 M 3.8253019,7.0021954 3.662999,6.7661728 M 4.0080997,7.3698139 3.8232256,7.003238 M 4.0891175,7.5457593 4.0074938,7.3701525 M 4.2004857,7.8239036 4.0884135,7.5460979 m 0.1120722,0.4446798 0,-0.1668741 m -0.055604,0.333766 0.056049,-0.1667493 M 4.0336383,8.2467339 4.145256,8.1582488 m -0.2228879,0.08403 0.1112702,0.00446 m -0.3337393,0.00267 0.2226473,0 m -0.3850838,0.060772 0.1622761,-0.061218 m 0.5563956,0.2414939 0.129689,0.092869 M 4.1634253,8.3606684 4.2596272,8.4878713 m -0.096202,-0.2384641 0,0.1112612 m 0.092736,-0.203979 -0.093083,0.092361 m 0.2228879,-0.092361 -0.129787,0 M 4.5528488,8.2493537 4.3856449,8.1572063 M 4.8309663,8.3049487 4.5527596,8.2497903 M 5.0534622,8.4162011 4.8305832,8.305715 m 0.2785185,0.1846603 -0.05596,-0.07396 m -0.018267,0.1666425 0.071554,-0.094634 m -0.275578,0.1503088 0.2038275,-0.05605 m -0.3706927,0.05605 0.1668652,0 M 4.3858588,8.5831286 4.6640833,8.638287 M 4.4229548,8.9354204 4.4977171,9.1577291 M 4.4971379,8.7499938 4.4224647,8.9351976 m 0.2415919,-0.1852038 -0.1668652,0 m 0.3337393,-0.037158 -0.1669454,0.036713 m 0.315267,-0.092361 -0.1481969,0.05596 M 5.16467,8.7498602 4.9789405,8.6578108 M 5.2573877,8.8796918 5.1611858,8.75248 m 0.096202,0.2940948 0,-0.166883 M 5.1090483,9.1392747 5.2549818,9.0427876 M 4.9421831,9.1948608 5.1091908,9.1397024 M 4.7752911,9.250536 4.9423167,9.1953776 m -0.3524343,0.055158 0.1854087,0 m -0.2780997,-0.092673 0.093083,0.092352 m -3.67157797,-2.5954997 0,-0.4079135 M 0.99292418,5.9130449 0.92065692,6.2472208 M 1.0855795,5.8203182 0.99249646,5.9126706 M 1.2524626,5.8760469 1.0854548,5.8208885 m 0.4080561,0.3147859 -0.241378,-0.25928 m 0.334069,0.5374065 -0.093431,-0.2778948 m 0.093431,0.4076907 0,-0.1297959 M 1.4378713,6.6363056 1.5837959,6.5398097 M 1.1968497,6.6919095 1.4384238,6.6387116 M 0.99289745,6.7475669 1.1966983,6.6915175 m -0.27797504,-0.036535 0.0717326,0.094732 m -0.12724741,0.4430491 0.0560495,0.2223711 m -0.0375148,-0.4819718 0,0.2602512 M 1.088529,6.7884768 0.8779827,6.927638 M 1.1969478,6.7477451 1.0886627,6.7886461 M 1.4751188,6.6921501 1.1969032,6.7473085 M 1.7161582,6.6550452 1.4750653,6.691758 M 1.9942758,6.7106491 1.7160691,6.6554908 M 2.2167716,6.7477451 1.9942312,6.7110323 M 2.3651022,6.9146994 2.2173686,6.7472907 m 0.1477336,0.2971957 0,-0.129787 M 2.1982192,7.2113784 2.365815,7.0452171 M 1.938654,7.3782525 2.1960984,7.2080903 M 1.6605186,7.489496 1.9389748,7.3790812 M 1.3267793,7.5451266 1.6606078,7.4899682 m -0.6304896,0.036535 0.2967235,0.017911 M 0.91887474,7.4153485 1.0306083,7.5261108 M 0.91887474,5.1346347 0.75194717,5.0979218 M 1.0301182,5.3757453 0.91804603,5.1350713 m 0.11207217,0.5002659 0,-0.2595919 M 0.91885692,6.0988903 1.0354113,5.636656 M 0.82613918,6.6366086 0.91658465,6.098516 m -0.0904455,0.9274715 0,-0.3893789 M 0.77053527,7.378306 0.82391146,7.0256399 M 0.75200063,7.5451801 0.77008973,7.3782436 M 0.58517108,7.6564503 0.75249073,7.5458484 m -0.50105896,0.1106019 0.33373931,0 M 0.10311012,7.4895405 0.25084365,7.6569582 M 0.04747948,7.2484922 0.10352893,7.4894514 m -0.05604945,-0.5746985 0,0.3337393 M 0.08454875,6.7107917 0.04596463,6.9144856 M 0.1400992,6.2472297 0.08609924,6.7109699 M 0.21422883,5.7465985 0.13848633,6.246998 m 0.0757425,-0.7043696 0,0.2039701 M 0.38110294,5.2459583 0.21313279,5.5420135 M 0.64068588,5.09761 0.38126334,5.2462257 M 0.75193826,5.09761 l -0.11127911,0 m 3.74535115,4.2276259 0.5377005,0 M 5.0905849,9.2510974 4.9234791,9.3247904 M 5.2018284,9.1584509 5.0902196,9.2507053 M 5.424342,9.2141707 5.2017304,9.1590123 m 0.2782423,0.1664286 -0.05605,-0.1110653 m 0.05605,0.3335789 0,-0.2225136 M 5.3687025,9.6591891 5.4804271,9.5484179 M 5.2018284,9.7148197 5.3688451,9.6596614 m -0.8344864,0.055158 0.6674697,0 m -0.824132,-0.013099 0.1566712,0.012921 M 4.2804074,9.625399 4.3778747,9.701498 m -0.103099,-0.2833038 0,0.2072672 M 4.3860459,9.3254943 4.2744282,9.4177487 M 3.0881758,9.1400856 3.1059976,9.2699795 M 3.1067015,8.9732026 3.0886124,9.140139 M 3.2549875,8.7136196 3.1074589,8.9736659 M 3.366231,8.5467277 3.2542747,8.7131741 M 3.5330605,8.4354842 3.3657498,8.5460683 M 3.8297128,8.3613189 3.5329002,8.4349228 M 4.0226779,8.3968734 3.8298999,8.360517 M 4.2266391,8.563792 4.0234888,8.3959555 M 4.3378915,8.7862968 4.2258193,8.5641841 M 4.3673598,8.9919065 4.3390232,8.7861364 M 4.3115777,9.2515073 4.3676271,8.9920045 M 4.2002986,9.3627596 4.3120321,9.2519885 m -0.1117335,0.3332848 0,-0.2225137 M 4.1446947,9.7521474 4.2007441,9.5854159 M 3.9407335,9.8633909 4.1442313,9.7513098 M 3.5884417,9.8819344 3.9407691,9.8640236 M 3.44012,9.8634354 3.5884773,9.881881 M 3.3659548,9.6966237 3.4384893,9.8642463 M 3.2733261,9.5297407 3.3653845,9.6970069 M 3.1065055,9.2701488 3.2743865,9.5290813 M 2.3648438,8.3244992 2.2716359,8.4353595 m 0.093208,-0.1108603 0.3893699,0 M 2.9210967,8.2132557 2.7537771,8.3238398 M 3.087953,8.1019944 2.9206423,8.2125874 m 0.241476,-0.110593 -0.074139,0 M 3.3104756,8.2688774 3.1627332,8.1014598 m 0.1477424,0.3343007 0,-0.1668831 m -0.03698,0.3337572 0.036089,-0.1671058 M 3.0324293,8.9178571 3.2718202,8.601387 m -0.406265,0.3720829 0.1669989,-0.055158 m -0.333873,-4.812e-4 0.1670256,0.055158 M 2.4761852,8.936365 2.6987078,8.9179194 M 2.3649418,8.8065156 2.4767823,8.9358214 M 2.2722864,8.6396326 2.3643448,8.8068987 m -0.092058,-0.3712273 0,0.2039612 M 2.0497728,7.8608659 2.199137,8.1570191 m -0.1678989,-0.518649 0,0.2232622 m 0.074139,-0.482863 -0.073693,0.2597344 M 2.3278547,7.137721 2.1073727,7.3806139 M 2.4947466,7.0264508 2.327427,7.1370527 m 0.4268847,-0.1106019 -0.2595651,0 M 2.9953511,7.1933606 2.7507919,7.0316904 M 3.088051,7.3602258 2.9960016,7.1929685 m 0.095275,0.387365 0,-0.2201345 M 3.0323758,8.0277489 3.0937718,7.5806988 M 2.8097998,8.2502537 3.0332402,8.0287024 m -0.3903234,0.2215513 0.166883,0 M 2.3091775,8.2687883 2.6429257,8.2503428 M 2.1979162,8.1574558 2.3096498,8.2682448 M 0.10273586,8.862066 0.19467836,9.0848916 m -0.0919425,-0.2228256 0,-0.5562529 M 0.26962779,7.972047 0.10159527,8.3052249 M 0.41794944,7.8051729 0.27021591,7.9725728 M 0.77024121,7.6568423 0.41788707,7.8050392 M 1.1596112,7.6012028 0.77016101,7.6563612 M 1.4933416,7.6568245 1.159531,7.6016662 M 1.8641769,7.7680858 1.4933861,7.6566909 M 1.9939639,7.9164164 1.8650591,7.7673284 M 2.0310421,8.1018429 1.9937055,7.9164787 M 2.0866727,8.2501913 2.0306233,8.1020212 M 2.2164597,8.4912396 2.0863163,8.2503695 m 0.056049,0.5189788 0.070485,-0.2790889 M 2.0497549,8.936258 2.1418133,8.7689829 M 1.7160602,9.1958321 2.0492559,8.9355452 m -0.5186134,0.2602869 0.1854177,0 M 1.3081556,9.1587628 1.530696,9.1954756 m -0.59338464,-0.036713 0.37084424,0 M 0.64065024,9.2514271 0.93576978,9.1539064 M 0.43669794,9.2699795 0.64059677,9.250732 M 0.19566746,9.0845708 0.43647517,9.2702825",
    "sand":          "m 1.3966654,9.9306706 0.012096,0 0,0.012069 -0.012096,0 0,-0.012069 m -0.3900343,-0.3565998 0.012096,0 0,0.012069 -0.012096,0 0,-0.012069 m -0.092932,-0.084983 0.0120902,0 0,0.012067 -0.0120902,0 0,-0.012067 M 0.41181061,9.030213 l 0.0120964,0 0,0.012066 -0.0120964,0 0,-0.012066 m -0.39371787,-0.3599659 0.01209018,0 0,0.012067 -0.01209018,0 0,-0.012067 m 0,0 0.01209018,0 0,0.012067 -0.01209018,0 0,-0.012067 m 2.94305876,0.8633295 0.01209,0 0,0.012069 -0.01209,0 0,-0.012069 m -0.4386998,-0.4010897 0.012096,0 0,0.012068 -0.012096,0 0,-0.012068 m -0.092932,-0.084972 0.01209,0 0,0.012066 -0.01209,0 0,-0.012066 M 1.9276311,8.588641 l 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.4386809,-0.4010893 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.092951,-0.084983 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.50188227,-0.4588753 0.0120963,0 0,0.012066 -0.0120963,0 0,-0.012066 m -0.43868114,-0.4010883 0.0120902,0 0,0.012067 -0.0120902,0 0,-0.012067 m -0.0929507,-0.084972 0.0120902,0 0,0.012067 -0.0120902,0 0,-0.012067 m -0.34439268,-0.3148862 0.01209018,0 0,0.012066 -0.01209018,0 0,-0.012066 m 0,0 0.01209018,0 0,0.012066 -0.01209018,0 0,-0.012066 m 0,0 0.01209018,0 0,0.012066 -0.01209018,0 0,-0.012066 m 5.37616479,3.0879235 0.012096,0 0,0.012069 -0.012096,0 0,-0.012069 M 5.0718047,9.635852 l 0.012091,0 0,0.012069 -0.012091,0 0,-0.012069 m -0.092951,-0.08498 0.012091,0 0,0.012069 -0.012091,0 0,-0.012069 m -0.5018822,-0.4588738 0.01209,0 0,0.012066 -0.01209,0 0,-0.012066 m -0.4386874,-0.4010897 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.092944,-0.084972 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.5018886,-0.4588739 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 M 3.00477,7.7459728 l 0.012091,0 0,0.012067 -0.012091,0 0,-0.012067 m -0.092951,-0.084983 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 M 2.4099367,7.202127 l 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.4386812,-0.401101 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.092951,-0.084972 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.5018807,-0.4588786 0.012091,0 0,0.012067 -0.012091,0 0,-0.012067 m -0.43868737,-0.401089 0.0120963,0 0,0.012067 -0.0120963,0 0,-0.012067 m -0.0929382,-0.084972 0.0120964,0 0,0.012066 -0.0120964,0 0,-0.012066 m -0.50189476,-0.4588745 0.0120964,0 0,0.012067 -0.0120964,0 0,-0.012067 M 0.01809274,5.015261 l 0.01209018,0 0,0.012067 -0.01209018,0 0,-0.012067 m 0,0 0.01209018,0 0,0.012067 -0.01209018,0 0,-0.012067 m 7.00821386,4.5800959 0.012096,0 0,0.012069 -0.012096,0 0,-0.012069 m -0.4386809,-0.401089 0.01209,0 0,0.012066 -0.01209,0 0,-0.012066 m -0.092951,-0.084972 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.5018822,-0.458874 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 M 5.554105,8.2493332 l 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.092944,-0.084984 0.01209,0 0,0.012066 -0.01209,0 0,-0.012066 m -0.5018885,-0.4588746 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.4386812,-0.401089 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.092938,-0.084972 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.5018947,-0.4588742 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.4386811,-0.4010883 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.092938,-0.084984 0.01209,0 0,0.012066 -0.01209,0 0,-0.012066 M 2.8922448,5.815592 l 0.01209,0 0,0.012067 -0.01209,0 0,-0.012067 m -0.4386874,-0.4010884 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.092939,-0.084972 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.5018947,-0.4588744 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.4386812,-0.4010894 0.01209,0 0,0.012066 -0.01209,0 0,-0.012066 m -0.092938,-0.084972 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.50188224,-0.4588746 0.0120902,0 0,0.012066 -0.0120902,0 0,-0.012066 M 0.38652929,3.524633 l 0.0120901,0 0,0.012066 -0.0120901,0 0,-0.012066 m -0.0929382,-0.084984 0.0120901,0 0,0.012067 -0.0120901,0 0,-0.012067 M 0.0180931,3.1877614 l 0.01209017,0 0,0.012066 -0.01209017,0 0,-0.012066 m 0,0 0.01209017,0 0,0.012066 -0.01209017,0 0,-0.012066 m 0,0 0.01209017,0 0,0.012066 -0.01209017,0 0,-0.012066 m 9.3736942,6.7429092 0.012097,0 0,0.012069 -0.012097,0 0,-0.012069 m -0.2548017,-0.2330384 0.012091,0 0,0.012069 -0.012091,0 0,-0.012069 m -0.092999,-0.08498 0.012095,0 0,0.012069 -0.012095,0 0,-0.012069 m -0.5018704,-0.4588746 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 M 8.1034907,8.752688 l 0.012097,0 0,0.012066 -0.012097,0 0,-0.012066 m -0.092994,-0.084972 0.01209,0 0,0.012067 -0.01209,0 0,-0.012067 m -0.5018704,-0.4588779 0.01209,0 0,0.012066 -0.01209,0 0,-0.012066 M 7.0699259,7.807749 l 0.012097,0 0,0.012067 -0.012097,0 0,-0.012067 m -0.092931,-0.084984 0.01209,0 0,0.012066 -0.01209,0 0,-0.012066 m -0.5019015,-0.458874 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.4386815,-0.4010892 0.012091,0 0,0.012067 -0.012091,0 0,-0.012067 m -0.092938,-0.084972 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.5018948,-0.4588745 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.4386811,-0.401089 0.012091,0 0,0.012067 -0.012091,0 0,-0.012067 m -0.092939,-0.084972 0.012091,0 0,0.012067 -0.012091,0 0,-0.012067 m -0.5018823,-0.4588745 0.01209,0 0,0.012066 -0.01209,0 0,-0.012066 M 3.9693776,4.972932 l 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.092939,-0.084984 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.5018818,-0.4588744 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.4386935,-0.4010891 0.012091,0 0,0.012067 -0.012091,0 0,-0.012067 m -0.092938,-0.084972 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 M 2.341043,3.4841379 l 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 M 1.9023561,3.083049 l 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.092944,-0.084983 0.01209,0 0,0.012066 -0.01209,0 0,-0.012066 m -0.5018824,-0.4588753 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.43868732,-0.4010882 0.0120964,0 0,0.012066 -0.0120964,0 0,-0.012066 m -0.0929507,-0.084972 0.0120965,0 0,0.012066 -0.0120965,0 0,-0.012066 m -0.50188227,-0.4588744 0.0120964,0 0,0.012066 -0.0120964,0 0,-0.012066 m -0.25591599,-0.2339803 0.01209017,0 0,0.012066 -0.01209017,0 0,-0.012066 m 0,0 0.01209017,0 0,0.012066 -0.01209017,0 0,-0.012066 m 9.92611548,7.2478768 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.3249413,-0.2970522 0.012087,0 0,0.012067 -0.012087,0 0,-0.012067 m -0.093,-0.084972 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.501869,-0.4588739 0.012091,0 0,0.012067 -0.012091,0 0,-0.012067 m -0.4386256,-0.401089 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.092995,-0.084972 0.01209,0 0,0.012067 -0.01209,0 0,-0.012067 m -0.5018759,-0.4588743 0.012095,0 0,0.012066 -0.012095,0 0,-0.012066 m -0.4386186,-0.4010885 0.01209,0 0,0.012067 -0.01209,0 0,-0.012067 m -0.093001,-0.084984 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.5018697,-0.4588745 0.012091,0 0,0.012067 -0.012091,0 0,-0.012067 m -0.438681,-0.401089 0.01209,0 0,0.012067 -0.01209,0 0,-0.012067 m -0.092951,-0.084972 0.012091,0 0,0.012067 -0.012091,0 0,-0.012067 m -0.5018822,-0.4588745 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.4386873,-0.4010884 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.092951,-0.084984 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.5018822,-0.4588627 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.4386812,-0.4011009 0.01209,0 0,0.012066 -0.01209,0 0,-0.012066 m -0.092951,-0.084972 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.5018823,-0.4588745 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.4386874,-0.401089 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.092944,-0.084972 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 M 2.82335,2.0976187 l 0.01209,0 0,0.012066 -0.01209,0 0,-0.012066 m -0.4386871,-0.401088 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.092951,-0.084984 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.5018824,-0.4588714 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.4386807,-0.40108828 0.012091,0 0,0.0120665 -0.012091,0 0,-0.0120665 m -0.092938,-0.0849768 0.012091,0 0,0.0120665 -0.012091,0 0,-0.0120665 M 0.75631582,0.2077358 l 0.0120901,0 0,0.0120664 -0.0120901,0 0,-0.0120664 m -0.19807856,-0.18110471 0.0120964,0 0,0.01206644 -0.0120964,0 0,-0.01206644 m 0,0 0.0120964,0 0,0.01206644 -0.0120964,0 0,-0.01206644 M 9.506797,6.3807357 l 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.4387432,-0.4010884 0.01209,0 0,0.012067 -0.01209,0 0,-0.012067 m -0.092876,-0.084973 0.01209,0 0,0.012067 -0.01209,0 0,-0.012067 M 8.4731827,5.4358 l 0.012097,0 0,0.012066 -0.012097,0 0,-0.012066 m -0.4386248,-0.4010884 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.092995,-0.084984 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.5018696,-0.4588745 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.4386623,-0.401089 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.09295,-0.084972 0.012095,0 0,0.012066 -0.012095,0 0,-0.012066 m -0.5018829,-0.4588745 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 M 5.967517,3.1448292 l 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.092938,-0.084984 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.5018947,-0.4588745 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.4386874,-0.4010891 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.092932,-0.084972 0.01209,0 0,0.012066 -0.01209,0 0,-0.012066 m -0.5018951,-0.4588737 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 M 3.900483,1.2549468 l 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.092939,-0.084977 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.5018948,-0.45887393 0.012096,0 0,0.0120665 -0.012096,0 0,-0.0120665 m -0.4386811,-0.40108963 0.01209,0 0,0.0120664 -0.01209,0 0,-0.0120664 m -0.092938,-0.0849767 0.012091,0 0,0.0120664 -0.012091,0 0,-0.0120664 m -0.2170009,-0.19839792 0.01209,0 0,0.01206644 -0.01209,0 0,-0.01206644 m 0,0 0.01209,0 0,0.01206644 -0.01209,0 0,-0.01206644 m 0,0 0.01209,0 0,0.01206644 -0.01209,0 0,-0.01206644 m 7.3871787,4.92653568 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.3938736,-0.3600382 0.012087,0 0,0.012067 -0.012087,0 0,-0.012067 m -0.092876,-0.084984 0.01209,0 0,0.012067 -0.01209,0 0,-0.012067 M 8.955583,4.0492817 l 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.4387439,-0.4011008 0.012097,0 0,0.012066 -0.012097,0 0,-0.012066 m -0.092876,-0.084972 0.012097,0 0,0.012066 -0.012097,0 0,-0.012066 m -0.5019874,-0.4588745 0.01209,0 0,0.012066 -0.01209,0 0,-0.012066 m -0.4386253,-0.4010883 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.093,-0.084973 0.012095,0 0,0.012066 -0.012095,0 0,-0.012066 m -0.5018455,-0.4588744 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.4386872,-0.4010884 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.092932,-0.084984 0.01209,0 0,0.012066 -0.01209,0 0,-0.012066 m -0.5018824,-0.4588745 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.4386998,-0.40108652 0.012096,0 0,0.0120665 -0.012096,0 0,-0.0120665 m -0.092938,-0.0849767 0.012096,0 0,0.0120665 -0.012096,0 0,-0.0120665 M 4.821483,0.26951545 l 0.012096,0 0,0.0120664 -0.012096,0 0,-0.0120664 m -0.2656541,-0.24288478 0.012096,0 0,0.01206644 -0.012096,0 0,-0.01206644 m 0,0 0.012096,0 0,0.01206644 -0.012096,0 0,-0.01206644 m 5.3883796,3.09904883 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m 0,0 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.00446,-0.00405 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 M 9.4378789,2.662755 l 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.4387432,-0.4010884 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.092877,-0.084973 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 M 8.404389,1.7178191 l 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.438745,-0.401093 0.01209,0 0,0.012067 -0.01209,0 0,-0.012067 m -0.092883,-0.084984 0.012097,0 0,0.012066 -0.012097,0 0,-0.012066 m -0.5019881,-0.45886768 0.012091,0 0,0.0120664 -0.012091,0 0,-0.0120664 m -0.4386247,-0.40108965 0.012096,0 0,0.0120665 -0.012096,0 0,-0.0120665 m -0.092951,-0.0849767 0.012096,0 0,0.0120665 -0.012096,0 0,-0.0120665 M 6.5546333,0.0266298 l 0.012091,0 0,0.01206645 -0.012091,0 0,-0.01206645 m 0,0 0.012091,0 0,0.01206645 -0.012091,0 0,-0.01206645 m 0,0 0.012091,0 0,0.01206645 -0.012091,0 0,-0.01206645 m 3.365525,1.2496013 0.012087,0 0,0.012066 -0.012087,0 0,-0.012066 m -0.4386264,-0.40108649 0.012097,0 0,0.0120665 -0.012097,0 0,-0.0120665 m -0.092994,-0.0849767 0.01209,0 0,0.0120665 -0.01209,0 0,-0.0120665 M 8.886662,0.33129467 l 0.012096,0 0,0.0120664 -0.012096,0 0,-0.0120664 m -0.333286,-0.30466505 0.012091,0 0,0.01206645 -0.012091,0 0,-0.01206645 m 0,0 0.012091,0 0,0.01206645 -0.012091,0 0,-0.01206645 m -7.5807211,9.90404008 0.0120962,0 0,0.012069 -0.0120962,0 0,-0.012069 m 0,0 0.0120962,0 0,0.012069 -0.0120962,0 0,-0.012069 m -0.004481,-0.00286 0.0120962,0 0,0.012069 -0.0120962,0 0,-0.012069 m -0.9500718,-0.6039091 0.01209017,0 0,0.012066 -0.01209017,0 0,-0.012066 m 0,0 0.01209017,0 0,0.012066 -0.01209017,0 0,-0.012066 m 0,0 0.01209017,0 0,0.012066 -0.01209017,0 0,-0.012066 m 2.5292887,0.6067653 0.01209,0 0,0.012069 -0.01209,0 0,-0.012069 m 0,0 0.01209,0 0,0.012069 -0.01209,0 0,-0.012069 m -0.00894,-0.00571 0.01209,0 0,0.012069 -0.01209,0 0,-0.012069 m -0.9994027,-0.6352731 0.012091,0 0,0.012067 -0.012091,0 0,-0.012067 m -0.76549922,-0.486572 0.0120964,0 0,0.012066 -0.0120964,0 0,-0.012066 m -0.2126328,-0.1351556 0.0120901,0 0,0.012066 -0.0120901,0 0,-0.012066 m -0.54283211,-0.3450523 0.01209018,0 0,0.012066 -0.01209018,0 0,-0.012066 m 0,0 0.01209018,0 0,0.012066 -0.01209018,0 0,-0.012066 m 0,0 0.01209018,0 0,0.012066 -0.01209018,0 0,-0.012066 m 4.10408273,1.6077688 0.012096,0 0,0.012069 -0.012096,0 0,-0.012069 m 0,0 0.012096,0 0,0.012069 -0.012096,0 0,-0.012069 m -0.013434,-0.00857 0.012096,0 0,0.012069 -0.012096,0 0,-0.012069 m -0.9994067,-0.635272 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.7654892,-0.4865913 0.01209,0 0,0.012067 -0.01209,0 0,-0.012067 m -0.212639,-0.1351564 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.9993966,-0.6352739 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.76549534,-0.4865915 0.0120902,0 0,0.012066 -0.0120902,0 0,-0.012066 m -0.212639,-0.135168 0.0120964,0 0,0.012067 -0.0120964,0 0,-0.012067 m -0.1355867,-0.086191 0.01209018,0 0,0.012067 -0.01209018,0 0,-0.012067 m 0,0 0.01209018,0 0,0.012067 -0.01209018,0 0,-0.012067 m 0,0 0.01209018,0 0,0.012067 -0.01209018,0 0,-0.012067 m 5.67884844,2.6087894 0.012091,0 0,0.012069 -0.012091,0 0,-0.012069 m 0,0 0.012091,0 0,0.012069 -0.012091,0 0,-0.012069 m -0.017908,-0.011394 0.012091,0 0,0.012069 -0.012091,0 0,-0.012069 m -0.9994028,-0.6352736 0.01209,0 0,0.012066 -0.01209,0 0,-0.012066 m -0.7654954,-0.4865921 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 M 3.7014893,8.662259 l 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.9994027,-0.6352747 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.7654954,-0.4865914 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.2126328,-0.1351681 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.99940269,-0.6352742 0.0120964,0 0,0.012067 -0.0120964,0 0,-0.012067 m -0.70647574,-0.4490765 0.01209018,0 0,0.012066 -0.01209018,0 0,-0.012066 m 0,0 0.01209018,0 0,0.012066 -0.01209018,0 0,-0.012066 m 7.25362693,3.6097984 0.01209,0 0,0.012069 -0.01209,0 0,-0.012069 m 0,0 0.01209,0 0,0.012069 -0.01209,0 0,-0.012069 m -0.022376,-0.01424 0.012096,0 0,0.012069 -0.012096,0 0,-0.012069 m -0.9994276,-0.6352748 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.7654892,-0.4865914 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.212639,-0.1351556 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 M 4.2723786,8.024136 l 0.012091,0 0,0.012067 -0.012091,0 0,-0.012067 m -0.7654955,-0.4865906 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.212639,-0.1351682 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.9993964,-0.6352745 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.7654955,-0.486591 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.2126328,-0.1351683 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.9994025,-0.6352735 0.0120901,0 0,0.012066 -0.0120901,0 0,-0.012066 m -0.29923652,-0.1902028 0.01209018,0 0,0.012066 -0.01209018,0 0,-0.012066 m 0,0 0.01209018,0 0,0.012066 -0.01209018,0 0,-0.012066 m 8.82841082,4.6108049 0.012097,0 0,0.012069 -0.012097,0 0,-0.012069 m 0,0 0.012097,0 0,0.012069 -0.012097,0 0,-0.012069 m -0.02685,-0.017086 0.012096,0 0,0.012069 -0.012096,0 0,-0.012069 m -0.9993835,-0.635262 0.01209,0 0,0.012066 -0.01209,0 0,-0.012066 m -0.7655581,-0.4866031 0.012097,0 0,0.012066 -0.012097,0 0,-0.012066 m -0.2126331,-0.135157 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.9994027,-0.6352733 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.7654891,-0.4865914 0.01209,0 0,0.012067 -0.01209,0 0,-0.012067 m -0.212639,-0.1351688 0.012091,0 0,0.012067 -0.012091,0 0,-0.012067 m -0.9994029,-0.6352735 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.7654891,-0.4865917 0.012091,0 0,0.012067 -0.012091,0 0,-0.012067 m -0.212639,-0.1351683 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.9994027,-0.635262 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.7654887,-0.4866043 0.01209,0 0,0.012067 -0.01209,0 0,-0.012067 m -0.21263911,-0.135156 0.0120964,0 0,0.012066 -0.0120964,0 0,-0.012066 m -0.89139381,-0.5666163 0.01209018,0 0,0.012067 -0.01209018,0 0,-0.012067 m 0,0 0.01209018,0 0,0.012067 -0.01209018,0 0,-0.012067 m 0,0 0.01209018,0 0,0.012067 -0.01209018,0 0,-0.012067 m 9.37236992,4.9566166 0.01209,0 0,0.012067 -0.01209,0 0,-0.012067 M 8.624942,8.7888834 l 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 M 8.4123404,8.653717 l 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.9993843,-0.6352739 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.7654957,-0.4865914 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.212639,-0.1351681 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 M 5.4354249,6.761409 l 0.01209,0 0,0.012067 -0.01209,0 0,-0.012067 m -0.7654955,-0.4865916 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.2126327,-0.1351559 0.012091,0 0,0.012067 -0.012091,0 0,-0.012067 M 3.457894,5.5043877 l 0.01209,0 0,0.012066 -0.01209,0 0,-0.012066 m -0.7654956,-0.4865915 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.2126327,-0.1351684 0.01209,0 0,0.012066 -0.01209,0 0,-0.012066 M 1.480363,4.247354 l 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.76549537,-0.4865916 0.0120963,0 0,0.012066 -0.0120963,0 0,-0.012066 M 0.5022348,3.625594 l 0.0120901,0 0,0.012066 -0.0120901,0 0,-0.012066 m -0.48415462,-0.3077543 0.01209018,0 0,0.012066 -0.01209018,0 0,-0.012066 m 0,0 0.01209018,0 0,0.012066 -0.01209018,0 0,-0.012066 m 0,0 0.01209018,0 0,0.012066 -0.01209018,0 0,-0.012066 m 8.96518582,4.6977551 0.012097,0 0,0.012066 -0.012097,0 0,-0.012066 m -0.7655069,-0.4865913 0.012095,0 0,0.012066 -0.012095,0 0,-0.012066 m -0.2125966,-0.1351681 0.01209,0 0,0.012066 -0.01209,0 0,-0.012066 m -0.9994521,-0.6352743 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.7654892,-0.486591 0.01209,0 0,0.012067 -0.01209,0 0,-0.012067 m -0.212639,-0.1351566 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.9994027,-0.6352737 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.7654892,-0.4865915 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.212639,-0.1351685 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.9993966,-0.6352737 0.012091,0 0,0.012067 -0.012091,0 0,-0.012067 m -0.7654954,-0.4865915 0.01209,0 0,0.012066 -0.01209,0 0,-0.012066 m -0.212639,-0.1351685 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.9993964,-0.6352736 0.01209,0 0,0.012066 -0.01209,0 0,-0.012066 m -0.76549551,-0.4865917 0.0120964,0 0,0.012066 -0.0120964,0 0,-0.012066 M 0.0949956,2.3657249 l 0.01209015,0 0,0.012066 -0.01209015,0 0,-0.012066 m -0.07691542,-0.048893 0.01209018,0 0,0.012066 -0.01209018,0 0,-0.012066 m 0,0 0.01209018,0 0,0.012066 -0.01209018,0 0,-0.012066 m 0,0 0.01209018,0 0,0.012066 -0.01209018,0 0,-0.012066 m 9.92611592,5.3085587 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.156121,-0.099235 0.012087,0 0,0.012066 -0.012087,0 0,-0.012066 m -0.2127208,-0.1351681 0.012087,0 0,0.012067 -0.012087,0 0,-0.012067 m -0.9993895,-0.6352739 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.7655076,-0.4865919 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.2125951,-0.1351559 0.01209,0 0,0.012067 -0.01209,0 0,-0.012067 m -0.9993907,-0.6352744 0.012091,0 0,0.012067 -0.012091,0 0,-0.012067 m -0.7654955,-0.4865909 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 M 5.6203432,4.876932 l 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.9994028,-0.6352743 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.7654955,-0.486591 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.2126327,-0.1351683 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.9994028,-0.6352743 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.7654892,-0.486591 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.2126389,-0.1351566 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.99940274,-0.6352737 0.0120963,0 0,0.012066 -0.0120963,0 0,-0.012066 M 0.01808033,1.315823 l 0.01209017,0 0,0.012066 -0.01209017,0 0,-0.012066 m 0,0 0.01209017,0 0,0.012066 -0.01209017,0 0,-0.012066 m 9.92611577,5.3085586 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.5634227,-0.3581079 0.01209,0 0,0.012066 -0.01209,0 0,-0.012066 m -0.2126014,-0.135156 0.012097,0 0,0.012066 -0.012097,0 0,-0.012066 m -0.9993905,-0.6352738 0.012097,0 0,0.012067 -0.012097,0 0,-0.012067 m -0.7655021,-0.4865915 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 M 7.190678,4.874084 l 0.012097,0 0,0.012067 -0.012097,0 0,-0.012067 m -0.9994458,-0.6352736 0.01209,0 0,0.012066 -0.01209,0 0,-0.012066 m -0.7654954,-0.4865917 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.2126391,-0.1351684 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.9993965,-0.6352737 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 M 3.4482058,2.495185 l 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 M 3.235573,2.360029 l 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.9994027,-0.6352744 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.7654954,-0.4865915 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.2126328,-0.1351678 0.012091,0 0,0.012067 -0.012091,0 0,-0.012067 m -0.99940274,-0.63527304 0.0120902,0 0,0.0120665 -0.0120902,0 0,-0.0120665 m -0.24055903,-0.15291325 0.01209017,0 0,0.0120665 -0.01209017,0 0,-0.0120665 m 0,0 0.01209017,0 0,0.0120665 -0.01209017,0 0,-0.0120665 m 9.72101837,5.17818709 0.012087,0 0,0.012066 -0.012087,0 0,-0.012066 m -0.7655081,-0.4865916 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.2127205,-0.1351684 0.012097,0 0,0.012067 -0.012097,0 0,-0.012067 m -0.9993898,-0.6352737 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.7654522,-0.4865917 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.2126386,-0.1351683 0.01209,0 0,0.012066 -0.01209,0 0,-0.012066 m -0.9994027,-0.6352619 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.7654893,-0.4866034 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.212639,-0.1351559 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.9994027,-0.6352744 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.7654892,-0.486591 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.2126391,-0.1351671 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.9993964,-0.6352731 0.012091,0 0,0.0120665 -0.012091,0 0,-0.0120665 m -0.6894387,-0.43824386 0.012091,0 0,0.01206645 -0.012091,0 0,-0.01206645 m 0,0 0.012091,0 0,0.01206645 -0.012091,0 0,-0.01206645 m 8.1923047,4.20648286 0.01209,0 0,0.012066 -0.01209,0 0,-0.012066 m -0.7655083,-0.486591 0.012097,0 0,0.012066 -0.012097,0 0,-0.012066 m -0.2126014,-0.1351567 0.012097,0 0,0.012066 -0.012097,0 0,-0.012066 m -0.9993842,-0.6352736 0.01209,0 0,0.012066 -0.01209,0 0,-0.012066 m -0.7655201,-0.4865916 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.2126329,-0.1351685 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.9994027,-0.6352736 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.7654954,-0.4865917 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 M 4.3986194,1.097302 l 0.01209,0 0,0.012066 -0.01209,0 0,-0.012066 m -0.9994028,-0.63527367 0.012096,0 0,0.0120664 -0.012096,0 0,-0.0120664 m -0.6849523,-0.43539659 0.012096,0 0,0.01206645 -0.012096,0 0,-0.01206645 m 0,0 0.012096,0 0,0.01206645 -0.012096,0 0,-0.01206645 m 7.2299318,3.59471436 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m 0,0 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 M 9.924001,3.60852 l 0.012087,0 0,0.012066 -0.012087,0 0,-0.012066 m -0.9993901,-0.6352743 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.7655014,-0.4865916 0.01209,0 0,0.012066 -0.01209,0 0,-0.012066 m -0.2127268,-0.1351677 0.012097,0 0,0.012066 -0.012097,0 0,-0.012066 m -0.9993524,-0.6352743 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 M 6.181541,1.2296204 l 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.212639,-0.1351653 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.9993965,-0.63527303 0.01209,0 0,0.0120665 -0.01209,0 0,-0.0120665 m -0.6804784,-0.43254995 0.012091,0 0,0.01206645 -0.012091,0 0,-0.01206645 m 0,0 0.012091,0 0,0.01206645 -0.012091,0 0,-0.01206645 m 5.6551662,2.59370648 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.2147735,-0.1365317 0.012087,0 0,0.012066 -0.012087,0 0,-0.012066 M 9.5167,2.3486384 l 0.012087,0 0,0.012066 -0.012087,0 0,-0.012066 m -0.999391,-0.6352743 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.7655075,-0.4865909 0.012097,0 0,0.012066 -0.012097,0 0,-0.012066 M 7.5392091,1.091608 l 0.01209,0 0,0.012066 -0.01209,0 0,-0.012066 m -0.9994153,-0.63527297 0.012096,0 0,0.0120664 -0.012096,0 0,-0.0120664 m -0.6760044,-0.42970329 0.012096,0 0,0.01206645 -0.012096,0 0,-0.01206645 m 0,0 0.012096,0 0,0.01206645 -0.012096,0 0,-0.01206645 m 4.0804067,1.59268636 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.622075,-0.3953932 0.01209,0 0,0.012066 -0.01209,0 0,-0.012066 m -0.2126015,-0.1351634 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.9993905,-0.63527312 0.012096,0 0,0.0120665 -0.012096,0 0,-0.0120665 m -0.6715364,-0.42685664 0.012091,0 0,0.01206645 -0.012091,0 0,-0.01206645 m 0,0 0.012091,0 0,0.01206645 -0.012091,0 0,-0.01206645 m 2.2417282,0.42400937 0.012096,0 0,0.0120665 -0.012096,0 0,-0.0120665 m -0.6669441,-0.42400937 0.012096,0 0,0.01206645 -0.012096,0 0,-0.01206645 m 0,0 0.012096,0 0,0.01206645 -0.012096,0 0,-0.01206645 m 0.9215098,9.90403986 0.012087,0 0,0.012069 -0.012087,0 0,-0.012069 m 0,0 0.012087,0 0,0.012069 -0.012087,0 0,-0.012069 m 0,0 0.012087,0 0,0.012069 -0.012087,0 0,-0.012069 m 0.0093,-1.3038878 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.014992,0.00196 0.012087,0 0,0.012067 -0.012087,0 0,-0.012067 m -0.4099642,0.053852 0.012087,0 0,0.012066 -0.012087,0 0,-0.012066 m -0.2624251,0.034486 0.01209,0 0,0.012066 -0.01209,0 0,-0.012066 m -0.6849646,0.089968 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.4099581,0.053852 0.01209,0 0,0.012067 -0.01209,0 0,-0.012067 m -0.262425,0.034474 0.01209,0 0,0.012066 -0.01209,0 0,-0.012066 m -0.684847,0.089968 0.012097,0 0,0.012066 -0.012097,0 0,-0.012066 m -0.4099829,0.053852 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.262462,0.034475 0.012091,0 0,0.012067 -0.012091,0 0,-0.012067 m -0.6849025,0.089967 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.4099522,0.053852 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.2624621,0.034474 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.6849024,0.089968 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.409946,0.053852 0.01209,0 0,0.012066 -0.01209,0 0,-0.012066 m -0.262462,0.034485 0.01209,0 0,0.012067 -0.01209,0 0,-0.012067 m -0.6849026,0.089967 0.01209,0 0,0.012069 -0.01209,0 0,-0.012069 m -0.4099397,0.053855 0.01209,0 0,0.012069 -0.01209,0 0,-0.012069 m -0.2624744,0.034476 0.012096,0 0,0.012069 -0.012096,0 0,-0.012069 m -0.6849026,0.089968 0.012096,0 0,0.012069 -0.012096,0 0,-0.012069 m -0.4099397,0.053855 0.012096,0 0,0.012069 -0.012096,0 0,-0.012069 m -0.2624558,0.034476 0.012091,0 0,0.012069 -0.012091,0 0,-0.012069 m -0.68491499,0.089968 0.0120901,0 0,0.012069 -0.0120901,0 0,-0.012069 m -0.40993973,0.053855 0.01209018,0 0,0.012069 -0.01209018,0 0,-0.012069 m 9.92612242,-1.3039042 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.014992,0.00196 0.012087,0 0,0.012066 -0.012087,0 0,-0.012066 m -0.4099642,0.053852 0.012087,0 0,0.012066 -0.012087,0 0,-0.012066 m -0.262425,0.034485 0.01209,0 0,0.012067 -0.01209,0 0,-0.012067 m -0.6849647,0.089968 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.409958,0.053852 0.01209,0 0,0.012066 -0.01209,0 0,-0.012066 m -0.2624251,0.034474 0.01209,0 0,0.012066 -0.01209,0 0,-0.012066 m -0.6848469,0.089968 0.012097,0 0,0.012067 -0.012097,0 0,-0.012067 m -0.4099829,0.053852 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.2624621,0.034475 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.6849025,0.089967 0.012091,0 0,0.012067 -0.012091,0 0,-0.012067 m -0.4099522,0.053852 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.262462,0.034473 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.6849025,0.089968 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.409946,0.053852 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.262462,0.034486 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.6849025,0.089968 0.01209,0 0,0.012069 -0.01209,0 0,-0.012069 m -0.4099398,0.053855 0.012091,0 0,0.012069 -0.012091,0 0,-0.012069 m -0.2624744,0.034476 0.012096,0 0,0.012069 -0.012096,0 0,-0.012069 m -0.6849025,0.089968 0.012096,0 0,0.012069 -0.012096,0 0,-0.012069 m -0.4099398,0.053855 0.012096,0 0,0.012069 -0.012096,0 0,-0.012069 m -0.2624558,0.034476 0.012091,0 0,0.012069 -0.012091,0 0,-0.012069 m -0.68491495,0.089968 0.0120902,0 0,0.012069 -0.0120902,0 0,-0.012069 m -0.40993972,0.053855 0.01209017,0 0,0.012069 -0.01209017,0 0,-0.012069 m 9.92611767,-2.6065773 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.4798615,0.063035 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.409958,0.053852 0.01209,0 0,0.012067 -0.01209,0 0,-0.012067 m -0.2625496,0.034474 0.012097,0 0,0.012066 -0.012097,0 0,-0.012066 m -0.6848401,0.089967 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.4099643,0.053853 0.012095,0 0,0.012066 -0.012095,0 0,-0.012066 m -0.262425,0.034474 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.6849275,0.089968 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.4099459,0.053852 0.012091,0 0,0.012067 -0.012091,0 0,-0.012067 m -0.2624621,0.034475 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.6849025,0.089978 0.012091,0 0,0.012067 -0.012091,0 0,-0.012067 m -0.4099522,0.053841 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.2624619,0.034485 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.6849026,0.089968 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.4099335,0.053852 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.2624744,0.034475 0.01209,0 0,0.012066 -0.01209,0 0,-0.012066 m -0.6849026,0.089967 0.01209,0 0,0.012067 -0.01209,0 0,-0.012067 m -0.4099397,0.053852 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.262462,0.034475 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.684915,0.089966 0.012096,0 0,0.012068 -0.012096,0 0,-0.012068 m -0.40993355,0.053854 0.0120902,0 0,0.012066 -0.0120902,0 0,-0.012066 m -0.26246194,0.034472 0.0120902,0 0,0.012068 -0.0120902,0 0,-0.012068 m -0.62993988,0.082753 0.01209017,0 0,0.012066 -0.01209017,0 0,-0.012066 m 0,0 0.01209017,0 0,0.012066 -0.01209017,0 0,-0.012066 m 9.66623597,-2.5724228 0.012087,0 0,0.012067 -0.012087,0 0,-0.012067 m -0.6849651,0.089967 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.4099643,0.053852 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.2624244,0.034474 0.012095,0 0,0.012066 -0.012095,0 0,-0.012066 m -0.6848407,0.089967 0.01209,0 0,0.012066 -0.01209,0 0,-0.012066 m -0.409965,0.053852 0.012097,0 0,0.012066 -0.012097,0 0,-0.012066 m -0.2624929,0.034486 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.6849024,0.089968 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.4099522,0.053852 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.262462,0.034474 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.6849026,0.089967 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.4099397,0.053853 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.2624682,0.034474 0.012091,0 0,0.012067 -0.012091,0 0,-0.012067 m -0.6849026,0.089968 0.01209,0 0,0.012066 -0.01209,0 0,-0.012066 m -0.4099397,0.053852 0.012091,0 0,0.012067 -0.012091,0 0,-0.012067 m -0.2624619,0.034474 0.01209,0 0,0.012067 -0.01209,0 0,-0.012067 m -0.6849151,0.089968 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.4099397,0.053852 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.2624619,0.034485 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.68490266,0.089967 0.0120964,0 0,0.012066 -0.0120964,0 0,-0.012066 m -0.40994594,0.053852 0.0120901,0 0,0.012067 -0.0120901,0 0,-0.012067 m -0.26246199,0.034475 0.0120901,0 0,0.012066 -0.0120901,0 0,-0.012066 m -0.16502498,0.021672 0.01209017,0 0,0.012066 -0.01209017,0 0,-0.012066 m 0,0 0.01209017,0 0,0.012066 -0.01209017,0 0,-0.012066 m 9.92611577,-2.6065578 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.052363,0.00688 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.4099654,0.053853 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.2625434,0.034474 0.012097,0 0,0.012066 -0.012097,0 0,-0.012066 m -0.6848394,0.089979 0.01209,0 0,0.012067 -0.01209,0 0,-0.012067 m -0.4099649,0.053841 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.2624251,0.034485 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.6849647,0.089968 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.4099209,0.053852 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.2624619,0.034474 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.6849026,0.089967 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.4099398,0.053853 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.2624744,0.034474 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.6849025,0.089968 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.4099398,0.053852 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.2624558,0.034474 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.6849149,0.089979 0.01209,0 0,0.012067 -0.01209,0 0,-0.012067 m -0.4099397,0.05384 0.01209,0 0,0.012067 -0.01209,0 0,-0.012067 m -0.2624621,0.034486 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.6849025,0.089967 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.4099521,0.053852 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.2624559,0.034474 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.68490873,0.089967 0.0120964,0 0,0.012066 -0.0120964,0 0,-0.012066 m -0.37251804,0.048942 0.01209017,0 0,0.012067 -0.01209017,0 0,-0.012067 M 9.9441916,3.416098 l 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.5173458,0.067959 0.01209,0 0,0.012066 -0.01209,0 0,-0.012066 m -0.4099637,0.053852 0.01209,0 0,0.012066 -0.01209,0 0,-0.012066 m -0.2624249,0.034474 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.6849647,0.089968 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.4098404,0.053852 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.2625427,0.034474 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.6848717,0.089967 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.4099334,0.053852 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.2624745,0.034474 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.6849025,0.089968 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.4099397,0.053852 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 M 4.68253,4.107289 l 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.684915,0.089967 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.4099336,0.053853 0.01209,0 0,0.012067 -0.01209,0 0,-0.012067 m -0.2624619,0.034474 0.01209,0 0,0.012067 -0.01209,0 0,-0.012067 M 2.640317,4.37555 l 0.01209,0 0,0.012067 -0.01209,0 0,-0.012067 m -0.4099523,0.053852 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.2624619,0.034474 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.6849025,0.089967 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.4099523,0.053853 0.0120965,0 0,0.012066 -0.0120965,0 0,-0.012066 m -0.26245571,0.034474 0.0120901,0 0,0.012066 -0.0120901,0 0,-0.012066 m -0.59251196,0.077841 0.01209017,0 0,0.012066 -0.01209017,0 0,-0.012066 m 0,0 0.01209017,0 0,0.012066 -0.01209017,0 0,-0.012066 m 9.92611577,-2.6065581 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m 0,0 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.034826,0.00458 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.262544,0.034474 0.012087,0 0,0.012066 -0.012087,0 0,-0.012066 m -0.6848459,0.089967 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.4099589,0.053853 0.01209,0 0,0.012066 -0.01209,0 0,-0.012066 m -0.2624242,0.034474 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.6849647,0.089967 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.409965,0.053852 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.2624305,0.034474 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.6849091,0.08998 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.4099335,0.053841 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.2624619,0.034486 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.6849027,0.089967 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.4099521,0.053853 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.2624619,0.034474 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.6849026,0.089968 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.409946,0.053852 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.2624619,0.034474 0.01209,0 0,0.012066 -0.01209,0 0,-0.012066 m -0.6849026,0.089967 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.4099398,0.053853 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.2624744,0.034474 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.68490258,0.089979 0.0120964,0 0,0.012066 -0.0120964,0 0,-0.012066 m -0.4099397,0.053841 0.0120964,0 0,0.012066 -0.0120964,0 0,-0.012066 m -0.26246821,0.034486 0.0120901,0 0,0.012066 -0.0120901,0 0,-0.012066 m -0.12759708,0.016761 0.01209017,0 0,0.012066 -0.01209017,0 0,-0.012066 m 0,0 0.01209017,0 0,0.012066 -0.01209017,0 0,-0.012066 m 9.92611577,-2.60656569 0.012096,0 0,0.0120664 -0.012096,0 0,-0.0120664 m -0.089848,0.0117945 0.012096,0 0,0.0120665 -0.012096,0 0,-0.0120665 m -0.4099584,0.0538505 0.01209,0 0,0.0120664 -0.01209,0 0,-0.0120664 m -0.262425,0.034477 0.01209,0 0,0.0120664 -0.01209,0 0,-0.0120664 m -0.6849653,0.0899704 0.01209,0 0,0.012066 -0.01209,0 0,-0.012066 m -0.4098397,0.053849 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.2625489,0.034478 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.6848774,0.089968 0.012096,0 0,0.01207 -0.012096,0 0,-0.01207 m -0.4099401,0.053856 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.2624557,0.034474 0.01209,0 0,0.012066 -0.01209,0 0,-0.012066 m -0.6849026,0.089967 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.4099521,0.053853 0.01209,0 0,0.012067 -0.01209,0 0,-0.012067 m -0.2624621,0.034474 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.6849025,0.089968 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.4099521,0.053852 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.2624559,0.034474 0.01209,0 0,0.012066 -0.01209,0 0,-0.012066 m -0.6849088,0.08998 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.4099334,0.053841 0.01209,0 0,0.012066 -0.01209,0 0,-0.012066 m -0.2624744,0.034486 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.6849026,0.089967 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.4099398,0.053852 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.2624743,0.034474 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.68490263,0.089968 0.0120964,0 0,0.012066 -0.0120964,0 0,-0.012066 m -0.33509015,0.044018 0.01209018,0 0,0.012066 -0.01209018,0 0,-0.012066 M 5.996848,0.02663792 l 0.01209,0 0,0.01206644 -0.01209,0 0,-0.01206644 m -0.6793273,0.08923644 0.01209,0 0,0.0120664 -0.01209,0 0,-0.0120664 m -0.4099522,0.0538504 0.012091,0 0,0.0120664 -0.012091,0 0,-0.0120664 m -0.262462,0.034477 0.012096,0 0,0.0120664 -0.012096,0 0,-0.0120664 m -0.6849026,0.0899691 0.012096,0 0,0.0120665 -0.012096,0 0,-0.0120665 m -0.4099397,0.0538498 0.012096,0 0,0.0120665 -0.012096,0 0,-0.0120665 m -0.2624682,0.0344777 0.012091,0 0,0.0120665 -0.012091,0 0,-0.0120665 m -0.6849025,0.0899697 0.01209,0 0,0.0120664 -0.01209,0 0,-0.0120664 m -0.4099398,0.0538504 0.012091,0 0,0.0120664 -0.012091,0 0,-0.0120664 m -0.2624621,0.034477 0.012096,0 0,0.0120665 -0.012096,0 0,-0.0120665 m -0.6849149,0.0899684 0.012091,0 0,0.0120665 -0.012091,0 0,-0.0120665 m -0.40993969,0.0538505 0.0120963,0 0,0.0120665 -0.0120963,0 0,-0.0120665 m -0.262462,0.034477 0.0120964,0 0,0.0120665 -0.0120964,0 0,-0.0120665 m -0.55509029,0.0729176 0.01209018,0 0,0.0120665 -0.01209018,0 0,-0.0120665 m 0,0 0.01209018,0 0,0.0120665 -0.01209018,0 0,-0.0120665 m 9.92611198,8.47529644 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m 0,0 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.012694,0.00969 0.012087,0 0,0.012066 -0.012087,0 0,-0.012066 m -0.6501384,0.4977165 0.012096,0 0,0.012069 -0.012096,0 0,-0.012069 m -0.1775263,0.1359648 0.01209,0 0,0.012069 -0.01209,0 0,-0.012069 m 0,0 0.01209,0 0,0.012069 -0.01209,0 0,-0.012069 m 0.8403581,-1.6371147 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m 0,0 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.044502,0.034003 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.6500127,0.4977172 0.012095,0 0,0.012066 -0.012095,0 0,-0.012066 m -0.6801242,0.5206792 0.01209,0 0,0.012067 -0.01209,0 0,-0.012067 m -0.6080493,0.465546 0.01209,0 0,0.012069 -0.01209,0 0,-0.012069 m -0.1556411,0.1191687 0.01209,0 0,0.012069 -0.01209,0 0,-0.012069 m 0,0 0.01209,0 0,0.012069 -0.01209,0 0,-0.012069 m 0,0 0.01209,0 0,0.012069 -0.01209,0 0,-0.012069 m 2.1383308,-2.6308703 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m 0,0 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.076185,0.05833 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.6501316,0.4977039 0.012091,0 0,0.012067 -0.012091,0 0,-0.012067 m -0.6800051,0.5206917 0.01209,0 0,0.012067 -0.01209,0 0,-0.012067 m -0.6081739,0.4655475 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.6500133,0.4977047 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.6800741,0.5206915 0.012091,0 0,0.012069 -0.012091,0 0,-0.012069 m -0.091706,0.070198 0.012096,0 0,0.012069 -0.012096,0 0,-0.012069 m 3.4362923,-3.6246269 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m 0,0 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.1079906,0.082655 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.6501376,0.4977045 0.012095,0 0,0.012066 -0.012095,0 0,-0.012066 m -0.6800003,0.5206795 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.6080548,0.4655593 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.6501317,0.4977039 0.01209,0 0,0.012067 -0.01209,0 0,-0.012067 m -0.6800429,0.52068 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.6080618,0.4655474 0.01209,0 0,0.012066 -0.01209,0 0,-0.012066 m -0.6500757,0.4977158 0.012096,0 0,0.012069 -0.012096,0 0,-0.012069 m -0.099758,0.076376 0.012096,0 0,0.012069 -0.012096,0 0,-0.012069 m 0,0 0.012096,0 0,0.012069 -0.012096,0 0,-0.012069 m 4.7342533,-4.6183822 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m 0,0 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.139793,0.1069695 0.012087,0 0,0.012067 -0.012087,0 0,-0.012067 m -0.650014,0.4977162 0.01209,0 0,0.012067 -0.01209,0 0,-0.012067 m -0.6801298,0.5206793 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.60805,0.4655475 0.012091,0 0,0.012067 -0.012091,0 0,-0.012067 m -0.6500126,0.4977164 0.01209,0 0,0.012067 -0.01209,0 0,-0.012067 m -0.6801179,0.5206793 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.6080741,0.4655474 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.6500633,0.4977157 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.680074,0.52068 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.6080741,0.4655475 0.01209,0 0,0.012069 -0.01209,0 0,-0.012069 m -0.077824,0.059585 0.012096,0 0,0.012069 -0.012096,0 0,-0.012069 m 0,0 0.012096,0 0,0.012069 -0.012096,0 0,-0.012069 m 0,0 0.012096,0 0,0.012069 -0.012096,0 0,-0.012069 m 6.032227,-5.6121259 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m 0,0 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.1714777,0.1312831 0.012087,0 0,0.012067 -0.012087,0 0,-0.012067 m -0.6501384,0.4977044 0.012097,0 0,0.012066 -0.012097,0 0,-0.012066 m -0.6800051,0.5206912 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.6081677,0.4655474 0.01209,0 0,0.012067 -0.01209,0 0,-0.012067 m -0.6500203,0.4977045 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.6800736,0.520691 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.6080618,0.4655476 0.012091,0 0,0.012067 -0.012091,0 0,-0.012067 m -0.6500756,0.4977045 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.6800802,0.520691 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.6080618,0.4655476 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 M 3.307962,9.399359 l 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.6800739,0.5206795 0.012091,0 0,0.012069 -0.012091,0 0,-0.012069 m -0.01387,0.010632 0.012091,0 0,0.012069 -0.012091,0 0,-0.012069 m 7.3301817,-6.605882 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m 0,0 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.2032868,0.1556091 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.6500137,0.4977043 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.6801242,0.5206788 0.01209,0 0,0.012067 -0.01209,0 0,-0.012067 m -0.6080486,0.46556 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.6501387,0.4977044 0.012097,0 0,0.012066 -0.012097,0 0,-0.012066 m -0.6800301,0.5206793 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.6080743,0.4655594 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.6500756,0.4977043 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.680065,0.5206846 0.01209,0 0,0.012066 -0.01209,0 0,-0.012066 m -0.6080743,0.4655482 0.01209,0 0,0.012066 -0.01209,0 0,-0.012066 m -0.6500632,0.4977157 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.6800802,0.5206792 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.6080742,0.4655476 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.6500632,0.4977157 0.012096,0 0,0.012069 -0.012096,0 0,-0.012069 m -0.021947,0.0168 0.012091,0 0,0.012069 -0.012091,0 0,-0.012069 m 0,0 0.012091,0 0,0.012069 -0.012091,0 0,-0.012069 m 8.6281553,-7.5996385 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m 0,0 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.2350892,0.1799232 0.012087,0 0,0.012065 -0.012087,0 0,-0.012065 m -0.6500143,0.4977163 0.01209,0 0,0.012066 -0.01209,0 0,-0.012066 m -0.6801305,0.5206793 0.012097,0 0,0.012066 -0.012097,0 0,-0.012066 m -0.6080492,0.4655475 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.6500507,0.4977162 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.6800739,0.5206793 0.01209,0 0,0.012067 -0.01209,0 0,-0.012067 M 5.8327265,5.47885 l 0.012091,0 0,0.012067 -0.012091,0 0,-0.012067 m -0.6500757,0.4977162 0.012091,0 0,0.012067 -0.012091,0 0,-0.012067 m -0.6800802,0.5206795 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.6080618,0.465547 0.012091,0 0,0.012067 -0.012091,0 0,-0.012067 m -0.6500756,0.4977165 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.680074,0.5206792 0.01209,0 0,0.012067 -0.01209,0 0,-0.012067 m -0.608068,0.4655482 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.6500689,0.4977129 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.68008026,0.5206793 0.0120964,0 0,0.012066 -0.0120964,0 0,-0.012066 m -0.60806181,0.4655474 0.01209017,0 0,0.012069 -0.01209017,0 0,-0.012069 M 9.944196,2.3310377 l 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m 0,0 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.2350892,0.1799232 0.012087,0 0,0.012066 -0.012087,0 0,-0.012066 m -0.6500138,0.4977163 0.01209,0 0,0.012066 -0.01209,0 0,-0.012066 m -0.6801305,0.5206794 0.012097,0 0,0.012066 -0.012097,0 0,-0.012066 m -0.6080492,0.4655474 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.6500507,0.4977162 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.6800739,0.5206794 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.6080617,0.4655476 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.6500758,0.4977161 0.012091,0 0,0.012067 -0.012091,0 0,-0.012067 m -0.6800801,0.5206795 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 M 3.8945094,6.96279 l 0.01209,0 0,0.012066 -0.01209,0 0,-0.012066 m -0.6500756,0.4977165 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.680074,0.5206791 0.01209,0 0,0.012067 -0.01209,0 0,-0.012067 m -0.608068,0.4655483 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.6500694,0.4977157 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.68008026,0.5206793 0.0120964,0 0,0.012066 -0.0120964,0 0,-0.012066 m -0.60806181,0.4655474 0.01209017,0 0,0.012069 -0.01209017,0 0,-0.012069 m 9.92611577,-8.5933944 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m 0,0 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.2667739,0.2042491 0.012087,0 0,0.012066 -0.012087,0 0,-0.012066 m -0.6501381,0.4977162 0.012095,0 0,0.012066 -0.012095,0 0,-0.012066 m -0.6800058,0.5206794 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.6081677,0.4655475 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.6500133,0.4977044 0.01209,0 0,0.012066 -0.01209,0 0,-0.012066 m -0.6800802,0.5206912 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.6080618,0.4655474 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.6500756,0.4977045 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.680074,0.5206911 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.6080681,0.4655475 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.6500694,0.4977045 0.012091,0 0,0.012067 -0.012091,0 0,-0.012067 m -0.6800677,0.5206914 0.01209,0 0,0.012066 -0.01209,0 0,-0.012066 m -0.6080742,0.4655468 0.012091,0 0,0.012068 -0.012091,0 0,-0.012068 m -0.6500757,0.4977047 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.68006774,0.5206792 0.0120964,0 0,0.012066 -0.0120964,0 0,-0.012066 m -0.57630253,0.4412334 0.01209017,0 0,0.012067 -0.01209017,0 0,-0.012067 m 9.92611577,-8.59338702 0.012096,0 0,0.0120664 -0.012096,0 0,-0.0120664 m 0,0 0.012096,0 0,0.0120664 -0.012096,0 0,-0.0120664 m -0.298584,0.22856523 0.012096,0 0,0.0120665 -0.012096,0 0,-0.0120665 M 8.9955997,1.069809 l 0.012095,0 0,0.012066 -0.012095,0 0,-0.012066 m -0.6801242,0.5206751 0.01209,0 0,0.012066 -0.01209,0 0,-0.012066 m -0.6080492,0.4655599 0.01209,0 0,0.012066 -0.01209,0 0,-0.012066 m -0.6500882,0.4977044 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.6800802,0.5206788 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.6080743,0.4655599 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.6500571,0.4977044 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.68008,0.5206787 0.012091,0 0,0.012067 -0.012091,0 0,-0.012067 m -0.608062,0.4655599 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.6500756,0.4977044 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.6800801,0.5206794 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.6080618,0.4655593 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.6500757,0.4977042 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.68007393,0.5206799 0.0120902,0 0,0.012066 -0.0120902,0 0,-0.012066 m -0.54453704,0.4169201 0.01209017,0 0,0.012067 -0.01209017,0 0,-0.012067 m 8.94571587,-7.84280282 0.01209,0 0,0.0120671 -0.01209,0 0,-0.0120671 m -0.6801235,0.52068188 0.01209,0 0,0.0120664 -0.01209,0 0,-0.0120664 m -0.6080555,0.46554994 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.6500508,0.4977119 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.680074,0.5206794 0.01209,0 0,0.012066 -0.01209,0 0,-0.012066 m -0.6080619,0.4655475 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.6500756,0.4977162 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.6800802,0.5206794 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.6080618,0.4655475 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.6500756,0.4977162 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.680074,0.5206793 0.01209,0 0,0.012067 -0.01209,0 0,-0.012067 m -0.6080618,0.4655475 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.6500757,0.4977163 0.012091,0 0,0.012067 -0.012091,0 0,-0.012067 m -0.6800677,0.5206793 0.0120964,0 0,0.012067 -0.0120964,0 0,-0.012067 m -0.51277777,0.3925936 0.01209017,0 0,0.012067 -0.01209017,0 0,-0.012067 M 7.762084,0.02663671 l 0.012097,0 0,0.01206645 -0.012097,0 0,-0.01206645 m 0,0 0.012097,0 0,0.01206645 -0.012097,0 0,-0.01206645 m -0.1181511,0.09053591 0.012096,0 0,0.0120664 -0.012096,0 0,-0.0120664 m -0.6501319,0.49771061 0.012091,0 0,0.0120664 -0.012091,0 0,-0.0120664 M 6.3137331,1.135565 l 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.6080743,0.4655501 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.6500756,0.4977162 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.6800616,0.5206793 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.6080741,0.4655476 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.6500633,0.4977044 0.01209,0 0,0.012066 -0.01209,0 0,-0.012066 m -0.6800801,0.5206912 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.6080743,0.4655475 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.6500633,0.4977044 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.68007389,0.5206912 0.0120901,0 0,0.012067 -0.0120901,0 0,-0.012067 m -0.48101228,0.3682678 0.01209017,0 0,0.012067 -0.01209017,0 0,-0.012067 m 6.44607987,-5.92902799 0.012096,0 0,0.01206645 -0.012096,0 0,-0.01206645 m -0.1821926,0.13949457 0.01209,0 0,0.0120665 -0.01209,0 0,-0.0120665 m -0.6080618,0.46554998 0.012091,0 0,0.0120665 -0.012091,0 0,-0.0120665 m -0.6500756,0.49771064 0.012091,0 0,0.012067 -0.012091,0 0,-0.012067 M 4.34375,1.6500682 l 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.6080618,0.4655598 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.6500757,0.4977044 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.6800739,0.5206788 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.6080681,0.46556 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.6500694,0.4977044 0.012091,0 0,0.012067 -0.012091,0 0,-0.012067 m -0.68008021,0.5206794 0.0120964,0 0,0.012065 -0.0120964,0 0,-0.012065 m -0.44924056,0.3439536 0.01209017,0 0,0.012066 -0.01209017,0 0,-0.012066 m 4.97397807,-4.80195055 0.012096,0 0,0.0120664 -0.012096,0 0,-0.0120664 m -0.6800678,0.52068126 0.012096,0 0,0.0120664 -0.012096,0 0,-0.0120664 m -0.6080741,0.46555119 0.012096,0 0,0.012067 -0.012096,0 0,-0.012067 m -0.6500695,0.4977119 0.01209,0 0,0.012066 -0.01209,0 0,-0.012066 m -0.6800677,0.5206794 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.6080743,0.4655475 0.012091,0 0,0.012066 -0.012091,0 0,-0.012066 m -0.6500632,0.4977161 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.68008017,0.5206795 0.0120964,0 0,0.012066 -0.0120964,0 0,-0.012066 m -0.4174813,0.31964 0.01209017,0 0,0.012066 -0.01209017,0 0,-0.012066 m 3.85015177,-3.94152819 0.01209,0 0,0.01206645 -0.01209,0 0,-0.01206645 m 0,0 0.01209,0 0,0.01206645 -0.01209,0 0,-0.01206645 m -0.1960687,0.15011999 0.01209,0 0,0.0120664 -0.01209,0 0,-0.0120664 m -0.6500756,0.49770939 0.012091,0 0,0.0120665 -0.012091,0 0,-0.0120665 m -0.6800803,0.52068551 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.6080617,0.4655476 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.6500757,0.4977044 0.012096,0 0,0.012066 -0.012096,0 0,-0.012066 m -0.68007395,0.5206912 0.0120901,0 0,0.012066 -0.0120901,0 0,-0.012066 m -0.38571582,0.295314 0.01209017,0 0,0.012066 -0.01209017,0 0,-0.012066 m 2.55219077,-2.94777209 0.012091,0 0,0.01206645 -0.012091,0 0,-0.01206645 m -0.2600166,0.19907742 0.01209,0 0,0.0120665 -0.01209,0 0,-0.0120665 m -0.6080743,0.46555127 0.012091,0 0,0.0120664 -0.012091,0 0,-0.0120664 m -0.6500756,0.4977106 0.012091,0 0,0.012064 -0.012091,0 0,-0.012064 m -0.68006773,0.5206762 0.0120964,0 0,0.012066 -0.0120964,0 0,-0.012066 m -0.35395654,0.2710005 0.01209017,0 0,0.012066 -0.01209017,0 0,-0.012066 m 1.00226507,-1.76111056 0.012096,0 0,0.0120664 -0.012096,0 0,-0.0120664 m -0.68007402,0.52068125 0.0120901,0 0,0.0120665 -0.0120901,0 0,-0.0120665 m -0.32219105,0.24667696 0.01209017,0 0,0.0120665 -0.01209017,0 0,-0.0120665",
    "sandstone":     "M 9.8299613,4.1491679 9.5758947,4.1309646 M 9.9572966,4.1624727 9.8299613,4.1494461 M 5.4794304,9.1460378 5.5848626,9.4632105 m -0.09793,-0.5387085 0,0.2216689 m 3.0957706,0.1802428 0,0.08561 m -0.015705,-0.203514 0.015705,0.1179041 m -0.015705,-0.2560556 0,0.1381515 m 1.3040393,-0.081631 0.086259,0.00457 M 9.3189286,9.1422158 9.8710372,9.127 M 8.9737702,9.103838 9.3189286,9.141877 M 8.5669979,9.0703581 8.9737702,9.1039707 M 8.252888,9.0808084 8.5669979,9.0705879 m -0.9123685,0.00255 0.5982586,0 m -1.1043863,0 0.5061277,0 m -1.024107,0.031278 0.5180035,-0.030927 M 9.1657397,8.5920772 9.4256052,8.545547 M 8.7531684,8.570923 9.1657397,8.592029 M 3.1364243,8.924502 3.0849465,9.4407014 M 0.31791616,8.924502 0.38206707,8.4496803 M 3.3261467,6.1271823 3.0717418,6.1131639 m 0.5878567,0.014018 -0.3334518,0 m 0.5278375,-0.057791 -0.1943253,0.057997 m 5.6793245,1.4999754 0.080944,0.070551 M 8.9111898,7.5933878 9.3389834,7.6274238 M 8.6037246,7.6154858 8.9111898,7.5934604 m -0.6381263,-7.26e-5 0.3306611,0.022207 m -0.7362253,0.0029 0.4055642,-0.025255 M 3.6681519,3.3573671 3.6041339,3.2794135 m 0.1265863,0.2344898 -0.06246,-0.1565846 m 0.034818,0.2955223 0.027702,-0.1389256 m 0.287918,-1.1278179 0.010523,-0.1432677 m -0.021988,0.4070159 0.011513,-0.2637482 m 0.017143,0.4701771 -0.028814,-0.2064047 m -0.00281,0.4435313 0.031532,-0.2371386 m 3.490655,1.3848773 0.1833919,0.056291 m -0.3901004,-0.056291 0.2067085,0 m -0.5499339,0.0044 0.3432254,0 m -0.6380176,-0.0044 0.2948284,0 m -0.6732221,0.026428 0.3784058,-0.026235 m -0.4972118,0.017417 0.118806,0.00881 m -0.4092006,-0.013208 0.2904308,0 M 5.739783,4.2927059 5.894156,4.2544369 m 3.0102722,-1.0184408 0.167928,-0.025339 m -0.5231138,0.025339 0.3551858,0 m -0.7472191,0.050764 0.3920333,-0.051042 m -0.7033646,0.00727 0.3112104,0.044571 m 0.5812242,0.2669291 0.3079485,-0.061274 m -0.5985002,0.061274 0.2905517,0 m -0.65951,0.00923 0.3689583,-0.00911 m -0.6387304,-0.024082 0.2697721,0.033298 m 1.7593779,0.2709932 0.1191201,-0.00294 m -0.3858719,-0.00351 0.2667518,0.00636 M 8.9003168,3.7546706 9.075131,3.766415 M 8.7124549,3.779647 8.9003168,3.754719 m -1.1903557,0.5422162 0.024525,0.4036414 m 0.01788,-0.5949029 -0.042163,0.1912978 m 0.06101,-0.5452763 -0.019088,0.3539664 m -3.7760118,1.378612 0.047733,0.205171 m -0.047733,-0.4257393 0,0.2205683 M 3.9446291,5.083656 3.9760521,5.2637173 M 3.95787,4.8585762 3.944774,5.083668 m 0.2487147,-0.6800169 0.018726,-0.077155 m -0.018726,0.2685741 0,-0.1914188 m 0.071677,0.347314 -0.07239,-0.1555686 M 3.1053878,3.9647281 3.0420464,3.8422399 m 0.070542,0.3388594 -0.019451,0.1021561 M 1.7924447,3.5745003 2.0271573,3.5610504 m -0.4678667,0.065653 0.2331541,-0.052191 m -0.6994503,0.046651 0.4663324,0 M 0.82875551,3.597832 1.0929582,3.6214902 M 0.64223463,3.6211636 0.82876759,3.5979287 m -0.41978372,0.030734 0.23325076,-0.0076 M 0.40898387,3.7879082 0.445626,4.1554212 m -0.0366421,-0.5267585 0,0.1592455 M 0.36001897,3.4816575 0.4088993,3.6286869 m -0.0282941,-0.34579 -0.02055,0.1987727 m 1.4015101,0.6798596 0.2190191,0.067237 m -0.6229645,-0.067237 0.4039454,0 m -0.6915976,0.036757 0.2876522,-0.036794 m -0.91190934,-0.00608 0.62428134,0.042587 m -0.73444935,-0.036467 0.11016801,-0.00606 m 4.23827284,-0.3707544 0,-0.079574 m 0.010801,0.2197337 -0.010873,-0.1401472 m 5.2733857,5.6407221 -0.8992,0 m 2.416e-4,0.017925 -0.094837,0.3168461 m 1.208e-4,2.42e-5 0.057265,0.1916849 M 9.0096512,0.03368758 9.0208867,0.0714966 m 4.832e-4,9.880312 0,0.00953 m 0,-9.88996466 0,0.31917252 m 0.00991,-1.5603e-4 -0.4482107,0.0601979 M 8.582945,0.45020718 8.2243765,0.37048765 m 0,-3.387e-5 0,-0.3367662 m 0,9.92765212 0,-0.1093528 m -0.00991,1.209e-4 0.2489925,-0.1097519 m 0,9.68e-5 0.5001596,0.017913 m -0.5001596,-0.017913 0,-0.3391014 m -0.00991,1.452e-4 0.6047823,0.039382 M 8.4535559,9.4034965 7.626722,9.3837571 m 0,-2.056e-4 -0.2492342,0.089251 m 1.209e-4,4.718e-4 -0.318737,0 m 0,0 -0.4282889,-0.1297816 m -6.04e-5,1.814e-4 0,-0.2392554 m 0,0 -0.01196,-0.1799283 m 0.01196,0.4191837 -0.3186645,0.070237 M 6.3117492,9.4134629 5.982852,9.3545714 m 1.691e-4,-9.193e-4 -0.3984363,0.1097641 m -2.42e-5,-8.47e-5 -0.6760732,-0.035874 m -2.42e-5,1.693e-4 -0.3101473,-0.1009829 m 3.63e-5,-1.451e-4 -0.2987669,0.047546 m -7.25e-5,-4.597e-4 -0.5279704,0.039805 m 0,7.25e-5 -0.686463,0.027311 m -1.21e-5,-6.05e-5 -0.5686597,-0.087279 m -2.42e-5,2.177e-4 -0.2420941,-0.078824 m 5.9401806,0.57728 -0.1196034,-0.109631 m 0,-3.62e-5 -0.6474288,0.029924 m 0,-1.21e-5 -0.069708,-0.2991024 m 0.069708,0.2991024 0,0.1889877 m 0,-9.92765212 0,0.35670395 m 0,0 0.109576,0.009813 m 0,1.5724e-4 0.6673628,-0.02988 m -0.7769388,0.0199099 -0.1107841,0.0330308 m 1.208e-4,1.0644e-4 -0.4870878,0.0367235 m 0,-7.499e-5 -0.3885177,-0.0298159 m 1.2e-5,-9.192e-5 -0.4582984,0.10942052 m 6.04e-5,2.407e-4 -0.4780753,-0.14981369 m 0.02049,9.57122277 0.00925,-0.1391433 M 5.5247831,0.39039153 5.5484984,0.03368758 m 0.00617,9.78850882 0.029478,-0.3589254 m -0.029478,0.3589254 -0.4383162,0 m -1.2e-5,2.42e-5 -0.2390498,-0.059932 m -1.2e-5,9.68e-5 0,-0.1993896 m 0,0 0.031483,-0.1353091 m -0.03148,0.3346989 -0.4148184,0.038753 M 4.4400166,0.03368758 4.42802,0.09381565 M 4.462488,9.8014289 4.430594,9.9613397 M 4.427964,0.09380234 4.451075,0.35875772 m -9.67e-5,8.46e-6 0.5179793,0.0463767 m 3.63e-5,-2.9634e-4 0.2762717,0 m 0,0 0.2795337,-0.0143026 m 3.5064813,-1.524e-4 0.1508935,0.0720367 m 0,1.935e-5 0.2764167,0 M 9.45847,0.46690259 9.9573007,0.40736389 M 9.4584659,0.4669022 9.4350285,0.68573479 m 4.832e-4,5.08e-5 0.023075,0.13821922 m -1.208e-4,2.298e-5 -0.062218,0.40135291 m 8.457e-4,1.452e-4 0.095804,0.066391 m 0,-2.42e-5 0.4643994,0 M 9.4584659,0.82402779 9.9572966,0.77937227 M 9.3970937,1.2255259 9.1493093,1.2920979 M 9.1491885,1.2918923 8.138117,1.3263878 m 0,7.26e-5 -0.6367974,0 M 7.5014404,1.337975 7.189626,1.2039601 m -2.417e-4,4.233e-4 -0.034262,-0.36866559 m -2.175e-4,2.177e-5 0.040037,-0.40162024 M 7.1549047,0.83573837 6.4672336,0.79925196 m 2.42e-5,-3.5318e-4 -0.4092852,0.0293164 m 0,-5.927e-5 -0.054885,-0.28825304 m 0.054885,0.28825304 0.029949,0.42905939 m -7.128e-4,4.84e-5 0.4385216,0 m 0,0 0.6636538,-0.05282 m 0.3120561,0.1335311 0.076232,0.3094923 m 4.832e-4,-1.089e-4 0.5262549,-0.038995 m 0,-1.21e-5 0.574942,0 m 0,0 0.3897379,0.083735 m 0,-4.112e-4 0.086139,-0.3081013 m 0.00157,4.717e-4 -0.00749,-0.092153 m -0.080219,0.399783 0,0.4229695 m 9.665e-4,0 -0.4229611,0 m 0,0 -0.6091316,0 m 0,-0.00847 -0.4652451,0.033334 m 0,5.322e-4 0,-0.4927226 m 0,0.4927226 -0.2284545,0.1184847 m 1.208e-4,3.63e-5 -0.1777137,-0.042406 m 0,7.26e-5 -0.7275269,0 m 0,0 -0.4740039,0 m 0,0 -0.09323,-0.033383 m 1.691e-4,-4.717e-4 -0.7103475,0.025436 m 0,-4.84e-5 -0.4821949,0 m 0,0 -0.6502558,0.035838 m -3.63e-5,-7.741e-4 -0.5176893,0.015446 m 1.1679814,-0.05051 0,-0.2710416 m 0.00846,1.331e-4 0.051913,-0.1859397 m -0.00116,-3.145e-4 0.4061441,-0.041559 m -7.25e-5,-7.741e-4 0.3975907,0.050848 m 1.21e-5,-4.83e-5 0.287785,0.04122 m -1.57e-4,0.0011 0.067582,-0.1016481 m 9.67e-5,6.04e-5 -0.025165,-0.2793993 M 5.8723457,1.420416 6.0873056,1.2573967 M 5.8723457,1.420416 5.6777425,1.369725 m 3.63e-5,-1.089e-4 -0.964402,0.025594 m 0,-1.936e-4 0.024815,0.3556234 M 4.7133768,1.395016 4.3497825,1.3429341 m -1.812e-4,0.00128 -0.2793041,0.050026 m 1.45e-4,7.741e-4 -0.6096753,0.075946 m 2.3692827,0.330429 -0.033114,0.2371629 m -7.248e-4,-1.089e-4 0.075459,0.1441386 M 9.070057,2.1146448 9.240522,2.2611177 m 2.416e-4,-3.507e-4 0.3084318,0 m 0,0 0.286444,0.033092 m 0,-2.42e-5 0.1216572,-0.00968 m -0.1216572,0.00968 -0.034914,0.4001095 m 6.041e-4,4.84e-5 0.1559676,0.012422 M 9.801329,2.6939932 9.681484,2.7238563 m 0,-7.26e-5 -0.3346479,0.019183 m 0,7.26e-5 L 9.236656,2.723312 m -1.208e-4,4.717e-4 -0.053761,-0.2312362 m 0.00109,-2.661e-4 0.057144,-0.2314781 m -1.8966197,-0.00224 -0.0476,0.2044574 m 7.248e-4,1.814e-4 0.00785,0.1289591 m 0,1.21e-5 0.0923,0.4134869 m -1.209e-4,4.84e-5 0.432626,0 m 0,0 0.073574,0.02638 m 1.208e-4,-4.84e-5 0.8041214,-0.041136 m 0,9.435e-4 0.4368544,-0.033528 m 0,-1.21e-5 0.091696,-0.2345382 m -0.091696,0.2345382 0.2841486,0.010704 m 0,-1.693e-4 0.5283087,0 M 8.1044106,1.6083514 8.1371506,1.3263515 M 4.4509742,0.35876618 3.9601896,0.49268677 m -2.42e-5,-7.983e-5 -0.242517,0.0274283 m 2.42e-5,1.4151e-4 -0.6539406,0 M 4.4624876,9.8014289 4.1038224,9.7871565 m -1.21e-5,3.024e-4 -0.3706376,0.072402 M 3.7331123,9.8595948 3.341828,9.8492171 m 0,7.25e-5 -0.4633604,0.010378 M 2.8615419,0.03368758 2.7760919,0.30911414 M 2.8784555,9.8595948 2.8468995,9.9613397 m -0.071412,-9.65241546 0.086537,0.18595418 m 9.907e-4,-4.6446e-4 0.2008008,0.0154093 m 0.2780114,9.33946634 0,-0.1855647 m 0.00515,7.26e-5 0.046972,-0.23553 m 3.0451988,-7.2120351 0.026458,0.3979445 m -6.04e-4,3.63e-5 -0.1535273,0.4398786 m 0.0019,6.652e-4 0.3089029,0.023283 m 1.21e-5,-9.67e-5 0.4633242,-0.069874 m 4.83e-5,3.145e-4 0.3118869,0 M 6.3133681,3.054757 6.1049682,3.1400525 M 6.1048595,3.1397743 5.6415112,3.1634688 M 5.641487,3.1629487 5.4098551,3.1392542 m -4.83e-5,5.201e-4 -0.432469,-0.038729 m 0,8.47e-5 -0.4710923,0 m 0,0 -0.5020443,0 M 4.0042616,3.0934 3.604146,3.2796796 M 5.641487,3.1629487 5.6184482,3.4023129 m -1.208e-4,-1.21e-5 0.069503,0.1161745 M 5.754192,3.7684349 5.2089939,3.7196186 m 2.42e-5,-1.935e-4 -0.262463,-0.047002 m -1.088e-4,6.29e-4 -0.2590923,0.03227 m -1.21e-5,-1.089e-4 -0.9842754,-0.052227 m 1.2433798,0.020066 0.070252,-0.2767868 m -7.25e-5,-2.42e-5 0.00696,-0.109631 m 8.46e-5,0 -0.046247,-0.1855042 m 0.039203,0.2951352 0.1460491,0.021796 m 0,-3.63e-5 0.4556526,-0.015542 M 7.3053634,2.5921757 6.8797565,2.623708 m 0,-4.84e-5 -0.4147579,-0.00958 M 7.8301685,3.005711 7.845874,3.2429706 m 0,1.21e-5 -0.036848,0.1253306 m 0,0 0,0.1622088 m 0,0 -0.038539,0.2210521 M 9.0419079,2.973199 9.0719899,3.2108457 m 3.625e-4,-4.84e-5 -0.026216,0.2825321 m 1.208e-4,1.21e-5 0.029357,0.2730614 m -4.833e-4,4.84e-5 0.4962937,0.061819 M 2.8630158,0.49441396 2.2940903,0.47669569 m 1.21e-5,-2.9754e-4 -0.5673067,0.0956126 m 3.63e-5,2.3465e-4 -0.044459,0.26537737 m 2.537e-4,4.355e-5 0.0328,0.28188378 m -7.248e-4,8.22e-5 -0.1500237,0.293079 m 8.45e-5,3.63e-5 0.4193005,0.075087 m 4.83e-5,-2.782e-4 0.1989162,-0.015833 m 0,0 0.5746399,0 m 0,0 0.703135,0 m -1.4766911,0.015833 0.044265,0.3011949 m -6.04e-5,0 0.082116,0.176457 m -0.00108,4.959e-4 0.3536515,-0.044051 m -2.42e-5,-1.814e-4 0.3093621,-0.088646 m 4.83e-5,1.693e-4 0,-0.2064411 m 0,0 -0.014413,-0.1548549 m 0.014413,0.361296 0.2502972,0.059762 m 1.933e-4,-7.862e-4 0.3021859,0.043301 m -1.329e-4,9.434e-4 0.1768197,-0.022025 m -1.21e-5,-9.67e-5 0.044302,-0.2432831 m -9.67e-5,-2.42e-5 -0.085643,-0.1993653 m 0.041438,0.4426726 0,0.3446167 m 0.00981,-1.451e-4 -0.2090522,0.074869 m 3.262e-4,9.071e-4 -0.7293753,0 m 3.62e-5,0.00738 -0.4346556,0.022231 m -1.21e-5,-1.209e-4 -0.04412,-0.176965 m -8.46e-5,2.41e-5 0.014715,-0.2211851 M 2.8784555,9.8595948 2.7878227,9.7153231 m -1.208e-4,7.26e-5 0.038164,-0.3143787 M 3.9601654,0.49260694 3.9957927,0.7860706 m 1.208e-4,-1.451e-5 0.088603,0.22847971 m -1.933e-4,7.74e-5 0,0.3806568 M 1.682627,0.83766635 1.5868839,0.87459423 m -2.41e-5,-6.41e-5 -0.67776464,-0.015171 m -1.209e-5,4.2454e-4 -0.5746399,0 m 0,0 -0.0664946,0.30961563 m 1.933e-4,4.23e-5 0.0573855,0.2465959 m -9.9066e-4,2.298e-4 0.6508478,0.018651 m 0,-6.04e-5 0.58936679,-0.022219 m 0.7094414,7.8625033 -0.1645332,0 m 2.42e-5,-0.00294 -0.9945565,-0.022267 m 0,1.451e-4 0.026736,-0.3256393 m -0.026736,0.3256393 -0.29462304,0.030141 m -6.04e-5,-6.531e-4 -0.56731873,0 m 4.833e-5,-0.00737 -0.21203627,0.081776 m 0,-8.94231893 0.20460636,0.0641167 m 6.041e-5,-2.032e-4 0.48633877,-0.0580594 m -1.0873e-4,-9.2287e-4 0.530435,0 m 0,0 0.4197595,0.0601338 m 1.692e-4,-0.001151 0.044893,0.0964629 M 0.24580336,0.4755693 0.29010496,0.71885357 m -9.665e-5,1.814e-5 0.0444224,0.14091404 M 2.1388233,2.3638303 1.9883768,2.4128159 m 3.62e-5,1.088e-4 -0.2823485,-0.00778 m 0,-6.05e-5 -0.051695,0.3147537 m -3.624e-4,-6.05e-5 0.027327,0.1500774 m -8.45e-5,2.42e-5 -0.050052,0.340589 m 2.416e-4,3.63e-5 0.3320625,0.099749 m 1.21e-5,-4.84e-5 0.6890484,0 m 0,0 0.9514751,-0.030976 M 1.7060645,2.405087 1.4903193,2.3879118 m -1.21e-5,9.68e-5 -0.67243681,0.033213 m 0,1.21e-5 -0.24905291,0 m 0,0 0,0.2409366 m 0,0 0.0417162,0.099616 m -2.0538e-4,8.46e-5 0.5230051,0.024977 m 0,-4.83e-5 0.074722,0 m 0,0 0.4459152,-0.067249 M 0.56881748,2.4212341 0.26160592,2.3633344 m 3.624e-5,-2.54e-4 -0.22050515,0.01755 m 0,0.3957795 0.20391774,0.010075 m -1.209e-5,3.145e-4 0.36528566,-0.024916 M 0.25317328,9.272203 0.317892,8.9244899 m -0.27675499,-7.4847458 0.03631594,0 m 0,0 0.24708368,-0.023598 m -0.28339962,1.8667505 0.33946824,0 m 0,0 0.24806225,0 m 0,0 0.36202374,0 m 0,0 0.19442196,-0.050643 m 0,-1.21e-5 0.00669,-0.1439209 m 1.21e-5,1.2e-5 0.034298,-0.1474285 M 1.2253434,2.9407234 1.2081519,2.7867877 m -0.023039,0.4454545 0.1274078,0.030419 m -2.42e-5,1.089e-4 0.194422,0 m 0,0 0.1245083,-0.052275 m 0.3320867,0.099713 0.034733,0.1137312 m 8.45e-5,-2.42e-5 0.028693,0.137063 m 1.329e-4,-2.42e-5 -0.00725,0.1298179 m 3.62e-5,1.21e-5 0.069128,0.2104082 m -0.061916,-0.3402382 0.144116,-0.021735 m 1.21e-5,9.67e-5 0.2233442,0.043627 m 7.25e-5,-3.508e-4 0.2522302,0.036128 m 1.21e-5,-7.26e-5 0.1369278,0 m 0,0 0.2954807,0.00731 m 0,-8.46e-5 0.1801783,0 m 0,0 0.1657413,0.017804 m 1.21e-5,-1.209e-4 0.2777819,0.00948 M 3.0793529,3.6258687 3.0650851,3.7484899 m -1.45e-4,-1.21e-5 -0.022773,0.093786 m -1.329e-4,-2.42e-5 -0.1501325,0.04301 m 7.25e-5,2.661e-4 -0.194579,-0.00734 m 0,1.209e-4 -0.4107953,0.00981 m 0,4.84e-5 L 2.089363,3.901 m 1.0160247,0.06373 0,0.2164921 M 4.7222323,4.0620824 4.6948564,3.9248623 m 0.7782677,0.1514683 0.2161801,0.029041 M 5.0623287,4.1051777 5.4730878,4.0757621 m -0.6053381,0.022207 0.194579,0.00734 M 4.7222323,4.0620824 4.8677377,4.0980294 M 4.6947839,4.2350076 4.7216282,4.0619857 m -0.041257,0.2956311 0.014268,-0.1226334 m -0.4824003,0.091525 -0.155581,-0.011732 m 0.4435352,0.042841 -0.2879663,-0.03094 m 0.4681446,0.03094 -0.1801783,0 m 0.4756591,0.00721 -0.2954808,-0.00729 m 0.4324085,0.00729 -0.1369277,0 M 5.365022,4.4008934 5.1127917,4.364753 M 5.5884387,4.44417 5.3650944,4.40053 M 5.7325668,4.422531 5.5884507,4.444266 M 5.754192,3.7684349 5.6877336,3.5184995 M 5.6893283,4.1051777 5.75418,3.7684228 M 5.7397792,4.2927018 5.689425,4.1051535 m 0.043142,0.3173783 0.00726,-0.12983 M 5.761404,4.5595584 5.732699,4.4225076 M 5.79621,4.6732776 5.761477,4.5595342 m 2.1338089,-0.828534 -0.1240734,0.020743 m 0.6336563,0.00608 -0.5094621,-0.027033 m 0.8170482,0.048853 -0.3075861,-0.022037 m 0.2547915,0.3391255 0.053036,-0.3170396 m -0.066446,0.5183281 0.01341,-0.2012885 M 8.7290063,4.4004424 8.6462503,4.297996 m 0.482642,0.1744613 0.3956576,-0.033334 m -0.7955437,-0.03868 0.4000069,0.071628 M 8.666305,4.4925843 8.730093,4.4011933 m -0.1442489,0.2725535 0.08046,-0.18115 m 0.9095898,-0.3615863 0,-0.3026826 m -0.024645,0.4831069 0.02525,-0.1803396 m -0.05207,0.3078231 0.026699,-0.1275077 M 9.5446079,4.5529761 9.5246739,4.438882 m 0.046754,0.2952441 -0.026699,-0.1811742 m -3.29192,0.1677606 -0.1245084,0.052275 m 0.3189303,-0.052275 -0.1944219,0 m 0.3218056,0.040253 -0.1272991,-0.040519 m 0.087069,0.3223131 0.017204,0.1539358 m 0.016322,-0.3015457 -0.034298,0.1474285 m 0.041003,-0.2816128 -0.00669,0.1341843 m 0.2011149,-0.1945635 -0.194434,0.060343 m 0.5564698,-0.060343 -0.3620358,0 m 0.6101464,0 -0.2481106,0 m 0.6034172,0 -0.3553066,0 m 0.5631024,0 -0.2077958,0 m 0.321721,0.03354 -0.1139252,-0.033613 m 0.093871,0.3623725 0.015464,0.1606486 m 0.00459,-0.4894085 -0.019934,0.328772 M 8.1568428,4.68045 8.0564485,4.7344068 m 0.529396,-0.060658 -0.4291225,0 m 0.6638592,0.060379 -0.2346159,-0.0605 m 0.7776636,0.0605 -0.5430477,0 m 0.7508435,0 -0.2077958,0 m 0.3687167,-0.01772 -0.1609209,0.017732 M 9.9572966,4.730875 9.7323456,4.7162277 M 9.7079417,5.8292289 9.9572966,5.7101636 M 9.5042535,6.2918465 9.6996057,6.3198345 M 9.414853,6.2426425 9.504133,6.2918945 M 9.3075724,6.1845015 9.4150946,6.242244 M 9.5757739,5.7864118 9.7079417,5.8291805 M 9.3478026,5.8087759 9.5757739,5.7865086 m -0.9519946,-0.053775 -0.2816116,0 m 0.5631024,0.040253 -0.2814908,-0.040325 m 0.5407522,0.062702 -0.2592614,-0.022291 m 0.4425325,0.035705 -0.1832711,-0.013123 m 0.1832711,0.2009861 0,-0.1878628 m -0.04023,0.3757256 0.040351,-0.1878386 m -0.201272,0.2012522 0.160921,-0.013559 m -0.5632232,0.013559 0.4023022,0 m -0.7195532,-0.013414 0.317251,0.013365 m -0.442412,-0.02678 0.1251608,0.013438 M 8.3421677,5.7327333 8.1372714,5.5705728 m 0.1914862,0.3589738 0.013772,-0.1967891 m -0.040593,0.4383304 0.026941,-0.2415292 m -0.080581,0.4025527 0.05352,-0.1610598 m -0.088192,0.3311427 0.033948,-0.1702401 m -0.565277,0.211775 -0.2470596,0.023598 m 0.5209392,-0.023598 -0.2738796,0 m 0.5313289,-0.041535 -0.2573285,0.04162 m 0.6557649,0.033153 -0.3984364,-0.075099 m 0.7470983,0.06679 -0.3486619,0.00832 m 0.8634397,-0.00832 -0.5147778,0 m 0.7472192,-0.041535 -0.2324414,0.04162 m 0.2241054,-0.5151834 0,-0.224475 m 0,0.4903278 0,-0.2658528 m 0.00834,0.4735638 0,-0.2078804 M 9.8988238,6.5769669 9.7078209,6.5272314 m 0.2494757,0.078885 -0.058352,-0.029258 m -0.2158902,2.0357811 0.2742421,0 M 9.4256052,8.5459945 9.6829337,8.6130019 M 9.400718,8.4130681 9.4254844,8.5460308 m -0.024766,-0.2741984 0,0.1412357 M 9.7244928,7.6487234 9.9572966,7.5903761 M 9.4199271,7.6979025 9.7244928,7.6486267 M 9.3342717,7.8730412 9.4199271,7.6979025 M 8.6287325,7.7484125 8.6039665,7.615462 m 0.024766,0.2825078 0,-0.1495573 m -0.3902211,0.1163197 -0.3710121,0 m 0.7612332,0.033238 -0.3902211,-0.032887 m 0.5894393,0.032887 -0.1992182,0 m 0.7055392,-0.024928 -0.506321,0.025013 M 9.409054,8.0225864 9.3343925,7.8729807 m 0.066325,0.3988517 0,-0.2493791 m -0.4151083,0.2410696 0.4152291,0 M 8.71173,8.2385947 8.9857305,8.2631359 M 8.2633986,8.1970598 7.8601298,8.2081632 M 8.71173,8.2385947 8.2633986,8.1971686 M 8.7531684,8.3632238 8.71173,8.2385705 m 0.041438,0.3323522 0,-0.2076989 m -0.863319,0.2076989 0.863319,0 M 7.7859515,8.5520179 7.8898494,8.5706203 M 7.5147297,5.1966857 7.1494078,5.2216018 m 0.902329,0.00192 -0.5371279,-0.026525 M 8.087497,5.3379215 8.0519784,5.2234403 M 8.1372714,5.5705486 8.0873762,5.3379577 M 7.4980577,5.6204051 8.1372714,5.5695326 m -0.9463165,-0.00728 0.3072236,0.0579 M 6.5516808,5.1966857 6.1781317,5.2716034 m 0.448259,-0.074918 -0.07471,0 m 0.597727,0.024928 -0.5230171,-0.024977 m 0.5645642,0.1246774 -0.041765,-0.099616 m 0.041765,0.3405527 0,-0.2409366 m -0.2491012,0.2409366 0.2491012,0 m -0.9215381,0.033226 0.6724489,-0.033214 m -0.9713123,0.00829 0.2988393,0.025182 M 5.1071619,4.6732776 4.2651782,4.7510982 m 1.5310321,-0.077821 -0.6890484,0 M 6.1282848,4.7729663 5.7962224,4.6732292 M 6.0784743,5.1136037 6.1285265,4.7730026 M 6.1780954,5.2714583 6.0785468,5.1135674 M 5.9705534,5.5705486 6.178929,5.2720388 m -0.407618,0.2985098 0.1992424,0 m -0.5786026,0.049094 0.379324,-0.049397 M 7.469667,7.2646037 7.4253292,7.1236945 M 7.513884,7.507911 7.469667,7.2646279 M 6.0773266,7.507911 6.0324451,7.4114517 M 6.4972552,7.5668872 6.0774957,7.5067619 m 0.9501945,0.060125 -0.530435,0 M 7.513884,7.507911 7.0275815,7.565968 M 7.8674993,7.618498 7.5140048,7.5077059 m 0.3534945,0.3540993 0,-0.2433072 m -0.00737,0.5898229 0,-0.3466003 m -0.074178,0.6902978 0.073816,-0.3437701 m -0.3532528,0.3834666 0.279437,-0.040023 m -0.8466711,0.032645 0.5673549,0 M 6.644597,8.6138244 6.93922,8.5836832 M 6.644597,8.6138244 6.6190816,8.9245625 M 5.6500404,8.5917144 6.644597,8.6139696 M 5.4923814,8.629899 5.6501613,8.5922224 M 6.7843396,6.5486157 6.1949728,6.5708346 M 7.4352357,6.5672181 6.7843396,6.5485673 M 7.4915339,6.8140451 7.4341484,6.5674479 m -0.00882,0.5562466 0.066446,-0.3096131 m -0.6411345,0.3096131 0.5746882,0 M 6.1728643,7.1089505 6.8506289,7.12413 M 6.077097,7.1458167 6.1728401,7.10889 m -2.4974274,-0.1400141 0,-0.3806605 M 3.7638105,7.1974269 3.6752073,6.9689484 M 3.7995586,7.4908809 3.7639313,7.1974149 M 4.9720221,8.1485217 4.9371922,8.435408 M 4.8812685,8.0043226 4.9719013,8.1485943 M 5.4361558,5.796596 5.421453,6.0177811 M 5.391951,5.6196431 5.436071,5.7966202 M 4.957295,5.6417652 5.3919386,5.6195222 m -1.1639947,0.029621 0.7293874,0 M 3.8441743,5.7249198 4.227932,5.6490828 M 4.2058356,6.0472692 3.8539721,6.0691858 M 4.5078885,6.0915014 4.2057027,6.0482127 M 4.7583791,6.1504898 4.5080818,6.0907273 m 0.2502973,0.2662035 0.014413,0.154855 m -0.014413,-0.361296 0,0.206441 M 5.0678015,6.0620133 4.7584274,6.1506591 M 5.4214168,6.0177811 5.0677773,6.0618319 M 5.5024571,6.1947219 5.4203415,6.018277 M 5.546662,6.4453952 5.5029041,6.1946494 m -0.7297981,0.3171122 -0.8781788,0 m 1.4528187,0 -0.5746399,0 M 5.546662,6.4453952 5.3477822,6.5118825 M 5.789771,6.5043835 5.5464446,6.4462902 M 6.1949728,6.5707378 5.7898798,6.5037787 M 5.9886872,7.013108 6.1946224,6.5705806 M 6.077097,7.1458167 5.988808,7.0130234 M 6.032892,7.411234 6.077351,7.1458651 M 5.465622,7.5070885 6.0329286,7.4114755 m -1.13622,0.077591 0.5689255,0.01772 m -5.42449679,-3.3546307 0.29449012,0 M 0.87997958,5.3598259 1.5411688,5.3400865 M 0.48852616,5.4254787 0.87991918,5.3595114 M 2.5970493,4.5654851 2.0175286,4.5457094 m 0.7255697,0.041535 -0.146049,-0.021795 M 2.736055,4.6968638 2.782302,4.8823802 M 2.743099,4.5872449 2.736149,4.6968759 M 2.813287,4.310434 2.743023,4.5872208 m 0.350003,-0.3039769 0.9636288,0.031375 m -1.243365,-0.00419 0.2797269,-0.027323 M 2.550706,4.2640603 2.813169,4.3110623 M 1.9806207,4.2286456 2.550706,4.264145 M 2.1250991,4.2376202 2.0889644,3.9011315 M 1.9651689,4.4295833 1.9807536,4.2286456 m 0.036775,0.3171243 -0.052323,-0.1161987 m 0.033936,0.398646 0.018786,-0.2824231 M 3.95787,4.8585762 4.264405,4.7488001 M 3.2534786,4.8823554 3.9578579,4.8583343 m -1.1754596,0.024021 0.4710803,0 M 2.3499173,4.8437112 2.7823862,4.88244 M 1.9991411,4.828217 2.3499052,4.843917 M 1.6548645,4.8437112 1.9991532,4.8283019 m -0.4451663,0.071047 0.1009018,-0.055589 m -0.98080816,0.1313418 -0.31187488,0 M 1.137441,4.9055419 0.67411679,4.9754159 m 0.87987011,-0.076067 -0.4165943,0 m 0.4037762,0.4405439 0,-0.4407253 m -0.039566,0.8484911 0.039264,-0.4078021 m 2.8718827,2.8602511 -0.045292,0.2270996 m 0.050439,-0.4125797 0,0.1855526 M 4.8967083,7.4890666 4.6959195,7.4736574 M 4.9842362,7.6745588 4.8976989,7.488607 M 4.8812685,8.0043226 4.9836321,7.6743653 M 4.417896,8.0146277 4.8812685,8.00425 m -0.8546567,7.26e-5 0.3912842,0.010378 m -0.7619823,0.061746 0.3706497,-0.072402 m -0.7293269,0.058444 0.3586652,0.014272 m 0.3861498,-0.6134569 0.6539526,0 M 3.7995586,7.4908809 4.0420756,7.463449 M 3.3087498,7.6247144 3.7995345,7.4907963 m -3.43731676,-2.5130218 -0.32108073,0 M 0.48852616,5.4254787 0.36342585,4.9774358 m 0.0987876,0.5428451 0.0264577,-0.094766 M 0.41539896,5.7249198 0.46297453,5.5204624 M 1.9635138,5.9450405 2.0306246,5.8008414 m -0.1009501,0.381241 0.033114,-0.2371507 m 1.7265051,0.6435377 0.2056332,-0.0762 M 3.4101227,6.6392572 3.6894269,6.5892435 M 3.0463593,6.5884694 3.4099415,6.6405514 M 3.0463593,6.5884694 3.0215326,6.232846 M 2.0819574,6.6138573 3.0463472,6.5882759 M 1.8873784,6.5630695 2.0819815,6.6137484 M 1.8873784,6.5630695 1.6724185,6.7260887 M 1.8620079,6.2836822 1.887173,6.5630816 M 1.9296745,6.1820824 1.8620925,6.2837427 M 3.0717297,6.1133575 3.0209527,6.2328702 m 0.059246,-0.4571626 0,0.3377587 M 3.4270364,5.7672409 3.8441381,5.724569 M 3.0801986,5.775708 3.4270364,5.767148 m -0.8290448,0.00856 0.482207,0 M 2.0311924,5.801108 2.5979916,5.775732 M 1.9381433,5.767242 2.0313613,5.800637 M 1.5016029,5.74766 1.9381431,5.767206 m -1.34509103,3.63e-5 0.90875623,0 M 0.41539896,5.7249198 0.59302811,5.7673256 M 0.18699274,5.8434408 0.41542312,5.7249561 m -0.22843038,0.1184847 0,0.4927104 M 0.04113701,5.8544232 0.18702898,5.8439729 M 0.18155622,6.336127 0.04113701,6.3465289 M 0.25825944,6.6455104 0.18200322,6.3360182 M 1.2340056,6.7262218 0.77626291,6.7952491 m 0.89626429,-0.069027 -0.4385216,0 M 1.7017515,7.1553235 1.6718023,6.7262701 m 0.029949,0.4290534 0.053676,0.3459593 M 1.2924663,7.1845818 1.7017515,7.155263 M 0.81080292,7.163913 1.2924905,7.184209 M 0.81080292,7.1639111 0.7759488,7.513378 m 3.1411e-4,-0.7181168 0.0343105,0.3686741 M 0.25825944,6.6455104 0.77662535,6.7940275 m -0.73548834,-0.1370024 0.21721908,0 M 2.5144746,7.5786317 2.2349289,7.5929403 m 0.5558174,-0.014309 -0.2762717,0 M 3.3087498,7.6247144 2.7907705,7.5783414 M 3.3317765,7.8896842 3.3086532,7.6247265 M 3.2972365,8.0624885 3.331704,7.8896721 M 2.8824423,8.1015197 3.2972606,8.0627666 M 2.8824423,8.3009092 2.8509588,8.4362184 m 0.031484,-0.3346987 0,0.1993895 M 2.6433684,8.0417089 2.8824181,8.1016407 m -0.6773659,-0.059932 0.4383162,0 m -0.4383162,0 -0.029478,0.3589253 M 2.234941,7.5930855 2.2051126,8.0417089 M 1.7567811,7.5010772 2.2349047,7.593279 M 1.2985431,7.55322 1.7568174,7.50138 M 0.91004957,7.523309 1.2985552,7.553124 M 0.64107484,7.503364 0.91004957,7.523297 M 0.31234675,7.593086 0.64108692,7.503388 M 0.20277072,7.58312 0.04113701,7.59035 M 0.31234675,7.59308 0.20275864,7.58327 m 0.10958811,0.508277 0,-0.4984677 m 0,0.4984677 0.0713633,0.3578006 M 0.04113701,8.1040718 0.31234675,8.0915412 m 5.18003465,0.5383578 0,0.2946514 M 5.2433406,8.5102652 5.4926593,8.6293184 M 4.7950695,8.400598 5.2439447,8.5077736 M 3.9881816,8.4504544 4.7950454,8.4001988 M 3.4602112,8.4903202 3.9881937,8.4505149 M 3.1613719,8.5999875 3.4610569,8.4926546 M 3.1613719,8.5999875 3.1361948,8.9244778 M 2.8512608,8.4362909 3.1613839,8.5999633 M 2.1751634,8.400598 2.8512487,8.4364724 m -1.0745458,0.073793 0.3984364,-0.109764 m -0.7271644,0.079514 0.328716,0.030383 m -0.6474893,0.00983 0.3187612,-0.040289 M 1.1292016,8.759496 1.1427446,8.9244868 m -0.013543,-0.4042582 0,0.2392674 M 0.70085237,8.4496803 1.1291654,8.5204736 m -0.74708625,-0.070793 0.31877322,0 m -0.56781405,0.030673 0.24902875,-0.030746 m -0.34093006,0.02852 0.09190131,0",
    "grass":         "M0,10 L1,9 M10,10 L9,9 M4,4 L5,5 L6,4",
    "roundconcrete": "m 3.5527758,8.5112518 a 0.13262729,0.12229873 0 1 0 -0.2652544,0 0.13262729,0.12229873 0 0 0 0.2652544,0 z M 2.4033397,6.1671933 a 0.11052284,0.1019157 0 1 0 -0.2210456,0 0.11052284,0.1019157 0 0 0 0.2210456,0 z m 1.326272,-0.4076618 a 0.33156808,0.30574672 0 1 0 -0.663136,0 0.33156808,0.30574672 0 1 0 0.663136,0 z M 0.9886492,0.50068801 a 0.15473177,0.1426818 0 1 0 -0.30946315,0 0.15473177,0.1426818 0 0 0 0.30946315,0 z M 8.3715659,4.4346289 a 0.08841847,0.08153275 0 1 0 -0.1768369,0 0.08841847,0.08153275 0 0 0 0.1768369,0 z m 1.4588994,3.2205323 a 0.22104539,0.20383114 0 1 0 -0.4420904,0 0.22104539,0.20383114 0 1 0 0.4420904,0 z M 4.945362,1.5809932 a 0.39788211,0.36689644 0 1 0 -0.7957642,0 0.39788211,0.36689644 0 0 0 0.7957642,0 z M 7.1558159,1.0510318 a 0.97259975,0.89685707 0 1 0 -1.9451995,0 0.97259975,0.89685707 0 0 0 1.9451995,0 z m 2.4314993,0.4178538 a 0.05526144,0.05095787 0 1 0 -0.1105228,0 0.05526144,0.05095787 0 0 0 0.1105228,0 z M 9.3883738,8.1749308 a 0.03315681,0.05095778 0 1 0 -0.06631,0 0.03315681,0.05095778 0 1 0 0.06631,0 z M 8.0399974,4.0299404 a 0.06631362,0.09894173 0 1 0 -0.1326271,0 0.06631362,0.09894173 0 1 0 0.1326271,0 z M 0.9886492,5.7289565 a 0.12157503,0.11210718 0 1 0 -0.24315003,0 0.12157503,0.11210718 0 0 0 0.24315003,0 z m 5.5261349,0.8866656 a 0.5526137,0.50957807 0 1 0 -1.1052274,0 0.5526137,0.50957807 0 0 0 1.1052274,0 z M 3.1106845,3.2524082 a 0.17683632,0.16306493 0 1 0 -0.3536719,0 0.17683632,0.16306493 0 1 0 0.3536719,0 z m -0.176836,5.5034409 a 0.79576338,0.7337921 0 1 0 -1.5915263,0 0.79576338,0.7337921 0 1 0 1.5915263,0 z M 0.76760353,9.510024 a 0.33156809,0.30574673 0 1 0 -0.66313603,0 0.33156809,0.30574673 0 0 0 0.66313603,0 z",
    "woodboard":     "M 0.7761786,7.6348068 1.1183518,10.455496 M 10.960267,7.634699 11.15479,9.2376807 M 0.97119781,5.4401601 1.6038595,10.655434 m 1.4863158,0.259248 0.030478,0.251308 M 0.59240861,0.06122178 0.77616478,7.6348339 M 10.776497,0.06122178 10.960129,7.6348068 M 0.07025665,5.1147796 0.20605086,10.711931 m 4.36458214,-1.3e-5 0.011012,0.454072 m 5.672628,-6.0512375 0.135794,5.5971515 M 0.34644938,0.06122178 0.61585902,11.16599 M 10.530413,0.06122178 10.799933,11.16599 M 0.84071179,0.06122178 0.97121162,5.4401872 M 9.5699301,0.06122178 9.6024674,1.4050367 M 11.024788,0.06122178 11.154792,5.4192027 m -7.527698,5.7467873 0,-0.06276 m -2.0232188,0.06276 0,-0.510543 m -0.4855491,0.0092 0,-0.209178 m 8.7208498,0.710494 0,-11.10476809 M 4.747139,3.4366819 l 0,-3.37544699 m 4.8553284,11.10476809 0,-9.7609261 m -0.3201155,9.7609261 0,-11.10476809 m -0.400764,11.10475309 0,-11.10476816 m -5.0920507,1.44667846 0,-1.44667846 m 2.0703814,11.10476816 0,-11.10476816 M 5.6308338,11.165988 l 0,-11.10476816 M 5.3833715,11.165988 l 0,-11.10476816 m 4.8709065,5.05355786 0,-5.05355786 M 5.1622684,11.165988 l 0,-11.10476816 m -5.09200978,5.05355786 0,-5.05355786 M 10.379041,11.16599 10.390067,10.711931 M 4.5705745,10.711918 4.7470784,3.4366688 M 0.19497726,11.16599 0.20598969,10.711904 M 3.9753531,7.0019049 4.1437378,0.06122178 M 4.0936951,11.16599 4.3631186,0.06122178 M 3.6790617,6.060101 3.789503,1.5079002 M 3.6270875,11.103227 3.9753544,7.0018913 M 1.0757474,11.16599 1.1183169,10.664646 M 3.090155,10.914736 3.6790458,6.0601416 M 1.9208587,1.0107242 2.4772143,3.8771163 M 1.6458245,4.7656412 2.4098688,10.164304 M 7.769303,0.06122178 7.9343235,1.2272396 M 1.8475577,0.06122178 1.9208587,1.0107405 M 1.3262471,0.06122178 1.6458245,4.7656412 M 7.5713748,6.7828107 7.7743902,11.16599 M 7.4546471,9.3094265 7.517702,11.16599 M 8.109281,0.06122178 8.2566554,6.139464 M 7.934417,1.2273221 8.092738,7.751308 m 0.5623381,3.414682 0,-11.10476822 M 8.4513167,11.16599 l 0,-11.10476822 M 8.2566554,11.16599 l 0,-5.0264989 m -0.6853523,0.6433332 0,-2.9303588 m -0.9617107,7.3135245 0,-3.9865265 m -0.228602,3.9865265 0,-7.8317248 m -0.2435331,7.8317248 0,-11.10476822 M 8.0622703,11.16599 8.0927354,7.7514294 M 6.9902129,11.16599 6.9948837,10.641038 M 3.3154313,4.2210587 3.4163463,0.06122178 M 6.8384626,11.16599 7.0077848,4.1870867 M 7.2960537,11.16599 7.3304659,9.7478449 M 6.6095864,7.1794906 6.851369,0.06122178 M 6.3810344,3.3342652 6.4922059,0.06122178 M 2.6693244,1.6146466 2.7823853,0.06122178 M 6.994864,10.640943 7.5713057,3.8524927 M 2.4771866,3.8771447 2.6693107,1.6146479 M 2.7330038,9.0227552 3.3154839,4.2210871 M 7.0078513,4.1871713 7.3992133,0.96097372 M 7.3991027,0.96095615 7.6130233,0.06122533 M 2.4098688,10.164331 2.7330032,9.0227268 M 7.3305021,9.7478856 7.4546333,9.3093864 m 2.5685867,1.8566036 0,-11.10476822 M 4.9311549,11.16599 l 0,-11.10476822",
    "woodplank":     "M 1.0356963,7.6600167 1.3977552,8.9327242 M 8.2797217,0.02460801 8.9061604,2.2267801 M 9.2980245,0.02460801 9.3536844,0.3508216 M 8.9074475,0.02460801 9.0740369,1.0002726 M 0.81067098,5.6823256 1.0357181,7.6600167 m 10.0471169,-1.9777318 0.0933,0.8195379 M 0.54037521,6.8008858 0.93867152,10.30102 M 10.812511,6.8008313 11.176137,9.9956842 M 0.34358384,8.5324395 0.46190619,9.572208 M 10.615745,8.5324258 10.734082,9.5721948 M 1.3977906,8.932738 l 0.080291,1.175913 m 7.5958218,-9.1084054 0.051343,0.7512872 m -8.86037395,4.243664 0.078747,2.5372427 M 10.53694,5.9952107 l 0.07884,2.537242 m -0.8312743,2.6366453 0,-11.14448999 M 4.6483973,11.169098 l 0,-11.14448999 m 4.9325314,11.14448999 0,-11.14448999 M 4.444806,9.4572052 l 0,-9.43259719 m 4.9089107,11.14448999 0,-10.81826812 m -5.1361366,8.31807922 0,-8.64430109 m 4.9076661,11.14448999 0,-9.4175113 m -5.1360521,5.1001751 0,-6.82715379 m 4.9170363,11.14448999 0,-8.9424533 m -5.1361083,3.73526 0,-5.93729669 m 7.3127479,5.65771759 0,-5.65771759 M 5.946804,11.169098 l 0,-11.14448999 m -5.13609763,5.65771759 0,-5.65771759 M 10.812547,6.8008858 l 0,-6.77627779 M 5.6765089,11.169098 l 0,-11.14448999 m -5.13609833,6.77627779 0,-6.77627779 m 9.99666343,5.97058879 0,-5.97058879 M 5.4009664,11.169098 l 0,-11.14448999 m -5.13609415,5.97058879 0,-5.97058879 M 10.270507,11.169098 l 0,-11.14448999 M 5.13437,11.169098 l 0,-11.14448999 m -5.13609484,11.14448999 0,-11.14448999 m 0.94045927,10.67903299 0,-0.402648 m 9.73475357,0.868105 0.06046,-1.5969032 M 3.9298381,8.4159834 3.9891728,6.8518026 M 0.40138895,11.169098 0.46196135,9.5722492 M 4.3613271,11.169098 4.4448132,9.4571915 M 1.4282847,11.13032 1.4781075,10.108638 m 2.6068284,0.502484 0.1326228,-1.9422129 m 6.9403823,2.5001889 0.01817,-0.159877 M 0.88571004,11.169098 0.93868013,10.703641 M 3.7423005,10.063586 3.9297886,8.4159566 M 3.3677694,9.497219 3.7700656,5.9618909 m 0.2195881,5.2072071 0.09524,-0.557962 m -2.6633159,0.557962 0.00665,-0.03878 m 1.936707,0.03878 L 3.7423303,10.0636 M 2.6829377,11.169098 3.3678273,9.4972327 m 3.7734035,0.9642493 0.2071272,0.20224 M 7.833128,1.107026 8.1986911,1.4639154 M 7.4110664,10.171664 7.553491,10.380246 M 7.6135299,2.9456259 8.0464405,3.579624 M 1.2937715,6.9168664 1.9559117,8.3022702 M 7.0219502,1.7077852 7.613544,2.9456259 M 7.3483552,10.663708 7.5623424,11.111434 M 7.0010112,5.6383336 7.563249,6.8147352 M 2.1086652,9.1972465 2.4242372,9.9162137 M 7.1828769,7.3845245 7.4028891,7.885801 M 7.7602916,5.3886799 8.0478278,6.0907574 M 8.0464278,3.5796378 8.293385,4.1824209 M 8.1985412,1.4639291 8.6293301,2.5154561 M 7.2462005,4.6636973 7.569868,5.6118026 M 7.5623,11.11142 7.57899,11.16911 M 7.5204342,0.02461008 7.8330917,1.1069646 M 1.5608573,4.7443782 1.7018591,5.2754574 M 6.8968538,3.3476783 7.2462707,4.6636718 M 2.6397604,3.6741005 2.8167775,4.3655326 M 7.5245225,7.7076494 7.7758146,8.689074 M 2.7197174,1.6187985 2.7780337,1.9604823 m 5.5154082,2.2219 0.1081886,0.634148 M 1.9559244,8.302326 2.1086907,9.1973022 M 7.2772683,9.3873635 7.4111358,10.171653 M 1.259382,2.6832923 1.5609237,4.7443782 M 7.7233749,6.5020147 8.0182526,8.5176148 M 6.927186,1.0599949 7.0219516,1.7077735 M 1.447204,1.6327023 1.7330746,3.5866458 m 5.3223065,6.2879952 0.085863,0.586856 M 2.4625728,2.4630485 2.6397434,3.6740597 m 5.1360712,5.0150281 0.052332,0.3576243 M 2.127373,4.384215 2.4574632,7.2850014 M 1.0252204,4.5562319 1.2938471,6.9168961 M 8.0478916,6.0907457 8.2192132,7.595687 M 7.4832211,8.5642539 7.5876332,9.4819053 m 0.8140183,-4.665362 0.048513,0.5676985 M 2.2960614,0.02461008 2.4625523,2.4630485 m 6.1668556,0.052356 0.044765,0.6551797 M 1.7363906,0.02461076 1.740846,0.1677652 M 2.6702368,0.02461076 2.7197132,1.6187723 m 5.9544826,9.5503287 0,-7.9984894 m -5.1361088,0.7643852 0,-3.91038604 m 4.9120861,11.14449024 0,-5.7848585 M 3.314008,1.7895123 l 0,-1.76490154 m 4.9051983,11.14449024 0,-3.5733726 m -5.1360856,-5.570846 0,-2.00027164 m 4.9352874,11.14449024 0,-2.6514718 m -0.1902386,1.6868568 0,-1.1578138 m -0.7727456,0.8279559 0,-0.6227296 m -0.2114057,1.9172025 0,-2.3107929 m -0.223004,2.3107929 0,-4.8931817 m -5.1361133,-5.70663197 0,-0.54467657 m -0.037702,1.60809244 0,-0.5111296 m 4.9482574,10.0475274 0,-8.1626444 m -5.1360934,-0.3231767 0,-2.65866914 m 4.9019228,11.14449024 0,-10.68079012 m -5.136092,4.06792162 0,-4.53162174 M 6.6209222,6.2758516 6.6990405,4.2163815 M 2.1273193,4.3842157 2.1784221,3.0369658 M 7.5534679,10.380167 7.5875547,9.4818654 M 3.2113058,4.4965716 3.313984,1.7895261 m 3.5300979,7.0687544 0.157035,-3.219971 M 2.7780784,1.9604968 2.8724829,0.02461076 M 6.1612933,0.48830189 6.1929762,0.02461076 M 2.0026017,1.2184641 2.0841159,0.02461076 M 3.3792643,6.2616901 3.5381223,3.9349968 M 1.7408991,0.16778453 1.7506728,0.02461076 M 7.055445,9.2519397 7.1829407,7.3845817 M 1.44724,1.1215708 1.4849554,0.56927213 M 1.9439492,5.0982823 2.1785077,3.0369928 M 6.3954996,3.0064987 6.5549538,1.605291 M 2.8168143,4.3654939 3.083161,2.02487 m 4.6352421,9.144232 0.1097734,-0.964614 M 1.7331276,3.586662 2.0026165,1.2184655 M 7.2772752,9.3873924 7.3607398,8.6539645 M 6.6991395,4.2163829 6.8968609,3.347612 M 2.8152429,6.2369254 3.2113418,4.496546 M 2.7938837,8.8335977 3.379224,6.2616507 M 2.424344,9.9162178 2.7939256,8.8335977 M 2.457481,7.2850035 2.8152704,6.2369529 m 4.7481131,0.577705 0.160126,-0.3127088 M 7.4029816,7.8858725 7.5245855,7.7077465 M 6.554968,1.6053455 6.9272496,1.060073 M 7.5700734,5.611766 7.7604682,5.3886702 M 7.360782,8.6539377 7.4832638,8.5642429 M 1.7019794,5.2754594 1.9439351,5.0982698 m 8.0909509,6.0708322 0,-11.14448987 M 4.8987352,11.169102 l 0,-11.14448987",
    "roof":          "m 13.170486,16.547471 0.08558,-0.340902 m -0.08558,-5.198915 0.08558,-0.340923 m -0.08558,-5.1988938 0.08558,-0.3409229 M 9.4615271,16.547471 9.54712,16.206569 M 9.4615275,11.007654 9.54712,10.666731 M 9.4615271,5.4678372 9.54712,5.1269143 M 5.7525203,16.547471 5.8381131,16.206569 m -0.085592,-5.198915 0.085592,-0.340923 M 5.7525203,5.4678372 5.8381131,5.1269143 M 2.0435132,16.547471 2.129106,16.206569 M 2.0435134,11.007654 2.129106,10.666731 M 2.0435132,5.4678372 2.129106,5.1269143 m 11.126955,11.0796547 0.171318,-0.255692 m -0.171318,-5.284146 0.171318,-0.255672 M 9.54712,16.206569 9.7183058,15.950877 M 13.256061,5.1269143 13.427379,4.871242 M 9.54712,10.666731 9.7183058,10.411059 m -3.8801927,5.79551 0.1711854,-0.255692 M 9.54712,5.1269143 9.7183058,4.871242 M 5.8381131,10.666731 6.0092985,10.411059 M 2.129106,16.206569 2.3002914,15.950877 M 5.8381131,5.1269143 6.0092985,4.871242 M 2.129106,10.666731 2.3002914,10.411059 M 2.129106,5.1269143 2.3002914,4.871242 m 11.1270876,11.079635 0.213858,-0.159795 m -3.9229312,0.159795 0.2140231,-0.159795 m 3.4950501,-5.380023 0.213858,-0.159815 M 6.0092985,15.950877 6.2232886,15.791082 M 9.7183058,10.411059 9.9323289,10.251244 M 2.3002914,15.950877 2.5142651,15.791082 M 13.427379,4.871242 13.641237,4.711427 M 6.0092985,10.411059 6.2232886,10.251244 M 9.7183058,4.871242 9.9323289,4.711427 M 2.3002914,10.411059 2.5142651,10.251244 M 6.0092985,4.871242 6.2232886,4.711427 M 2.3002914,4.871242 2.5142651,4.711427 m 11.1269719,11.079655 0.0341,-0.01691 m -3.7430061,0.01691 0.2995991,-0.149151 m -4.0086398,0.149151 0.2995663,-0.149151 m 7.1183815,-5.390688 0.0341,-0.01689 M 2.5142572,15.791081 2.8138398,15.64193 M 9.932321,10.251241 10.23192,10.102092 m -4.0086393,0.149149 0.2995664,-0.149149 m 7.1183819,-5.3906682 0.0341,-0.016893 M 2.5142651,10.251244 2.8138477,10.102095 M 9.9323289,4.711427 10.231928,4.5622776 M 6.2232886,4.711427 6.522855,4.5622776 M 2.5142651,4.711427 2.8138477,4.5622776 M 10.231928,15.641933 10.617104,15.514066 M 6.522855,15.641933 6.9080304,15.514066 M 2.8138477,15.641933 3.1990068,15.514066 M 10.231928,10.10209 10.617104,9.9742546 M 6.522855,10.10209 6.9080304,9.9742546 M 2.8138477,10.10209 3.1990068,9.9742546 M 10.231928,4.5622736 10.617104,4.4344379 M 6.522855,4.5622736 6.9080304,4.4344379 M 2.8138477,4.5622736 3.1990068,4.4344379 m 7.4180972,11.0796341 0.299434,-0.04475 m -4.0085076,0.04475 0.2995663,-0.04475 m -4.0085899,0.04475 0.2995828,-0.04475 m 7.1185144,-5.4950674 0.299434,-0.044735 m -4.0085076,0.04474 0.2995663,-0.044735 M 3.1990068,9.9742591 3.4985896,9.9295244 M 10.617104,4.434442 10.916538,4.3897081 M 6.9080304,4.434442 7.2075967,4.3897074 M 3.1990068,4.434442 3.4985896,4.3897074 m 7.4179484,11.0796336 0.2996,-0.02131 m -4.0085413,0.02131 0.2995662,-0.02131 m -4.0085733,0.02131 0.2995663,-0.02131 M 10.916538,9.92952 11.216138,9.908208 M 7.2075967,9.9295244 7.5071629,9.908212 M 3.4985896,9.9295244 3.7981559,9.908212 m -3.7172833,-0.01003 0.0165525,0 0,0.020087 -0.0165525,0 0,-0.020087 m 10.8356654,-5.5084746 0.2996,-0.021313 m -4.0085413,0.021313 0.2995662,-0.021313 m -4.0085733,0.021313 0.2995663,-0.021313 m -3.7172833,-0.010045 0.0165525,0 0,0.020088 -0.0165525,0 0,-0.020088 m 12.8899904,6.7333896 0.199623,0 m -3.9086637,0 0.1997048,0 m -3.9087285,0 0.1997217,0 m -3.908729,0 0.1997219,0 m 10.9273498,-5.539824 0.199623,0 m -3.9086637,0 0.1997048,0 m -3.9087285,0 0.1997217,0 m -3.908729,0 0.1997219,0 m 11.1269728,0 0,-0.084086 m 0,5.623903 0,-0.08409 m -3.7089589,-5.4557316 0,-0.084086 m 0,5.6239036 0,-0.08409 m -3.7090068,-5.4557322 0,-0.084086 m 0,5.6239032 0,-0.08409 m -3.7090071,-5.4557318 0,-0.084086 m 0,5.6239028 0,-0.08409 m 10.9273498,-5.4557142 0,-0.084086 m 0,5.6239032 0,-0.08409 m -3.7090407,-5.4557315 0,-0.084086 m 0,5.6239035 0,-0.08409 m -3.7090237,-5.4557321 0,-0.084086 m 0,5.6239031 0,-0.08409 m -3.7090073,-5.4557317 0,-0.084086 m 0,5.6239027 0,-0.08409 m -0.085592,5.198924 0.085592,0.340903 m -0.085592,-5.880739 0.085592,0.340922 m -0.085592,-5.88074 0.085592,0.3409229 m 3.6234309,10.7387311 0.085577,0.340903 m -0.085577,-5.880739 0.085577,0.340922 m -0.085577,-5.88074 0.085577,0.3409229 M 9.17623,16.206551 9.261822,16.547454 M 9.17623,10.666715 9.261822,11.007637 M 9.17623,5.126897 9.261822,5.4678199 m 3.623464,10.7387311 0.08558,0.340903 m -0.08558,-5.880739 0.08558,0.340922 m -0.08558,-5.88074 0.08558,0.3409229 M 1.5870132,15.950877 1.7581985,16.206569 m 3.5378383,-0.255692 0.1711854,0.255692 m -3.880209,-5.79551 0.1711853,0.255672 m 7.2468452,5.284146 0.1711857,0.255692 m -3.8801926,-5.79551 0.1711854,0.255672 M 1.5870132,4.871242 1.7581985,5.1269143 m 10.9557705,10.8239627 0.171317,0.255692 m -3.8802423,-5.79551 0.1711857,0.255672 M 5.2960368,4.871242 5.4672222,5.1269143 m 7.2467468,5.2841447 0.171317,0.255672 M 9.0050437,4.871242 9.1762294,5.1269143 M 12.713969,4.871242 12.885286,5.1269143 M 1.3730397,15.791082 1.5870132,15.950877 m 3.4950336,-0.159795 0.21399,0.159795 m 3.4950171,-0.159795 0.2139898,0.159795 m -7.632004,-5.699633 0.2139735,0.159815 m 10.9130968,5.380023 0.214024,0.159795 m -7.6320872,-5.699633 0.21399,0.159815 m 3.4950171,-0.159815 0.2139898,0.159815 M 1.3730397,4.711427 1.5870132,4.871242 m 10.9130968,5.380002 0.214024,0.159815 M 5.0820468,4.711427 5.2960368,4.871242 M 8.7910539,4.711427 9.0050437,4.871242 M 12.50011,4.711427 12.714134,4.871242 M 1.0734569,15.641933 1.3730397,15.791084 m 3.4094408,-0.149151 0.2995663,0.149151 m 3.4094404,-0.149151 0.2995667,0.149151 m 3.4094571,-0.149151 0.299599,0.149151 M 1.0734569,10.102095 1.3730397,10.251244 m 3.4094408,-0.149149 0.2995663,0.149149 m 3.4094404,-0.149149 0.2995667,0.149149 m 3.4094571,-0.149149 0.299599,0.149149 M 1.0734569,4.562278 1.3730397,4.711427 M 4.7824805,4.5622776 5.0820468,4.711427 M 8.4914872,4.5622776 8.7910539,4.711427 M 12.200511,4.5622776 12.50011,4.711427 M 0.68829791,15.514076 1.0734569,15.641933 m 3.3238479,-0.127867 0.3851757,0.127867 m 3.3238316,-0.127867 0.3851751,0.127867 m 3.3238488,-0.127867 0.385175,0.127867 M 0.68829791,9.9742591 1.0734569,10.102095 M 4.3973048,9.9742595 4.7824805,10.102095 M 8.1063121,9.9742595 8.4914872,10.102095 M 11.815336,9.9742595 12.200511,10.102095 M 0.68829791,4.434442 1.0734569,4.562278 M 4.3973048,4.4344423 4.7824805,4.562278 M 8.1063121,4.4344423 8.4914872,4.562278 M 11.815336,4.4344423 12.200511,4.562278 m -11.81179592,10.907063 0.29958283,0.04475 m 3.40944069,-0.04475 0.2995662,0.04475 m 3.409441,-0.04475 0.2995663,0.04475 m 3.4094249,-0.04475 0.299599,0.04475 M 0.38871508,9.9295244 0.68829791,9.9742591 m 3.40944069,-0.044735 0.2995662,0.044735 m 3.409441,-0.044735 0.2995663,0.044735 m 3.4094249,-0.044735 0.299599,0.044735 M 0.38871508,4.3897074 0.68829791,4.434442 M 4.0977386,4.3897074 4.3973048,4.434442 m 3.409441,-0.044733 0.2995663,0.044733 m 3.4094249,-0.044733 0.299599,0.044733 m -11.72618717,11.013587 0.29956625,0.02131 m 3.40944082,-0.02131 0.2995827,0.02131 m 3.4094243,-0.02131 0.2995829,0.02131 m 3.4093922,-0.02131 0.299599,0.02131 M 0.08914883,9.908212 0.38871508,9.9295238 M 3.7981559,9.908212 4.0977386,9.9295238 m 3.4094243,-0.021312 0.2995829,0.021312 m 3.4093922,-0.021312 0.299599,0.021312 M 0.08914883,4.3683948 0.38871508,4.3897074 m 3.40944082,-0.021313 0.2995827,0.021313 m 3.4094243,-0.021312 0.2995829,0.021312 m 3.4093922,-0.021312 0.299599,0.021312 m -0.556329,11.5141446 0.25673,-0.01599 m -3.9657533,0.01599 0.2567782,-0.01599 m -3.9657852,0.01599 0.2567782,-0.01599 m 7.1612521,-5.523833 0.25673,-0.01599 m -3.9657533,0.01599 0.2567782,-0.01599 m -3.9657852,0.01599 0.2567782,-0.01599 m 7.1612521,-5.5238277 0.25673,-0.015988 m -3.9657533,0.015992 0.2567782,-0.015988 m -3.9657852,0.015988 0.2567782,-0.015988 m 6.9045241,11.1382297 0.256728,-0.04261 m -3.9658013,0.04261 0.256778,-0.04261 m -3.9657852,0.04261 0.2567782,-0.04261 m 7.1613023,-5.497213 0.256728,-0.04261 m -3.9658013,0.04261 0.256778,-0.04261 m -3.9657852,0.04261 0.2567782,-0.04261 M 10.70268,4.8668142 10.959408,4.8242092 m -3.9658013,0.042605 0.256778,-0.042605 m -3.9657852,0.042605 0.2567782,-0.042605 m 6.9044083,11.1989538 0.256894,-0.07672 m -3.9658351,0.07672 0.2567618,-0.07672 m -3.9657854,0.07672 0.2567782,-0.07672 M 10.445786,10.48334 10.70268,10.40662 M 6.7368449,10.48334 6.9936067,10.40662 M 3.0278213,10.48335 3.2845995,10.40663 M 10.445786,4.9435266 10.70268,4.8668136 m -3.9658351,0.076713 0.2567618,-0.076713 m -3.9657854,0.076725 0.2567782,-0.076713 m 6.9473285,11.2628704 0.213858,-0.106523 m -3.922931,0.106523 0.2139899,-0.106523 m -3.9229972,0.106523 0.2139736,-0.106523 m 7.2041067,-5.433295 0.213858,-0.106523 M 6.522855,10.589878 6.7368449,10.483355 M 2.8138477,10.589878 3.0278213,10.483355 M 10.231928,5.050061 10.445786,4.9435375 M 6.522855,5.050061 6.7368449,4.9435375 M 2.8138477,5.050061 3.0278213,4.9435375 m 6.9477101,11.4158975 0.2563966,-0.22974 m -3.9654209,0.229741 0.2563479,-0.22974 m 3.4526764,-5.31008 0.2563966,-0.229739 m -7.6744281,5.769556 0.2563478,-0.22974 M 6.2665071,10.819616 6.522855,10.589877 M 9.9755314,5.279799 10.231928,5.0500598 M 2.5574999,10.819616 2.8138477,10.589877 M 6.2665071,5.279799 6.522855,5.0500598 M 2.5574999,5.279799 2.8138477,5.0500598 M 13.634119,16.547471 13.67534,16.394004 m -0.04122,-5.38635 0.04122,-0.153467 M 13.634119,5.4678372 13.67534,5.3143696 M 9.9252158,16.547471 9.9755294,16.359433 m -0.050314,-5.351779 0.050314,-0.188038 M 9.9252158,5.4678372 9.9755294,5.279799 m -3.7593779,11.267672 0.050352,-0.188038 m -0.050349,-5.351779 0.050352,-0.188038 M 6.2161545,5.4678372 6.2665071,5.279799 m -3.7593763,11.267672 0.050369,-0.188038 m -0.050369,-5.351779 0.050369,-0.188038 M 2.5071308,5.4678372 2.5574999,5.279799 m 10.5131741,6.242253 0.523553,-0.03724 m -4.2325443,0.03724 0.5234712,-0.03724 m -4.2324945,0.03724 0.5235541,-0.03724 m -4.2325613,0.03724 0.5235541,-0.03724 M 13.070674,5.9822347 13.594227,5.9449926 M 9.3616827,5.9822347 9.8851539,5.9449926 M 5.6526594,5.9822345 6.1762135,5.9449926 M 1.9436522,5.9822345 2.4672063,5.9449926 M 13.070674,0.4424054 13.594227,0.40516961 M 9.3616827,0.4424054 9.8851539,0.40516961 M 5.6526594,0.4424054 6.1762135,0.40516961 M 1.9436522,0.4424054 2.4672063,0.40516961 M 1.4200983,11.48481 1.9436522,11.52205 m 3.1854531,-0.03724 0.5235541,0.03724 m 3.1854692,-0.03724 0.5235541,0.03724 m 3.1854363,-0.03724 0.523555,0.03724 M 1.4200983,5.9449926 1.9436522,5.9822347 m 3.1854531,-0.037242 0.5235541,0.037242 m 3.1854692,-0.037242 0.5235541,0.037242 m 3.1854363,-0.037242 0.523555,0.037242 M 1.4200983,0.4051696 1.9436522,0.44240539 m 3.1854531,-0.0372358 0.5235541,0.0372358 m 3.1854692,-0.0372358 0.5235541,0.0372358 m 3.1854363,-0.0372358 0.523555,0.0372358 M 1.3298048,16.359433 l 0.050369,0.188038 m -0.050369,-5.727855 0.050369,0.188038 m -0.050369,-5.727855 0.050369,0.1880382 m 3.6586545,10.8915958 0.050352,0.188038 m -0.050352,-5.727855 0.050352,0.188038 m -0.050352,-5.727855 0.050352,0.1880382 m 3.658654,10.8915958 0.050352,0.188038 m -0.050352,-5.727855 0.050352,0.188038 m -0.050352,-5.727855 0.050352,0.1880382 m 3.6587217,10.8915958 0.05032,0.188038 m -0.05032,-5.727855 0.05032,0.188038 m -0.05032,-5.727855 0.05032,0.1880382 M 1.0734569,16.129693 l 0.2563479,0.22974 m 3.4526757,-0.22974 0.2563478,0.22974 m -3.9653714,-5.769556 0.2563479,0.229739 m 7.1616824,5.310077 0.2563479,0.22974 m -3.9653546,-5.769556 0.2563478,0.229739 m 7.1616827,5.310077 0.256398,0.22974 M 1.0734569,5.0500598 1.3298048,5.279799 m 7.1616824,5.310078 0.2563479,0.229739 M 4.7824805,5.0500598 5.0388283,5.279799 m 7.1616827,5.310078 0.256398,0.229739 M 8.4914872,5.0500598 8.7478351,5.279799 M 12.200511,5.0500598 12.456909,5.279799 M 0.85948331,16.023171 1.0734569,16.129695 m 3.4950335,-0.106524 0.2139901,0.106524 m 3.4950171,-0.106524 0.2139896,0.106524 m 3.4950008,-0.106524 0.214023,0.106524 M 0.85948331,10.483354 1.0734569,10.589877 m 3.4950335,-0.106523 0.2139901,0.106523 m 3.4950171,-0.106523 0.2139896,0.106523 m 3.4950008,-0.106523 0.214023,0.106523 M 0.85948331,4.9435365 1.0734569,5.05006 M 4.5684904,4.9435365 4.7824805,5.05006 M 8.2774976,4.9435365 8.4914872,5.05006 M 11.986488,4.9435365 12.200511,5.05006 m -11.59780582,10.896397 0.25677813,0.07672 m 3.45222879,-0.07672 0.2567783,0.07672 m 3.4522289,-0.07672 0.2567783,0.07672 m 3.4522624,-0.07672 0.256728,0.07672 M 0.60270518,10.40664 0.85948331,10.48335 m 3.45222879,-0.07672 0.2567783,0.07672 m 3.4522289,-0.07672 0.2567783,0.07672 m 3.4522624,-0.07672 0.256728,0.07672 M 0.60270518,4.8668228 0.85948331,4.9435365 m 3.45222879,-0.076713 0.2567783,0.076713 m 3.4522289,-0.076713 0.2567783,0.076713 m 3.4522624,-0.076713 0.256728,0.076713 M 0.34592701,15.903852 l 0.25677817,0.04261 m 3.45222902,-0.04261 0.2567779,0.04261 m 3.452229,-0.04261 0.2567782,0.04261 m 3.4523117,-0.04261 0.256729,0.04261 m -11.38383299,-5.58243 0.25677817,0.04261 m 3.45222902,-0.04261 0.2567779,0.04261 m 3.452229,-0.04261 0.2567782,0.04261 m 3.4523117,-0.04261 0.256729,0.04261 M 0.34592701,4.8242174 0.60270518,4.8668234 M 4.0549342,4.824217 4.3117121,4.8668234 m 3.452229,-0.042606 0.2567782,0.042606 M 11.473031,4.824217 11.72976,4.8668234 M 0.08914883,15.887862 l 0.25677818,0.01599 m 3.45222889,-0.01599 0.2567783,0.01599 m 3.4522287,-0.01599 0.2567782,0.01599 m 3.4521969,-0.01599 0.256893,0.01599 m -11.38388217,-5.555803 0.25677818,0.01599 m 3.45222889,-0.01599 0.2567783,0.01599 m 3.4522287,-0.01599 0.2567782,0.01599 m 3.4521969,-0.01599 0.256893,0.01599 M 0.08914883,4.808228 0.34592701,4.8242174 m 3.45222889,-0.015989 0.2567783,0.015989 m 3.4522287,-0.015988 0.2567782,0.015988 m 3.4521969,-0.015988 0.256893,0.015988 M 12.970863,5.4678372 12.518318,0.05991293 M 12.970863,11.007654 12.507229,5.4678372 m 0.463634,11.0796338 -0.463634,-5.539817 m -0.0083,5.529774 0.01654,0 0,0.02007 -0.01654,0 0,-0.02007 M 9.2618223,5.4678372 8.8092282,0.05991293 M 9.2618223,11.007654 8.7981876,5.4678372 M 9.2618223,16.547471 8.7981876,11.007654 M 5.5527986,5.4678372 5.1002213,0.05991293 M 5.5527986,11.007654 5.0891808,5.4678372 M 5.5527986,16.547471 5.0891808,11.007654 M 1.8437913,5.4678372 1.3912143,0.05991293 M 1.8437913,11.007654 1.3801738,5.4678372 M 1.8437913,16.547471 1.3801738,11.007654 m 11.7903122,5.539817 0.463633,-5.539817 m -0.463633,0 0.463633,-5.5398168 m -0.463633,0 0.452708,-5.40792427 M 9.4615271,16.547471 9.9252108,11.007654 m -0.4636837,0 0.4636837,-5.5398168 m -0.4636837,0 L 9.914121,0.05991293 M 5.7525203,16.547471 6.2161545,11.007654 m -0.4636342,0 0.4636342,-5.5398168 m -0.4636342,0 L 6.205114,0.05991293 M 2.0435132,16.547471 2.5071308,11.007654 m -0.4636176,0 0.4636176,-5.5398168 m -0.4636176,0 0.4525937,-5.40792427",
    "woodgrain":     "m 1.7738083,7.9048577 0.1404525,0.067074 M 1.6568553,8.1660679 1.9525893,8.3072952 M 5.2359982,0.18273866 6.1765737,1.0810694 M 6.1001588,0.01300748 6.4084982,0.30751203 M 6.7654475,0.01300748 6.9845391,0.22226744 M 1.3948578,8.2552032 1.8694303,8.7084661 M 1.9525608,8.307282 2.0577077,8.4077074 M 1.5140926,8.0297152 1.6568268,8.1660404 m 0.023342,-0.350618 0.093626,0.089422 m 4.6347181,-7.59732234 0.443202,0.5644028 M 2.0183669,10.636803 2.3153704,11.015026 M 2.7378972,5.9284873 2.9631632,6.2153551 M 4.5335929,1.5082783 4.8665296,1.9322746 M 2.0546993,5.7997755 2.5177078,6.389404 M 1.9493669,6.362262 2.1688295,6.6417213 m 2.978306,-6.62871382 0.088877,0.16976795 M 6.1765737,1.081068 6.8075117,2.2862972 M 4.0717537,0.62606833 4.5335929,1.508292 M 4.866558,1.9322746 5.4294803,3.0075526 M 4.1941116,3.913085 4.6014951,4.6912536 M 0.85070033,9.6426938 1.5982498,11.070673 M 3.1548203,3.7273643 4.0091561,5.3593275 M 6.8517435,0.87195297 7.316035,1.7588247 M 2.1067021,3.4887618 3.6235179,6.3861631 M 1.1582701,8.6446349 2.0183815,10.287615 M 1.2828522,8.0412503 1.3948578,8.2551894 m 1.5683194,-2.039848 0.138428,0.2644377 M 2.1775557,4.8580845 2.7379256,5.928501 M 1.8694303,8.7084661 2.2516034,9.4385055 M 1.440544,7.889196 1.514107,8.029729 M 2.5177218,6.3894177 2.6599999,6.6611959 M 4.6015091,4.6912947 4.7293566,5.179708 M 2.7665868,2.2441604 3.1548203,3.7273643 m 0.854322,1.6319358 0.2042048,0.7801163 M 0.68539409,9.0110373 0.85072883,9.6427072 M 6.8075264,2.2863244 7.0405204,3.176481 M 3.6498686,1.8338103 4.1941401,3.9131258 M 0.33427718,10.010403 0.64337246,11.191269 M 10.867601,10.01039 11.176739,11.191269 M -0.02760502,9.545142 0.05341534,9.8546303 M 10.505705,9.5450868 10.586837,9.8545759 M 3.6235169,6.3861768 3.6962954,6.6642333 m -2.6247075,1.6492862 0.086666,0.3311154 m 0.053772,-0.8739092 0.070811,0.2705114 M 3.101619,6.4797927 3.1628197,6.7135878 M 1.3875855,7.6868881 1.440544,7.889209 M 5.4294518,3.0075526 5.6360525,3.7968479 M 2.168815,6.6417076 2.2244113,6.8540802 m -0.591041,0.7824993 0.046813,0.1788429 m 6.7523858,2.4671936 0.082703,0.631182 M -0.08709414,9.0909792 -0.02764809,9.545101 M 4.0560548,0.50604793 4.0717685,0.62603972 m 6.3746185,8.46489858 0.05932,0.4541084 M 4.7293426,5.1796943 4.8285007,5.9373125 m -0.615139,0.2021039 0.088464,0.6760271 M 3.459153,0.37677078 3.6498402,1.8337558 M 2.4745598,0.01300748 2.7665581,2.2441876 m 0.9297386,4.420059 0.078867,0.6025533 M 3.1628196,6.713574 3.2133961,7.1000362 M 2.6599853,6.6611821 2.7218132,7.1335391 M 2.2243975,6.8541209 2.2653638,7.1671094 m 6.2497651,2.4843823 0,-8.81130343 m 0,10.35108073 0,-0.277471 M 8.093914,5.8927788 l 0,-4.4337735 m -2.4578469,6.0526897 0,-3.7148471 m 1.4044533,0.3856456 0,-1.0060396 m -2.2120197,5.4498086 0,-2.6889232 m -0.7724459,-5.4312587 0,-0.49307312 m -0.5969018,0.3637633 0,-0.3637633 m 7.127543,11.17826152 0,-1.3366931 m -10.53333768,1.3366931 0,-1.3366931 M 10.446387,9.0909792 l 0,-9.07797172 m -10.53348114,9.07797172 0,-9.07797172 M 10.867601,10.010376 l 0,-6.6382462 m -10.53335231,6.6382462 0,-6.6382462 m 0.35111691,5.6389075 0,-3.6316766 m 3.6164737,2.8049427 0,-1.3688599 m 1.8608886,4.3758255 0,-0.301808 M 0.7555921,0.1527921 l 0,-0.13978462 m 0.8426724,1.41964522 0,-1.41964522 m 0,11.17826152 0,-0.120596 m 0.4201024,-0.43387 0,-0.349201 m -0.9467778,-1.9740825 0,-2.1496573 m 2.7035748,1.4491154 0,-0.3462183 m 0,3.9245097 0,-0.03786 M 1.212027,7.7707277 l 0,-0.6707025 m 2.0013556,0.4842462 0,-0.4842462 m -1.8257971,0.586865 0,-0.5533216 m 1.3342417,0.5533216 0,-0.5533216 m -1.0884568,0.5030129 0,-0.4694832 m 0.6320074,0.4694832 0,-0.4694832 m 7.2679963,4.0241727 0,-11.17826151 M 9.1121593,11.191269 l 0,-11.17826152 m 0.9128697,11.17826152 0,-11.17826152 M 10.867601,3.3721843 11.195419,0.86837256 M 0.33424869,3.3721298 0.75557752,0.15279484 M 0.6853656,5.3793607 0.80552781,4.4611764 M 7.4004206,11.191269 8.093914,5.8927918 M 8.4325689,10.282686 8.5152714,9.6515051 M 1.0715891,6.1638622 1.1264437,5.7447549 m 0.085583,1.3552683 0.050591,-0.3864622 m 4.900125,4.175913 0.877778,-6.7069396 M 1.3875855,7.1335666 1.4333571,6.783834 m 0.2000132,0.3832623 0.040966,-0.3129886 m 2.1008271,4.2993003 0.064837,-0.371537 M 4.9939779,11.191269 5.636067,7.511695 M 4.6885475,9.1610076 4.8285146,8.62629 m -0.5360577,-0.4062367 0.00935,-0.03575 M 7.3160067,1.7588111 7.498367,1.0621011 M 0.80554169,4.4611901 1.5982785,1.4326392 M 1.1264291,5.7447824 1.1992225,5.466726 M 3.6466462,8.1039786 3.7751639,7.6129776 M 2.8385382,11.191269 2.940035,10.80347 M 2.0736638,5.2549112 2.1775273,4.8580983 M 1.903638,4.2645064 2.1067021,3.4887482 m -0.8441123,3.2248258 0.0612,-0.2337949 m 1.818867,1.3746618 0.070726,-0.2701584 M 2.3153704,11.015012 2.5080397,10.27894 M 2.2516034,9.4384788 2.4214872,8.7894988 M 8.093914,1.4589781 8.4723516,0.01300748 M 1.4333719,6.7838203 1.4815249,6.5998434 M 2.6688685,7.889196 2.7218272,7.6868743 m -0.4915694,0.083851 0.03512,-0.1341462 M 8.5151289,0.84023726 8.7317252,0.01300748 M 1.6743513,6.8541209 1.7094572,6.7199745 M 3.8399718,10.781871 4.6885189,9.1610076 M 2.940035,10.80347 4.2924708,8.2200533 M 7.498367,1.0621214 8.0475716,0.01300748 M 1.5880402,4.8674134 1.903652,4.2645198 M 1.1992225,5.4667123 1.3627747,5.1542949 m 1.145251,5.1246321 1.138592,-2.1749345 M 1.7881389,5.8003202 2.0736638,5.2548975 M 1.3237899,6.4797927 1.4622178,6.2153689 M 2.8848091,8.3469536 3.1426569,7.8544134 m -0.947505,-0.016628 0.035106,-0.067059 M 1.4815103,6.5998834 1.5916909,6.3894177 M 1.7094572,6.7199745 1.7913756,6.5634937 M 2.59532,8.0297152 2.668883,7.8891822 M 6.9845532,0.22227561 7.1488757,0.01300748 M 1.3627602,5.1542681 1.5880262,4.8674003 M 1.4622324,6.2153414 1.7881389,5.8003202 M 1.5916909,6.3894177 2.0546993,5.7998023 M 1.7913759,6.5634675 1.9493669,6.362262 M 2.4214726,8.7895119 2.8848377,8.3469536 M 2.452558,8.1660679 2.5952915,8.0297428 M 2.0577223,8.4076799 2.1688721,8.3015207 M 2.0546993,7.9719307 2.1951519,7.8377851 M 2.1688866,8.3015077 2.452558,8.1660404 m -0.5382972,-0.1941097 0.1404385,0",
    "halftile":      "M0,8 L0,0 L8,0",
    "pavement":      "M0,0 L10,10 M2.5,2.5 L0,5 L5,10 L10,5 M0,10 L2.5,7.5 M5,0 L7.5,2.5 M5,5 L10,0",
    "parquet":       "M0,5 L10,5 M5,0 L5,10 M1.666,0 L1.666,5 M3.333,0 L3.333,5 M5,1.666 L10,1.666 M5,3.333 L10,3.333 M0,6.666 L5,6.666 M0,8.333 L5,8.333 M6.666,5 L 6.666,10 M8.333,5 L8.333,10",
    "honeycomb":     "m 3.6685437,1049.936 2.5366435,-0.053 m -2.4892926,-4.9943 2.4103745,0 m 1.299889,-2.5265 -1.299889,2.5265 1.3314563,2.4735 -1.2525382,2.5209 1.1894036,2.4791 M 0,1042.3622 l 2.4475728,0 1.2683218,2.5265 -1.2581692,2.4735 1.2108183,2.5738 -1.1792511,2.4262 -2.4892926,0",
    }

# translation to autocad builtin names
AutocadPatterns = {
    "ANGLE":"halftile",
    "ANSI31":"simple",
    "ANSI32":"double",
    "ANSI33":"", # one continuous, one dashed
    "ANSI34":"", # triple
    "ANSI35":"", # one continuous, one dashdot
    "ANSI36":"dashed",
    "ANSI37":"cross",
    "ANSI38":"", # cross with one dashed
    "AR-B816":"brick",
    "AR-B816C":"brick",
    "AR-B88":"brick",
    "AR-BRELM":"brick",
    "AR-BRSTD":"brick",
    "AR-CONC":"concrete",
    "AR-HBONE":"pavement",
    "AR-PARQ1":"parquet",
    "AR-RROOF":"", # seemingly random lines
    "AR-RSHKE":"", # seemingly random tiles
    "AR-SAND":"sand",
    "BOX":"", # stupid useless square-inside-square
    "BRASS":"", # horizontal ansi33
    "BRICK":"brick",
    "BRSTONE":"", # material symbol
    "CLAY":"", # material symbol
    "CORK":"", # material symbol
    "CROSS":"satellite",
    "DASH":"line",
    "DOLMIT":"", # material symbol
    "DOTS":"", # array of tri dots
    "EARTH":"earth",
    "ESCHER":"", # WTF
    "FLEX":"", # material symbol
    "GRASS":"grass",
    "GRATE":"line",
    "GRAVEL":"sandstone",
    "HEX":"", # hexagons...
    "HONEY":"honeycomb",
    "HOUND":"", # material symbol
    "INSUL":"", # material symbol
    "ACAD_ISO02W100":"line",
    "ACAD_ISO03W100":"line",
    "ACAD_ISO04W100":"line",
    "ACAD_ISO05W100":"line",
    "ACAD_ISO06W100":"line",
    "ACAD_ISO07W100":"line",
    "ACAD_ISO08W100":"line",
    "ACAD_ISO09W100":"line",
    "ACAD_ISO10W100":"line",
    "ACAD_ISO11W100":"line",
    "ACAD_ISO12W100":"line",
    "ACAD_ISO13W100":"line",
    "ACAD_ISO14W100":"line",
    "ACAD_ISO15W100":"line",
    "LINE":"line",
    "MUDST":"", # material symbol
    "NET":"square",
    "NET3":"", # tri network
    "PLAST":"", # material symbol
    "PLASTI":"", # material symbol
    "SACNCR":"", # material symbol
    "SQUARE":"square",
    "STARS":"", #...
    "STEEL":"", # material symbol
    "SWAMP":"grass",
    "TRANS":"", # material symbol
    "TRIANG":"", # small triangles
    "ZIGZAG":""
    }

def buildPattern(name,scale=5,thickness=1,color="#000000"):
    
    """buildPattern(name,scale=5,thickness=1,color="#000000")
    builds an SVG <pattern> fragment from a name and path data"""
    
    name,scale,thickness = decodeName(name,scale,thickness)
    if not (name in Patterns.keys()):
        return None
    pname = name + "_" + str(scale).replace(".","") + "_" + str(thickness).replace(".","")
    data = Patterns[name]
    template='''<pattern id="$name" patternUnits="userSpaceOnUse" 
    patternTransform="matrix($scale,0,0,$scale,0,0)" x="0" y="0" width="10" height="10">
    <g style="fill:none; stroke:$color; stroke-width:$thickness"><path d="$path"/>
    </g></pattern>'''
    t = template.replace("$name",pname)
    t = t.replace("$scale",str(scale))
    t = t.replace("$thickness",str(thickness))
    t = t.replace("$color",color)
    t = t.replace("$path",data)
    t = t.replace("\n","")
    return t


def buildTextureImage(name,scale=5,thickness=1,color="#000000",size=64):
    
    """buildTextureImage(name,scale,thickness,color="#000000",size=64)
    builds a 64x64 SVG image filled with the given texture"""
    
    name,scale,thickness = decodeName(name,scale,thickness)
    if not (name in Patterns.keys()):
        return None
    s = str(size)
    template = '''<svg xmlns="http://www.w3.org/2000/svg" version="1.1" 
    width="'''+s+'''" height="'''+s+'''"><defs>$pattern</defs><rect x="0" 
    y="$0" width="'''+s+'''" height="'''+s+'''" style="fill:url(#$name); 
    stroke:none; stroke-width:none"/></svg>'''
    pat = buildPattern(name,scale,thickness,color)
    t = template.replace("\n","")
    t = t.replace("$pattern",pat+"\n")
    t = t.replace("$name",name+"_"+str(scale).replace(".","")+"_"+str(thickness).replace(".",""))
    return t


def buildSwatch(name,scale=5,thickness=1,color="#000000",size=64):
    
    """buildSwatch(name,scale,thickness,color="#000000",size=64)
    builds a 64x64 SVG image filled with the given texture, a
    white background and a border, to serve as a sample"""
    
    name,scale,thickness = decodeName(name,scale,thickness)
    if not (name in Patterns.keys()):
        return None
    s = str(size)
    template = '''<svg xmlns="http://www.w3.org/2000/svg" version="1.1" 
    width="'''+s+'''" height="'''+s+'''"><defs>$pattern</defs><rect x="0" 
    y="$0" width="'''+s+'''" height="'''+s+'''" style="fill:#FFFFFF; 
    stroke:none; stroke-width:none"/><rect x="0" y="$0" width="'''+s+'''" 
    height="'''+s+'''" style="fill:url(#$name); stroke:#000000; 
    stroke-width:2"/></svg>'''
    pat = buildPattern(name,scale,thickness,color)
    t = template.replace("\n","")
    t = t.replace("$pattern",pat+"\n")
    t = t.replace("$name",name+"_"+str(scale).replace(".","")+"_"+str(thickness).replace(".",""))
    return t


def buildFileSwatch(name,scale=5,thickness=1,color="#000000",size=64,png=False):

    """buildFileSwatch(name,scale,thickness,color="#000000",size=64,png=False)
    builds a 64x64 SVG image filled with the given texture, a
    white background and a border, to serve as a sample. The image
    is saved as a temp file, the filepath is returned"""
    s = buildSwatch(name,scale,thickness,color,size)
    if s:
        import tempfile
        tf = tempfile.mkstemp(suffix=".svg")[1]
        f = open(tf,"wb")
        f.write(s)
        f.close()
        if png:
            # we use imagemagick's convert because Qt4 doesn't support SVG patterns...
            import os
            if os.system("convert -version") == 0:
                ptf = os.path.splitext(tf)[0]+".png"
                os.system('convert "'+tf+'" "'+ptf+'"')
                return ptf
        else:
            return tf
    return None


def saveTestImage(filename,scales=[2.5,5],thicknesses=[0.1,0.2,1]):
    
    """saveTestImage(filename,scales=[2.5,5],thicknesses=[0.1,0.2,1])
    builds a test SVG file showing all available patterns at given scales and thicknesses"""
    
    maxcols = 6
    row = 0
    col = 0
    pats = '\n'
    cont = '\n'
    template = '''<svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="$width" 
    height="$height"><defs>$patterns</defs>$content</svg>'''
    for name in Patterns.keys():
        for thickness in thicknesses:
            for scale in scales:
                pats += buildPattern(name,scale,thickness)
                pats += '\n'                
                subtemplate='''<rect x="$xpos" y="$ypos" width="64" height="64"
                style="fill:url(#$pattern); stroke:#000000; stroke-width:2"/>'''
                st = subtemplate.replace("$xpos",str(64*col + 8*col + 8))
                st = st.replace("$ypos",str(64*row + 8*row + 8))
                st = st.replace("$pattern",name+"_"+str(scale)+"_"+str(thickness))
                st = st.replace("\n","")
                cont += st
                cont += '\n'
                if col == maxcols-1:
                    col = 0
                    row += 1
                else:
                    col += 1
    t = template.replace("\n","")
    t = t.replace("$patterns",pats)
    t = t.replace("$content",cont)
    t = t.replace("$width",str(8+maxcols*72))
    t = t.replace("$height",str(80+row*72))
    f = open(filename,"wb")
    f.write(t)
    f.close()
    
    
def decodeName(name,scale,thickness):
    
    """decodeName(name,scale,thickness) : decodes names written in the form 'name_5_1'"""
    
    name = name.split("_")
    if len(name) > 1:
        try:
            scale = float(name[1])
        except Exception:
            pass
    if len(name) > 2:
        try:
            thickness = float(name[2])
        except Exception:
            pass
    return name[0],scale,thickness


def getPatternNames():
    
    """getPatternNames : returns available pattern names"""
    
    return Patterns.keys()
