/* application-configuration.c generated by valac 0.56.3, the Vala compiler
 * generated from application-configuration.vala, do not modify */

/*
 * Copyright 2016 Software Freedom Conservancy Inc.
 * Copyright 2019 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-client-43.0.h"
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include "geary-engine.h"
#include <glib-object.h>

#define APPLICATION_CONFIGURATION_CLOCK_FORMAT_KEY "clock-format"

enum  {
	APPLICATION_CONFIGURATION_0_PROPERTY,
	APPLICATION_CONFIGURATION_SETTINGS_PROPERTY,
	APPLICATION_CONFIGURATION_GNOME_INTERFACE_PROPERTY,
	APPLICATION_CONFIGURATION_ENABLE_DEBUG_PROPERTY,
	APPLICATION_CONFIGURATION_ENABLE_INSPECTOR_PROPERTY,
	APPLICATION_CONFIGURATION_REVOKE_CERTS_PROPERTY,
	APPLICATION_CONFIGURATION_DESKTOP_ENVIRONMENT_PROPERTY,
	APPLICATION_CONFIGURATION_WINDOW_WIDTH_PROPERTY,
	APPLICATION_CONFIGURATION_WINDOW_HEIGHT_PROPERTY,
	APPLICATION_CONFIGURATION_WINDOW_MAXIMIZE_PROPERTY,
	APPLICATION_CONFIGURATION_FORMATTING_TOOLBAR_VISIBLE_PROPERTY,
	APPLICATION_CONFIGURATION_AUTOSELECT_PROPERTY,
	APPLICATION_CONFIGURATION_DISPLAY_PREVIEW_PROPERTY,
	APPLICATION_CONFIGURATION_SINGLE_KEY_SHORTCUTS_PROPERTY,
	APPLICATION_CONFIGURATION_RUN_IN_BACKGROUND_PROPERTY,
	APPLICATION_CONFIGURATION_CLOCK_FORMAT_PROPERTY,
	APPLICATION_CONFIGURATION_ASK_OPEN_ATTACHMENT_PROPERTY,
	APPLICATION_CONFIGURATION_COMPOSE_AS_HTML_PROPERTY,
	APPLICATION_CONFIGURATION_CONVERSATION_VIEWER_ZOOM_PROPERTY,
	APPLICATION_CONFIGURATION_UNDO_SEND_DELAY_PROPERTY,
	APPLICATION_CONFIGURATION_BRIEF_NOTIFICATION_DURATION_PROPERTY,
	APPLICATION_CONFIGURATION_NUM_PROPERTIES
};
static GParamSpec* application_configuration_properties[APPLICATION_CONFIGURATION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ApplicationConfigurationPrivate {
	GSettings* _settings;
	GSettings* _gnome_interface;
	gboolean _enable_debug;
	gboolean _enable_inspector;
	gboolean _revoke_certs;
	gboolean _single_key_shortcuts;
};

static gint ApplicationConfiguration_private_offset;
static gpointer application_configuration_parent_class = NULL;

static void application_configuration_set_settings (ApplicationConfiguration* self,
                                             GSettings* value);
static void application_configuration_set_gnome_interface (ApplicationConfiguration* self,
                                                    GSettings* value);
static void application_configuration_set_boolean (ApplicationConfiguration* self,
                                            const gchar* name,
                                            gboolean value);
static gint _variant_get1 (GVariant* value);
static gint _variant_get2 (GVariant* value);
static GVariant* _variant_new1 (gint* value,
                         gint value_length1);
static void _vala_array_add5 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add6 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static gchar** _vala_array_dup2 (gchar** self,
                          gssize length);
static void application_configuration_finalize (GObject * obj);
static GType application_configuration_get_type_once (void);
static void _vala_application_configuration_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);
static void _vala_application_configuration_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
application_configuration_get_instance_private (ApplicationConfiguration* self)
{
	return G_STRUCT_MEMBER_P (self, ApplicationConfiguration_private_offset);
}

static GType
application_configuration_desktop_environment_get_type_once (void)
{
	static const GEnumValue values[] = {{APPLICATION_CONFIGURATION_DESKTOP_ENVIRONMENT_UNKNOWN, "APPLICATION_CONFIGURATION_DESKTOP_ENVIRONMENT_UNKNOWN", "unknown"}, {APPLICATION_CONFIGURATION_DESKTOP_ENVIRONMENT_UNITY, "APPLICATION_CONFIGURATION_DESKTOP_ENVIRONMENT_UNITY", "unity"}, {0, NULL, NULL}};
	GType application_configuration_desktop_environment_type_id;
	application_configuration_desktop_environment_type_id = g_enum_register_static ("ApplicationConfigurationDesktopEnvironment", values);
	return application_configuration_desktop_environment_type_id;
}

GType
application_configuration_desktop_environment_get_type (void)
{
	static volatile gsize application_configuration_desktop_environment_type_id__once = 0;
	if (g_once_init_enter (&application_configuration_desktop_environment_type_id__once)) {
		GType application_configuration_desktop_environment_type_id;
		application_configuration_desktop_environment_type_id = application_configuration_desktop_environment_get_type_once ();
		g_once_init_leave (&application_configuration_desktop_environment_type_id__once, application_configuration_desktop_environment_type_id);
	}
	return application_configuration_desktop_environment_type_id__once;
}

void
application_configuration_init (gboolean is_installed,
                                const gchar* schema_dir)
{
	if (!is_installed) {
		_vala_assert (schema_dir != NULL, "schema_dir != null");
		g_setenv ("GSETTINGS_SCHEMA_DIR", schema_dir, TRUE);
	}
}

GSettings*
application_configuration_get_settings (ApplicationConfiguration* self)
{
	GSettings* result;
	GSettings* _tmp0_;
	g_return_val_if_fail (APPLICATION_IS_CONFIGURATION (self), NULL);
	_tmp0_ = self->priv->_settings;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
application_configuration_set_settings (ApplicationConfiguration* self,
                                        GSettings* value)
{
	GSettings* old_value;
	g_return_if_fail (APPLICATION_IS_CONFIGURATION (self));
	old_value = application_configuration_get_settings (self);
	if (old_value != value) {
		GSettings* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_settings);
		self->priv->_settings = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, application_configuration_properties[APPLICATION_CONFIGURATION_SETTINGS_PROPERTY]);
	}
}

GSettings*
application_configuration_get_gnome_interface (ApplicationConfiguration* self)
{
	GSettings* result;
	GSettings* _tmp0_;
	g_return_val_if_fail (APPLICATION_IS_CONFIGURATION (self), NULL);
	_tmp0_ = self->priv->_gnome_interface;
	result = _tmp0_;
	return result;
}

static void
application_configuration_set_gnome_interface (ApplicationConfiguration* self,
                                               GSettings* value)
{
	GSettings* old_value;
	g_return_if_fail (APPLICATION_IS_CONFIGURATION (self));
	old_value = application_configuration_get_gnome_interface (self);
	if (old_value != value) {
		GSettings* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_gnome_interface);
		self->priv->_gnome_interface = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, application_configuration_properties[APPLICATION_CONFIGURATION_GNOME_INTERFACE_PROPERTY]);
	}
}

gboolean
application_configuration_get_enable_debug (ApplicationConfiguration* self)
{
	gboolean result;
	g_return_val_if_fail (APPLICATION_IS_CONFIGURATION (self), FALSE);
	result = self->priv->_enable_debug;
	return result;
}

void
application_configuration_set_enable_debug (ApplicationConfiguration* self,
                                            gboolean value)
{
	gboolean old_value;
	g_return_if_fail (APPLICATION_IS_CONFIGURATION (self));
	old_value = application_configuration_get_enable_debug (self);
	if (old_value != value) {
		self->priv->_enable_debug = value;
		g_object_notify_by_pspec ((GObject *) self, application_configuration_properties[APPLICATION_CONFIGURATION_ENABLE_DEBUG_PROPERTY]);
	}
}

gboolean
application_configuration_get_enable_inspector (ApplicationConfiguration* self)
{
	gboolean result;
	g_return_val_if_fail (APPLICATION_IS_CONFIGURATION (self), FALSE);
	result = self->priv->_enable_inspector;
	return result;
}

void
application_configuration_set_enable_inspector (ApplicationConfiguration* self,
                                                gboolean value)
{
	gboolean old_value;
	g_return_if_fail (APPLICATION_IS_CONFIGURATION (self));
	old_value = application_configuration_get_enable_inspector (self);
	if (old_value != value) {
		self->priv->_enable_inspector = value;
		g_object_notify_by_pspec ((GObject *) self, application_configuration_properties[APPLICATION_CONFIGURATION_ENABLE_INSPECTOR_PROPERTY]);
	}
}

gboolean
application_configuration_get_revoke_certs (ApplicationConfiguration* self)
{
	gboolean result;
	g_return_val_if_fail (APPLICATION_IS_CONFIGURATION (self), FALSE);
	result = self->priv->_revoke_certs;
	return result;
}

void
application_configuration_set_revoke_certs (ApplicationConfiguration* self,
                                            gboolean value)
{
	gboolean old_value;
	g_return_if_fail (APPLICATION_IS_CONFIGURATION (self));
	old_value = application_configuration_get_revoke_certs (self);
	if (old_value != value) {
		self->priv->_revoke_certs = value;
		g_object_notify_by_pspec ((GObject *) self, application_configuration_properties[APPLICATION_CONFIGURATION_REVOKE_CERTS_PROPERTY]);
	}
}

ApplicationConfigurationDesktopEnvironment
application_configuration_get_desktop_environment (ApplicationConfiguration* self)
{
	ApplicationConfigurationDesktopEnvironment result;
	gchar* xdg_current_desktop = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	g_return_val_if_fail (APPLICATION_IS_CONFIGURATION (self), 0);
	_tmp0_ = g_getenv ("XDG_CURRENT_DESKTOP");
	_tmp1_ = g_strdup (_tmp0_);
	xdg_current_desktop = _tmp1_;
	_tmp3_ = xdg_current_desktop;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		_tmp4_ = xdg_current_desktop;
		_tmp2_ = g_str_has_prefix (_tmp4_, "Unity");
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		result = APPLICATION_CONFIGURATION_DESKTOP_ENVIRONMENT_UNITY;
		_g_free0 (xdg_current_desktop);
		return result;
	} else {
		result = APPLICATION_CONFIGURATION_DESKTOP_ENVIRONMENT_UNKNOWN;
		_g_free0 (xdg_current_desktop);
		return result;
	}
}

gint
application_configuration_get_window_width (ApplicationConfiguration* self)
{
	gint result;
	GSettings* _tmp0_;
	g_return_val_if_fail (APPLICATION_IS_CONFIGURATION (self), 0);
	_tmp0_ = self->priv->_settings;
	result = g_settings_get_int (_tmp0_, APPLICATION_CONFIGURATION_WINDOW_WIDTH_KEY);
	return result;
}

gint
application_configuration_get_window_height (ApplicationConfiguration* self)
{
	gint result;
	GSettings* _tmp0_;
	g_return_val_if_fail (APPLICATION_IS_CONFIGURATION (self), 0);
	_tmp0_ = self->priv->_settings;
	result = g_settings_get_int (_tmp0_, APPLICATION_CONFIGURATION_WINDOW_HEIGHT_KEY);
	return result;
}

gboolean
application_configuration_get_window_maximize (ApplicationConfiguration* self)
{
	gboolean result;
	GSettings* _tmp0_;
	g_return_val_if_fail (APPLICATION_IS_CONFIGURATION (self), FALSE);
	_tmp0_ = self->priv->_settings;
	result = g_settings_get_boolean (_tmp0_, APPLICATION_CONFIGURATION_WINDOW_MAXIMIZE_KEY);
	return result;
}

gboolean
application_configuration_get_formatting_toolbar_visible (ApplicationConfiguration* self)
{
	gboolean result;
	GSettings* _tmp0_;
	g_return_val_if_fail (APPLICATION_IS_CONFIGURATION (self), FALSE);
	_tmp0_ = self->priv->_settings;
	result = g_settings_get_boolean (_tmp0_, APPLICATION_CONFIGURATION_FORMATTING_TOOLBAR_VISIBLE);
	return result;
}

void
application_configuration_set_formatting_toolbar_visible (ApplicationConfiguration* self,
                                                          gboolean value)
{
	GSettings* _tmp0_;
	g_return_if_fail (APPLICATION_IS_CONFIGURATION (self));
	_tmp0_ = self->priv->_settings;
	g_settings_set_boolean (_tmp0_, APPLICATION_CONFIGURATION_FORMATTING_TOOLBAR_VISIBLE, value);
	g_object_notify_by_pspec ((GObject *) self, application_configuration_properties[APPLICATION_CONFIGURATION_FORMATTING_TOOLBAR_VISIBLE_PROPERTY]);
}

gboolean
application_configuration_get_autoselect (ApplicationConfiguration* self)
{
	gboolean result;
	GSettings* _tmp0_;
	g_return_val_if_fail (APPLICATION_IS_CONFIGURATION (self), FALSE);
	_tmp0_ = self->priv->_settings;
	result = g_settings_get_boolean (_tmp0_, APPLICATION_CONFIGURATION_AUTOSELECT_KEY);
	return result;
}

gboolean
application_configuration_get_display_preview (ApplicationConfiguration* self)
{
	gboolean result;
	GSettings* _tmp0_;
	g_return_val_if_fail (APPLICATION_IS_CONFIGURATION (self), FALSE);
	_tmp0_ = self->priv->_settings;
	result = g_settings_get_boolean (_tmp0_, APPLICATION_CONFIGURATION_DISPLAY_PREVIEW_KEY);
	return result;
}

gboolean
application_configuration_get_single_key_shortcuts (ApplicationConfiguration* self)
{
	gboolean result;
	g_return_val_if_fail (APPLICATION_IS_CONFIGURATION (self), FALSE);
	result = self->priv->_single_key_shortcuts;
	return result;
}

void
application_configuration_set_single_key_shortcuts (ApplicationConfiguration* self,
                                                    gboolean value)
{
	gboolean old_value;
	g_return_if_fail (APPLICATION_IS_CONFIGURATION (self));
	old_value = application_configuration_get_single_key_shortcuts (self);
	if (old_value != value) {
		self->priv->_single_key_shortcuts = value;
		g_object_notify_by_pspec ((GObject *) self, application_configuration_properties[APPLICATION_CONFIGURATION_SINGLE_KEY_SHORTCUTS_PROPERTY]);
	}
}

gboolean
application_configuration_get_run_in_background (ApplicationConfiguration* self)
{
	gboolean result;
	GSettings* _tmp0_;
	g_return_val_if_fail (APPLICATION_IS_CONFIGURATION (self), FALSE);
	_tmp0_ = self->priv->_settings;
	result = g_settings_get_boolean (_tmp0_, APPLICATION_CONFIGURATION_RUN_IN_BACKGROUND_KEY);
	return result;
}

void
application_configuration_set_run_in_background (ApplicationConfiguration* self,
                                                 gboolean value)
{
	g_return_if_fail (APPLICATION_IS_CONFIGURATION (self));
	application_configuration_set_boolean (self, APPLICATION_CONFIGURATION_RUN_IN_BACKGROUND_KEY, value);
	g_object_notify_by_pspec ((GObject *) self, application_configuration_properties[APPLICATION_CONFIGURATION_RUN_IN_BACKGROUND_PROPERTY]);
}

UtilDateClockFormat
application_configuration_get_clock_format (ApplicationConfiguration* self)
{
	UtilDateClockFormat result;
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	g_return_val_if_fail (APPLICATION_IS_CONFIGURATION (self), 0);
	_tmp0_ = self->priv->_gnome_interface;
	_tmp1_ = g_settings_get_string (_tmp0_, APPLICATION_CONFIGURATION_CLOCK_FORMAT_KEY);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strcmp0 (_tmp2_, "12h") == 0;
	_g_free0 (_tmp2_);
	if (_tmp3_) {
		result = UTIL_DATE_CLOCK_FORMAT_TWELVE_HOURS;
		return result;
	} else {
		result = UTIL_DATE_CLOCK_FORMAT_TWENTY_FOUR_HOURS;
		return result;
	}
}

gboolean
application_configuration_get_ask_open_attachment (ApplicationConfiguration* self)
{
	gboolean result;
	GSettings* _tmp0_;
	g_return_val_if_fail (APPLICATION_IS_CONFIGURATION (self), FALSE);
	_tmp0_ = self->priv->_settings;
	result = g_settings_get_boolean (_tmp0_, APPLICATION_CONFIGURATION_ASK_OPEN_ATTACHMENT_KEY);
	return result;
}

void
application_configuration_set_ask_open_attachment (ApplicationConfiguration* self,
                                                   gboolean value)
{
	g_return_if_fail (APPLICATION_IS_CONFIGURATION (self));
	application_configuration_set_boolean (self, APPLICATION_CONFIGURATION_ASK_OPEN_ATTACHMENT_KEY, value);
	g_object_notify_by_pspec ((GObject *) self, application_configuration_properties[APPLICATION_CONFIGURATION_ASK_OPEN_ATTACHMENT_PROPERTY]);
}

gboolean
application_configuration_get_compose_as_html (ApplicationConfiguration* self)
{
	gboolean result;
	GSettings* _tmp0_;
	g_return_val_if_fail (APPLICATION_IS_CONFIGURATION (self), FALSE);
	_tmp0_ = self->priv->_settings;
	result = g_settings_get_boolean (_tmp0_, APPLICATION_CONFIGURATION_COMPOSE_AS_HTML_KEY);
	return result;
}

void
application_configuration_set_compose_as_html (ApplicationConfiguration* self,
                                               gboolean value)
{
	g_return_if_fail (APPLICATION_IS_CONFIGURATION (self));
	application_configuration_set_boolean (self, APPLICATION_CONFIGURATION_COMPOSE_AS_HTML_KEY, value);
	g_object_notify_by_pspec ((GObject *) self, application_configuration_properties[APPLICATION_CONFIGURATION_COMPOSE_AS_HTML_PROPERTY]);
}

gdouble
application_configuration_get_conversation_viewer_zoom (ApplicationConfiguration* self)
{
	gdouble result;
	GSettings* _tmp0_;
	g_return_val_if_fail (APPLICATION_IS_CONFIGURATION (self), 0.0);
	_tmp0_ = self->priv->_settings;
	result = g_settings_get_double (_tmp0_, APPLICATION_CONFIGURATION_CONVERSATION_VIEWER_ZOOM_KEY);
	return result;
}

void
application_configuration_set_conversation_viewer_zoom (ApplicationConfiguration* self,
                                                        gdouble value)
{
	GSettings* _tmp0_;
	g_return_if_fail (APPLICATION_IS_CONFIGURATION (self));
	_tmp0_ = self->priv->_settings;
	g_settings_set_double (_tmp0_, APPLICATION_CONFIGURATION_CONVERSATION_VIEWER_ZOOM_KEY, value);
	g_object_notify_by_pspec ((GObject *) self, application_configuration_properties[APPLICATION_CONFIGURATION_CONVERSATION_VIEWER_ZOOM_PROPERTY]);
}

gint
application_configuration_get_undo_send_delay (ApplicationConfiguration* self)
{
	gint result;
	GSettings* _tmp0_;
	g_return_val_if_fail (APPLICATION_IS_CONFIGURATION (self), 0);
	_tmp0_ = self->priv->_settings;
	result = g_settings_get_int (_tmp0_, APPLICATION_CONFIGURATION_UNDO_SEND_DELAY);
	return result;
}

gint
application_configuration_get_brief_notification_duration (ApplicationConfiguration* self)
{
	gint result;
	GSettings* _tmp0_;
	g_return_val_if_fail (APPLICATION_IS_CONFIGURATION (self), 0);
	_tmp0_ = self->priv->_settings;
	result = g_settings_get_int (_tmp0_, APPLICATION_CONFIGURATION_BRIEF_NOTIFICATION_DURATION);
	return result;
}

ApplicationConfiguration*
application_configuration_construct (GType object_type,
                                     const gchar* schema_id)
{
	ApplicationConfiguration * self = NULL;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	g_return_val_if_fail (schema_id != NULL, NULL);
	self = (ApplicationConfiguration*) geary_base_object_construct (object_type);
	_tmp0_ = g_settings_new (schema_id);
	_tmp1_ = _tmp0_;
	application_configuration_set_settings (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = g_settings_new ("org.gnome.desktop.interface");
	_tmp3_ = _tmp2_;
	application_configuration_set_gnome_interface (self, _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = self->priv->_settings;
	util_migrate_old_app_config (_tmp4_, UTIL_MIGRATE_OLD_APP_ID);
	application_configuration_bind (self, APPLICATION_CONFIGURATION_SINGLE_KEY_SHORTCUTS, G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), APPLICATION_CONFIGURATION_SINGLE_KEY_SHORTCUTS, G_SETTINGS_BIND_DEFAULT);
	return self;
}

ApplicationConfiguration*
application_configuration_new (const gchar* schema_id)
{
	return application_configuration_construct (APPLICATION_TYPE_CONFIGURATION, schema_id);
}

void
application_configuration_bind (ApplicationConfiguration* self,
                                const gchar* key,
                                GObject* object,
                                const gchar* property,
                                GSettingsBindFlags flags)
{
	GSettings* _tmp0_;
	g_return_if_fail (APPLICATION_IS_CONFIGURATION (self));
	g_return_if_fail (key != NULL);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (object, G_TYPE_OBJECT));
	g_return_if_fail (property != NULL);
	_tmp0_ = self->priv->_settings;
	g_settings_bind (_tmp0_, key, object, property, flags);
}

void
application_configuration_bind_with_mapping (ApplicationConfiguration* self,
                                             const gchar* key,
                                             GObject* object,
                                             const gchar* property,
                                             GSettingsBindGetMapping get_mapping,
                                             GSettingsBindSetMapping set_mapping,
                                             GSettingsBindFlags flags)
{
	GSettings* _tmp0_;
	g_return_if_fail (APPLICATION_IS_CONFIGURATION (self));
	g_return_if_fail (key != NULL);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (object, G_TYPE_OBJECT));
	g_return_if_fail (property != NULL);
	_tmp0_ = self->priv->_settings;
	g_settings_bind_with_mapping (_tmp0_, key, object, property, flags, get_mapping, set_mapping, NULL, NULL);
}

static gchar*
bool_to_string (gboolean self)
{
	gchar* result;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}

static void
application_configuration_set_boolean (ApplicationConfiguration* self,
                                       const gchar* name,
                                       gboolean value)
{
	GSettings* _tmp0_;
	g_return_if_fail (APPLICATION_IS_CONFIGURATION (self));
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->_settings;
	if (!g_settings_set_boolean (_tmp0_, name, value)) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = bool_to_string (value);
		_tmp2_ = _tmp1_;
		g_message ("application-configuration.vala:172: Unable to set configuration value " \
"%s = %s", name, _tmp2_);
		_g_free0 (_tmp2_);
	}
}

/** Returns the saved size of the composer window. */
static gint
_variant_get1 (GVariant* value)
{
	return g_variant_get_int32 (value);
}

static gint
_variant_get2 (GVariant* value)
{
	return g_variant_get_int32 (value);
}

gint*
application_configuration_get_composer_window_size (ApplicationConfiguration* self,
                                                    gint* result_length1)
{
	gint* size = NULL;
	gint* _tmp0_;
	gint size_length1;
	gint _size_size_;
	GVariant* s = NULL;
	GSettings* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	gint* _tmp14_;
	gint _tmp14__length1;
	gint* result;
	g_return_val_if_fail (APPLICATION_IS_CONFIGURATION (self), NULL);
	_tmp0_ = g_new0 (gint, 2);
	size = _tmp0_;
	size_length1 = 2;
	_size_size_ = size_length1;
	_tmp1_ = self->priv->_settings;
	_tmp2_ = g_settings_get_value (_tmp1_, APPLICATION_CONFIGURATION_COMPOSER_WINDOW_SIZE_KEY);
	s = _tmp2_;
	_tmp3_ = s;
	if (g_variant_n_children (_tmp3_) == ((gsize) 2)) {
		GVariant* _tmp4_;
		GVariant* _tmp5_;
		GVariant* _tmp6_;
		gint _tmp7_;
		GVariant* _tmp8_;
		GVariant* _tmp9_;
		GVariant* _tmp10_;
		gint _tmp11_;
		gint* _tmp12_;
		_tmp4_ = s;
		_tmp5_ = g_variant_get_child_value (_tmp4_, (gsize) 0);
		_tmp6_ = _tmp5_;
		_tmp7_ = _variant_get1 (_tmp6_);
		_tmp8_ = s;
		_tmp9_ = g_variant_get_child_value (_tmp8_, (gsize) 1);
		_tmp10_ = _tmp9_;
		_tmp11_ = _variant_get2 (_tmp10_);
		_tmp12_ = g_new0 (gint, 2);
		_tmp12_[0] = _tmp7_;
		_tmp12_[1] = _tmp11_;
		size = (g_free (size), NULL);
		size = _tmp12_;
		size_length1 = 2;
		_size_size_ = size_length1;
		_g_variant_unref0 (_tmp10_);
		_g_variant_unref0 (_tmp6_);
	} else {
		gint* _tmp13_;
		_tmp13_ = g_new0 (gint, 2);
		_tmp13_[0] = -1;
		_tmp13_[1] = -1;
		size = (g_free (size), NULL);
		size = _tmp13_;
		size_length1 = 2;
		_size_size_ = size_length1;
	}
	_tmp14_ = size;
	_tmp14__length1 = size_length1;
	if (result_length1) {
		*result_length1 = _tmp14__length1;
	}
	result = _tmp14_;
	_g_variant_unref0 (s);
	return result;
}

/** Sets the saved size of the composer window. */
static GVariant*
_variant_new1 (gint* value,
               gint value_length1)
{
	gint* _tmp1_;
	GVariantBuilder _tmp2_;
	gint _tmp3_;
	_tmp1_ = value;
	g_variant_builder_init (&_tmp2_, G_VARIANT_TYPE ("ai"));
	for (_tmp3_ = 0; _tmp3_ < value_length1; _tmp3_++) {
		g_variant_builder_add_value (&_tmp2_, g_variant_new_int32 (*_tmp1_));
		_tmp1_++;
	}
	return g_variant_ref_sink (g_variant_builder_end (&_tmp2_));
}

void
application_configuration_set_composer_window_size (ApplicationConfiguration* self,
                                                    gint* value,
                                                    gint value_length1)
{
	GSettings* _tmp0_;
	GVariant* _tmp4_;
	g_return_if_fail (APPLICATION_IS_CONFIGURATION (self));
	_tmp0_ = self->priv->_settings;
	_tmp4_ = _variant_new1 (value, value_length1);
	g_settings_set_value (_tmp0_, APPLICATION_CONFIGURATION_COMPOSER_WINDOW_SIZE_KEY, _tmp4_);
	_g_variant_unref0 (_tmp4_);
}

/** Returns list of trusted domains for which images loading is allowed. */
gchar**
application_configuration_get_images_trusted_domains (ApplicationConfiguration* self,
                                                      gint* result_length1)
{
	GSettings* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** result;
	g_return_val_if_fail (APPLICATION_IS_CONFIGURATION (self), NULL);
	_tmp0_ = self->priv->_settings;
	_tmp2_ = _tmp1_ = g_settings_get_strv (_tmp0_, APPLICATION_CONFIGURATION_IMAGES_TRUSTED_DOMAINS);
	_tmp3_ = _tmp2_;
	_tmp3__length1 = _vala_array_length (_tmp1_);
	if (result_length1) {
		*result_length1 = _tmp3__length1;
	}
	result = _tmp3_;
	return result;
}

/** Sets list of trusted domains for which images loading is allowed. */
void
application_configuration_set_images_trusted_domains (ApplicationConfiguration* self,
                                                      gchar** value,
                                                      gint value_length1)
{
	GSettings* _tmp0_;
	g_return_if_fail (APPLICATION_IS_CONFIGURATION (self));
	_tmp0_ = self->priv->_settings;
	g_settings_set_strv (_tmp0_, APPLICATION_CONFIGURATION_IMAGES_TRUSTED_DOMAINS, value);
}

/** Adds domain to trusted list for which images loading is allowed. */
static void
_vala_array_add5 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

void
application_configuration_add_images_trusted_domain (ApplicationConfiguration* self,
                                                     const gchar* domain)
{
	gchar** domains = NULL;
	gint _tmp0_ = 0;
	gchar** _tmp1_;
	gint domains_length1;
	gint _domains_size_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	g_return_if_fail (APPLICATION_IS_CONFIGURATION (self));
	g_return_if_fail (domain != NULL);
	_tmp1_ = application_configuration_get_images_trusted_domains (self, &_tmp0_);
	domains = _tmp1_;
	domains_length1 = _tmp0_;
	_domains_size_ = domains_length1;
	_tmp2_ = g_strdup (domain);
	_vala_array_add5 (&domains, &domains_length1, &_domains_size_, _tmp2_);
	_tmp3_ = domains;
	_tmp3__length1 = domains_length1;
	application_configuration_set_images_trusted_domains (self, _tmp3_, (gint) _tmp3__length1);
	domains = (_vala_array_free (domains, domains_length1, (GDestroyNotify) g_free), NULL);
}

/** Removes domain from trusted for which images loading is allowed. */
static void
_vala_array_add6 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

void
application_configuration_remove_images_trusted_domain (ApplicationConfiguration* self,
                                                        const gchar* domain)
{
	gchar** domains = NULL;
	gint _tmp0_ = 0;
	gchar** _tmp1_;
	gint domains_length1;
	gint _domains_size_;
	gchar** new_domains = NULL;
	gchar** _tmp2_;
	gint new_domains_length1;
	gint _new_domains_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** _tmp8_;
	gint _tmp8__length1;
	g_return_if_fail (APPLICATION_IS_CONFIGURATION (self));
	g_return_if_fail (domain != NULL);
	_tmp1_ = application_configuration_get_images_trusted_domains (self, &_tmp0_);
	domains = _tmp1_;
	domains_length1 = _tmp0_;
	_domains_size_ = domains_length1;
	_tmp2_ = g_new0 (gchar*, 0 + 1);
	new_domains = _tmp2_;
	new_domains_length1 = 0;
	_new_domains_size_ = new_domains_length1;
	_tmp3_ = domains;
	_tmp3__length1 = domains_length1;
	{
		gchar** _domain_collection = NULL;
		gint _domain_collection_length1 = 0;
		gint __domain_collection_size_ = 0;
		gint _domain_it = 0;
		_domain_collection = _tmp3_;
		_domain_collection_length1 = _tmp3__length1;
		for (_domain_it = 0; _domain_it < _domain_collection_length1; _domain_it = _domain_it + 1) {
			gchar* _tmp4_;
			gchar* _domain = NULL;
			_tmp4_ = g_strdup (_domain_collection[_domain_it]);
			_domain = _tmp4_;
			{
				const gchar* _tmp5_;
				_tmp5_ = _domain;
				if (g_strcmp0 (domain, _tmp5_) != 0) {
					const gchar* _tmp6_;
					gchar* _tmp7_;
					_tmp6_ = _domain;
					_tmp7_ = g_strdup (_tmp6_);
					_vala_array_add6 (&new_domains, &new_domains_length1, &_new_domains_size_, _tmp7_);
				}
				_g_free0 (_domain);
			}
		}
	}
	_tmp8_ = new_domains;
	_tmp8__length1 = new_domains_length1;
	application_configuration_set_images_trusted_domains (self, _tmp8_, (gint) _tmp8__length1);
	new_domains = (_vala_array_free (new_domains, new_domains_length1, (GDestroyNotify) g_free), NULL);
	domains = (_vala_array_free (domains, domains_length1, (GDestroyNotify) g_free), NULL);
}

/**
     * Returns list of optional plugins to load by default
     */
gchar**
application_configuration_get_optional_plugins (ApplicationConfiguration* self,
                                                gint* result_length1)
{
	GSettings* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** result;
	g_return_val_if_fail (APPLICATION_IS_CONFIGURATION (self), NULL);
	_tmp0_ = self->priv->_settings;
	_tmp2_ = _tmp1_ = g_settings_get_strv (_tmp0_, APPLICATION_CONFIGURATION_OPTIONAL_PLUGINS);
	_tmp3_ = _tmp2_;
	_tmp3__length1 = _vala_array_length (_tmp1_);
	if (result_length1) {
		*result_length1 = _tmp3__length1;
	}
	result = _tmp3_;
	return result;
}

/**
     * Sets the list of optional plugins to load by default
     */
void
application_configuration_set_optional_plugins (ApplicationConfiguration* self,
                                                gchar** value,
                                                gint value_length1)
{
	GSettings* _tmp0_;
	g_return_if_fail (APPLICATION_IS_CONFIGURATION (self));
	_tmp0_ = self->priv->_settings;
	g_settings_set_strv (_tmp0_, APPLICATION_CONFIGURATION_OPTIONAL_PLUGINS, value);
}

/**
     * Returns enabled spell checker languages.
     *
     * This specifies the languages used for spell checking by the
     * client. By default, the set will contain languages based on
     * environment variables.
     *
     * @see Util.I18n.get_user_preferred_languages
     */
static gchar**
_vala_array_dup2 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

gchar**
application_configuration_get_spell_check_languages (ApplicationConfiguration* self,
                                                     gint* result_length1)
{
	GVariant* value = NULL;
	GSettings* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	const gchar** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gint __tmp5__size_ = 0;
	GVariant* _tmp6_;
	gchar** langs = NULL;
	gchar** _tmp12_;
	gint _tmp12__length1;
	gint langs_length1;
	gint _langs_size_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	gchar** result;
	g_return_val_if_fail (APPLICATION_IS_CONFIGURATION (self), NULL);
	_tmp0_ = self->priv->_settings;
	_tmp1_ = g_settings_get_value (_tmp0_, APPLICATION_CONFIGURATION_SPELL_CHECK_LANGUAGES);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_variant_get_maybe (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_variant_unref0 (_tmp2_);
	value = _tmp4_;
	_tmp6_ = value;
	if (_tmp6_ != NULL) {
		GVariant* _tmp7_;
		gsize _tmp8_ = 0;
		const gchar** _tmp9_;
		_tmp7_ = value;
		_tmp9_ = g_variant_get_strv (_tmp7_, &_tmp8_);
		_tmp5_ = (g_free (_tmp5_), NULL);
		_tmp5_ = _tmp9_;
		_tmp5__length1 = _tmp8_;
		__tmp5__size_ = _tmp5__length1;
	} else {
		gint _tmp10_ = 0;
		gchar** _tmp11_;
		_tmp11_ = util_i18n_get_user_preferred_languages (&_tmp10_);
		_tmp5_ = (g_free (_tmp5_), NULL);
		_tmp5_ = _tmp11_;
		_tmp5__length1 = _tmp10_;
		__tmp5__size_ = _tmp5__length1;
	}
	_tmp12_ = (_tmp5_ != NULL) ? _vala_array_dup2 (_tmp5_, _tmp5__length1) : _tmp5_;
	_tmp12__length1 = _tmp5__length1;
	langs = _tmp12_;
	langs_length1 = _tmp12__length1;
	_langs_size_ = langs_length1;
	_tmp13_ = langs;
	_tmp13__length1 = langs_length1;
	if (result_length1) {
		*result_length1 = _tmp13__length1;
	}
	result = _tmp13_;
	_tmp5_ = (g_free (_tmp5_), NULL);
	_g_variant_unref0 (value);
	return result;
}

/**
     * Sets enabled spell checker languages.
     *
     * This specifies the languages used for spell checking by the
     * client. By default, the set will contain languages based on
     * environment variables.
     *
     * @see Util.I18n.get_user_preferred_languages
     */
void
application_configuration_set_spell_check_languages (ApplicationConfiguration* self,
                                                     gchar** value,
                                                     gint value_length1)
{
	GSettings* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	g_return_if_fail (APPLICATION_IS_CONFIGURATION (self));
	_tmp0_ = self->priv->_settings;
	_tmp1_ = g_variant_new_strv (value, value_length1);
	g_variant_ref_sink (_tmp1_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_variant_new_maybe (NULL, _tmp2_);
	g_variant_ref_sink (_tmp3_);
	_tmp4_ = _tmp3_;
	g_settings_set_value (_tmp0_, APPLICATION_CONFIGURATION_SPELL_CHECK_LANGUAGES, _tmp4_);
	_g_variant_unref0 (_tmp4_);
	_g_variant_unref0 (_tmp2_);
}

/**
     * Returns visible spell checker languages.
     *
     * This is the list of languages shown when selecting languages to
     * be used for spell checking.
     */
gchar**
application_configuration_get_spell_check_visible_languages (ApplicationConfiguration* self,
                                                             gint* result_length1)
{
	GSettings* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** result;
	g_return_val_if_fail (APPLICATION_IS_CONFIGURATION (self), NULL);
	_tmp0_ = self->priv->_settings;
	_tmp2_ = _tmp1_ = g_settings_get_strv (_tmp0_, APPLICATION_CONFIGURATION_SPELL_CHECK_VISIBLE_LANGUAGES);
	_tmp3_ = _tmp2_;
	_tmp3__length1 = _vala_array_length (_tmp1_);
	if (result_length1) {
		*result_length1 = _tmp3__length1;
	}
	result = _tmp3_;
	return result;
}

/**
     * Sets visible spell checker languages.
     *
     * This is the list of languages shown when selecting languages to
     * be used for spell checking.
     */
void
application_configuration_set_spell_check_visible_languages (ApplicationConfiguration* self,
                                                             gchar** value,
                                                             gint value_length1)
{
	GSettings* _tmp0_;
	g_return_if_fail (APPLICATION_IS_CONFIGURATION (self));
	_tmp0_ = self->priv->_settings;
	g_settings_set_strv (_tmp0_, APPLICATION_CONFIGURATION_SPELL_CHECK_VISIBLE_LANGUAGES, value);
}

GearySearchQueryStrategy
application_configuration_get_search_strategy (ApplicationConfiguration* self)
{
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GQuark _tmp7_ = 0U;
	static GQuark _tmp6_label0 = 0;
	static GQuark _tmp6_label1 = 0;
	static GQuark _tmp6_label2 = 0;
	GearySearchQueryStrategy result;
	g_return_val_if_fail (APPLICATION_IS_CONFIGURATION (self), 0);
	_tmp0_ = self->priv->_settings;
	_tmp1_ = g_settings_get_string (_tmp0_, APPLICATION_CONFIGURATION_SEARCH_STRATEGY_KEY);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_utf8_strdown (_tmp2_, (gssize) -1);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	_tmp5_ = _tmp4_;
	_tmp7_ = (NULL == _tmp5_) ? 0 : g_quark_from_string (_tmp5_);
	g_free (_tmp5_);
	if (_tmp7_ == ((0 != _tmp6_label0) ? _tmp6_label0 : (_tmp6_label0 = g_quark_from_static_string ("exact")))) {
		switch (0) {
			default:
			{
				result = GEARY_SEARCH_QUERY_STRATEGY_EXACT;
				return result;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label1) ? _tmp6_label1 : (_tmp6_label1 = g_quark_from_static_string ("aggressive")))) {
		switch (0) {
			default:
			{
				result = GEARY_SEARCH_QUERY_STRATEGY_AGGRESSIVE;
				return result;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label2) ? _tmp6_label2 : (_tmp6_label2 = g_quark_from_static_string ("horizon")))) {
		switch (0) {
			default:
			{
				result = GEARY_SEARCH_QUERY_STRATEGY_HORIZON;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = GEARY_SEARCH_QUERY_STRATEGY_CONSERVATIVE;
				return result;
			}
		}
	}
}

void
application_configuration_set_search_strategy (ApplicationConfiguration* self,
                                               GearySearchQueryStrategy strategy)
{
	g_return_if_fail (APPLICATION_IS_CONFIGURATION (self));
	switch (strategy) {
		case GEARY_SEARCH_QUERY_STRATEGY_EXACT:
		{
			GSettings* _tmp0_;
			_tmp0_ = self->priv->_settings;
			g_settings_set_string (_tmp0_, APPLICATION_CONFIGURATION_SEARCH_STRATEGY_KEY, "exact");
			break;
		}
		case GEARY_SEARCH_QUERY_STRATEGY_AGGRESSIVE:
		{
			GSettings* _tmp1_;
			_tmp1_ = self->priv->_settings;
			g_settings_set_string (_tmp1_, APPLICATION_CONFIGURATION_SEARCH_STRATEGY_KEY, "aggressive");
			break;
		}
		case GEARY_SEARCH_QUERY_STRATEGY_HORIZON:
		{
			GSettings* _tmp2_;
			_tmp2_ = self->priv->_settings;
			g_settings_set_string (_tmp2_, APPLICATION_CONFIGURATION_SEARCH_STRATEGY_KEY, "horizon");
			break;
		}
		default:
		case GEARY_SEARCH_QUERY_STRATEGY_CONSERVATIVE:
		{
			GSettings* _tmp3_;
			_tmp3_ = self->priv->_settings;
			g_settings_set_string (_tmp3_, APPLICATION_CONFIGURATION_SEARCH_STRATEGY_KEY, "conservative");
			break;
		}
	}
}

static void
application_configuration_class_init (ApplicationConfigurationClass * klass,
                                      gpointer klass_data)
{
	application_configuration_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ApplicationConfiguration_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_application_configuration_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_application_configuration_set_property;
	G_OBJECT_CLASS (klass)->finalize = application_configuration_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_CONFIGURATION_SETTINGS_PROPERTY, application_configuration_properties[APPLICATION_CONFIGURATION_SETTINGS_PROPERTY] = g_param_spec_object ("settings", "settings", "settings", g_settings_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_CONFIGURATION_GNOME_INTERFACE_PROPERTY, application_configuration_properties[APPLICATION_CONFIGURATION_GNOME_INTERFACE_PROPERTY] = g_param_spec_object ("gnome-interface", "gnome-interface", "gnome-interface", g_settings_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_CONFIGURATION_ENABLE_DEBUG_PROPERTY, application_configuration_properties[APPLICATION_CONFIGURATION_ENABLE_DEBUG_PROPERTY] = g_param_spec_boolean ("enable-debug", "enable-debug", "enable-debug", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_CONFIGURATION_ENABLE_INSPECTOR_PROPERTY, application_configuration_properties[APPLICATION_CONFIGURATION_ENABLE_INSPECTOR_PROPERTY] = g_param_spec_boolean ("enable-inspector", "enable-inspector", "enable-inspector", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_CONFIGURATION_REVOKE_CERTS_PROPERTY, application_configuration_properties[APPLICATION_CONFIGURATION_REVOKE_CERTS_PROPERTY] = g_param_spec_boolean ("revoke-certs", "revoke-certs", "revoke-certs", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_CONFIGURATION_DESKTOP_ENVIRONMENT_PROPERTY, application_configuration_properties[APPLICATION_CONFIGURATION_DESKTOP_ENVIRONMENT_PROPERTY] = g_param_spec_enum ("desktop-environment", "desktop-environment", "desktop-environment", APPLICATION_CONFIGURATION_TYPE_DESKTOP_ENVIRONMENT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_CONFIGURATION_WINDOW_WIDTH_PROPERTY, application_configuration_properties[APPLICATION_CONFIGURATION_WINDOW_WIDTH_PROPERTY] = g_param_spec_int ("window-width", "window-width", "window-width", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_CONFIGURATION_WINDOW_HEIGHT_PROPERTY, application_configuration_properties[APPLICATION_CONFIGURATION_WINDOW_HEIGHT_PROPERTY] = g_param_spec_int ("window-height", "window-height", "window-height", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_CONFIGURATION_WINDOW_MAXIMIZE_PROPERTY, application_configuration_properties[APPLICATION_CONFIGURATION_WINDOW_MAXIMIZE_PROPERTY] = g_param_spec_boolean ("window-maximize", "window-maximize", "window-maximize", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_CONFIGURATION_FORMATTING_TOOLBAR_VISIBLE_PROPERTY, application_configuration_properties[APPLICATION_CONFIGURATION_FORMATTING_TOOLBAR_VISIBLE_PROPERTY] = g_param_spec_boolean ("formatting-toolbar-visible", "formatting-toolbar-visible", "formatting-toolbar-visible", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_CONFIGURATION_AUTOSELECT_PROPERTY, application_configuration_properties[APPLICATION_CONFIGURATION_AUTOSELECT_PROPERTY] = g_param_spec_boolean ("autoselect", "autoselect", "autoselect", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_CONFIGURATION_DISPLAY_PREVIEW_PROPERTY, application_configuration_properties[APPLICATION_CONFIGURATION_DISPLAY_PREVIEW_PROPERTY] = g_param_spec_boolean ("display-preview", "display-preview", "display-preview", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_CONFIGURATION_SINGLE_KEY_SHORTCUTS_PROPERTY, application_configuration_properties[APPLICATION_CONFIGURATION_SINGLE_KEY_SHORTCUTS_PROPERTY] = g_param_spec_boolean ("single-key-shortcuts", "single-key-shortcuts", "single-key-shortcuts", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_CONFIGURATION_RUN_IN_BACKGROUND_PROPERTY, application_configuration_properties[APPLICATION_CONFIGURATION_RUN_IN_BACKGROUND_PROPERTY] = g_param_spec_boolean ("run-in-background", "run-in-background", "run-in-background", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_CONFIGURATION_CLOCK_FORMAT_PROPERTY, application_configuration_properties[APPLICATION_CONFIGURATION_CLOCK_FORMAT_PROPERTY] = g_param_spec_enum ("clock-format", "clock-format", "clock-format", UTIL_DATE_TYPE_CLOCK_FORMAT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_CONFIGURATION_ASK_OPEN_ATTACHMENT_PROPERTY, application_configuration_properties[APPLICATION_CONFIGURATION_ASK_OPEN_ATTACHMENT_PROPERTY] = g_param_spec_boolean ("ask-open-attachment", "ask-open-attachment", "ask-open-attachment", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_CONFIGURATION_COMPOSE_AS_HTML_PROPERTY, application_configuration_properties[APPLICATION_CONFIGURATION_COMPOSE_AS_HTML_PROPERTY] = g_param_spec_boolean ("compose-as-html", "compose-as-html", "compose-as-html", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_CONFIGURATION_CONVERSATION_VIEWER_ZOOM_PROPERTY, application_configuration_properties[APPLICATION_CONFIGURATION_CONVERSATION_VIEWER_ZOOM_PROPERTY] = g_param_spec_double ("conversation-viewer-zoom", "conversation-viewer-zoom", "conversation-viewer-zoom", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/** The number of seconds to wait before sending an email. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_CONFIGURATION_UNDO_SEND_DELAY_PROPERTY, application_configuration_properties[APPLICATION_CONFIGURATION_UNDO_SEND_DELAY_PROPERTY] = g_param_spec_int ("undo-send-delay", "undo-send-delay", "undo-send-delay", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** The number of seconds for which brief notifications should be displayed. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_CONFIGURATION_BRIEF_NOTIFICATION_DURATION_PROPERTY, application_configuration_properties[APPLICATION_CONFIGURATION_BRIEF_NOTIFICATION_DURATION_PROPERTY] = g_param_spec_int ("brief-notification-duration", "brief-notification-duration", "brief-notification-duration", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
application_configuration_instance_init (ApplicationConfiguration * self,
                                         gpointer klass)
{
	self->priv = application_configuration_get_instance_private (self);
	self->priv->_enable_debug = FALSE;
	self->priv->_enable_inspector = FALSE;
	self->priv->_revoke_certs = FALSE;
	self->priv->_single_key_shortcuts = FALSE;
}

static void
application_configuration_finalize (GObject * obj)
{
	ApplicationConfiguration * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, APPLICATION_TYPE_CONFIGURATION, ApplicationConfiguration);
	_g_object_unref0 (self->priv->_settings);
	_g_object_unref0 (self->priv->_gnome_interface);
	G_OBJECT_CLASS (application_configuration_parent_class)->finalize (obj);
}

/**
 * Provides properties to access application GSettings values.
 */
static GType
application_configuration_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ApplicationConfigurationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) application_configuration_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ApplicationConfiguration), 0, (GInstanceInitFunc) application_configuration_instance_init, NULL };
	GType application_configuration_type_id;
	application_configuration_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "ApplicationConfiguration", &g_define_type_info, 0);
	ApplicationConfiguration_private_offset = g_type_add_instance_private (application_configuration_type_id, sizeof (ApplicationConfigurationPrivate));
	return application_configuration_type_id;
}

GType
application_configuration_get_type (void)
{
	static volatile gsize application_configuration_type_id__once = 0;
	if (g_once_init_enter (&application_configuration_type_id__once)) {
		GType application_configuration_type_id;
		application_configuration_type_id = application_configuration_get_type_once ();
		g_once_init_leave (&application_configuration_type_id__once, application_configuration_type_id);
	}
	return application_configuration_type_id__once;
}

static void
_vala_application_configuration_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	ApplicationConfiguration * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, APPLICATION_TYPE_CONFIGURATION, ApplicationConfiguration);
	switch (property_id) {
		case APPLICATION_CONFIGURATION_SETTINGS_PROPERTY:
		g_value_set_object (value, application_configuration_get_settings (self));
		break;
		case APPLICATION_CONFIGURATION_GNOME_INTERFACE_PROPERTY:
		g_value_set_object (value, application_configuration_get_gnome_interface (self));
		break;
		case APPLICATION_CONFIGURATION_ENABLE_DEBUG_PROPERTY:
		g_value_set_boolean (value, application_configuration_get_enable_debug (self));
		break;
		case APPLICATION_CONFIGURATION_ENABLE_INSPECTOR_PROPERTY:
		g_value_set_boolean (value, application_configuration_get_enable_inspector (self));
		break;
		case APPLICATION_CONFIGURATION_REVOKE_CERTS_PROPERTY:
		g_value_set_boolean (value, application_configuration_get_revoke_certs (self));
		break;
		case APPLICATION_CONFIGURATION_DESKTOP_ENVIRONMENT_PROPERTY:
		g_value_set_enum (value, application_configuration_get_desktop_environment (self));
		break;
		case APPLICATION_CONFIGURATION_WINDOW_WIDTH_PROPERTY:
		g_value_set_int (value, application_configuration_get_window_width (self));
		break;
		case APPLICATION_CONFIGURATION_WINDOW_HEIGHT_PROPERTY:
		g_value_set_int (value, application_configuration_get_window_height (self));
		break;
		case APPLICATION_CONFIGURATION_WINDOW_MAXIMIZE_PROPERTY:
		g_value_set_boolean (value, application_configuration_get_window_maximize (self));
		break;
		case APPLICATION_CONFIGURATION_FORMATTING_TOOLBAR_VISIBLE_PROPERTY:
		g_value_set_boolean (value, application_configuration_get_formatting_toolbar_visible (self));
		break;
		case APPLICATION_CONFIGURATION_AUTOSELECT_PROPERTY:
		g_value_set_boolean (value, application_configuration_get_autoselect (self));
		break;
		case APPLICATION_CONFIGURATION_DISPLAY_PREVIEW_PROPERTY:
		g_value_set_boolean (value, application_configuration_get_display_preview (self));
		break;
		case APPLICATION_CONFIGURATION_SINGLE_KEY_SHORTCUTS_PROPERTY:
		g_value_set_boolean (value, application_configuration_get_single_key_shortcuts (self));
		break;
		case APPLICATION_CONFIGURATION_RUN_IN_BACKGROUND_PROPERTY:
		g_value_set_boolean (value, application_configuration_get_run_in_background (self));
		break;
		case APPLICATION_CONFIGURATION_CLOCK_FORMAT_PROPERTY:
		g_value_set_enum (value, application_configuration_get_clock_format (self));
		break;
		case APPLICATION_CONFIGURATION_ASK_OPEN_ATTACHMENT_PROPERTY:
		g_value_set_boolean (value, application_configuration_get_ask_open_attachment (self));
		break;
		case APPLICATION_CONFIGURATION_COMPOSE_AS_HTML_PROPERTY:
		g_value_set_boolean (value, application_configuration_get_compose_as_html (self));
		break;
		case APPLICATION_CONFIGURATION_CONVERSATION_VIEWER_ZOOM_PROPERTY:
		g_value_set_double (value, application_configuration_get_conversation_viewer_zoom (self));
		break;
		case APPLICATION_CONFIGURATION_UNDO_SEND_DELAY_PROPERTY:
		g_value_set_int (value, application_configuration_get_undo_send_delay (self));
		break;
		case APPLICATION_CONFIGURATION_BRIEF_NOTIFICATION_DURATION_PROPERTY:
		g_value_set_int (value, application_configuration_get_brief_notification_duration (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_application_configuration_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec)
{
	ApplicationConfiguration * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, APPLICATION_TYPE_CONFIGURATION, ApplicationConfiguration);
	switch (property_id) {
		case APPLICATION_CONFIGURATION_SETTINGS_PROPERTY:
		application_configuration_set_settings (self, g_value_get_object (value));
		break;
		case APPLICATION_CONFIGURATION_GNOME_INTERFACE_PROPERTY:
		application_configuration_set_gnome_interface (self, g_value_get_object (value));
		break;
		case APPLICATION_CONFIGURATION_ENABLE_DEBUG_PROPERTY:
		application_configuration_set_enable_debug (self, g_value_get_boolean (value));
		break;
		case APPLICATION_CONFIGURATION_ENABLE_INSPECTOR_PROPERTY:
		application_configuration_set_enable_inspector (self, g_value_get_boolean (value));
		break;
		case APPLICATION_CONFIGURATION_REVOKE_CERTS_PROPERTY:
		application_configuration_set_revoke_certs (self, g_value_get_boolean (value));
		break;
		case APPLICATION_CONFIGURATION_FORMATTING_TOOLBAR_VISIBLE_PROPERTY:
		application_configuration_set_formatting_toolbar_visible (self, g_value_get_boolean (value));
		break;
		case APPLICATION_CONFIGURATION_SINGLE_KEY_SHORTCUTS_PROPERTY:
		application_configuration_set_single_key_shortcuts (self, g_value_get_boolean (value));
		break;
		case APPLICATION_CONFIGURATION_RUN_IN_BACKGROUND_PROPERTY:
		application_configuration_set_run_in_background (self, g_value_get_boolean (value));
		break;
		case APPLICATION_CONFIGURATION_ASK_OPEN_ATTACHMENT_PROPERTY:
		application_configuration_set_ask_open_attachment (self, g_value_get_boolean (value));
		break;
		case APPLICATION_CONFIGURATION_COMPOSE_AS_HTML_PROPERTY:
		application_configuration_set_compose_as_html (self, g_value_get_boolean (value));
		break;
		case APPLICATION_CONFIGURATION_CONVERSATION_VIEWER_ZOOM_PROPERTY:
		application_configuration_set_conversation_viewer_zoom (self, g_value_get_double (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

