/* components-inspector.c generated by valac 0.56.3, the Vala compiler
 * generated from components-inspector.vala, do not modify */

/*
 * Copyright 2019 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-client-43.0.h"
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include "geary-engine.h"

#define COMPONENTS_INSPECTOR_ACTION_CLOSE "inspector-close"
#define COMPONENTS_INSPECTOR_ACTION_PLAY_TOGGLE "toggle-play"
#define COMPONENTS_INSPECTOR_ACTION_SEARCH_TOGGLE "toggle-search"
#define COMPONENTS_INSPECTOR_ACTION_SEARCH_ACTIVATE "activate-search"

enum  {
	COMPONENTS_INSPECTOR_0_PROPERTY,
	COMPONENTS_INSPECTOR_NUM_PROPERTIES
};
static GParamSpec* components_inspector_properties[COMPONENTS_INSPECTOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _geary_logging_record_unref0(var) ((var == NULL) ? NULL : (var = (geary_logging_record_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ComponentsInspectorSaveData ComponentsInspectorSaveData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

struct _ComponentsInspectorPrivate {
	GtkHeaderBar* header_bar;
	GtkStack* stack;
	GtkButton* copy_button;
	GtkToggleButton* play_button;
	GtkButton* mark_button;
	GtkToggleButton* search_button;
	GtkButton* clear_button;
	ComponentsInspectorLogView* log_pane;
	ComponentsInspectorSystemView* system_pane;
};

struct _ComponentsInspectorSaveData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ComponentsInspector* self;
	gchar* path;
	GCancellable* cancellable;
	GFile* dest;
	GFile* _tmp0_;
	GFileIOStream* dest_io;
	GFile* _tmp1_;
	GFileIOStream* _tmp2_;
	GDataOutputStream* out;
	GFileIOStream* _tmp3_;
	GOutputStream* _tmp4_;
	GBufferedOutputStream* _tmp5_;
	GBufferedOutputStream* _tmp6_;
	GDataOutputStream* _tmp7_;
	GDataOutputStream* _tmp8_;
	ComponentsInspectorSystemView* _tmp9_;
	GDataOutputStream* _tmp10_;
	GDataOutputStream* _tmp11_;
	ComponentsInspectorLogView* _tmp12_;
	GDataOutputStream* _tmp13_;
	GDataOutputStream* _tmp14_;
	GFileIOStream* _tmp15_;
	GError* _inner_error0_;
};

static gint ComponentsInspector_private_offset;
static gpointer components_inspector_parent_class = NULL;

static void components_inspector_on_copy_clicked (ComponentsInspector* self);
static void _components_inspector_on_copy_clicked_gsimple_action_activate_callback (GSimpleAction* action,
                                                                             GVariant* parameter,
                                                                             gpointer self);
static void components_inspector_on_close (ComponentsInspector* self);
static void _components_inspector_on_close_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self);
static void components_inspector_on_logs_play_toggled (ComponentsInspector* self,
                                                GSimpleAction* action,
                                                GVariant* param);
static void _components_inspector_on_logs_play_toggled_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                  GVariant* parameter,
                                                                                  gpointer self);
static void components_inspector_on_logs_search_toggled (ComponentsInspector* self,
                                                  GSimpleAction* action,
                                                  GVariant* param);
static void _components_inspector_on_logs_search_toggled_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                    GVariant* parameter,
                                                                                    gpointer self);
static void components_inspector_on_logs_search_activated (ComponentsInspector* self);
static void _components_inspector_on_logs_search_activated_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                      GVariant* parameter,
                                                                                      gpointer self);
static void components_inspector_on_logs_selection_changed (ComponentsInspector* self);
static void _components_inspector_on_logs_selection_changed_components_inspector_log_view_record_selection_changed (ComponentsInspectorLogView* _sender,
                                                                                                             gpointer self);
static void components_inspector_enable_log_updates (ComponentsInspector* self,
                                              gboolean enabled);
static gboolean components_inspector_real_key_press_event (GtkWidget* base,
                                                    GdkEventKey* event);
static void components_inspector_save_data_free (gpointer _data);
static void components_inspector_save (ComponentsInspector* self,
                                const gchar* path,
                                GCancellable* cancellable,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_);
static void components_inspector_save_finish (ComponentsInspector* self,
                                       GAsyncResult* _res_,
                                       GError** error);
static gboolean components_inspector_save_co (ComponentsInspectorSaveData* _data_);
static void components_inspector_save_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_);
static void components_inspector_update_ui (ComponentsInspector* self);
static void components_inspector_on_visible_child_changed (ComponentsInspector* self);
static void _components_inspector_on_visible_child_changed_g_object_notify (GObject* _sender,
                                                                     GParamSpec* pspec,
                                                                     gpointer self);
static void components_inspector_on_mark_clicked (ComponentsInspector* self);
static void _components_inspector_on_mark_clicked_gtk_button_clicked (GtkButton* _sender,
                                                               gpointer self);
static void components_inspector_on_clear_clicked (ComponentsInspector* self);
static void _components_inspector_on_clear_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                gpointer self);
static void components_inspector_on_save_as_clicked (ComponentsInspector* self);
static void ___lambda70_ (ComponentsInspector* self,
                   GObject* obj,
                   GAsyncResult* res);
static void ____lambda70__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static void _components_inspector_on_save_as_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                  gpointer self);
static gboolean _variant_get6 (GVariant* value);
static GVariant* _variant_new5 (gboolean value);
static gboolean _variant_get7 (GVariant* value);
static GVariant* _variant_new6 (gboolean value);
static void components_inspector_finalize (GObject * obj);
static GType components_inspector_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GActionEntry COMPONENTS_INSPECTOR_EDIT_ACTIONS[1] = {{ACTION_EDIT_COPY, _components_inspector_on_copy_clicked_gsimple_action_activate_callback}};
static const GActionEntry COMPONENTS_INSPECTOR_WINDOW_ACTIONS[5] = {{ACTION_WINDOW_CLOSE, _components_inspector_on_close_gsimple_action_activate_callback}, {COMPONENTS_INSPECTOR_ACTION_CLOSE, _components_inspector_on_close_gsimple_action_activate_callback}, {COMPONENTS_INSPECTOR_ACTION_PLAY_TOGGLE, _components_inspector_on_logs_play_toggled_gsimple_action_activate_callback, NULL, "true"}, {COMPONENTS_INSPECTOR_ACTION_SEARCH_TOGGLE, _components_inspector_on_logs_search_toggled_gsimple_action_activate_callback, NULL, "false"}, {COMPONENTS_INSPECTOR_ACTION_SEARCH_ACTIVATE, _components_inspector_on_logs_search_activated_gsimple_action_activate_callback}};

static inline gpointer
components_inspector_get_instance_private (ComponentsInspector* self)
{
	return G_STRUCT_MEMBER_P (self, ComponentsInspector_private_offset);
}

/** Determines the format used when serialising inspector data. */
gchar*
components_inspector_text_format_get_line_separator (ComponentsInspectorTextFormat self)
{
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* result;
	if (self == COMPONENTS_INSPECTOR_TEXT_FORMAT_MARKDOWN) {
		_tmp0_ = "  \n";
	} else {
		_tmp0_ = "\n";
	}
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static GType
components_inspector_text_format_get_type_once (void)
{
	static const GEnumValue values[] = {{COMPONENTS_INSPECTOR_TEXT_FORMAT_PLAIN, "COMPONENTS_INSPECTOR_TEXT_FORMAT_PLAIN", "plain"}, {COMPONENTS_INSPECTOR_TEXT_FORMAT_MARKDOWN, "COMPONENTS_INSPECTOR_TEXT_FORMAT_MARKDOWN", "markdown"}, {0, NULL, NULL}};
	GType components_inspector_text_format_type_id;
	components_inspector_text_format_type_id = g_enum_register_static ("ComponentsInspectorTextFormat", values);
	return components_inspector_text_format_type_id;
}

GType
components_inspector_text_format_get_type (void)
{
	static volatile gsize components_inspector_text_format_type_id__once = 0;
	if (g_once_init_enter (&components_inspector_text_format_type_id__once)) {
		GType components_inspector_text_format_type_id;
		components_inspector_text_format_type_id = components_inspector_text_format_get_type_once ();
		g_once_init_leave (&components_inspector_text_format_type_id__once, components_inspector_text_format_type_id);
	}
	return components_inspector_text_format_type_id__once;
}

static void
_components_inspector_on_copy_clicked_gsimple_action_activate_callback (GSimpleAction* action,
                                                                        GVariant* parameter,
                                                                        gpointer self)
{
	components_inspector_on_copy_clicked ((ComponentsInspector*) self);
}

static void
_components_inspector_on_close_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self)
{
	components_inspector_on_close ((ComponentsInspector*) self);
}

static void
_components_inspector_on_logs_play_toggled_gsimple_action_activate_callback (GSimpleAction* action,
                                                                             GVariant* parameter,
                                                                             gpointer self)
{
	components_inspector_on_logs_play_toggled ((ComponentsInspector*) self, action, parameter);
}

static void
_components_inspector_on_logs_search_toggled_gsimple_action_activate_callback (GSimpleAction* action,
                                                                               GVariant* parameter,
                                                                               gpointer self)
{
	components_inspector_on_logs_search_toggled ((ComponentsInspector*) self, action, parameter);
}

static void
_components_inspector_on_logs_search_activated_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                 GVariant* parameter,
                                                                                 gpointer self)
{
	components_inspector_on_logs_search_activated ((ComponentsInspector*) self);
}

void
components_inspector_add_accelerators (ApplicationClient* app)
{
	gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar* _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	g_return_if_fail (APPLICATION_IS_CLIENT (app));
	_tmp0_ = g_strdup ("Escape");
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = 1;
	application_client_add_window_accelerators (app, COMPONENTS_INSPECTOR_ACTION_CLOSE, _tmp2_, (gint) 1, NULL);
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
	_tmp3_ = g_strdup ("space");
	_tmp4_ = g_new0 (gchar*, 1 + 1);
	_tmp4_[0] = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp5__length1 = 1;
	application_client_add_window_accelerators (app, COMPONENTS_INSPECTOR_ACTION_PLAY_TOGGLE, _tmp5_, (gint) 1, NULL);
	_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_free), NULL);
	_tmp6_ = g_strdup ("<Ctrl>F");
	_tmp7_ = g_new0 (gchar*, 1 + 1);
	_tmp7_[0] = _tmp6_;
	_tmp8_ = _tmp7_;
	_tmp8__length1 = 1;
	application_client_add_window_accelerators (app, COMPONENTS_INSPECTOR_ACTION_SEARCH_ACTIVATE, _tmp8_, (gint) 1, NULL);
	_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_free), NULL);
}

static void
_components_inspector_on_logs_selection_changed_components_inspector_log_view_record_selection_changed (ComponentsInspectorLogView* _sender,
                                                                                                        gpointer self)
{
	components_inspector_on_logs_selection_changed ((ComponentsInspector*) self);
}

ComponentsInspector*
components_inspector_construct (GType object_type,
                                ApplicationClient* application)
{
	ComponentsInspector * self = NULL;
	GtkHeaderBar* _tmp0_;
	GSimpleActionGroup* edit_actions = NULL;
	GSimpleActionGroup* _tmp1_;
	ApplicationConfiguration* _tmp2_;
	ApplicationConfiguration* _tmp3_;
	ComponentsInspectorLogView* _tmp4_;
	ComponentsInspectorLogView* _tmp5_;
	GtkStack* _tmp6_;
	ComponentsInspectorLogView* _tmp7_;
	ComponentsInspectorSystemView* _tmp8_;
	GtkStack* _tmp9_;
	ComponentsInspectorSystemView* _tmp10_;
	ComponentsInspectorLogView* _tmp11_;
	GearyLoggingRecord* _tmp12_;
	GearyLoggingRecord* _tmp13_;
	g_return_val_if_fail (APPLICATION_IS_CLIENT (application), NULL);
	self = (ComponentsInspector*) g_object_new (object_type, "application", application, NULL);
	_tmp0_ = self->priv->header_bar;
	gtk_header_bar_set_title (_tmp0_, _ ("Inspector"));
	gtk_window_set_title (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), _ ("Inspector"));
	_tmp1_ = g_simple_action_group_new ();
	edit_actions = _tmp1_;
	g_action_map_add_action_entries (G_TYPE_CHECK_INSTANCE_CAST (edit_actions, g_action_map_get_type (), GActionMap), COMPONENTS_INSPECTOR_EDIT_ACTIONS, (gint) G_N_ELEMENTS (COMPONENTS_INSPECTOR_EDIT_ACTIONS), self);
	gtk_widget_insert_action_group (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), ACTION_EDIT_GROUP_NAME, G_TYPE_CHECK_INSTANCE_CAST (edit_actions, g_action_group_get_type (), GActionGroup));
	g_action_map_add_action_entries (G_TYPE_CHECK_INSTANCE_CAST (self, g_action_map_get_type (), GActionMap), COMPONENTS_INSPECTOR_WINDOW_ACTIONS, (gint) G_N_ELEMENTS (COMPONENTS_INSPECTOR_WINDOW_ACTIONS), self);
	_tmp2_ = application_client_get_config (application);
	_tmp3_ = _tmp2_;
	_tmp4_ = components_inspector_log_view_new (_tmp3_, NULL);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->log_pane);
	self->priv->log_pane = _tmp4_;
	_tmp5_ = self->priv->log_pane;
	g_signal_connect_object (_tmp5_, "record-selection-changed", (GCallback) _components_inspector_on_logs_selection_changed_components_inspector_log_view_record_selection_changed, self, 0);
	_tmp6_ = self->priv->stack;
	_tmp7_ = self->priv->log_pane;
	gtk_stack_add_titled (_tmp6_, G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget), "log_pane", _ ("Logs"));
	_tmp8_ = components_inspector_system_view_new (application);
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->system_pane);
	self->priv->system_pane = _tmp8_;
	_tmp9_ = self->priv->stack;
	_tmp10_ = self->priv->system_pane;
	gtk_stack_add_titled (_tmp9_, G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget), "system_pane", _ ("System"));
	components_inspector_enable_log_updates (self, TRUE);
	_tmp11_ = self->priv->log_pane;
	_tmp12_ = geary_logging_get_earliest_record ();
	_tmp13_ = _tmp12_;
	components_inspector_log_view_load (_tmp11_, _tmp13_, NULL);
	_geary_logging_record_unref0 (_tmp13_);
	_g_object_unref0 (edit_actions);
	return self;
}

ComponentsInspector*
components_inspector_new (ApplicationClient* application)
{
	return components_inspector_construct (COMPONENTS_TYPE_INSPECTOR, application);
}

static gboolean
components_inspector_real_key_press_event (GtkWidget* base,
                                           GdkEventKey* event)
{
	ComponentsInspector * self;
	gboolean ret = FALSE;
	gboolean _tmp0_ = FALSE;
	ComponentsInspectorLogView* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, COMPONENTS_TYPE_INSPECTOR, ComponentsInspector);
	g_return_val_if_fail (event != NULL, FALSE);
	ret = GDK_EVENT_PROPAGATE;
	_tmp1_ = self->priv->log_pane;
	_tmp2_ = components_inspector_log_view_get_search_mode_enabled (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		_tmp0_ = event->keyval == GDK_KEY_Escape;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkToggleButton* _tmp4_;
		_tmp4_ = self->priv->search_button;
		gtk_toggle_button_set_active (_tmp4_, FALSE);
		ret = GDK_EVENT_STOP;
	}
	if (ret == GDK_EVENT_PROPAGATE) {
		ComponentsInspectorLogView* _tmp6_;
		gboolean _tmp7_;
		gboolean _tmp8_;
		_tmp6_ = self->priv->log_pane;
		_tmp7_ = components_inspector_log_view_get_search_mode_enabled (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp5_ = _tmp8_;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		ComponentsInspectorLogView* _tmp9_;
		_tmp9_ = self->priv->log_pane;
		ret = components_inspector_log_view_handle_key_press (_tmp9_, event);
	}
	if (ret == GDK_EVENT_PROPAGATE) {
		ret = GTK_WIDGET_CLASS (components_inspector_parent_class)->key_press_event (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_window_get_type (), GtkApplicationWindow), gtk_widget_get_type (), GtkWidget), event);
	}
	if (ret == GDK_EVENT_PROPAGATE) {
		ComponentsInspectorLogView* _tmp11_;
		gboolean _tmp12_;
		gboolean _tmp13_;
		_tmp11_ = self->priv->log_pane;
		_tmp12_ = components_inspector_log_view_get_search_mode_enabled (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp10_ = !_tmp13_;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		ComponentsInspectorLogView* _tmp14_;
		_tmp14_ = self->priv->log_pane;
		ret = components_inspector_log_view_handle_key_press (_tmp14_, event);
		if (ret == GDK_EVENT_STOP) {
			GtkToggleButton* _tmp15_;
			_tmp15_ = self->priv->search_button;
			gtk_toggle_button_set_active (_tmp15_, TRUE);
		}
	}
	result = ret;
	return result;
}

static void
components_inspector_enable_log_updates (ComponentsInspector* self,
                                         gboolean enabled)
{
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	ComponentsInspectorLogView* _tmp3_;
	g_return_if_fail (COMPONENTS_IS_INSPECTOR (self));
	if (enabled) {
		_tmp0_ = "▶";
	} else {
		_tmp0_ = "■";
	}
	_tmp1_ = gtk_window_get_title (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow));
	_tmp2_ = _tmp1_;
	g_debug ("components-inspector.vala:134: ---- 8< ---- %s %s ---- 8< ----", _tmp2_, _tmp0_);
	_tmp3_ = self->priv->log_pane;
	components_inspector_log_view_enable_log_updates (_tmp3_, enabled);
}

static void
components_inspector_save_data_free (gpointer _data)
{
	ComponentsInspectorSaveData* _data_;
	_data_ = _data;
	_g_free0 (_data_->path);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (ComponentsInspectorSaveData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
components_inspector_save (ComponentsInspector* self,
                           const gchar* path,
                           GCancellable* cancellable,
                           GAsyncReadyCallback _callback_,
                           gpointer _user_data_)
{
	ComponentsInspectorSaveData* _data_;
	ComponentsInspector* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (COMPONENTS_IS_INSPECTOR (self));
	g_return_if_fail (path != NULL);
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (ComponentsInspectorSaveData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, components_inspector_save_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (path);
	_g_free0 (_data_->path);
	_data_->path = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	components_inspector_save_co (_data_);
}

static void
components_inspector_save_finish (ComponentsInspector* self,
                                  GAsyncResult* _res_,
                                  GError** error)
{
	ComponentsInspectorSaveData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
components_inspector_save_ready (GObject* source_object,
                                 GAsyncResult* _res_,
                                 gpointer _user_data_)
{
	ComponentsInspectorSaveData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	components_inspector_save_co (_data_);
}

static gboolean
components_inspector_save_co (ComponentsInspectorSaveData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_file_new_for_path (_data_->path);
	_data_->dest = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->dest;
	_data_->_state_ = 1;
	g_file_replace_readwrite_async (_data_->_tmp1_, NULL, FALSE, G_FILE_CREATE_NONE, G_PRIORITY_DEFAULT, _data_->cancellable, components_inspector_save_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp2_ = g_file_replace_readwrite_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error0_);
	_data_->dest_io = _data_->_tmp2_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->dest);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = _data_->dest_io;
	_data_->_tmp4_ = g_io_stream_get_output_stream (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp3_, g_io_stream_get_type (), GIOStream));
	_data_->_tmp5_ = (GBufferedOutputStream*) g_buffered_output_stream_new (_data_->_tmp4_);
	_data_->_tmp6_ = _data_->_tmp5_;
	_data_->_tmp7_ = g_data_output_stream_new (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp6_, g_output_stream_get_type (), GOutputStream));
	_data_->_tmp8_ = _data_->_tmp7_;
	_g_object_unref0 (_data_->_tmp6_);
	_data_->out = _data_->_tmp8_;
	_data_->_tmp9_ = _data_->self->priv->system_pane;
	_data_->_tmp10_ = _data_->out;
	components_inspector_system_view_save (_data_->_tmp9_, _data_->_tmp10_, COMPONENTS_INSPECTOR_TEXT_FORMAT_PLAIN, _data_->cancellable, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->out);
		_g_object_unref0 (_data_->dest_io);
		_g_object_unref0 (_data_->dest);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp11_ = _data_->out;
	g_data_output_stream_put_string (_data_->_tmp11_, "\n", NULL, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->out);
		_g_object_unref0 (_data_->dest_io);
		_g_object_unref0 (_data_->dest);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp12_ = _data_->self->priv->log_pane;
	_data_->_tmp13_ = _data_->out;
	components_inspector_log_view_save (_data_->_tmp12_, _data_->_tmp13_, COMPONENTS_INSPECTOR_TEXT_FORMAT_PLAIN, TRUE, _data_->cancellable, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->out);
		_g_object_unref0 (_data_->dest_io);
		_g_object_unref0 (_data_->dest);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp14_ = _data_->out;
	_data_->_state_ = 2;
	g_output_stream_close_async (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp14_, g_output_stream_get_type (), GOutputStream), G_PRIORITY_DEFAULT, NULL, components_inspector_save_ready, _data_);
	return FALSE;
	_state_2:
	g_output_stream_close_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp14_, g_output_stream_get_type (), GOutputStream), _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->out);
		_g_object_unref0 (_data_->dest_io);
		_g_object_unref0 (_data_->dest);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp15_ = _data_->dest_io;
	_data_->_state_ = 3;
	g_io_stream_close_async (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp15_, g_io_stream_get_type (), GIOStream), G_PRIORITY_DEFAULT, NULL, components_inspector_save_ready, _data_);
	return FALSE;
	_state_3:
	g_io_stream_close_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp15_, g_io_stream_get_type (), GIOStream), _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->out);
		_g_object_unref0 (_data_->dest_io);
		_g_object_unref0 (_data_->dest);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->out);
	_g_object_unref0 (_data_->dest_io);
	_g_object_unref0 (_data_->dest);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
components_inspector_update_ui (ComponentsInspector* self)
{
	gboolean logs_visible = FALSE;
	GtkStack* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	ComponentsInspectorLogView* _tmp3_;
	guint logs_selected = 0U;
	ComponentsInspectorLogView* _tmp4_;
	gboolean _tmp5_ = FALSE;
	GtkButton* _tmp6_;
	GtkToggleButton* _tmp7_;
	GtkButton* _tmp8_;
	GtkButton* _tmp9_;
	GtkToggleButton* _tmp10_;
	g_return_if_fail (COMPONENTS_IS_INSPECTOR (self));
	_tmp0_ = self->priv->stack;
	_tmp1_ = gtk_stack_get_visible_child (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->log_pane;
	logs_visible = _tmp2_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget);
	_tmp4_ = self->priv->log_pane;
	logs_selected = (guint) components_inspector_log_view_count_selected_records (_tmp4_);
	if (!logs_visible) {
		_tmp5_ = TRUE;
	} else {
		_tmp5_ = logs_selected > ((guint) 0);
	}
	_tmp6_ = self->priv->copy_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget), _tmp5_);
	_tmp7_ = self->priv->play_button;
	gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget), logs_visible);
	_tmp8_ = self->priv->mark_button;
	gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget), logs_visible);
	_tmp9_ = self->priv->clear_button;
	gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget), logs_visible);
	_tmp10_ = self->priv->search_button;
	gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget), logs_visible);
}

static void
components_inspector_on_visible_child_changed (ComponentsInspector* self)
{
	g_return_if_fail (COMPONENTS_IS_INSPECTOR (self));
	components_inspector_update_ui (self);
}

static void
_components_inspector_on_visible_child_changed_g_object_notify (GObject* _sender,
                                                                GParamSpec* pspec,
                                                                gpointer self)
{
	components_inspector_on_visible_child_changed ((ComponentsInspector*) self);
}

static void
components_inspector_on_mark_clicked (ComponentsInspector* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (COMPONENTS_IS_INSPECTOR (self));
	_tmp0_ = gtk_window_get_title (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow));
	_tmp1_ = _tmp0_;
	g_debug ("components-inspector.vala:183: ---- 8< ---- %s ---- 8< ----", _tmp1_);
}

static void
_components_inspector_on_mark_clicked_gtk_button_clicked (GtkButton* _sender,
                                                          gpointer self)
{
	components_inspector_on_mark_clicked ((ComponentsInspector*) self);
}

static void
components_inspector_on_clear_clicked (ComponentsInspector* self)
{
	ComponentsInspectorLogView* _tmp0_;
	g_return_if_fail (COMPONENTS_IS_INSPECTOR (self));
	_tmp0_ = self->priv->log_pane;
	components_inspector_log_view_clear (_tmp0_);
}

static void
_components_inspector_on_clear_clicked_gtk_button_clicked (GtkButton* _sender,
                                                           gpointer self)
{
	components_inspector_on_clear_clicked ((ComponentsInspector*) self);
}

static void
components_inspector_on_copy_clicked (ComponentsInspector* self)
{
	GMemoryOutputStream* bytes = NULL;
	GMemoryOutputStream* _tmp0_;
	GDataOutputStream* out = NULL;
	GMemoryOutputStream* _tmp1_;
	GDataOutputStream* _tmp2_;
	gchar* clipboard_value = NULL;
	GMemoryOutputStream* _tmp18_;
	guint8* _tmp19_;
	gchar* _tmp20_;
	const gchar* _tmp21_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (COMPONENTS_IS_INSPECTOR (self));
	_tmp0_ = (GMemoryOutputStream*) g_memory_output_stream_new_resizable ();
	bytes = _tmp0_;
	_tmp1_ = bytes;
	_tmp2_ = g_data_output_stream_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_output_stream_get_type (), GOutputStream));
	out = _tmp2_;
	{
		GtkStack* _tmp3_;
		GtkWidget* _tmp4_;
		GtkWidget* _tmp5_;
		ComponentsInspectorLogView* _tmp6_;
		GDataOutputStream* _tmp15_;
		_tmp3_ = self->priv->stack;
		_tmp4_ = gtk_stack_get_visible_child (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = self->priv->log_pane;
		if (_tmp5_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget)) {
			ComponentsInspectorLogView* _tmp7_;
			GDataOutputStream* _tmp8_;
			_tmp7_ = self->priv->log_pane;
			_tmp8_ = out;
			components_inspector_log_view_save (_tmp7_, _tmp8_, COMPONENTS_INSPECTOR_TEXT_FORMAT_MARKDOWN, FALSE, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		} else {
			GtkStack* _tmp9_;
			GtkWidget* _tmp10_;
			GtkWidget* _tmp11_;
			ComponentsInspectorSystemView* _tmp12_;
			_tmp9_ = self->priv->stack;
			_tmp10_ = gtk_stack_get_visible_child (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = self->priv->system_pane;
			if (_tmp11_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_widget_get_type (), GtkWidget)) {
				ComponentsInspectorSystemView* _tmp13_;
				GDataOutputStream* _tmp14_;
				_tmp13_ = self->priv->system_pane;
				_tmp14_ = out;
				components_inspector_system_view_save (_tmp13_, _tmp14_, COMPONENTS_INSPECTOR_TEXT_FORMAT_MARKDOWN, NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
			}
		}
		_tmp15_ = out;
		g_data_output_stream_put_byte (_tmp15_, (guint8) 0, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp16_;
		const gchar* _tmp17_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp16_ = err;
		_tmp17_ = _tmp16_->message;
		g_warning ("components-inspector.vala:204: Error saving inspector data for clipboa" \
"rd: %s", _tmp17_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (out);
		_g_object_unref0 (bytes);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp18_ = bytes;
	_tmp19_ = g_memory_output_stream_get_data (_tmp18_);
	_tmp20_ = g_strdup ((const gchar*) _tmp19_);
	clipboard_value = _tmp20_;
	_tmp21_ = clipboard_value;
	if (!geary_string_is_empty (_tmp21_)) {
		GtkClipboard* _tmp22_;
		const gchar* _tmp23_;
		_tmp22_ = gtk_widget_get_clipboard (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), GDK_SELECTION_CLIPBOARD);
		_tmp23_ = clipboard_value;
		gtk_clipboard_set_text (_tmp22_, _tmp23_, -1);
	}
	_g_free0 (clipboard_value);
	_g_object_unref0 (out);
	_g_object_unref0 (bytes);
}

static void
___lambda70_ (ComponentsInspector* self,
              GObject* obj,
              GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail ((obj == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (obj, G_TYPE_OBJECT));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (res, g_async_result_get_type ()));
	{
		components_inspector_save_finish (self, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = err;
		_tmp1_ = _tmp0_->message;
		g_warning ("components-inspector.vala:237: Failed to save inspector data: %s", _tmp1_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda70__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	___lambda70_ ((ComponentsInspector*) self, source_object, res);
	g_object_unref (self);
}

static void
components_inspector_on_save_as_clicked (ComponentsInspector* self)
{
	GtkFileChooserNative* chooser = NULL;
	GtkFileChooserNative* _tmp0_;
	GtkFileChooserNative* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GtkFileChooserNative* _tmp6_;
	g_return_if_fail (COMPONENTS_IS_INSPECTOR (self));
	_tmp0_ = gtk_file_chooser_native_new (_ ("Save As"), G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), GTK_FILE_CHOOSER_ACTION_SAVE, _ ("Save As"), _ ("Cancel"));
	chooser = _tmp0_;
	_tmp1_ = chooser;
	_tmp2_ = g_date_time_new_now_local ();
	_tmp3_ = _tmp2_;
	_tmp4_ = g_date_time_format (_tmp3_, "Geary Inspector - %F %T.txt");
	_tmp5_ = _tmp4_;
	gtk_file_chooser_set_current_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_file_chooser_get_type (), GtkFileChooser), _tmp5_);
	_g_free0 (_tmp5_);
	_g_date_time_unref0 (_tmp3_);
	_tmp6_ = chooser;
	if (gtk_native_dialog_run (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_native_dialog_get_type (), GtkNativeDialog)) == ((gint) GTK_RESPONSE_ACCEPT)) {
		GtkFileChooserNative* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp7_ = chooser;
		_tmp8_ = gtk_file_chooser_get_filename (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_file_chooser_get_type (), GtkFileChooser));
		_tmp9_ = _tmp8_;
		components_inspector_save (self, _tmp9_, NULL, ____lambda70__gasync_ready_callback, g_object_ref (self));
		_g_free0 (_tmp9_);
	}
	_g_object_unref0 (chooser);
}

static void
_components_inspector_on_save_as_clicked_gtk_button_clicked (GtkButton* _sender,
                                                             gpointer self)
{
	components_inspector_on_save_as_clicked ((ComponentsInspector*) self);
}

static void
components_inspector_on_logs_selection_changed (ComponentsInspector* self)
{
	g_return_if_fail (COMPONENTS_IS_INSPECTOR (self));
	components_inspector_update_ui (self);
}

static gboolean
_variant_get6 (GVariant* value)
{
	return g_variant_get_boolean (value);
}

static GVariant*
_variant_new5 (gboolean value)
{
	return g_variant_ref_sink (g_variant_new_boolean (value));
}

static void
components_inspector_on_logs_search_toggled (ComponentsInspector* self,
                                             GSimpleAction* action,
                                             GVariant* param)
{
	gboolean enabled = FALSE;
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	ComponentsInspectorLogView* _tmp5_;
	GVariant* _tmp6_;
	g_return_if_fail (COMPONENTS_IS_INSPECTOR (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (action, g_simple_action_get_type ()));
	_tmp0_ = g_action_get_state (G_TYPE_CHECK_INSTANCE_CAST (action, g_action_get_type (), GAction));
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = _variant_get6 (_tmp2_);
	_tmp4_ = !_tmp3_;
	_g_variant_unref0 (_tmp2_);
	enabled = _tmp4_;
	_tmp5_ = self->priv->log_pane;
	components_inspector_log_view_set_search_mode_enabled (_tmp5_, enabled);
	_tmp6_ = _variant_new5 (enabled);
	g_simple_action_set_state (action, _tmp6_);
	_g_variant_unref0 (_tmp6_);
}

static void
components_inspector_on_logs_search_activated (ComponentsInspector* self)
{
	GtkToggleButton* _tmp0_;
	g_return_if_fail (COMPONENTS_IS_INSPECTOR (self));
	_tmp0_ = self->priv->search_button;
	gtk_toggle_button_set_active (_tmp0_, TRUE);
}

static gboolean
_variant_get7 (GVariant* value)
{
	return g_variant_get_boolean (value);
}

static GVariant*
_variant_new6 (gboolean value)
{
	return g_variant_ref_sink (g_variant_new_boolean (value));
}

static void
components_inspector_on_logs_play_toggled (ComponentsInspector* self,
                                           GSimpleAction* action,
                                           GVariant* param)
{
	gboolean enabled = FALSE;
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GVariant* _tmp5_;
	g_return_if_fail (COMPONENTS_IS_INSPECTOR (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (action, g_simple_action_get_type ()));
	_tmp0_ = g_action_get_state (G_TYPE_CHECK_INSTANCE_CAST (action, g_action_get_type (), GAction));
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = _variant_get7 (_tmp2_);
	_tmp4_ = !_tmp3_;
	_g_variant_unref0 (_tmp2_);
	enabled = _tmp4_;
	components_inspector_enable_log_updates (self, enabled);
	_tmp5_ = _variant_new6 (enabled);
	g_simple_action_set_state (action, _tmp5_);
	_g_variant_unref0 (_tmp5_);
}

static void
components_inspector_on_close (ComponentsInspector* self)
{
	g_return_if_fail (COMPONENTS_IS_INSPECTOR (self));
	gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
}

static void
components_inspector_class_init (ComponentsInspectorClass * klass,
                                 gpointer klass_data)
{
	components_inspector_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ComponentsInspector_private_offset);
	((GtkWidgetClass *) klass)->key_press_event = (gboolean (*) (GtkWidget*, GdkEventKey*)) components_inspector_real_key_press_event;
	G_OBJECT_CLASS (klass)->finalize = components_inspector_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Geary/components-inspector.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "header_bar", FALSE, ComponentsInspector_private_offset + G_STRUCT_OFFSET (ComponentsInspectorPrivate, header_bar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stack", FALSE, ComponentsInspector_private_offset + G_STRUCT_OFFSET (ComponentsInspectorPrivate, stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "copy_button", FALSE, ComponentsInspector_private_offset + G_STRUCT_OFFSET (ComponentsInspectorPrivate, copy_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "play_button", FALSE, ComponentsInspector_private_offset + G_STRUCT_OFFSET (ComponentsInspectorPrivate, play_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "mark_button", FALSE, ComponentsInspector_private_offset + G_STRUCT_OFFSET (ComponentsInspectorPrivate, mark_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "search_button", FALSE, ComponentsInspector_private_offset + G_STRUCT_OFFSET (ComponentsInspectorPrivate, search_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "clear_button", FALSE, ComponentsInspector_private_offset + G_STRUCT_OFFSET (ComponentsInspectorPrivate, clear_button));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_visible_child_changed", G_CALLBACK(_components_inspector_on_visible_child_changed_g_object_notify));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_mark_clicked", G_CALLBACK(_components_inspector_on_mark_clicked_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_clear_clicked", G_CALLBACK(_components_inspector_on_clear_clicked_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_save_as_clicked", G_CALLBACK(_components_inspector_on_save_as_clicked_gtk_button_clicked));
}

static void
components_inspector_instance_init (ComponentsInspector * self,
                                    gpointer klass)
{
	self->priv = components_inspector_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
components_inspector_finalize (GObject * obj)
{
	ComponentsInspector * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, COMPONENTS_TYPE_INSPECTOR, ComponentsInspector);
	_g_object_unref0 (self->priv->log_pane);
	_g_object_unref0 (self->priv->system_pane);
	G_OBJECT_CLASS (components_inspector_parent_class)->finalize (obj);
}

/**
 * A window that displays debugging and development information.
 */
static GType
components_inspector_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ComponentsInspectorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) components_inspector_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ComponentsInspector), 0, (GInstanceInitFunc) components_inspector_instance_init, NULL };
	GType components_inspector_type_id;
	components_inspector_type_id = g_type_register_static (gtk_application_window_get_type (), "ComponentsInspector", &g_define_type_info, 0);
	ComponentsInspector_private_offset = g_type_add_instance_private (components_inspector_type_id, sizeof (ComponentsInspectorPrivate));
	return components_inspector_type_id;
}

GType
components_inspector_get_type (void)
{
	static volatile gsize components_inspector_type_id__once = 0;
	if (g_once_init_enter (&components_inspector_type_id__once)) {
		GType components_inspector_type_id;
		components_inspector_type_id = components_inspector_get_type_once ();
		g_once_init_leave (&components_inspector_type_id__once, components_inspector_type_id);
	}
	return components_inspector_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

