/* components-validator.c generated by valac 0.56.3, the Vala compiler
 * generated from components-validator.vala, do not modify */

/*
 * Copyright 2018 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-client-43.0.h"
#include <gtk/gtk.h>
#include <glib.h>
#include "geary-engine.h"
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>

#define COMPONENTS_VALIDATOR_ICON_POS GTK_ENTRY_ICON_SECONDARY

enum  {
	COMPONENTS_VALIDATOR_0_PROPERTY,
	COMPONENTS_VALIDATOR_TARGET_PROPERTY,
	COMPONENTS_VALIDATOR_IS_VALID_PROPERTY,
	COMPONENTS_VALIDATOR_IS_REQUIRED_PROPERTY,
	COMPONENTS_VALIDATOR_STATE_PROPERTY,
	COMPONENTS_VALIDATOR_NUM_PROPERTIES
};
static GParamSpec* components_validator_properties[COMPONENTS_VALIDATOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	COMPONENTS_VALIDATOR_STATE_CHANGED_SIGNAL,
	COMPONENTS_VALIDATOR_CHANGED_SIGNAL,
	COMPONENTS_VALIDATOR_ACTIVATED_SIGNAL,
	COMPONENTS_VALIDATOR_FOCUS_LOST_SIGNAL,
	COMPONENTS_VALIDATOR_NUM_SIGNALS
};
static guint components_validator_signals[COMPONENTS_VALIDATOR_NUM_SIGNALS] = {0};
enum  {
	COMPONENTS_EMAIL_VALIDATOR_0_PROPERTY,
	COMPONENTS_EMAIL_VALIDATOR_NUM_PROPERTIES
};
static GParamSpec* components_email_validator_properties[COMPONENTS_EMAIL_VALIDATOR_NUM_PROPERTIES];
enum  {
	COMPONENTS_NETWORK_ADDRESS_VALIDATOR_0_PROPERTY,
	COMPONENTS_NETWORK_ADDRESS_VALIDATOR_VALIDATED_ADDRESS_PROPERTY,
	COMPONENTS_NETWORK_ADDRESS_VALIDATOR_DEFAULT_PORT_PROPERTY,
	COMPONENTS_NETWORK_ADDRESS_VALIDATOR_NUM_PROPERTIES
};
static GParamSpec* components_network_address_validator_properties[COMPONENTS_NETWORK_ADDRESS_VALIDATOR_NUM_PROPERTIES];
typedef struct _Block60Data Block60Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _ComponentsValidatorPrivate {
	GtkEntry* _target;
	gboolean _is_required;
	ComponentsValidatorValidity _state;
	gboolean target_changed;
	GearyTimeoutManager* ui_update_timer;
	GearyTimeoutManager* pulse_timer;
	gboolean did_pulse;
};

struct _ComponentsNetworkAddressValidatorPrivate {
	GNetworkAddress* _validated_address;
	guint16 _default_port;
	GResolver* resolver;
	GCancellable* cancellable;
};

struct _Block60Data {
	int _ref_count_;
	ComponentsNetworkAddressValidator* self;
	GNetworkAddress* address;
	ComponentsValidatorTrigger reason;
};

static gint ComponentsValidator_private_offset;
static gpointer components_validator_parent_class = NULL;
static gpointer components_email_validator_parent_class = NULL;
static gint ComponentsNetworkAddressValidator_private_offset;
static gpointer components_network_address_validator_parent_class = NULL;

static gboolean components_validator_on_focus_out (ComponentsValidator* self);
static gboolean _components_validator_on_focus_out_gtk_widget_focus_out_event (GtkWidget* _sender,
                                                                        GdkEventFocus* event,
                                                                        gpointer self);
static void components_validator_on_changed (ComponentsValidator* self);
static void _components_validator_on_changed_gtk_editable_changed (GtkEditable* _sender,
                                                            gpointer self);
static void components_validator_on_activate (ComponentsValidator* self);
static void _components_validator_on_activate_gtk_entry_activate (GtkEntry* _sender,
                                                           gpointer self);
static void components_validator_set_target (ComponentsValidator* self,
                                      GtkEntry* value);
static void components_validator_set_state (ComponentsValidator* self,
                                     ComponentsValidatorValidity value);
static void g_cclosure_user_marshal_VOID__ENUM_ENUM (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data);
static void components_validator_on_update_ui (ComponentsValidator* self);
static void _components_validator_on_update_ui_geary_timeout_manager_timeout_func (GearyTimeoutManager* manager,
                                                                            gpointer self);
static void components_validator_on_pulse (ComponentsValidator* self);
static void _components_validator_on_pulse_geary_timeout_manager_timeout_func (GearyTimeoutManager* manager,
                                                                        gpointer self);
static void components_validator_validate_entry (ComponentsValidator* self,
                                          ComponentsValidatorTrigger reason);
static ComponentsValidatorValidity components_validator_real_do_validate (ComponentsValidator* self,
                                                                   const gchar* value,
                                                                   ComponentsValidatorTrigger reason);
static void components_validator_update_ui (ComponentsValidator* self,
                                     ComponentsValidatorValidity state);
static void components_validator_finalize (GObject * obj);
static GType components_validator_get_type_once (void);
static void _vala_components_validator_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_components_validator_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);
static ComponentsValidatorValidity components_email_validator_real_do_validate (ComponentsValidator* base,
                                                                         const gchar* value,
                                                                         ComponentsValidatorTrigger reason);
static GType components_email_validator_get_type_once (void);
static void components_network_address_validator_set_validated_address (ComponentsNetworkAddressValidator* self,
                                                                 GNetworkAddress* value);
static void components_network_address_validator_set_default_port (ComponentsNetworkAddressValidator* self,
                                                            guint16 value);
static ComponentsValidatorValidity components_network_address_validator_real_do_validate (ComponentsValidator* base,
                                                                                   const gchar* value,
                                                                                   ComponentsValidatorTrigger reason);
static Block60Data* block60_data_ref (Block60Data* _data60_);
static void block60_data_unref (void * _userdata_);
static void ____lambda90_ (Block60Data* _data60_,
                    GObject* obj,
                    GAsyncResult* res);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void _____lambda90__gasync_ready_callback (GObject* source_object,
                                           GAsyncResult* res,
                                           gpointer self);
static void components_network_address_validator_finalize (GObject * obj);
static GType components_network_address_validator_get_type_once (void);
static void _vala_components_network_address_validator_get_property (GObject * object,
                                                              guint property_id,
                                                              GValue * value,
                                                              GParamSpec * pspec);
static void _vala_components_network_address_validator_set_property (GObject * object,
                                                              guint property_id,
                                                              const GValue * value,
                                                              GParamSpec * pspec);

static inline gpointer
components_validator_get_instance_private (ComponentsValidator* self)
{
	return G_STRUCT_MEMBER_P (self, ComponentsValidator_private_offset);
}

static gboolean
_components_validator_on_focus_out_gtk_widget_focus_out_event (GtkWidget* _sender,
                                                               GdkEventFocus* event,
                                                               gpointer self)
{
	gboolean result;
	result = components_validator_on_focus_out ((ComponentsValidator*) self);
	return result;
}

static void
_components_validator_on_changed_gtk_editable_changed (GtkEditable* _sender,
                                                       gpointer self)
{
	components_validator_on_changed ((ComponentsValidator*) self);
}

static void
_components_validator_on_activate_gtk_entry_activate (GtkEntry* _sender,
                                                      gpointer self)
{
	components_validator_on_activate ((ComponentsValidator*) self);
}

/**
     * The state of the entry monitored by this validator.
     *
     * Only {@link VALID} can be considered strictly valid, all other
     * states should be treated as being invalid.
     */
static GType
components_validator_validity_get_type_once (void)
{
	static const GEnumValue values[] = {{COMPONENTS_VALIDATOR_VALIDITY_INDETERMINATE, "COMPONENTS_VALIDATOR_VALIDITY_INDETERMINATE", "indeterminate"}, {COMPONENTS_VALIDATOR_VALIDITY_VALID, "COMPONENTS_VALIDATOR_VALIDITY_VALID", "valid"}, {COMPONENTS_VALIDATOR_VALIDITY_IN_PROGRESS, "COMPONENTS_VALIDATOR_VALIDITY_IN_PROGRESS", "in-progress"}, {COMPONENTS_VALIDATOR_VALIDITY_EMPTY, "COMPONENTS_VALIDATOR_VALIDITY_EMPTY", "empty"}, {COMPONENTS_VALIDATOR_VALIDITY_INVALID, "COMPONENTS_VALIDATOR_VALIDITY_INVALID", "invalid"}, {0, NULL, NULL}};
	GType components_validator_validity_type_id;
	components_validator_validity_type_id = g_enum_register_static ("ComponentsValidatorValidity", values);
	return components_validator_validity_type_id;
}

GType
components_validator_validity_get_type (void)
{
	static volatile gsize components_validator_validity_type_id__once = 0;
	if (g_once_init_enter (&components_validator_validity_type_id__once)) {
		GType components_validator_validity_type_id;
		components_validator_validity_type_id = components_validator_validity_get_type_once ();
		g_once_init_leave (&components_validator_validity_type_id__once, components_validator_validity_type_id);
	}
	return components_validator_validity_type_id__once;
}

/** The cause of a validity check being required. */
static GType
components_validator_trigger_get_type_once (void)
{
	static const GEnumValue values[] = {{COMPONENTS_VALIDATOR_TRIGGER_MANUAL, "COMPONENTS_VALIDATOR_TRIGGER_MANUAL", "manual"}, {COMPONENTS_VALIDATOR_TRIGGER_CHANGED, "COMPONENTS_VALIDATOR_TRIGGER_CHANGED", "changed"}, {COMPONENTS_VALIDATOR_TRIGGER_LOST_FOCUS, "COMPONENTS_VALIDATOR_TRIGGER_LOST_FOCUS", "lost-focus"}, {COMPONENTS_VALIDATOR_TRIGGER_ACTIVATED, "COMPONENTS_VALIDATOR_TRIGGER_ACTIVATED", "activated"}, {0, NULL, NULL}};
	GType components_validator_trigger_type_id;
	components_validator_trigger_type_id = g_enum_register_static ("ComponentsValidatorTrigger", values);
	return components_validator_trigger_type_id;
}

GType
components_validator_trigger_get_type (void)
{
	static volatile gsize components_validator_trigger_type_id__once = 0;
	if (g_once_init_enter (&components_validator_trigger_type_id__once)) {
		GType components_validator_trigger_type_id;
		components_validator_trigger_type_id = components_validator_trigger_get_type_once ();
		g_once_init_leave (&components_validator_trigger_type_id__once, components_validator_trigger_type_id);
	}
	return components_validator_trigger_type_id__once;
}

GtkEntry*
components_validator_get_target (ComponentsValidator* self)
{
	GtkEntry* result;
	GtkEntry* _tmp0_;
	g_return_val_if_fail (COMPONENTS_IS_VALIDATOR (self), NULL);
	_tmp0_ = self->priv->_target;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
components_validator_set_target (ComponentsValidator* self,
                                 GtkEntry* value)
{
	GtkEntry* old_value;
	g_return_if_fail (COMPONENTS_IS_VALIDATOR (self));
	old_value = components_validator_get_target (self);
	if (old_value != value) {
		GtkEntry* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_target);
		self->priv->_target = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, components_validator_properties[COMPONENTS_VALIDATOR_TARGET_PROPERTY]);
	}
}

gboolean
components_validator_get_is_valid (ComponentsValidator* self)
{
	gboolean result;
	ComponentsValidatorValidity _tmp0_;
	g_return_val_if_fail (COMPONENTS_IS_VALIDATOR (self), FALSE);
	_tmp0_ = self->priv->_state;
	result = _tmp0_ == COMPONENTS_VALIDATOR_VALIDITY_VALID;
	return result;
}

gboolean
components_validator_get_is_required (ComponentsValidator* self)
{
	gboolean result;
	g_return_val_if_fail (COMPONENTS_IS_VALIDATOR (self), FALSE);
	result = self->priv->_is_required;
	return result;
}

void
components_validator_set_is_required (ComponentsValidator* self,
                                      gboolean value)
{
	gboolean old_value;
	g_return_if_fail (COMPONENTS_IS_VALIDATOR (self));
	old_value = components_validator_get_is_required (self);
	if (old_value != value) {
		self->priv->_is_required = value;
		g_object_notify_by_pspec ((GObject *) self, components_validator_properties[COMPONENTS_VALIDATOR_IS_REQUIRED_PROPERTY]);
	}
}

ComponentsValidatorValidity
components_validator_get_state (ComponentsValidator* self)
{
	ComponentsValidatorValidity result;
	g_return_val_if_fail (COMPONENTS_IS_VALIDATOR (self), 0);
	result = self->priv->_state;
	return result;
}

static void
components_validator_set_state (ComponentsValidator* self,
                                ComponentsValidatorValidity value)
{
	ComponentsValidatorValidity old_value;
	g_return_if_fail (COMPONENTS_IS_VALIDATOR (self));
	old_value = components_validator_get_state (self);
	if (old_value != value) {
		self->priv->_state = value;
		g_object_notify_by_pspec ((GObject *) self, components_validator_properties[COMPONENTS_VALIDATOR_STATE_PROPERTY]);
	}
}

static void
g_cclosure_user_marshal_VOID__ENUM_ENUM (GClosure * closure,
                                         GValue * return_value,
                                         guint n_param_values,
                                         const GValue * param_values,
                                         gpointer invocation_hint,
                                         gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__ENUM_ENUM) (gpointer data1, gint arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__ENUM_ENUM callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__ENUM_ENUM) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_enum (param_values + 1), g_value_get_enum (param_values + 2), data2);
}

static void
_components_validator_on_update_ui_geary_timeout_manager_timeout_func (GearyTimeoutManager* manager,
                                                                       gpointer self)
{
	components_validator_on_update_ui ((ComponentsValidator*) self);
}

static void
_components_validator_on_pulse_geary_timeout_manager_timeout_func (GearyTimeoutManager* manager,
                                                                   gpointer self)
{
	components_validator_on_pulse ((ComponentsValidator*) self);
}

ComponentsValidator*
components_validator_construct (GType object_type,
                                GtkEntry* target)
{
	ComponentsValidator * self = NULL;
	GearyTimeoutManager* _tmp0_;
	GearyTimeoutManager* _tmp1_;
	GearyTimeoutManager* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	ComponentsValidatorUiState _tmp6_ = {0};
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	ComponentsValidatorUiState _tmp10_ = {0};
	const gchar* _tmp11_;
	gchar* _tmp12_;
	ComponentsValidatorUiState _tmp13_ = {0};
	gchar* _tmp14_;
	ComponentsValidatorUiState _tmp15_ = {0};
	gchar* _tmp16_;
	ComponentsValidatorUiState _tmp17_ = {0};
	GtkEntry* _tmp18_;
	GtkEntry* _tmp19_;
	GtkEntry* _tmp20_;
	GtkEntry* _tmp21_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (target, gtk_entry_get_type ()), NULL);
	self = (ComponentsValidator*) g_object_new (object_type, NULL);
	components_validator_set_target (self, target);
	_tmp0_ = geary_timeout_manager_new_seconds ((guint) 2, _components_validator_on_update_ui_geary_timeout_manager_timeout_func, self);
	_g_object_unref0 (self->priv->ui_update_timer);
	self->priv->ui_update_timer = _tmp0_;
	_tmp1_ = geary_timeout_manager_new_milliseconds ((guint) 200, _components_validator_on_pulse_geary_timeout_manager_timeout_func, self);
	_g_object_unref0 (self->priv->pulse_timer);
	self->priv->pulse_timer = _tmp1_;
	_tmp2_ = self->priv->pulse_timer;
	_tmp2_->repetition = GEARY_TIMEOUT_MANAGER_REPEAT_FOREVER;
	_tmp3_ = gtk_entry_get_icon_name (target, COMPONENTS_VALIDATOR_ICON_POS);
	_tmp4_ = g_strdup (_tmp3_);
	_tmp5_ = gtk_entry_get_icon_tooltip_text (target, COMPONENTS_VALIDATOR_ICON_POS);
	_g_free0 (_tmp6_.icon_name);
	_tmp6_.icon_name = _tmp4_;
	_g_free0 (_tmp6_.icon_tooltip_text);
	_tmp6_.icon_tooltip_text = _tmp5_;
	components_validator_ui_state_destroy (&self->indeterminate_state);
	self->indeterminate_state = _tmp6_;
	_tmp7_ = gtk_entry_get_icon_name (target, COMPONENTS_VALIDATOR_ICON_POS);
	_tmp8_ = g_strdup (_tmp7_);
	_tmp9_ = gtk_entry_get_icon_tooltip_text (target, COMPONENTS_VALIDATOR_ICON_POS);
	_g_free0 (_tmp10_.icon_name);
	_tmp10_.icon_name = _tmp8_;
	_g_free0 (_tmp10_.icon_tooltip_text);
	_tmp10_.icon_tooltip_text = _tmp9_;
	components_validator_ui_state_destroy (&self->valid_state);
	self->valid_state = _tmp10_;
	_tmp11_ = gtk_entry_get_icon_name (target, COMPONENTS_VALIDATOR_ICON_POS);
	_tmp12_ = g_strdup (_tmp11_);
	_g_free0 (_tmp13_.icon_name);
	_tmp13_.icon_name = _tmp12_;
	_g_free0 (_tmp13_.icon_tooltip_text);
	_tmp13_.icon_tooltip_text = NULL;
	components_validator_ui_state_destroy (&self->in_progress_state);
	self->in_progress_state = _tmp13_;
	_tmp14_ = g_strdup ("dialog-warning-symbolic");
	_g_free0 (_tmp15_.icon_name);
	_tmp15_.icon_name = _tmp14_;
	_g_free0 (_tmp15_.icon_tooltip_text);
	_tmp15_.icon_tooltip_text = NULL;
	components_validator_ui_state_destroy (&self->empty_state);
	self->empty_state = _tmp15_;
	_tmp16_ = g_strdup ("dialog-error-symbolic");
	_g_free0 (_tmp17_.icon_name);
	_tmp17_.icon_name = _tmp16_;
	_g_free0 (_tmp17_.icon_tooltip_text);
	_tmp17_.icon_tooltip_text = NULL;
	components_validator_ui_state_destroy (&self->invalid_state);
	self->invalid_state = _tmp17_;
	_tmp18_ = self->priv->_target;
	gtk_widget_add_events (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_widget_get_type (), GtkWidget), (gint) GDK_FOCUS_CHANGE_MASK);
	_tmp19_ = self->priv->_target;
	g_signal_connect_object (_tmp19_, "activate", (GCallback) _components_validator_on_activate_gtk_entry_activate, self, 0);
	_tmp20_ = self->priv->_target;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_editable_get_type (), GtkEditable), "changed", (GCallback) _components_validator_on_changed_gtk_editable_changed, self, 0);
	_tmp21_ = self->priv->_target;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_widget_get_type (), GtkWidget), "focus-out-event", (GCallback) _components_validator_on_focus_out_gtk_widget_focus_out_event, self, 0);
	return self;
}

ComponentsValidator*
components_validator_new (GtkEntry* target)
{
	return components_validator_construct (COMPONENTS_TYPE_VALIDATOR, target);
}

/**
     * Triggers a validation of the entry.
     *
     * In the case of an asynchronous validation implementations,
     * result of the validation will be known sometime after this call
     * has completed.
     */
void
components_validator_validate (ComponentsValidator* self)
{
	g_return_if_fail (COMPONENTS_IS_VALIDATOR (self));
	components_validator_validate_entry (self, COMPONENTS_VALIDATOR_TRIGGER_MANUAL);
}

/**
     * Called to validate the target entry's value.
     *
     * This method will be called repeatedly as the user edits the
     * value of the target entry to set the new validation {@link
     * state} given the updated value. It will *not* be called if the
     * entry is changed to be empty, instead the validity state will
     * be set based on {@link is_required}.
     *
     * Subclasses may override this method to implement custom
     * validation routines. Since this call is made repeatedly as the
     * user is typing, it should not perform a CPU-intensive or
     * long-running routine. Subclasses that do perform such
     * validation should launch the routine in the background (either
     * asynchronously or in a thread) and return {@link
     * Validity.IN_PROGRESS} as soon as possible. Then, when it is
     * complete, call {@link update_state} to update the validity state
     * with the actual result.
     *
     * The given reason specifies which user action was taken to cause
     * the entry's value to be validated.
     *
     * By default, this always returns {@link Validity.VALID}, making
     * it useful for required, but otherwise free-form fields only.
     */
static ComponentsValidatorValidity
components_validator_real_do_validate (ComponentsValidator* self,
                                       const gchar* value,
                                       ComponentsValidatorTrigger reason)
{
	ComponentsValidatorValidity result;
	g_return_val_if_fail (value != NULL, 0);
	result = COMPONENTS_VALIDATOR_VALIDITY_VALID;
	return result;
}

ComponentsValidatorValidity
components_validator_do_validate (ComponentsValidator* self,
                                  const gchar* value,
                                  ComponentsValidatorTrigger reason)
{
	ComponentsValidatorClass* _klass_;
	g_return_val_if_fail (COMPONENTS_IS_VALIDATOR (self), 0);
	_klass_ = COMPONENTS_VALIDATOR_GET_CLASS (self);
	if (_klass_->do_validate) {
		return _klass_->do_validate (self, value, reason);
	}
	return 0;
}

/**
     * Updates the current validation state and the entry's UI.
     *
     * This should only be called by subclasses that implement a
     * CPU-intensive or long-running validation routine and it has
     * completed validating a value. See {@link validate} for details.
     */
void
components_validator_update_state (ComponentsValidator* self,
                                   ComponentsValidatorValidity new_state,
                                   ComponentsValidatorTrigger reason)
{
	ComponentsValidatorValidity _tmp0_;
	g_return_if_fail (COMPONENTS_IS_VALIDATOR (self));
	_tmp0_ = self->priv->_state;
	if (_tmp0_ != new_state) {
		ComponentsValidatorValidity old_state = 0;
		ComponentsValidatorValidity _tmp1_;
		gboolean _tmp2_ = FALSE;
		_tmp1_ = self->priv->_state;
		old_state = _tmp1_;
		components_validator_set_state (self, new_state);
		g_object_notify (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), "is-valid");
		g_signal_emit (self, components_validator_signals[COMPONENTS_VALIDATOR_STATE_CHANGED_SIGNAL], 0, reason, old_state);
		if (new_state == COMPONENTS_VALIDATOR_VALIDITY_VALID) {
			_tmp2_ = TRUE;
		} else {
			_tmp2_ = reason != COMPONENTS_VALIDATOR_TRIGGER_CHANGED;
		}
		if (_tmp2_) {
			components_validator_update_ui (self, new_state);
		} else {
			GearyTimeoutManager* _tmp3_;
			if (old_state == COMPONENTS_VALIDATOR_VALIDITY_EMPTY) {
				components_validator_update_ui (self, COMPONENTS_VALIDATOR_VALIDITY_INDETERMINATE);
			}
			_tmp3_ = self->priv->ui_update_timer;
			geary_timeout_manager_start (_tmp3_);
		}
	}
	if (new_state != COMPONENTS_VALIDATOR_VALIDITY_IN_PROGRESS) {
		self->priv->target_changed = FALSE;
		switch (reason) {
			case COMPONENTS_VALIDATOR_TRIGGER_CHANGED:
			{
				g_signal_emit (self, components_validator_signals[COMPONENTS_VALIDATOR_CHANGED_SIGNAL], 0);
				break;
			}
			case COMPONENTS_VALIDATOR_TRIGGER_ACTIVATED:
			{
				g_signal_emit (self, components_validator_signals[COMPONENTS_VALIDATOR_ACTIVATED_SIGNAL], 0);
				break;
			}
			case COMPONENTS_VALIDATOR_TRIGGER_LOST_FOCUS:
			{
				g_signal_emit (self, components_validator_signals[COMPONENTS_VALIDATOR_FOCUS_LOST_SIGNAL], 0);
				break;
			}
			case COMPONENTS_VALIDATOR_TRIGGER_MANUAL:
			{
				break;
			}
			default:
			break;
		}
	} else {
		GearyTimeoutManager* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp4_ = self->priv->pulse_timer;
		_tmp5_ = geary_timeout_manager_get_is_running (_tmp4_);
		_tmp6_ = _tmp5_;
		if (!_tmp6_) {
			GearyTimeoutManager* _tmp7_;
			_tmp7_ = self->priv->pulse_timer;
			geary_timeout_manager_start (_tmp7_);
		}
	}
}

static void
components_validator_validate_entry (ComponentsValidator* self,
                                     ComponentsValidatorTrigger reason)
{
	gchar* value = NULL;
	GtkEntry* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	ComponentsValidatorValidity new_state = 0;
	ComponentsValidatorValidity _tmp3_;
	const gchar* _tmp4_;
	g_return_if_fail (COMPONENTS_IS_VALIDATOR (self));
	_tmp0_ = self->priv->_target;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	value = _tmp2_;
	_tmp3_ = self->priv->_state;
	new_state = _tmp3_;
	_tmp4_ = value;
	if (geary_string_is_empty_or_whitespace (_tmp4_)) {
		ComponentsValidatorValidity _tmp5_ = 0;
		gboolean _tmp6_;
		_tmp6_ = self->priv->_is_required;
		if (_tmp6_) {
			_tmp5_ = COMPONENTS_VALIDATOR_VALIDITY_EMPTY;
		} else {
			_tmp5_ = COMPONENTS_VALIDATOR_VALIDITY_VALID;
		}
		new_state = _tmp5_;
	} else {
		const gchar* _tmp7_;
		_tmp7_ = value;
		new_state = components_validator_do_validate (self, _tmp7_, reason);
	}
	components_validator_update_state (self, new_state, reason);
	_g_free0 (value);
}

static void
components_validator_update_ui (ComponentsValidator* self,
                                ComponentsValidatorValidity state)
{
	GearyTimeoutManager* _tmp0_;
	GtkStyleContext* style = NULL;
	GtkEntry* _tmp1_;
	GtkStyleContext* _tmp2_;
	GtkStyleContext* _tmp3_;
	GtkStyleContext* _tmp4_;
	GtkStyleContext* _tmp5_;
	ComponentsValidatorUiState ui = {0};
	ComponentsValidatorUiState _tmp6_ = {0};
	gboolean in_progress = FALSE;
	GtkEntry* _tmp30_;
	ComponentsValidatorUiState _tmp31_;
	const gchar* _tmp32_;
	const gchar* _tmp33_ = NULL;
	ComponentsValidatorUiState _tmp34_;
	const gchar* _tmp35_;
	GtkEntry* _tmp38_;
	g_return_if_fail (COMPONENTS_IS_VALIDATOR (self));
	_tmp0_ = self->priv->ui_update_timer;
	geary_timeout_manager_reset (_tmp0_);
	_tmp1_ = self->priv->_target;
	_tmp2_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget));
	_tmp3_ = _g_object_ref0 (_tmp2_);
	style = _tmp3_;
	_tmp4_ = style;
	gtk_style_context_remove_class (_tmp4_, GTK_STYLE_CLASS_ERROR);
	_tmp5_ = style;
	gtk_style_context_remove_class (_tmp5_, GTK_STYLE_CLASS_WARNING);
	_g_free0 (_tmp6_.icon_name);
	_tmp6_.icon_name = NULL;
	_g_free0 (_tmp6_.icon_tooltip_text);
	_tmp6_.icon_tooltip_text = NULL;
	ui = _tmp6_;
	in_progress = FALSE;
	switch (state) {
		case COMPONENTS_VALIDATOR_VALIDITY_INDETERMINATE:
		{
			ComponentsValidatorUiState _tmp7_;
			ComponentsValidatorUiState _tmp8_;
			ComponentsValidatorUiState _tmp9_ = {0};
			_tmp7_ = self->indeterminate_state;
			_tmp8_ = _tmp7_;
			components_validator_ui_state_copy (&_tmp8_, &_tmp9_);
			components_validator_ui_state_destroy (&ui);
			ui = _tmp9_;
			break;
		}
		case COMPONENTS_VALIDATOR_VALIDITY_VALID:
		{
			ComponentsValidatorUiState _tmp10_;
			ComponentsValidatorUiState _tmp11_;
			ComponentsValidatorUiState _tmp12_ = {0};
			_tmp10_ = self->valid_state;
			_tmp11_ = _tmp10_;
			components_validator_ui_state_copy (&_tmp11_, &_tmp12_);
			components_validator_ui_state_destroy (&ui);
			ui = _tmp12_;
			break;
		}
		case COMPONENTS_VALIDATOR_VALIDITY_IN_PROGRESS:
		{
			ComponentsValidatorUiState _tmp13_;
			ComponentsValidatorUiState _tmp14_;
			ComponentsValidatorUiState _tmp15_ = {0};
			in_progress = TRUE;
			_tmp13_ = self->in_progress_state;
			_tmp14_ = _tmp13_;
			components_validator_ui_state_copy (&_tmp14_, &_tmp15_);
			components_validator_ui_state_destroy (&ui);
			ui = _tmp15_;
			break;
		}
		case COMPONENTS_VALIDATOR_VALIDITY_EMPTY:
		{
			GtkStyleContext* _tmp16_;
			ComponentsValidatorUiState _tmp17_;
			ComponentsValidatorUiState _tmp18_;
			ComponentsValidatorUiState _tmp19_ = {0};
			_tmp16_ = style;
			gtk_style_context_add_class (_tmp16_, GTK_STYLE_CLASS_WARNING);
			_tmp17_ = self->empty_state;
			_tmp18_ = _tmp17_;
			components_validator_ui_state_copy (&_tmp18_, &_tmp19_);
			components_validator_ui_state_destroy (&ui);
			ui = _tmp19_;
			break;
		}
		case COMPONENTS_VALIDATOR_VALIDITY_INVALID:
		{
			GtkStyleContext* _tmp20_;
			ComponentsValidatorUiState _tmp21_;
			ComponentsValidatorUiState _tmp22_;
			ComponentsValidatorUiState _tmp23_ = {0};
			_tmp20_ = style;
			gtk_style_context_add_class (_tmp20_, GTK_STYLE_CLASS_ERROR);
			_tmp21_ = self->invalid_state;
			_tmp22_ = _tmp21_;
			components_validator_ui_state_copy (&_tmp22_, &_tmp23_);
			components_validator_ui_state_destroy (&ui);
			ui = _tmp23_;
			break;
		}
		default:
		break;
	}
	if (in_progress) {
		GearyTimeoutManager* _tmp24_;
		gboolean _tmp25_;
		gboolean _tmp26_;
		_tmp24_ = self->priv->pulse_timer;
		_tmp25_ = geary_timeout_manager_get_is_running (_tmp24_);
		_tmp26_ = _tmp25_;
		if (!_tmp26_) {
			GearyTimeoutManager* _tmp27_;
			_tmp27_ = self->priv->pulse_timer;
			geary_timeout_manager_start (_tmp27_);
		}
	} else {
		GearyTimeoutManager* _tmp28_;
		_tmp28_ = self->priv->pulse_timer;
		geary_timeout_manager_reset (_tmp28_);
		if (self->priv->did_pulse) {
			GtkEntry* _tmp29_;
			_tmp29_ = self->priv->_target;
			gtk_entry_set_progress_fraction (_tmp29_, 0.0);
			self->priv->did_pulse = FALSE;
		}
	}
	_tmp30_ = self->priv->_target;
	_tmp31_ = ui;
	_tmp32_ = _tmp31_.icon_name;
	gtk_entry_set_icon_from_icon_name (_tmp30_, COMPONENTS_VALIDATOR_ICON_POS, _tmp32_);
	_tmp34_ = ui;
	_tmp35_ = _tmp34_.icon_tooltip_text;
	if (geary_string_is_empty (_tmp35_)) {
		_tmp33_ = " ";
	} else {
		ComponentsValidatorUiState _tmp36_;
		const gchar* _tmp37_;
		_tmp36_ = ui;
		_tmp37_ = _tmp36_.icon_tooltip_text;
		_tmp33_ = _tmp37_;
	}
	_tmp38_ = self->priv->_target;
	gtk_entry_set_icon_tooltip_text (_tmp38_, COMPONENTS_VALIDATOR_ICON_POS, _tmp33_);
	components_validator_ui_state_destroy (&ui);
	_g_object_unref0 (style);
}

static void
components_validator_on_activate (ComponentsValidator* self)
{
	g_return_if_fail (COMPONENTS_IS_VALIDATOR (self));
	if (self->priv->target_changed) {
		components_validator_validate_entry (self, COMPONENTS_VALIDATOR_TRIGGER_ACTIVATED);
	} else {
		g_signal_emit (self, components_validator_signals[COMPONENTS_VALIDATOR_ACTIVATED_SIGNAL], 0);
	}
}

static void
components_validator_on_update_ui (ComponentsValidator* self)
{
	ComponentsValidatorValidity _tmp0_;
	g_return_if_fail (COMPONENTS_IS_VALIDATOR (self));
	_tmp0_ = self->priv->_state;
	components_validator_update_ui (self, _tmp0_);
}

static void
components_validator_on_pulse (ComponentsValidator* self)
{
	GtkEntry* _tmp0_;
	g_return_if_fail (COMPONENTS_IS_VALIDATOR (self));
	_tmp0_ = self->priv->_target;
	gtk_entry_progress_pulse (_tmp0_);
	self->priv->did_pulse = TRUE;
}

static void
components_validator_on_changed (ComponentsValidator* self)
{
	GearyTimeoutManager* _tmp0_;
	g_return_if_fail (COMPONENTS_IS_VALIDATOR (self));
	self->priv->target_changed = TRUE;
	components_validator_validate_entry (self, COMPONENTS_VALIDATOR_TRIGGER_CHANGED);
	_tmp0_ = self->priv->ui_update_timer;
	geary_timeout_manager_start (_tmp0_);
}

static gboolean
components_validator_on_focus_out (ComponentsValidator* self)
{
	gboolean result;
	g_return_val_if_fail (COMPONENTS_IS_VALIDATOR (self), FALSE);
	if (self->priv->target_changed) {
		GtkEntry* _tmp0_;
		gboolean _tmp1_;
		gboolean _tmp2_;
		_tmp0_ = self->priv->_target;
		g_object_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget), "is-focus", &_tmp1_, NULL);
		_tmp2_ = _tmp1_;
		if (!_tmp2_) {
			components_validator_validate_entry (self, COMPONENTS_VALIDATOR_TRIGGER_LOST_FOCUS);
		}
	} else {
		g_signal_emit (self, components_validator_signals[COMPONENTS_VALIDATOR_FOCUS_LOST_SIGNAL], 0);
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}

void
components_validator_ui_state_copy (const ComponentsValidatorUiState* self,
                                    ComponentsValidatorUiState* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = (*self).icon_name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).icon_name);
	(*dest).icon_name = _tmp1_;
	_tmp2_ = (*self).icon_tooltip_text;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).icon_tooltip_text);
	(*dest).icon_tooltip_text = _tmp3_;
}

void
components_validator_ui_state_destroy (ComponentsValidatorUiState* self)
{
	_g_free0 ((*self).icon_name);
	_g_free0 ((*self).icon_tooltip_text);
}

ComponentsValidatorUiState*
components_validator_ui_state_dup (const ComponentsValidatorUiState* self)
{
	ComponentsValidatorUiState* dup;
	dup = g_new0 (ComponentsValidatorUiState, 1);
	components_validator_ui_state_copy (self, dup);
	return dup;
}

void
components_validator_ui_state_free (ComponentsValidatorUiState* self)
{
	components_validator_ui_state_destroy (self);
	g_free (self);
}

static GType
components_validator_ui_state_get_type_once (void)
{
	GType components_validator_ui_state_type_id;
	components_validator_ui_state_type_id = g_boxed_type_register_static ("ComponentsValidatorUiState", (GBoxedCopyFunc) components_validator_ui_state_dup, (GBoxedFreeFunc) components_validator_ui_state_free);
	return components_validator_ui_state_type_id;
}

GType
components_validator_ui_state_get_type (void)
{
	static volatile gsize components_validator_ui_state_type_id__once = 0;
	if (g_once_init_enter (&components_validator_ui_state_type_id__once)) {
		GType components_validator_ui_state_type_id;
		components_validator_ui_state_type_id = components_validator_ui_state_get_type_once ();
		g_once_init_leave (&components_validator_ui_state_type_id__once, components_validator_ui_state_type_id);
	}
	return components_validator_ui_state_type_id__once;
}

static void
components_validator_class_init (ComponentsValidatorClass * klass,
                                 gpointer klass_data)
{
	components_validator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ComponentsValidator_private_offset);
	((ComponentsValidatorClass *) klass)->do_validate = (ComponentsValidatorValidity (*) (ComponentsValidator*, const gchar*, ComponentsValidatorTrigger)) components_validator_real_do_validate;
	G_OBJECT_CLASS (klass)->get_property = _vala_components_validator_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_components_validator_set_property;
	G_OBJECT_CLASS (klass)->finalize = components_validator_finalize;
	/** The entry being monitored */
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMPONENTS_VALIDATOR_TARGET_PROPERTY, components_validator_properties[COMPONENTS_VALIDATOR_TARGET_PROPERTY] = g_param_spec_object ("target", "target", "target", gtk_entry_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** Determines if the current state indicates the entry is valid. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMPONENTS_VALIDATOR_IS_VALID_PROPERTY, components_validator_properties[COMPONENTS_VALIDATOR_IS_VALID_PROPERTY] = g_param_spec_boolean ("is-valid", "is-valid", "is-valid", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Determines how empty entries are treated.
	     *
	     * If true, an empty entry is considered {@link Validity.EMPTY}
	     * (i.e. invalid) else it is considered to be {@link
	     * Validity.INDETERMINATE}.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMPONENTS_VALIDATOR_IS_REQUIRED_PROPERTY, components_validator_properties[COMPONENTS_VALIDATOR_IS_REQUIRED_PROPERTY] = g_param_spec_boolean ("is-required", "is-required", "is-required", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/** The current validation state of the entry. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMPONENTS_VALIDATOR_STATE_PROPERTY, components_validator_properties[COMPONENTS_VALIDATOR_STATE_PROPERTY] = g_param_spec_enum ("state", "state", "state", COMPONENTS_VALIDATOR_TYPE_VALIDITY, COMPONENTS_VALIDATOR_VALIDITY_INDETERMINATE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** Fired when the validation state changes. */
	components_validator_signals[COMPONENTS_VALIDATOR_STATE_CHANGED_SIGNAL] = g_signal_new ("state-changed", COMPONENTS_TYPE_VALIDATOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__ENUM_ENUM, G_TYPE_NONE, 2, COMPONENTS_VALIDATOR_TYPE_TRIGGER, COMPONENTS_VALIDATOR_TYPE_VALIDITY);
	/** Fired when validation completes after the target has changed. */
	components_validator_signals[COMPONENTS_VALIDATOR_CHANGED_SIGNAL] = g_signal_new ("changed", COMPONENTS_TYPE_VALIDATOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	/** Fired when validation completes after the target was activated. */
	components_validator_signals[COMPONENTS_VALIDATOR_ACTIVATED_SIGNAL] = g_signal_new ("activated", COMPONENTS_TYPE_VALIDATOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	/** Fired when validation completes after the target lost focus. */
	components_validator_signals[COMPONENTS_VALIDATOR_FOCUS_LOST_SIGNAL] = g_signal_new ("focus-lost", COMPONENTS_TYPE_VALIDATOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
components_validator_instance_init (ComponentsValidator * self,
                                    gpointer klass)
{
	self->priv = components_validator_get_instance_private (self);
	self->priv->_is_required = TRUE;
	self->priv->_state = COMPONENTS_VALIDATOR_VALIDITY_INDETERMINATE;
	self->priv->target_changed = FALSE;
	self->priv->did_pulse = FALSE;
}

static void
components_validator_finalize (GObject * obj)
{
	ComponentsValidator * self;
	GtkEntry* _tmp0_;
	guint _tmp1_;
	GtkEntry* _tmp2_;
	guint _tmp3_;
	GtkEntry* _tmp4_;
	guint _tmp5_;
	GearyTimeoutManager* _tmp6_;
	GearyTimeoutManager* _tmp7_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, COMPONENTS_TYPE_VALIDATOR, ComponentsValidator);
	_tmp0_ = self->priv->_target;
	g_signal_parse_name ("focus-out-event", gtk_widget_get_type (), &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _components_validator_on_focus_out_gtk_widget_focus_out_event, self);
	_tmp2_ = self->priv->_target;
	g_signal_parse_name ("changed", gtk_editable_get_type (), &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_editable_get_type (), GtkEditable), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _components_validator_on_changed_gtk_editable_changed, self);
	_tmp4_ = self->priv->_target;
	g_signal_parse_name ("activate", gtk_entry_get_type (), &_tmp5_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _components_validator_on_activate_gtk_entry_activate, self);
	_tmp6_ = self->priv->ui_update_timer;
	geary_timeout_manager_reset (_tmp6_);
	_tmp7_ = self->priv->pulse_timer;
	geary_timeout_manager_reset (_tmp7_);
	_g_object_unref0 (self->priv->_target);
	components_validator_ui_state_destroy (&self->indeterminate_state);
	components_validator_ui_state_destroy (&self->valid_state);
	components_validator_ui_state_destroy (&self->in_progress_state);
	components_validator_ui_state_destroy (&self->empty_state);
	components_validator_ui_state_destroy (&self->invalid_state);
	_g_object_unref0 (self->priv->ui_update_timer);
	_g_object_unref0 (self->priv->pulse_timer);
	G_OBJECT_CLASS (components_validator_parent_class)->finalize (obj);
}

/**
 * Validates the contents of a Gtk Entry as they are entered.
 *
 * This class may be used to validate required, but otherwise free
 * form entries. Subclasses may perform more complex and task-specific
 * validation.
 */
static GType
components_validator_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ComponentsValidatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) components_validator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ComponentsValidator), 0, (GInstanceInitFunc) components_validator_instance_init, NULL };
	GType components_validator_type_id;
	components_validator_type_id = g_type_register_static (G_TYPE_OBJECT, "ComponentsValidator", &g_define_type_info, 0);
	ComponentsValidator_private_offset = g_type_add_instance_private (components_validator_type_id, sizeof (ComponentsValidatorPrivate));
	return components_validator_type_id;
}

GType
components_validator_get_type (void)
{
	static volatile gsize components_validator_type_id__once = 0;
	if (g_once_init_enter (&components_validator_type_id__once)) {
		GType components_validator_type_id;
		components_validator_type_id = components_validator_get_type_once ();
		g_once_init_leave (&components_validator_type_id__once, components_validator_type_id);
	}
	return components_validator_type_id__once;
}

static void
_vala_components_validator_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	ComponentsValidator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, COMPONENTS_TYPE_VALIDATOR, ComponentsValidator);
	switch (property_id) {
		case COMPONENTS_VALIDATOR_TARGET_PROPERTY:
		g_value_set_object (value, components_validator_get_target (self));
		break;
		case COMPONENTS_VALIDATOR_IS_VALID_PROPERTY:
		g_value_set_boolean (value, components_validator_get_is_valid (self));
		break;
		case COMPONENTS_VALIDATOR_IS_REQUIRED_PROPERTY:
		g_value_set_boolean (value, components_validator_get_is_required (self));
		break;
		case COMPONENTS_VALIDATOR_STATE_PROPERTY:
		g_value_set_enum (value, components_validator_get_state (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_components_validator_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	ComponentsValidator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, COMPONENTS_TYPE_VALIDATOR, ComponentsValidator);
	switch (property_id) {
		case COMPONENTS_VALIDATOR_TARGET_PROPERTY:
		components_validator_set_target (self, g_value_get_object (value));
		break;
		case COMPONENTS_VALIDATOR_IS_REQUIRED_PROPERTY:
		components_validator_set_is_required (self, g_value_get_boolean (value));
		break;
		case COMPONENTS_VALIDATOR_STATE_PROPERTY:
		components_validator_set_state (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

ComponentsEmailValidator*
components_email_validator_construct (GType object_type,
                                      GtkEntry* target)
{
	ComponentsEmailValidator * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (target, gtk_entry_get_type ()), NULL);
	self = (ComponentsEmailValidator*) components_validator_construct (object_type, target);
	_tmp0_ = g_strdup (_ ("An email address is required"));
	_g_free0 (G_TYPE_CHECK_INSTANCE_CAST (self, COMPONENTS_TYPE_VALIDATOR, ComponentsValidator)->empty_state.icon_tooltip_text);
	G_TYPE_CHECK_INSTANCE_CAST (self, COMPONENTS_TYPE_VALIDATOR, ComponentsValidator)->empty_state.icon_tooltip_text = _tmp0_;
	_tmp1_ = g_strdup (_ ("Not a valid email address"));
	_g_free0 (G_TYPE_CHECK_INSTANCE_CAST (self, COMPONENTS_TYPE_VALIDATOR, ComponentsValidator)->invalid_state.icon_tooltip_text);
	G_TYPE_CHECK_INSTANCE_CAST (self, COMPONENTS_TYPE_VALIDATOR, ComponentsValidator)->invalid_state.icon_tooltip_text = _tmp1_;
	return self;
}

ComponentsEmailValidator*
components_email_validator_new (GtkEntry* target)
{
	return components_email_validator_construct (COMPONENTS_TYPE_EMAIL_VALIDATOR, target);
}

static ComponentsValidatorValidity
components_email_validator_real_do_validate (ComponentsValidator* base,
                                             const gchar* value,
                                             ComponentsValidatorTrigger reason)
{
	ComponentsEmailValidator * self;
	ComponentsValidatorValidity _tmp0_ = 0;
	ComponentsValidatorValidity result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, COMPONENTS_TYPE_EMAIL_VALIDATOR, ComponentsEmailValidator);
	g_return_val_if_fail (value != NULL, 0);
	if (geary_rf_c822_mailbox_address_is_valid_address (value)) {
		_tmp0_ = COMPONENTS_VALIDATOR_VALIDITY_VALID;
	} else {
		_tmp0_ = COMPONENTS_VALIDATOR_VALIDITY_INVALID;
	}
	result = _tmp0_;
	return result;
}

static void
components_email_validator_class_init (ComponentsEmailValidatorClass * klass,
                                       gpointer klass_data)
{
	components_email_validator_parent_class = g_type_class_peek_parent (klass);
	((ComponentsValidatorClass *) klass)->do_validate = (ComponentsValidatorValidity (*) (ComponentsValidator*, const gchar*, ComponentsValidatorTrigger)) components_email_validator_real_do_validate;
}

static void
components_email_validator_instance_init (ComponentsEmailValidator * self,
                                          gpointer klass)
{
}

/**
 * A validator for GTK Entry widgets that contain an email address.
 */
static GType
components_email_validator_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ComponentsEmailValidatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) components_email_validator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ComponentsEmailValidator), 0, (GInstanceInitFunc) components_email_validator_instance_init, NULL };
	GType components_email_validator_type_id;
	components_email_validator_type_id = g_type_register_static (COMPONENTS_TYPE_VALIDATOR, "ComponentsEmailValidator", &g_define_type_info, 0);
	return components_email_validator_type_id;
}

GType
components_email_validator_get_type (void)
{
	static volatile gsize components_email_validator_type_id__once = 0;
	if (g_once_init_enter (&components_email_validator_type_id__once)) {
		GType components_email_validator_type_id;
		components_email_validator_type_id = components_email_validator_get_type_once ();
		g_once_init_leave (&components_email_validator_type_id__once, components_email_validator_type_id);
	}
	return components_email_validator_type_id__once;
}

static inline gpointer
components_network_address_validator_get_instance_private (ComponentsNetworkAddressValidator* self)
{
	return G_STRUCT_MEMBER_P (self, ComponentsNetworkAddressValidator_private_offset);
}

GNetworkAddress*
components_network_address_validator_get_validated_address (ComponentsNetworkAddressValidator* self)
{
	GNetworkAddress* result;
	GNetworkAddress* _tmp0_;
	g_return_val_if_fail (COMPONENTS_IS_NETWORK_ADDRESS_VALIDATOR (self), NULL);
	_tmp0_ = self->priv->_validated_address;
	result = _tmp0_;
	return result;
}

static void
components_network_address_validator_set_validated_address (ComponentsNetworkAddressValidator* self,
                                                            GNetworkAddress* value)
{
	GNetworkAddress* old_value;
	g_return_if_fail (COMPONENTS_IS_NETWORK_ADDRESS_VALIDATOR (self));
	old_value = components_network_address_validator_get_validated_address (self);
	if (old_value != value) {
		GNetworkAddress* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_validated_address);
		self->priv->_validated_address = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, components_network_address_validator_properties[COMPONENTS_NETWORK_ADDRESS_VALIDATOR_VALIDATED_ADDRESS_PROPERTY]);
	}
}

guint16
components_network_address_validator_get_default_port (ComponentsNetworkAddressValidator* self)
{
	guint16 result;
	g_return_val_if_fail (COMPONENTS_IS_NETWORK_ADDRESS_VALIDATOR (self), 0U);
	result = self->priv->_default_port;
	return result;
}

static void
components_network_address_validator_set_default_port (ComponentsNetworkAddressValidator* self,
                                                       guint16 value)
{
	guint16 old_value;
	g_return_if_fail (COMPONENTS_IS_NETWORK_ADDRESS_VALIDATOR (self));
	old_value = components_network_address_validator_get_default_port (self);
	if (old_value != value) {
		self->priv->_default_port = value;
		g_object_notify_by_pspec ((GObject *) self, components_network_address_validator_properties[COMPONENTS_NETWORK_ADDRESS_VALIDATOR_DEFAULT_PORT_PROPERTY]);
	}
}

ComponentsNetworkAddressValidator*
components_network_address_validator_construct (GType object_type,
                                                GtkEntry* target,
                                                guint16 default_port)
{
	ComponentsNetworkAddressValidator * self = NULL;
	GResolver* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (target, gtk_entry_get_type ()), NULL);
	self = (ComponentsNetworkAddressValidator*) components_validator_construct (object_type, target);
	components_network_address_validator_set_default_port (self, default_port);
	_tmp0_ = g_resolver_get_default ();
	_g_object_unref0 (self->priv->resolver);
	self->priv->resolver = _tmp0_;
	_tmp1_ = g_strdup (_ ("A server name is required"));
	_g_free0 (G_TYPE_CHECK_INSTANCE_CAST (self, COMPONENTS_TYPE_VALIDATOR, ComponentsValidator)->empty_state.icon_tooltip_text);
	G_TYPE_CHECK_INSTANCE_CAST (self, COMPONENTS_TYPE_VALIDATOR, ComponentsValidator)->empty_state.icon_tooltip_text = _tmp1_;
	_tmp2_ = g_strdup (_ ("Could not look up server name"));
	_g_free0 (G_TYPE_CHECK_INSTANCE_CAST (self, COMPONENTS_TYPE_VALIDATOR, ComponentsValidator)->invalid_state.icon_tooltip_text);
	G_TYPE_CHECK_INSTANCE_CAST (self, COMPONENTS_TYPE_VALIDATOR, ComponentsValidator)->invalid_state.icon_tooltip_text = _tmp2_;
	return self;
}

ComponentsNetworkAddressValidator*
components_network_address_validator_new (GtkEntry* target,
                                          guint16 default_port)
{
	return components_network_address_validator_construct (COMPONENTS_TYPE_NETWORK_ADDRESS_VALIDATOR, target, default_port);
}

static Block60Data*
block60_data_ref (Block60Data* _data60_)
{
	g_atomic_int_inc (&_data60_->_ref_count_);
	return _data60_;
}

static void
block60_data_unref (void * _userdata_)
{
	Block60Data* _data60_;
	_data60_ = (Block60Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data60_->_ref_count_)) {
		ComponentsNetworkAddressValidator* self;
		self = _data60_->self;
		_g_object_unref0 (_data60_->address);
		_g_object_unref0 (self);
		g_slice_free (Block60Data, _data60_);
	}
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
____lambda90_ (Block60Data* _data60_,
               GObject* obj,
               GAsyncResult* res)
{
	ComponentsNetworkAddressValidator* self;
	GError* _inner_error0_ = NULL;
	self = _data60_->self;
	g_return_if_fail ((obj == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (obj, G_TYPE_OBJECT));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (res, g_async_result_get_type ()));
	{
		GResolver* _tmp0_;
		GList* _tmp1_;
		GList* _tmp2_;
		GNetworkAddress* _tmp3_;
		_tmp0_ = self->priv->resolver;
		_tmp1_ = g_resolver_lookup_by_name_finish (_tmp0_, res, &_inner_error0_);
		_tmp2_ = _tmp1_;
		(_tmp2_ == NULL) ? NULL : (_tmp2_ = (_g_list_free__g_object_unref0_ (_tmp2_), NULL));
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (g_error_matches (_inner_error0_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
				goto __catch0_g_io_error_cancelled;
			}
			goto __catch0_g_error;
		}
		_tmp3_ = _data60_->address;
		components_network_address_validator_set_validated_address (self, _tmp3_);
		components_validator_update_state (G_TYPE_CHECK_INSTANCE_CAST (self, COMPONENTS_TYPE_VALIDATOR, ComponentsValidator), COMPONENTS_VALIDATOR_VALIDITY_VALID, _data60_->reason);
	}
	goto __finally0;
	__catch0_g_io_error_cancelled:
	{
		g_clear_error (&_inner_error0_);
		components_network_address_validator_set_validated_address (self, NULL);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		components_network_address_validator_set_validated_address (self, NULL);
		components_validator_update_state (G_TYPE_CHECK_INSTANCE_CAST (self, COMPONENTS_TYPE_VALIDATOR, ComponentsValidator), COMPONENTS_VALIDATOR_VALIDITY_INVALID, _data60_->reason);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = NULL;
}

static void
_____lambda90__gasync_ready_callback (GObject* source_object,
                                      GAsyncResult* res,
                                      gpointer self)
{
	____lambda90_ (self, source_object, res);
	block60_data_unref (self);
}

static ComponentsValidatorValidity
components_network_address_validator_real_do_validate (ComponentsValidator* base,
                                                       const gchar* value,
                                                       ComponentsValidatorTrigger reason)
{
	ComponentsNetworkAddressValidator * self;
	Block60Data* _data60_;
	GCancellable* _tmp0_;
	ComponentsValidatorValidity ret = 0;
	ComponentsValidatorValidity _tmp2_;
	ComponentsValidatorValidity _tmp3_;
	GNetworkAddress* _tmp13_;
	GError* _inner_error0_ = NULL;
	ComponentsValidatorValidity result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, COMPONENTS_TYPE_NETWORK_ADDRESS_VALIDATOR, ComponentsNetworkAddressValidator);
	g_return_val_if_fail (value != NULL, 0);
	_data60_ = g_slice_new0 (Block60Data);
	_data60_->_ref_count_ = 1;
	_data60_->self = g_object_ref (self);
	_data60_->reason = reason;
	_tmp0_ = self->priv->cancellable;
	if (_tmp0_ != NULL) {
		GCancellable* _tmp1_;
		_tmp1_ = self->priv->cancellable;
		g_cancellable_cancel (_tmp1_);
	}
	_tmp2_ = components_validator_get_state (G_TYPE_CHECK_INSTANCE_CAST (self, COMPONENTS_TYPE_VALIDATOR, ComponentsValidator));
	_tmp3_ = _tmp2_;
	ret = _tmp3_;
	_data60_->address = NULL;
	{
		GNetworkAddress* _tmp4_ = NULL;
		gchar* _tmp5_;
		gchar* _tmp6_;
		guint16 _tmp7_;
		GNetworkAddress* _tmp8_;
		GNetworkAddress* _tmp9_;
		GNetworkAddress* _tmp10_;
		_tmp5_ = string_strip (value);
		_tmp6_ = _tmp5_;
		_tmp7_ = self->priv->_default_port;
		_tmp8_ = g_network_address_parse (_tmp6_, _tmp7_, &_inner_error0_);
		_tmp9_ = _tmp8_;
		_g_free0 (_tmp6_);
		_tmp4_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp10_ = _tmp4_;
		_tmp4_ = NULL;
		_g_object_unref0 (_data60_->address);
		_data60_->address = _tmp10_;
		_g_object_unref0 (_tmp4_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp11_;
		const gchar* _tmp12_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		components_network_address_validator_set_validated_address (self, NULL);
		ret = COMPONENTS_VALIDATOR_VALIDITY_INVALID;
		_tmp11_ = err;
		_tmp12_ = _tmp11_->message;
		g_debug ("components-validator.vala:469: Error parsing host name \"%s\": %s", value, _tmp12_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		block60_data_unref (_data60_);
		_data60_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return 0;
	}
	_tmp13_ = _data60_->address;
	if (_tmp13_ != NULL) {
		gboolean _tmp14_ = FALSE;
		GNetworkAddress* _tmp15_;
		_tmp15_ = self->priv->_validated_address;
		if (_tmp15_ == NULL) {
			_tmp14_ = TRUE;
		} else {
			GNetworkAddress* _tmp16_;
			const gchar* _tmp17_;
			const gchar* _tmp18_;
			GNetworkAddress* _tmp19_;
			const gchar* _tmp20_;
			const gchar* _tmp21_;
			_tmp16_ = self->priv->_validated_address;
			_tmp17_ = g_network_address_get_hostname (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = _data60_->address;
			_tmp20_ = g_network_address_get_hostname (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp14_ = g_strcmp0 (_tmp18_, _tmp21_) != 0;
		}
		if (_tmp14_) {
			GCancellable* _tmp22_;
			GResolver* _tmp23_;
			GNetworkAddress* _tmp24_;
			const gchar* _tmp25_;
			const gchar* _tmp26_;
			GCancellable* _tmp27_;
			_tmp22_ = g_cancellable_new ();
			_g_object_unref0 (self->priv->cancellable);
			self->priv->cancellable = _tmp22_;
			_tmp23_ = self->priv->resolver;
			_tmp24_ = _data60_->address;
			_tmp25_ = g_network_address_get_hostname (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = self->priv->cancellable;
			g_resolver_lookup_by_name_async (_tmp23_, _tmp26_, _tmp27_, _____lambda90__gasync_ready_callback, block60_data_ref (_data60_));
			ret = COMPONENTS_VALIDATOR_VALIDITY_IN_PROGRESS;
		} else {
			GNetworkAddress* _tmp28_;
			_tmp28_ = _data60_->address;
			components_network_address_validator_set_validated_address (self, _tmp28_);
			ret = COMPONENTS_VALIDATOR_VALIDITY_VALID;
		}
	}
	result = ret;
	block60_data_unref (_data60_);
	_data60_ = NULL;
	return result;
}

static void
components_network_address_validator_class_init (ComponentsNetworkAddressValidatorClass * klass,
                                                 gpointer klass_data)
{
	components_network_address_validator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ComponentsNetworkAddressValidator_private_offset);
	((ComponentsValidatorClass *) klass)->do_validate = (ComponentsValidatorValidity (*) (ComponentsValidator*, const gchar*, ComponentsValidatorTrigger)) components_network_address_validator_real_do_validate;
	G_OBJECT_CLASS (klass)->get_property = _vala_components_network_address_validator_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_components_network_address_validator_set_property;
	G_OBJECT_CLASS (klass)->finalize = components_network_address_validator_finalize;
	/** The validated network address, if any. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMPONENTS_NETWORK_ADDRESS_VALIDATOR_VALIDATED_ADDRESS_PROPERTY, components_network_address_validator_properties[COMPONENTS_NETWORK_ADDRESS_VALIDATOR_VALIDATED_ADDRESS_PROPERTY] = g_param_spec_object ("validated-address", "validated-address", "validated-address", g_network_address_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** The default port used when parsing the address. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMPONENTS_NETWORK_ADDRESS_VALIDATOR_DEFAULT_PORT_PROPERTY, components_network_address_validator_properties[COMPONENTS_NETWORK_ADDRESS_VALIDATOR_DEFAULT_PORT_PROPERTY] = g_param_spec_uint ("default-port", "default-port", "default-port", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
components_network_address_validator_instance_init (ComponentsNetworkAddressValidator * self,
                                                    gpointer klass)
{
	self->priv = components_network_address_validator_get_instance_private (self);
	self->priv->_validated_address = NULL;
	self->priv->cancellable = NULL;
}

static void
components_network_address_validator_finalize (GObject * obj)
{
	ComponentsNetworkAddressValidator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, COMPONENTS_TYPE_NETWORK_ADDRESS_VALIDATOR, ComponentsNetworkAddressValidator);
	_g_object_unref0 (self->priv->_validated_address);
	_g_object_unref0 (self->priv->resolver);
	_g_object_unref0 (self->priv->cancellable);
	G_OBJECT_CLASS (components_network_address_validator_parent_class)->finalize (obj);
}

/**
 * A validator for GTK Entry widgets that contain a network address.
 *
 * This attempts parse the entry value as a host name or IP address
 * with an optional port, then resolve the host name if
 * needed. Parsing is performed by {@link GLib.NetworkAddress.parse}
 * to parse the user input, hence it may be specified in any form
 * supported by that method.
 */
static GType
components_network_address_validator_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ComponentsNetworkAddressValidatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) components_network_address_validator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ComponentsNetworkAddressValidator), 0, (GInstanceInitFunc) components_network_address_validator_instance_init, NULL };
	GType components_network_address_validator_type_id;
	components_network_address_validator_type_id = g_type_register_static (COMPONENTS_TYPE_VALIDATOR, "ComponentsNetworkAddressValidator", &g_define_type_info, 0);
	ComponentsNetworkAddressValidator_private_offset = g_type_add_instance_private (components_network_address_validator_type_id, sizeof (ComponentsNetworkAddressValidatorPrivate));
	return components_network_address_validator_type_id;
}

GType
components_network_address_validator_get_type (void)
{
	static volatile gsize components_network_address_validator_type_id__once = 0;
	if (g_once_init_enter (&components_network_address_validator_type_id__once)) {
		GType components_network_address_validator_type_id;
		components_network_address_validator_type_id = components_network_address_validator_get_type_once ();
		g_once_init_leave (&components_network_address_validator_type_id__once, components_network_address_validator_type_id);
	}
	return components_network_address_validator_type_id__once;
}

static void
_vala_components_network_address_validator_get_property (GObject * object,
                                                         guint property_id,
                                                         GValue * value,
                                                         GParamSpec * pspec)
{
	ComponentsNetworkAddressValidator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, COMPONENTS_TYPE_NETWORK_ADDRESS_VALIDATOR, ComponentsNetworkAddressValidator);
	switch (property_id) {
		case COMPONENTS_NETWORK_ADDRESS_VALIDATOR_VALIDATED_ADDRESS_PROPERTY:
		g_value_set_object (value, components_network_address_validator_get_validated_address (self));
		break;
		case COMPONENTS_NETWORK_ADDRESS_VALIDATOR_DEFAULT_PORT_PROPERTY:
		g_value_set_uint (value, components_network_address_validator_get_default_port (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_components_network_address_validator_set_property (GObject * object,
                                                         guint property_id,
                                                         const GValue * value,
                                                         GParamSpec * pspec)
{
	ComponentsNetworkAddressValidator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, COMPONENTS_TYPE_NETWORK_ADDRESS_VALIDATOR, ComponentsNetworkAddressValidator);
	switch (property_id) {
		case COMPONENTS_NETWORK_ADDRESS_VALIDATOR_VALIDATED_ADDRESS_PROPERTY:
		components_network_address_validator_set_validated_address (self, g_value_get_object (value));
		break;
		case COMPONENTS_NETWORK_ADDRESS_VALIDATOR_DEFAULT_PORT_PROPERTY:
		components_network_address_validator_set_default_port (self, g_value_get_uint (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

