/* composer-link-popover.c generated by valac 0.56.3, the Vala compiler
 * generated from composer-link-popover.vala, do not modify */

/*
 * Copyright 2017 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-client-43.0.h"
#include <gtk/gtk.h>
#include "geary-engine.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>

enum  {
	COMPOSER_LINK_POPOVER_0_PROPERTY,
	COMPOSER_LINK_POPOVER_LINK_URI_PROPERTY,
	COMPOSER_LINK_POPOVER_NUM_PROPERTIES
};
static GParamSpec* composer_link_popover_properties[COMPOSER_LINK_POPOVER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_uri_unref0(var) ((var == NULL) ? NULL : (var = (g_uri_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	COMPOSER_LINK_POPOVER_LINK_CHANGED_SIGNAL,
	COMPOSER_LINK_POPOVER_LINK_ACTIVATE_SIGNAL,
	COMPOSER_LINK_POPOVER_LINK_DELETE_SIGNAL,
	COMPOSER_LINK_POPOVER_NUM_SIGNALS
};
static guint composer_link_popover_signals[COMPOSER_LINK_POPOVER_NUM_SIGNALS] = {0};

struct _ComposerLinkPopoverPrivate {
	GtkEntry* url;
	GtkButton* insert;
	GtkButton* update;
	GtkButton* remove;
	GearyTimeoutManager* validation_timeout;
};

static gint ComposerLinkPopover_private_offset;
static gpointer composer_link_popover_parent_class = NULL;

static void g_cclosure_user_marshal_VOID__BOXED_BOOLEAN (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static void __lambda14_ (ComposerLinkPopover* self);
static void composer_link_popover_validate (ComposerLinkPopover* self);
static void ___lambda14__geary_timeout_manager_timeout_func (GearyTimeoutManager* manager,
                                                      gpointer self);
static void composer_link_popover_real_show (GtkWidget* base);
static void composer_link_popover_real_destroy (GtkWidget* base);
static gboolean _vala_string_array_contains (const gchar* * stack,
                                      gssize stack_length,
                                      const const gchar* needle);
static void composer_link_popover_on_url_changed (ComposerLinkPopover* self);
static void _composer_link_popover_on_url_changed_gtk_editable_changed (GtkEditable* _sender,
                                                                 gpointer self);
static void composer_link_popover_on_activate_popover (ComposerLinkPopover* self);
static void _composer_link_popover_on_activate_popover_gtk_button_clicked (GtkButton* _sender,
                                                                    gpointer self);
static void composer_link_popover_on_remove_clicked (ComposerLinkPopover* self);
static void _composer_link_popover_on_remove_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                  gpointer self);
static void composer_link_popover_finalize (GObject * obj);
static GType composer_link_popover_get_type_once (void);
static void _vala_composer_link_popover_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);

static const gchar* COMPOSER_LINK_POPOVER_HTTP_SCHEMES[2] = {"http", "https"};
static const gchar* COMPOSER_LINK_POPOVER_OTHER_SCHEMES[30] = {"aim", "apt", "bitcoin", "cvs", "ed2k", "ftp", "file", "finger", "git", "gtalk", "irc", "ircs", "irc6", "lastfm", "ldap", "ldaps", "magnet", "news", "nntp", "rsync", "sftp", "skype", "smb", "sms", "svn", "telnet", "tftp", "ssh", "webcal", "xmpp"};

static inline gpointer
composer_link_popover_get_instance_private (ComposerLinkPopover* self)
{
	return G_STRUCT_MEMBER_P (self, ComposerLinkPopover_private_offset);
}

/** Determines which version of the UI is presented to the user. */
static GType
composer_link_popover_type_get_type_once (void)
{
	static const GEnumValue values[] = {{COMPOSER_LINK_POPOVER_TYPE_NEW_LINK, "COMPOSER_LINK_POPOVER_TYPE_NEW_LINK", "new-link"}, {COMPOSER_LINK_POPOVER_TYPE_EXISTING_LINK, "COMPOSER_LINK_POPOVER_TYPE_EXISTING_LINK", "existing-link"}, {0, NULL, NULL}};
	GType composer_link_popover_type_type_id;
	composer_link_popover_type_type_id = g_enum_register_static ("ComposerLinkPopoverType", values);
	return composer_link_popover_type_type_id;
}

GType
composer_link_popover_type_get_type (void)
{
	static volatile gsize composer_link_popover_type_type_id__once = 0;
	if (g_once_init_enter (&composer_link_popover_type_type_id__once)) {
		GType composer_link_popover_type_type_id;
		composer_link_popover_type_type_id = composer_link_popover_type_get_type_once ();
		g_once_init_leave (&composer_link_popover_type_type_id__once, composer_link_popover_type_type_id);
	}
	return composer_link_popover_type_type_id__once;
}

const gchar*
composer_link_popover_get_link_uri (ComposerLinkPopover* self)
{
	const gchar* result;
	GtkEntry* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (COMPOSER_IS_LINK_POPOVER (self), NULL);
	_tmp0_ = self->priv->url;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
g_cclosure_user_marshal_VOID__BOXED_BOOLEAN (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__BOXED_BOOLEAN) (gpointer data1, gpointer arg_1, gboolean arg_2, gpointer data2);
	register GMarshalFunc_VOID__BOXED_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOXED_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boxed (param_values + 1), g_value_get_boolean (param_values + 2), data2);
}

static void
__lambda14_ (ComposerLinkPopover* self)
{
	composer_link_popover_validate (self);
}

static void
___lambda14__geary_timeout_manager_timeout_func (GearyTimeoutManager* manager,
                                                 gpointer self)
{
	__lambda14_ ((ComposerLinkPopover*) self);
}

ComposerLinkPopover*
composer_link_popover_construct (GType object_type,
                                 ComposerLinkPopoverType type)
{
	ComposerLinkPopover * self = NULL;
	GtkEntry* _tmp0_;
	GtkEntry* _tmp1_;
	GearyTimeoutManager* _tmp5_;
	self = (ComposerLinkPopover*) g_object_new (object_type, NULL);
	_tmp0_ = self->priv->url;
	gtk_popover_set_default_widget (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_popover_get_type (), GtkPopover), G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget));
	_tmp1_ = self->priv->url;
	gtk_container_set_focus_child (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget));
	switch (type) {
		case COMPOSER_LINK_POPOVER_TYPE_NEW_LINK:
		{
			GtkButton* _tmp2_;
			GtkButton* _tmp3_;
			_tmp2_ = self->priv->update;
			gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget));
			_tmp3_ = self->priv->remove;
			gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget));
			break;
		}
		case COMPOSER_LINK_POPOVER_TYPE_EXISTING_LINK:
		{
			GtkButton* _tmp4_;
			_tmp4_ = self->priv->insert;
			gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget));
			break;
		}
		default:
		break;
	}
	_tmp5_ = geary_timeout_manager_new_milliseconds ((guint) 150, ___lambda14__geary_timeout_manager_timeout_func, self);
	_g_object_unref0 (self->priv->validation_timeout);
	self->priv->validation_timeout = _tmp5_;
	return self;
}

ComposerLinkPopover*
composer_link_popover_new (ComposerLinkPopoverType type)
{
	return composer_link_popover_construct (COMPOSER_TYPE_LINK_POPOVER, type);
}

static void
composer_link_popover_real_show (GtkWidget* base)
{
	ComposerLinkPopover * self;
	GtkEntry* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, COMPOSER_TYPE_LINK_POPOVER, ComposerLinkPopover);
	GTK_WIDGET_CLASS (composer_link_popover_parent_class)->show (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_popover_get_type (), GtkPopover), gtk_widget_get_type (), GtkWidget));
	_tmp0_ = self->priv->url;
	gtk_widget_grab_focus (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget));
}

static void
composer_link_popover_real_destroy (GtkWidget* base)
{
	ComposerLinkPopover * self;
	GearyTimeoutManager* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, COMPOSER_TYPE_LINK_POPOVER, ComposerLinkPopover);
	_tmp0_ = self->priv->validation_timeout;
	geary_timeout_manager_reset (_tmp0_);
	GTK_WIDGET_CLASS (composer_link_popover_parent_class)->destroy (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_popover_get_type (), GtkPopover), gtk_widget_get_type (), GtkWidget));
}

void
composer_link_popover_set_link_url (ComposerLinkPopover* self,
                                    const gchar* url)
{
	GtkEntry* _tmp0_;
	GearyTimeoutManager* _tmp1_;
	g_return_if_fail (COMPOSER_IS_LINK_POPOVER (self));
	g_return_if_fail (url != NULL);
	_tmp0_ = self->priv->url;
	gtk_entry_set_text (_tmp0_, url);
	_tmp1_ = self->priv->validation_timeout;
	geary_timeout_manager_reset (_tmp1_);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gboolean
_vala_string_array_contains (const gchar* * stack,
                             gssize stack_length,
                             const const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
composer_link_popover_validate (ComposerLinkPopover* self)
{
	gchar* text = NULL;
	GtkEntry* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean is_empty = FALSE;
	const gchar* _tmp3_;
	gboolean is_valid = FALSE;
	gboolean is_nominal = FALSE;
	gboolean is_mailto = FALSE;
	GUri* url = NULL;
	GtkStyleContext* style = NULL;
	GtkEntry* _tmp30_;
	GtkStyleContext* _tmp31_;
	GtkStyleContext* _tmp32_;
	GtkEntryIconPosition pos = 0;
	gboolean _tmp46_ = FALSE;
	GUri* _tmp47_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (COMPOSER_IS_LINK_POPOVER (self));
	_tmp0_ = self->priv->url;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	_tmp2_ = string_strip (_tmp1_);
	text = _tmp2_;
	_tmp3_ = text;
	is_empty = geary_string_is_empty (_tmp3_);
	is_valid = FALSE;
	is_nominal = FALSE;
	is_mailto = FALSE;
	url = NULL;
	if (!is_empty) {
		GUri* _tmp10_;
		{
			GUri* _tmp4_ = NULL;
			const gchar* _tmp5_;
			GUri* _tmp6_;
			GUri* _tmp7_;
			_tmp5_ = text;
			_tmp6_ = g_uri_parse (_tmp5_, G_URI_FLAGS_PARSE_RELAXED, &_inner_error0_);
			_tmp4_ = _tmp6_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_URI_ERROR) {
					goto __catch0_g_uri_error;
				}
				_g_uri_unref0 (url);
				_g_free0 (text);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_tmp7_ = _tmp4_;
			_tmp4_ = NULL;
			_g_uri_unref0 (url);
			url = _tmp7_;
			_g_uri_unref0 (_tmp4_);
		}
		goto __finally0;
		__catch0_g_uri_error:
		{
			GError* err = NULL;
			GError* _tmp8_;
			const gchar* _tmp9_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp8_ = err;
			_tmp9_ = _tmp8_->message;
			g_debug ("composer-link-popover.vala:107: Invalid link URI: %s", _tmp9_);
			_g_error_free0 (err);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_uri_unref0 (url);
			_g_free0 (text);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp10_ = url;
		if (_tmp10_ != NULL) {
			gchar* scheme = NULL;
			GUri* _tmp11_;
			const gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* path = NULL;
			GUri* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			const gchar* _tmp17_;
			is_valid = TRUE;
			_tmp11_ = url;
			_tmp12_ = g_uri_get_scheme (_tmp11_);
			_tmp13_ = g_strdup (_tmp12_);
			scheme = _tmp13_;
			_tmp14_ = url;
			_tmp15_ = g_uri_get_path (_tmp14_);
			_tmp16_ = g_strdup (_tmp15_);
			path = _tmp16_;
			_tmp17_ = scheme;
			if (_vala_string_array_contains (COMPOSER_LINK_POPOVER_HTTP_SCHEMES, G_N_ELEMENTS (COMPOSER_LINK_POPOVER_HTTP_SCHEMES), _tmp17_)) {
				GUri* _tmp18_;
				const gchar* _tmp19_;
				gchar* _tmp20_;
				_tmp18_ = url;
				_tmp19_ = g_uri_get_host (_tmp18_);
				_tmp20_ = g_strdup (_tmp19_);
				is_nominal = geary_inet_is_valid_display_host (_tmp20_);
			} else {
				const gchar* _tmp21_;
				_tmp21_ = scheme;
				if (g_strcmp0 (_tmp21_, "mailto") == 0) {
					gboolean _tmp22_ = FALSE;
					const gchar* _tmp23_;
					is_mailto = TRUE;
					_tmp23_ = path;
					if (!geary_string_is_empty (_tmp23_)) {
						const gchar* _tmp24_;
						_tmp24_ = path;
						_tmp22_ = geary_rf_c822_mailbox_address_is_valid_address (_tmp24_);
					} else {
						_tmp22_ = FALSE;
					}
					is_nominal = _tmp22_;
				} else {
					const gchar* _tmp25_;
					_tmp25_ = scheme;
					if (_vala_string_array_contains (COMPOSER_LINK_POPOVER_OTHER_SCHEMES, G_N_ELEMENTS (COMPOSER_LINK_POPOVER_OTHER_SCHEMES), _tmp25_)) {
						const gchar* _tmp26_;
						_tmp26_ = path;
						is_nominal = !geary_string_is_empty (_tmp26_);
					}
				}
			}
			_g_free0 (path);
			_g_free0 (scheme);
		} else {
			gboolean _tmp27_ = FALSE;
			const gchar* _tmp28_;
			_tmp28_ = text;
			if (g_strcmp0 (_tmp28_, "http:/") == 0) {
				_tmp27_ = TRUE;
			} else {
				const gchar* _tmp29_;
				_tmp29_ = text;
				_tmp27_ = g_strcmp0 (_tmp29_, "https:/") == 0;
			}
			if (_tmp27_) {
				is_valid = TRUE;
			}
		}
	}
	_tmp30_ = self->priv->url;
	_tmp31_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, gtk_widget_get_type (), GtkWidget));
	_tmp32_ = _g_object_ref0 (_tmp31_);
	style = _tmp32_;
	pos = GTK_ENTRY_ICON_SECONDARY;
	if (!is_valid) {
		GtkStyleContext* _tmp33_;
		GtkStyleContext* _tmp34_;
		GtkEntry* _tmp35_;
		GtkEntry* _tmp36_;
		_tmp33_ = style;
		gtk_style_context_add_class (_tmp33_, GTK_STYLE_CLASS_ERROR);
		_tmp34_ = style;
		gtk_style_context_remove_class (_tmp34_, GTK_STYLE_CLASS_WARNING);
		_tmp35_ = self->priv->url;
		gtk_entry_set_icon_from_icon_name (_tmp35_, pos, "dialog-error-symbolic");
		_tmp36_ = self->priv->url;
		gtk_widget_set_tooltip_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, gtk_widget_get_type (), GtkWidget), _ ("Link URL is not correctly formatted, e.g. http://example.com"));
	} else {
		if (!is_nominal) {
			GtkStyleContext* _tmp37_;
			GtkStyleContext* _tmp38_;
			GtkEntry* _tmp39_;
			const gchar* _tmp40_ = NULL;
			GtkEntry* _tmp41_;
			_tmp37_ = style;
			gtk_style_context_remove_class (_tmp37_, GTK_STYLE_CLASS_ERROR);
			_tmp38_ = style;
			gtk_style_context_add_class (_tmp38_, GTK_STYLE_CLASS_WARNING);
			_tmp39_ = self->priv->url;
			gtk_entry_set_icon_from_icon_name (_tmp39_, pos, "dialog-warning-symbolic");
			if (!is_mailto) {
				_tmp40_ = _ ("Invalid link URL");
			} else {
				_tmp40_ = _ ("Invalid email address");
			}
			_tmp41_ = self->priv->url;
			gtk_widget_set_tooltip_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, gtk_widget_get_type (), GtkWidget), _tmp40_);
		} else {
			GtkStyleContext* _tmp42_;
			GtkStyleContext* _tmp43_;
			GtkEntry* _tmp44_;
			GtkEntry* _tmp45_;
			_tmp42_ = style;
			gtk_style_context_remove_class (_tmp42_, GTK_STYLE_CLASS_ERROR);
			_tmp43_ = style;
			gtk_style_context_remove_class (_tmp43_, GTK_STYLE_CLASS_WARNING);
			_tmp44_ = self->priv->url;
			gtk_entry_set_icon_from_icon_name (_tmp44_, pos, NULL);
			_tmp45_ = self->priv->url;
			gtk_widget_set_tooltip_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, gtk_widget_get_type (), GtkWidget), "");
		}
	}
	if (is_valid) {
		_tmp46_ = is_nominal;
	} else {
		_tmp46_ = FALSE;
	}
	_tmp47_ = url;
	g_signal_emit (self, composer_link_popover_signals[COMPOSER_LINK_POPOVER_LINK_CHANGED_SIGNAL], 0, _tmp47_, _tmp46_);
	_g_object_unref0 (style);
	_g_uri_unref0 (url);
	_g_free0 (text);
}

static void
composer_link_popover_on_url_changed (ComposerLinkPopover* self)
{
	GearyTimeoutManager* _tmp0_;
	g_return_if_fail (COMPOSER_IS_LINK_POPOVER (self));
	_tmp0_ = self->priv->validation_timeout;
	geary_timeout_manager_start (_tmp0_);
}

static void
_composer_link_popover_on_url_changed_gtk_editable_changed (GtkEditable* _sender,
                                                            gpointer self)
{
	composer_link_popover_on_url_changed ((ComposerLinkPopover*) self);
}

static void
composer_link_popover_on_activate_popover (ComposerLinkPopover* self)
{
	g_return_if_fail (COMPOSER_IS_LINK_POPOVER (self));
	g_signal_emit (self, composer_link_popover_signals[COMPOSER_LINK_POPOVER_LINK_ACTIVATE_SIGNAL], 0);
	gtk_popover_popdown (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_popover_get_type (), GtkPopover));
}

static void
_composer_link_popover_on_activate_popover_gtk_button_clicked (GtkButton* _sender,
                                                               gpointer self)
{
	composer_link_popover_on_activate_popover ((ComposerLinkPopover*) self);
}

static void
composer_link_popover_on_remove_clicked (ComposerLinkPopover* self)
{
	g_return_if_fail (COMPOSER_IS_LINK_POPOVER (self));
	g_signal_emit (self, composer_link_popover_signals[COMPOSER_LINK_POPOVER_LINK_DELETE_SIGNAL], 0);
	gtk_popover_popdown (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_popover_get_type (), GtkPopover));
}

static void
_composer_link_popover_on_remove_clicked_gtk_button_clicked (GtkButton* _sender,
                                                             gpointer self)
{
	composer_link_popover_on_remove_clicked ((ComposerLinkPopover*) self);
}

static void
composer_link_popover_class_init (ComposerLinkPopoverClass * klass,
                                  gpointer klass_data)
{
	composer_link_popover_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ComposerLinkPopover_private_offset);
	((GtkWidgetClass *) klass)->show = (void (*) (GtkWidget*)) composer_link_popover_real_show;
	((GtkWidgetClass *) klass)->destroy = (void (*) (GtkWidget*)) composer_link_popover_real_destroy;
	G_OBJECT_CLASS (klass)->get_property = _vala_composer_link_popover_get_property;
	G_OBJECT_CLASS (klass)->finalize = composer_link_popover_finalize;
	/** The URL displayed in the popover */
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMPOSER_LINK_POPOVER_LINK_URI_PROPERTY, composer_link_popover_properties[COMPOSER_LINK_POPOVER_LINK_URI_PROPERTY] = g_param_spec_string ("link-uri", "link-uri", "link-uri", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Geary/composer-link-popover.ui");
	/** Emitted when the link URL has changed. */
	composer_link_popover_signals[COMPOSER_LINK_POPOVER_LINK_CHANGED_SIGNAL] = g_signal_new ("link-changed", COMPOSER_TYPE_LINK_POPOVER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOXED_BOOLEAN, G_TYPE_NONE, 2, G_TYPE_URI, G_TYPE_BOOLEAN);
	/** Emitted when the link URL was activated. */
	composer_link_popover_signals[COMPOSER_LINK_POPOVER_LINK_ACTIVATE_SIGNAL] = g_signal_new ("link-activate", COMPOSER_TYPE_LINK_POPOVER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	/** Emitted when the delete button was activated. */
	composer_link_popover_signals[COMPOSER_LINK_POPOVER_LINK_DELETE_SIGNAL] = g_signal_new ("link-delete", COMPOSER_TYPE_LINK_POPOVER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "url", FALSE, ComposerLinkPopover_private_offset + G_STRUCT_OFFSET (ComposerLinkPopoverPrivate, url));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "insert", FALSE, ComposerLinkPopover_private_offset + G_STRUCT_OFFSET (ComposerLinkPopoverPrivate, insert));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "update", FALSE, ComposerLinkPopover_private_offset + G_STRUCT_OFFSET (ComposerLinkPopoverPrivate, update));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "remove", FALSE, ComposerLinkPopover_private_offset + G_STRUCT_OFFSET (ComposerLinkPopoverPrivate, remove));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_url_changed", G_CALLBACK(_composer_link_popover_on_url_changed_gtk_editable_changed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_activate_popover", G_CALLBACK(_composer_link_popover_on_activate_popover_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_remove_clicked", G_CALLBACK(_composer_link_popover_on_remove_clicked_gtk_button_clicked));
}

static void
composer_link_popover_instance_init (ComposerLinkPopover * self,
                                     gpointer klass)
{
	self->priv = composer_link_popover_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
composer_link_popover_finalize (GObject * obj)
{
	ComposerLinkPopover * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, COMPOSER_TYPE_LINK_POPOVER, ComposerLinkPopover);
	_g_object_unref0 (self->priv->validation_timeout);
	G_OBJECT_CLASS (composer_link_popover_parent_class)->finalize (obj);
}

/**
 * A popover for editing a link in the composer.
 *
 * The exact appearance of the popover will depend on the {@link
 * Type} passed to the constructor:
 *
 *  * For {@link Type.NEW_LINK}, the user will be presented with an
 *    insert button and an open button.
 *  * For {@link Type.EXISTING_LINK}, the user will be presented with
 *    an update, delete and open buttons.
 */
static GType
composer_link_popover_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ComposerLinkPopoverClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) composer_link_popover_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ComposerLinkPopover), 0, (GInstanceInitFunc) composer_link_popover_instance_init, NULL };
	GType composer_link_popover_type_id;
	composer_link_popover_type_id = g_type_register_static (gtk_popover_get_type (), "ComposerLinkPopover", &g_define_type_info, 0);
	ComposerLinkPopover_private_offset = g_type_add_instance_private (composer_link_popover_type_id, sizeof (ComposerLinkPopoverPrivate));
	return composer_link_popover_type_id;
}

GType
composer_link_popover_get_type (void)
{
	static volatile gsize composer_link_popover_type_id__once = 0;
	if (g_once_init_enter (&composer_link_popover_type_id__once)) {
		GType composer_link_popover_type_id;
		composer_link_popover_type_id = composer_link_popover_get_type_once ();
		g_once_init_leave (&composer_link_popover_type_id__once, composer_link_popover_type_id);
	}
	return composer_link_popover_type_id__once;
}

static void
_vala_composer_link_popover_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	ComposerLinkPopover * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, COMPOSER_TYPE_LINK_POPOVER, ComposerLinkPopover);
	switch (property_id) {
		case COMPOSER_LINK_POPOVER_LINK_URI_PROPERTY:
		g_value_set_string (value, composer_link_popover_get_link_uri (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

