/* conversation-contact-popover.c generated by valac 0.56.3, the Vala compiler
 * generated from conversation-contact-popover.vala, do not modify */

/*
 * Copyright 2019 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-client-43.0.h"
#include "geary-engine.h"
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <handy.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <gdk/gdk.h>

#define CONVERSATION_CONTACT_POPOVER_ACTION_COPY_EMAIL "copy-email"
#define CONVERSATION_CONTACT_POPOVER_ACTION_LOAD_REMOTE "load-remote"
#define CONVERSATION_CONTACT_POPOVER_ACTION_NEW_CONVERSATION "new-conversation"
#define CONVERSATION_CONTACT_POPOVER_ACTION_OPEN "open"
#define CONVERSATION_CONTACT_POPOVER_ACTION_SAVE "save"
#define CONVERSATION_CONTACT_POPOVER_ACTION_SHOW_CONVERSATIONS "show-conversations"
#define CONVERSATION_CONTACT_POPOVER_ACTION_STAR "star"
#define CONVERSATION_CONTACT_POPOVER_ACTION_UNSTAR "unstar"
#define CONVERSATION_CONTACT_POPOVER_ACTION_GROUP "con"

enum  {
	CONVERSATION_CONTACT_POPOVER_0_PROPERTY,
	CONVERSATION_CONTACT_POPOVER_CONTACT_PROPERTY,
	CONVERSATION_CONTACT_POPOVER_MAILBOX_PROPERTY,
	CONVERSATION_CONTACT_POPOVER_NUM_PROPERTIES
};
static GParamSpec* conversation_contact_popover_properties[CONVERSATION_CONTACT_POPOVER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ConversationContactPopoverOpenData ConversationContactPopoverOpenData;
typedef struct _ConversationContactPopoverSaveData ConversationContactPopoverSaveData;
typedef struct _ConversationContactPopoverSetLoadRemoteResourcesData ConversationContactPopoverSetLoadRemoteResourcesData;
typedef struct _ConversationContactPopoverSetFavouriteData ConversationContactPopoverSetFavouriteData;
enum  {
	CONVERSATION_CONTACT_POPOVER_LOAD_REMOTE_RESOURCES_CHANGED_SIGNAL,
	CONVERSATION_CONTACT_POPOVER_NUM_SIGNALS
};
static guint conversation_contact_popover_signals[CONVERSATION_CONTACT_POPOVER_NUM_SIGNALS] = {0};

struct _ConversationContactPopoverPrivate {
	ApplicationContact* _contact;
	GearyRFC822MailboxAddress* _mailbox;
	GCancellable* load_cancellable;
	ApplicationConfiguration* config;
	GtkGrid* contact_pane;
	HdyAvatar* avatar;
	GtkLabel* contact_name;
	GtkLabel* contact_address;
	GtkButton* starred_button;
	GtkButton* unstarred_button;
	GtkModelButton* open_button;
	GtkModelButton* save_button;
	GtkModelButton* load_remote_button;
	GtkGrid* deceptive_pane;
	GtkLabel* forged_email_label;
	GtkLabel* actual_email_label;
	GSimpleActionGroup* actions;
};

struct _ConversationContactPopoverOpenData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ConversationContactPopover* self;
	ApplicationContact* _tmp0_;
	GError* err;
	ApplicationContact* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GError* _tmp4_;
	const gchar* _tmp5_;
	GError* _inner_error0_;
};

struct _ConversationContactPopoverSaveData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ConversationContactPopover* self;
	ApplicationContact* _tmp0_;
	GError* err;
	ApplicationContact* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GError* _tmp4_;
	const gchar* _tmp5_;
	GError* _inner_error0_;
};

struct _ConversationContactPopoverSetLoadRemoteResourcesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ConversationContactPopover* self;
	gboolean enabled;
	GeeCollection* email_addresses;
	ApplicationContact* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	GeeCollection* _tmp3_;
	GeeIterator* _email_it;
	GeeCollection* _tmp4_;
	GeeIterator* _tmp5_;
	GeeIterator* _tmp6_;
	GearyRFC822MailboxAddress* email;
	GeeIterator* _tmp7_;
	gpointer _tmp8_;
	ApplicationConfiguration* _tmp9_;
	GearyRFC822MailboxAddress* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	ApplicationContact* _tmp13_;
	GError* err;
	ApplicationContact* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	GError* _tmp17_;
	const gchar* _tmp18_;
	GError* _inner_error0_;
};

struct _ConversationContactPopoverSetFavouriteData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ConversationContactPopover* self;
	gboolean enabled;
	ApplicationContact* _tmp0_;
	GError* err;
	ApplicationContact* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GError* _tmp4_;
	const gchar* _tmp5_;
	GError* _inner_error0_;
};

static gint ConversationContactPopover_private_offset;
static gpointer conversation_contact_popover_parent_class = NULL;

static void conversation_contact_popover_on_copy_email (ConversationContactPopover* self);
static void _conversation_contact_popover_on_copy_email_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                   GVariant* parameter,
                                                                                   gpointer self);
static void conversation_contact_popover_on_load_remote (ConversationContactPopover* self,
                                                  GSimpleAction* action);
static void _conversation_contact_popover_on_load_remote_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                    GVariant* parameter,
                                                                                    gpointer self);
static void conversation_contact_popover_on_new_conversation (ConversationContactPopover* self);
static void _conversation_contact_popover_on_new_conversation_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                         GVariant* parameter,
                                                                                         gpointer self);
static void conversation_contact_popover_on_open (ConversationContactPopover* self);
static void _conversation_contact_popover_on_open_gsimple_action_activate_callback (GSimpleAction* action,
                                                                             GVariant* parameter,
                                                                             gpointer self);
static void conversation_contact_popover_on_save (ConversationContactPopover* self);
static void _conversation_contact_popover_on_save_gsimple_action_activate_callback (GSimpleAction* action,
                                                                             GVariant* parameter,
                                                                             gpointer self);
static void conversation_contact_popover_on_show_conversations (ConversationContactPopover* self);
static void _conversation_contact_popover_on_show_conversations_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                           GVariant* parameter,
                                                                                           gpointer self);
static void conversation_contact_popover_on_star (ConversationContactPopover* self);
static void _conversation_contact_popover_on_star_gsimple_action_activate_callback (GSimpleAction* action,
                                                                             GVariant* parameter,
                                                                             gpointer self);
static void conversation_contact_popover_on_unstar (ConversationContactPopover* self);
static void _conversation_contact_popover_on_unstar_gsimple_action_activate_callback (GSimpleAction* action,
                                                                               GVariant* parameter,
                                                                               gpointer self);
static void conversation_contact_popover_set_contact (ConversationContactPopover* self,
                                               ApplicationContact* value);
static void conversation_contact_popover_set_mailbox (ConversationContactPopover* self,
                                               GearyRFC822MailboxAddress* value);
static void conversation_contact_popover_on_contact_changed (ConversationContactPopover* self);
static void _conversation_contact_popover_on_contact_changed_application_contact_changed (ApplicationContact* _sender,
                                                                                   gpointer self);
static void conversation_contact_popover_update (ConversationContactPopover* self);
static void conversation_contact_popover_real_destroy (GtkWidget* base);
static void conversation_contact_popover_open_data_free (gpointer _data);
static void conversation_contact_popover_open (ConversationContactPopover* self,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
static void conversation_contact_popover_open_finish (ConversationContactPopover* self,
                                               GAsyncResult* _res_);
static gboolean conversation_contact_popover_open_co (ConversationContactPopoverOpenData* _data_);
static void conversation_contact_popover_open_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_);
static void conversation_contact_popover_save_data_free (gpointer _data);
static void conversation_contact_popover_save (ConversationContactPopover* self,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
static void conversation_contact_popover_save_finish (ConversationContactPopover* self,
                                               GAsyncResult* _res_);
static gboolean conversation_contact_popover_save_co (ConversationContactPopoverSaveData* _data_);
static void conversation_contact_popover_save_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_);
static void conversation_contact_popover_set_load_remote_resources_data_free (gpointer _data);
static void conversation_contact_popover_set_load_remote_resources (ConversationContactPopover* self,
                                                             gboolean enabled,
                                                             GAsyncReadyCallback _callback_,
                                                             gpointer _user_data_);
static void conversation_contact_popover_set_load_remote_resources_finish (ConversationContactPopover* self,
                                                                    GAsyncResult* _res_);
static gboolean conversation_contact_popover_set_load_remote_resources_co (ConversationContactPopoverSetLoadRemoteResourcesData* _data_);
static void conversation_contact_popover_set_load_remote_resources_ready (GObject* source_object,
                                                                   GAsyncResult* _res_,
                                                                   gpointer _user_data_);
static void conversation_contact_popover_set_favourite_data_free (gpointer _data);
static void conversation_contact_popover_set_favourite (ConversationContactPopover* self,
                                                 gboolean enabled,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_);
static void conversation_contact_popover_set_favourite_finish (ConversationContactPopover* self,
                                                        GAsyncResult* _res_);
static gboolean conversation_contact_popover_set_favourite_co (ConversationContactPopoverSetFavouriteData* _data_);
static void conversation_contact_popover_set_favourite_ready (GObject* source_object,
                                                       GAsyncResult* _res_,
                                                       gpointer _user_data_);
static void conversation_contact_popover_after_closed (ConversationContactPopover* self);
static gboolean __lambda116_ (ConversationContactPopover* self);
static gboolean ___lambda116__gsource_func (gpointer self);
static void _conversation_contact_popover_after_closed_gtk_popover_closed (GtkPopover* _sender,
                                                                    gpointer self);
static void conversation_contact_popover_finalize (GObject * obj);
static GType conversation_contact_popover_get_type_once (void);
static void _vala_conversation_contact_popover_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec);
static void _vala_conversation_contact_popover_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec);

static const GActionEntry CONVERSATION_CONTACT_POPOVER_ACTION_ENTRIES[8] = {{CONVERSATION_CONTACT_POPOVER_ACTION_COPY_EMAIL, _conversation_contact_popover_on_copy_email_gsimple_action_activate_callback}, {CONVERSATION_CONTACT_POPOVER_ACTION_LOAD_REMOTE, _conversation_contact_popover_on_load_remote_gsimple_action_activate_callback, NULL, "false"}, {CONVERSATION_CONTACT_POPOVER_ACTION_NEW_CONVERSATION, _conversation_contact_popover_on_new_conversation_gsimple_action_activate_callback}, {CONVERSATION_CONTACT_POPOVER_ACTION_OPEN, _conversation_contact_popover_on_open_gsimple_action_activate_callback}, {CONVERSATION_CONTACT_POPOVER_ACTION_SAVE, _conversation_contact_popover_on_save_gsimple_action_activate_callback}, {CONVERSATION_CONTACT_POPOVER_ACTION_SHOW_CONVERSATIONS, _conversation_contact_popover_on_show_conversations_gsimple_action_activate_callback}, {CONVERSATION_CONTACT_POPOVER_ACTION_STAR, _conversation_contact_popover_on_star_gsimple_action_activate_callback}, {CONVERSATION_CONTACT_POPOVER_ACTION_UNSTAR, _conversation_contact_popover_on_unstar_gsimple_action_activate_callback}};

static inline gpointer
conversation_contact_popover_get_instance_private (ConversationContactPopover* self)
{
	return G_STRUCT_MEMBER_P (self, ConversationContactPopover_private_offset);
}

static void
_conversation_contact_popover_on_copy_email_gsimple_action_activate_callback (GSimpleAction* action,
                                                                              GVariant* parameter,
                                                                              gpointer self)
{
	conversation_contact_popover_on_copy_email ((ConversationContactPopover*) self);
}

static void
_conversation_contact_popover_on_load_remote_gsimple_action_activate_callback (GSimpleAction* action,
                                                                               GVariant* parameter,
                                                                               gpointer self)
{
	conversation_contact_popover_on_load_remote ((ConversationContactPopover*) self, action);
}

static void
_conversation_contact_popover_on_new_conversation_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                    GVariant* parameter,
                                                                                    gpointer self)
{
	conversation_contact_popover_on_new_conversation ((ConversationContactPopover*) self);
}

static void
_conversation_contact_popover_on_open_gsimple_action_activate_callback (GSimpleAction* action,
                                                                        GVariant* parameter,
                                                                        gpointer self)
{
	conversation_contact_popover_on_open ((ConversationContactPopover*) self);
}

static void
_conversation_contact_popover_on_save_gsimple_action_activate_callback (GSimpleAction* action,
                                                                        GVariant* parameter,
                                                                        gpointer self)
{
	conversation_contact_popover_on_save ((ConversationContactPopover*) self);
}

static void
_conversation_contact_popover_on_show_conversations_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                      GVariant* parameter,
                                                                                      gpointer self)
{
	conversation_contact_popover_on_show_conversations ((ConversationContactPopover*) self);
}

static void
_conversation_contact_popover_on_star_gsimple_action_activate_callback (GSimpleAction* action,
                                                                        GVariant* parameter,
                                                                        gpointer self)
{
	conversation_contact_popover_on_star ((ConversationContactPopover*) self);
}

static void
_conversation_contact_popover_on_unstar_gsimple_action_activate_callback (GSimpleAction* action,
                                                                          GVariant* parameter,
                                                                          gpointer self)
{
	conversation_contact_popover_on_unstar ((ConversationContactPopover*) self);
}

ApplicationContact*
conversation_contact_popover_get_contact (ConversationContactPopover* self)
{
	ApplicationContact* result;
	ApplicationContact* _tmp0_;
	g_return_val_if_fail (CONVERSATION_IS_CONTACT_POPOVER (self), NULL);
	_tmp0_ = self->priv->_contact;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
conversation_contact_popover_set_contact (ConversationContactPopover* self,
                                          ApplicationContact* value)
{
	ApplicationContact* old_value;
	g_return_if_fail (CONVERSATION_IS_CONTACT_POPOVER (self));
	old_value = conversation_contact_popover_get_contact (self);
	if (old_value != value) {
		ApplicationContact* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_contact);
		self->priv->_contact = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, conversation_contact_popover_properties[CONVERSATION_CONTACT_POPOVER_CONTACT_PROPERTY]);
	}
}

GearyRFC822MailboxAddress*
conversation_contact_popover_get_mailbox (ConversationContactPopover* self)
{
	GearyRFC822MailboxAddress* result;
	GearyRFC822MailboxAddress* _tmp0_;
	g_return_val_if_fail (CONVERSATION_IS_CONTACT_POPOVER (self), NULL);
	_tmp0_ = self->priv->_mailbox;
	result = _tmp0_;
	return result;
}

static void
conversation_contact_popover_set_mailbox (ConversationContactPopover* self,
                                          GearyRFC822MailboxAddress* value)
{
	GearyRFC822MailboxAddress* old_value;
	g_return_if_fail (CONVERSATION_IS_CONTACT_POPOVER (self));
	old_value = conversation_contact_popover_get_mailbox (self);
	if (old_value != value) {
		GearyRFC822MailboxAddress* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_mailbox);
		self->priv->_mailbox = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, conversation_contact_popover_properties[CONVERSATION_CONTACT_POPOVER_MAILBOX_PROPERTY]);
	}
}

static void
_conversation_contact_popover_on_contact_changed_application_contact_changed (ApplicationContact* _sender,
                                                                              gpointer self)
{
	conversation_contact_popover_on_contact_changed ((ConversationContactPopover*) self);
}

ConversationContactPopover*
conversation_contact_popover_construct (GType object_type,
                                        GtkWidget* relative_to,
                                        ApplicationContact* contact,
                                        GearyRFC822MailboxAddress* mailbox,
                                        ApplicationConfiguration* config)
{
	ConversationContactPopover * self = NULL;
	ApplicationConfiguration* _tmp0_;
	GtkModelButton* _tmp1_;
	ApplicationContact* _tmp2_;
	HdyAvatar* _tmp3_;
	ApplicationContact* _tmp4_;
	HdyAvatar* _tmp5_;
	GSimpleActionGroup* _tmp6_;
	GSimpleActionGroup* _tmp7_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (relative_to, gtk_widget_get_type ()), NULL);
	g_return_val_if_fail (APPLICATION_IS_CONTACT (contact), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (mailbox, GEARY_RF_C822_TYPE_MAILBOX_ADDRESS), NULL);
	g_return_val_if_fail (APPLICATION_IS_CONFIGURATION (config), NULL);
	self = (ConversationContactPopover*) g_object_new (object_type, NULL);
	gtk_popover_set_relative_to (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_popover_get_type (), GtkPopover), relative_to);
	conversation_contact_popover_set_contact (self, contact);
	conversation_contact_popover_set_mailbox (self, mailbox);
	_tmp0_ = _g_object_ref0 (config);
	_g_object_unref0 (self->priv->config);
	self->priv->config = _tmp0_;
	_tmp1_ = self->priv->load_remote_button;
	g_object_set (_tmp1_, "role", GTK_BUTTON_ROLE_CHECK, NULL);
	_tmp2_ = self->priv->_contact;
	_tmp3_ = self->priv->avatar;
	g_object_bind_property_with_closures (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, G_TYPE_OBJECT, GObject), "display-name", G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, G_TYPE_OBJECT, GObject), "text", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp4_ = self->priv->_contact;
	_tmp5_ = self->priv->avatar;
	g_object_bind_property_with_closures (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, G_TYPE_OBJECT, GObject), "avatar", G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, G_TYPE_OBJECT, GObject), "loadable-icon", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp6_ = self->priv->actions;
	g_action_map_add_action_entries (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, g_action_map_get_type (), GActionMap), CONVERSATION_CONTACT_POPOVER_ACTION_ENTRIES, (gint) G_N_ELEMENTS (CONVERSATION_CONTACT_POPOVER_ACTION_ENTRIES), self);
	_tmp7_ = self->priv->actions;
	gtk_widget_insert_action_group (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), CONVERSATION_CONTACT_POPOVER_ACTION_GROUP, G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, g_action_group_get_type (), GActionGroup));
	g_signal_connect_object (contact, "changed", (GCallback) _conversation_contact_popover_on_contact_changed_application_contact_changed, self, 0);
	conversation_contact_popover_update (self);
	return self;
}

ConversationContactPopover*
conversation_contact_popover_new (GtkWidget* relative_to,
                                  ApplicationContact* contact,
                                  GearyRFC822MailboxAddress* mailbox,
                                  ApplicationConfiguration* config)
{
	return conversation_contact_popover_construct (CONVERSATION_TYPE_CONTACT_POPOVER, relative_to, contact, mailbox, config);
}

/**
     * Starts loading the avatar for the message's sender.
     */
static void
conversation_contact_popover_real_destroy (GtkWidget* base)
{
	ConversationContactPopover * self;
	ApplicationContact* _tmp0_;
	guint _tmp1_;
	GCancellable* _tmp2_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CONVERSATION_TYPE_CONTACT_POPOVER, ConversationContactPopover);
	_tmp0_ = self->priv->_contact;
	g_signal_parse_name ("changed", APPLICATION_TYPE_CONTACT, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _conversation_contact_popover_on_contact_changed_application_contact_changed, self);
	_tmp2_ = self->priv->load_cancellable;
	g_cancellable_cancel (_tmp2_);
	GTK_WIDGET_CLASS (conversation_contact_popover_parent_class)->destroy (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_popover_get_type (), GtkPopover), gtk_widget_get_type (), GtkWidget));
}

static void
conversation_contact_popover_update (ConversationContactPopover* self)
{
	GearyRFC822MailboxAddress* _tmp0_;
	g_return_if_fail (CONVERSATION_IS_CONTACT_POPOVER (self));
	_tmp0_ = self->priv->_mailbox;
	if (!geary_rf_c822_mailbox_address_is_spoofed (_tmp0_)) {
		GtkGrid* _tmp1_;
		GtkGrid* _tmp2_;
		gchar* display_name = NULL;
		ApplicationContact* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		GtkLabel* _tmp7_;
		const gchar* _tmp8_;
		ApplicationContact* _tmp9_;
		gboolean _tmp10_;
		gboolean _tmp11_;
		gboolean is_desktop = FALSE;
		ApplicationContact* _tmp19_;
		gboolean _tmp20_;
		gboolean _tmp21_;
		gboolean starred = FALSE;
		gboolean unstarred = FALSE;
		GtkButton* _tmp28_;
		GtkButton* _tmp29_;
		GtkModelButton* _tmp30_;
		GtkModelButton* _tmp31_;
		GtkModelButton* _tmp32_;
		GSimpleAction* load_remote = NULL;
		GSimpleActionGroup* _tmp33_;
		GAction* _tmp34_;
		GSimpleAction* _tmp35_;
		gboolean _tmp36_ = FALSE;
		GSimpleAction* _tmp39_;
		GVariant* _tmp40_;
		GVariant* _tmp41_;
		_tmp1_ = self->priv->contact_pane;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget));
		_tmp2_ = self->priv->deceptive_pane;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget));
		_tmp3_ = self->priv->_contact;
		_tmp4_ = application_contact_get_display_name (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strdup (_tmp5_);
		display_name = _tmp6_;
		_tmp7_ = self->priv->contact_name;
		_tmp8_ = display_name;
		gtk_label_set_text (_tmp7_, _tmp8_);
		_tmp9_ = self->priv->_contact;
		_tmp10_ = application_contact_get_display_name_is_email (_tmp9_);
		_tmp11_ = _tmp10_;
		if (!_tmp11_) {
			GtkLabel* _tmp12_;
			GearyRFC822MailboxAddress* _tmp13_;
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			_tmp12_ = self->priv->contact_address;
			_tmp13_ = self->priv->_mailbox;
			_tmp14_ = geary_rf_c822_mailbox_address_get_address (_tmp13_);
			_tmp15_ = _tmp14_;
			gtk_label_set_text (_tmp12_, _tmp15_);
		} else {
			GtkLabel* _tmp16_;
			GtkLabel* _tmp17_;
			GtkLabel* _tmp18_;
			_tmp16_ = self->priv->contact_name;
			gtk_widget_set_vexpand (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_widget_get_type (), GtkWidget), TRUE);
			_tmp17_ = self->priv->contact_name;
			gtk_widget_set_valign (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_FILL);
			_tmp18_ = self->priv->contact_address;
			gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_widget_get_type (), GtkWidget));
		}
		_tmp19_ = self->priv->_contact;
		_tmp20_ = application_contact_get_is_desktop_contact (_tmp19_);
		_tmp21_ = _tmp20_;
		is_desktop = _tmp21_;
		starred = FALSE;
		unstarred = FALSE;
		if (is_desktop) {
			ApplicationContact* _tmp22_;
			gboolean _tmp23_;
			gboolean _tmp24_;
			ApplicationContact* _tmp25_;
			gboolean _tmp26_;
			gboolean _tmp27_;
			_tmp22_ = self->priv->_contact;
			_tmp23_ = application_contact_get_is_favourite (_tmp22_);
			_tmp24_ = _tmp23_;
			starred = _tmp24_;
			_tmp25_ = self->priv->_contact;
			_tmp26_ = application_contact_get_is_favourite (_tmp25_);
			_tmp27_ = _tmp26_;
			unstarred = !_tmp27_;
		}
		_tmp28_ = self->priv->starred_button;
		gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, gtk_widget_get_type (), GtkWidget), starred);
		_tmp29_ = self->priv->unstarred_button;
		gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, gtk_widget_get_type (), GtkWidget), unstarred);
		_tmp30_ = self->priv->open_button;
		gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, gtk_widget_get_type (), GtkWidget), is_desktop);
		_tmp31_ = self->priv->save_button;
		gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, gtk_widget_get_type (), GtkWidget), !is_desktop);
		_tmp32_ = self->priv->load_remote_button;
		gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, gtk_widget_get_type (), GtkWidget), !is_desktop);
		_tmp33_ = self->priv->actions;
		_tmp34_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, g_action_map_get_type (), GActionMap), CONVERSATION_CONTACT_POPOVER_ACTION_LOAD_REMOTE);
		_tmp35_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, g_simple_action_get_type (), GSimpleAction));
		load_remote = _tmp35_;
		if (is_desktop) {
			_tmp36_ = TRUE;
		} else {
			ApplicationContact* _tmp37_;
			ApplicationConfiguration* _tmp38_;
			_tmp37_ = self->priv->_contact;
			_tmp38_ = self->priv->config;
			_tmp36_ = util_contact_should_load_images (_tmp37_, _tmp38_);
		}
		_tmp39_ = load_remote;
		_tmp40_ = g_variant_new_boolean (_tmp36_);
		g_variant_ref_sink (_tmp40_);
		_tmp41_ = _tmp40_;
		g_simple_action_set_state (_tmp39_, _tmp41_);
		_g_variant_unref0 (_tmp41_);
		_g_object_unref0 (load_remote);
		_g_free0 (display_name);
	} else {
		GtkGrid* _tmp42_;
		GtkGrid* _tmp43_;
		GtkLabel* _tmp44_;
		GearyRFC822MailboxAddress* _tmp45_;
		const gchar* _tmp46_;
		const gchar* _tmp47_;
		gchar* _tmp48_;
		gchar* _tmp49_;
		GtkLabel* _tmp50_;
		GearyRFC822MailboxAddress* _tmp51_;
		const gchar* _tmp52_;
		const gchar* _tmp53_;
		_tmp42_ = self->priv->deceptive_pane;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, gtk_widget_get_type (), GtkWidget));
		_tmp43_ = self->priv->contact_pane;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, gtk_widget_get_type (), GtkWidget));
		_tmp44_ = self->priv->forged_email_label;
		_tmp45_ = self->priv->_mailbox;
		_tmp46_ = geary_rf_c822_mailbox_address_get_name (_tmp45_);
		_tmp47_ = _tmp46_;
		_tmp48_ = geary_string_reduce_whitespace (_tmp47_);
		_tmp49_ = _tmp48_;
		gtk_label_set_label (_tmp44_, _tmp49_);
		_g_free0 (_tmp49_);
		_tmp50_ = self->priv->actual_email_label;
		_tmp51_ = self->priv->_mailbox;
		_tmp52_ = geary_rf_c822_mailbox_address_get_address (_tmp51_);
		_tmp53_ = _tmp52_;
		gtk_label_set_label (_tmp50_, _tmp53_);
	}
}

static void
conversation_contact_popover_open_data_free (gpointer _data)
{
	ConversationContactPopoverOpenData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ConversationContactPopoverOpenData, _data_);
}

static void
conversation_contact_popover_open (ConversationContactPopover* self,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	ConversationContactPopoverOpenData* _data_;
	ConversationContactPopover* _tmp0_;
	g_return_if_fail (CONVERSATION_IS_CONTACT_POPOVER (self));
	_data_ = g_slice_new0 (ConversationContactPopoverOpenData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, conversation_contact_popover_open_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	conversation_contact_popover_open_co (_data_);
}

static void
conversation_contact_popover_open_finish (ConversationContactPopover* self,
                                          GAsyncResult* _res_)
{
	ConversationContactPopoverOpenData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
conversation_contact_popover_open_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_)
{
	ConversationContactPopoverOpenData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	conversation_contact_popover_open_co (_data_);
}

static gboolean
conversation_contact_popover_open_co (ConversationContactPopoverOpenData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->self->priv->_contact;
		_data_->_state_ = 1;
		application_contact_open_on_desktop (_data_->_tmp0_, NULL, conversation_contact_popover_open_ready, _data_);
		return FALSE;
		_state_1:
		application_contact_open_on_desktop_finish (_data_->_tmp0_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp1_ = _data_->self->priv->_contact;
		_data_->_tmp2_ = application_contact_to_string (_data_->_tmp1_);
		_data_->_tmp3_ = _data_->_tmp2_;
		_data_->_tmp4_ = _data_->err;
		_data_->_tmp5_ = _data_->_tmp4_->message;
		g_debug ("conversation-contact-popover.vala:171: Failed to open desktop app for " \
"showing contact %s:, %s", _data_->_tmp3_, _data_->_tmp5_);
		_g_free0 (_data_->_tmp3_);
		_g_error_free0 (_data_->err);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
conversation_contact_popover_save_data_free (gpointer _data)
{
	ConversationContactPopoverSaveData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ConversationContactPopoverSaveData, _data_);
}

static void
conversation_contact_popover_save (ConversationContactPopover* self,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	ConversationContactPopoverSaveData* _data_;
	ConversationContactPopover* _tmp0_;
	g_return_if_fail (CONVERSATION_IS_CONTACT_POPOVER (self));
	_data_ = g_slice_new0 (ConversationContactPopoverSaveData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, conversation_contact_popover_save_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	conversation_contact_popover_save_co (_data_);
}

static void
conversation_contact_popover_save_finish (ConversationContactPopover* self,
                                          GAsyncResult* _res_)
{
	ConversationContactPopoverSaveData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
conversation_contact_popover_save_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_)
{
	ConversationContactPopoverSaveData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	conversation_contact_popover_save_co (_data_);
}

static gboolean
conversation_contact_popover_save_co (ConversationContactPopoverSaveData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->self->priv->_contact;
		_data_->_state_ = 1;
		application_contact_save_to_desktop (_data_->_tmp0_, NULL, conversation_contact_popover_save_ready, _data_);
		return FALSE;
		_state_1:
		application_contact_save_to_desktop_finish (_data_->_tmp0_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp1_ = _data_->self->priv->_contact;
		_data_->_tmp2_ = application_contact_to_string (_data_->_tmp1_);
		_data_->_tmp3_ = _data_->_tmp2_;
		_data_->_tmp4_ = _data_->err;
		_data_->_tmp5_ = _data_->_tmp4_->message;
		g_debug ("conversation-contact-popover.vala:180: Failed to open desktop app for " \
"saving contact %s:, %s", _data_->_tmp3_, _data_->_tmp5_);
		_g_free0 (_data_->_tmp3_);
		_g_error_free0 (_data_->err);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
conversation_contact_popover_set_load_remote_resources_data_free (gpointer _data)
{
	ConversationContactPopoverSetLoadRemoteResourcesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ConversationContactPopoverSetLoadRemoteResourcesData, _data_);
}

static void
conversation_contact_popover_set_load_remote_resources (ConversationContactPopover* self,
                                                        gboolean enabled,
                                                        GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_)
{
	ConversationContactPopoverSetLoadRemoteResourcesData* _data_;
	ConversationContactPopover* _tmp0_;
	g_return_if_fail (CONVERSATION_IS_CONTACT_POPOVER (self));
	_data_ = g_slice_new0 (ConversationContactPopoverSetLoadRemoteResourcesData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, conversation_contact_popover_set_load_remote_resources_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->enabled = enabled;
	conversation_contact_popover_set_load_remote_resources_co (_data_);
}

static void
conversation_contact_popover_set_load_remote_resources_finish (ConversationContactPopover* self,
                                                               GAsyncResult* _res_)
{
	ConversationContactPopoverSetLoadRemoteResourcesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
conversation_contact_popover_set_load_remote_resources_ready (GObject* source_object,
                                                              GAsyncResult* _res_,
                                                              gpointer _user_data_)
{
	ConversationContactPopoverSetLoadRemoteResourcesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	conversation_contact_popover_set_load_remote_resources_co (_data_);
}

static gboolean
conversation_contact_popover_set_load_remote_resources_co (ConversationContactPopoverSetLoadRemoteResourcesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		if (!_data_->enabled) {
			_data_->_tmp0_ = _data_->self->priv->_contact;
			_data_->_tmp1_ = application_contact_get_email_addresses (_data_->_tmp0_);
			_data_->_tmp2_ = _data_->_tmp1_;
			_data_->_tmp3_ = _g_object_ref0 (_data_->_tmp2_);
			_data_->email_addresses = _data_->_tmp3_;
			{
				_data_->_tmp4_ = _data_->email_addresses;
				_data_->_tmp5_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp4_, GEE_TYPE_ITERABLE, GeeIterable));
				_data_->_email_it = _data_->_tmp5_;
				while (TRUE) {
					_data_->_tmp6_ = _data_->_email_it;
					if (!gee_iterator_next (_data_->_tmp6_)) {
						break;
					}
					_data_->_tmp7_ = _data_->_email_it;
					_data_->_tmp8_ = gee_iterator_get (_data_->_tmp7_);
					_data_->email = (GearyRFC822MailboxAddress*) _data_->_tmp8_;
					_data_->_tmp9_ = _data_->self->priv->config;
					_data_->_tmp10_ = _data_->email;
					_data_->_tmp11_ = geary_rf_c822_mailbox_address_get_domain (_data_->_tmp10_);
					_data_->_tmp12_ = _data_->_tmp11_;
					application_configuration_remove_images_trusted_domain (_data_->_tmp9_, _data_->_tmp12_);
					_g_object_unref0 (_data_->email);
				}
				_g_object_unref0 (_data_->_email_it);
			}
			_g_object_unref0 (_data_->email_addresses);
		}
		_data_->_tmp13_ = _data_->self->priv->_contact;
		_data_->_state_ = 1;
		application_contact_set_remote_resource_loading (_data_->_tmp13_, _data_->enabled, NULL, conversation_contact_popover_set_load_remote_resources_ready, _data_);
		return FALSE;
		_state_1:
		application_contact_set_remote_resource_loading_finish (_data_->_tmp13_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		g_signal_emit (_data_->self, conversation_contact_popover_signals[CONVERSATION_CONTACT_POPOVER_LOAD_REMOTE_RESOURCES_CHANGED_SIGNAL], 0, _data_->enabled);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp14_ = _data_->self->priv->_contact;
		_data_->_tmp15_ = application_contact_to_string (_data_->_tmp14_);
		_data_->_tmp16_ = _data_->_tmp15_;
		_data_->_tmp17_ = _data_->err;
		_data_->_tmp18_ = _data_->_tmp17_->message;
		g_debug ("conversation-contact-popover.vala:198: Failed to set load remote resou" \
"rces for contact %s:, %s", _data_->_tmp16_, _data_->_tmp18_);
		_g_free0 (_data_->_tmp16_);
		_g_error_free0 (_data_->err);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
conversation_contact_popover_set_favourite_data_free (gpointer _data)
{
	ConversationContactPopoverSetFavouriteData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ConversationContactPopoverSetFavouriteData, _data_);
}

static void
conversation_contact_popover_set_favourite (ConversationContactPopover* self,
                                            gboolean enabled,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_)
{
	ConversationContactPopoverSetFavouriteData* _data_;
	ConversationContactPopover* _tmp0_;
	g_return_if_fail (CONVERSATION_IS_CONTACT_POPOVER (self));
	_data_ = g_slice_new0 (ConversationContactPopoverSetFavouriteData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, conversation_contact_popover_set_favourite_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->enabled = enabled;
	conversation_contact_popover_set_favourite_co (_data_);
}

static void
conversation_contact_popover_set_favourite_finish (ConversationContactPopover* self,
                                                   GAsyncResult* _res_)
{
	ConversationContactPopoverSetFavouriteData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
conversation_contact_popover_set_favourite_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_)
{
	ConversationContactPopoverSetFavouriteData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	conversation_contact_popover_set_favourite_co (_data_);
}

static gboolean
conversation_contact_popover_set_favourite_co (ConversationContactPopoverSetFavouriteData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->self->priv->_contact;
		_data_->_state_ = 1;
		application_contact_set_favourite (_data_->_tmp0_, _data_->enabled, NULL, conversation_contact_popover_set_favourite_ready, _data_);
		return FALSE;
		_state_1:
		application_contact_set_favourite_finish (_data_->_tmp0_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp1_ = _data_->self->priv->_contact;
		_data_->_tmp2_ = application_contact_to_string (_data_->_tmp1_);
		_data_->_tmp3_ = _data_->_tmp2_;
		_data_->_tmp4_ = _data_->err;
		_data_->_tmp5_ = _data_->_tmp4_->message;
		g_debug ("conversation-contact-popover.vala:207: Failed to set enabled state for" \
" contact %s:, %s", _data_->_tmp3_, _data_->_tmp5_);
		_g_free0 (_data_->_tmp3_);
		_g_error_free0 (_data_->err);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
conversation_contact_popover_on_contact_changed (ConversationContactPopover* self)
{
	g_return_if_fail (CONVERSATION_IS_CONTACT_POPOVER (self));
	conversation_contact_popover_update (self);
}

static void
conversation_contact_popover_on_copy_email (ConversationContactPopover* self)
{
	GtkClipboard* clipboard = NULL;
	GtkClipboard* _tmp0_;
	GtkClipboard* _tmp1_;
	GearyRFC822MailboxAddress* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (CONVERSATION_IS_CONTACT_POPOVER (self));
	_tmp0_ = gtk_clipboard_get (GDK_SELECTION_CLIPBOARD);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	clipboard = _tmp1_;
	_tmp2_ = self->priv->_mailbox;
	_tmp3_ = geary_rf_c822_mailbox_address_to_full_display (_tmp2_, "<", ">");
	_tmp4_ = _tmp3_;
	gtk_clipboard_set_text (clipboard, _tmp4_, -1);
	_g_free0 (_tmp4_);
	gtk_clipboard_store (clipboard);
	_g_object_unref0 (clipboard);
}

static void
conversation_contact_popover_on_load_remote (ConversationContactPopover* self,
                                             GSimpleAction* action)
{
	gboolean state = FALSE;
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (CONVERSATION_IS_CONTACT_POPOVER (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (action, g_simple_action_get_type ()));
	_tmp0_ = g_action_get_state (G_TYPE_CHECK_INSTANCE_CAST (action, g_action_get_type (), GAction));
	_tmp1_ = _tmp0_;
	_tmp2_ = !g_variant_get_boolean (_tmp1_);
	_g_variant_unref0 (_tmp1_);
	state = _tmp2_;
	conversation_contact_popover_set_load_remote_resources (self, state, NULL, NULL);
}

static void
conversation_contact_popover_on_new_conversation (ConversationContactPopover* self)
{
	ApplicationMainWindow* main = NULL;
	GtkWidget* _tmp0_;
	ApplicationMainWindow* _tmp1_;
	ApplicationMainWindow* _tmp2_;
	g_return_if_fail (CONVERSATION_IS_CONTACT_POPOVER (self));
	_tmp0_ = gtk_widget_get_toplevel (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp1_ = _g_object_ref0 (APPLICATION_IS_MAIN_WINDOW (_tmp0_) ? ((ApplicationMainWindow*) _tmp0_) : NULL);
	main = _tmp1_;
	_tmp2_ = main;
	if (_tmp2_ != NULL) {
		ApplicationMainWindow* _tmp3_;
		ApplicationClient* _tmp4_;
		ApplicationClient* _tmp5_;
		GearyRFC822MailboxAddress* _tmp6_;
		_tmp3_ = main;
		_tmp4_ = application_main_window_get_application (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = self->priv->_mailbox;
		application_client_new_composer (_tmp5_, _tmp6_, NULL, NULL);
	}
	_g_object_unref0 (main);
}

static void
conversation_contact_popover_on_open (ConversationContactPopover* self)
{
	g_return_if_fail (CONVERSATION_IS_CONTACT_POPOVER (self));
	conversation_contact_popover_open (self, NULL, NULL);
}

static void
conversation_contact_popover_on_save (ConversationContactPopover* self)
{
	g_return_if_fail (CONVERSATION_IS_CONTACT_POPOVER (self));
	conversation_contact_popover_save (self, NULL, NULL);
}

static void
conversation_contact_popover_on_show_conversations (ConversationContactPopover* self)
{
	ApplicationMainWindow* main = NULL;
	GtkWidget* _tmp0_;
	ApplicationMainWindow* _tmp1_;
	ApplicationMainWindow* _tmp2_;
	g_return_if_fail (CONVERSATION_IS_CONTACT_POPOVER (self));
	_tmp0_ = gtk_widget_get_toplevel (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp1_ = _g_object_ref0 (APPLICATION_IS_MAIN_WINDOW (_tmp0_) ? ((ApplicationMainWindow*) _tmp0_) : NULL);
	main = _tmp1_;
	_tmp2_ = main;
	if (_tmp2_ != NULL) {
		ApplicationMainWindow* _tmp3_;
		GearyRFC822MailboxAddress* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp3_ = main;
		_tmp4_ = self->priv->_mailbox;
		_tmp5_ = geary_rf_c822_mailbox_address_get_address (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strdup_printf ("from:%s", _tmp6_);
		_tmp8_ = _tmp7_;
		application_main_window_show_search_bar (_tmp3_, _tmp8_);
		_g_free0 (_tmp8_);
	}
	_g_object_unref0 (main);
}

static void
conversation_contact_popover_on_star (ConversationContactPopover* self)
{
	g_return_if_fail (CONVERSATION_IS_CONTACT_POPOVER (self));
	conversation_contact_popover_set_favourite (self, TRUE, NULL, NULL);
}

static void
conversation_contact_popover_on_unstar (ConversationContactPopover* self)
{
	g_return_if_fail (CONVERSATION_IS_CONTACT_POPOVER (self));
	conversation_contact_popover_set_favourite (self, FALSE, NULL, NULL);
}

static gboolean
__lambda116_ (ConversationContactPopover* self)
{
	gboolean result;
	gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda116__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda116_ ((ConversationContactPopover*) self);
	return result;
}

static void
conversation_contact_popover_after_closed (ConversationContactPopover* self)
{
	g_return_if_fail (CONVERSATION_IS_CONTACT_POPOVER (self));
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda116__gsource_func, g_object_ref (self), g_object_unref);
}

static void
_conversation_contact_popover_after_closed_gtk_popover_closed (GtkPopover* _sender,
                                                               gpointer self)
{
	conversation_contact_popover_after_closed ((ConversationContactPopover*) self);
}

static void
conversation_contact_popover_class_init (ConversationContactPopoverClass * klass,
                                         gpointer klass_data)
{
	conversation_contact_popover_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ConversationContactPopover_private_offset);
	((GtkWidgetClass *) klass)->destroy = (void (*) (GtkWidget*)) conversation_contact_popover_real_destroy;
	G_OBJECT_CLASS (klass)->get_property = _vala_conversation_contact_popover_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_conversation_contact_popover_set_property;
	G_OBJECT_CLASS (klass)->finalize = conversation_contact_popover_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONVERSATION_CONTACT_POPOVER_CONTACT_PROPERTY, conversation_contact_popover_properties[CONVERSATION_CONTACT_POPOVER_CONTACT_PROPERTY] = g_param_spec_object ("contact", "contact", "contact", APPLICATION_TYPE_CONTACT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONVERSATION_CONTACT_POPOVER_MAILBOX_PROPERTY, conversation_contact_popover_properties[CONVERSATION_CONTACT_POPOVER_MAILBOX_PROPERTY] = g_param_spec_object ("mailbox", "mailbox", "mailbox", GEARY_RF_C822_TYPE_MAILBOX_ADDRESS, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Geary/conversation-contact-popover.ui");
	/** Fired when the remote resources load pref changes */
	conversation_contact_popover_signals[CONVERSATION_CONTACT_POPOVER_LOAD_REMOTE_RESOURCES_CHANGED_SIGNAL] = g_signal_new ("load-remote-resources-changed", CONVERSATION_TYPE_CONTACT_POPOVER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "contact_pane", FALSE, ConversationContactPopover_private_offset + G_STRUCT_OFFSET (ConversationContactPopoverPrivate, contact_pane));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "avatar", FALSE, ConversationContactPopover_private_offset + G_STRUCT_OFFSET (ConversationContactPopoverPrivate, avatar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "contact_name", FALSE, ConversationContactPopover_private_offset + G_STRUCT_OFFSET (ConversationContactPopoverPrivate, contact_name));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "contact_address", FALSE, ConversationContactPopover_private_offset + G_STRUCT_OFFSET (ConversationContactPopoverPrivate, contact_address));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "starred_button", FALSE, ConversationContactPopover_private_offset + G_STRUCT_OFFSET (ConversationContactPopoverPrivate, starred_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "unstarred_button", FALSE, ConversationContactPopover_private_offset + G_STRUCT_OFFSET (ConversationContactPopoverPrivate, unstarred_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "open_button", FALSE, ConversationContactPopover_private_offset + G_STRUCT_OFFSET (ConversationContactPopoverPrivate, open_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "save_button", FALSE, ConversationContactPopover_private_offset + G_STRUCT_OFFSET (ConversationContactPopoverPrivate, save_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "load_remote_button", FALSE, ConversationContactPopover_private_offset + G_STRUCT_OFFSET (ConversationContactPopoverPrivate, load_remote_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "deceptive_pane", FALSE, ConversationContactPopover_private_offset + G_STRUCT_OFFSET (ConversationContactPopoverPrivate, deceptive_pane));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "forged_email_label", FALSE, ConversationContactPopover_private_offset + G_STRUCT_OFFSET (ConversationContactPopoverPrivate, forged_email_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "actual_email_label", FALSE, ConversationContactPopover_private_offset + G_STRUCT_OFFSET (ConversationContactPopoverPrivate, actual_email_label));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "after_closed", G_CALLBACK(_conversation_contact_popover_after_closed_gtk_popover_closed));
}

static void
conversation_contact_popover_instance_init (ConversationContactPopover * self,
                                            gpointer klass)
{
	GCancellable* _tmp0_;
	GSimpleActionGroup* _tmp1_;
	self->priv = conversation_contact_popover_get_instance_private (self);
	_tmp0_ = g_cancellable_new ();
	self->priv->load_cancellable = _tmp0_;
	_tmp1_ = g_simple_action_group_new ();
	self->priv->actions = _tmp1_;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
conversation_contact_popover_finalize (GObject * obj)
{
	ConversationContactPopover * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONVERSATION_TYPE_CONTACT_POPOVER, ConversationContactPopover);
	_g_object_unref0 (self->priv->_contact);
	_g_object_unref0 (self->priv->_mailbox);
	_g_object_unref0 (self->priv->load_cancellable);
	_g_object_unref0 (self->priv->config);
	_g_object_unref0 (self->priv->actions);
	G_OBJECT_CLASS (conversation_contact_popover_parent_class)->finalize (obj);
}

/**
 * Display contact information and supported actions for a contact.
 */
static GType
conversation_contact_popover_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ConversationContactPopoverClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) conversation_contact_popover_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ConversationContactPopover), 0, (GInstanceInitFunc) conversation_contact_popover_instance_init, NULL };
	GType conversation_contact_popover_type_id;
	conversation_contact_popover_type_id = g_type_register_static (gtk_popover_get_type (), "ConversationContactPopover", &g_define_type_info, 0);
	ConversationContactPopover_private_offset = g_type_add_instance_private (conversation_contact_popover_type_id, sizeof (ConversationContactPopoverPrivate));
	return conversation_contact_popover_type_id;
}

GType
conversation_contact_popover_get_type (void)
{
	static volatile gsize conversation_contact_popover_type_id__once = 0;
	if (g_once_init_enter (&conversation_contact_popover_type_id__once)) {
		GType conversation_contact_popover_type_id;
		conversation_contact_popover_type_id = conversation_contact_popover_get_type_once ();
		g_once_init_leave (&conversation_contact_popover_type_id__once, conversation_contact_popover_type_id);
	}
	return conversation_contact_popover_type_id__once;
}

static void
_vala_conversation_contact_popover_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec)
{
	ConversationContactPopover * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONVERSATION_TYPE_CONTACT_POPOVER, ConversationContactPopover);
	switch (property_id) {
		case CONVERSATION_CONTACT_POPOVER_CONTACT_PROPERTY:
		g_value_set_object (value, conversation_contact_popover_get_contact (self));
		break;
		case CONVERSATION_CONTACT_POPOVER_MAILBOX_PROPERTY:
		g_value_set_object (value, conversation_contact_popover_get_mailbox (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_conversation_contact_popover_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec)
{
	ConversationContactPopover * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONVERSATION_TYPE_CONTACT_POPOVER, ConversationContactPopover);
	switch (property_id) {
		case CONVERSATION_CONTACT_POPOVER_CONTACT_PROPERTY:
		conversation_contact_popover_set_contact (self, g_value_get_object (value));
		break;
		case CONVERSATION_CONTACT_POPOVER_MAILBOX_PROPERTY:
		conversation_contact_popover_set_mailbox (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

