/* plugin-action-bar.c generated by valac 0.56.3, the Vala compiler
 * generated from plugin-action-bar.vala, do not modify */

/*
 * Copyright © 2020 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-client-43.0.h"
#include <gee.h>
#include <glib-object.h>
#include <glib.h>
#include "geary-engine.h"
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>

enum  {
	PLUGIN_ACTION_BAR_0_PROPERTY,
	PLUGIN_ACTION_BAR_NUM_PROPERTIES
};
static GParamSpec* plugin_action_bar_properties[PLUGIN_ACTION_BAR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	PLUGIN_ACTION_BAR_LABEL_ITEM_0_PROPERTY,
	PLUGIN_ACTION_BAR_LABEL_ITEM_TEXT_PROPERTY,
	PLUGIN_ACTION_BAR_LABEL_ITEM_NUM_PROPERTIES
};
static GParamSpec* plugin_action_bar_label_item_properties[PLUGIN_ACTION_BAR_LABEL_ITEM_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	PLUGIN_ACTION_BAR_BUTTON_ITEM_0_PROPERTY,
	PLUGIN_ACTION_BAR_BUTTON_ITEM_ACTION_PROPERTY,
	PLUGIN_ACTION_BAR_BUTTON_ITEM_NUM_PROPERTIES
};
static GParamSpec* plugin_action_bar_button_item_properties[PLUGIN_ACTION_BAR_BUTTON_ITEM_NUM_PROPERTIES];
enum  {
	PLUGIN_ACTION_BAR_MENU_ITEM_0_PROPERTY,
	PLUGIN_ACTION_BAR_MENU_ITEM_LABEL_PROPERTY,
	PLUGIN_ACTION_BAR_MENU_ITEM_MENU_PROPERTY,
	PLUGIN_ACTION_BAR_MENU_ITEM_NUM_PROPERTIES
};
static GParamSpec* plugin_action_bar_menu_item_properties[PLUGIN_ACTION_BAR_MENU_ITEM_NUM_PROPERTIES];
enum  {
	PLUGIN_ACTION_BAR_GROUP_ITEM_0_PROPERTY,
	PLUGIN_ACTION_BAR_GROUP_ITEM_NUM_PROPERTIES
};
static GParamSpec* plugin_action_bar_group_item_properties[PLUGIN_ACTION_BAR_GROUP_ITEM_NUM_PROPERTIES];

struct _PluginActionBarPrivate {
	GeeList* start_items;
	GeeList* centre_items;
	GeeList* end_items;
};

struct _PluginActionBarLabelItemPrivate {
	gchar* _text;
};

struct _PluginActionBarButtonItemPrivate {
	PluginActionable* _action;
};

struct _PluginActionBarMenuItemPrivate {
	gchar* _label;
	GMenuModel* _menu;
};

struct _PluginActionBarGroupItemPrivate {
	GeeList* items;
};

static gint PluginActionBar_private_offset;
static gpointer plugin_action_bar_parent_class = NULL;
static gint PluginActionBarLabelItem_private_offset;
static gpointer plugin_action_bar_label_item_parent_class = NULL;
static PluginActionBarItemIface * plugin_action_bar_label_item_plugin_action_bar_item_parent_iface = NULL;
static gint PluginActionBarButtonItem_private_offset;
static gpointer plugin_action_bar_button_item_parent_class = NULL;
static PluginActionBarItemIface * plugin_action_bar_button_item_plugin_action_bar_item_parent_iface = NULL;
static gint PluginActionBarMenuItem_private_offset;
static gpointer plugin_action_bar_menu_item_parent_class = NULL;
static PluginActionBarItemIface * plugin_action_bar_menu_item_plugin_action_bar_item_parent_iface = NULL;
static gint PluginActionBarGroupItem_private_offset;
static gpointer plugin_action_bar_group_item_parent_class = NULL;
static PluginActionBarItemIface * plugin_action_bar_group_item_plugin_action_bar_item_parent_iface = NULL;

static void plugin_action_bar_label_item_set_text (PluginActionBarLabelItem* self,
                                            const gchar* value);
static void plugin_action_bar_label_item_finalize (GObject * obj);
static GType plugin_action_bar_label_item_get_type_once (void);
static void _vala_plugin_action_bar_label_item_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec);
static void _vala_plugin_action_bar_label_item_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec);
static void plugin_action_bar_button_item_set_action (PluginActionBarButtonItem* self,
                                               PluginActionable* value);
static void plugin_action_bar_button_item_finalize (GObject * obj);
static GType plugin_action_bar_button_item_get_type_once (void);
static void _vala_plugin_action_bar_button_item_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec);
static void _vala_plugin_action_bar_button_item_set_property (GObject * object,
                                                       guint property_id,
                                                       const GValue * value,
                                                       GParamSpec * pspec);
static void plugin_action_bar_menu_item_set_label (PluginActionBarMenuItem* self,
                                            const gchar* value);
static void plugin_action_bar_menu_item_set_menu (PluginActionBarMenuItem* self,
                                           GMenuModel* value);
static void plugin_action_bar_menu_item_finalize (GObject * obj);
static GType plugin_action_bar_menu_item_get_type_once (void);
static void _vala_plugin_action_bar_menu_item_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec);
static void _vala_plugin_action_bar_menu_item_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec);
static void plugin_action_bar_group_item_finalize (GObject * obj);
static GType plugin_action_bar_group_item_get_type_once (void);
static GType plugin_action_bar_item_get_type_once (void);
static void plugin_action_bar_finalize (GObject * obj);
static GType plugin_action_bar_get_type_once (void);

static inline gpointer
plugin_action_bar_get_instance_private (PluginActionBar* self)
{
	return G_STRUCT_MEMBER_P (self, PluginActionBar_private_offset);
}

/**
     * Determines the position of a widget added to an action bar.
     *
     * @see append_item
     */
static GType
plugin_action_bar_position_get_type_once (void)
{
	static const GEnumValue values[] = {{PLUGIN_ACTION_BAR_POSITION_START, "PLUGIN_ACTION_BAR_POSITION_START", "start"}, {PLUGIN_ACTION_BAR_POSITION_CENTRE, "PLUGIN_ACTION_BAR_POSITION_CENTRE", "centre"}, {PLUGIN_ACTION_BAR_POSITION_END, "PLUGIN_ACTION_BAR_POSITION_END", "end"}, {0, NULL, NULL}};
	GType plugin_action_bar_position_type_id;
	plugin_action_bar_position_type_id = g_enum_register_static ("PluginActionBarPosition", values);
	return plugin_action_bar_position_type_id;
}

GType
plugin_action_bar_position_get_type (void)
{
	static volatile gsize plugin_action_bar_position_type_id__once = 0;
	if (g_once_init_enter (&plugin_action_bar_position_type_id__once)) {
		GType plugin_action_bar_position_type_id;
		plugin_action_bar_position_type_id = plugin_action_bar_position_get_type_once ();
		g_once_init_leave (&plugin_action_bar_position_type_id__once, plugin_action_bar_position_type_id);
	}
	return plugin_action_bar_position_type_id__once;
}

/** Constructs a new, empty action bar. */
PluginActionBar*
plugin_action_bar_construct (GType object_type)
{
	PluginActionBar * self = NULL;
	self = (PluginActionBar*) geary_base_object_construct (object_type);
	return self;
}

PluginActionBar*
plugin_action_bar_new (void)
{
	return plugin_action_bar_construct (PLUGIN_TYPE_ACTION_BAR);
}

/**
     * Appends an item to the action bar in the given location.
     *
     * Items at the same position are laid out in the same direction
     * as the current locale's writing direction.
     */
void
plugin_action_bar_append_item (PluginActionBar* self,
                               PluginActionBarItem* item,
                               PluginActionBarPosition item_position)
{
	g_return_if_fail (PLUGIN_IS_ACTION_BAR (self));
	g_return_if_fail (PLUGIN_ACTION_BAR_IS_ITEM (item));
	switch (item_position) {
		case PLUGIN_ACTION_BAR_POSITION_START:
		{
			GeeList* _tmp0_;
			_tmp0_ = self->priv->start_items;
			gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), item);
			break;
		}
		case PLUGIN_ACTION_BAR_POSITION_CENTRE:
		{
			GeeList* _tmp1_;
			_tmp1_ = self->priv->centre_items;
			gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection), item);
			break;
		}
		case PLUGIN_ACTION_BAR_POSITION_END:
		{
			GeeList* _tmp2_;
			_tmp2_ = self->priv->end_items;
			gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection), item);
			break;
		}
		default:
		break;
	}
}

/** Returns a read-only list of items at the given position. */
GeeList*
plugin_action_bar_get_items (PluginActionBar* self,
                             PluginActionBarPosition item_position)
{
	GeeList* items = NULL;
	GeeList* result;
	g_return_val_if_fail (PLUGIN_IS_ACTION_BAR (self), NULL);
	items = NULL;
	switch (item_position) {
		case PLUGIN_ACTION_BAR_POSITION_START:
		{
			GeeList* _tmp0_;
			GeeList* _tmp1_;
			GeeList* _tmp2_;
			_tmp0_ = self->priv->start_items;
			_tmp1_ = gee_list_get_read_only_view (_tmp0_);
			_tmp2_ = _tmp1_;
			_g_object_unref0 (items);
			items = _tmp2_;
			break;
		}
		case PLUGIN_ACTION_BAR_POSITION_CENTRE:
		{
			GeeList* _tmp3_;
			GeeList* _tmp4_;
			GeeList* _tmp5_;
			_tmp3_ = self->priv->centre_items;
			_tmp4_ = gee_list_get_read_only_view (_tmp3_);
			_tmp5_ = _tmp4_;
			_g_object_unref0 (items);
			items = _tmp5_;
			break;
		}
		case PLUGIN_ACTION_BAR_POSITION_END:
		{
			GeeList* _tmp6_;
			GeeList* _tmp7_;
			GeeList* _tmp8_;
			_tmp6_ = self->priv->end_items;
			_tmp7_ = gee_list_get_read_only_view (_tmp6_);
			_tmp8_ = _tmp7_;
			_g_object_unref0 (items);
			items = _tmp8_;
			break;
		}
		default:
		break;
	}
	result = items;
	return result;
}

static inline gpointer
plugin_action_bar_label_item_get_instance_private (PluginActionBarLabelItem* self)
{
	return G_STRUCT_MEMBER_P (self, PluginActionBarLabelItem_private_offset);
}

const gchar*
plugin_action_bar_label_item_get_text (PluginActionBarLabelItem* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (PLUGIN_ACTION_BAR_IS_LABEL_ITEM (self), NULL);
	_tmp0_ = self->priv->_text;
	result = _tmp0_;
	return result;
}

static void
plugin_action_bar_label_item_set_text (PluginActionBarLabelItem* self,
                                       const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (PLUGIN_ACTION_BAR_IS_LABEL_ITEM (self));
	old_value = plugin_action_bar_label_item_get_text (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_text);
		self->priv->_text = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plugin_action_bar_label_item_properties[PLUGIN_ACTION_BAR_LABEL_ITEM_TEXT_PROPERTY]);
	}
}

/** Constructs a text label item for an action bar. */
PluginActionBarLabelItem*
plugin_action_bar_label_item_construct (GType object_type,
                                        const gchar* text)
{
	PluginActionBarLabelItem * self = NULL;
	g_return_val_if_fail (text != NULL, NULL);
	self = (PluginActionBarLabelItem*) g_object_new (object_type, NULL);
	plugin_action_bar_label_item_set_text (self, text);
	return self;
}

PluginActionBarLabelItem*
plugin_action_bar_label_item_new (const gchar* text)
{
	return plugin_action_bar_label_item_construct (PLUGIN_ACTION_BAR_TYPE_LABEL_ITEM, text);
}

static void
plugin_action_bar_label_item_class_init (PluginActionBarLabelItemClass * klass,
                                         gpointer klass_data)
{
	plugin_action_bar_label_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PluginActionBarLabelItem_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_plugin_action_bar_label_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_plugin_action_bar_label_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = plugin_action_bar_label_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLUGIN_ACTION_BAR_LABEL_ITEM_TEXT_PROPERTY, plugin_action_bar_label_item_properties[PLUGIN_ACTION_BAR_LABEL_ITEM_TEXT_PROPERTY] = g_param_spec_string ("text", "text", "text", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
plugin_action_bar_label_item_plugin_action_bar_item_interface_init (PluginActionBarItemIface * iface,
                                                                    gpointer iface_data)
{
	plugin_action_bar_label_item_plugin_action_bar_item_parent_iface = g_type_interface_peek_parent (iface);
}

static void
plugin_action_bar_label_item_instance_init (PluginActionBarLabelItem * self,
                                            gpointer klass)
{
	self->priv = plugin_action_bar_label_item_get_instance_private (self);
}

static void
plugin_action_bar_label_item_finalize (GObject * obj)
{
	PluginActionBarLabelItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLUGIN_ACTION_BAR_TYPE_LABEL_ITEM, PluginActionBarLabelItem);
	_g_free0 (self->priv->_text);
	G_OBJECT_CLASS (plugin_action_bar_label_item_parent_class)->finalize (obj);
}

/** A text label item for an action bar. */
static GType
plugin_action_bar_label_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PluginActionBarLabelItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plugin_action_bar_label_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PluginActionBarLabelItem), 0, (GInstanceInitFunc) plugin_action_bar_label_item_instance_init, NULL };
	static const GInterfaceInfo plugin_action_bar_item_info = { (GInterfaceInitFunc) plugin_action_bar_label_item_plugin_action_bar_item_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType plugin_action_bar_label_item_type_id;
	plugin_action_bar_label_item_type_id = g_type_register_static (G_TYPE_OBJECT, "PluginActionBarLabelItem", &g_define_type_info, 0);
	g_type_add_interface_static (plugin_action_bar_label_item_type_id, PLUGIN_ACTION_BAR_TYPE_ITEM, &plugin_action_bar_item_info);
	PluginActionBarLabelItem_private_offset = g_type_add_instance_private (plugin_action_bar_label_item_type_id, sizeof (PluginActionBarLabelItemPrivate));
	return plugin_action_bar_label_item_type_id;
}

GType
plugin_action_bar_label_item_get_type (void)
{
	static volatile gsize plugin_action_bar_label_item_type_id__once = 0;
	if (g_once_init_enter (&plugin_action_bar_label_item_type_id__once)) {
		GType plugin_action_bar_label_item_type_id;
		plugin_action_bar_label_item_type_id = plugin_action_bar_label_item_get_type_once ();
		g_once_init_leave (&plugin_action_bar_label_item_type_id__once, plugin_action_bar_label_item_type_id);
	}
	return plugin_action_bar_label_item_type_id__once;
}

static void
_vala_plugin_action_bar_label_item_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec)
{
	PluginActionBarLabelItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PLUGIN_ACTION_BAR_TYPE_LABEL_ITEM, PluginActionBarLabelItem);
	switch (property_id) {
		case PLUGIN_ACTION_BAR_LABEL_ITEM_TEXT_PROPERTY:
		g_value_set_string (value, plugin_action_bar_label_item_get_text (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_plugin_action_bar_label_item_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec)
{
	PluginActionBarLabelItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PLUGIN_ACTION_BAR_TYPE_LABEL_ITEM, PluginActionBarLabelItem);
	switch (property_id) {
		case PLUGIN_ACTION_BAR_LABEL_ITEM_TEXT_PROPERTY:
		plugin_action_bar_label_item_set_text (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
plugin_action_bar_button_item_get_instance_private (PluginActionBarButtonItem* self)
{
	return G_STRUCT_MEMBER_P (self, PluginActionBarButtonItem_private_offset);
}

PluginActionable*
plugin_action_bar_button_item_get_action (PluginActionBarButtonItem* self)
{
	PluginActionable* result;
	PluginActionable* _tmp0_;
	g_return_val_if_fail (PLUGIN_ACTION_BAR_IS_BUTTON_ITEM (self), NULL);
	_tmp0_ = self->priv->_action;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
plugin_action_bar_button_item_set_action (PluginActionBarButtonItem* self,
                                          PluginActionable* value)
{
	PluginActionable* old_value;
	g_return_if_fail (PLUGIN_ACTION_BAR_IS_BUTTON_ITEM (self));
	old_value = plugin_action_bar_button_item_get_action (self);
	if (old_value != value) {
		PluginActionable* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_action);
		self->priv->_action = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plugin_action_bar_button_item_properties[PLUGIN_ACTION_BAR_BUTTON_ITEM_ACTION_PROPERTY]);
	}
}

/** Constructs a button item for an action bar. */
PluginActionBarButtonItem*
plugin_action_bar_button_item_construct (GType object_type,
                                         PluginActionable* action)
{
	PluginActionBarButtonItem * self = NULL;
	g_return_val_if_fail (PLUGIN_IS_ACTIONABLE (action), NULL);
	self = (PluginActionBarButtonItem*) g_object_new (object_type, NULL);
	plugin_action_bar_button_item_set_action (self, action);
	return self;
}

PluginActionBarButtonItem*
plugin_action_bar_button_item_new (PluginActionable* action)
{
	return plugin_action_bar_button_item_construct (PLUGIN_ACTION_BAR_TYPE_BUTTON_ITEM, action);
}

static void
plugin_action_bar_button_item_class_init (PluginActionBarButtonItemClass * klass,
                                          gpointer klass_data)
{
	plugin_action_bar_button_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PluginActionBarButtonItem_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_plugin_action_bar_button_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_plugin_action_bar_button_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = plugin_action_bar_button_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLUGIN_ACTION_BAR_BUTTON_ITEM_ACTION_PROPERTY, plugin_action_bar_button_item_properties[PLUGIN_ACTION_BAR_BUTTON_ITEM_ACTION_PROPERTY] = g_param_spec_object ("action", "action", "action", PLUGIN_TYPE_ACTIONABLE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
plugin_action_bar_button_item_plugin_action_bar_item_interface_init (PluginActionBarItemIface * iface,
                                                                     gpointer iface_data)
{
	plugin_action_bar_button_item_plugin_action_bar_item_parent_iface = g_type_interface_peek_parent (iface);
}

static void
plugin_action_bar_button_item_instance_init (PluginActionBarButtonItem * self,
                                             gpointer klass)
{
	self->priv = plugin_action_bar_button_item_get_instance_private (self);
}

static void
plugin_action_bar_button_item_finalize (GObject * obj)
{
	PluginActionBarButtonItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLUGIN_ACTION_BAR_TYPE_BUTTON_ITEM, PluginActionBarButtonItem);
	_g_object_unref0 (self->priv->_action);
	G_OBJECT_CLASS (plugin_action_bar_button_item_parent_class)->finalize (obj);
}

/** A button item for an action bar. */
static GType
plugin_action_bar_button_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PluginActionBarButtonItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plugin_action_bar_button_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PluginActionBarButtonItem), 0, (GInstanceInitFunc) plugin_action_bar_button_item_instance_init, NULL };
	static const GInterfaceInfo plugin_action_bar_item_info = { (GInterfaceInitFunc) plugin_action_bar_button_item_plugin_action_bar_item_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType plugin_action_bar_button_item_type_id;
	plugin_action_bar_button_item_type_id = g_type_register_static (G_TYPE_OBJECT, "PluginActionBarButtonItem", &g_define_type_info, 0);
	g_type_add_interface_static (plugin_action_bar_button_item_type_id, PLUGIN_ACTION_BAR_TYPE_ITEM, &plugin_action_bar_item_info);
	PluginActionBarButtonItem_private_offset = g_type_add_instance_private (plugin_action_bar_button_item_type_id, sizeof (PluginActionBarButtonItemPrivate));
	return plugin_action_bar_button_item_type_id;
}

GType
plugin_action_bar_button_item_get_type (void)
{
	static volatile gsize plugin_action_bar_button_item_type_id__once = 0;
	if (g_once_init_enter (&plugin_action_bar_button_item_type_id__once)) {
		GType plugin_action_bar_button_item_type_id;
		plugin_action_bar_button_item_type_id = plugin_action_bar_button_item_get_type_once ();
		g_once_init_leave (&plugin_action_bar_button_item_type_id__once, plugin_action_bar_button_item_type_id);
	}
	return plugin_action_bar_button_item_type_id__once;
}

static void
_vala_plugin_action_bar_button_item_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec)
{
	PluginActionBarButtonItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PLUGIN_ACTION_BAR_TYPE_BUTTON_ITEM, PluginActionBarButtonItem);
	switch (property_id) {
		case PLUGIN_ACTION_BAR_BUTTON_ITEM_ACTION_PROPERTY:
		g_value_set_object (value, plugin_action_bar_button_item_get_action (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_plugin_action_bar_button_item_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec)
{
	PluginActionBarButtonItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PLUGIN_ACTION_BAR_TYPE_BUTTON_ITEM, PluginActionBarButtonItem);
	switch (property_id) {
		case PLUGIN_ACTION_BAR_BUTTON_ITEM_ACTION_PROPERTY:
		plugin_action_bar_button_item_set_action (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
plugin_action_bar_menu_item_get_instance_private (PluginActionBarMenuItem* self)
{
	return G_STRUCT_MEMBER_P (self, PluginActionBarMenuItem_private_offset);
}

const gchar*
plugin_action_bar_menu_item_get_label (PluginActionBarMenuItem* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (PLUGIN_ACTION_BAR_IS_MENU_ITEM (self), NULL);
	_tmp0_ = self->priv->_label;
	result = _tmp0_;
	return result;
}

static void
plugin_action_bar_menu_item_set_label (PluginActionBarMenuItem* self,
                                       const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (PLUGIN_ACTION_BAR_IS_MENU_ITEM (self));
	old_value = plugin_action_bar_menu_item_get_label (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_label);
		self->priv->_label = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plugin_action_bar_menu_item_properties[PLUGIN_ACTION_BAR_MENU_ITEM_LABEL_PROPERTY]);
	}
}

GMenuModel*
plugin_action_bar_menu_item_get_menu (PluginActionBarMenuItem* self)
{
	GMenuModel* result;
	GMenuModel* _tmp0_;
	g_return_val_if_fail (PLUGIN_ACTION_BAR_IS_MENU_ITEM (self), NULL);
	_tmp0_ = self->priv->_menu;
	result = _tmp0_;
	return result;
}

static void
plugin_action_bar_menu_item_set_menu (PluginActionBarMenuItem* self,
                                      GMenuModel* value)
{
	GMenuModel* old_value;
	g_return_if_fail (PLUGIN_ACTION_BAR_IS_MENU_ITEM (self));
	old_value = plugin_action_bar_menu_item_get_menu (self);
	if (old_value != value) {
		GMenuModel* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_menu);
		self->priv->_menu = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plugin_action_bar_menu_item_properties[PLUGIN_ACTION_BAR_MENU_ITEM_MENU_PROPERTY]);
	}
}

/** Constructs a menu item for an action bar. */
PluginActionBarMenuItem*
plugin_action_bar_menu_item_construct (GType object_type,
                                       const gchar* label,
                                       GMenuModel* menu)
{
	PluginActionBarMenuItem * self = NULL;
	g_return_val_if_fail (label != NULL, NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (menu, g_menu_model_get_type ()), NULL);
	self = (PluginActionBarMenuItem*) g_object_new (object_type, NULL);
	plugin_action_bar_menu_item_set_label (self, label);
	plugin_action_bar_menu_item_set_menu (self, menu);
	return self;
}

PluginActionBarMenuItem*
plugin_action_bar_menu_item_new (const gchar* label,
                                 GMenuModel* menu)
{
	return plugin_action_bar_menu_item_construct (PLUGIN_ACTION_BAR_TYPE_MENU_ITEM, label, menu);
}

static void
plugin_action_bar_menu_item_class_init (PluginActionBarMenuItemClass * klass,
                                        gpointer klass_data)
{
	plugin_action_bar_menu_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PluginActionBarMenuItem_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_plugin_action_bar_menu_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_plugin_action_bar_menu_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = plugin_action_bar_menu_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLUGIN_ACTION_BAR_MENU_ITEM_LABEL_PROPERTY, plugin_action_bar_menu_item_properties[PLUGIN_ACTION_BAR_MENU_ITEM_LABEL_PROPERTY] = g_param_spec_string ("label", "label", "label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLUGIN_ACTION_BAR_MENU_ITEM_MENU_PROPERTY, plugin_action_bar_menu_item_properties[PLUGIN_ACTION_BAR_MENU_ITEM_MENU_PROPERTY] = g_param_spec_object ("menu", "menu", "menu", g_menu_model_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
plugin_action_bar_menu_item_plugin_action_bar_item_interface_init (PluginActionBarItemIface * iface,
                                                                   gpointer iface_data)
{
	plugin_action_bar_menu_item_plugin_action_bar_item_parent_iface = g_type_interface_peek_parent (iface);
}

static void
plugin_action_bar_menu_item_instance_init (PluginActionBarMenuItem * self,
                                           gpointer klass)
{
	self->priv = plugin_action_bar_menu_item_get_instance_private (self);
}

static void
plugin_action_bar_menu_item_finalize (GObject * obj)
{
	PluginActionBarMenuItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLUGIN_ACTION_BAR_TYPE_MENU_ITEM, PluginActionBarMenuItem);
	_g_free0 (self->priv->_label);
	_g_object_unref0 (self->priv->_menu);
	G_OBJECT_CLASS (plugin_action_bar_menu_item_parent_class)->finalize (obj);
}

/** A menu for an action bar. */
static GType
plugin_action_bar_menu_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PluginActionBarMenuItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plugin_action_bar_menu_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PluginActionBarMenuItem), 0, (GInstanceInitFunc) plugin_action_bar_menu_item_instance_init, NULL };
	static const GInterfaceInfo plugin_action_bar_item_info = { (GInterfaceInitFunc) plugin_action_bar_menu_item_plugin_action_bar_item_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType plugin_action_bar_menu_item_type_id;
	plugin_action_bar_menu_item_type_id = g_type_register_static (G_TYPE_OBJECT, "PluginActionBarMenuItem", &g_define_type_info, 0);
	g_type_add_interface_static (plugin_action_bar_menu_item_type_id, PLUGIN_ACTION_BAR_TYPE_ITEM, &plugin_action_bar_item_info);
	PluginActionBarMenuItem_private_offset = g_type_add_instance_private (plugin_action_bar_menu_item_type_id, sizeof (PluginActionBarMenuItemPrivate));
	return plugin_action_bar_menu_item_type_id;
}

GType
plugin_action_bar_menu_item_get_type (void)
{
	static volatile gsize plugin_action_bar_menu_item_type_id__once = 0;
	if (g_once_init_enter (&plugin_action_bar_menu_item_type_id__once)) {
		GType plugin_action_bar_menu_item_type_id;
		plugin_action_bar_menu_item_type_id = plugin_action_bar_menu_item_get_type_once ();
		g_once_init_leave (&plugin_action_bar_menu_item_type_id__once, plugin_action_bar_menu_item_type_id);
	}
	return plugin_action_bar_menu_item_type_id__once;
}

static void
_vala_plugin_action_bar_menu_item_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec)
{
	PluginActionBarMenuItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PLUGIN_ACTION_BAR_TYPE_MENU_ITEM, PluginActionBarMenuItem);
	switch (property_id) {
		case PLUGIN_ACTION_BAR_MENU_ITEM_LABEL_PROPERTY:
		g_value_set_string (value, plugin_action_bar_menu_item_get_label (self));
		break;
		case PLUGIN_ACTION_BAR_MENU_ITEM_MENU_PROPERTY:
		g_value_set_object (value, plugin_action_bar_menu_item_get_menu (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_plugin_action_bar_menu_item_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec)
{
	PluginActionBarMenuItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PLUGIN_ACTION_BAR_TYPE_MENU_ITEM, PluginActionBarMenuItem);
	switch (property_id) {
		case PLUGIN_ACTION_BAR_MENU_ITEM_LABEL_PROPERTY:
		plugin_action_bar_menu_item_set_label (self, g_value_get_string (value));
		break;
		case PLUGIN_ACTION_BAR_MENU_ITEM_MENU_PROPERTY:
		plugin_action_bar_menu_item_set_menu (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
plugin_action_bar_group_item_get_instance_private (PluginActionBarGroupItem* self)
{
	return G_STRUCT_MEMBER_P (self, PluginActionBarGroupItem_private_offset);
}

/** Constructs a button item for an action bar. */
PluginActionBarGroupItem*
plugin_action_bar_group_item_construct (GType object_type,
                                        GeeCollection* items)
{
	PluginActionBarGroupItem * self = NULL;
	g_return_val_if_fail ((items == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (items, GEE_TYPE_COLLECTION), NULL);
	self = (PluginActionBarGroupItem*) g_object_new (object_type, NULL);
	if (items != NULL) {
		GeeList* _tmp0_;
		_tmp0_ = self->priv->items;
		gee_collection_add_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), items);
	}
	return self;
}

PluginActionBarGroupItem*
plugin_action_bar_group_item_new (GeeCollection* items)
{
	return plugin_action_bar_group_item_construct (PLUGIN_ACTION_BAR_TYPE_GROUP_ITEM, items);
}

/** Appends an item to end of the group. */
void
plugin_action_bar_group_item_append_item (PluginActionBarGroupItem* self,
                                          PluginActionBarItem* item)
{
	GeeList* _tmp0_;
	g_return_if_fail (PLUGIN_ACTION_BAR_IS_GROUP_ITEM (self));
	g_return_if_fail (PLUGIN_ACTION_BAR_IS_ITEM (item));
	_tmp0_ = self->priv->items;
	gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), item);
}

/** Returns a read-only list of items in the group. */
GeeList*
plugin_action_bar_group_item_get_items (PluginActionBarGroupItem* self)
{
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	GeeList* result;
	g_return_val_if_fail (PLUGIN_ACTION_BAR_IS_GROUP_ITEM (self), NULL);
	_tmp0_ = self->priv->items;
	_tmp1_ = gee_list_get_read_only_view (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static void
plugin_action_bar_group_item_class_init (PluginActionBarGroupItemClass * klass,
                                         gpointer klass_data)
{
	plugin_action_bar_group_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PluginActionBarGroupItem_private_offset);
	G_OBJECT_CLASS (klass)->finalize = plugin_action_bar_group_item_finalize;
}

static void
plugin_action_bar_group_item_plugin_action_bar_item_interface_init (PluginActionBarItemIface * iface,
                                                                    gpointer iface_data)
{
	plugin_action_bar_group_item_plugin_action_bar_item_parent_iface = g_type_interface_peek_parent (iface);
}

static void
plugin_action_bar_group_item_instance_init (PluginActionBarGroupItem * self,
                                            gpointer klass)
{
	GeeLinkedList* _tmp0_;
	self->priv = plugin_action_bar_group_item_get_instance_private (self);
	_tmp0_ = gee_linked_list_new (PLUGIN_ACTION_BAR_TYPE_ITEM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->items = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_LIST, GeeList);
}

static void
plugin_action_bar_group_item_finalize (GObject * obj)
{
	PluginActionBarGroupItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLUGIN_ACTION_BAR_TYPE_GROUP_ITEM, PluginActionBarGroupItem);
	_g_object_unref0 (self->priv->items);
	G_OBJECT_CLASS (plugin_action_bar_group_item_parent_class)->finalize (obj);
}

/**
     * A group of items for an action bar.
     *
     * Groups will be displayed in a way that indicates they are
     * related, for example as pill buttons. Items in the group are
     * laid out in the same direction as the current locale's writing
     * direction.
     */
static GType
plugin_action_bar_group_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PluginActionBarGroupItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plugin_action_bar_group_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PluginActionBarGroupItem), 0, (GInstanceInitFunc) plugin_action_bar_group_item_instance_init, NULL };
	static const GInterfaceInfo plugin_action_bar_item_info = { (GInterfaceInitFunc) plugin_action_bar_group_item_plugin_action_bar_item_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType plugin_action_bar_group_item_type_id;
	plugin_action_bar_group_item_type_id = g_type_register_static (G_TYPE_OBJECT, "PluginActionBarGroupItem", &g_define_type_info, 0);
	g_type_add_interface_static (plugin_action_bar_group_item_type_id, PLUGIN_ACTION_BAR_TYPE_ITEM, &plugin_action_bar_item_info);
	PluginActionBarGroupItem_private_offset = g_type_add_instance_private (plugin_action_bar_group_item_type_id, sizeof (PluginActionBarGroupItemPrivate));
	return plugin_action_bar_group_item_type_id;
}

GType
plugin_action_bar_group_item_get_type (void)
{
	static volatile gsize plugin_action_bar_group_item_type_id__once = 0;
	if (g_once_init_enter (&plugin_action_bar_group_item_type_id__once)) {
		GType plugin_action_bar_group_item_type_id;
		plugin_action_bar_group_item_type_id = plugin_action_bar_group_item_get_type_once ();
		g_once_init_leave (&plugin_action_bar_group_item_type_id__once, plugin_action_bar_group_item_type_id);
	}
	return plugin_action_bar_group_item_type_id__once;
}

static void
plugin_action_bar_item_default_init (PluginActionBarItemIface * iface,
                                     gpointer iface_data)
{
}

/** Denotes an object that can be added to an action bar. */
static GType
plugin_action_bar_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PluginActionBarItemIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plugin_action_bar_item_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType plugin_action_bar_item_type_id;
	plugin_action_bar_item_type_id = g_type_register_static (G_TYPE_INTERFACE, "PluginActionBarItem", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (plugin_action_bar_item_type_id, G_TYPE_OBJECT);
	return plugin_action_bar_item_type_id;
}

GType
plugin_action_bar_item_get_type (void)
{
	static volatile gsize plugin_action_bar_item_type_id__once = 0;
	if (g_once_init_enter (&plugin_action_bar_item_type_id__once)) {
		GType plugin_action_bar_item_type_id;
		plugin_action_bar_item_type_id = plugin_action_bar_item_get_type_once ();
		g_once_init_leave (&plugin_action_bar_item_type_id__once, plugin_action_bar_item_type_id);
	}
	return plugin_action_bar_item_type_id__once;
}

static void
plugin_action_bar_class_init (PluginActionBarClass * klass,
                              gpointer klass_data)
{
	plugin_action_bar_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PluginActionBar_private_offset);
	G_OBJECT_CLASS (klass)->finalize = plugin_action_bar_finalize;
}

static void
plugin_action_bar_instance_init (PluginActionBar * self,
                                 gpointer klass)
{
	GeeLinkedList* _tmp0_;
	GeeLinkedList* _tmp1_;
	GeeLinkedList* _tmp2_;
	self->priv = plugin_action_bar_get_instance_private (self);
	_tmp0_ = gee_linked_list_new (PLUGIN_ACTION_BAR_TYPE_ITEM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->start_items = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_LIST, GeeList);
	_tmp1_ = gee_linked_list_new (PLUGIN_ACTION_BAR_TYPE_ITEM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->centre_items = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_LIST, GeeList);
	_tmp2_ = gee_linked_list_new (PLUGIN_ACTION_BAR_TYPE_ITEM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->end_items = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_LIST, GeeList);
}

static void
plugin_action_bar_finalize (GObject * obj)
{
	PluginActionBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLUGIN_TYPE_ACTION_BAR, PluginActionBar);
	_g_object_unref0 (self->priv->start_items);
	_g_object_unref0 (self->priv->centre_items);
	_g_object_unref0 (self->priv->end_items);
	G_OBJECT_CLASS (plugin_action_bar_parent_class)->finalize (obj);
}

/**
 * Enables plugins to display an action bar.
 *
 * Action bars are horizontal containers for buttons, menu buttons and
 * labels that can be added individually or in groups, at the start,
 * centre, or end of the bar. These interface items are added by
 * creating an appropriate {@link Item} instance and calling {@link
 * append_item}.
 *
 * The {@link Actionable} instances added to the action bar must have
 * their actions registered either globally for the application using
 * {@link Application.register_action} or locally for a specific UI
 * element, for example using {@link Composer.register_action}.
 */
static GType
plugin_action_bar_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PluginActionBarClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plugin_action_bar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PluginActionBar), 0, (GInstanceInitFunc) plugin_action_bar_instance_init, NULL };
	GType plugin_action_bar_type_id;
	plugin_action_bar_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "PluginActionBar", &g_define_type_info, 0);
	PluginActionBar_private_offset = g_type_add_instance_private (plugin_action_bar_type_id, sizeof (PluginActionBarPrivate));
	return plugin_action_bar_type_id;
}

GType
plugin_action_bar_get_type (void)
{
	static volatile gsize plugin_action_bar_type_id__once = 0;
	if (g_once_init_enter (&plugin_action_bar_type_id__once)) {
		GType plugin_action_bar_type_id;
		plugin_action_bar_type_id = plugin_action_bar_get_type_once ();
		g_once_init_leave (&plugin_action_bar_type_id__once, plugin_action_bar_type_id);
	}
	return plugin_action_bar_type_id__once;
}

