/* util-date.c generated by valac 0.56.3, the Vala compiler
 * generated from util-date.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-client-43.0.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <locale.h>
#include <glib/gi18n-lib.h>
#include <math.h>
#include <float.h>

#define UTIL_DATE_xlat_diff_year "%x"

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

VALA_EXTERN gint util_date_init_count;
gint util_date_init_count = 0;
VALA_EXTERN gchar** util_date_xlat_pretty_clocks;
VALA_EXTERN gint util_date_xlat_pretty_clocks_length1;
gchar** util_date_xlat_pretty_clocks = NULL;
gint util_date_xlat_pretty_clocks_length1 = 0;
static gint _util_date_xlat_pretty_clocks_size_ = 0;
VALA_EXTERN gchar** util_date_xlat_pretty_verbose_dates;
VALA_EXTERN gint util_date_xlat_pretty_verbose_dates_length1;
gchar** util_date_xlat_pretty_verbose_dates = NULL;
gint util_date_xlat_pretty_verbose_dates_length1 = 0;
static gint _util_date_xlat_pretty_verbose_dates_size_ = 0;
VALA_EXTERN gchar* util_date_xlat_same_year;
gchar* util_date_xlat_same_year = NULL;

VALA_EXTERN gint util_date_clock_format_to_index (UtilDateClockFormat self);
VALA_EXTERN void util_date_terminate (void);
VALA_EXTERN gboolean util_date_same_day (GDateTime* a,
                             GDateTime* b);
VALA_EXTERN gchar* util_date_pretty_print_coarse (UtilDateCoarseDate coarse_date,
                                      UtilDateClockFormat clock_format,
                                      GDateTime* datetime,
                                      GTimeSpan diff);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

gint
util_date_clock_format_to_index (UtilDateClockFormat self)
{
	gint result;
	result = CLAMP ((gint) self, 0, (gint) (UTIL_DATE_CLOCK_FORMAT_TOTAL - 1));
	return result;
}

static GType
util_date_clock_format_get_type_once (void)
{
	static const GEnumValue values[] = {{UTIL_DATE_CLOCK_FORMAT_TWELVE_HOURS, "UTIL_DATE_CLOCK_FORMAT_TWELVE_HOURS", "twelve-hours"}, {UTIL_DATE_CLOCK_FORMAT_TWENTY_FOUR_HOURS, "UTIL_DATE_CLOCK_FORMAT_TWENTY_FOUR_HOURS", "twenty-four-hours"}, {UTIL_DATE_CLOCK_FORMAT_LOCALE_DEFAULT, "UTIL_DATE_CLOCK_FORMAT_LOCALE_DEFAULT", "locale-default"}, {UTIL_DATE_CLOCK_FORMAT_TOTAL, "UTIL_DATE_CLOCK_FORMAT_TOTAL", "total"}, {0, NULL, NULL}};
	GType util_date_clock_format_type_id;
	util_date_clock_format_type_id = g_enum_register_static ("UtilDateClockFormat", values);
	return util_date_clock_format_type_id;
}

GType
util_date_clock_format_get_type (void)
{
	static volatile gsize util_date_clock_format_type_id__once = 0;
	if (g_once_init_enter (&util_date_clock_format_type_id__once)) {
		GType util_date_clock_format_type_id;
		util_date_clock_format_type_id = util_date_clock_format_get_type_once ();
		g_once_init_leave (&util_date_clock_format_type_id__once, util_date_clock_format_type_id);
	}
	return util_date_clock_format_type_id__once;
}

static GType
util_date_coarse_date_get_type_once (void)
{
	static const GEnumValue values[] = {{UTIL_DATE_COARSE_DATE_NOW, "UTIL_DATE_COARSE_DATE_NOW", "now"}, {UTIL_DATE_COARSE_DATE_MINUTES, "UTIL_DATE_COARSE_DATE_MINUTES", "minutes"}, {UTIL_DATE_COARSE_DATE_HOURS, "UTIL_DATE_COARSE_DATE_HOURS", "hours"}, {UTIL_DATE_COARSE_DATE_TODAY, "UTIL_DATE_COARSE_DATE_TODAY", "today"}, {UTIL_DATE_COARSE_DATE_YESTERDAY, "UTIL_DATE_COARSE_DATE_YESTERDAY", "yesterday"}, {UTIL_DATE_COARSE_DATE_THIS_WEEK, "UTIL_DATE_COARSE_DATE_THIS_WEEK", "this-week"}, {UTIL_DATE_COARSE_DATE_THIS_YEAR, "UTIL_DATE_COARSE_DATE_THIS_YEAR", "this-year"}, {UTIL_DATE_COARSE_DATE_YEARS, "UTIL_DATE_COARSE_DATE_YEARS", "years"}, {UTIL_DATE_COARSE_DATE_FUTURE, "UTIL_DATE_COARSE_DATE_FUTURE", "future"}, {0, NULL, NULL}};
	GType util_date_coarse_date_type_id;
	util_date_coarse_date_type_id = g_enum_register_static ("UtilDateCoarseDate", values);
	return util_date_coarse_date_type_id;
}

GType
util_date_coarse_date_get_type (void)
{
	static volatile gsize util_date_coarse_date_type_id__once = 0;
	if (g_once_init_enter (&util_date_coarse_date_type_id__once)) {
		GType util_date_coarse_date_type_id;
		util_date_coarse_date_type_id = util_date_coarse_date_get_type_once ();
		g_once_init_leave (&util_date_coarse_date_type_id__once, util_date_coarse_date_type_id);
	}
	return util_date_coarse_date_type_id__once;
}

void
util_date_init (void)
{
	gint _tmp0_;
	gchar* messages_locale = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* time_locale = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* language_env = NULL;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar** _tmp10_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	gchar* _tmp12_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	gchar* _tmp14_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar** _tmp18_;
	gchar** _tmp19_;
	gint _tmp19__length1;
	gchar* _tmp20_;
	gchar** _tmp21_;
	gint _tmp21__length1;
	gchar* _tmp22_;
	gchar** _tmp23_;
	gint _tmp23__length1;
	gchar* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp27_;
	_tmp0_ = util_date_init_count;
	util_date_init_count = _tmp0_ + 1;
	if (_tmp0_ != 0) {
		return;
	}
	_tmp1_ = setlocale (LC_MESSAGES, NULL);
	_tmp2_ = g_strdup (_tmp1_);
	messages_locale = _tmp2_;
	_tmp3_ = setlocale (LC_TIME, NULL);
	_tmp4_ = g_strdup (_tmp3_);
	time_locale = _tmp4_;
	_tmp5_ = g_getenv ("LANGUAGE");
	_tmp6_ = g_strdup (_tmp5_);
	language_env = _tmp6_;
	_tmp7_ = language_env;
	if (_tmp7_ != NULL) {
		g_unsetenv ("LANGUAGE");
	}
	_tmp8_ = time_locale;
	if (_tmp8_ != NULL) {
		const gchar* _tmp9_;
		_tmp9_ = time_locale;
		setlocale (LC_MESSAGES, _tmp9_);
	}
	_tmp10_ = g_new0 (gchar*, UTIL_DATE_CLOCK_FORMAT_TOTAL + 1);
	util_date_xlat_pretty_clocks = (_vala_array_free (util_date_xlat_pretty_clocks, util_date_xlat_pretty_clocks_length1, (GDestroyNotify) g_free), NULL);
	util_date_xlat_pretty_clocks = _tmp10_;
	util_date_xlat_pretty_clocks_length1 = UTIL_DATE_CLOCK_FORMAT_TOTAL;
	_util_date_xlat_pretty_clocks_size_ = util_date_xlat_pretty_clocks_length1;
	_tmp11_ = util_date_xlat_pretty_clocks;
	_tmp11__length1 = util_date_xlat_pretty_clocks_length1;
	_tmp12_ = g_strdup (_ ("%l:%M %P"));
	_g_free0 (_tmp11_[UTIL_DATE_CLOCK_FORMAT_TWELVE_HOURS]);
	_tmp11_[UTIL_DATE_CLOCK_FORMAT_TWELVE_HOURS] = _tmp12_;
	_tmp13_ = util_date_xlat_pretty_clocks;
	_tmp13__length1 = util_date_xlat_pretty_clocks_length1;
	_tmp14_ = g_strdup (_ ("%H:%M"));
	_g_free0 (_tmp13_[UTIL_DATE_CLOCK_FORMAT_TWENTY_FOUR_HOURS]);
	_tmp13_[UTIL_DATE_CLOCK_FORMAT_TWENTY_FOUR_HOURS] = _tmp14_;
	_tmp15_ = util_date_xlat_pretty_clocks;
	_tmp15__length1 = util_date_xlat_pretty_clocks_length1;
	_tmp16_ = g_strdup ("%X");
	_g_free0 (_tmp15_[UTIL_DATE_CLOCK_FORMAT_LOCALE_DEFAULT]);
	_tmp15_[UTIL_DATE_CLOCK_FORMAT_LOCALE_DEFAULT] = _tmp16_;
	_tmp17_ = g_strdup (_ ("%b %-e"));
	_g_free0 (util_date_xlat_same_year);
	util_date_xlat_same_year = _tmp17_;
	_tmp18_ = g_new0 (gchar*, UTIL_DATE_CLOCK_FORMAT_TOTAL + 1);
	util_date_xlat_pretty_verbose_dates = (_vala_array_free (util_date_xlat_pretty_verbose_dates, util_date_xlat_pretty_verbose_dates_length1, (GDestroyNotify) g_free), NULL);
	util_date_xlat_pretty_verbose_dates = _tmp18_;
	util_date_xlat_pretty_verbose_dates_length1 = UTIL_DATE_CLOCK_FORMAT_TOTAL;
	_util_date_xlat_pretty_verbose_dates_size_ = util_date_xlat_pretty_verbose_dates_length1;
	_tmp19_ = util_date_xlat_pretty_verbose_dates;
	_tmp19__length1 = util_date_xlat_pretty_verbose_dates_length1;
	_tmp20_ = g_strdup (_ ("%B %-e, %Y %-l:%M %P"));
	_g_free0 (_tmp19_[UTIL_DATE_CLOCK_FORMAT_TWELVE_HOURS]);
	_tmp19_[UTIL_DATE_CLOCK_FORMAT_TWELVE_HOURS] = _tmp20_;
	_tmp21_ = util_date_xlat_pretty_verbose_dates;
	_tmp21__length1 = util_date_xlat_pretty_verbose_dates_length1;
	_tmp22_ = g_strdup (_ ("%B %-e, %Y %-H:%M"));
	_g_free0 (_tmp21_[UTIL_DATE_CLOCK_FORMAT_TWENTY_FOUR_HOURS]);
	_tmp21_[UTIL_DATE_CLOCK_FORMAT_TWENTY_FOUR_HOURS] = _tmp22_;
	_tmp23_ = util_date_xlat_pretty_verbose_dates;
	_tmp23__length1 = util_date_xlat_pretty_verbose_dates_length1;
	_tmp24_ = g_strdup (C_ ("Default full date", "%B %-e, %Y %-l:%M %P"));
	_g_free0 (_tmp23_[UTIL_DATE_CLOCK_FORMAT_LOCALE_DEFAULT]);
	_tmp23_[UTIL_DATE_CLOCK_FORMAT_LOCALE_DEFAULT] = _tmp24_;
	_tmp25_ = messages_locale;
	if (_tmp25_ != NULL) {
		const gchar* _tmp26_;
		_tmp26_ = messages_locale;
		setlocale (LC_MESSAGES, _tmp26_);
	}
	_tmp27_ = language_env;
	if (_tmp27_ != NULL) {
		const gchar* _tmp28_;
		_tmp28_ = language_env;
		g_setenv ("LANGUAGE", _tmp28_, TRUE);
	}
	_g_free0 (language_env);
	_g_free0 (time_locale);
	_g_free0 (messages_locale);
}

void
util_date_terminate (void)
{
	gint _tmp0_;
	util_date_init_count = util_date_init_count - 1;
	_tmp0_ = util_date_init_count;
	if (_tmp0_ != 0) {
		return;
	}
	util_date_xlat_pretty_clocks = (_vala_array_free (util_date_xlat_pretty_clocks, util_date_xlat_pretty_clocks_length1, (GDestroyNotify) g_free), NULL);
	util_date_xlat_pretty_clocks = NULL;
	util_date_xlat_pretty_clocks_length1 = 0;
	_util_date_xlat_pretty_clocks_size_ = util_date_xlat_pretty_clocks_length1;
	_g_free0 (util_date_xlat_same_year);
	util_date_xlat_same_year = NULL;
	util_date_xlat_pretty_verbose_dates = (_vala_array_free (util_date_xlat_pretty_verbose_dates, util_date_xlat_pretty_verbose_dates_length1, (GDestroyNotify) g_free), NULL);
	util_date_xlat_pretty_verbose_dates = NULL;
	util_date_xlat_pretty_verbose_dates_length1 = 0;
	_util_date_xlat_pretty_verbose_dates_size_ = util_date_xlat_pretty_verbose_dates_length1;
}

gboolean
util_date_same_day (GDateTime* a,
                    GDateTime* b)
{
	gint year1 = 0;
	gint month1 = 0;
	gint day1 = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint year2 = 0;
	gint month2 = 0;
	gint day2 = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean result;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	g_date_time_get_ymd (a, &_tmp0_, &_tmp1_, &_tmp2_);
	year1 = _tmp0_;
	month1 = _tmp1_;
	day1 = _tmp2_;
	g_date_time_get_ymd (b, &_tmp3_, &_tmp4_, &_tmp5_);
	year2 = _tmp3_;
	month2 = _tmp4_;
	day2 = _tmp5_;
	if (year1 == year2) {
		_tmp7_ = month1 == month2;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		_tmp6_ = day1 == day2;
	} else {
		_tmp6_ = FALSE;
	}
	result = _tmp6_;
	return result;
}

UtilDateCoarseDate
util_date_as_coarse_date (GDateTime* datetime,
                          GDateTime* now,
                          GTimeSpan diff)
{
	UtilDateCoarseDate result;
	g_return_val_if_fail (datetime != NULL, 0);
	g_return_val_if_fail (now != NULL, 0);
	if (util_date_same_day (datetime, now)) {
		if (diff < G_TIME_SPAN_MINUTE) {
			result = UTIL_DATE_COARSE_DATE_NOW;
			return result;
		}
		if (diff < G_TIME_SPAN_HOUR) {
			result = UTIL_DATE_COARSE_DATE_MINUTES;
			return result;
		}
		if (diff < (12 * G_TIME_SPAN_HOUR)) {
			result = UTIL_DATE_COARSE_DATE_HOURS;
			return result;
		}
		result = UTIL_DATE_COARSE_DATE_TODAY;
		return result;
	} else {
		GDateTime* temp = NULL;
		GDateTime* _tmp0_;
		GDateTime* _tmp1_;
		GDateTime* _tmp2_;
		gboolean _tmp3_ = FALSE;
		GDateTime* _tmp4_;
		if (g_date_time_compare (datetime, now) > 0) {
			result = UTIL_DATE_COARSE_DATE_FUTURE;
			return result;
		}
		_tmp0_ = g_date_time_add_days (datetime, 1);
		_g_date_time_unref0 (temp);
		temp = _tmp0_;
		_tmp1_ = temp;
		if (util_date_same_day (_tmp1_, now)) {
			result = UTIL_DATE_COARSE_DATE_YESTERDAY;
			_g_date_time_unref0 (temp);
			return result;
		}
		_tmp2_ = g_date_time_add_days (datetime, 6);
		_g_date_time_unref0 (temp);
		temp = _tmp2_;
		_tmp4_ = temp;
		if (util_date_same_day (_tmp4_, now)) {
			_tmp3_ = TRUE;
		} else {
			GDateTime* _tmp5_;
			_tmp5_ = temp;
			_tmp3_ = g_date_time_compare (_tmp5_, now) >= 0;
		}
		if (_tmp3_) {
			result = UTIL_DATE_COARSE_DATE_THIS_WEEK;
			_g_date_time_unref0 (temp);
			return result;
		}
		if (g_date_time_get_year (datetime) == g_date_time_get_year (now)) {
			result = UTIL_DATE_COARSE_DATE_THIS_YEAR;
			_g_date_time_unref0 (temp);
			return result;
		} else {
			result = UTIL_DATE_COARSE_DATE_YEARS;
			_g_date_time_unref0 (temp);
			return result;
		}
		_g_date_time_unref0 (temp);
	}
}

gchar*
util_date_pretty_print_coarse (UtilDateCoarseDate coarse_date,
                               UtilDateClockFormat clock_format,
                               GDateTime* datetime,
                               GTimeSpan diff)
{
	gchar* fmt = NULL;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* result;
	g_return_val_if_fail (datetime != NULL, NULL);
	switch (coarse_date) {
		case UTIL_DATE_COARSE_DATE_NOW:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup (_ ("Now"));
			result = _tmp0_;
			_g_free0 (fmt);
			return result;
		}
		case UTIL_DATE_COARSE_DATE_MINUTES:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup_printf (ngettext ("%dm ago", "%dm ago", (gulong) (diff / G_TIME_SPAN_MINUTE)), (gint) (diff / G_TIME_SPAN_MINUTE));
			result = _tmp1_;
			_g_free0 (fmt);
			return result;
		}
		case UTIL_DATE_COARSE_DATE_HOURS:
		{
			gint rounded = 0;
			gchar* _tmp2_;
			rounded = (gint) round (((gdouble) diff) / G_TIME_SPAN_HOUR);
			_tmp2_ = g_strdup_printf (ngettext ("%dh ago", "%dh ago", (gulong) rounded), rounded);
			result = _tmp2_;
			_g_free0 (fmt);
			return result;
		}
		case UTIL_DATE_COARSE_DATE_TODAY:
		{
			gchar* _tmp3_;
			_tmp3_ = util_date_get_clock_format (clock_format);
			_g_free0 (fmt);
			fmt = _tmp3_;
			break;
		}
		case UTIL_DATE_COARSE_DATE_YESTERDAY:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup (_ ("Yesterday"));
			result = _tmp4_;
			_g_free0 (fmt);
			return result;
		}
		case UTIL_DATE_COARSE_DATE_THIS_WEEK:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup (_ ("%A"));
			_g_free0 (fmt);
			fmt = _tmp5_;
			break;
		}
		case UTIL_DATE_COARSE_DATE_THIS_YEAR:
		{
			const gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp6_ = util_date_xlat_same_year;
			_tmp7_ = g_strdup (_tmp6_);
			_g_free0 (fmt);
			fmt = _tmp7_;
			break;
		}
		default:
		case UTIL_DATE_COARSE_DATE_YEARS:
		case UTIL_DATE_COARSE_DATE_FUTURE:
		{
			gchar* _tmp8_;
			_tmp8_ = g_strdup (UTIL_DATE_xlat_diff_year);
			_g_free0 (fmt);
			fmt = _tmp8_;
			break;
		}
	}
	_tmp9_ = fmt;
	_tmp10_ = g_date_time_format (datetime, _tmp9_);
	result = _tmp10_;
	_g_free0 (fmt);
	return result;
}

gchar*
util_date_pretty_print (GDateTime* datetime,
                        UtilDateClockFormat clock_format)
{
	GDateTime* to_local = NULL;
	GDateTime* _tmp0_;
	GDateTime* now = NULL;
	GDateTime* _tmp1_;
	GTimeSpan diff = 0LL;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (datetime != NULL, NULL);
	_tmp0_ = g_date_time_to_local (datetime);
	to_local = _tmp0_;
	_tmp1_ = g_date_time_new_now_local ();
	now = _tmp1_;
	diff = g_date_time_difference (now, to_local);
	_tmp2_ = util_date_pretty_print_coarse (util_date_as_coarse_date (to_local, now, diff), clock_format, to_local, diff);
	result = _tmp2_;
	_g_date_time_unref0 (now);
	_g_date_time_unref0 (to_local);
	return result;
}

gchar*
util_date_pretty_print_verbose (GDateTime* datetime,
                                UtilDateClockFormat clock_format)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (datetime != NULL, NULL);
	_tmp0_ = util_date_xlat_pretty_verbose_dates;
	_tmp0__length1 = util_date_xlat_pretty_verbose_dates_length1;
	_tmp1_ = _tmp0_[util_date_clock_format_to_index (clock_format)];
	_tmp2_ = g_date_time_format (datetime, _tmp1_);
	result = _tmp2_;
	return result;
}

gchar*
util_date_get_clock_format (UtilDateClockFormat clock_format)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	_tmp0_ = util_date_xlat_pretty_clocks;
	_tmp0__length1 = util_date_xlat_pretty_clocks_length1;
	_tmp1_ = _tmp0_[util_date_clock_format_to_index (clock_format)];
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

