/* geary-account.c generated by valac 0.56.3, the Vala compiler
 * generated from geary-account.vala, do not modify */

/*
 * Copyright 2016 Software Freedom Conservancy Inc.
 * Copyright 2018-2019 Michael Gratton <mike@vee.net>.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>

#define GEARY_ACCOUNT_AUTH_ATTEMPTS_MAX ((guint) 3)

enum  {
	GEARY_ACCOUNT_0_PROPERTY,
	GEARY_ACCOUNT_INFORMATION_PROPERTY,
	GEARY_ACCOUNT_CURRENT_STATUS_PROPERTY,
	GEARY_ACCOUNT_INCOMING_PROPERTY,
	GEARY_ACCOUNT_OUTGOING_PROPERTY,
	GEARY_ACCOUNT_CONTACT_STORE_PROPERTY,
	GEARY_ACCOUNT_LOCAL_FOLDER_ROOT_PROPERTY,
	GEARY_ACCOUNT_BACKGROUND_PROGRESS_PROPERTY,
	GEARY_ACCOUNT_DB_UPGRADE_MONITOR_PROPERTY,
	GEARY_ACCOUNT_DB_VACUUM_MONITOR_PROPERTY,
	GEARY_ACCOUNT_LAST_STORAGE_CLEANUP_PROPERTY,
	GEARY_ACCOUNT_LOGGING_PARENT_PROPERTY,
	GEARY_ACCOUNT_NUM_PROPERTIES
};
static GParamSpec* geary_account_properties[GEARY_ACCOUNT_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
enum  {
	GEARY_ACCOUNT_OPENED_SIGNAL,
	GEARY_ACCOUNT_CLOSED_SIGNAL,
	GEARY_ACCOUNT_REPORT_PROBLEM_SIGNAL,
	GEARY_ACCOUNT_FOLDERS_AVAILABLE_UNAVAILABLE_SIGNAL,
	GEARY_ACCOUNT_FOLDERS_CREATED_SIGNAL,
	GEARY_ACCOUNT_FOLDERS_DELETED_SIGNAL,
	GEARY_ACCOUNT_FOLDERS_USE_CHANGED_SIGNAL,
	GEARY_ACCOUNT_EMAIL_APPENDED_SIGNAL,
	GEARY_ACCOUNT_EMAIL_INSERTED_SIGNAL,
	GEARY_ACCOUNT_EMAIL_REMOVED_SIGNAL,
	GEARY_ACCOUNT_EMAIL_LOCALLY_REMOVED_SIGNAL,
	GEARY_ACCOUNT_EMAIL_LOCALLY_COMPLETE_SIGNAL,
	GEARY_ACCOUNT_EMAIL_DISCOVERED_SIGNAL,
	GEARY_ACCOUNT_EMAIL_FLAGS_CHANGED_SIGNAL,
	GEARY_ACCOUNT_NUM_SIGNALS
};
static guint geary_account_signals[GEARY_ACCOUNT_NUM_SIGNALS] = {0};

struct _GearyAccountPrivate {
	GearyAccountInformation* _information;
	GearyAccountStatus _current_status;
	GearyClientService* _incoming;
	GearyClientService* _outgoing;
	GearyContactStore* _contact_store;
	GearyFolderRoot* _local_folder_root;
	GearyProgressMonitor* _background_progress;
	GearyProgressMonitor* _db_upgrade_monitor;
	GearyProgressMonitor* _db_vacuum_monitor;
	GDateTime* _last_storage_cleanup;
};

struct _Block1Data {
	int _ref_count_;
	GearyAccount* self;
	GearyFolderSpecialUse use;
};

static gint GearyAccount_private_offset;
static gpointer geary_account_parent_class = NULL;
static GearyLoggingSourceIface * geary_account_geary_logging_source_parent_iface = NULL;

static gint _geary_account_folder_path_comparator_gcompare_data_func (gconstpointer a,
                                                               gconstpointer b,
                                                               gpointer self);
static void geary_account_set_incoming (GearyAccount* self,
                                 GearyClientService* value);
static void geary_account_set_outgoing (GearyAccount* self,
                                 GearyClientService* value);
static void geary_account_set_local_folder_root (GearyAccount* self,
                                          GearyFolderRoot* value);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static void geary_account_on_service_status_notify (GearyAccount* self);
static void _geary_account_on_service_status_notify_g_object_notify (GObject* _sender,
                                                              GParamSpec* pspec,
                                                              gpointer self);
static gboolean geary_account_real_is_open (GearyAccount* self);
static void geary_account_real_cancel_remote_update (GearyAccount* self);
static GearyEmailIdentifier* geary_account_real_to_email_identifier (GearyAccount* self,
                                                              GVariant* serialised,
                                                              GError** error);
static GearyFolderPath* geary_account_real_to_folder_path (GearyAccount* self,
                                                    GVariant* serialised,
                                                    GError** error);
static gboolean geary_account_real_has_folder (GearyAccount* self,
                                        GearyFolderPath* path);
static GearyFolder* geary_account_real_get_folder (GearyAccount* self,
                                            GearyFolderPath* path,
                                            GError** error);
static GeeCollection* geary_account_real_list_folders (GearyAccount* self);
static GeeCollection* geary_account_real_list_matching_folders (GearyAccount* self,
                                                         GearyFolderPath* parent,
                                                         GError** error);
static GearyFolder* geary_account_real_get_special_folder (GearyAccount* self,
                                                    GearyFolderSpecialUse use);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean __lambda126_ (Block1Data* _data1_,
                       GearyFolder* f);
static gboolean ___lambda126__gee_predicate (gconstpointer g,
                                      gpointer self);
static void geary_account_real_register_local_folder (GearyAccount* self,
                                               GearyFolder* local,
                                               GError** error);
static void geary_account_real_deregister_local_folder (GearyAccount* self,
                                                 GearyFolder* local,
                                                 GError** error);
static GearySearchQuery* geary_account_real_new_search_query (GearyAccount* self,
                                                       GeeList* expression,
                                                       const gchar* text,
                                                       GError** error);
static GearyLoggingState* geary_account_real_to_logging_state (GearyAccount* self);
static void geary_account_real_notify_opened (GearyAccount* self);
static void geary_account_real_notify_closed (GearyAccount* self);
static void geary_account_real_notify_folders_available_unavailable (GearyAccount* self,
                                                              GeeBidirSortedSet* available,
                                                              GeeBidirSortedSet* unavailable);
static void geary_account_real_notify_folders_created (GearyAccount* self,
                                                GeeBidirSortedSet* created);
static void geary_account_real_notify_folders_deleted (GearyAccount* self,
                                                GeeBidirSortedSet* deleted);
static void geary_account_real_notify_email_appended (GearyAccount* self,
                                               GearyFolder* folder,
                                               GeeCollection* ids);
static void geary_account_real_notify_email_inserted (GearyAccount* self,
                                               GearyFolder* folder,
                                               GeeCollection* ids);
static void geary_account_real_notify_email_removed (GearyAccount* self,
                                              GearyFolder* folder,
                                              GeeCollection* ids);
static void geary_account_real_notify_email_locally_removed (GearyAccount* self,
                                                      GearyFolder* folder,
                                                      GeeCollection* ids);
static void geary_account_real_notify_email_locally_complete (GearyAccount* self,
                                                       GearyFolder* folder,
                                                       GeeCollection* ids);
static void geary_account_real_notify_email_discovered (GearyAccount* self,
                                                 GearyFolder* folder,
                                                 GeeCollection* ids);
static void geary_account_real_notify_email_flags_changed (GearyAccount* self,
                                                    GearyFolder* folder,
                                                    GeeMap* flag_map);
static void geary_account_real_notify_report_problem (GearyAccount* self,
                                               GearyProblemReport* report);
static void geary_account_real_notify_account_problem (GearyAccount* self,
                                                GError* err);
static void geary_account_real_notify_service_problem (GearyAccount* self,
                                                GearyServiceInformation* service,
                                                GError* err);
static void geary_account_finalize (GObject * obj);
static GType geary_account_get_type_once (void);
static void _vala_geary_account_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec);
static void _vala_geary_account_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec);

static inline gpointer
geary_account_get_instance_private (GearyAccount* self)
{
	return G_STRUCT_MEMBER_P (self, GearyAccount_private_offset);
}

/**
     * Denotes the account's current status.
     *
     * @see Account.current_status
     * @see ClientService.current_status
     */
/** Determines if the {@link ONLINE} flag is set. */
gboolean
geary_account_status_is_online (GearyAccountStatus self)
{
	gboolean result;
	result = (self & GEARY_ACCOUNT_STATUS_ONLINE) == GEARY_ACCOUNT_STATUS_ONLINE;
	return result;
}

/** Determines if the {@link SERVICE_PROBLEM} flag is set. */
gboolean
geary_account_status_has_service_problem (GearyAccountStatus self)
{
	gboolean result;
	result = (self & GEARY_ACCOUNT_STATUS_SERVICE_PROBLEM) == GEARY_ACCOUNT_STATUS_SERVICE_PROBLEM;
	return result;
}

 G_GNUC_NO_INLINE static GType
geary_account_status_get_type_once (void)
{
	static const GFlagsValue values[] = {{GEARY_ACCOUNT_STATUS_ONLINE, "GEARY_ACCOUNT_STATUS_ONLINE", "online"}, {GEARY_ACCOUNT_STATUS_SERVICE_PROBLEM, "GEARY_ACCOUNT_STATUS_SERVICE_PROBLEM", "service-problem"}, {0, NULL, NULL}};
	GType geary_account_status_type_id;
	geary_account_status_type_id = g_flags_register_static ("GearyAccountStatus", values);
	return geary_account_status_type_id;
}

GType
geary_account_status_get_type (void)
{
	static gsize geary_account_status_type_id__once = 0;
	if (g_once_init_enter (&geary_account_status_type_id__once)) {
		GType geary_account_status_type_id;
		geary_account_status_type_id = geary_account_status_get_type_once ();
		g_once_init_leave (&geary_account_status_type_id__once, geary_account_status_type_id);
	}
	return geary_account_status_type_id__once;
}

/**
     * A utility method to sort a Gee.Collection of {@link Folder}s by
     * their {@link FolderPath}s to ensure they comport with {@link
     * folders_available_unavailable}, {@link folders_created}, {@link
     * folders_deleted} signals' contracts.
     */
static gint
_geary_account_folder_path_comparator_gcompare_data_func (gconstpointer a,
                                                          gconstpointer b,
                                                          gpointer self)
{
	gint result;
	result = geary_account_folder_path_comparator ((GearyFolder*) a, (GearyFolder*) b);
	return result;
}

GeeBidirSortedSet*
geary_account_sort_by_path (GeeCollection* folders)
{
	GeeTreeSet* sorted = NULL;
	GeeTreeSet* _tmp0_;
	GeeBidirSortedSet* result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (folders, GEE_TYPE_COLLECTION), NULL);
	_tmp0_ = gee_tree_set_new (GEARY_TYPE_FOLDER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _geary_account_folder_path_comparator_gcompare_data_func, NULL, NULL);
	sorted = _tmp0_;
	gee_collection_add_all (G_TYPE_CHECK_INSTANCE_CAST (sorted, GEE_TYPE_COLLECTION, GeeCollection), folders);
	result = G_TYPE_CHECK_INSTANCE_CAST (sorted, GEE_TYPE_BIDIR_SORTED_SET, GeeBidirSortedSet);
	return result;
}

/**
     * Comparator used to sort folders.
     *
     * @see sort_by_path
     */
gint
geary_account_folder_path_comparator (GearyFolder* a,
                                      GearyFolder* b)
{
	GearyFolderPath* _tmp0_;
	GearyFolderPath* _tmp1_;
	GearyFolderPath* _tmp2_;
	GearyFolderPath* _tmp3_;
	gint result;
	g_return_val_if_fail (GEARY_IS_FOLDER (a), 0);
	g_return_val_if_fail (GEARY_IS_FOLDER (b), 0);
	_tmp0_ = geary_folder_get_path (a);
	_tmp1_ = _tmp0_;
	_tmp2_ = geary_folder_get_path (b);
	_tmp3_ = _tmp2_;
	result = gee_comparable_compare_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COMPARABLE, GeeComparable), _tmp3_);
	return result;
}

GearyAccountInformation*
geary_account_get_information (GearyAccount* self)
{
	GearyAccountInformation* result;
	GearyAccountInformation* _tmp0_;
	g_return_val_if_fail (GEARY_IS_ACCOUNT (self), NULL);
	_tmp0_ = self->priv->_information;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
geary_account_set_information (GearyAccount* self,
                               GearyAccountInformation* value)
{
	GearyAccountInformation* old_value;
	g_return_if_fail (GEARY_IS_ACCOUNT (self));
	old_value = geary_account_get_information (self);
	if (old_value != value) {
		GearyAccountInformation* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_information);
		self->priv->_information = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_account_properties[GEARY_ACCOUNT_INFORMATION_PROPERTY]);
	}
}

GearyAccountStatus
geary_account_get_current_status (GearyAccount* self)
{
	GearyAccountStatus result;
	g_return_val_if_fail (GEARY_IS_ACCOUNT (self), 0U);
	result = self->priv->_current_status;
	return result;
}

void
geary_account_set_current_status (GearyAccount* self,
                                  GearyAccountStatus value)
{
	GearyAccountStatus old_value;
	g_return_if_fail (GEARY_IS_ACCOUNT (self));
	old_value = geary_account_get_current_status (self);
	if (old_value != value) {
		self->priv->_current_status = value;
		g_object_notify_by_pspec ((GObject *) self, geary_account_properties[GEARY_ACCOUNT_CURRENT_STATUS_PROPERTY]);
	}
}

GearyClientService*
geary_account_get_incoming (GearyAccount* self)
{
	GearyClientService* result;
	GearyClientService* _tmp0_;
	g_return_val_if_fail (GEARY_IS_ACCOUNT (self), NULL);
	_tmp0_ = self->priv->_incoming;
	result = _tmp0_;
	return result;
}

static void
geary_account_set_incoming (GearyAccount* self,
                            GearyClientService* value)
{
	GearyClientService* old_value;
	g_return_if_fail (GEARY_IS_ACCOUNT (self));
	old_value = geary_account_get_incoming (self);
	if (old_value != value) {
		GearyClientService* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_incoming);
		self->priv->_incoming = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_account_properties[GEARY_ACCOUNT_INCOMING_PROPERTY]);
	}
}

GearyClientService*
geary_account_get_outgoing (GearyAccount* self)
{
	GearyClientService* result;
	GearyClientService* _tmp0_;
	g_return_val_if_fail (GEARY_IS_ACCOUNT (self), NULL);
	_tmp0_ = self->priv->_outgoing;
	result = _tmp0_;
	return result;
}

static void
geary_account_set_outgoing (GearyAccount* self,
                            GearyClientService* value)
{
	GearyClientService* old_value;
	g_return_if_fail (GEARY_IS_ACCOUNT (self));
	old_value = geary_account_get_outgoing (self);
	if (old_value != value) {
		GearyClientService* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_outgoing);
		self->priv->_outgoing = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_account_properties[GEARY_ACCOUNT_OUTGOING_PROPERTY]);
	}
}

GearyContactStore*
geary_account_get_contact_store (GearyAccount* self)
{
	GearyContactStore* result;
	GearyContactStore* _tmp0_;
	g_return_val_if_fail (GEARY_IS_ACCOUNT (self), NULL);
	_tmp0_ = self->priv->_contact_store;
	result = _tmp0_;
	return result;
}

void
geary_account_set_contact_store (GearyAccount* self,
                                 GearyContactStore* value)
{
	GearyContactStore* old_value;
	g_return_if_fail (GEARY_IS_ACCOUNT (self));
	old_value = geary_account_get_contact_store (self);
	if (old_value != value) {
		GearyContactStore* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_contact_store);
		self->priv->_contact_store = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_account_properties[GEARY_ACCOUNT_CONTACT_STORE_PROPERTY]);
	}
}

GearyFolderRoot*
geary_account_get_local_folder_root (GearyAccount* self)
{
	GearyFolderRoot* result;
	GearyFolderRoot* _tmp0_;
	g_return_val_if_fail (GEARY_IS_ACCOUNT (self), NULL);
	_tmp0_ = self->priv->_local_folder_root;
	result = _tmp0_;
	return result;
}

static void
geary_account_set_local_folder_root (GearyAccount* self,
                                     GearyFolderRoot* value)
{
	GearyFolderRoot* old_value;
	g_return_if_fail (GEARY_IS_ACCOUNT (self));
	old_value = geary_account_get_local_folder_root (self);
	if (old_value != value) {
		GearyFolderRoot* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_local_folder_root);
		self->priv->_local_folder_root = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_account_properties[GEARY_ACCOUNT_LOCAL_FOLDER_ROOT_PROPERTY]);
	}
}

GearyProgressMonitor*
geary_account_get_background_progress (GearyAccount* self)
{
	GearyProgressMonitor* result;
	GearyProgressMonitor* _tmp0_;
	g_return_val_if_fail (GEARY_IS_ACCOUNT (self), NULL);
	_tmp0_ = self->priv->_background_progress;
	result = _tmp0_;
	return result;
}

void
geary_account_set_background_progress (GearyAccount* self,
                                       GearyProgressMonitor* value)
{
	GearyProgressMonitor* old_value;
	g_return_if_fail (GEARY_IS_ACCOUNT (self));
	old_value = geary_account_get_background_progress (self);
	if (old_value != value) {
		GearyProgressMonitor* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_background_progress);
		self->priv->_background_progress = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_account_properties[GEARY_ACCOUNT_BACKGROUND_PROGRESS_PROPERTY]);
	}
}

GearyProgressMonitor*
geary_account_get_db_upgrade_monitor (GearyAccount* self)
{
	GearyProgressMonitor* result;
	GearyProgressMonitor* _tmp0_;
	g_return_val_if_fail (GEARY_IS_ACCOUNT (self), NULL);
	_tmp0_ = self->priv->_db_upgrade_monitor;
	result = _tmp0_;
	return result;
}

void
geary_account_set_db_upgrade_monitor (GearyAccount* self,
                                      GearyProgressMonitor* value)
{
	GearyProgressMonitor* old_value;
	g_return_if_fail (GEARY_IS_ACCOUNT (self));
	old_value = geary_account_get_db_upgrade_monitor (self);
	if (old_value != value) {
		GearyProgressMonitor* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_db_upgrade_monitor);
		self->priv->_db_upgrade_monitor = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_account_properties[GEARY_ACCOUNT_DB_UPGRADE_MONITOR_PROPERTY]);
	}
}

GearyProgressMonitor*
geary_account_get_db_vacuum_monitor (GearyAccount* self)
{
	GearyProgressMonitor* result;
	GearyProgressMonitor* _tmp0_;
	g_return_val_if_fail (GEARY_IS_ACCOUNT (self), NULL);
	_tmp0_ = self->priv->_db_vacuum_monitor;
	result = _tmp0_;
	return result;
}

void
geary_account_set_db_vacuum_monitor (GearyAccount* self,
                                     GearyProgressMonitor* value)
{
	GearyProgressMonitor* old_value;
	g_return_if_fail (GEARY_IS_ACCOUNT (self));
	old_value = geary_account_get_db_vacuum_monitor (self);
	if (old_value != value) {
		GearyProgressMonitor* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_db_vacuum_monitor);
		self->priv->_db_vacuum_monitor = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_account_properties[GEARY_ACCOUNT_DB_VACUUM_MONITOR_PROPERTY]);
	}
}

GDateTime*
geary_account_get_last_storage_cleanup (GearyAccount* self)
{
	GDateTime* result;
	GDateTime* _tmp0_;
	g_return_val_if_fail (GEARY_IS_ACCOUNT (self), NULL);
	_tmp0_ = self->priv->_last_storage_cleanup;
	result = _tmp0_;
	return result;
}

static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

void
geary_account_set_last_storage_cleanup (GearyAccount* self,
                                        GDateTime* value)
{
	GDateTime* old_value;
	g_return_if_fail (GEARY_IS_ACCOUNT (self));
	old_value = geary_account_get_last_storage_cleanup (self);
	if (old_value != value) {
		GDateTime* _tmp0_;
		_tmp0_ = _g_date_time_ref0 (value);
		_g_date_time_unref0 (self->priv->_last_storage_cleanup);
		self->priv->_last_storage_cleanup = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_account_properties[GEARY_ACCOUNT_LAST_STORAGE_CLEANUP_PROPERTY]);
	}
}

static void
g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), data2);
}

static GearyLoggingSource*
geary_account_real_get_logging_parent (GearyLoggingSource* base)
{
	GearyLoggingSource* result;
	GearyAccount* self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_TYPE_ACCOUNT, GearyAccount);
	result = NULL;
	return result;
}

static void
_geary_account_on_service_status_notify_g_object_notify (GObject* _sender,
                                                         GParamSpec* pspec,
                                                         gpointer self)
{
	geary_account_on_service_status_notify ((GearyAccount*) self);
}

GearyAccount*
geary_account_construct (GType object_type,
                         GearyAccountInformation* information,
                         GearyClientService* incoming,
                         GearyClientService* outgoing)
{
	GearyAccount * self = NULL;
	g_return_val_if_fail (GEARY_IS_ACCOUNT_INFORMATION (information), NULL);
	g_return_val_if_fail (GEARY_IS_CLIENT_SERVICE (incoming), NULL);
	g_return_val_if_fail (GEARY_IS_CLIENT_SERVICE (outgoing), NULL);
	self = (GearyAccount*) geary_base_object_construct (object_type);
	geary_account_set_information (self, information);
	geary_account_set_incoming (self, incoming);
	geary_account_set_outgoing (self, outgoing);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (incoming, G_TYPE_OBJECT, GObject), "notify::current-status", (GCallback) _geary_account_on_service_status_notify_g_object_notify, self, 0);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (outgoing, G_TYPE_OBJECT, GObject), "notify::current-status", (GCallback) _geary_account_on_service_status_notify_g_object_notify, self, 0);
	return self;
}

void
geary_account_open_async (GearyAccount* self,
                          GCancellable* cancellable,
                          GAsyncReadyCallback _callback_,
                          gpointer _user_data_)
{
	GearyAccountClass* _klass_;
	_klass_ = GEARY_ACCOUNT_GET_CLASS (self);
	if (_klass_->open_async) {
		_klass_->open_async (self, cancellable, _callback_, _user_data_);
	}
}

void
geary_account_open_finish (GearyAccount* self,
                           GAsyncResult* _res_,
                           GError** error)
{
	GearyAccountClass* _klass_;
	_klass_ = GEARY_ACCOUNT_GET_CLASS (self);
	if (_klass_->open_finish) {
		_klass_->open_finish (self, _res_, error);
	}
}

void
geary_account_close_async (GearyAccount* self,
                           GCancellable* cancellable,
                           GAsyncReadyCallback _callback_,
                           gpointer _user_data_)
{
	GearyAccountClass* _klass_;
	_klass_ = GEARY_ACCOUNT_GET_CLASS (self);
	if (_klass_->close_async) {
		_klass_->close_async (self, cancellable, _callback_, _user_data_);
	}
}

void
geary_account_close_finish (GearyAccount* self,
                            GAsyncResult* _res_,
                            GError** error)
{
	GearyAccountClass* _klass_;
	_klass_ = GEARY_ACCOUNT_GET_CLASS (self);
	if (_klass_->close_finish) {
		_klass_->close_finish (self, _res_, error);
	}
}

/**
     * Returns true if this account is open, else false.
     */
static gboolean
geary_account_real_is_open (GearyAccount* self)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `geary_account_is_open'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
geary_account_is_open (GearyAccount* self)
{
	GearyAccountClass* _klass_;
	g_return_val_if_fail (GEARY_IS_ACCOUNT (self), FALSE);
	_klass_ = GEARY_ACCOUNT_GET_CLASS (self);
	if (_klass_->is_open) {
		return _klass_->is_open (self);
	}
	return FALSE;
}

/**
     * Cancel any running/pending remote update for this {@link Account}.
     */
static void
geary_account_real_cancel_remote_update (GearyAccount* self)
{
	g_critical ("Type `%s' does not implement abstract method `geary_account_cancel_remote_update'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
geary_account_cancel_remote_update (GearyAccount* self)
{
	GearyAccountClass* _klass_;
	g_return_if_fail (GEARY_IS_ACCOUNT (self));
	_klass_ = GEARY_ACCOUNT_GET_CLASS (self);
	if (_klass_->cancel_remote_update) {
		_klass_->cancel_remote_update (self);
	}
}

void
geary_account_rebuild_async (GearyAccount* self,
                             GCancellable* cancellable,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_)
{
	GearyAccountClass* _klass_;
	_klass_ = GEARY_ACCOUNT_GET_CLASS (self);
	if (_klass_->rebuild_async) {
		_klass_->rebuild_async (self, cancellable, _callback_, _user_data_);
	}
}

void
geary_account_rebuild_finish (GearyAccount* self,
                              GAsyncResult* _res_,
                              GError** error)
{
	GearyAccountClass* _klass_;
	_klass_ = GEARY_ACCOUNT_GET_CLASS (self);
	if (_klass_->rebuild_finish) {
		_klass_->rebuild_finish (self, _res_, error);
	}
}

/**
     * Returns an email identifier from its serialised form.
     *
     * This is useful for converting a string representation of a
     * email id back into an actual instance of an id. This does not
     * guarantee that the email represented by the id will exist.
     *
     * @see EmailIdentifier.to_variant
     * @throws EngineError.BAD_PARAMETERS when the variant is not the
     * have the correct type.
     */
static GearyEmailIdentifier*
geary_account_real_to_email_identifier (GearyAccount* self,
                                        GVariant* serialised,
                                        GError** error)
{
	g_critical ("Type `%s' does not implement abstract method `geary_account_to_email_identifier'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

GearyEmailIdentifier*
geary_account_to_email_identifier (GearyAccount* self,
                                   GVariant* serialised,
                                   GError** error)
{
	GearyAccountClass* _klass_;
	g_return_val_if_fail (GEARY_IS_ACCOUNT (self), NULL);
	_klass_ = GEARY_ACCOUNT_GET_CLASS (self);
	if (_klass_->to_email_identifier) {
		return _klass_->to_email_identifier (self, serialised, error);
	}
	return NULL;
}

/**
     * Returns the folder path from its serialised form.
     *
     * This is useful for converting a string representation of a
     * folder path back into an actual instance of a path. This does
     * not guarantee that the folder represented by the path will
     * exist.
     *
     * @see FolderPath.to_variant
     * @throws EngineError.BAD_PARAMETERS when the variant is not the
     * have the correct type or if no folder root with an appropriate
     * label exists.
     */
static GearyFolderPath*
geary_account_real_to_folder_path (GearyAccount* self,
                                   GVariant* serialised,
                                   GError** error)
{
	g_critical ("Type `%s' does not implement abstract method `geary_account_to_folder_path'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

GearyFolderPath*
geary_account_to_folder_path (GearyAccount* self,
                              GVariant* serialised,
                              GError** error)
{
	GearyAccountClass* _klass_;
	g_return_val_if_fail (GEARY_IS_ACCOUNT (self), NULL);
	_klass_ = GEARY_ACCOUNT_GET_CLASS (self);
	if (_klass_->to_folder_path) {
		return _klass_->to_folder_path (self, serialised, error);
	}
	return NULL;
}

/**
     * Determines if a folder is known to the engine.
     *
     * This method only considers currently known folders, it does not
     * check the remote to see if a previously folder exists.
     */
static gboolean
geary_account_real_has_folder (GearyAccount* self,
                               GearyFolderPath* path)
{
	gboolean _tmp3_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (GEARY_IS_FOLDER_PATH (path), FALSE);
	{
		GearyFolder* _tmp0_;
		GearyFolder* _tmp1_;
		_tmp0_ = geary_account_get_folder (self, path, &_inner_error0_);
		_tmp1_ = _tmp0_;
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp2_ = FALSE;
			if (g_error_matches (_inner_error0_, GEARY_ENGINE_ERROR, GEARY_ENGINE_ERROR_NOT_FOUND)) {
				goto __catch0_geary_engine_error_not_found;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp2_;
		}
		result = TRUE;
		return result;
	}
	goto __finally0;
	__catch0_geary_engine_error_not_found:
	{
		g_clear_error (&_inner_error0_);
		result = FALSE;
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp3_;
}

gboolean
geary_account_has_folder (GearyAccount* self,
                          GearyFolderPath* path)
{
	GearyAccountClass* _klass_;
	g_return_val_if_fail (GEARY_IS_ACCOUNT (self), FALSE);
	_klass_ = GEARY_ACCOUNT_GET_CLASS (self);
	if (_klass_->has_folder) {
		return _klass_->has_folder (self, path);
	}
	return FALSE;
}

/**
     * Returns the folder represented by a specific path.
     *
     * This method only considers currently known folders, it does not
     * check the remote to see if a previously folder exists.
     *
     * @throws EngineError.NOT_FOUND if the folder does not exist.
     */
static GearyFolder*
geary_account_real_get_folder (GearyAccount* self,
                               GearyFolderPath* path,
                               GError** error)
{
	g_critical ("Type `%s' does not implement abstract method `geary_account_get_folder'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

GearyFolder*
geary_account_get_folder (GearyAccount* self,
                          GearyFolderPath* path,
                          GError** error)
{
	GearyAccountClass* _klass_;
	g_return_val_if_fail (GEARY_IS_ACCOUNT (self), NULL);
	_klass_ = GEARY_ACCOUNT_GET_CLASS (self);
	if (_klass_->get_folder) {
		return _klass_->get_folder (self, path, error);
	}
	return NULL;
}

/**
     * Lists all currently-available folders.
     *
     * @see list_matching_folders
     */
static GeeCollection*
geary_account_real_list_folders (GearyAccount* self)
{
	g_critical ("Type `%s' does not implement abstract method `geary_account_list_folders'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

GeeCollection*
geary_account_list_folders (GearyAccount* self)
{
	GearyAccountClass* _klass_;
	g_return_val_if_fail (GEARY_IS_ACCOUNT (self), NULL);
	_klass_ = GEARY_ACCOUNT_GET_CLASS (self);
	if (_klass_->list_folders) {
		return _klass_->list_folders (self);
	}
	return NULL;
}

/**
     * Lists all currently-available folders found a under parent.
     *
     * If the parent path cannot be found, EngineError.NOT_FOUND is
     * thrown. However, the caller should be prepared to deal with an
     * empty list being returned instead.
     */
static GeeCollection*
geary_account_real_list_matching_folders (GearyAccount* self,
                                          GearyFolderPath* parent,
                                          GError** error)
{
	g_critical ("Type `%s' does not implement abstract method `geary_account_list_matching_folders'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

GeeCollection*
geary_account_list_matching_folders (GearyAccount* self,
                                     GearyFolderPath* parent,
                                     GError** error)
{
	GearyAccountClass* _klass_;
	g_return_val_if_fail (GEARY_IS_ACCOUNT (self), NULL);
	_klass_ = GEARY_ACCOUNT_GET_CLASS (self);
	if (_klass_->list_matching_folders) {
		return _klass_->list_matching_folders (self, parent, error);
	}
	return NULL;
}

/**
     * Returns a folder for the given special folder type, it is exists.
     */
static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		GearyAccount* self;
		self = _data1_->self;
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static gboolean
__lambda126_ (Block1Data* _data1_,
              GearyFolder* f)
{
	GearyAccount* self;
	GearyFolderSpecialUse _tmp0_;
	GearyFolderSpecialUse _tmp1_;
	gboolean result;
	self = _data1_->self;
	g_return_val_if_fail (GEARY_IS_FOLDER (f), FALSE);
	_tmp0_ = geary_folder_get_used_as (f);
	_tmp1_ = _tmp0_;
	result = _tmp1_ == _data1_->use;
	return result;
}

static gboolean
___lambda126__gee_predicate (gconstpointer g,
                             gpointer self)
{
	gboolean result;
	result = __lambda126_ (self, (GearyFolder*) g);
	return result;
}

static GearyFolder*
geary_account_real_get_special_folder (GearyAccount* self,
                                       GearyFolderSpecialUse use)
{
	Block1Data* _data1_;
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	GearyIterable* _tmp2_;
	GearyIterable* _tmp3_;
	gpointer _tmp4_;
	GearyFolder* _tmp5_;
	GearyFolder* result;
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_data1_->use = use;
	_tmp0_ = geary_account_list_folders (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = geary_traverse (GEARY_TYPE_FOLDER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ITERABLE, GeeIterable));
	_tmp3_ = _tmp2_;
	_tmp4_ = geary_iterable_first_matching (_tmp3_, ___lambda126__gee_predicate, block1_data_ref (_data1_), block1_data_unref);
	_tmp5_ = (GearyFolder*) _tmp4_;
	_g_object_unref0 (_tmp3_);
	_g_object_unref0 (_tmp1_);
	result = _tmp5_;
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}

GearyFolder*
geary_account_get_special_folder (GearyAccount* self,
                                  GearyFolderSpecialUse use)
{
	GearyAccountClass* _klass_;
	g_return_val_if_fail (GEARY_IS_ACCOUNT (self), NULL);
	_klass_ = GEARY_ACCOUNT_GET_CLASS (self);
	if (_klass_->get_special_folder) {
		return _klass_->get_special_folder (self, use);
	}
	return NULL;
}

void
geary_account_get_required_special_folder_async (GearyAccount* self,
                                                 GearyFolderSpecialUse special,
                                                 GCancellable* cancellable,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_)
{
	GearyAccountClass* _klass_;
	_klass_ = GEARY_ACCOUNT_GET_CLASS (self);
	if (_klass_->get_required_special_folder_async) {
		_klass_->get_required_special_folder_async (self, special, cancellable, _callback_, _user_data_);
	}
}

GearyFolder*
geary_account_get_required_special_folder_finish (GearyAccount* self,
                                                  GAsyncResult* _res_,
                                                  GError** error)
{
	GearyAccountClass* _klass_;
	_klass_ = GEARY_ACCOUNT_GET_CLASS (self);
	if (_klass_->get_required_special_folder_finish) {
		return _klass_->get_required_special_folder_finish (self, _res_, error);
	}
	return NULL;
}

void
geary_account_create_personal_folder (GearyAccount* self,
                                      const gchar* name,
                                      GearyFolderSpecialUse use,
                                      GCancellable* cancellable,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	GearyAccountClass* _klass_;
	_klass_ = GEARY_ACCOUNT_GET_CLASS (self);
	if (_klass_->create_personal_folder) {
		_klass_->create_personal_folder (self, name, use, cancellable, _callback_, _user_data_);
	}
}

GearyFolder*
geary_account_create_personal_folder_finish (GearyAccount* self,
                                             GAsyncResult* _res_,
                                             GError** error)
{
	GearyAccountClass* _klass_;
	_klass_ = GEARY_ACCOUNT_GET_CLASS (self);
	if (_klass_->create_personal_folder_finish) {
		return _klass_->create_personal_folder_finish (self, _res_, error);
	}
	return NULL;
}

/**
     * Registers a local folder with the account.
     *
     * The registering a local folder will cause the account will hook
     * to the folder's signals such as {@link Folder.email_appended}
     * and forward them on to the account-wide equivalents, include
     * the list folder in the folder list, allow email in the folder
     * to be found by account-wide operations, and so on. The folder
     * will then be signalled as being available via {@link
     * folders_available_unavailable}.
     *
     * A {@link EngineError.ALREADY_EXISTS} exception will be thrown
     * if the given folder is already registered, or {@link
     * EngineError.NOT_FOUND} if its path does not have {@link
     * local_folder_root} as its root.
     *
     * @see deregister_local_folder
     */
static void
geary_account_real_register_local_folder (GearyAccount* self,
                                          GearyFolder* local,
                                          GError** error)
{
	g_critical ("Type `%s' does not implement abstract method `geary_account_register_local_folder'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
geary_account_register_local_folder (GearyAccount* self,
                                     GearyFolder* local,
                                     GError** error)
{
	GearyAccountClass* _klass_;
	g_return_if_fail (GEARY_IS_ACCOUNT (self));
	_klass_ = GEARY_ACCOUNT_GET_CLASS (self);
	if (_klass_->register_local_folder) {
		_klass_->register_local_folder (self, local, error);
	}
}

/**
     * De-registers a local folder with the account.
     *
     * De-registering a previously registered local folder will signal
     * it as being unavailable via {@link
     * folders_available_unavailable} and unhook it from the account.
     *
     * A {@link local_folder_root} error will be thrown if the given
     * folder is not already registered.
     *
     * @see register_local_folder
     */
static void
geary_account_real_deregister_local_folder (GearyAccount* self,
                                            GearyFolder* local,
                                            GError** error)
{
	g_critical ("Type `%s' does not implement abstract method `geary_account_deregister_local_folder'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
geary_account_deregister_local_folder (GearyAccount* self,
                                       GearyFolder* local,
                                       GError** error)
{
	GearyAccountClass* _klass_;
	g_return_if_fail (GEARY_IS_ACCOUNT (self));
	_klass_ = GEARY_ACCOUNT_GET_CLASS (self);
	if (_klass_->deregister_local_folder) {
		_klass_->deregister_local_folder (self, local, error);
	}
}

void
geary_account_local_search_message_id_async (GearyAccount* self,
                                             GearyRFC822MessageID* message_id,
                                             GearyEmailField requested_fields,
                                             gboolean partial_ok,
                                             GeeCollection* folder_blacklist,
                                             GearyEmailFlags* flag_blacklist,
                                             GCancellable* cancellable,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_)
{
	GearyAccountClass* _klass_;
	_klass_ = GEARY_ACCOUNT_GET_CLASS (self);
	if (_klass_->local_search_message_id_async) {
		_klass_->local_search_message_id_async (self, message_id, requested_fields, partial_ok, folder_blacklist, flag_blacklist, cancellable, _callback_, _user_data_);
	}
}

GeeMultiMap*
geary_account_local_search_message_id_finish (GearyAccount* self,
                                              GAsyncResult* _res_,
                                              GError** error)
{
	GearyAccountClass* _klass_;
	_klass_ = GEARY_ACCOUNT_GET_CLASS (self);
	if (_klass_->local_search_message_id_finish) {
		return _klass_->local_search_message_id_finish (self, _res_, error);
	}
	return NULL;
}

void
geary_account_local_fetch_email_async (GearyAccount* self,
                                       GearyEmailIdentifier* email_id,
                                       GearyEmailField required_fields,
                                       GCancellable* cancellable,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_)
{
	GearyAccountClass* _klass_;
	_klass_ = GEARY_ACCOUNT_GET_CLASS (self);
	if (_klass_->local_fetch_email_async) {
		_klass_->local_fetch_email_async (self, email_id, required_fields, cancellable, _callback_, _user_data_);
	}
}

GearyEmail*
geary_account_local_fetch_email_finish (GearyAccount* self,
                                        GAsyncResult* _res_,
                                        GError** error)
{
	GearyAccountClass* _klass_;
	_klass_ = GEARY_ACCOUNT_GET_CLASS (self);
	if (_klass_->local_fetch_email_finish) {
		return _klass_->local_fetch_email_finish (self, _res_, error);
	}
	return NULL;
}

void
geary_account_list_local_email_async (GearyAccount* self,
                                      GeeCollection* ids,
                                      GearyEmailField required_fields,
                                      GCancellable* cancellable,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	GearyAccountClass* _klass_;
	_klass_ = GEARY_ACCOUNT_GET_CLASS (self);
	if (_klass_->list_local_email_async) {
		_klass_->list_local_email_async (self, ids, required_fields, cancellable, _callback_, _user_data_);
	}
}

GeeList*
geary_account_list_local_email_finish (GearyAccount* self,
                                       GAsyncResult* _res_,
                                       GError** error)
{
	GearyAccountClass* _klass_;
	_klass_ = GEARY_ACCOUNT_GET_CLASS (self);
	if (_klass_->list_local_email_finish) {
		return _klass_->list_local_email_finish (self, _res_, error);
	}
	return NULL;
}

/**
     * Create a new search query for this account.
     */
static GearySearchQuery*
geary_account_real_new_search_query (GearyAccount* self,
                                     GeeList* expression,
                                     const gchar* text,
                                     GError** error)
{
	g_critical ("Type `%s' does not implement abstract method `geary_account_new_search_query'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

GearySearchQuery*
geary_account_new_search_query (GearyAccount* self,
                                GeeList* expression,
                                const gchar* text,
                                GError** error)
{
	GearyAccountClass* _klass_;
	g_return_val_if_fail (GEARY_IS_ACCOUNT (self), NULL);
	_klass_ = GEARY_ACCOUNT_GET_CLASS (self);
	if (_klass_->new_search_query) {
		return _klass_->new_search_query (self, expression, text, error);
	}
	return NULL;
}

void
geary_account_local_search_async (GearyAccount* self,
                                  GearySearchQuery* query,
                                  gint limit,
                                  gint offset,
                                  GeeCollection* folder_blacklist,
                                  GeeCollection* search_ids,
                                  GCancellable* cancellable,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_)
{
	GearyAccountClass* _klass_;
	_klass_ = GEARY_ACCOUNT_GET_CLASS (self);
	if (_klass_->local_search_async) {
		_klass_->local_search_async (self, query, limit, offset, folder_blacklist, search_ids, cancellable, _callback_, _user_data_);
	}
}

GeeCollection*
geary_account_local_search_finish (GearyAccount* self,
                                   GAsyncResult* _res_,
                                   GError** error)
{
	GearyAccountClass* _klass_;
	_klass_ = GEARY_ACCOUNT_GET_CLASS (self);
	if (_klass_->local_search_finish) {
		return _klass_->local_search_finish (self, _res_, error);
	}
	return NULL;
}

void
geary_account_get_search_matches_async (GearyAccount* self,
                                        GearySearchQuery* query,
                                        GeeCollection* ids,
                                        GCancellable* cancellable,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	GearyAccountClass* _klass_;
	_klass_ = GEARY_ACCOUNT_GET_CLASS (self);
	if (_klass_->get_search_matches_async) {
		_klass_->get_search_matches_async (self, query, ids, cancellable, _callback_, _user_data_);
	}
}

GeeSet*
geary_account_get_search_matches_finish (GearyAccount* self,
                                         GAsyncResult* _res_,
                                         GError** error)
{
	GearyAccountClass* _klass_;
	_klass_ = GEARY_ACCOUNT_GET_CLASS (self);
	if (_klass_->get_search_matches_finish) {
		return _klass_->get_search_matches_finish (self, _res_, error);
	}
	return NULL;
}

void
geary_account_get_containing_folders_async (GearyAccount* self,
                                            GeeCollection* ids,
                                            GCancellable* cancellable,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_)
{
	GearyAccountClass* _klass_;
	_klass_ = GEARY_ACCOUNT_GET_CLASS (self);
	if (_klass_->get_containing_folders_async) {
		_klass_->get_containing_folders_async (self, ids, cancellable, _callback_, _user_data_);
	}
}

GeeMultiMap*
geary_account_get_containing_folders_finish (GearyAccount* self,
                                             GAsyncResult* _res_,
                                             GError** error)
{
	GearyAccountClass* _klass_;
	_klass_ = GEARY_ACCOUNT_GET_CLASS (self);
	if (_klass_->get_containing_folders_finish) {
		return _klass_->get_containing_folders_finish (self, _res_, error);
	}
	return NULL;
}

/** {@inheritDoc} */
static GearyLoggingState*
geary_account_real_to_logging_state (GearyAccount* self)
{
	GearyAccountInformation* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GearyLoggingState* _tmp3_;
	GearyLoggingState* result;
	_tmp0_ = self->priv->_information;
	_tmp1_ = geary_account_information_get_id (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = geary_logging_state_new (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "%s", _tmp2_);
	result = _tmp3_;
	return result;
}

GearyLoggingState*
geary_account_to_logging_state (GearyAccount* self)
{
	GearyAccountClass* _klass_;
	g_return_val_if_fail (GEARY_IS_ACCOUNT (self), NULL);
	_klass_ = GEARY_ACCOUNT_GET_CLASS (self);
	if (_klass_->to_logging_state) {
		return _klass_->to_logging_state (self);
	}
	return NULL;
}

void
geary_account_cleanup_storage (GearyAccount* self,
                               GCancellable* cancellable,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_)
{
	GearyAccountClass* _klass_;
	_klass_ = GEARY_ACCOUNT_GET_CLASS (self);
	if (_klass_->cleanup_storage) {
		_klass_->cleanup_storage (self, cancellable, _callback_, _user_data_);
	}
}

void
geary_account_cleanup_storage_finish (GearyAccount* self,
                                      GAsyncResult* _res_,
                                      GError** error)
{
	GearyAccountClass* _klass_;
	_klass_ = GEARY_ACCOUNT_GET_CLASS (self);
	if (_klass_->cleanup_storage_finish) {
		_klass_->cleanup_storage_finish (self, _res_, error);
	}
}

/** Fires a {@link opened} signal. */
static void
geary_account_real_notify_opened (GearyAccount* self)
{
	g_signal_emit (self, geary_account_signals[GEARY_ACCOUNT_OPENED_SIGNAL], 0);
}

void
geary_account_notify_opened (GearyAccount* self)
{
	GearyAccountClass* _klass_;
	g_return_if_fail (GEARY_IS_ACCOUNT (self));
	_klass_ = GEARY_ACCOUNT_GET_CLASS (self);
	if (_klass_->notify_opened) {
		_klass_->notify_opened (self);
	}
}

/** Fires a {@link closed} signal. */
static void
geary_account_real_notify_closed (GearyAccount* self)
{
	g_signal_emit (self, geary_account_signals[GEARY_ACCOUNT_CLOSED_SIGNAL], 0);
}

void
geary_account_notify_closed (GearyAccount* self)
{
	GearyAccountClass* _klass_;
	g_return_if_fail (GEARY_IS_ACCOUNT (self));
	_klass_ = GEARY_ACCOUNT_GET_CLASS (self);
	if (_klass_->notify_closed) {
		_klass_->notify_closed (self);
	}
}

/** Fires a {@link folders_available_unavailable} signal. */
static void
geary_account_real_notify_folders_available_unavailable (GearyAccount* self,
                                                         GeeBidirSortedSet* available,
                                                         GeeBidirSortedSet* unavailable)
{
	g_return_if_fail ((available == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (available, GEE_TYPE_BIDIR_SORTED_SET));
	g_return_if_fail ((unavailable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (unavailable, GEE_TYPE_BIDIR_SORTED_SET));
	g_signal_emit (self, geary_account_signals[GEARY_ACCOUNT_FOLDERS_AVAILABLE_UNAVAILABLE_SIGNAL], 0, available, unavailable);
}

void
geary_account_notify_folders_available_unavailable (GearyAccount* self,
                                                    GeeBidirSortedSet* available,
                                                    GeeBidirSortedSet* unavailable)
{
	GearyAccountClass* _klass_;
	g_return_if_fail (GEARY_IS_ACCOUNT (self));
	_klass_ = GEARY_ACCOUNT_GET_CLASS (self);
	if (_klass_->notify_folders_available_unavailable) {
		_klass_->notify_folders_available_unavailable (self, available, unavailable);
	}
}

/** Fires a {@link folders_created} signal. */
static void
geary_account_real_notify_folders_created (GearyAccount* self,
                                           GeeBidirSortedSet* created)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (created, GEE_TYPE_BIDIR_SORTED_SET));
	g_signal_emit (self, geary_account_signals[GEARY_ACCOUNT_FOLDERS_CREATED_SIGNAL], 0, created);
}

void
geary_account_notify_folders_created (GearyAccount* self,
                                      GeeBidirSortedSet* created)
{
	GearyAccountClass* _klass_;
	g_return_if_fail (GEARY_IS_ACCOUNT (self));
	_klass_ = GEARY_ACCOUNT_GET_CLASS (self);
	if (_klass_->notify_folders_created) {
		_klass_->notify_folders_created (self, created);
	}
}

/** Fires a {@link folders_deleted} signal. */
static void
geary_account_real_notify_folders_deleted (GearyAccount* self,
                                           GeeBidirSortedSet* deleted)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (deleted, GEE_TYPE_BIDIR_SORTED_SET));
	g_signal_emit (self, geary_account_signals[GEARY_ACCOUNT_FOLDERS_DELETED_SIGNAL], 0, deleted);
}

void
geary_account_notify_folders_deleted (GearyAccount* self,
                                      GeeBidirSortedSet* deleted)
{
	GearyAccountClass* _klass_;
	g_return_if_fail (GEARY_IS_ACCOUNT (self));
	_klass_ = GEARY_ACCOUNT_GET_CLASS (self);
	if (_klass_->notify_folders_deleted) {
		_klass_->notify_folders_deleted (self, deleted);
	}
}

/** Fires a {@link email_appended} signal. */
static void
geary_account_real_notify_email_appended (GearyAccount* self,
                                          GearyFolder* folder,
                                          GeeCollection* ids)
{
	g_return_if_fail (GEARY_IS_FOLDER (folder));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (ids, GEE_TYPE_COLLECTION));
	g_signal_emit (self, geary_account_signals[GEARY_ACCOUNT_EMAIL_APPENDED_SIGNAL], 0, folder, ids);
}

void
geary_account_notify_email_appended (GearyAccount* self,
                                     GearyFolder* folder,
                                     GeeCollection* ids)
{
	GearyAccountClass* _klass_;
	g_return_if_fail (GEARY_IS_ACCOUNT (self));
	_klass_ = GEARY_ACCOUNT_GET_CLASS (self);
	if (_klass_->notify_email_appended) {
		_klass_->notify_email_appended (self, folder, ids);
	}
}

/** Fires a {@link email_inserted} signal. */
static void
geary_account_real_notify_email_inserted (GearyAccount* self,
                                          GearyFolder* folder,
                                          GeeCollection* ids)
{
	g_return_if_fail (GEARY_IS_FOLDER (folder));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (ids, GEE_TYPE_COLLECTION));
	g_signal_emit (self, geary_account_signals[GEARY_ACCOUNT_EMAIL_INSERTED_SIGNAL], 0, folder, ids);
}

void
geary_account_notify_email_inserted (GearyAccount* self,
                                     GearyFolder* folder,
                                     GeeCollection* ids)
{
	GearyAccountClass* _klass_;
	g_return_if_fail (GEARY_IS_ACCOUNT (self));
	_klass_ = GEARY_ACCOUNT_GET_CLASS (self);
	if (_klass_->notify_email_inserted) {
		_klass_->notify_email_inserted (self, folder, ids);
	}
}

/** Fires a {@link email_removed} signal. */
static void
geary_account_real_notify_email_removed (GearyAccount* self,
                                         GearyFolder* folder,
                                         GeeCollection* ids)
{
	g_return_if_fail (GEARY_IS_FOLDER (folder));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (ids, GEE_TYPE_COLLECTION));
	g_signal_emit (self, geary_account_signals[GEARY_ACCOUNT_EMAIL_REMOVED_SIGNAL], 0, folder, ids);
}

void
geary_account_notify_email_removed (GearyAccount* self,
                                    GearyFolder* folder,
                                    GeeCollection* ids)
{
	GearyAccountClass* _klass_;
	g_return_if_fail (GEARY_IS_ACCOUNT (self));
	_klass_ = GEARY_ACCOUNT_GET_CLASS (self);
	if (_klass_->notify_email_removed) {
		_klass_->notify_email_removed (self, folder, ids);
	}
}

/** Fires a {@link email_locally_removed} signal. */
static void
geary_account_real_notify_email_locally_removed (GearyAccount* self,
                                                 GearyFolder* folder,
                                                 GeeCollection* ids)
{
	g_return_if_fail (GEARY_IS_FOLDER (folder));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (ids, GEE_TYPE_COLLECTION));
	g_signal_emit (self, geary_account_signals[GEARY_ACCOUNT_EMAIL_LOCALLY_REMOVED_SIGNAL], 0, folder, ids);
}

void
geary_account_notify_email_locally_removed (GearyAccount* self,
                                            GearyFolder* folder,
                                            GeeCollection* ids)
{
	GearyAccountClass* _klass_;
	g_return_if_fail (GEARY_IS_ACCOUNT (self));
	_klass_ = GEARY_ACCOUNT_GET_CLASS (self);
	if (_klass_->notify_email_locally_removed) {
		_klass_->notify_email_locally_removed (self, folder, ids);
	}
}

/** Fires a {@link email_locally_complete} signal. */
static void
geary_account_real_notify_email_locally_complete (GearyAccount* self,
                                                  GearyFolder* folder,
                                                  GeeCollection* ids)
{
	g_return_if_fail (GEARY_IS_FOLDER (folder));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (ids, GEE_TYPE_COLLECTION));
	g_signal_emit (self, geary_account_signals[GEARY_ACCOUNT_EMAIL_LOCALLY_COMPLETE_SIGNAL], 0, folder, ids);
}

void
geary_account_notify_email_locally_complete (GearyAccount* self,
                                             GearyFolder* folder,
                                             GeeCollection* ids)
{
	GearyAccountClass* _klass_;
	g_return_if_fail (GEARY_IS_ACCOUNT (self));
	_klass_ = GEARY_ACCOUNT_GET_CLASS (self);
	if (_klass_->notify_email_locally_complete) {
		_klass_->notify_email_locally_complete (self, folder, ids);
	}
}

/** Fires a {@link email_discovered} signal. */
static void
geary_account_real_notify_email_discovered (GearyAccount* self,
                                            GearyFolder* folder,
                                            GeeCollection* ids)
{
	g_return_if_fail (GEARY_IS_FOLDER (folder));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (ids, GEE_TYPE_COLLECTION));
	g_signal_emit (self, geary_account_signals[GEARY_ACCOUNT_EMAIL_DISCOVERED_SIGNAL], 0, folder, ids);
}

void
geary_account_notify_email_discovered (GearyAccount* self,
                                       GearyFolder* folder,
                                       GeeCollection* ids)
{
	GearyAccountClass* _klass_;
	g_return_if_fail (GEARY_IS_ACCOUNT (self));
	_klass_ = GEARY_ACCOUNT_GET_CLASS (self);
	if (_klass_->notify_email_discovered) {
		_klass_->notify_email_discovered (self, folder, ids);
	}
}

/** Fires a {@link email_flags_changed} signal. */
static void
geary_account_real_notify_email_flags_changed (GearyAccount* self,
                                               GearyFolder* folder,
                                               GeeMap* flag_map)
{
	g_return_if_fail (GEARY_IS_FOLDER (folder));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (flag_map, GEE_TYPE_MAP));
	g_signal_emit (self, geary_account_signals[GEARY_ACCOUNT_EMAIL_FLAGS_CHANGED_SIGNAL], 0, folder, flag_map);
}

void
geary_account_notify_email_flags_changed (GearyAccount* self,
                                          GearyFolder* folder,
                                          GeeMap* flag_map)
{
	GearyAccountClass* _klass_;
	g_return_if_fail (GEARY_IS_ACCOUNT (self));
	_klass_ = GEARY_ACCOUNT_GET_CLASS (self);
	if (_klass_->notify_email_flags_changed) {
		_klass_->notify_email_flags_changed (self, folder, flag_map);
	}
}

/** Fires a {@link report_problem} signal for this account. */
static void
geary_account_real_notify_report_problem (GearyAccount* self,
                                          GearyProblemReport* report)
{
	g_return_if_fail (GEARY_IS_PROBLEM_REPORT (report));
	g_signal_emit (self, geary_account_signals[GEARY_ACCOUNT_REPORT_PROBLEM_SIGNAL], 0, report);
}

void
geary_account_notify_report_problem (GearyAccount* self,
                                     GearyProblemReport* report)
{
	GearyAccountClass* _klass_;
	g_return_if_fail (GEARY_IS_ACCOUNT (self));
	_klass_ = GEARY_ACCOUNT_GET_CLASS (self);
	if (_klass_->notify_report_problem) {
		_klass_->notify_report_problem (self, report);
	}
}

/**
     * Fires a {@link report_problem} signal for this account.
     */
static void
geary_account_real_notify_account_problem (GearyAccount* self,
                                           GError* err)
{
	GearyAccountInformation* _tmp0_;
	GearyAccountProblemReport* _tmp1_;
	GearyAccountProblemReport* _tmp2_;
	_tmp0_ = self->priv->_information;
	_tmp1_ = geary_account_problem_report_new (_tmp0_, err);
	_tmp2_ = _tmp1_;
	g_signal_emit (self, geary_account_signals[GEARY_ACCOUNT_REPORT_PROBLEM_SIGNAL], 0, G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEARY_TYPE_PROBLEM_REPORT, GearyProblemReport));
	_g_object_unref0 (_tmp2_);
}

void
geary_account_notify_account_problem (GearyAccount* self,
                                      GError* err)
{
	GearyAccountClass* _klass_;
	g_return_if_fail (GEARY_IS_ACCOUNT (self));
	_klass_ = GEARY_ACCOUNT_GET_CLASS (self);
	if (_klass_->notify_account_problem) {
		_klass_->notify_account_problem (self, err);
	}
}

/** Fires a {@link report_problem} signal for a service for this account. */
static void
geary_account_real_notify_service_problem (GearyAccount* self,
                                           GearyServiceInformation* service,
                                           GError* err)
{
	GearyAccountInformation* _tmp0_;
	GearyServiceProblemReport* _tmp1_;
	GearyServiceProblemReport* _tmp2_;
	g_return_if_fail (GEARY_IS_SERVICE_INFORMATION (service));
	_tmp0_ = self->priv->_information;
	_tmp1_ = geary_service_problem_report_new (_tmp0_, service, err);
	_tmp2_ = _tmp1_;
	g_signal_emit (self, geary_account_signals[GEARY_ACCOUNT_REPORT_PROBLEM_SIGNAL], 0, G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEARY_TYPE_PROBLEM_REPORT, GearyProblemReport));
	_g_object_unref0 (_tmp2_);
}

void
geary_account_notify_service_problem (GearyAccount* self,
                                      GearyServiceInformation* service,
                                      GError* err)
{
	GearyAccountClass* _klass_;
	g_return_if_fail (GEARY_IS_ACCOUNT (self));
	_klass_ = GEARY_ACCOUNT_GET_CLASS (self);
	if (_klass_->notify_service_problem) {
		_klass_->notify_service_problem (self, service, err);
	}
}

static void
geary_account_on_service_status_notify (GearyAccount* self)
{
	GearyAccountStatus new_status = 0U;
	GearyClientService* _tmp0_;
	GearyClientServiceStatus _tmp1_;
	GearyClientServiceStatus _tmp2_;
	gboolean _tmp3_ = FALSE;
	GearyClientService* _tmp4_;
	GearyClientServiceStatus _tmp5_;
	GearyClientServiceStatus _tmp6_;
	g_return_if_fail (GEARY_IS_ACCOUNT (self));
	new_status = 0;
	_tmp0_ = self->priv->_incoming;
	_tmp1_ = geary_client_service_get_current_status (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != GEARY_CLIENT_SERVICE_STATUS_UNREACHABLE) {
		new_status |= GEARY_ACCOUNT_STATUS_ONLINE;
	}
	_tmp4_ = self->priv->_incoming;
	_tmp5_ = geary_client_service_get_current_status (_tmp4_);
	_tmp6_ = _tmp5_;
	if (geary_client_service_status_is_error (_tmp6_)) {
		_tmp3_ = TRUE;
	} else {
		GearyClientService* _tmp7_;
		GearyClientServiceStatus _tmp8_;
		GearyClientServiceStatus _tmp9_;
		_tmp7_ = self->priv->_outgoing;
		_tmp8_ = geary_client_service_get_current_status (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp3_ = geary_client_service_status_is_error (_tmp9_);
	}
	if (_tmp3_) {
		new_status |= GEARY_ACCOUNT_STATUS_SERVICE_PROBLEM;
	}
	geary_account_set_current_status (self, new_status);
}

static void
geary_account_class_init (GearyAccountClass * klass,
                          gpointer klass_data)
{
	geary_account_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyAccount_private_offset);
	((GearyAccountClass *) klass)->is_open = (gboolean (*) (GearyAccount*)) geary_account_real_is_open;
	((GearyAccountClass *) klass)->cancel_remote_update = (void (*) (GearyAccount*)) geary_account_real_cancel_remote_update;
	((GearyAccountClass *) klass)->to_email_identifier = (GearyEmailIdentifier* (*) (GearyAccount*, GVariant*, GError**)) geary_account_real_to_email_identifier;
	((GearyAccountClass *) klass)->to_folder_path = (GearyFolderPath* (*) (GearyAccount*, GVariant*, GError**)) geary_account_real_to_folder_path;
	((GearyAccountClass *) klass)->has_folder = (gboolean (*) (GearyAccount*, GearyFolderPath*)) geary_account_real_has_folder;
	((GearyAccountClass *) klass)->get_folder = (GearyFolder* (*) (GearyAccount*, GearyFolderPath*, GError**)) geary_account_real_get_folder;
	((GearyAccountClass *) klass)->list_folders = (GeeCollection* (*) (GearyAccount*)) geary_account_real_list_folders;
	((GearyAccountClass *) klass)->list_matching_folders = (GeeCollection* (*) (GearyAccount*, GearyFolderPath*, GError**)) geary_account_real_list_matching_folders;
	((GearyAccountClass *) klass)->get_special_folder = (GearyFolder* (*) (GearyAccount*, GearyFolderSpecialUse)) geary_account_real_get_special_folder;
	((GearyAccountClass *) klass)->register_local_folder = (void (*) (GearyAccount*, GearyFolder*, GError**)) geary_account_real_register_local_folder;
	((GearyAccountClass *) klass)->deregister_local_folder = (void (*) (GearyAccount*, GearyFolder*, GError**)) geary_account_real_deregister_local_folder;
	((GearyAccountClass *) klass)->new_search_query = (GearySearchQuery* (*) (GearyAccount*, GeeList*, const gchar*, GError**)) geary_account_real_new_search_query;
	((GearyAccountClass *) klass)->to_logging_state = (GearyLoggingState* (*) (GearyAccount*)) geary_account_real_to_logging_state;
	((GearyAccountClass *) klass)->notify_opened = (void (*) (GearyAccount*)) geary_account_real_notify_opened;
	((GearyAccountClass *) klass)->notify_closed = (void (*) (GearyAccount*)) geary_account_real_notify_closed;
	((GearyAccountClass *) klass)->notify_folders_available_unavailable = (void (*) (GearyAccount*, GeeBidirSortedSet*, GeeBidirSortedSet*)) geary_account_real_notify_folders_available_unavailable;
	((GearyAccountClass *) klass)->notify_folders_created = (void (*) (GearyAccount*, GeeBidirSortedSet*)) geary_account_real_notify_folders_created;
	((GearyAccountClass *) klass)->notify_folders_deleted = (void (*) (GearyAccount*, GeeBidirSortedSet*)) geary_account_real_notify_folders_deleted;
	((GearyAccountClass *) klass)->notify_email_appended = (void (*) (GearyAccount*, GearyFolder*, GeeCollection*)) geary_account_real_notify_email_appended;
	((GearyAccountClass *) klass)->notify_email_inserted = (void (*) (GearyAccount*, GearyFolder*, GeeCollection*)) geary_account_real_notify_email_inserted;
	((GearyAccountClass *) klass)->notify_email_removed = (void (*) (GearyAccount*, GearyFolder*, GeeCollection*)) geary_account_real_notify_email_removed;
	((GearyAccountClass *) klass)->notify_email_locally_removed = (void (*) (GearyAccount*, GearyFolder*, GeeCollection*)) geary_account_real_notify_email_locally_removed;
	((GearyAccountClass *) klass)->notify_email_locally_complete = (void (*) (GearyAccount*, GearyFolder*, GeeCollection*)) geary_account_real_notify_email_locally_complete;
	((GearyAccountClass *) klass)->notify_email_discovered = (void (*) (GearyAccount*, GearyFolder*, GeeCollection*)) geary_account_real_notify_email_discovered;
	((GearyAccountClass *) klass)->notify_email_flags_changed = (void (*) (GearyAccount*, GearyFolder*, GeeMap*)) geary_account_real_notify_email_flags_changed;
	((GearyAccountClass *) klass)->notify_report_problem = (void (*) (GearyAccount*, GearyProblemReport*)) geary_account_real_notify_report_problem;
	((GearyAccountClass *) klass)->notify_account_problem = (void (*) (GearyAccount*, GError*)) geary_account_real_notify_account_problem;
	((GearyAccountClass *) klass)->notify_service_problem = (void (*) (GearyAccount*, GearyServiceInformation*, GError*)) geary_account_real_notify_service_problem;
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_account_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_account_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_account_finalize;
	/**
	     * The account's current configuration.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_ACCOUNT_INFORMATION_PROPERTY, geary_account_properties[GEARY_ACCOUNT_INFORMATION_PROPERTY] = g_param_spec_object ("information", "information", "information", GEARY_TYPE_ACCOUNT_INFORMATION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * The account's current status.
	     *
	     * This property's value is set based on the {@link
	     * ClientService.current_status} of the account's {@link incoming}
	     * and {@link outgoing} services. See {@link Status} for more
	     * information.
	     *
	     * The initial value for this property is {@link Status.ONLINE},
	     * which may or may not be incorrect. However the once the account
	     * has been opened, its services will begin checking connectivity
	     * and the value will be updated to match in due course.
	     *
	     * @see ClientService.current_status
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_ACCOUNT_CURRENT_STATUS_PROPERTY, geary_account_properties[GEARY_ACCOUNT_CURRENT_STATUS_PROPERTY] = g_param_spec_flags ("current-status", "current-status", "current-status", GEARY_ACCOUNT_TYPE_STATUS, GEARY_ACCOUNT_STATUS_ONLINE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * The service manager for the incoming email service.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_ACCOUNT_INCOMING_PROPERTY, geary_account_properties[GEARY_ACCOUNT_INCOMING_PROPERTY] = g_param_spec_object ("incoming", "incoming", "incoming", GEARY_TYPE_CLIENT_SERVICE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * The service manager for the outgoing email service.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_ACCOUNT_OUTGOING_PROPERTY, geary_account_properties[GEARY_ACCOUNT_OUTGOING_PROPERTY] = g_param_spec_object ("outgoing", "outgoing", "outgoing", GEARY_TYPE_CLIENT_SERVICE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * The contact information store for this account.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_ACCOUNT_CONTACT_STORE_PROPERTY, geary_account_properties[GEARY_ACCOUNT_CONTACT_STORE_PROPERTY] = g_param_spec_object ("contact-store", "contact-store", "contact-store", GEARY_TYPE_CONTACT_STORE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * The root path for all local folders.
	     *
	     * Any local folders create by the engine or clients must use this
	     * as the root for local folders.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_ACCOUNT_LOCAL_FOLDER_ROOT_PROPERTY, geary_account_properties[GEARY_ACCOUNT_LOCAL_FOLDER_ROOT_PROPERTY] = g_param_spec_object ("local-folder-root", "local-folder-root", "local-folder-root", GEARY_TYPE_FOLDER_ROOT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_ACCOUNT_BACKGROUND_PROGRESS_PROPERTY, geary_account_properties[GEARY_ACCOUNT_BACKGROUND_PROGRESS_PROPERTY] = g_param_spec_object ("background-progress", "background-progress", "background-progress", GEARY_TYPE_PROGRESS_MONITOR, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_ACCOUNT_DB_UPGRADE_MONITOR_PROPERTY, geary_account_properties[GEARY_ACCOUNT_DB_UPGRADE_MONITOR_PROPERTY] = g_param_spec_object ("db-upgrade-monitor", "db-upgrade-monitor", "db-upgrade-monitor", GEARY_TYPE_PROGRESS_MONITOR, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_ACCOUNT_DB_VACUUM_MONITOR_PROPERTY, geary_account_properties[GEARY_ACCOUNT_DB_VACUUM_MONITOR_PROPERTY] = g_param_spec_object ("db-vacuum-monitor", "db-vacuum-monitor", "db-vacuum-monitor", GEARY_TYPE_PROGRESS_MONITOR, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * The last time the account storage was cleaned.
	     *
	     * This does not imply that a full reap plus vacuum garbage
	     * collection (GC) is performed, merely that:
	     * 1. Any old messages are removed
	     * 2. If any old messages were removed, or the defined period
	     * (in ImapDB.GC) has past, a GC reap is performed
	     * 3. GC vacuum is run if recommended
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_ACCOUNT_LAST_STORAGE_CLEANUP_PROPERTY, geary_account_properties[GEARY_ACCOUNT_LAST_STORAGE_CLEANUP_PROPERTY] = g_param_spec_boxed ("last-storage-cleanup", "last-storage-cleanup", "last-storage-cleanup", G_TYPE_DATE_TIME, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/** {@inheritDoc} */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_ACCOUNT_LOGGING_PARENT_PROPERTY, geary_account_properties[GEARY_ACCOUNT_LOGGING_PARENT_PROPERTY] = g_param_spec_object ("logging-parent", "logging-parent", "logging-parent", GEARY_LOGGING_TYPE_SOURCE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	geary_account_signals[GEARY_ACCOUNT_OPENED_SIGNAL] = g_signal_new ("opened", GEARY_TYPE_ACCOUNT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	geary_account_signals[GEARY_ACCOUNT_CLOSED_SIGNAL] = g_signal_new ("closed", GEARY_TYPE_ACCOUNT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	/**
	     * Emitted to notify the client that some problem has occurred.
	     *
	     * The engine uses this signal to report internal errors and other
	     * issues that the client should notify the user about. The {@link
	     * ProblemReport} class provides context about the nature of the
	     * problem itself.
	     */
	geary_account_signals[GEARY_ACCOUNT_REPORT_PROBLEM_SIGNAL] = g_signal_new ("report-problem", GEARY_TYPE_ACCOUNT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEARY_TYPE_PROBLEM_REPORT);
	/**
	     * Fired when folders become available or unavailable in the account.
	     *
	     * Folders become available when the account is first opened or when
	     * they're created later; they become unavailable when the account is
	     * closed or they're deleted later.
	     *
	     * Folders are ordered for the convenience of the caller from the
	     * top of the hierarchy to lower in the hierarchy.  In other
	     * words, parents are listed before children, assuming the
	     * collections are traversed in natural order.
	     *
	     * @see sort_by_path
	     */
	geary_account_signals[GEARY_ACCOUNT_FOLDERS_AVAILABLE_UNAVAILABLE_SIGNAL] = g_signal_new ("folders-available-unavailable", GEARY_TYPE_ACCOUNT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, GEE_TYPE_BIDIR_SORTED_SET, GEE_TYPE_BIDIR_SORTED_SET);
	/**
	     * Fired when new folders have been created.
	     *
	     * This is fired in response to new folders appearing, for example
	     * the user created a new folder. It will be fired after {@link
	     * folders_available_unavailable} has been fired to mark the
	     * folders as having been made available.
	     *
	     * Folders are ordered for the convenience of the caller from the
	     * top of the hierarchy to lower in the hierarchy.  In other
	     * words, parents are listed before children, assuming the
	     * collection is traversed in natural order.
	     */
	geary_account_signals[GEARY_ACCOUNT_FOLDERS_CREATED_SIGNAL] = g_signal_new ("folders-created", GEARY_TYPE_ACCOUNT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_BIDIR_SORTED_SET);
	/**
	     * Fired when existing folders are deleted.
	     *
	     * This is fired in response to existing folders being removed,
	     * for example if the user deleted a folder. it will be fired
	     * after {@link folders_available_unavailable} has been fired to
	     * mark the folders as having been made unavailable.
	     *
	     * Folders are ordered for the convenience of the caller from the
	     * top of the hierarchy to lower in the hierarchy.  In other
	     * words, parents are listed before children, assuming the
	     * collection is traversed in natural order.
	     */
	geary_account_signals[GEARY_ACCOUNT_FOLDERS_DELETED_SIGNAL] = g_signal_new ("folders-deleted", GEARY_TYPE_ACCOUNT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_BIDIR_SORTED_SET);
	/**
	     * Fired when a Folder's special use is detected having changed.
	     */
	geary_account_signals[GEARY_ACCOUNT_FOLDERS_USE_CHANGED_SIGNAL] = g_signal_new ("folders-use-changed", GEARY_TYPE_ACCOUNT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_COLLECTION);
	/**
	     * Fired when emails are appended to a folder in this account.
	     */
	geary_account_signals[GEARY_ACCOUNT_EMAIL_APPENDED_SIGNAL] = g_signal_new ("email-appended", GEARY_TYPE_ACCOUNT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, GEARY_TYPE_FOLDER, GEE_TYPE_COLLECTION);
	/**
	     * Fired when emails are inserted to a folder in this account.
	     *
	     * @see Folder.email_inserted
	     */
	geary_account_signals[GEARY_ACCOUNT_EMAIL_INSERTED_SIGNAL] = g_signal_new ("email-inserted", GEARY_TYPE_ACCOUNT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, GEARY_TYPE_FOLDER, GEE_TYPE_COLLECTION);
	/**
	     * Fired when emails are removed from a folder in this account.
	     */
	geary_account_signals[GEARY_ACCOUNT_EMAIL_REMOVED_SIGNAL] = g_signal_new ("email-removed", GEARY_TYPE_ACCOUNT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, GEARY_TYPE_FOLDER, GEE_TYPE_COLLECTION);
	/**
	     * Fired when emails are removed from a local folder in this account.
	     */
	geary_account_signals[GEARY_ACCOUNT_EMAIL_LOCALLY_REMOVED_SIGNAL] = g_signal_new ("email-locally-removed", GEARY_TYPE_ACCOUNT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, GEARY_TYPE_FOLDER, GEE_TYPE_COLLECTION);
	/**
	     * Fired when one or more emails have been locally saved to a folder with
	     * the full set of Fields.
	     */
	geary_account_signals[GEARY_ACCOUNT_EMAIL_LOCALLY_COMPLETE_SIGNAL] = g_signal_new ("email-locally-complete", GEARY_TYPE_ACCOUNT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, GEARY_TYPE_FOLDER, GEE_TYPE_COLLECTION);
	/**
	     * Fired when one or more emails have been discovered (added) to the Folder, but not necessarily
	     * appended (i.e. old email pulled down due to user request or background fetching).
	     */
	geary_account_signals[GEARY_ACCOUNT_EMAIL_DISCOVERED_SIGNAL] = g_signal_new ("email-discovered", GEARY_TYPE_ACCOUNT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, GEARY_TYPE_FOLDER, GEE_TYPE_COLLECTION);
	/**
	     * Fired when the supplied email flags have changed from any folder.
	     */
	geary_account_signals[GEARY_ACCOUNT_EMAIL_FLAGS_CHANGED_SIGNAL] = g_signal_new ("email-flags-changed", GEARY_TYPE_ACCOUNT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, GEARY_TYPE_FOLDER, GEE_TYPE_MAP);
}

static void
geary_account_geary_logging_source_interface_init (GearyLoggingSourceIface * iface,
                                                   gpointer iface_data)
{
	geary_account_geary_logging_source_parent_iface = g_type_interface_peek_parent (iface);
	iface->to_logging_state = (GearyLoggingState* (*) (GearyLoggingSource*)) geary_account_to_logging_state;
	iface->get_logging_parent = geary_account_real_get_logging_parent;
}

static void
geary_account_instance_init (GearyAccount * self,
                             gpointer klass)
{
	GearyFolderRoot* _tmp0_;
	self->priv = geary_account_get_instance_private (self);
	self->priv->_current_status = GEARY_ACCOUNT_STATUS_ONLINE;
	_tmp0_ = geary_folder_root_new ("$geary-local", TRUE);
	self->priv->_local_folder_root = _tmp0_;
}

static void
geary_account_finalize (GObject * obj)
{
	GearyAccount * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_TYPE_ACCOUNT, GearyAccount);
	_g_object_unref0 (self->priv->_information);
	_g_object_unref0 (self->priv->_incoming);
	_g_object_unref0 (self->priv->_outgoing);
	_g_object_unref0 (self->priv->_contact_store);
	_g_object_unref0 (self->priv->_local_folder_root);
	_g_object_unref0 (self->priv->_background_progress);
	_g_object_unref0 (self->priv->_db_upgrade_monitor);
	_g_object_unref0 (self->priv->_db_vacuum_monitor);
	_g_date_time_unref0 (self->priv->_last_storage_cleanup);
	G_OBJECT_CLASS (geary_account_parent_class)->finalize (obj);
}

/**
 * Account is the basic interface to the user's email account, {@link Folder}s, and various signals,
 * monitors, and notifications of account activity.
 *
 * In addition to providing an interface to the various Folders, Account offers aggregation signals
 * indicating changes to all Folders as they're discovered.  Because some mail interfaces don't
 * provide account-wide notification, these signals may only be fired when the Folder is open,
 * which sometimes happens in the background as background synchronization occurs.
 *
 * Accounts must be opened and closed with {@link open_async} and {@link close_async}.  Most
 * methods only work if the Account is opened (if not, that will be mentioned in their
 * documentation).
 *
 * A list of all Accounts may be retrieved from the {@link Engine} singleton.
 */
 G_GNUC_NO_INLINE static GType
geary_account_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyAccountClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_account_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyAccount), 0, (GInstanceInitFunc) geary_account_instance_init, NULL };
	static const GInterfaceInfo geary_logging_source_info = { (GInterfaceInitFunc) geary_account_geary_logging_source_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType geary_account_type_id;
	geary_account_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "GearyAccount", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	g_type_add_interface_static (geary_account_type_id, GEARY_LOGGING_TYPE_SOURCE, &geary_logging_source_info);
	GearyAccount_private_offset = g_type_add_instance_private (geary_account_type_id, sizeof (GearyAccountPrivate));
	return geary_account_type_id;
}

GType
geary_account_get_type (void)
{
	static gsize geary_account_type_id__once = 0;
	if (g_once_init_enter (&geary_account_type_id__once)) {
		GType geary_account_type_id;
		geary_account_type_id = geary_account_get_type_once ();
		g_once_init_leave (&geary_account_type_id__once, geary_account_type_id);
	}
	return geary_account_type_id__once;
}

static void
_vala_geary_account_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec)
{
	GearyAccount * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_TYPE_ACCOUNT, GearyAccount);
	switch (property_id) {
		case GEARY_ACCOUNT_INFORMATION_PROPERTY:
		g_value_set_object (value, geary_account_get_information (self));
		break;
		case GEARY_ACCOUNT_CURRENT_STATUS_PROPERTY:
		g_value_set_flags (value, geary_account_get_current_status (self));
		break;
		case GEARY_ACCOUNT_INCOMING_PROPERTY:
		g_value_set_object (value, geary_account_get_incoming (self));
		break;
		case GEARY_ACCOUNT_OUTGOING_PROPERTY:
		g_value_set_object (value, geary_account_get_outgoing (self));
		break;
		case GEARY_ACCOUNT_CONTACT_STORE_PROPERTY:
		g_value_set_object (value, geary_account_get_contact_store (self));
		break;
		case GEARY_ACCOUNT_LOCAL_FOLDER_ROOT_PROPERTY:
		g_value_set_object (value, geary_account_get_local_folder_root (self));
		break;
		case GEARY_ACCOUNT_BACKGROUND_PROGRESS_PROPERTY:
		g_value_set_object (value, geary_account_get_background_progress (self));
		break;
		case GEARY_ACCOUNT_DB_UPGRADE_MONITOR_PROPERTY:
		g_value_set_object (value, geary_account_get_db_upgrade_monitor (self));
		break;
		case GEARY_ACCOUNT_DB_VACUUM_MONITOR_PROPERTY:
		g_value_set_object (value, geary_account_get_db_vacuum_monitor (self));
		break;
		case GEARY_ACCOUNT_LAST_STORAGE_CLEANUP_PROPERTY:
		g_value_set_boxed (value, geary_account_get_last_storage_cleanup (self));
		break;
		case GEARY_ACCOUNT_LOGGING_PARENT_PROPERTY:
		g_value_set_object (value, geary_logging_source_get_logging_parent (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource)));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_account_set_property (GObject * object,
                                  guint property_id,
                                  const GValue * value,
                                  GParamSpec * pspec)
{
	GearyAccount * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_TYPE_ACCOUNT, GearyAccount);
	switch (property_id) {
		case GEARY_ACCOUNT_INFORMATION_PROPERTY:
		geary_account_set_information (self, g_value_get_object (value));
		break;
		case GEARY_ACCOUNT_CURRENT_STATUS_PROPERTY:
		geary_account_set_current_status (self, g_value_get_flags (value));
		break;
		case GEARY_ACCOUNT_INCOMING_PROPERTY:
		geary_account_set_incoming (self, g_value_get_object (value));
		break;
		case GEARY_ACCOUNT_OUTGOING_PROPERTY:
		geary_account_set_outgoing (self, g_value_get_object (value));
		break;
		case GEARY_ACCOUNT_CONTACT_STORE_PROPERTY:
		geary_account_set_contact_store (self, g_value_get_object (value));
		break;
		case GEARY_ACCOUNT_LOCAL_FOLDER_ROOT_PROPERTY:
		geary_account_set_local_folder_root (self, g_value_get_object (value));
		break;
		case GEARY_ACCOUNT_BACKGROUND_PROGRESS_PROPERTY:
		geary_account_set_background_progress (self, g_value_get_object (value));
		break;
		case GEARY_ACCOUNT_DB_UPGRADE_MONITOR_PROPERTY:
		geary_account_set_db_upgrade_monitor (self, g_value_get_object (value));
		break;
		case GEARY_ACCOUNT_DB_VACUUM_MONITOR_PROPERTY:
		geary_account_set_db_vacuum_monitor (self, g_value_get_object (value));
		break;
		case GEARY_ACCOUNT_LAST_STORAGE_CLEANUP_PROPERTY:
		geary_account_set_last_storage_cleanup (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

