/* app-conversation-operation.c generated by valac 0.56.3, the Vala compiler
 * generated from app-conversation-operation.vala, do not modify */

/*
 * Copyright 2016 Software Freedom Conservancy Inc.
 * Copyright 2018-2019 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <gee.h>

#define GEARY_APP_BATCH_OPERATION_BATCH_MAX_N 100

#define GEARY_APP_TYPE_CONVERSATION_OPERATION (geary_app_conversation_operation_get_type ())
#define GEARY_APP_CONVERSATION_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_APP_TYPE_CONVERSATION_OPERATION, GearyAppConversationOperation))
#define GEARY_APP_CONVERSATION_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_APP_TYPE_CONVERSATION_OPERATION, GearyAppConversationOperationClass))
#define GEARY_APP_IS_CONVERSATION_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_APP_TYPE_CONVERSATION_OPERATION))
#define GEARY_APP_IS_CONVERSATION_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_APP_TYPE_CONVERSATION_OPERATION))
#define GEARY_APP_CONVERSATION_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_APP_TYPE_CONVERSATION_OPERATION, GearyAppConversationOperationClass))

typedef struct _GearyAppConversationOperation GearyAppConversationOperation;
typedef struct _GearyAppConversationOperationClass GearyAppConversationOperationClass;
typedef struct _GearyAppConversationOperationPrivate GearyAppConversationOperationPrivate;
enum  {
	GEARY_APP_CONVERSATION_OPERATION_0_PROPERTY,
	GEARY_APP_CONVERSATION_OPERATION_ALLOW_DUPLICATES_PROPERTY,
	GEARY_APP_CONVERSATION_OPERATION_NUM_PROPERTIES
};
static GParamSpec* geary_app_conversation_operation_properties[GEARY_APP_CONVERSATION_OPERATION_NUM_PROPERTIES];

#define GEARY_APP_TYPE_BATCH_OPERATION (geary_app_batch_operation_get_type ())
#define GEARY_APP_BATCH_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_APP_TYPE_BATCH_OPERATION, GearyAppBatchOperation))
#define GEARY_APP_BATCH_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_APP_TYPE_BATCH_OPERATION, GearyAppBatchOperationClass))
#define GEARY_APP_IS_BATCH_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_APP_TYPE_BATCH_OPERATION))
#define GEARY_APP_IS_BATCH_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_APP_TYPE_BATCH_OPERATION))
#define GEARY_APP_BATCH_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_APP_TYPE_BATCH_OPERATION, GearyAppBatchOperationClass))

typedef struct _GearyAppBatchOperation GearyAppBatchOperation;
typedef struct _GearyAppBatchOperationClass GearyAppBatchOperationClass;
typedef struct _GearyAppBatchOperationPrivate GearyAppBatchOperationPrivate;
enum  {
	GEARY_APP_BATCH_OPERATION_0_PROPERTY,
	GEARY_APP_BATCH_OPERATION_T_TYPE,
	GEARY_APP_BATCH_OPERATION_T_DUP_FUNC,
	GEARY_APP_BATCH_OPERATION_T_DESTROY_FUNC,
	GEARY_APP_BATCH_OPERATION_NUM_PROPERTIES
};
static GParamSpec* geary_app_batch_operation_properties[GEARY_APP_BATCH_OPERATION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _GearyAppBatchOperationExecuteAsyncData GearyAppBatchOperationExecuteAsyncData;

struct _GearyAppConversationOperation {
	GearyBaseObject parent_instance;
	GearyAppConversationMonitor* monitor;
	GearyAppConversationOperationPrivate * priv;
};

struct _GearyAppConversationOperationClass {
	GearyBaseObjectClass parent_class;
	void (*execute_async) (GearyAppConversationOperation* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*execute_finish) (GearyAppConversationOperation* self, GAsyncResult* _res_, GError** error);
};

struct _GearyAppConversationOperationPrivate {
	gboolean _allow_duplicates;
};

struct _GearyAppBatchOperation {
	GearyAppConversationOperation parent_instance;
	GearyAppBatchOperationPrivate * priv;
};

struct _GearyAppBatchOperationClass {
	GearyAppConversationOperationClass parent_class;
	void (*execute_batch) (GearyAppBatchOperation* self, GeeCollection* batch, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*execute_batch_finish) (GearyAppBatchOperation* self, GAsyncResult* _res_, GError** error);
};

struct _GearyAppBatchOperationPrivate {
	GType t_type;
	GBoxedCopyFunc t_dup_func;
	GDestroyNotify t_destroy_func;
	GeeCollection* full;
};

struct _GearyAppBatchOperationExecuteAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyAppBatchOperation* self;
	GeeCollection* batch;
	GeeLinkedList* _tmp0_;
	GeeIterator* _element_it;
	GeeCollection* _tmp1_;
	GeeIterator* _tmp2_;
	GeeIterator* _tmp3_;
	gpointer element;
	GeeIterator* _tmp4_;
	gpointer _tmp5_;
	GeeCollection* _tmp6_;
	gconstpointer _tmp7_;
	GeeCollection* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	GeeCollection* _tmp11_;
	GeeLinkedList* _tmp12_;
	GeeCollection* _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	GeeCollection* _tmp16_;
	GError* _inner_error0_;
};

static gint GearyAppConversationOperation_private_offset;
static gpointer geary_app_conversation_operation_parent_class = NULL;
static gint GearyAppBatchOperation_private_offset;
static gpointer geary_app_batch_operation_parent_class = NULL;

VALA_EXTERN GType geary_app_conversation_operation_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gboolean geary_app_conversation_operation_get_allow_duplicates (GearyAppConversationOperation* self);
static void geary_app_conversation_operation_set_allow_duplicates (GearyAppConversationOperation* self,
                                                            gboolean value);
VALA_EXTERN GearyAppConversationOperation* geary_app_conversation_operation_construct (GType object_type,
                                                                           GearyAppConversationMonitor* monitor,
                                                                           gboolean allow_duplicates);
VALA_EXTERN void geary_app_conversation_operation_execute_async (GearyAppConversationOperation* self,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_);
VALA_EXTERN void geary_app_conversation_operation_execute_finish (GearyAppConversationOperation* self,
                                                      GAsyncResult* _res_,
                                                      GError** error);
static void geary_app_conversation_operation_finalize (GObject * obj);
static GType geary_app_conversation_operation_get_type_once (void);
static void _vala_geary_app_conversation_operation_get_property (GObject * object,
                                                          guint property_id,
                                                          GValue * value,
                                                          GParamSpec * pspec);
static void _vala_geary_app_conversation_operation_set_property (GObject * object,
                                                          guint property_id,
                                                          const GValue * value,
                                                          GParamSpec * pspec);
VALA_EXTERN GType geary_app_batch_operation_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GearyAppBatchOperation* geary_app_batch_operation_construct (GType object_type,
                                                             GType t_type,
                                                             GBoxedCopyFunc t_dup_func,
                                                             GDestroyNotify t_destroy_func,
                                                             GearyAppConversationMonitor* monitor,
                                                             GeeCollection* full);
static void geary_app_batch_operation_real_execute_async_data_free (gpointer _data);
static void geary_app_batch_operation_real_execute_async (GearyAppConversationOperation* base,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
static gboolean geary_app_batch_operation_real_execute_async_co (GearyAppBatchOperationExecuteAsyncData* _data_);
VALA_EXTERN void geary_app_batch_operation_execute_batch (GearyAppBatchOperation* self,
                                              GeeCollection* batch,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
VALA_EXTERN void geary_app_batch_operation_execute_batch_finish (GearyAppBatchOperation* self,
                                                     GAsyncResult* _res_,
                                                     GError** error);
static void geary_app_batch_operation_execute_async_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_);
static void geary_app_batch_operation_finalize (GObject * obj);
static GType geary_app_batch_operation_get_type_once (void);
static void _vala_geary_app_batch_operation_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);
static void _vala_geary_app_batch_operation_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec);

static inline gpointer
geary_app_conversation_operation_get_instance_private (GearyAppConversationOperation* self)
{
	return G_STRUCT_MEMBER_P (self, GearyAppConversationOperation_private_offset);
}

gboolean
geary_app_conversation_operation_get_allow_duplicates (GearyAppConversationOperation* self)
{
	gboolean result;
	g_return_val_if_fail (GEARY_APP_IS_CONVERSATION_OPERATION (self), FALSE);
	result = self->priv->_allow_duplicates;
	return result;
}

static void
geary_app_conversation_operation_set_allow_duplicates (GearyAppConversationOperation* self,
                                                       gboolean value)
{
	gboolean old_value;
	g_return_if_fail (GEARY_APP_IS_CONVERSATION_OPERATION (self));
	old_value = geary_app_conversation_operation_get_allow_duplicates (self);
	if (old_value != value) {
		self->priv->_allow_duplicates = value;
		g_object_notify_by_pspec ((GObject *) self, geary_app_conversation_operation_properties[GEARY_APP_CONVERSATION_OPERATION_ALLOW_DUPLICATES_PROPERTY]);
	}
}

GearyAppConversationOperation*
geary_app_conversation_operation_construct (GType object_type,
                                            GearyAppConversationMonitor* monitor,
                                            gboolean allow_duplicates)
{
	GearyAppConversationOperation * self = NULL;
	g_return_val_if_fail ((monitor == NULL) || GEARY_APP_IS_CONVERSATION_MONITOR (monitor), NULL);
	self = (GearyAppConversationOperation*) geary_base_object_construct (object_type);
	self->monitor = monitor;
	geary_app_conversation_operation_set_allow_duplicates (self, allow_duplicates);
	return self;
}

void
geary_app_conversation_operation_execute_async (GearyAppConversationOperation* self,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	GearyAppConversationOperationClass* _klass_;
	_klass_ = GEARY_APP_CONVERSATION_OPERATION_GET_CLASS (self);
	if (_klass_->execute_async) {
		_klass_->execute_async (self, _callback_, _user_data_);
	}
}

void
geary_app_conversation_operation_execute_finish (GearyAppConversationOperation* self,
                                                 GAsyncResult* _res_,
                                                 GError** error)
{
	GearyAppConversationOperationClass* _klass_;
	_klass_ = GEARY_APP_CONVERSATION_OPERATION_GET_CLASS (self);
	if (_klass_->execute_finish) {
		_klass_->execute_finish (self, _res_, error);
	}
}

static void
geary_app_conversation_operation_class_init (GearyAppConversationOperationClass * klass,
                                             gpointer klass_data)
{
	geary_app_conversation_operation_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyAppConversationOperation_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_app_conversation_operation_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_app_conversation_operation_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_app_conversation_operation_finalize;
	/** Determines if multiple instances of this operation can be queued. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_APP_CONVERSATION_OPERATION_ALLOW_DUPLICATES_PROPERTY, geary_app_conversation_operation_properties[GEARY_APP_CONVERSATION_OPERATION_ALLOW_DUPLICATES_PROPERTY] = g_param_spec_boolean ("allow-duplicates", "allow-duplicates", "allow-duplicates", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_app_conversation_operation_instance_init (GearyAppConversationOperation * self,
                                                gpointer klass)
{
	self->priv = geary_app_conversation_operation_get_instance_private (self);
	self->monitor = NULL;
}

static void
geary_app_conversation_operation_finalize (GObject * obj)
{
	GearyAppConversationOperation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_APP_TYPE_CONVERSATION_OPERATION, GearyAppConversationOperation);
	G_OBJECT_CLASS (geary_app_conversation_operation_parent_class)->finalize (obj);
}

/**
 * An internal operation used to keep conversations up to date.
 *
 * Classes implementing this interface are used by {@link
 * ConversationMonitor} to asynchronously keep conversations up to
 * date as messages are added to, updated, and removed from folders.
 */
 G_GNUC_NO_INLINE static GType
geary_app_conversation_operation_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyAppConversationOperationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_app_conversation_operation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyAppConversationOperation), 0, (GInstanceInitFunc) geary_app_conversation_operation_instance_init, NULL };
	GType geary_app_conversation_operation_type_id;
	geary_app_conversation_operation_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "GearyAppConversationOperation", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	GearyAppConversationOperation_private_offset = g_type_add_instance_private (geary_app_conversation_operation_type_id, sizeof (GearyAppConversationOperationPrivate));
	return geary_app_conversation_operation_type_id;
}

GType
geary_app_conversation_operation_get_type (void)
{
	static gsize geary_app_conversation_operation_type_id__once = 0;
	if (g_once_init_enter (&geary_app_conversation_operation_type_id__once)) {
		GType geary_app_conversation_operation_type_id;
		geary_app_conversation_operation_type_id = geary_app_conversation_operation_get_type_once ();
		g_once_init_leave (&geary_app_conversation_operation_type_id__once, geary_app_conversation_operation_type_id);
	}
	return geary_app_conversation_operation_type_id__once;
}

static void
_vala_geary_app_conversation_operation_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec)
{
	GearyAppConversationOperation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_APP_TYPE_CONVERSATION_OPERATION, GearyAppConversationOperation);
	switch (property_id) {
		case GEARY_APP_CONVERSATION_OPERATION_ALLOW_DUPLICATES_PROPERTY:
		g_value_set_boolean (value, geary_app_conversation_operation_get_allow_duplicates (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_app_conversation_operation_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec)
{
	GearyAppConversationOperation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_APP_TYPE_CONVERSATION_OPERATION, GearyAppConversationOperation);
	switch (property_id) {
		case GEARY_APP_CONVERSATION_OPERATION_ALLOW_DUPLICATES_PROPERTY:
		geary_app_conversation_operation_set_allow_duplicates (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
geary_app_batch_operation_get_instance_private (GearyAppBatchOperation* self)
{
	return G_STRUCT_MEMBER_P (self, GearyAppBatchOperation_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GearyAppBatchOperation*
geary_app_batch_operation_construct (GType object_type,
                                     GType t_type,
                                     GBoxedCopyFunc t_dup_func,
                                     GDestroyNotify t_destroy_func,
                                     GearyAppConversationMonitor* monitor,
                                     GeeCollection* full)
{
	GearyAppBatchOperation * self = NULL;
	GeeCollection* _tmp0_;
	g_return_val_if_fail ((monitor == NULL) || GEARY_APP_IS_CONVERSATION_MONITOR (monitor), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (full, GEE_TYPE_COLLECTION), NULL);
	self = (GearyAppBatchOperation*) geary_app_conversation_operation_construct (object_type, monitor, TRUE);
	self->priv->t_type = t_type;
	self->priv->t_dup_func = t_dup_func;
	self->priv->t_destroy_func = t_destroy_func;
	_tmp0_ = _g_object_ref0 (full);
	_g_object_unref0 (self->priv->full);
	self->priv->full = _tmp0_;
	return self;
}

static void
geary_app_batch_operation_real_execute_async_data_free (gpointer _data)
{
	GearyAppBatchOperationExecuteAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyAppBatchOperationExecuteAsyncData, _data_);
}

static void
geary_app_batch_operation_real_execute_async (GearyAppConversationOperation* base,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	GearyAppBatchOperation * self;
	GearyAppBatchOperationExecuteAsyncData* _data_;
	GearyAppBatchOperation* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_APP_TYPE_BATCH_OPERATION, GearyAppBatchOperation);
	_data_ = g_slice_new0 (GearyAppBatchOperationExecuteAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_app_batch_operation_real_execute_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	geary_app_batch_operation_real_execute_async_co (_data_);
}

static void
geary_app_batch_operation_execute_finish (GearyAppConversationOperation* base,
                                          GAsyncResult* _res_,
                                          GError** error)
{
	GearyAppBatchOperationExecuteAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
geary_app_batch_operation_execute_async_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_)
{
	GearyAppBatchOperationExecuteAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_app_batch_operation_real_execute_async_co (_data_);
}

static gboolean
geary_app_batch_operation_real_execute_async_co (GearyAppBatchOperationExecuteAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = gee_linked_list_new (_data_->self->priv->t_type, (GBoxedCopyFunc) _data_->self->priv->t_dup_func, (GDestroyNotify) _data_->self->priv->t_destroy_func, NULL, NULL, NULL);
	_data_->batch = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp0_, GEE_TYPE_COLLECTION, GeeCollection);
	{
		_data_->_tmp1_ = _data_->self->priv->full;
		_data_->_tmp2_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, GEE_TYPE_ITERABLE, GeeIterable));
		_data_->_element_it = _data_->_tmp2_;
		while (TRUE) {
			_data_->_tmp3_ = _data_->_element_it;
			if (!gee_iterator_next (_data_->_tmp3_)) {
				break;
			}
			_data_->_tmp4_ = _data_->_element_it;
			_data_->_tmp5_ = gee_iterator_get (_data_->_tmp4_);
			_data_->element = _data_->_tmp5_;
			_data_->_tmp6_ = _data_->batch;
			_data_->_tmp7_ = _data_->element;
			gee_collection_add (_data_->_tmp6_, _data_->_tmp7_);
			_data_->_tmp8_ = _data_->batch;
			_data_->_tmp9_ = gee_collection_get_size (_data_->_tmp8_);
			_data_->_tmp10_ = _data_->_tmp9_;
			if (_data_->_tmp10_ == GEARY_APP_BATCH_OPERATION_BATCH_MAX_N) {
				_data_->_tmp11_ = _data_->batch;
				_data_->_state_ = 1;
				geary_app_batch_operation_execute_batch (_data_->self, _data_->_tmp11_, geary_app_batch_operation_execute_async_ready, _data_);
				return FALSE;
				_state_1:
				geary_app_batch_operation_execute_batch_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
					((_data_->element == NULL) || (_data_->self->priv->t_destroy_func == NULL)) ? NULL : (_data_->element = (_data_->self->priv->t_destroy_func (_data_->element), NULL));
					_g_object_unref0 (_data_->_element_it);
					_g_object_unref0 (_data_->batch);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				_data_->_tmp12_ = gee_linked_list_new (_data_->self->priv->t_type, (GBoxedCopyFunc) _data_->self->priv->t_dup_func, (GDestroyNotify) _data_->self->priv->t_destroy_func, NULL, NULL, NULL);
				_g_object_unref0 (_data_->batch);
				_data_->batch = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp12_, GEE_TYPE_COLLECTION, GeeCollection);
			}
			((_data_->element == NULL) || (_data_->self->priv->t_destroy_func == NULL)) ? NULL : (_data_->element = (_data_->self->priv->t_destroy_func (_data_->element), NULL));
		}
		_g_object_unref0 (_data_->_element_it);
	}
	_data_->_tmp13_ = _data_->batch;
	_data_->_tmp14_ = gee_collection_get_is_empty (_data_->_tmp13_);
	_data_->_tmp15_ = _data_->_tmp14_;
	if (!_data_->_tmp15_) {
		_data_->_tmp16_ = _data_->batch;
		_data_->_state_ = 2;
		geary_app_batch_operation_execute_batch (_data_->self, _data_->_tmp16_, geary_app_batch_operation_execute_async_ready, _data_);
		return FALSE;
		_state_2:
		geary_app_batch_operation_execute_batch_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->batch);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_g_object_unref0 (_data_->batch);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
geary_app_batch_operation_execute_batch (GearyAppBatchOperation* self,
                                         GeeCollection* batch,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	GearyAppBatchOperationClass* _klass_;
	_klass_ = GEARY_APP_BATCH_OPERATION_GET_CLASS (self);
	if (_klass_->execute_batch) {
		_klass_->execute_batch (self, batch, _callback_, _user_data_);
	}
}

void
geary_app_batch_operation_execute_batch_finish (GearyAppBatchOperation* self,
                                                GAsyncResult* _res_,
                                                GError** error)
{
	GearyAppBatchOperationClass* _klass_;
	_klass_ = GEARY_APP_BATCH_OPERATION_GET_CLASS (self);
	if (_klass_->execute_batch_finish) {
		_klass_->execute_batch_finish (self, _res_, error);
	}
}

static void
geary_app_batch_operation_class_init (GearyAppBatchOperationClass * klass,
                                      gpointer klass_data)
{
	geary_app_batch_operation_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyAppBatchOperation_private_offset);
	((GearyAppConversationOperationClass *) klass)->execute_async = (void (*) (GearyAppConversationOperation*, GAsyncReadyCallback, gpointer)) geary_app_batch_operation_real_execute_async;
	((GearyAppConversationOperationClass *) klass)->execute_finish = (void (*) (GearyAppConversationOperation*, GAsyncResult*, GError**)) geary_app_batch_operation_execute_finish;
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_app_batch_operation_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_app_batch_operation_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_app_batch_operation_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_APP_BATCH_OPERATION_T_TYPE, g_param_spec_gtype ("t-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_APP_BATCH_OPERATION_T_DUP_FUNC, g_param_spec_pointer ("t-dup-func", "dup func", "dup func", G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_APP_BATCH_OPERATION_T_DESTROY_FUNC, g_param_spec_pointer ("t-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
}

static void
geary_app_batch_operation_instance_init (GearyAppBatchOperation * self,
                                         gpointer klass)
{
	self->priv = geary_app_batch_operation_get_instance_private (self);
}

static void
geary_app_batch_operation_finalize (GObject * obj)
{
	GearyAppBatchOperation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_APP_TYPE_BATCH_OPERATION, GearyAppBatchOperation);
	_g_object_unref0 (self->priv->full);
	G_OBJECT_CLASS (geary_app_batch_operation_parent_class)->finalize (obj);
}

/**
 * An operation that executes on a collection in batches.
 */
 G_GNUC_NO_INLINE static GType
geary_app_batch_operation_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyAppBatchOperationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_app_batch_operation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyAppBatchOperation), 0, (GInstanceInitFunc) geary_app_batch_operation_instance_init, NULL };
	GType geary_app_batch_operation_type_id;
	geary_app_batch_operation_type_id = g_type_register_static (GEARY_APP_TYPE_CONVERSATION_OPERATION, "GearyAppBatchOperation", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	GearyAppBatchOperation_private_offset = g_type_add_instance_private (geary_app_batch_operation_type_id, sizeof (GearyAppBatchOperationPrivate));
	return geary_app_batch_operation_type_id;
}

GType
geary_app_batch_operation_get_type (void)
{
	static gsize geary_app_batch_operation_type_id__once = 0;
	if (g_once_init_enter (&geary_app_batch_operation_type_id__once)) {
		GType geary_app_batch_operation_type_id;
		geary_app_batch_operation_type_id = geary_app_batch_operation_get_type_once ();
		g_once_init_leave (&geary_app_batch_operation_type_id__once, geary_app_batch_operation_type_id);
	}
	return geary_app_batch_operation_type_id__once;
}

static void
_vala_geary_app_batch_operation_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	GearyAppBatchOperation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_APP_TYPE_BATCH_OPERATION, GearyAppBatchOperation);
	switch (property_id) {
		case GEARY_APP_BATCH_OPERATION_T_TYPE:
		g_value_set_gtype (value, self->priv->t_type);
		break;
		case GEARY_APP_BATCH_OPERATION_T_DUP_FUNC:
		g_value_set_pointer (value, self->priv->t_dup_func);
		break;
		case GEARY_APP_BATCH_OPERATION_T_DESTROY_FUNC:
		g_value_set_pointer (value, self->priv->t_destroy_func);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_app_batch_operation_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec)
{
	GearyAppBatchOperation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_APP_TYPE_BATCH_OPERATION, GearyAppBatchOperation);
	switch (property_id) {
		case GEARY_APP_BATCH_OPERATION_T_TYPE:
		self->priv->t_type = g_value_get_gtype (value);
		break;
		case GEARY_APP_BATCH_OPERATION_T_DUP_FUNC:
		self->priv->t_dup_func = g_value_get_pointer (value);
		break;
		case GEARY_APP_BATCH_OPERATION_T_DESTROY_FUNC:
		self->priv->t_destroy_func = g_value_get_pointer (value);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

