/* imap-idle-command.c generated by valac 0.56.3, the Vala compiler
 * generated from imap-idle-command.vala, do not modify */

/*
 * Copyright 2016 Software Freedom Conservancy Inc.
 * Copyright 2018 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>

#define GEARY_IMAP_IDLE_COMMAND_DONE "DONE"

enum  {
	GEARY_IMAP_IDLE_COMMAND_0_PROPERTY,
	GEARY_IMAP_IDLE_COMMAND_IDLE_STARTED_PROPERTY,
	GEARY_IMAP_IDLE_COMMAND_NUM_PROPERTIES
};
static GParamSpec* geary_imap_idle_command_properties[GEARY_IMAP_IDLE_COMMAND_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _GearyImapIdleCommandSendData GearyImapIdleCommandSendData;
typedef struct _GearyImapIdleCommandSendWaitData GearyImapIdleCommandSendWaitData;

struct _GearyImapIdleCommandPrivate {
	gboolean _idle_started;
	gboolean serialised;
	GearyNonblockingSemaphore* exit_lock;
	GCancellable* exit_cancellable;
};

struct _GearyImapIdleCommandSendData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapIdleCommand* self;
	GearyImapSerializer* ser;
	GCancellable* cancellable;
	GError* _inner_error0_;
};

struct _GearyImapIdleCommandSendWaitData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapIdleCommand* self;
	GearyImapSerializer* ser;
	GCancellable* cancellable;
	GearyNonblockingSemaphore* _tmp0_;
	GearyImapStatusResponse* _tmp1_;
	GearyImapStatusResponse* _tmp2_;
	GearyTimeoutManager* _tmp3_;
	GearyTimeoutManager* _tmp4_;
	GError* _inner_error0_;
};

static gint GearyImapIdleCommand_private_offset;
static gpointer geary_imap_idle_command_parent_class = NULL;

VALA_EXTERN void geary_imap_command_send (GearyImapCommand* self,
                              GearyImapSerializer* ser,
                              GCancellable* cancellable,
                              GAsyncReadyCallback _callback_,
                              gpointer _user_data_);
VALA_EXTERN void geary_imap_command_send_finish (GearyImapCommand* self,
                                     GAsyncResult* _res_,
                                     GError** error);
VALA_EXTERN void geary_imap_command_send_wait (GearyImapCommand* self,
                                   GearyImapSerializer* ser,
                                   GCancellable* cancellable,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_);
VALA_EXTERN void geary_imap_command_send_wait_finish (GearyImapCommand* self,
                                          GAsyncResult* _res_,
                                          GError** error);
VALA_EXTERN void geary_imap_command_continuation_requested (GearyImapCommand* self,
                                                GearyImapContinuationResponse* continuation,
                                                GError** error);
static void geary_imap_idle_command_set_idle_started (GearyImapIdleCommand* self,
                                               gboolean value);
static void geary_imap_idle_command_real_send_data_free (gpointer _data);
static void geary_imap_idle_command_real_send (GearyImapCommand* base,
                                        GearyImapSerializer* ser,
                                        GCancellable* cancellable,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
static gboolean geary_imap_idle_command_real_send_co (GearyImapIdleCommandSendData* _data_);
static void geary_imap_idle_command_send_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_);
static void geary_imap_idle_command_real_send_wait_data_free (gpointer _data);
static void geary_imap_idle_command_real_send_wait (GearyImapCommand* base,
                                             GearyImapSerializer* ser,
                                             GCancellable* cancellable,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
static gboolean geary_imap_idle_command_real_send_wait_co (GearyImapIdleCommandSendWaitData* _data_);
static void geary_imap_idle_command_send_wait_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_);
static void geary_imap_idle_command_real_continuation_requested (GearyImapCommand* base,
                                                          GearyImapContinuationResponse* response,
                                                          GError** error);
static void geary_imap_idle_command_real_stop_serialisation (GearyImapCommand* base);
static void geary_imap_idle_command_finalize (GObject * obj);
static GType geary_imap_idle_command_get_type_once (void);
static void _vala_geary_imap_idle_command_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_geary_imap_idle_command_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);

static inline gpointer
geary_imap_idle_command_get_instance_private (GearyImapIdleCommand* self)
{
	return G_STRUCT_MEMBER_P (self, GearyImapIdleCommand_private_offset);
}

gboolean
geary_imap_idle_command_get_idle_started (GearyImapIdleCommand* self)
{
	gboolean result;
	g_return_val_if_fail (GEARY_IMAP_IS_IDLE_COMMAND (self), FALSE);
	result = self->priv->_idle_started;
	return result;
}

static void
geary_imap_idle_command_set_idle_started (GearyImapIdleCommand* self,
                                          gboolean value)
{
	gboolean old_value;
	g_return_if_fail (GEARY_IMAP_IS_IDLE_COMMAND (self));
	old_value = geary_imap_idle_command_get_idle_started (self);
	if (old_value != value) {
		self->priv->_idle_started = value;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_idle_command_properties[GEARY_IMAP_IDLE_COMMAND_IDLE_STARTED_PROPERTY]);
	}
}

GearyImapIdleCommand*
geary_imap_idle_command_construct (GType object_type,
                                   GCancellable* should_send)
{
	GearyImapIdleCommand * self = NULL;
	GCancellable* _tmp0_;
	GearyNonblockingSemaphore* _tmp1_;
	g_return_val_if_fail ((should_send == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (should_send, g_cancellable_get_type ()), NULL);
	self = (GearyImapIdleCommand*) geary_imap_command_construct (object_type, GEARY_IMAP_IDLE_COMMAND_NAME, NULL, (gint) 0, should_send);
	_tmp0_ = self->priv->exit_cancellable;
	_tmp1_ = geary_nonblocking_semaphore_new (_tmp0_);
	_g_object_unref0 (self->priv->exit_lock);
	self->priv->exit_lock = _tmp1_;
	return self;
}

GearyImapIdleCommand*
geary_imap_idle_command_new (GCancellable* should_send)
{
	return geary_imap_idle_command_construct (GEARY_IMAP_TYPE_IDLE_COMMAND, should_send);
}

/** Causes the idle command to exit, if currently executing. **/
void
geary_imap_idle_command_exit_idle (GearyImapIdleCommand* self)
{
	GearyNonblockingSemaphore* _tmp0_;
	g_return_if_fail (GEARY_IMAP_IS_IDLE_COMMAND (self));
	_tmp0_ = self->priv->exit_lock;
	geary_nonblocking_lock_blind_notify (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEARY_NONBLOCKING_TYPE_LOCK, GearyNonblockingLock));
}

static void
geary_imap_idle_command_real_send_data_free (gpointer _data)
{
	GearyImapIdleCommandSendData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->ser);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapIdleCommandSendData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
geary_imap_idle_command_real_send (GearyImapCommand* base,
                                   GearyImapSerializer* ser,
                                   GCancellable* cancellable,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	GearyImapIdleCommand * self;
	GearyImapIdleCommandSendData* _data_;
	GearyImapIdleCommand* _tmp0_;
	GearyImapSerializer* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (GEARY_IMAP_IS_SERIALIZER (ser));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_TYPE_IDLE_COMMAND, GearyImapIdleCommand);
	_data_ = g_slice_new0 (GearyImapIdleCommandSendData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_idle_command_real_send_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (ser);
	_g_object_unref0 (_data_->ser);
	_data_->ser = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	geary_imap_idle_command_real_send_co (_data_);
}

static void
geary_imap_idle_command_send_finish (GearyImapCommand* base,
                                     GAsyncResult* _res_,
                                     GError** error)
{
	GearyImapIdleCommandSendData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/** Waits after serialisation has completed for {@link exit_idle}. */
static void
geary_imap_idle_command_send_ready (GObject* source_object,
                                    GAsyncResult* _res_,
                                    gpointer _user_data_)
{
	GearyImapIdleCommandSendData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_idle_command_real_send_co (_data_);
}

static gboolean
geary_imap_idle_command_real_send_co (GearyImapIdleCommandSendData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	geary_imap_serializer_flush_stream (_data_->ser, _data_->cancellable, geary_imap_idle_command_send_ready, _data_);
	return FALSE;
	_state_1:
	geary_imap_serializer_flush_stream_finish (_data_->ser, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_state_ = 2;
	GEARY_IMAP_COMMAND_CLASS (geary_imap_idle_command_parent_class)->send (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_IMAP_TYPE_COMMAND, GearyImapCommand), _data_->ser, _data_->cancellable, geary_imap_idle_command_send_ready, _data_);
	return FALSE;
	_state_2:
	GEARY_IMAP_COMMAND_CLASS (geary_imap_idle_command_parent_class)->send_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_IMAP_TYPE_COMMAND, GearyImapCommand), _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->self->priv->serialised = TRUE;
	_data_->_state_ = 3;
	geary_imap_serializer_flush_stream (_data_->ser, _data_->cancellable, geary_imap_idle_command_send_ready, _data_);
	return FALSE;
	_state_3:
	geary_imap_serializer_flush_stream_finish (_data_->ser, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_imap_idle_command_real_send_wait_data_free (gpointer _data)
{
	GearyImapIdleCommandSendWaitData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->ser);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapIdleCommandSendWaitData, _data_);
}

static void
geary_imap_idle_command_real_send_wait (GearyImapCommand* base,
                                        GearyImapSerializer* ser,
                                        GCancellable* cancellable,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	GearyImapIdleCommand * self;
	GearyImapIdleCommandSendWaitData* _data_;
	GearyImapIdleCommand* _tmp0_;
	GearyImapSerializer* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (GEARY_IMAP_IS_SERIALIZER (ser));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_TYPE_IDLE_COMMAND, GearyImapIdleCommand);
	_data_ = g_slice_new0 (GearyImapIdleCommandSendWaitData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_idle_command_real_send_wait_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (ser);
	_g_object_unref0 (_data_->ser);
	_data_->ser = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	geary_imap_idle_command_real_send_wait_co (_data_);
}

static void
geary_imap_idle_command_send_wait_finish (GearyImapCommand* base,
                                          GAsyncResult* _res_,
                                          GError** error)
{
	GearyImapIdleCommandSendWaitData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
geary_imap_idle_command_send_wait_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_)
{
	GearyImapIdleCommandSendWaitData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_idle_command_real_send_wait_co (_data_);
}

static gboolean
geary_imap_idle_command_real_send_wait_co (GearyImapIdleCommandSendWaitData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->exit_lock;
	_data_->_state_ = 1;
	geary_nonblocking_lock_wait_async (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp0_, GEARY_NONBLOCKING_TYPE_LOCK, GearyNonblockingLock), _data_->cancellable, geary_imap_idle_command_send_wait_ready, _data_);
	return FALSE;
	_state_1:
	geary_nonblocking_lock_wait_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp0_, GEARY_NONBLOCKING_TYPE_LOCK, GearyNonblockingLock), _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = geary_imap_command_get_status (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_IMAP_TYPE_COMMAND, GearyImapCommand));
	_data_->_tmp2_ = _data_->_tmp1_;
	if (_data_->_tmp2_ == NULL) {
		_data_->_tmp3_ = geary_imap_command_get_response_timer (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_IMAP_TYPE_COMMAND, GearyImapCommand));
		_data_->_tmp4_ = _data_->_tmp3_;
		geary_timeout_manager_start (_data_->_tmp4_);
		geary_imap_serializer_push_unquoted_string (_data_->ser, GEARY_IMAP_IDLE_COMMAND_DONE, NULL, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		geary_imap_serializer_push_eol (_data_->ser, _data_->cancellable, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_state_ = 2;
		geary_imap_serializer_flush_stream (_data_->ser, _data_->cancellable, geary_imap_idle_command_send_wait_ready, _data_);
		return FALSE;
		_state_2:
		geary_imap_serializer_flush_stream_finish (_data_->ser, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_state_ = 3;
	geary_imap_command_wait_until_complete (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_IMAP_TYPE_COMMAND, GearyImapCommand), _data_->cancellable, geary_imap_idle_command_send_wait_ready, _data_);
	return FALSE;
	_state_3:
	geary_imap_command_wait_until_complete_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_IMAP_TYPE_COMMAND, GearyImapCommand), _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_imap_idle_command_real_continuation_requested (GearyImapCommand* base,
                                                     GearyImapContinuationResponse* response,
                                                     GError** error)
{
	GearyImapIdleCommand * self;
	GError* _inner_error0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_TYPE_IDLE_COMMAND, GearyImapIdleCommand);
	g_return_if_fail (GEARY_IMAP_IS_CONTINUATION_RESPONSE (response));
	if (!self->priv->serialised) {
		GEARY_IMAP_COMMAND_CLASS (geary_imap_idle_command_parent_class)->continuation_requested (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_COMMAND, GearyImapCommand), response, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	} else {
		GearyTimeoutManager* _tmp0_;
		GearyTimeoutManager* _tmp1_;
		geary_imap_idle_command_set_idle_started (self, TRUE);
		_tmp0_ = geary_imap_command_get_response_timer (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_COMMAND, GearyImapCommand));
		_tmp1_ = _tmp0_;
		geary_timeout_manager_reset (_tmp1_);
	}
}

static void
geary_imap_idle_command_real_stop_serialisation (GearyImapCommand* base)
{
	GearyImapIdleCommand * self;
	GCancellable* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_TYPE_IDLE_COMMAND, GearyImapIdleCommand);
	GEARY_IMAP_COMMAND_CLASS (geary_imap_idle_command_parent_class)->stop_serialisation (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_COMMAND, GearyImapCommand));
	_tmp0_ = self->priv->exit_cancellable;
	g_cancellable_cancel (_tmp0_);
}

static void
geary_imap_idle_command_class_init (GearyImapIdleCommandClass * klass,
                                    gpointer klass_data)
{
	geary_imap_idle_command_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyImapIdleCommand_private_offset);
	((GearyImapCommandClass *) klass)->send = (void (*) (GearyImapCommand*, GearyImapSerializer*, GCancellable*, GAsyncReadyCallback, gpointer)) geary_imap_idle_command_real_send;
	((GearyImapCommandClass *) klass)->send_finish = (void (*) (GearyImapCommand*, GAsyncResult*, GError**)) geary_imap_idle_command_send_finish;
	((GearyImapCommandClass *) klass)->send_wait = (void (*) (GearyImapCommand*, GearyImapSerializer*, GCancellable*, GAsyncReadyCallback, gpointer)) geary_imap_idle_command_real_send_wait;
	((GearyImapCommandClass *) klass)->send_wait_finish = (void (*) (GearyImapCommand*, GAsyncResult*, GError**)) geary_imap_idle_command_send_wait_finish;
	((GearyImapCommandClass *) klass)->continuation_requested = (void (*) (GearyImapCommand*, GearyImapContinuationResponse*, GError**)) geary_imap_idle_command_real_continuation_requested;
	((GearyImapCommandClass *) klass)->stop_serialisation = (void (*) (GearyImapCommand*)) geary_imap_idle_command_real_stop_serialisation;
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_imap_idle_command_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_imap_idle_command_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_imap_idle_command_finalize;
	/** Determines if the server has acknowledged the IDLE request. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_IDLE_COMMAND_IDLE_STARTED_PROPERTY, geary_imap_idle_command_properties[GEARY_IMAP_IDLE_COMMAND_IDLE_STARTED_PROPERTY] = g_param_spec_boolean ("idle-started", "idle-started", "idle-started", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_imap_idle_command_instance_init (GearyImapIdleCommand * self,
                                       gpointer klass)
{
	GCancellable* _tmp0_;
	self->priv = geary_imap_idle_command_get_instance_private (self);
	self->priv->_idle_started = FALSE;
	self->priv->serialised = FALSE;
	_tmp0_ = g_cancellable_new ();
	self->priv->exit_cancellable = _tmp0_;
}

static void
geary_imap_idle_command_finalize (GObject * obj)
{
	GearyImapIdleCommand * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_IMAP_TYPE_IDLE_COMMAND, GearyImapIdleCommand);
	_g_object_unref0 (self->priv->exit_lock);
	_g_object_unref0 (self->priv->exit_cancellable);
	G_OBJECT_CLASS (geary_imap_idle_command_parent_class)->finalize (obj);
}

/**
 * The IMAP IDLE command.
 *
 * See [[http://tools.ietf.org/html/rfc2177]]
 */
 G_GNUC_NO_INLINE static GType
geary_imap_idle_command_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapIdleCommandClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_idle_command_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapIdleCommand), 0, (GInstanceInitFunc) geary_imap_idle_command_instance_init, NULL };
	GType geary_imap_idle_command_type_id;
	geary_imap_idle_command_type_id = g_type_register_static (GEARY_IMAP_TYPE_COMMAND, "GearyImapIdleCommand", &g_define_type_info, 0);
	GearyImapIdleCommand_private_offset = g_type_add_instance_private (geary_imap_idle_command_type_id, sizeof (GearyImapIdleCommandPrivate));
	return geary_imap_idle_command_type_id;
}

GType
geary_imap_idle_command_get_type (void)
{
	static gsize geary_imap_idle_command_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_idle_command_type_id__once)) {
		GType geary_imap_idle_command_type_id;
		geary_imap_idle_command_type_id = geary_imap_idle_command_get_type_once ();
		g_once_init_leave (&geary_imap_idle_command_type_id__once, geary_imap_idle_command_type_id);
	}
	return geary_imap_idle_command_type_id__once;
}

static void
_vala_geary_imap_idle_command_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	GearyImapIdleCommand * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_TYPE_IDLE_COMMAND, GearyImapIdleCommand);
	switch (property_id) {
		case GEARY_IMAP_IDLE_COMMAND_IDLE_STARTED_PROPERTY:
		g_value_set_boolean (value, geary_imap_idle_command_get_idle_started (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_imap_idle_command_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	GearyImapIdleCommand * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_TYPE_IDLE_COMMAND, GearyImapIdleCommand);
	switch (property_id) {
		case GEARY_IMAP_IDLE_COMMAND_IDLE_STARTED_PROPERTY:
		geary_imap_idle_command_set_idle_started (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

