/* imap-sequence-number.c generated by valac 0.56.3, the Vala compiler
 * generated from imap-sequence-number.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <glib-object.h>

enum  {
	GEARY_IMAP_SEQUENCE_NUMBER_0_PROPERTY,
	GEARY_IMAP_SEQUENCE_NUMBER_NUM_PROPERTIES
};
static GParamSpec* geary_imap_sequence_number_properties[GEARY_IMAP_SEQUENCE_NUMBER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

static gpointer geary_imap_sequence_number_parent_class = NULL;
static GearyImapMessageDataIface * geary_imap_sequence_number_geary_imap_message_data_parent_iface = NULL;
static GeeComparableIface * geary_imap_sequence_number_gee_comparable_parent_iface = NULL;

static gint geary_imap_sequence_number_real_compare_to (GearyImapSequenceNumber* self,
                                                 GearyImapSequenceNumber* other);
static GType geary_imap_sequence_number_get_type_once (void);

/**
     * Create a new {@link SequenceNumber}.
     *
     * This does not check if the value is valid.
     *
     * @see is_value_valid
     * @see SequenceNumber.SequenceNumber.checked
     */
GearyImapSequenceNumber*
geary_imap_sequence_number_construct (GType object_type,
                                      gint64 value)
{
	GearyImapSequenceNumber * self = NULL;
	self = (GearyImapSequenceNumber*) geary_message_data_int64_message_data_construct (object_type, value);
	return self;
}

GearyImapSequenceNumber*
geary_imap_sequence_number_new (gint64 value)
{
	return geary_imap_sequence_number_construct (GEARY_IMAP_TYPE_SEQUENCE_NUMBER, value);
}

/**
     * Create a new {@link SequenceNumber}, throwing {@link ImapError.INVALID} if an invalid value
     * is passed in.
     *
     * @see is_value_valid
     * @see SequenceNumber
     */
GearyImapSequenceNumber*
geary_imap_sequence_number_construct_checked (GType object_type,
                                              gint64 value,
                                              GError** error)
{
	GearyImapSequenceNumber * self = NULL;
	GError* _inner_error0_ = NULL;
	if (!geary_imap_sequence_number_is_value_valid (value)) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		GError* _tmp2_;
		GError* _tmp3_;
		_tmp0_ = g_strdup_printf ("%" G_GINT64_FORMAT, value);
		_tmp1_ = _tmp0_;
		_tmp2_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_INVALID, "Invalid sequence number %s", _tmp1_);
		_tmp3_ = _tmp2_;
		_g_free0 (_tmp1_);
		_inner_error0_ = _tmp3_;
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	self = (GearyImapSequenceNumber*) geary_message_data_int64_message_data_construct (object_type, value);
	return self;
}

GearyImapSequenceNumber*
geary_imap_sequence_number_new_checked (gint64 value,
                                        GError** error)
{
	return geary_imap_sequence_number_construct_checked (GEARY_IMAP_TYPE_SEQUENCE_NUMBER, value, error);
}

/**
     * Defined as {@link MessageData.Int64MessageData.value} >= {@link MIN} and <= {@link MAX}.
     */
gboolean
geary_imap_sequence_number_is_value_valid (gint64 value)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	if (value >= GEARY_IMAP_SEQUENCE_NUMBER_MIN) {
		_tmp0_ = value <= GEARY_IMAP_SEQUENCE_NUMBER_MAX;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

/**
     * Defined as {@link MessageData.Int64MessageData.value} >= {@link MIN} and <= {@link MAX}.
     */
gboolean
geary_imap_sequence_number_is_valid (GearyImapSequenceNumber* self)
{
	gint64 _tmp0_;
	gint64 _tmp1_;
	gboolean result;
	g_return_val_if_fail (GEARY_IMAP_IS_SEQUENCE_NUMBER (self), FALSE);
	_tmp0_ = geary_message_data_int64_message_data_get_value (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_MESSAGE_DATA_TYPE_INT64_MESSAGE_DATA, GearyMessageDataInt64MessageData));
	_tmp1_ = _tmp0_;
	result = geary_imap_sequence_number_is_value_valid (_tmp1_);
	return result;
}

/**
     * Returns a new {@link SequenceNumber} that is one lower than this value.
     *
     * Returns null if the decremented value is less than {@link MIN}.
     */
GearyImapSequenceNumber*
geary_imap_sequence_number_dec (GearyImapSequenceNumber* self)
{
	GearyImapSequenceNumber* _tmp0_ = NULL;
	gint64 _tmp1_;
	gint64 _tmp2_;
	GearyImapSequenceNumber* result;
	g_return_val_if_fail (GEARY_IMAP_IS_SEQUENCE_NUMBER (self), NULL);
	_tmp1_ = geary_message_data_int64_message_data_get_value (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_MESSAGE_DATA_TYPE_INT64_MESSAGE_DATA, GearyMessageDataInt64MessageData));
	_tmp2_ = _tmp1_;
	if (_tmp2_ > GEARY_IMAP_SEQUENCE_NUMBER_MIN) {
		gint64 _tmp3_;
		gint64 _tmp4_;
		GearyImapSequenceNumber* _tmp5_;
		_tmp3_ = geary_message_data_int64_message_data_get_value (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_MESSAGE_DATA_TYPE_INT64_MESSAGE_DATA, GearyMessageDataInt64MessageData));
		_tmp4_ = _tmp3_;
		_tmp5_ = geary_imap_sequence_number_new (_tmp4_ - 1);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp5_;
	} else {
		_g_object_unref0 (_tmp0_);
		_tmp0_ = NULL;
	}
	result = _tmp0_;
	return result;
}

/**
     * Returns a new {@link SequenceNumber} that is one lower than this value.
     *
     * Returns a SequenceNumber of MIN if the decremented value is less than it.
     */
GearyImapSequenceNumber*
geary_imap_sequence_number_dec_clamped (GearyImapSequenceNumber* self)
{
	GearyImapSequenceNumber* _tmp0_ = NULL;
	gint64 _tmp1_;
	gint64 _tmp2_;
	GearyImapSequenceNumber* result;
	g_return_val_if_fail (GEARY_IMAP_IS_SEQUENCE_NUMBER (self), NULL);
	_tmp1_ = geary_message_data_int64_message_data_get_value (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_MESSAGE_DATA_TYPE_INT64_MESSAGE_DATA, GearyMessageDataInt64MessageData));
	_tmp2_ = _tmp1_;
	if (_tmp2_ > GEARY_IMAP_SEQUENCE_NUMBER_MIN) {
		gint64 _tmp3_;
		gint64 _tmp4_;
		GearyImapSequenceNumber* _tmp5_;
		_tmp3_ = geary_message_data_int64_message_data_get_value (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_MESSAGE_DATA_TYPE_INT64_MESSAGE_DATA, GearyMessageDataInt64MessageData));
		_tmp4_ = _tmp3_;
		_tmp5_ = geary_imap_sequence_number_new (_tmp4_ - 1);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp5_;
	} else {
		GearyImapSequenceNumber* _tmp6_;
		_tmp6_ = geary_imap_sequence_number_new (GEARY_IMAP_SEQUENCE_NUMBER_MIN);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp6_;
	}
	result = _tmp0_;
	return result;
}

/**
     * Returns the {@link SequenceNumber} after the suppled SequenceNumber has been removed from
     * the vector of messages.
     *
     * When a message is removed, positions above it will shift downward while positions below
     * it remain unchanged.  If the position removed matches this SequenceNumber, null is returned.
     */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GearyImapSequenceNumber*
geary_imap_sequence_number_shift_for_removed (GearyImapSequenceNumber* self,
                                              GearyImapSequenceNumber* removed)
{
	gint comparison = 0;
	GearyImapSequenceNumber* _tmp1_;
	GearyImapSequenceNumber* result;
	g_return_val_if_fail (GEARY_IMAP_IS_SEQUENCE_NUMBER (self), NULL);
	g_return_val_if_fail (GEARY_IMAP_IS_SEQUENCE_NUMBER (removed), NULL);
	comparison = geary_imap_sequence_number_compare_to (self, removed);
	if (comparison > 0) {
		GearyImapSequenceNumber* _tmp0_;
		_tmp0_ = geary_imap_sequence_number_dec (self);
		result = _tmp0_;
		return result;
	}
	if (comparison == 0) {
		result = NULL;
		return result;
	}
	_tmp1_ = _g_object_ref0 (self);
	result = _tmp1_;
	return result;
}

static gint
geary_imap_sequence_number_real_compare_to (GearyImapSequenceNumber* self,
                                            GearyImapSequenceNumber* other)
{
	gint64 _tmp0_;
	gint64 _tmp1_;
	gint64 _tmp2_;
	gint64 _tmp3_;
	gint result;
	g_return_val_if_fail (GEARY_IMAP_IS_SEQUENCE_NUMBER (other), 0);
	_tmp0_ = geary_message_data_int64_message_data_get_value (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_MESSAGE_DATA_TYPE_INT64_MESSAGE_DATA, GearyMessageDataInt64MessageData));
	_tmp1_ = _tmp0_;
	_tmp2_ = geary_message_data_int64_message_data_get_value (G_TYPE_CHECK_INSTANCE_CAST (other, GEARY_MESSAGE_DATA_TYPE_INT64_MESSAGE_DATA, GearyMessageDataInt64MessageData));
	_tmp3_ = _tmp2_;
	result = (gint) CLAMP (_tmp1_ - _tmp3_, (gint64) -1, (gint64) 1);
	return result;
}

gint
geary_imap_sequence_number_compare_to (GearyImapSequenceNumber* self,
                                       GearyImapSequenceNumber* other)
{
	GearyImapSequenceNumberClass* _klass_;
	g_return_val_if_fail (GEARY_IMAP_IS_SEQUENCE_NUMBER (self), 0);
	_klass_ = GEARY_IMAP_SEQUENCE_NUMBER_GET_CLASS (self);
	if (_klass_->compare_to) {
		return _klass_->compare_to (self, other);
	}
	return -1;
}

gchar*
geary_imap_sequence_number_serialize (GearyImapSequenceNumber* self)
{
	gint64 _tmp0_;
	gint64 _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (GEARY_IMAP_IS_SEQUENCE_NUMBER (self), NULL);
	_tmp0_ = geary_message_data_int64_message_data_get_value (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_MESSAGE_DATA_TYPE_INT64_MESSAGE_DATA, GearyMessageDataInt64MessageData));
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp1_);
	result = _tmp2_;
	return result;
}

static void
geary_imap_sequence_number_class_init (GearyImapSequenceNumberClass * klass,
                                       gpointer klass_data)
{
	geary_imap_sequence_number_parent_class = g_type_class_peek_parent (klass);
	((GearyImapSequenceNumberClass *) klass)->compare_to = (gint (*) (GearyImapSequenceNumber*, GearyImapSequenceNumber*)) geary_imap_sequence_number_real_compare_to;
}

static void
geary_imap_sequence_number_geary_imap_message_data_interface_init (GearyImapMessageDataIface * iface,
                                                                   gpointer iface_data)
{
	geary_imap_sequence_number_geary_imap_message_data_parent_iface = g_type_interface_peek_parent (iface);
}

static void
geary_imap_sequence_number_gee_comparable_interface_init (GeeComparableIface * iface,
                                                          gpointer iface_data)
{
	geary_imap_sequence_number_gee_comparable_parent_iface = g_type_interface_peek_parent (iface);
	iface->compare_to = (gint (*) (GeeComparable*, gconstpointer)) geary_imap_sequence_number_compare_to;
}

static void
geary_imap_sequence_number_instance_init (GearyImapSequenceNumber * self,
                                          gpointer klass)
{
}

/**
 * A representation of IMAP's sequence number, i.e. 1-based positional addressing within a mailbox.
 *
 * See [[http://tools.ietf.org/html/rfc3501#section-2.3.1.2]]
 *
 * @see UID
 */
 G_GNUC_NO_INLINE static GType
geary_imap_sequence_number_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapSequenceNumberClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_sequence_number_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapSequenceNumber), 0, (GInstanceInitFunc) geary_imap_sequence_number_instance_init, NULL };
	static const GInterfaceInfo geary_imap_message_data_info = { (GInterfaceInitFunc) geary_imap_sequence_number_geary_imap_message_data_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo gee_comparable_info = { (GInterfaceInitFunc) geary_imap_sequence_number_gee_comparable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType geary_imap_sequence_number_type_id;
	geary_imap_sequence_number_type_id = g_type_register_static (GEARY_MESSAGE_DATA_TYPE_INT64_MESSAGE_DATA, "GearyImapSequenceNumber", &g_define_type_info, 0);
	g_type_add_interface_static (geary_imap_sequence_number_type_id, GEARY_IMAP_TYPE_MESSAGE_DATA, &geary_imap_message_data_info);
	g_type_add_interface_static (geary_imap_sequence_number_type_id, GEE_TYPE_COMPARABLE, &gee_comparable_info);
	return geary_imap_sequence_number_type_id;
}

GType
geary_imap_sequence_number_get_type (void)
{
	static gsize geary_imap_sequence_number_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_sequence_number_type_id__once)) {
		GType geary_imap_sequence_number_type_id;
		geary_imap_sequence_number_type_id = geary_imap_sequence_number_get_type_once ();
		g_once_init_leave (&geary_imap_sequence_number_type_id__once, geary_imap_sequence_number_type_id);
	}
	return geary_imap_sequence_number_type_id__once;
}

