/* imap-continuation-response.c generated by valac 0.56.3, the Vala compiler
 * generated from imap-continuation-response.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>

enum  {
	GEARY_IMAP_CONTINUATION_RESPONSE_0_PROPERTY,
	GEARY_IMAP_CONTINUATION_RESPONSE_NUM_PROPERTIES
};
static GParamSpec* geary_imap_continuation_response_properties[GEARY_IMAP_CONTINUATION_RESPONSE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

static gpointer geary_imap_continuation_response_parent_class = NULL;

static GearyImapContinuationResponse* geary_imap_continuation_response_new (GearyImapQuirks* quirks);
static GearyImapContinuationResponse* geary_imap_continuation_response_construct (GType object_type,
                                                                           GearyImapQuirks* quirks);
static GType geary_imap_continuation_response_get_type_once (void);

static GearyImapContinuationResponse*
geary_imap_continuation_response_construct (GType object_type,
                                            GearyImapQuirks* quirks)
{
	GearyImapContinuationResponse * self = NULL;
	GearyImapTag* _tmp0_;
	GearyImapTag* _tmp1_;
	g_return_val_if_fail (GEARY_IMAP_IS_QUIRKS (quirks), NULL);
	_tmp0_ = geary_imap_tag_get_continuation ();
	_tmp1_ = _tmp0_;
	self = (GearyImapContinuationResponse*) geary_imap_server_response_construct (object_type, _tmp1_, quirks);
	_g_object_unref0 (_tmp1_);
	return self;
}

static GearyImapContinuationResponse*
geary_imap_continuation_response_new (GearyImapQuirks* quirks)
{
	return geary_imap_continuation_response_construct (GEARY_IMAP_TYPE_CONTINUATION_RESPONSE, quirks);
}

/**
     * Converts the {@link RootParameters} into a {@link ContinuationResponse}.
     *
     * The supplied root is "stripped" of its children.  This may happen even if an exception is
     * thrown.  It's recommended to use {@link is_continuation_response} prior to this call.
     */
GearyImapContinuationResponse*
geary_imap_continuation_response_construct_migrate (GType object_type,
                                                    GearyImapRootParameters* root,
                                                    GearyImapQuirks* quirks,
                                                    GError** error)
{
	GearyImapContinuationResponse * self = NULL;
	GearyImapTag* _tmp0_;
	GearyImapTag* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (GEARY_IMAP_IS_ROOT_PARAMETERS (root), NULL);
	g_return_val_if_fail (GEARY_IMAP_IS_QUIRKS (quirks), NULL);
	self = (GearyImapContinuationResponse*) geary_imap_server_response_construct_migrate (object_type, root, quirks, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp0_ = geary_imap_server_response_get_tag (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_SERVER_RESPONSE, GearyImapServerResponse));
	_tmp1_ = _tmp0_;
	if (!geary_imap_tag_is_continuation (_tmp1_)) {
		GearyImapTag* _tmp2_;
		GearyImapTag* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		GError* _tmp6_;
		GError* _tmp7_;
		_tmp2_ = geary_imap_server_response_get_tag (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_SERVER_RESPONSE, GearyImapServerResponse));
		_tmp3_ = _tmp2_;
		_tmp4_ = geary_imap_parameter_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
		_tmp5_ = _tmp4_;
		_tmp6_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_INVALID, "Tag %s is not a continuation", _tmp5_);
		_tmp7_ = _tmp6_;
		_g_free0 (_tmp5_);
		_inner_error0_ = _tmp7_;
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	return self;
}

GearyImapContinuationResponse*
geary_imap_continuation_response_new_migrate (GearyImapRootParameters* root,
                                              GearyImapQuirks* quirks,
                                              GError** error)
{
	return geary_imap_continuation_response_construct_migrate (GEARY_IMAP_TYPE_CONTINUATION_RESPONSE, root, quirks, error);
}

/**
     * Returns true if the {@link RootParameters}'s {@link Tag} is a continuation character ("+").
     */
gboolean
geary_imap_continuation_response_is_continuation_response (GearyImapRootParameters* root)
{
	GearyImapTag* tag = NULL;
	GearyImapTag* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GearyImapTag* _tmp2_;
	gboolean result;
	g_return_val_if_fail (GEARY_IMAP_IS_ROOT_PARAMETERS (root), FALSE);
	_tmp0_ = geary_imap_root_parameters_get_tag (root);
	tag = _tmp0_;
	_tmp2_ = tag;
	if (_tmp2_ != NULL) {
		GearyImapTag* _tmp3_;
		_tmp3_ = tag;
		_tmp1_ = geary_imap_tag_is_continuation (_tmp3_);
	} else {
		_tmp1_ = FALSE;
	}
	result = _tmp1_;
	_g_object_unref0 (tag);
	return result;
}

static void
geary_imap_continuation_response_class_init (GearyImapContinuationResponseClass * klass,
                                             gpointer klass_data)
{
	geary_imap_continuation_response_parent_class = g_type_class_peek_parent (klass);
}

static void
geary_imap_continuation_response_instance_init (GearyImapContinuationResponse * self,
                                                gpointer klass)
{
}

/**
 * A server response indicating that the server is ready to accept more data for the current
 * command.
 *
 * The only requirement for a ContinuationResponse is that its {@link Tag} must be a
 * {@link Tag.CONTINUATION_VALUE} ("+").  All other information in the response is optional.
 *
 * See [[http://tools.ietf.org/html/rfc3501#section-7.5]] for more information.
 */
 G_GNUC_NO_INLINE static GType
geary_imap_continuation_response_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapContinuationResponseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_continuation_response_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapContinuationResponse), 0, (GInstanceInitFunc) geary_imap_continuation_response_instance_init, NULL };
	GType geary_imap_continuation_response_type_id;
	geary_imap_continuation_response_type_id = g_type_register_static (GEARY_IMAP_TYPE_SERVER_RESPONSE, "GearyImapContinuationResponse", &g_define_type_info, 0);
	return geary_imap_continuation_response_type_id;
}

GType
geary_imap_continuation_response_get_type (void)
{
	static gsize geary_imap_continuation_response_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_continuation_response_type_id__once)) {
		GType geary_imap_continuation_response_type_id;
		geary_imap_continuation_response_type_id = geary_imap_continuation_response_get_type_once ();
		g_once_init_leave (&geary_imap_continuation_response_type_id__once, geary_imap_continuation_response_type_id);
	}
	return geary_imap_continuation_response_type_id__once;
}

