/* imap-serializer.c generated by valac 0.56.3, the Vala compiler
 * generated from imap-serializer.vala, do not modify */

/*
 * Copyright © 2016 Software Freedom Conservancy Inc.
 * Copyright © 2018, 2020 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>

#define GEARY_IMAP_SERIALIZER_EOL "\r\n"
#define GEARY_IMAP_SERIALIZER_SPACE " "

enum  {
	GEARY_IMAP_SERIALIZER_0_PROPERTY,
	GEARY_IMAP_SERIALIZER_NUM_PROPERTIES
};
static GParamSpec* geary_imap_serializer_properties[GEARY_IMAP_SERIALIZER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _GearyImapSerializerPushLiteralDataData GearyImapSerializerPushLiteralDataData;
typedef struct _GearyImapSerializerFlushStreamData GearyImapSerializerFlushStreamData;
typedef struct _GearyImapSerializerCloseStreamData GearyImapSerializerCloseStreamData;

struct _GearyImapSerializerPrivate {
	GOutputStream* output;
};

struct _GearyImapSerializerPushLiteralDataData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapSerializer* self;
	guint8* buffer;
	gint buffer_length1;
	GCancellable* cancellable;
	GOutputStream* _tmp0_;
	GError* _inner_error0_;
};

struct _GearyImapSerializerFlushStreamData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapSerializer* self;
	GCancellable* cancellable;
	GOutputStream* _tmp0_;
	GError* _inner_error0_;
};

struct _GearyImapSerializerCloseStreamData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapSerializer* self;
	GCancellable* cancellable;
	GOutputStream* _tmp0_;
	GError* _inner_error0_;
};

static gint GearyImapSerializer_private_offset;
static gpointer geary_imap_serializer_parent_class = NULL;

static void geary_imap_serializer_push_literal_data_data_free (gpointer _data);
static gboolean geary_imap_serializer_push_literal_data_co (GearyImapSerializerPushLiteralDataData* _data_);
static void geary_imap_serializer_push_literal_data_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_);
static void geary_imap_serializer_flush_stream_data_free (gpointer _data);
static gboolean geary_imap_serializer_flush_stream_co (GearyImapSerializerFlushStreamData* _data_);
static void geary_imap_serializer_flush_stream_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_);
static void geary_imap_serializer_close_stream_data_free (gpointer _data);
static gboolean geary_imap_serializer_close_stream_co (GearyImapSerializerCloseStreamData* _data_);
static void geary_imap_serializer_close_stream_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_);
static void geary_imap_serializer_finalize (GObject * obj);
static GType geary_imap_serializer_get_type_once (void);

static inline gpointer
geary_imap_serializer_get_instance_private (GearyImapSerializer* self)
{
	return G_STRUCT_MEMBER_P (self, GearyImapSerializer_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GearyImapSerializer*
geary_imap_serializer_construct (GType object_type,
                                 GOutputStream* output)
{
	GearyImapSerializer * self = NULL;
	GOutputStream* _tmp0_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (output, g_output_stream_get_type ()), NULL);
	self = (GearyImapSerializer*) geary_base_object_construct (object_type);
	_tmp0_ = _g_object_ref0 (output);
	_g_object_unref0 (self->priv->output);
	self->priv->output = _tmp0_;
	return self;
}

GearyImapSerializer*
geary_imap_serializer_new (GOutputStream* output)
{
	return geary_imap_serializer_construct (GEARY_IMAP_TYPE_SERIALIZER, output);
}

/**
     * Writes a string without quoting.
     *
     * It is the caller's responsibility to ensure that the value is
     * valid to be written as an unquoted string, instead of with
     * quoting or as a literal.
     */
static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

void
geary_imap_serializer_push_unquoted_string (GearyImapSerializer* self,
                                            const gchar* str,
                                            GCancellable* cancellable,
                                            GError** error)
{
	GOutputStream* _tmp0_;
	guint8* _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_ = 0;
	guint8* _tmp3_;
	gint _tmp3__length1;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (GEARY_IMAP_IS_SERIALIZER (self));
	g_return_if_fail (str != NULL);
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_tmp0_ = self->priv->output;
	_tmp1_ = string_get_data (str, &_tmp2_);
	_tmp1__length1 = _tmp2_;
	_tmp3_ = _tmp1_;
	_tmp3__length1 = _tmp1__length1;
	g_output_stream_write_all (_tmp0_, _tmp3_, (gsize) _tmp3__length1, NULL, cancellable, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

/**
     * Writes a string with quoting.
     *
     * It is the caller's responsibility to ensure that the value is
     * valid to be written as a quoted string, instead of as a
     * literal.
     */
static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static guint8*
g_string_get_data (GString* self,
                   gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	const gchar* _tmp0_;
	gint res_length1;
	gint _res_size_;
	guint8* _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->str;
	res = (guint8*) _tmp0_;
	res_length1 = -1;
	_res_size_ = res_length1;
	res_length1 = (gint) self->len;
	_tmp1_ = res;
	_tmp1__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

void
geary_imap_serializer_push_quoted_string (GearyImapSerializer* self,
                                          const gchar* str,
                                          GCancellable* cancellable,
                                          GError** error)
{
	GString* buf = NULL;
	gint _tmp0_;
	gint _tmp1_;
	GString* _tmp2_;
	GString* _tmp3_;
	gint index = 0;
	gchar ch = '\0';
	GString* _tmp9_;
	GOutputStream* _tmp10_;
	GString* _tmp11_;
	guint8* _tmp12_;
	gint _tmp12__length1;
	gint _tmp13_ = 0;
	guint8* _tmp14_;
	gint _tmp14__length1;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (GEARY_IMAP_IS_SERIALIZER (self));
	g_return_if_fail (str != NULL);
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_tmp0_ = strlen (str);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_string_sized_new ((gsize) (_tmp1_ + 2));
	buf = _tmp2_;
	_tmp3_ = buf;
	g_string_append_c (_tmp3_, '"');
	index = 0;
	ch = string_get (str, (glong) index);
	while (TRUE) {
		gboolean _tmp4_ = FALSE;
		GString* _tmp6_;
		const gchar* _tmp7_;
		gint _tmp8_;
		if (!(ch != GEARY_STRING_EOS)) {
			break;
		}
		if (ch == '"') {
			_tmp4_ = TRUE;
		} else {
			_tmp4_ = ch == '\\';
		}
		if (_tmp4_) {
			GString* _tmp5_;
			_tmp5_ = buf;
			g_string_append_c (_tmp5_, '\\');
		}
		_tmp6_ = buf;
		g_string_append_c (_tmp6_, ch);
		_tmp7_ = str;
		index = index + 1;
		_tmp8_ = index;
		ch = string_get (_tmp7_, (glong) _tmp8_);
	}
	_tmp9_ = buf;
	g_string_append_c (_tmp9_, '"');
	_tmp10_ = self->priv->output;
	_tmp11_ = buf;
	_tmp12_ = g_string_get_data (_tmp11_, &_tmp13_);
	_tmp12__length1 = _tmp13_;
	_tmp14_ = _tmp12_;
	_tmp14__length1 = _tmp12__length1;
	g_output_stream_write_all (_tmp10_, _tmp14_, (gsize) _tmp14__length1, NULL, cancellable, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_string_free0 (buf);
		return;
	}
	_g_string_free0 (buf);
}

/**
     * Writes a single ASCII character.
     *
     * It is the caller's responsibility to ensure that the value is
     * valid to be written as-is.
     */
void
geary_imap_serializer_push_ascii (GearyImapSerializer* self,
                                  gchar ch,
                                  GCancellable* cancellable,
                                  GError** error)
{
	guint8 buf[1] = {0};
	guint8 _tmp0_[1] = {0};
	GOutputStream* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (GEARY_IMAP_IS_SERIALIZER (self));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_tmp0_[0] = (guint8) ch;
	memcpy (buf, _tmp0_, 1 * sizeof (guint8));
	_tmp1_ = self->priv->output;
	g_output_stream_write_all (_tmp1_, buf, (gsize) 1, NULL, cancellable, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

/**
     * Writes a ASCII space character.
     */
void
geary_imap_serializer_push_space (GearyImapSerializer* self,
                                  GCancellable* cancellable,
                                  GError** error)
{
	GOutputStream* _tmp0_;
	guint8* _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_ = 0;
	guint8* _tmp3_;
	gint _tmp3__length1;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (GEARY_IMAP_IS_SERIALIZER (self));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_tmp0_ = self->priv->output;
	_tmp1_ = string_get_data (GEARY_IMAP_SERIALIZER_SPACE, &_tmp2_);
	_tmp1__length1 = _tmp2_;
	_tmp3_ = _tmp1_;
	_tmp3__length1 = _tmp1__length1;
	g_output_stream_write_all (_tmp0_, _tmp3_, (gsize) _tmp3__length1, NULL, cancellable, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

/**
     * Writes a NIL atom.
     */
void
geary_imap_serializer_push_nil (GearyImapSerializer* self,
                                GCancellable* cancellable,
                                GError** error)
{
	GOutputStream* _tmp0_;
	guint8* _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_ = 0;
	guint8* _tmp3_;
	gint _tmp3__length1;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (GEARY_IMAP_IS_SERIALIZER (self));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_tmp0_ = self->priv->output;
	_tmp1_ = string_get_data (GEARY_IMAP_NIL_PARAMETER_VALUE, &_tmp2_);
	_tmp1__length1 = _tmp2_;
	_tmp3_ = _tmp1_;
	_tmp3__length1 = _tmp1__length1;
	g_output_stream_write_all (_tmp0_, _tmp3_, (gsize) _tmp3__length1, NULL, cancellable, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

/**
     * Writes a CRLF sequence.
     */
void
geary_imap_serializer_push_eol (GearyImapSerializer* self,
                                GCancellable* cancellable,
                                GError** error)
{
	GOutputStream* _tmp0_;
	guint8* _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_ = 0;
	guint8* _tmp3_;
	gint _tmp3__length1;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (GEARY_IMAP_IS_SERIALIZER (self));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_tmp0_ = self->priv->output;
	_tmp1_ = string_get_data (GEARY_IMAP_SERIALIZER_EOL, &_tmp2_);
	_tmp1__length1 = _tmp2_;
	_tmp3_ = _tmp1_;
	_tmp3__length1 = _tmp1__length1;
	g_output_stream_write_all (_tmp0_, _tmp3_, (gsize) _tmp3__length1, NULL, cancellable, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static void
geary_imap_serializer_push_literal_data_data_free (gpointer _data)
{
	GearyImapSerializerPushLiteralDataData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapSerializerPushLiteralDataData, _data_);
}

void
geary_imap_serializer_push_literal_data (GearyImapSerializer* self,
                                         guint8* buffer,
                                         gint buffer_length1,
                                         GCancellable* cancellable,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	GearyImapSerializerPushLiteralDataData* _data_;
	GearyImapSerializer* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (GEARY_IMAP_IS_SERIALIZER (self));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyImapSerializerPushLiteralDataData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_serializer_push_literal_data_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->buffer = buffer;
	_data_->buffer_length1 = buffer_length1;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	geary_imap_serializer_push_literal_data_co (_data_);
}

void
geary_imap_serializer_push_literal_data_finish (GearyImapSerializer* self,
                                                GAsyncResult* _res_,
                                                GError** error)
{
	GearyImapSerializerPushLiteralDataData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Writes literal data to the output stream.
     */
static void
geary_imap_serializer_push_literal_data_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_)
{
	GearyImapSerializerPushLiteralDataData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_serializer_push_literal_data_co (_data_);
}

static gboolean
geary_imap_serializer_push_literal_data_co (GearyImapSerializerPushLiteralDataData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->buffer_length1 > 0) {
		_data_->_tmp0_ = _data_->self->priv->output;
		_data_->_state_ = 1;
		g_output_stream_write_all_async (_data_->_tmp0_, _data_->buffer, (gsize) _data_->buffer_length1, G_PRIORITY_DEFAULT, _data_->cancellable, geary_imap_serializer_push_literal_data_ready, _data_);
		return FALSE;
		_state_1:
		g_output_stream_write_all_finish (_data_->_tmp0_, _data_->_res_, NULL, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_imap_serializer_flush_stream_data_free (gpointer _data)
{
	GearyImapSerializerFlushStreamData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapSerializerFlushStreamData, _data_);
}

void
geary_imap_serializer_flush_stream (GearyImapSerializer* self,
                                    GCancellable* cancellable,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_)
{
	GearyImapSerializerFlushStreamData* _data_;
	GearyImapSerializer* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (GEARY_IMAP_IS_SERIALIZER (self));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyImapSerializerFlushStreamData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_serializer_flush_stream_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	geary_imap_serializer_flush_stream_co (_data_);
}

void
geary_imap_serializer_flush_stream_finish (GearyImapSerializer* self,
                                           GAsyncResult* _res_,
                                           GError** error)
{
	GearyImapSerializerFlushStreamData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Flushes the output stream, ensuring a command has been sent.
     */
static void
geary_imap_serializer_flush_stream_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_)
{
	GearyImapSerializerFlushStreamData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_serializer_flush_stream_co (_data_);
}

static gboolean
geary_imap_serializer_flush_stream_co (GearyImapSerializerFlushStreamData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->output;
	_data_->_state_ = 1;
	g_output_stream_flush_async (_data_->_tmp0_, G_PRIORITY_DEFAULT, _data_->cancellable, geary_imap_serializer_flush_stream_ready, _data_);
	return FALSE;
	_state_1:
	g_output_stream_flush_finish (_data_->_tmp0_, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_imap_serializer_close_stream_data_free (gpointer _data)
{
	GearyImapSerializerCloseStreamData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapSerializerCloseStreamData, _data_);
}

void
geary_imap_serializer_close_stream (GearyImapSerializer* self,
                                    GCancellable* cancellable,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_)
{
	GearyImapSerializerCloseStreamData* _data_;
	GearyImapSerializer* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (GEARY_IMAP_IS_SERIALIZER (self));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyImapSerializerCloseStreamData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_serializer_close_stream_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	geary_imap_serializer_close_stream_co (_data_);
}

void
geary_imap_serializer_close_stream_finish (GearyImapSerializer* self,
                                           GAsyncResult* _res_,
                                           GError** error)
{
	GearyImapSerializerCloseStreamData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Closes the stream, ensuring a command has been sent.
     */
static void
geary_imap_serializer_close_stream_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_)
{
	GearyImapSerializerCloseStreamData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_serializer_close_stream_co (_data_);
}

static gboolean
geary_imap_serializer_close_stream_co (GearyImapSerializerCloseStreamData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->output;
	_data_->_state_ = 1;
	g_output_stream_close_async (_data_->_tmp0_, G_PRIORITY_DEFAULT, _data_->cancellable, geary_imap_serializer_close_stream_ready, _data_);
	return FALSE;
	_state_1:
	g_output_stream_close_finish (_data_->_tmp0_, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if (_data_->_inner_error0_->domain == G_IO_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_imap_serializer_class_init (GearyImapSerializerClass * klass,
                                  gpointer klass_data)
{
	geary_imap_serializer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyImapSerializer_private_offset);
	G_OBJECT_CLASS (klass)->finalize = geary_imap_serializer_finalize;
}

static void
geary_imap_serializer_instance_init (GearyImapSerializer * self,
                                     gpointer klass)
{
	self->priv = geary_imap_serializer_get_instance_private (self);
}

static void
geary_imap_serializer_finalize (GObject * obj)
{
	GearyImapSerializer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_IMAP_TYPE_SERIALIZER, GearyImapSerializer);
	_g_object_unref0 (self->priv->output);
	G_OBJECT_CLASS (geary_imap_serializer_parent_class)->finalize (obj);
}

/**
 * Writes IMAP protocol strings to the supplied output stream.
 *
 * Since most IMAP commands are small (with the exception of literal
 * data) this class writes directly, synchronously to the given
 * stream. Thus it is highly desirable that the stream passed to the
 * constructor is buffered, either a {@link
 * GLib.BufferedOutputStream}, or some other type that uses a memory
 * buffer large enough to write a typical command completely without
 * causing disk or network I/O.
 *
 * @see Deserializer
 */
 G_GNUC_NO_INLINE static GType
geary_imap_serializer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapSerializerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_serializer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapSerializer), 0, (GInstanceInitFunc) geary_imap_serializer_instance_init, NULL };
	GType geary_imap_serializer_type_id;
	geary_imap_serializer_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "GearyImapSerializer", &g_define_type_info, 0);
	GearyImapSerializer_private_offset = g_type_add_instance_private (geary_imap_serializer_type_id, sizeof (GearyImapSerializerPrivate));
	return geary_imap_serializer_type_id;
}

GType
geary_imap_serializer_get_type (void)
{
	static gsize geary_imap_serializer_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_serializer_type_id__once)) {
		GType geary_imap_serializer_type_id;
		geary_imap_serializer_type_id = geary_imap_serializer_get_type_once ();
		g_once_init_leave (&geary_imap_serializer_type_id__once, geary_imap_serializer_type_id);
	}
	return geary_imap_serializer_type_id__once;
}

