/* memory-buffer.c generated by valac 0.56.3, the Vala compiler
 * generated from memory-buffer.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>

enum  {
	GEARY_MEMORY_BUFFER_0_PROPERTY,
	GEARY_MEMORY_BUFFER_SIZE_PROPERTY,
	GEARY_MEMORY_BUFFER_ALLOCATED_SIZE_PROPERTY,
	GEARY_MEMORY_BUFFER_NUM_PROPERTIES
};
static GParamSpec* geary_memory_buffer_properties[GEARY_MEMORY_BUFFER_NUM_PROPERTIES];
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

static gpointer geary_memory_buffer_parent_class = NULL;

static GBytes* geary_memory_buffer_real_get_bytes (GearyMemoryBuffer* self);
static GInputStream* geary_memory_buffer_real_get_input_stream (GearyMemoryBuffer* self);
static GByteArray* geary_memory_buffer_real_get_byte_array (GearyMemoryBuffer* self);
static guint8* geary_memory_buffer_real_get_uint8_array (GearyMemoryBuffer* self,
                                                  gint* result_length1);
static guint8* _vala_array_dup8 (guint8* self,
                          gssize length);
static gchar* geary_memory_buffer_real_to_string (GearyMemoryBuffer* self);
static void _vala_array_add7 (guint8* * array,
                       gint* length,
                       gint* size,
                       guint8 value);
static gchar* geary_memory_buffer_real_get_valid_utf8 (GearyMemoryBuffer* self);
static GType geary_memory_buffer_get_type_once (void);
static void _vala_geary_memory_buffer_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);

gsize
geary_memory_buffer_get_size (GearyMemoryBuffer* self)
{
	GearyMemoryBufferClass* _klass_;
	g_return_val_if_fail (GEARY_MEMORY_IS_BUFFER (self), 0UL);
	_klass_ = GEARY_MEMORY_BUFFER_GET_CLASS (self);
	if (_klass_->get_size) {
		return _klass_->get_size (self);
	}
	return 0UL;
}

gsize
geary_memory_buffer_get_allocated_size (GearyMemoryBuffer* self)
{
	GearyMemoryBufferClass* _klass_;
	g_return_val_if_fail (GEARY_MEMORY_IS_BUFFER (self), 0UL);
	_klass_ = GEARY_MEMORY_BUFFER_GET_CLASS (self);
	if (_klass_->get_allocated_size) {
		return _klass_->get_allocated_size (self);
	}
	return 0UL;
}

/**
     * Returns a Bytes object holding the buffer's contents.
     *
     * Since Bytes is immutable, the caller will need to make its own copy if it wants to modify
     * the data.
     */
static GBytes*
geary_memory_buffer_real_get_bytes (GearyMemoryBuffer* self)
{
	g_critical ("Type `%s' does not implement abstract method `geary_memory_buffer_get_bytes'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

GBytes*
geary_memory_buffer_get_bytes (GearyMemoryBuffer* self)
{
	GearyMemoryBufferClass* _klass_;
	g_return_val_if_fail (GEARY_MEMORY_IS_BUFFER (self), NULL);
	_klass_ = GEARY_MEMORY_BUFFER_GET_CLASS (self);
	if (_klass_->get_bytes) {
		return _klass_->get_bytes (self);
	}
	return NULL;
}

/**
     * Returns an InputStream that can read the buffer in its current entirety.
     *
     * Note that the InputStream may share its memory buffer(s) with the Buffer but does
     * not hold references to them or the Buffer itself.  Thus, the Buffer should
     * only be destroyed after all InputStreams are destroyed or exhausted.
     *
     * The base class implementation uses {@link get_bytes} to create the InputStream.  Subclasses
     * should look for more optimal implementations.
     */
static GInputStream*
geary_memory_buffer_real_get_input_stream (GearyMemoryBuffer* self)
{
	GBytes* _tmp0_;
	GBytes* _tmp1_;
	GMemoryInputStream* _tmp2_;
	GInputStream* _tmp3_;
	GInputStream* result;
	_tmp0_ = geary_memory_buffer_get_bytes (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = (GMemoryInputStream*) g_memory_input_stream_new_from_bytes (_tmp1_);
	_tmp3_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, g_input_stream_get_type (), GInputStream);
	_g_bytes_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}

GInputStream*
geary_memory_buffer_get_input_stream (GearyMemoryBuffer* self)
{
	GearyMemoryBufferClass* _klass_;
	g_return_val_if_fail (GEARY_MEMORY_IS_BUFFER (self), NULL);
	_klass_ = GEARY_MEMORY_BUFFER_GET_CLASS (self);
	if (_klass_->get_input_stream) {
		return _klass_->get_input_stream (self);
	}
	return NULL;
}

/**
     * Returns a ByteArray storing the buffer in its entirety.
     *
     * A copy of the backing buffer is returned.
     *
     * The base class implementation uses {@link get_bytes} to create the InputStream.  Subclasses
     * should look for more optimal implementations.
     */
static GByteArray*
geary_memory_buffer_real_get_byte_array (GearyMemoryBuffer* self)
{
	GByteArray* byte_array = NULL;
	GByteArray* _tmp0_;
	GBytes* _tmp1_;
	GBytes* _tmp2_;
	gsize _tmp3_ = 0;
	guint8* _tmp4_;
	GByteArray* result;
	_tmp0_ = g_byte_array_new ();
	byte_array = _tmp0_;
	_tmp1_ = geary_memory_buffer_get_bytes (self);
	_tmp2_ = _tmp1_;
	_tmp4_ = g_bytes_get_data (_tmp2_, &_tmp3_);
	g_byte_array_append (byte_array, _tmp4_, (gint) _tmp3_);
	_g_bytes_unref0 (_tmp2_);
	result = byte_array;
	return result;
}

GByteArray*
geary_memory_buffer_get_byte_array (GearyMemoryBuffer* self)
{
	GearyMemoryBufferClass* _klass_;
	g_return_val_if_fail (GEARY_MEMORY_IS_BUFFER (self), NULL);
	_klass_ = GEARY_MEMORY_BUFFER_GET_CLASS (self);
	if (_klass_->get_byte_array) {
		return _klass_->get_byte_array (self);
	}
	return NULL;
}

/**
     * Returns an array of uint8 storing the buffer in its entirety.
     *
     * A copy of the backing buffer is returned.
     *
     * The base class implementation uses {@link get_bytes} to create the InputStream.  Subclasses
     * should look for more optimal implementations.
     *
     * @see UnownedBytesBuffer
     */
static guint8*
_vala_array_dup8 (guint8* self,
                  gssize length)
{
	if (length > 0) {
		return g_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

static guint8*
geary_memory_buffer_real_get_uint8_array (GearyMemoryBuffer* self,
                                          gint* result_length1)
{
	GBytes* _tmp0_;
	GBytes* _tmp1_;
	gsize _tmp2_ = 0;
	guint8* _tmp3_;
	guint8* _tmp4_;
	gint _tmp4__length1;
	guint8* _tmp5_;
	gint _tmp5__length1;
	guint8* _tmp6_;
	gint _tmp6__length1;
	guint8* result;
	_tmp0_ = geary_memory_buffer_get_bytes (self);
	_tmp1_ = _tmp0_;
	_tmp3_ = g_bytes_get_data (_tmp1_, &_tmp2_);
	_tmp4_ = (_tmp3_ != NULL) ? _vala_array_dup8 (_tmp3_, _tmp2_) : _tmp3_;
	_tmp4__length1 = _tmp2_;
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp4__length1;
	_g_bytes_unref0 (_tmp1_);
	_tmp6_ = _tmp5_;
	_tmp6__length1 = _tmp5__length1;
	if (result_length1) {
		*result_length1 = _tmp6__length1;
	}
	result = _tmp6_;
	return result;
}

guint8*
geary_memory_buffer_get_uint8_array (GearyMemoryBuffer* self,
                                     gint* result_length1)
{
	GearyMemoryBufferClass* _klass_;
	g_return_val_if_fail (GEARY_MEMORY_IS_BUFFER (self), NULL);
	_klass_ = GEARY_MEMORY_BUFFER_GET_CLASS (self);
	if (_klass_->get_uint8_array) {
		return _klass_->get_uint8_array (self, result_length1);
	}
	return NULL;
}

/**
     * Returns a copy of the contents of the buffer as though it was a null terminated string.
     *
     * The base class implementation uses {@link get_bytes} to create the InputStream.  Subclasses
     * should look for more optimal implementations.
     *
     * No validation is made on the string.  See {@link get_valid_utf8}.
     *
     * @see UnownedStringBuffer
     */
static void
_vala_array_add7 (guint8* * array,
                  gint* length,
                  gint* size,
                  guint8 value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint8, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static gchar*
geary_memory_buffer_real_to_string (GearyMemoryBuffer* self)
{
	guint8* buffer = NULL;
	gint _tmp0_ = 0;
	guint8* _tmp1_;
	gint buffer_length1;
	gint _buffer_size_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	gchar* _tmp3_;
	gchar* result;
	_tmp1_ = geary_memory_buffer_get_uint8_array (self, &_tmp0_);
	buffer = _tmp1_;
	buffer_length1 = _tmp0_;
	_buffer_size_ = buffer_length1;
	_vala_array_add7 (&buffer, &buffer_length1, &_buffer_size_, (guint8) '\0');
	_tmp2_ = buffer;
	_tmp2__length1 = buffer_length1;
	_tmp3_ = g_strdup ((const gchar*) _tmp2_);
	result = _tmp3_;
	buffer = (g_free (buffer), NULL);
	return result;
}

gchar*
geary_memory_buffer_to_string (GearyMemoryBuffer* self)
{
	GearyMemoryBufferClass* _klass_;
	g_return_val_if_fail (GEARY_MEMORY_IS_BUFFER (self), NULL);
	_klass_ = GEARY_MEMORY_BUFFER_GET_CLASS (self);
	if (_klass_->to_string) {
		return _klass_->to_string (self);
	}
	return NULL;
}

/**
     * Returns a copy of the contents of the buffer as a UTF-8 string.
     *
     * The base class implementation uses {@link to_string} to create
     * the string and and {@link string.make_valid} to perform the
     * validation. Subclasses should look for more optimal
     * implementations.
     */
static gchar*
geary_memory_buffer_real_get_valid_utf8 (GearyMemoryBuffer* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	_tmp0_ = geary_memory_buffer_to_string (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_utf8_make_valid (_tmp1_, (gssize) -1);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

gchar*
geary_memory_buffer_get_valid_utf8 (GearyMemoryBuffer* self)
{
	GearyMemoryBufferClass* _klass_;
	g_return_val_if_fail (GEARY_MEMORY_IS_BUFFER (self), NULL);
	_klass_ = GEARY_MEMORY_BUFFER_GET_CLASS (self);
	if (_klass_->get_valid_utf8) {
		return _klass_->get_valid_utf8 (self);
	}
	return NULL;
}

GearyMemoryBuffer*
geary_memory_buffer_construct (GType object_type)
{
	GearyMemoryBuffer * self = NULL;
	self = (GearyMemoryBuffer*) geary_base_object_construct (object_type);
	return self;
}

static void
geary_memory_buffer_class_init (GearyMemoryBufferClass * klass,
                                gpointer klass_data)
{
	geary_memory_buffer_parent_class = g_type_class_peek_parent (klass);
	((GearyMemoryBufferClass *) klass)->get_bytes = (GBytes* (*) (GearyMemoryBuffer*)) geary_memory_buffer_real_get_bytes;
	((GearyMemoryBufferClass *) klass)->get_input_stream = (GInputStream* (*) (GearyMemoryBuffer*)) geary_memory_buffer_real_get_input_stream;
	((GearyMemoryBufferClass *) klass)->get_byte_array = (GByteArray* (*) (GearyMemoryBuffer*)) geary_memory_buffer_real_get_byte_array;
	((GearyMemoryBufferClass *) klass)->get_uint8_array = (guint8* (*) (GearyMemoryBuffer*, gint*)) geary_memory_buffer_real_get_uint8_array;
	((GearyMemoryBufferClass *) klass)->to_string = (gchar* (*) (GearyMemoryBuffer*)) geary_memory_buffer_real_to_string;
	((GearyMemoryBufferClass *) klass)->get_valid_utf8 = (gchar* (*) (GearyMemoryBuffer*)) geary_memory_buffer_real_get_valid_utf8;
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_memory_buffer_get_property;
	/**
	     * Returns the number of valid (usable) bytes in the buffer.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_MEMORY_BUFFER_SIZE_PROPERTY, geary_memory_buffer_properties[GEARY_MEMORY_BUFFER_SIZE_PROPERTY] = g_param_spec_ulong ("size", "size", "size", 0, G_MAXULONG, 0UL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Returns the number of bytes allocated (usable and unusable) for the buffer.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_MEMORY_BUFFER_ALLOCATED_SIZE_PROPERTY, geary_memory_buffer_properties[GEARY_MEMORY_BUFFER_ALLOCATED_SIZE_PROPERTY] = g_param_spec_ulong ("allocated-size", "allocated-size", "allocated-size", 0, G_MAXULONG, 0UL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_memory_buffer_instance_init (GearyMemoryBuffer * self,
                                   gpointer klass)
{
}

/**
 * Represents an interface to a variety of backing buffers.
 *
 * A Buffer may be an in-memory or on-disk block of bytes.  Buffer allows for a
 * uniform interface to these blocks and makes it easy to move them around and avoiding copies.
 *
 * Questions of mutability are left to the implementation and users of Buffer.  In general,
 * AbstractBuffers should be built and modified before allowing other callers to access it.
 *
 * @see ByteBuffer
 * @see EmptyBuffer
 * @see GrowableBuffer
 * @see StringBuffer
 * @see UnownedStringBuffer
 * @see UnownedBytesBuffer
 */
 G_GNUC_NO_INLINE static GType
geary_memory_buffer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyMemoryBufferClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_memory_buffer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyMemoryBuffer), 0, (GInstanceInitFunc) geary_memory_buffer_instance_init, NULL };
	GType geary_memory_buffer_type_id;
	geary_memory_buffer_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "GearyMemoryBuffer", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	return geary_memory_buffer_type_id;
}

GType
geary_memory_buffer_get_type (void)
{
	static gsize geary_memory_buffer_type_id__once = 0;
	if (g_once_init_enter (&geary_memory_buffer_type_id__once)) {
		GType geary_memory_buffer_type_id;
		geary_memory_buffer_type_id = geary_memory_buffer_get_type_once ();
		g_once_init_leave (&geary_memory_buffer_type_id__once, geary_memory_buffer_type_id);
	}
	return geary_memory_buffer_type_id__once;
}

static void
_vala_geary_memory_buffer_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	GearyMemoryBuffer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_MEMORY_TYPE_BUFFER, GearyMemoryBuffer);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

