/* smtp-login-authenticator.c generated by valac 0.56.3, the Vala compiler
 * generated from smtp-login-authenticator.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>

enum  {
	GEARY_SMTP_LOGIN_AUTHENTICATOR_0_PROPERTY,
	GEARY_SMTP_LOGIN_AUTHENTICATOR_NUM_PROPERTIES
};
static GParamSpec* geary_smtp_login_authenticator_properties[GEARY_SMTP_LOGIN_AUTHENTICATOR_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

static gpointer geary_smtp_login_authenticator_parent_class = NULL;

static GearySmtpRequest* geary_smtp_login_authenticator_real_initiate (GearySmtpAuthenticator* base);
static GearyMemoryBuffer* geary_smtp_login_authenticator_real_challenge (GearySmtpAuthenticator* base,
                                                                  gint step,
                                                                  GearySmtpResponse* response,
                                                                  GError** error);
static GType geary_smtp_login_authenticator_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

GearySmtpLoginAuthenticator*
geary_smtp_login_authenticator_construct (GType object_type,
                                          GearyCredentials* credentials)
{
	GearySmtpLoginAuthenticator * self = NULL;
	g_return_val_if_fail (GEARY_IS_CREDENTIALS (credentials), NULL);
	self = (GearySmtpLoginAuthenticator*) geary_smtp_authenticator_construct (object_type, "LOGIN", credentials);
	return self;
}

GearySmtpLoginAuthenticator*
geary_smtp_login_authenticator_new (GearyCredentials* credentials)
{
	return geary_smtp_login_authenticator_construct (GEARY_SMTP_TYPE_LOGIN_AUTHENTICATOR, credentials);
}

static GearySmtpRequest*
geary_smtp_login_authenticator_real_initiate (GearySmtpAuthenticator* base)
{
	GearySmtpLoginAuthenticator * self;
	gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	GearySmtpRequest* _tmp3_;
	GearySmtpRequest* _tmp4_;
	GearySmtpRequest* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_SMTP_TYPE_LOGIN_AUTHENTICATOR, GearySmtpLoginAuthenticator);
	_tmp0_ = g_strdup ("login");
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = 1;
	_tmp3_ = geary_smtp_request_new (GEARY_SMTP_COMMAND_AUTH, _tmp2_, 1);
	_tmp4_ = _tmp3_;
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
	result = _tmp4_;
	return result;
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static GearyMemoryBuffer*
geary_smtp_login_authenticator_real_challenge (GearySmtpAuthenticator* base,
                                               gint step,
                                               GearySmtpResponse* response,
                                               GError** error)
{
	GearySmtpLoginAuthenticator * self;
	GearyMemoryBuffer* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_SMTP_TYPE_LOGIN_AUTHENTICATOR, GearySmtpLoginAuthenticator);
	g_return_val_if_fail (GEARY_SMTP_IS_RESPONSE (response), NULL);
	switch (step) {
		case 0:
		{
			GearyCredentials* _tmp0_;
			GearyCredentials* _tmp1_;
			const gchar* _tmp2_;
			const gchar* _tmp3_;
			guint8* _tmp4_;
			gint _tmp4__length1;
			gint _tmp5_ = 0;
			guint8* _tmp6_;
			gint _tmp6__length1;
			gchar* _tmp7_;
			gchar* _tmp8_;
			GearyMemoryStringBuffer* _tmp9_;
			GearyMemoryBuffer* _tmp10_;
			_tmp0_ = geary_smtp_authenticator_get_credentials (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_SMTP_TYPE_AUTHENTICATOR, GearySmtpAuthenticator));
			_tmp1_ = _tmp0_;
			_tmp2_ = geary_credentials_get_user (_tmp1_);
			_tmp3_ = _tmp2_;
			_tmp4_ = string_get_data (_tmp3_, &_tmp5_);
			_tmp4__length1 = _tmp5_;
			_tmp6_ = _tmp4_;
			_tmp6__length1 = _tmp4__length1;
			_tmp7_ = g_base64_encode (_tmp6_, (gint) _tmp6__length1);
			_tmp8_ = _tmp7_;
			_tmp9_ = geary_memory_string_buffer_new (_tmp8_);
			_tmp10_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEARY_MEMORY_TYPE_BUFFER, GearyMemoryBuffer);
			_g_free0 (_tmp8_);
			result = _tmp10_;
			return result;
		}
		case 1:
		{
			const gchar* _tmp11_ = NULL;
			GearyCredentials* _tmp12_;
			GearyCredentials* _tmp13_;
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			guint8* _tmp16_;
			gint _tmp16__length1;
			gint _tmp17_ = 0;
			guint8* _tmp18_;
			gint _tmp18__length1;
			gchar* _tmp19_;
			gchar* _tmp20_;
			GearyMemoryStringBuffer* _tmp21_;
			GearyMemoryBuffer* _tmp22_;
			_tmp12_ = geary_smtp_authenticator_get_credentials (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_SMTP_TYPE_AUTHENTICATOR, GearySmtpAuthenticator));
			_tmp13_ = _tmp12_;
			_tmp14_ = geary_credentials_get_token (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp11_ = _tmp15_;
			if (_tmp11_ == NULL) {
				_tmp11_ = "";
			}
			_tmp16_ = string_get_data (_tmp11_, &_tmp17_);
			_tmp16__length1 = _tmp17_;
			_tmp18_ = _tmp16_;
			_tmp18__length1 = _tmp16__length1;
			_tmp19_ = g_base64_encode (_tmp18_, (gint) _tmp18__length1);
			_tmp20_ = _tmp19_;
			_tmp21_ = geary_memory_string_buffer_new (_tmp20_);
			_tmp22_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, GEARY_MEMORY_TYPE_BUFFER, GearyMemoryBuffer);
			_g_free0 (_tmp20_);
			result = _tmp22_;
			return result;
		}
		default:
		{
			result = NULL;
			return result;
		}
	}
}

static void
geary_smtp_login_authenticator_class_init (GearySmtpLoginAuthenticatorClass * klass,
                                           gpointer klass_data)
{
	geary_smtp_login_authenticator_parent_class = g_type_class_peek_parent (klass);
	((GearySmtpAuthenticatorClass *) klass)->initiate = (GearySmtpRequest* (*) (GearySmtpAuthenticator*)) geary_smtp_login_authenticator_real_initiate;
	((GearySmtpAuthenticatorClass *) klass)->challenge = (GearyMemoryBuffer* (*) (GearySmtpAuthenticator*, gint, GearySmtpResponse*, GError**)) geary_smtp_login_authenticator_real_challenge;
}

static void
geary_smtp_login_authenticator_instance_init (GearySmtpLoginAuthenticator * self,
                                              gpointer klass)
{
}

/**
 * SASL's LOGIN authentication schema implemented as an {@link Authenticator}.
 *
 * LOGIN is obsolete but still widely in use and provided for backward compatibility.
 *
 * See [[https://tools.ietf.org/html/draft-murchison-sasl-login-00]]
 */
 G_GNUC_NO_INLINE static GType
geary_smtp_login_authenticator_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearySmtpLoginAuthenticatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_smtp_login_authenticator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearySmtpLoginAuthenticator), 0, (GInstanceInitFunc) geary_smtp_login_authenticator_instance_init, NULL };
	GType geary_smtp_login_authenticator_type_id;
	geary_smtp_login_authenticator_type_id = g_type_register_static (GEARY_SMTP_TYPE_AUTHENTICATOR, "GearySmtpLoginAuthenticator", &g_define_type_info, 0);
	return geary_smtp_login_authenticator_type_id;
}

GType
geary_smtp_login_authenticator_get_type (void)
{
	static gsize geary_smtp_login_authenticator_type_id__once = 0;
	if (g_once_init_enter (&geary_smtp_login_authenticator_type_id__once)) {
		GType geary_smtp_login_authenticator_type_id;
		geary_smtp_login_authenticator_type_id = geary_smtp_login_authenticator_get_type_once ();
		g_once_init_leave (&geary_smtp_login_authenticator_type_id__once, geary_smtp_login_authenticator_type_id);
	}
	return geary_smtp_login_authenticator_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

