/* smtp-response-line.c generated by valac 0.56.3, the Vala compiler
 * generated from smtp-response-line.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gobject/gvaluecollector.h>

#define _geary_smtp_response_code_unref0(var) ((var == NULL) ? NULL : (var = (geary_smtp_response_code_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _GearySmtpParamSpecResponseLine GearySmtpParamSpecResponseLine;

struct _GearySmtpResponseLinePrivate {
	GearySmtpResponseCode* _code;
	gchar* _explanation;
	gboolean _continued;
};

struct _GearySmtpParamSpecResponseLine {
	GParamSpec parent_instance;
};

static gint GearySmtpResponseLine_private_offset;
static gpointer geary_smtp_response_line_parent_class = NULL;

static void geary_smtp_response_line_set_code (GearySmtpResponseLine* self,
                                        GearySmtpResponseCode* value);
static void geary_smtp_response_line_set_explanation (GearySmtpResponseLine* self,
                                               const gchar* value);
static void geary_smtp_response_line_set_continued (GearySmtpResponseLine* self,
                                             gboolean value);
static void geary_smtp_response_line_finalize (GearySmtpResponseLine * obj);
static GType geary_smtp_response_line_get_type_once (void);

static inline gpointer
geary_smtp_response_line_get_instance_private (GearySmtpResponseLine* self)
{
	return G_STRUCT_MEMBER_P (self, GearySmtpResponseLine_private_offset);
}

GearySmtpResponseCode*
geary_smtp_response_line_get_code (GearySmtpResponseLine* self)
{
	GearySmtpResponseCode* result;
	GearySmtpResponseCode* _tmp0_;
	g_return_val_if_fail (GEARY_SMTP_IS_RESPONSE_LINE (self), NULL);
	_tmp0_ = self->priv->_code;
	result = _tmp0_;
	return result;
}

static gpointer
_geary_smtp_response_code_ref0 (gpointer self)
{
	return self ? geary_smtp_response_code_ref (self) : NULL;
}

static void
geary_smtp_response_line_set_code (GearySmtpResponseLine* self,
                                   GearySmtpResponseCode* value)
{
	GearySmtpResponseCode* _tmp0_;
	g_return_if_fail (GEARY_SMTP_IS_RESPONSE_LINE (self));
	_tmp0_ = _geary_smtp_response_code_ref0 (value);
	_geary_smtp_response_code_unref0 (self->priv->_code);
	self->priv->_code = _tmp0_;
}

const gchar*
geary_smtp_response_line_get_explanation (GearySmtpResponseLine* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_SMTP_IS_RESPONSE_LINE (self), NULL);
	_tmp0_ = self->priv->_explanation;
	result = _tmp0_;
	return result;
}

static void
geary_smtp_response_line_set_explanation (GearySmtpResponseLine* self,
                                          const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (GEARY_SMTP_IS_RESPONSE_LINE (self));
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_explanation);
	self->priv->_explanation = _tmp0_;
}

gboolean
geary_smtp_response_line_get_continued (GearySmtpResponseLine* self)
{
	gboolean result;
	g_return_val_if_fail (GEARY_SMTP_IS_RESPONSE_LINE (self), FALSE);
	result = self->priv->_continued;
	return result;
}

static void
geary_smtp_response_line_set_continued (GearySmtpResponseLine* self,
                                        gboolean value)
{
	g_return_if_fail (GEARY_SMTP_IS_RESPONSE_LINE (self));
	self->priv->_continued = value;
}

GearySmtpResponseLine*
geary_smtp_response_line_construct (GType object_type,
                                    GearySmtpResponseCode* code,
                                    const gchar* explanation,
                                    gboolean continued)
{
	GearySmtpResponseLine* self = NULL;
	g_return_val_if_fail (GEARY_SMTP_IS_RESPONSE_CODE (code), NULL);
	self = (GearySmtpResponseLine*) g_type_create_instance (object_type);
	geary_smtp_response_line_set_code (self, code);
	geary_smtp_response_line_set_explanation (self, explanation);
	geary_smtp_response_line_set_continued (self, continued);
	return self;
}

GearySmtpResponseLine*
geary_smtp_response_line_new (GearySmtpResponseCode* code,
                              const gchar* explanation,
                              gboolean continued)
{
	return geary_smtp_response_line_construct (GEARY_SMTP_TYPE_RESPONSE_LINE, code, explanation, continued);
}

/**
     * Converts a serialized line into something usable.  The CRLF should *not* be included in
     * the input.
     */
static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

GearySmtpResponseLine*
geary_smtp_response_line_deserialize (const gchar* line,
                                      GError** error)
{
	gint _tmp0_;
	gint _tmp1_;
	gchar* explanation = NULL;
	gboolean continued = FALSE;
	GearySmtpResponseCode* _tmp8_ = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GearySmtpResponseCode* _tmp11_;
	GearySmtpResponseCode* _tmp12_;
	const gchar* _tmp13_;
	GearySmtpResponseLine* _tmp14_;
	GError* _inner_error0_ = NULL;
	GearySmtpResponseLine* result;
	g_return_val_if_fail (line != NULL, NULL);
	_tmp0_ = strlen (line);
	_tmp1_ = _tmp0_;
	if (_tmp1_ < GEARY_SMTP_RESPONSE_CODE_STRLEN) {
		GError* _tmp2_;
		_tmp2_ = g_error_new (GEARY_SMTP_ERROR, GEARY_SMTP_ERROR_PARSE_ERROR, "Line too short: %s", line);
		_inner_error0_ = _tmp2_;
		if (_inner_error0_->domain == GEARY_SMTP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	switch (string_get (line, (glong) GEARY_SMTP_RESPONSE_CODE_STRLEN)) {
		case GEARY_SMTP_RESPONSE_LINE_NOT_CONTINUED_CHAR:
		{
			gchar* _tmp3_;
			_tmp3_ = string_substring (line, (glong) (GEARY_SMTP_RESPONSE_CODE_STRLEN + 1), (glong) -1);
			_g_free0 (explanation);
			explanation = _tmp3_;
			continued = FALSE;
			break;
		}
		case GEARY_STRING_EOS:
		{
			_g_free0 (explanation);
			explanation = NULL;
			continued = FALSE;
			break;
		}
		case GEARY_SMTP_RESPONSE_LINE_CONTINUED_CHAR:
		{
			gchar* _tmp4_;
			const gchar* _tmp5_;
			gchar* _tmp6_;
			_tmp4_ = string_substring (line, (glong) (GEARY_SMTP_RESPONSE_CODE_STRLEN + 1), (glong) -1);
			_g_free0 (explanation);
			explanation = _tmp4_;
			_tmp5_ = explanation;
			_tmp6_ = g_strdup (_tmp5_);
			_g_free0 (explanation);
			explanation = _tmp6_;
			continued = TRUE;
			break;
		}
		default:
		{
			GError* _tmp7_;
			_tmp7_ = g_error_new (GEARY_SMTP_ERROR, GEARY_SMTP_ERROR_PARSE_ERROR, "Invalid response line separator: %s", line);
			_inner_error0_ = _tmp7_;
			if (_inner_error0_->domain == GEARY_SMTP_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (explanation);
				return NULL;
			} else {
				_g_free0 (explanation);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
	}
	_tmp9_ = string_substring (line, (glong) 0, (glong) GEARY_SMTP_RESPONSE_CODE_STRLEN);
	_tmp10_ = _tmp9_;
	_tmp11_ = geary_smtp_response_code_new (_tmp10_, &_inner_error0_);
	_tmp12_ = _tmp11_;
	_g_free0 (_tmp10_);
	_tmp8_ = _tmp12_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_SMTP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (explanation);
			return NULL;
		} else {
			_g_free0 (explanation);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp13_ = explanation;
	_tmp14_ = geary_smtp_response_line_new (_tmp8_, _tmp13_, continued);
	result = _tmp14_;
	_geary_smtp_response_code_unref0 (_tmp8_);
	_g_free0 (explanation);
	return result;
}

/**
     * Serializes the Reply into a line for transmission.  Note that the CRLF is *not* included.
     */
gchar*
geary_smtp_response_line_serialize (GearySmtpResponseLine* self)
{
	gchar _tmp0_ = '\0';
	gboolean _tmp1_;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_;
	GearySmtpResponseCode* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* result;
	g_return_val_if_fail (GEARY_SMTP_IS_RESPONSE_LINE (self), NULL);
	_tmp1_ = self->priv->_continued;
	if (_tmp1_) {
		_tmp0_ = GEARY_SMTP_RESPONSE_LINE_CONTINUED_CHAR;
	} else {
		_tmp0_ = GEARY_SMTP_RESPONSE_LINE_NOT_CONTINUED_CHAR;
	}
	_tmp3_ = self->priv->_explanation;
	_tmp2_ = _tmp3_;
	if (_tmp2_ == NULL) {
		_tmp2_ = "";
	}
	_tmp4_ = self->priv->_code;
	_tmp5_ = geary_smtp_response_code_serialize (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strdup_printf ("%s%c%s", _tmp6_, (gint) _tmp0_, _tmp2_);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	result = _tmp8_;
	return result;
}

gchar*
geary_smtp_response_line_to_string (GearySmtpResponseLine* self)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (GEARY_SMTP_IS_RESPONSE_LINE (self), NULL);
	_tmp0_ = geary_smtp_response_line_serialize (self);
	result = _tmp0_;
	return result;
}

static void
geary_smtp_value_response_line_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
geary_smtp_value_response_line_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		geary_smtp_response_line_unref (value->data[0].v_pointer);
	}
}

static void
geary_smtp_value_response_line_copy_value (const GValue* src_value,
                                           GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = geary_smtp_response_line_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
geary_smtp_value_response_line_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
geary_smtp_value_response_line_collect_value (GValue* value,
                                              guint n_collect_values,
                                              GTypeCValue* collect_values,
                                              guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GearySmtpResponseLine * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = geary_smtp_response_line_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
geary_smtp_value_response_line_lcopy_value (const GValue* value,
                                            guint n_collect_values,
                                            GTypeCValue* collect_values,
                                            guint collect_flags)
{
	GearySmtpResponseLine ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = geary_smtp_response_line_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
geary_smtp_param_spec_response_line (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags)
{
	GearySmtpParamSpecResponseLine* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GEARY_SMTP_TYPE_RESPONSE_LINE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
geary_smtp_value_get_response_line (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEARY_SMTP_TYPE_RESPONSE_LINE), NULL);
	return value->data[0].v_pointer;
}

void
geary_smtp_value_set_response_line (GValue* value,
                                    gpointer v_object)
{
	GearySmtpResponseLine * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEARY_SMTP_TYPE_RESPONSE_LINE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GEARY_SMTP_TYPE_RESPONSE_LINE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		geary_smtp_response_line_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		geary_smtp_response_line_unref (old);
	}
}

void
geary_smtp_value_take_response_line (GValue* value,
                                     gpointer v_object)
{
	GearySmtpResponseLine * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEARY_SMTP_TYPE_RESPONSE_LINE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GEARY_SMTP_TYPE_RESPONSE_LINE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		geary_smtp_response_line_unref (old);
	}
}

static void
geary_smtp_response_line_class_init (GearySmtpResponseLineClass * klass,
                                     gpointer klass_data)
{
	geary_smtp_response_line_parent_class = g_type_class_peek_parent (klass);
	((GearySmtpResponseLineClass *) klass)->finalize = geary_smtp_response_line_finalize;
	g_type_class_adjust_private_offset (klass, &GearySmtpResponseLine_private_offset);
}

static void
geary_smtp_response_line_instance_init (GearySmtpResponseLine * self,
                                        gpointer klass)
{
	self->priv = geary_smtp_response_line_get_instance_private (self);
	self->ref_count = 1;
}

static void
geary_smtp_response_line_finalize (GearySmtpResponseLine * obj)
{
	GearySmtpResponseLine * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_SMTP_TYPE_RESPONSE_LINE, GearySmtpResponseLine);
	g_signal_handlers_destroy (self);
	_geary_smtp_response_code_unref0 (self->priv->_code);
	_g_free0 (self->priv->_explanation);
}

 G_GNUC_NO_INLINE static GType
geary_smtp_response_line_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { geary_smtp_value_response_line_init, geary_smtp_value_response_line_free_value, geary_smtp_value_response_line_copy_value, geary_smtp_value_response_line_peek_pointer, "p", geary_smtp_value_response_line_collect_value, "p", geary_smtp_value_response_line_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GearySmtpResponseLineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_smtp_response_line_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearySmtpResponseLine), 0, (GInstanceInitFunc) geary_smtp_response_line_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType geary_smtp_response_line_type_id;
	geary_smtp_response_line_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GearySmtpResponseLine", &g_define_type_info, &g_define_type_fundamental_info, 0);
	GearySmtpResponseLine_private_offset = g_type_add_instance_private (geary_smtp_response_line_type_id, sizeof (GearySmtpResponseLinePrivate));
	return geary_smtp_response_line_type_id;
}

GType
geary_smtp_response_line_get_type (void)
{
	static gsize geary_smtp_response_line_type_id__once = 0;
	if (g_once_init_enter (&geary_smtp_response_line_type_id__once)) {
		GType geary_smtp_response_line_type_id;
		geary_smtp_response_line_type_id = geary_smtp_response_line_get_type_once ();
		g_once_init_leave (&geary_smtp_response_line_type_id__once, geary_smtp_response_line_type_id);
	}
	return geary_smtp_response_line_type_id__once;
}

gpointer
geary_smtp_response_line_ref (gpointer instance)
{
	GearySmtpResponseLine * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
geary_smtp_response_line_unref (gpointer instance)
{
	GearySmtpResponseLine * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GEARY_SMTP_RESPONSE_LINE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

