/* util-error-context.c generated by valac 0.56.3, the Vala compiler
 * generated from util-error-context.vala, do not modify */

/*
 * Copyright 2019 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include "libunwind.h"
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>

enum  {
	GEARY_ERROR_CONTEXT_0_PROPERTY,
	GEARY_ERROR_CONTEXT_THROWN_PROPERTY,
	GEARY_ERROR_CONTEXT_BACKTRACE_PROPERTY,
	GEARY_ERROR_CONTEXT_NUM_PROPERTIES
};
static GParamSpec* geary_error_context_properties[GEARY_ERROR_CONTEXT_NUM_PROPERTIES];
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _geary_error_context_stack_frame_unref0(var) ((var == NULL) ? NULL : (var = (geary_error_context_stack_frame_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _GearyErrorContextParamSpecStackFrame GearyErrorContextParamSpecStackFrame;

struct _GearyErrorContextPrivate {
	GError* _thrown;
	GeeList* _backtrace;
};

struct _GearyErrorContextParamSpecStackFrame {
	GParamSpec parent_instance;
};

static gint GearyErrorContext_private_offset;
static gpointer geary_error_context_parent_class = NULL;
static gpointer geary_error_context_stack_frame_parent_class = NULL;

static void geary_error_context_set_thrown (GearyErrorContext* self,
                                     GError* value);
static void geary_error_context_set_backtrace (GearyErrorContext* self,
                                        GeeList* value);
VALA_EXTERN GearyErrorContextStackFrame* geary_error_context_stack_frame_new (unw_cursor_t* frame);
VALA_EXTERN GearyErrorContextStackFrame* geary_error_context_stack_frame_construct (GType object_type,
                                                                        unw_cursor_t* frame);
static void geary_error_context_stack_frame_finalize (GearyErrorContextStackFrame * obj);
static GType geary_error_context_stack_frame_get_type_once (void);
static void geary_error_context_finalize (GObject * obj);
static GType geary_error_context_get_type_once (void);
static void _vala_geary_error_context_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_geary_error_context_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
geary_error_context_get_instance_private (GearyErrorContext* self)
{
	return G_STRUCT_MEMBER_P (self, GearyErrorContext_private_offset);
}

GError*
geary_error_context_get_thrown (GearyErrorContext* self)
{
	GError* result;
	GError* _tmp0_;
	g_return_val_if_fail (GEARY_IS_ERROR_CONTEXT (self), NULL);
	_tmp0_ = self->priv->_thrown;
	result = _tmp0_;
	return result;
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static void
geary_error_context_set_thrown (GearyErrorContext* self,
                                GError* value)
{
	GError* old_value;
	g_return_if_fail (GEARY_IS_ERROR_CONTEXT (self));
	old_value = geary_error_context_get_thrown (self);
	if (old_value != value) {
		GError* _tmp0_;
		_tmp0_ = _g_error_copy0 (value);
		_g_error_free0 (self->priv->_thrown);
		self->priv->_thrown = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_error_context_properties[GEARY_ERROR_CONTEXT_THROWN_PROPERTY]);
	}
}

GeeList*
geary_error_context_get_backtrace (GearyErrorContext* self)
{
	GeeList* result;
	GeeList* _tmp0_;
	g_return_val_if_fail (GEARY_IS_ERROR_CONTEXT (self), NULL);
	_tmp0_ = self->priv->_backtrace;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
geary_error_context_set_backtrace (GearyErrorContext* self,
                                   GeeList* value)
{
	GeeList* old_value;
	g_return_if_fail (GEARY_IS_ERROR_CONTEXT (self));
	old_value = geary_error_context_get_backtrace (self);
	if (old_value != value) {
		GeeList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_backtrace);
		self->priv->_backtrace = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_error_context_properties[GEARY_ERROR_CONTEXT_BACKTRACE_PROPERTY]);
	}
}

GearyErrorContext*
geary_error_context_construct (GType object_type,
                               GError* thrown)
{
	GearyErrorContext * self = NULL;
	unw_context_t trace = {0};
	unw_cursor_t cursor = {0};
	unw_context_t _tmp0_;
	g_return_val_if_fail (thrown != NULL, NULL);
	self = (GearyErrorContext*) geary_base_object_construct (object_type);
	geary_error_context_set_thrown (self, thrown);
	unw_getcontext (&trace);
	_tmp0_ = trace;
	unw_init_local (&cursor, &_tmp0_);
	while (TRUE) {
		GeeList* _tmp1_;
		unw_cursor_t _tmp2_;
		GearyErrorContextStackFrame* _tmp3_;
		GearyErrorContextStackFrame* _tmp4_;
		if (!(unw_step (&cursor) != 0)) {
			break;
		}
		_tmp1_ = self->priv->_backtrace;
		_tmp2_ = cursor;
		_tmp3_ = geary_error_context_stack_frame_new (&_tmp2_);
		_tmp4_ = _tmp3_;
		gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection), _tmp4_);
		_geary_error_context_stack_frame_unref0 (_tmp4_);
	}
	return self;
}

GearyErrorContext*
geary_error_context_new (GError* thrown)
{
	return geary_error_context_construct (GEARY_TYPE_ERROR_CONTEXT, thrown);
}

/** Returns a string representation of the error type, for debugging. */
static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

gchar*
geary_error_context_format_error_type (GearyErrorContext* self)
{
	gchar* type = NULL;
	GError* _tmp0_;
	gchar* result;
	g_return_val_if_fail (GEARY_IS_ERROR_CONTEXT (self), NULL);
	type = NULL;
	_tmp0_ = self->priv->_thrown;
	if (_tmp0_ != NULL) {
		static const char QUARK_SUFFIX[] = "-quark";
		gchar* ugly_domain = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		GString* nice_domain = NULL;
		GString* _tmp12_;
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_;
		gchar* separator = NULL;
		gchar* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		gchar** _tmp18_;
		gchar** _tmp19_;
		GString* _tmp34_;
		const gchar* _tmp35_;
		GError* _tmp36_;
		gchar* _tmp37_;
		_tmp1_ = self->priv->_thrown;
		_tmp2_ = g_quark_to_string (_tmp1_->domain);
		_tmp3_ = g_strdup (_tmp2_);
		ugly_domain = _tmp3_;
		_tmp4_ = ugly_domain;
		if (g_str_has_suffix (_tmp4_, QUARK_SUFFIX)) {
			const gchar* _tmp5_;
			const gchar* _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			gchar* _tmp11_;
			_tmp5_ = ugly_domain;
			_tmp6_ = ugly_domain;
			_tmp7_ = strlen (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = strlen (QUARK_SUFFIX);
			_tmp10_ = _tmp9_;
			_tmp11_ = string_substring (_tmp5_, (glong) 0, (glong) (_tmp8_ - _tmp10_));
			_g_free0 (ugly_domain);
			ugly_domain = _tmp11_;
		}
		_tmp12_ = g_string_new ("");
		nice_domain = _tmp12_;
		_tmp14_ = ugly_domain;
		if (string_index_of (_tmp14_, "_", 0) != -1) {
			_tmp13_ = "_";
		} else {
			_tmp13_ = "-";
		}
		_tmp15_ = g_strdup (_tmp13_);
		separator = _tmp15_;
		_tmp16_ = ugly_domain;
		_tmp17_ = separator;
		_tmp19_ = _tmp18_ = g_strsplit (_tmp16_, _tmp17_, 0);
		{
			gchar** part_collection = NULL;
			gint part_collection_length1 = 0;
			gint _part_collection_size_ = 0;
			gint part_it = 0;
			part_collection = _tmp19_;
			part_collection_length1 = _vala_array_length (_tmp18_);
			for (part_it = 0; part_it < part_collection_length1; part_it = part_it + 1) {
				gchar* _tmp20_;
				gchar* part = NULL;
				_tmp20_ = g_strdup (part_collection[part_it]);
				part = _tmp20_;
				{
					const gchar* _tmp21_;
					gint _tmp22_;
					gint _tmp23_;
					_tmp21_ = part;
					_tmp22_ = strlen (_tmp21_);
					_tmp23_ = _tmp22_;
					if (_tmp23_ > 0) {
						const gchar* _tmp24_;
						_tmp24_ = part;
						if (g_strcmp0 (_tmp24_, "io") == 0) {
							GString* _tmp25_;
							_tmp25_ = nice_domain;
							g_string_append (_tmp25_, "IO");
						} else {
							GString* _tmp26_;
							const gchar* _tmp27_;
							gchar* _tmp28_;
							gchar* _tmp29_;
							GString* _tmp30_;
							const gchar* _tmp31_;
							gchar* _tmp32_;
							gchar* _tmp33_;
							_tmp26_ = nice_domain;
							_tmp27_ = part;
							_tmp28_ = g_utf8_strup (_tmp27_, (gssize) 1);
							_tmp29_ = _tmp28_;
							g_string_append (_tmp26_, _tmp29_);
							_g_free0 (_tmp29_);
							_tmp30_ = nice_domain;
							_tmp31_ = part;
							_tmp32_ = string_substring (_tmp31_, (glong) 1, (glong) -1);
							_tmp33_ = _tmp32_;
							g_string_append (_tmp30_, _tmp33_);
							_g_free0 (_tmp33_);
						}
					}
					_g_free0 (part);
				}
			}
			part_collection = (_vala_array_free (part_collection, part_collection_length1, (GDestroyNotify) g_free), NULL);
		}
		_tmp34_ = nice_domain;
		_tmp35_ = _tmp34_->str;
		_tmp36_ = self->priv->_thrown;
		_tmp37_ = g_strdup_printf ("%s %i", _tmp35_, _tmp36_->code);
		_g_free0 (type);
		type = _tmp37_;
		_g_free0 (separator);
		_g_string_free0 (nice_domain);
		_g_free0 (ugly_domain);
	}
	result = type;
	return result;
}

/** Returns a string representation of the complete error, for debugging. */
gchar*
geary_error_context_format_full_error (GearyErrorContext* self)
{
	gchar* _error_ = NULL;
	GError* _tmp0_;
	gchar* result;
	g_return_val_if_fail (GEARY_IS_ERROR_CONTEXT (self), NULL);
	_error_ = NULL;
	_tmp0_ = self->priv->_thrown;
	if (_tmp0_ != NULL) {
		gchar* _tmp1_ = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp12_;
		_tmp2_ = self->priv->_thrown;
		_tmp3_ = _tmp2_->message;
		if (geary_string_is_empty (_tmp3_)) {
			gchar* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			_tmp4_ = geary_error_context_format_error_type (self);
			_tmp5_ = _tmp4_;
			_tmp6_ = g_strdup_printf ("%s: no message specified", _tmp5_);
			_g_free0 (_tmp1_);
			_tmp1_ = _tmp6_;
			_g_free0 (_tmp5_);
		} else {
			gchar* _tmp7_;
			gchar* _tmp8_;
			GError* _tmp9_;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp7_ = geary_error_context_format_error_type (self);
			_tmp8_ = _tmp7_;
			_tmp9_ = self->priv->_thrown;
			_tmp10_ = _tmp9_->message;
			_tmp11_ = g_strdup_printf ("%s: \"%s\"", _tmp8_, _tmp10_);
			_g_free0 (_tmp1_);
			_tmp1_ = _tmp11_;
			_g_free0 (_tmp8_);
		}
		_tmp12_ = g_strdup (_tmp1_);
		_g_free0 (_error_);
		_error_ = _tmp12_;
		_g_free0 (_tmp1_);
	}
	result = _error_;
	return result;
}

GearyErrorContextStackFrame*
geary_error_context_stack_frame_construct (GType object_type,
                                           unw_cursor_t* frame)
{
	GearyErrorContextStackFrame* self = NULL;
	guint8 proc_name[256] = {0};
	gint ret = 0;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (frame != NULL, NULL);
	self = (GearyErrorContextStackFrame*) g_type_create_instance (object_type);
	ret = -unw_get_proc_name (frame, proc_name, (gint) 256, NULL);
	if (ret == ((gint) UNW_ESUCCESS)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = ret == ((gint) UNW_ENOMEM);
	}
	if (_tmp0_) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ((const gchar*) proc_name);
		_g_free0 (self->name);
		self->name = _tmp1_;
	}
	return self;
}

GearyErrorContextStackFrame*
geary_error_context_stack_frame_new (unw_cursor_t* frame)
{
	return geary_error_context_stack_frame_construct (GEARY_ERROR_CONTEXT_TYPE_STACK_FRAME, frame);
}

gchar*
geary_error_context_stack_frame_to_string (GearyErrorContextStackFrame* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (GEARY_ERROR_CONTEXT_IS_STACK_FRAME (self), NULL);
	_tmp0_ = self->name;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
geary_error_context_value_stack_frame_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
geary_error_context_value_stack_frame_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		geary_error_context_stack_frame_unref (value->data[0].v_pointer);
	}
}

static void
geary_error_context_value_stack_frame_copy_value (const GValue* src_value,
                                                  GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = geary_error_context_stack_frame_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
geary_error_context_value_stack_frame_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
geary_error_context_value_stack_frame_collect_value (GValue* value,
                                                     guint n_collect_values,
                                                     GTypeCValue* collect_values,
                                                     guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GearyErrorContextStackFrame * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = geary_error_context_stack_frame_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
geary_error_context_value_stack_frame_lcopy_value (const GValue* value,
                                                   guint n_collect_values,
                                                   GTypeCValue* collect_values,
                                                   guint collect_flags)
{
	GearyErrorContextStackFrame ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = geary_error_context_stack_frame_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
geary_error_context_param_spec_stack_frame (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags)
{
	GearyErrorContextParamSpecStackFrame* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GEARY_ERROR_CONTEXT_TYPE_STACK_FRAME), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
geary_error_context_value_get_stack_frame (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEARY_ERROR_CONTEXT_TYPE_STACK_FRAME), NULL);
	return value->data[0].v_pointer;
}

void
geary_error_context_value_set_stack_frame (GValue* value,
                                           gpointer v_object)
{
	GearyErrorContextStackFrame * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEARY_ERROR_CONTEXT_TYPE_STACK_FRAME));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GEARY_ERROR_CONTEXT_TYPE_STACK_FRAME));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		geary_error_context_stack_frame_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		geary_error_context_stack_frame_unref (old);
	}
}

void
geary_error_context_value_take_stack_frame (GValue* value,
                                            gpointer v_object)
{
	GearyErrorContextStackFrame * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEARY_ERROR_CONTEXT_TYPE_STACK_FRAME));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GEARY_ERROR_CONTEXT_TYPE_STACK_FRAME));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		geary_error_context_stack_frame_unref (old);
	}
}

static void
geary_error_context_stack_frame_class_init (GearyErrorContextStackFrameClass * klass,
                                            gpointer klass_data)
{
	geary_error_context_stack_frame_parent_class = g_type_class_peek_parent (klass);
	((GearyErrorContextStackFrameClass *) klass)->finalize = geary_error_context_stack_frame_finalize;
}

static void
geary_error_context_stack_frame_instance_init (GearyErrorContextStackFrame * self,
                                               gpointer klass)
{
	gchar* _tmp0_;
	_tmp0_ = g_strdup ("unknown");
	self->name = _tmp0_;
	self->ref_count = 1;
}

static void
geary_error_context_stack_frame_finalize (GearyErrorContextStackFrame * obj)
{
	GearyErrorContextStackFrame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_ERROR_CONTEXT_TYPE_STACK_FRAME, GearyErrorContextStackFrame);
	g_signal_handlers_destroy (self);
	_g_free0 (self->name);
}

/** Represents an individual stack frame in a call back-trace. */
 G_GNUC_NO_INLINE static GType
geary_error_context_stack_frame_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { geary_error_context_value_stack_frame_init, geary_error_context_value_stack_frame_free_value, geary_error_context_value_stack_frame_copy_value, geary_error_context_value_stack_frame_peek_pointer, "p", geary_error_context_value_stack_frame_collect_value, "p", geary_error_context_value_stack_frame_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GearyErrorContextStackFrameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_error_context_stack_frame_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyErrorContextStackFrame), 0, (GInstanceInitFunc) geary_error_context_stack_frame_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType geary_error_context_stack_frame_type_id;
	geary_error_context_stack_frame_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GearyErrorContextStackFrame", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return geary_error_context_stack_frame_type_id;
}

GType
geary_error_context_stack_frame_get_type (void)
{
	static gsize geary_error_context_stack_frame_type_id__once = 0;
	if (g_once_init_enter (&geary_error_context_stack_frame_type_id__once)) {
		GType geary_error_context_stack_frame_type_id;
		geary_error_context_stack_frame_type_id = geary_error_context_stack_frame_get_type_once ();
		g_once_init_leave (&geary_error_context_stack_frame_type_id__once, geary_error_context_stack_frame_type_id);
	}
	return geary_error_context_stack_frame_type_id__once;
}

gpointer
geary_error_context_stack_frame_ref (gpointer instance)
{
	GearyErrorContextStackFrame * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
geary_error_context_stack_frame_unref (gpointer instance)
{
	GearyErrorContextStackFrame * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GEARY_ERROR_CONTEXT_STACK_FRAME_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
geary_error_context_class_init (GearyErrorContextClass * klass,
                                gpointer klass_data)
{
	geary_error_context_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyErrorContext_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_error_context_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_error_context_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_error_context_finalize;
	/** The error thrown that this context is describing. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_ERROR_CONTEXT_THROWN_PROPERTY, geary_error_context_properties[GEARY_ERROR_CONTEXT_THROWN_PROPERTY] = g_param_spec_boxed ("thrown", "thrown", "thrown", G_TYPE_ERROR, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** A back trace from when the context was constructed. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_ERROR_CONTEXT_BACKTRACE_PROPERTY, geary_error_context_properties[GEARY_ERROR_CONTEXT_BACKTRACE_PROPERTY] = g_param_spec_object ("backtrace", "backtrace", "backtrace", GEE_TYPE_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_error_context_instance_init (GearyErrorContext * self,
                                   gpointer klass)
{
	GeeLinkedList* _tmp0_;
	self->priv = geary_error_context_get_instance_private (self);
	_tmp0_ = gee_linked_list_new (GEARY_ERROR_CONTEXT_TYPE_STACK_FRAME, (GBoxedCopyFunc) geary_error_context_stack_frame_ref, (GDestroyNotify) geary_error_context_stack_frame_unref, NULL, NULL, NULL);
	self->priv->_backtrace = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_LIST, GeeList);
}

static void
geary_error_context_finalize (GObject * obj)
{
	GearyErrorContext * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_TYPE_ERROR_CONTEXT, GearyErrorContext);
	_g_error_free0 (self->priv->_thrown);
	_g_object_unref0 (self->priv->_backtrace);
	G_OBJECT_CLASS (geary_error_context_parent_class)->finalize (obj);
}

/**
 * Provides additional context information for an error when thrown.
 *
 * This class allows the engine to provide additional context
 * information such as stack traces, the cause of this error, or
 * engine state when an error is thrown. A stack trace will be
 * generated for the context when instantiated, so context instances
 * should be constructed as close to when the error was thrown as
 * possible.
 *
 * This works around the GLib error system's lack of extensibility.
 */
 G_GNUC_NO_INLINE static GType
geary_error_context_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyErrorContextClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_error_context_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyErrorContext), 0, (GInstanceInitFunc) geary_error_context_instance_init, NULL };
	GType geary_error_context_type_id;
	geary_error_context_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "GearyErrorContext", &g_define_type_info, 0);
	GearyErrorContext_private_offset = g_type_add_instance_private (geary_error_context_type_id, sizeof (GearyErrorContextPrivate));
	return geary_error_context_type_id;
}

GType
geary_error_context_get_type (void)
{
	static gsize geary_error_context_type_id__once = 0;
	if (g_once_init_enter (&geary_error_context_type_id__once)) {
		GType geary_error_context_type_id;
		geary_error_context_type_id = geary_error_context_get_type_once ();
		g_once_init_leave (&geary_error_context_type_id__once, geary_error_context_type_id);
	}
	return geary_error_context_type_id__once;
}

static void
_vala_geary_error_context_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	GearyErrorContext * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_TYPE_ERROR_CONTEXT, GearyErrorContext);
	switch (property_id) {
		case GEARY_ERROR_CONTEXT_THROWN_PROPERTY:
		g_value_set_pointer (value, geary_error_context_get_thrown (self));
		break;
		case GEARY_ERROR_CONTEXT_BACKTRACE_PROPERTY:
		g_value_set_object (value, geary_error_context_get_backtrace (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_error_context_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	GearyErrorContext * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_TYPE_ERROR_CONTEXT, GearyErrorContext);
	switch (property_id) {
		case GEARY_ERROR_CONTEXT_THROWN_PROPERTY:
		geary_error_context_set_thrown (self, g_value_get_pointer (value));
		break;
		case GEARY_ERROR_CONTEXT_BACKTRACE_PROPERTY:
		geary_error_context_set_backtrace (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

