/* folder-list-account-branch.c generated by valac 0.56.3, the Vala compiler
 * generated from folder-list-account-branch.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */
/* A branch that holds all the folders for a particular account.*/

#include "geary-client-43.0.h"
#include "geary-engine.h"
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>

enum  {
	FOLDER_LIST_ACCOUNT_BRANCH_0_PROPERTY,
	FOLDER_LIST_ACCOUNT_BRANCH_ACCOUNT_PROPERTY,
	FOLDER_LIST_ACCOUNT_BRANCH_USER_FOLDER_GROUP_PROPERTY,
	FOLDER_LIST_ACCOUNT_BRANCH_FOLDER_ENTRIES_PROPERTY,
	FOLDER_LIST_ACCOUNT_BRANCH_NUM_PROPERTIES
};
static GParamSpec* folder_list_account_branch_properties[FOLDER_LIST_ACCOUNT_BRANCH_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block100Data Block100Data;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _FolderListAccountBranchPrivate {
	GearyAccount* _account;
	FolderListSpecialGrouping* _user_folder_group;
	GeeHashMap* _folder_entries;
	gchar* display_name;
};

struct _Block100Data {
	int _ref_count_;
	FolderListAccountBranch* self;
	FolderListFolderEntry* folder_entry;
};

static gint FolderListAccountBranch_private_offset;
static gpointer folder_list_account_branch_parent_class = NULL;

static void folder_list_account_branch_on_information_changed (FolderListAccountBranch* self);
static void _folder_list_account_branch_on_information_changed_geary_account_information_changed (GearyAccountInformation* _sender,
                                                                                           gpointer self);
static void folder_list_account_branch_on_entry_removed (FolderListAccountBranch* self,
                                                  SidebarEntry* entry);
static void _folder_list_account_branch_on_entry_removed_sidebar_branch_entry_removed (SidebarBranch* _sender,
                                                                                SidebarEntry* entry,
                                                                                gpointer self);
static void folder_list_account_branch_check_user_folders (FolderListAccountBranch* self,
                                                    SidebarEntry* entry);
static void _folder_list_account_branch_check_user_folders_sidebar_branch_entry_moved (SidebarBranch* _sender,
                                                                                SidebarEntry* entry,
                                                                                gpointer self);
static void folder_list_account_branch_set_account (FolderListAccountBranch* self,
                                             GearyAccount* value);
static void folder_list_account_branch_set_user_folder_group (FolderListAccountBranch* self,
                                                       FolderListSpecialGrouping* value);
static void folder_list_account_branch_set_folder_entries (FolderListAccountBranch* self,
                                                    GeeHashMap* value);
static gint folder_list_account_branch_normal_folder_comparator (SidebarEntry* a,
                                                          SidebarEntry* b);
static gint _folder_list_account_branch_normal_folder_comparator_gcompare_func (gconstpointer a,
                                                                         gconstpointer b);
static gint folder_list_account_branch_special_folder_comparator (SidebarEntry* a,
                                                           SidebarEntry* b);
static gint _folder_list_account_branch_special_folder_comparator_gcompare_func (gconstpointer a,
                                                                          gconstpointer b);
static gint folder_list_account_branch_special_grouping_comparator (SidebarEntry* a,
                                                             SidebarEntry* b);
static Block100Data* block100_data_ref (Block100Data* _data100_);
static void block100_data_unref (void * _userdata_);
static gboolean ___lambda159_ (Block100Data* _data100_,
                        SidebarEntry* e);
static gboolean ____lambda159__locator (gconstpointer item,
                                 gpointer self);
static void folder_list_account_branch_finalize (GObject * obj);
static GType folder_list_account_branch_get_type_once (void);
static void _vala_folder_list_account_branch_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec);
static void _vala_folder_list_account_branch_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec);

static const GearyFolderSpecialUse FOLDER_LIST_ACCOUNT_BRANCH_SPECIAL_USE_ORDERING[13] = {GEARY_FOLDER_SPECIAL_USE_INBOX, GEARY_FOLDER_SPECIAL_USE_SEARCH, GEARY_FOLDER_SPECIAL_USE_FLAGGED, GEARY_FOLDER_SPECIAL_USE_IMPORTANT, GEARY_FOLDER_SPECIAL_USE_DRAFTS, GEARY_FOLDER_SPECIAL_USE_CUSTOM, GEARY_FOLDER_SPECIAL_USE_NONE, GEARY_FOLDER_SPECIAL_USE_OUTBOX, GEARY_FOLDER_SPECIAL_USE_SENT, GEARY_FOLDER_SPECIAL_USE_ARCHIVE, GEARY_FOLDER_SPECIAL_USE_ALL_MAIL, GEARY_FOLDER_SPECIAL_USE_TRASH, GEARY_FOLDER_SPECIAL_USE_JUNK};

static inline gpointer
folder_list_account_branch_get_instance_private (FolderListAccountBranch* self)
{
	return G_STRUCT_MEMBER_P (self, FolderListAccountBranch_private_offset);
}

static void
_folder_list_account_branch_on_information_changed_geary_account_information_changed (GearyAccountInformation* _sender,
                                                                                      gpointer self)
{
	folder_list_account_branch_on_information_changed ((FolderListAccountBranch*) self);
}

static void
_folder_list_account_branch_on_entry_removed_sidebar_branch_entry_removed (SidebarBranch* _sender,
                                                                           SidebarEntry* entry,
                                                                           gpointer self)
{
	folder_list_account_branch_on_entry_removed ((FolderListAccountBranch*) self, entry);
}

static void
_folder_list_account_branch_check_user_folders_sidebar_branch_entry_moved (SidebarBranch* _sender,
                                                                           SidebarEntry* entry,
                                                                           gpointer self)
{
	folder_list_account_branch_check_user_folders ((FolderListAccountBranch*) self, entry);
}

GearyAccount*
folder_list_account_branch_get_account (FolderListAccountBranch* self)
{
	GearyAccount* result;
	GearyAccount* _tmp0_;
	g_return_val_if_fail (FOLDER_LIST_IS_ACCOUNT_BRANCH (self), NULL);
	_tmp0_ = self->priv->_account;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
folder_list_account_branch_set_account (FolderListAccountBranch* self,
                                        GearyAccount* value)
{
	GearyAccount* old_value;
	g_return_if_fail (FOLDER_LIST_IS_ACCOUNT_BRANCH (self));
	old_value = folder_list_account_branch_get_account (self);
	if (old_value != value) {
		GearyAccount* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_account);
		self->priv->_account = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, folder_list_account_branch_properties[FOLDER_LIST_ACCOUNT_BRANCH_ACCOUNT_PROPERTY]);
	}
}

FolderListSpecialGrouping*
folder_list_account_branch_get_user_folder_group (FolderListAccountBranch* self)
{
	FolderListSpecialGrouping* result;
	FolderListSpecialGrouping* _tmp0_;
	g_return_val_if_fail (FOLDER_LIST_IS_ACCOUNT_BRANCH (self), NULL);
	_tmp0_ = self->priv->_user_folder_group;
	result = _tmp0_;
	return result;
}

static void
folder_list_account_branch_set_user_folder_group (FolderListAccountBranch* self,
                                                  FolderListSpecialGrouping* value)
{
	FolderListSpecialGrouping* old_value;
	g_return_if_fail (FOLDER_LIST_IS_ACCOUNT_BRANCH (self));
	old_value = folder_list_account_branch_get_user_folder_group (self);
	if (old_value != value) {
		FolderListSpecialGrouping* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_user_folder_group);
		self->priv->_user_folder_group = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, folder_list_account_branch_properties[FOLDER_LIST_ACCOUNT_BRANCH_USER_FOLDER_GROUP_PROPERTY]);
	}
}

GeeHashMap*
folder_list_account_branch_get_folder_entries (FolderListAccountBranch* self)
{
	GeeHashMap* result;
	GeeHashMap* _tmp0_;
	g_return_val_if_fail (FOLDER_LIST_IS_ACCOUNT_BRANCH (self), NULL);
	_tmp0_ = self->priv->_folder_entries;
	result = _tmp0_;
	return result;
}

static void
folder_list_account_branch_set_folder_entries (FolderListAccountBranch* self,
                                               GeeHashMap* value)
{
	GeeHashMap* old_value;
	g_return_if_fail (FOLDER_LIST_IS_ACCOUNT_BRANCH (self));
	old_value = folder_list_account_branch_get_folder_entries (self);
	if (old_value != value) {
		GeeHashMap* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_folder_entries);
		self->priv->_folder_entries = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, folder_list_account_branch_properties[FOLDER_LIST_ACCOUNT_BRANCH_FOLDER_ENTRIES_PROPERTY]);
	}
}

static gint
_folder_list_account_branch_normal_folder_comparator_gcompare_func (gconstpointer a,
                                                                    gconstpointer b)
{
	gint result;
	result = folder_list_account_branch_normal_folder_comparator ((SidebarEntry*) a, (SidebarEntry*) b);
	return result;
}

static gint
_folder_list_account_branch_special_folder_comparator_gcompare_func (gconstpointer a,
                                                                     gconstpointer b)
{
	gint result;
	result = folder_list_account_branch_special_folder_comparator ((SidebarEntry*) a, (SidebarEntry*) b);
	return result;
}

FolderListAccountBranch*
folder_list_account_branch_construct (GType object_type,
                                      GearyAccount* account)
{
	FolderListAccountBranch * self = NULL;
	GearyAccountInformation* _tmp0_;
	GearyAccountInformation* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	SidebarHeader* _tmp4_;
	SidebarHeader* _tmp5_;
	gchar* name = NULL;
	gchar* icon_name = NULL;
	GearyAccountInformation* _tmp6_;
	GearyAccountInformation* _tmp7_;
	GearyServiceProvider _tmp8_;
	GearyServiceProvider _tmp9_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	FolderListSpecialGrouping* _tmp16_;
	FolderListSpecialGrouping* _tmp17_;
	GeeHashMap* _tmp18_;
	GeeHashMap* _tmp19_;
	GearyAccountInformation* _tmp20_;
	GearyAccountInformation* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	GearyAccountInformation* _tmp25_;
	GearyAccountInformation* _tmp26_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (account, GEARY_TYPE_ACCOUNT), NULL);
	_tmp0_ = geary_account_get_information (account);
	_tmp1_ = _tmp0_;
	_tmp2_ = geary_account_information_get_display_name (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = sidebar_header_new (_tmp3_, TRUE);
	_tmp5_ = _tmp4_;
	self = (FolderListAccountBranch*) sidebar_branch_construct (object_type, G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, SIDEBAR_TYPE_ENTRY, SidebarEntry), SIDEBAR_BRANCH_OPTIONS_STARTUP_OPEN_GROUPING | SIDEBAR_BRANCH_OPTIONS_STARTUP_EXPAND_TO_FIRST_CHILD, _folder_list_account_branch_normal_folder_comparator_gcompare_func, _folder_list_account_branch_special_folder_comparator_gcompare_func);
	_g_object_unref0 (_tmp5_);
	folder_list_account_branch_set_account (self, account);
	_tmp6_ = geary_account_get_information (account);
	_tmp7_ = _tmp6_;
	_tmp8_ = geary_account_information_get_service_provider (_tmp7_);
	_tmp9_ = _tmp8_;
	switch (_tmp9_) {
		case GEARY_SERVICE_PROVIDER_GMAIL:
		{
			gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp10_ = g_strdup (_ ("Labels"));
			_g_free0 (name);
			name = _tmp10_;
			_tmp11_ = g_strdup ("tag-symbolic");
			_g_free0 (icon_name);
			icon_name = _tmp11_;
			break;
		}
		default:
		{
			gchar* _tmp12_;
			gchar* _tmp13_;
			_tmp12_ = g_strdup (_ ("Folders"));
			_g_free0 (name);
			name = _tmp12_;
			_tmp13_ = g_strdup ("folder-symbolic");
			_g_free0 (icon_name);
			icon_name = _tmp13_;
			break;
		}
	}
	_tmp14_ = name;
	_tmp15_ = icon_name;
	_tmp16_ = folder_list_special_grouping_new (2, _tmp14_, _tmp15_, NULL);
	_tmp17_ = _tmp16_;
	folder_list_account_branch_set_user_folder_group (self, _tmp17_);
	_g_object_unref0 (_tmp17_);
	_tmp18_ = gee_hash_map_new (GEARY_TYPE_FOLDER_PATH, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, FOLDER_LIST_TYPE_FOLDER_ENTRY, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_tmp19_ = _tmp18_;
	folder_list_account_branch_set_folder_entries (self, _tmp19_);
	_g_object_unref0 (_tmp19_);
	_tmp20_ = geary_account_get_information (account);
	_tmp21_ = _tmp20_;
	_tmp22_ = geary_account_information_get_display_name (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = g_strdup (_tmp23_);
	_g_free0 (self->priv->display_name);
	self->priv->display_name = _tmp24_;
	_tmp25_ = geary_account_get_information (account);
	_tmp26_ = _tmp25_;
	g_signal_connect_object (_tmp26_, "changed", (GCallback) _folder_list_account_branch_on_information_changed_geary_account_information_changed, self, 0);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, SIDEBAR_TYPE_BRANCH, SidebarBranch), "entry-removed", (GCallback) _folder_list_account_branch_on_entry_removed_sidebar_branch_entry_removed, self, 0);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, SIDEBAR_TYPE_BRANCH, SidebarBranch), "entry-moved", (GCallback) _folder_list_account_branch_check_user_folders_sidebar_branch_entry_moved, self, 0);
	_g_free0 (icon_name);
	_g_free0 (name);
	return self;
}

FolderListAccountBranch*
folder_list_account_branch_new (GearyAccount* account)
{
	return folder_list_account_branch_construct (FOLDER_LIST_TYPE_ACCOUNT_BRANCH, account);
}

static void
folder_list_account_branch_on_information_changed (FolderListAccountBranch* self)
{
	const gchar* _tmp0_;
	GearyAccount* _tmp1_;
	GearyAccountInformation* _tmp2_;
	GearyAccountInformation* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	g_return_if_fail (FOLDER_LIST_IS_ACCOUNT_BRANCH (self));
	_tmp0_ = self->priv->display_name;
	_tmp1_ = self->priv->_account;
	_tmp2_ = geary_account_get_information (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = geary_account_information_get_display_name (_tmp3_);
	_tmp5_ = _tmp4_;
	if (g_strcmp0 (_tmp0_, _tmp5_) != 0) {
		GearyAccount* _tmp6_;
		GearyAccountInformation* _tmp7_;
		GearyAccountInformation* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		SidebarEntry* _tmp12_;
		SidebarGrouping* _tmp13_;
		const gchar* _tmp14_;
		_tmp6_ = self->priv->_account;
		_tmp7_ = geary_account_get_information (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = geary_account_information_get_display_name (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strdup (_tmp10_);
		_g_free0 (self->priv->display_name);
		self->priv->display_name = _tmp11_;
		_tmp12_ = sidebar_branch_get_root (G_TYPE_CHECK_INSTANCE_CAST (self, SIDEBAR_TYPE_BRANCH, SidebarBranch));
		_tmp13_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, SIDEBAR_TYPE_GROUPING, SidebarGrouping);
		_tmp14_ = self->priv->display_name;
		sidebar_renameable_entry_rename (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, SIDEBAR_TYPE_RENAMEABLE_ENTRY, SidebarRenameableEntry), _tmp14_);
		_g_object_unref0 (_tmp13_);
	}
}

static gint
folder_list_account_branch_special_grouping_comparator (SidebarEntry* a,
                                                        SidebarEntry* b)
{
	FolderListSpecialGrouping* grouping_a = NULL;
	FolderListSpecialGrouping* _tmp0_;
	FolderListSpecialGrouping* grouping_b = NULL;
	FolderListSpecialGrouping* _tmp1_;
	gboolean _tmp2_ = FALSE;
	FolderListSpecialGrouping* _tmp3_;
	gint _tmp5_ = 0;
	FolderListSpecialGrouping* _tmp6_;
	gint position_a = 0;
	gint _tmp10_ = 0;
	FolderListSpecialGrouping* _tmp11_;
	gint position_b = 0;
	gint result;
	g_return_val_if_fail (SIDEBAR_IS_ENTRY (a), 0);
	g_return_val_if_fail (SIDEBAR_IS_ENTRY (b), 0);
	_tmp0_ = _g_object_ref0 (FOLDER_LIST_IS_SPECIAL_GROUPING (a) ? ((FolderListSpecialGrouping*) a) : NULL);
	grouping_a = _tmp0_;
	_tmp1_ = _g_object_ref0 (FOLDER_LIST_IS_SPECIAL_GROUPING (b) ? ((FolderListSpecialGrouping*) b) : NULL);
	grouping_b = _tmp1_;
	_tmp3_ = grouping_a;
	if (_tmp3_ != NULL) {
		_tmp2_ = TRUE;
	} else {
		FolderListSpecialGrouping* _tmp4_;
		_tmp4_ = grouping_b;
		_tmp2_ = _tmp4_ != NULL;
	}
	_vala_assert (_tmp2_, "grouping_a != null || grouping_b != null");
	_tmp6_ = grouping_a;
	if (_tmp6_ != NULL) {
		FolderListSpecialGrouping* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		_tmp7_ = grouping_a;
		_tmp8_ = folder_list_special_grouping_get_position (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp5_ = _tmp9_;
	} else {
		_tmp5_ = 0;
	}
	position_a = _tmp5_;
	_tmp11_ = grouping_b;
	if (_tmp11_ != NULL) {
		FolderListSpecialGrouping* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		_tmp12_ = grouping_b;
		_tmp13_ = folder_list_special_grouping_get_position (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp10_ = _tmp14_;
	} else {
		_tmp10_ = 0;
	}
	position_b = _tmp10_;
	result = position_a - position_b;
	_g_object_unref0 (grouping_b);
	_g_object_unref0 (grouping_a);
	return result;
}

static gint
folder_list_account_branch_special_folder_comparator (SidebarEntry* a,
                                                      SidebarEntry* b)
{
	gboolean _tmp0_ = FALSE;
	FolderListFolderEntry* entry_a = NULL;
	FolderListFolderEntry* _tmp1_;
	FolderListFolderEntry* entry_b = NULL;
	FolderListFolderEntry* _tmp2_;
	GearyFolderSpecialUse type_a = 0;
	FolderListFolderEntry* _tmp3_;
	GearyFolder* _tmp4_;
	GearyFolder* _tmp5_;
	GearyFolderSpecialUse _tmp6_;
	GearyFolderSpecialUse _tmp7_;
	GearyFolderSpecialUse type_b = 0;
	FolderListFolderEntry* _tmp8_;
	GearyFolder* _tmp9_;
	GearyFolder* _tmp10_;
	GearyFolderSpecialUse _tmp11_;
	GearyFolderSpecialUse _tmp12_;
	gint ordering_a = 0;
	gint ordering_b = 0;
	gint result;
	g_return_val_if_fail (SIDEBAR_IS_ENTRY (a), 0);
	g_return_val_if_fail (SIDEBAR_IS_ENTRY (b), 0);
	if (SIDEBAR_IS_GROUPING (a)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = SIDEBAR_IS_GROUPING (b);
	}
	if (_tmp0_) {
		result = folder_list_account_branch_special_grouping_comparator (a, b);
		return result;
	}
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (a, FOLDER_LIST_TYPE_FOLDER_ENTRY, FolderListFolderEntry));
	entry_a = _tmp1_;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (b, FOLDER_LIST_TYPE_FOLDER_ENTRY, FolderListFolderEntry));
	entry_b = _tmp2_;
	_tmp3_ = entry_a;
	_tmp4_ = folder_list_abstract_folder_entry_get_folder (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, FOLDER_LIST_TYPE_ABSTRACT_FOLDER_ENTRY, FolderListAbstractFolderEntry));
	_tmp5_ = _tmp4_;
	_tmp6_ = geary_folder_get_used_as (_tmp5_);
	_tmp7_ = _tmp6_;
	type_a = _tmp7_;
	_tmp8_ = entry_b;
	_tmp9_ = folder_list_abstract_folder_entry_get_folder (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, FOLDER_LIST_TYPE_ABSTRACT_FOLDER_ENTRY, FolderListAbstractFolderEntry));
	_tmp10_ = _tmp9_;
	_tmp11_ = geary_folder_get_used_as (_tmp10_);
	_tmp12_ = _tmp11_;
	type_b = _tmp12_;
	if (type_a == type_b) {
		result = 0;
		_g_object_unref0 (entry_b);
		_g_object_unref0 (entry_a);
		return result;
	}
	if (type_a == GEARY_FOLDER_SPECIAL_USE_INBOX) {
		result = -1;
		_g_object_unref0 (entry_b);
		_g_object_unref0 (entry_a);
		return result;
	}
	if (type_b == GEARY_FOLDER_SPECIAL_USE_INBOX) {
		result = 1;
		_g_object_unref0 (entry_b);
		_g_object_unref0 (entry_a);
		return result;
	}
	ordering_a = 0;
	{
		gboolean _tmp13_ = FALSE;
		_tmp13_ = TRUE;
		while (TRUE) {
			GearyFolderSpecialUse _tmp15_;
			if (!_tmp13_) {
				gint _tmp14_;
				_tmp14_ = ordering_a;
				ordering_a = _tmp14_ + 1;
			}
			_tmp13_ = FALSE;
			if (!(ordering_a < G_N_ELEMENTS (FOLDER_LIST_ACCOUNT_BRANCH_SPECIAL_USE_ORDERING))) {
				break;
			}
			_tmp15_ = FOLDER_LIST_ACCOUNT_BRANCH_SPECIAL_USE_ORDERING[ordering_a];
			if (type_a == _tmp15_) {
				break;
			}
		}
	}
	ordering_b = 0;
	{
		gboolean _tmp16_ = FALSE;
		_tmp16_ = TRUE;
		while (TRUE) {
			GearyFolderSpecialUse _tmp18_;
			if (!_tmp16_) {
				gint _tmp17_;
				_tmp17_ = ordering_b;
				ordering_b = _tmp17_ + 1;
			}
			_tmp16_ = FALSE;
			if (!(ordering_b < G_N_ELEMENTS (FOLDER_LIST_ACCOUNT_BRANCH_SPECIAL_USE_ORDERING))) {
				break;
			}
			_tmp18_ = FOLDER_LIST_ACCOUNT_BRANCH_SPECIAL_USE_ORDERING[ordering_b];
			if (type_b == _tmp18_) {
				break;
			}
		}
	}
	if (ordering_a == ordering_b) {
		result = folder_list_account_branch_normal_folder_comparator (a, b);
		_g_object_unref0 (entry_b);
		_g_object_unref0 (entry_a);
		return result;
	}
	result = ordering_a - ordering_b;
	_g_object_unref0 (entry_b);
	_g_object_unref0 (entry_a);
	return result;
}

static gint
folder_list_account_branch_normal_folder_comparator (SidebarEntry* a,
                                                     SidebarEntry* b)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gint _tmp4_;
	gint result;
	g_return_val_if_fail (SIDEBAR_IS_ENTRY (a), 0);
	g_return_val_if_fail (SIDEBAR_IS_ENTRY (b), 0);
	_tmp0_ = sidebar_entry_get_sidebar_name (a);
	_tmp1_ = _tmp0_;
	_tmp2_ = sidebar_entry_get_sidebar_name (b);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_utf8_collate (_tmp1_, _tmp3_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	result = _tmp4_;
	return result;
}

FolderListFolderEntry*
folder_list_account_branch_get_entry_for_path (FolderListAccountBranch* self,
                                               GearyFolderPath* folder_path)
{
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	FolderListFolderEntry* result;
	g_return_val_if_fail (FOLDER_LIST_IS_ACCOUNT_BRANCH (self), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (folder_path, GEARY_TYPE_FOLDER_PATH), NULL);
	_tmp0_ = self->priv->_folder_entries;
	_tmp1_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), folder_path);
	result = (FolderListFolderEntry*) _tmp1_;
	return result;
}

static Block100Data*
block100_data_ref (Block100Data* _data100_)
{
	g_atomic_int_inc (&_data100_->_ref_count_);
	return _data100_;
}

static void
block100_data_unref (void * _userdata_)
{
	Block100Data* _data100_;
	_data100_ = (Block100Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data100_->_ref_count_)) {
		FolderListAccountBranch* self;
		self = _data100_->self;
		_g_object_unref0 (_data100_->folder_entry);
		_g_object_unref0 (self);
		g_slice_free (Block100Data, _data100_);
	}
}

static gboolean
___lambda159_ (Block100Data* _data100_,
               SidebarEntry* e)
{
	FolderListAccountBranch* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	FolderListFolderEntry* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	gboolean result;
	self = _data100_->self;
	g_return_val_if_fail (SIDEBAR_IS_ENTRY (e), FALSE);
	_tmp0_ = sidebar_entry_get_sidebar_name (e);
	_tmp1_ = _tmp0_;
	_tmp2_ = _data100_->folder_entry;
	_tmp3_ = folder_list_abstract_folder_entry_get_sidebar_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, FOLDER_LIST_TYPE_ABSTRACT_FOLDER_ENTRY, FolderListAbstractFolderEntry));
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strcmp0 (_tmp1_, _tmp4_) == 0;
	_g_free0 (_tmp4_);
	_g_free0 (_tmp1_);
	result = _tmp5_;
	return result;
}

static gboolean
____lambda159__locator (gconstpointer item,
                        gpointer self)
{
	gboolean result;
	result = ___lambda159_ (self, (SidebarEntry*) item);
	return result;
}

void
folder_list_account_branch_add_folder (FolderListAccountBranch* self,
                                       ApplicationFolderContext* context)
{
	Block100Data* _data100_;
	SidebarEntry* graft_point = NULL;
	FolderListFolderEntry* _tmp0_;
	GearyFolderSpecialUse used_as = 0;
	GearyFolder* _tmp1_;
	GearyFolder* _tmp2_;
	GearyFolderSpecialUse _tmp3_;
	GearyFolderSpecialUse _tmp4_;
	SidebarEntry* _tmp29_;
	SidebarEntry* _tmp33_;
	g_return_if_fail (FOLDER_LIST_IS_ACCOUNT_BRANCH (self));
	g_return_if_fail (APPLICATION_IS_FOLDER_CONTEXT (context));
	_data100_ = g_slice_new0 (Block100Data);
	_data100_->_ref_count_ = 1;
	_data100_->self = g_object_ref (self);
	graft_point = NULL;
	_tmp0_ = folder_list_folder_entry_new (context);
	_data100_->folder_entry = _tmp0_;
	_tmp1_ = application_folder_context_get_folder (context);
	_tmp2_ = _tmp1_;
	_tmp3_ = geary_folder_get_used_as (_tmp2_);
	_tmp4_ = _tmp3_;
	used_as = _tmp4_;
	if (used_as != GEARY_FOLDER_SPECIAL_USE_NONE) {
		SidebarEntry* _tmp5_;
		if (used_as == GEARY_FOLDER_SPECIAL_USE_SEARCH) {
			_g_object_unref0 (graft_point);
			block100_data_unref (_data100_);
			_data100_ = NULL;
			return;
		}
		_tmp5_ = sidebar_branch_get_root (G_TYPE_CHECK_INSTANCE_CAST (self, SIDEBAR_TYPE_BRANCH, SidebarBranch));
		_g_object_unref0 (graft_point);
		graft_point = _tmp5_;
	} else {
		GearyFolder* _tmp6_;
		GearyFolder* _tmp7_;
		GearyFolderPath* _tmp8_;
		GearyFolderPath* _tmp9_;
		gboolean _tmp10_;
		gboolean _tmp11_;
		_tmp6_ = application_folder_context_get_folder (context);
		_tmp7_ = _tmp6_;
		_tmp8_ = geary_folder_get_path (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = geary_folder_path_get_is_top_level (_tmp9_);
		_tmp11_ = _tmp10_;
		if (_tmp11_) {
			FolderListSpecialGrouping* _tmp12_;
			SidebarEntry* _tmp13_;
			FolderListSpecialGrouping* _tmp14_;
			_tmp12_ = self->priv->_user_folder_group;
			_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, SIDEBAR_TYPE_ENTRY, SidebarEntry));
			_g_object_unref0 (graft_point);
			graft_point = _tmp13_;
			_tmp14_ = self->priv->_user_folder_group;
			if (!sidebar_branch_has_entry (G_TYPE_CHECK_INSTANCE_CAST (self, SIDEBAR_TYPE_BRANCH, SidebarBranch), G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, SIDEBAR_TYPE_ENTRY, SidebarEntry))) {
				SidebarEntry* _tmp15_;
				SidebarEntry* _tmp16_;
				FolderListSpecialGrouping* _tmp17_;
				_tmp15_ = sidebar_branch_get_root (G_TYPE_CHECK_INSTANCE_CAST (self, SIDEBAR_TYPE_BRANCH, SidebarBranch));
				_tmp16_ = _tmp15_;
				_tmp17_ = self->priv->_user_folder_group;
				sidebar_branch_graft (G_TYPE_CHECK_INSTANCE_CAST (self, SIDEBAR_TYPE_BRANCH, SidebarBranch), _tmp16_, G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, SIDEBAR_TYPE_ENTRY, SidebarEntry), NULL);
				_g_object_unref0 (_tmp16_);
			}
		} else {
			FolderListFolderEntry* entry = NULL;
			GeeHashMap* _tmp18_;
			GearyFolder* _tmp19_;
			GearyFolder* _tmp20_;
			GearyFolderPath* _tmp21_;
			GearyFolderPath* _tmp22_;
			GearyFolderPath* _tmp23_;
			GearyFolderPath* _tmp24_;
			gpointer _tmp25_;
			FolderListFolderEntry* _tmp26_;
			_tmp18_ = self->priv->_folder_entries;
			_tmp19_ = application_folder_context_get_folder (context);
			_tmp20_ = _tmp19_;
			_tmp21_ = geary_folder_get_path (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = geary_folder_path_get_parent (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp24_);
			entry = (FolderListFolderEntry*) _tmp25_;
			_tmp26_ = entry;
			if (_tmp26_ != NULL) {
				FolderListFolderEntry* _tmp27_;
				SidebarEntry* _tmp28_;
				_tmp27_ = entry;
				_tmp28_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, SIDEBAR_TYPE_ENTRY, SidebarEntry));
				_g_object_unref0 (graft_point);
				graft_point = _tmp28_;
			}
			_g_object_unref0 (entry);
		}
	}
	_tmp29_ = graft_point;
	if (_tmp29_ != NULL) {
		SidebarEntry* twin = NULL;
		SidebarEntry* _tmp30_;
		SidebarEntry* _tmp31_;
		SidebarEntry* _tmp32_;
		_tmp30_ = graft_point;
		_tmp31_ = sidebar_branch_find_first_child (G_TYPE_CHECK_INSTANCE_CAST (self, SIDEBAR_TYPE_BRANCH, SidebarBranch), _tmp30_, ____lambda159__locator, _data100_);
		twin = _tmp31_;
		_tmp32_ = twin;
		if (_tmp32_ != NULL) {
			_g_object_unref0 (graft_point);
			graft_point = NULL;
		}
		_g_object_unref0 (twin);
	}
	_tmp33_ = graft_point;
	if (_tmp33_ != NULL) {
		SidebarEntry* _tmp34_;
		FolderListFolderEntry* _tmp35_;
		GeeHashMap* _tmp36_;
		GearyFolder* _tmp37_;
		GearyFolder* _tmp38_;
		GearyFolderPath* _tmp39_;
		GearyFolderPath* _tmp40_;
		FolderListFolderEntry* _tmp41_;
		_tmp34_ = graft_point;
		_tmp35_ = _data100_->folder_entry;
		sidebar_branch_graft (G_TYPE_CHECK_INSTANCE_CAST (self, SIDEBAR_TYPE_BRANCH, SidebarBranch), _tmp34_, G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, SIDEBAR_TYPE_ENTRY, SidebarEntry), NULL);
		_tmp36_ = self->priv->_folder_entries;
		_tmp37_ = application_folder_context_get_folder (context);
		_tmp38_ = _tmp37_;
		_tmp39_ = geary_folder_get_path (_tmp38_);
		_tmp40_ = _tmp39_;
		_tmp41_ = _data100_->folder_entry;
		gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp40_, _tmp41_);
	} else {
		GearyFolder* _tmp42_;
		GearyFolder* _tmp43_;
		gchar* _tmp44_;
		gchar* _tmp45_;
		GEnumValue* _tmp46_;
		_tmp42_ = application_folder_context_get_folder (context);
		_tmp43_ = _tmp42_;
		_tmp44_ = geary_logging_source_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource));
		_tmp45_ = _tmp44_;
		_tmp46_ = g_enum_get_value (g_type_class_ref (GEARY_FOLDER_TYPE_SPECIAL_USE), used_as);
		g_debug ("folder-list-account-branch.vala:170: Could not add folder %s of type %" \
"s to folder list", _tmp45_, (_tmp46_ != NULL) ? _tmp46_->value_name : NULL);
		_g_free0 (_tmp45_);
	}
	_g_object_unref0 (graft_point);
	block100_data_unref (_data100_);
	_data100_ = NULL;
}

void
folder_list_account_branch_remove_folder (FolderListAccountBranch* self,
                                          GearyFolderPath* path)
{
	SidebarEntry* entry = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	SidebarEntry* _tmp2_;
	SidebarEntry* _tmp5_;
	GeeHashMap* _tmp6_;
	g_return_if_fail (FOLDER_LIST_IS_ACCOUNT_BRANCH (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (path, GEARY_TYPE_FOLDER_PATH));
	_tmp0_ = self->priv->_folder_entries;
	_tmp1_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), path);
	entry = G_TYPE_CHECK_INSTANCE_CAST ((FolderListFolderEntry*) _tmp1_, SIDEBAR_TYPE_ENTRY, SidebarEntry);
	_tmp2_ = entry;
	if (_tmp2_ == NULL) {
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = geary_folder_path_to_string (path);
		_tmp4_ = _tmp3_;
		g_debug ("folder-list-account-branch.vala:181: Could not remove folder %s", _tmp4_);
		_g_free0 (_tmp4_);
		_g_object_unref0 (entry);
		return;
	}
	_tmp5_ = entry;
	sidebar_branch_prune (G_TYPE_CHECK_INSTANCE_CAST (self, SIDEBAR_TYPE_BRANCH, SidebarBranch), _tmp5_);
	_tmp6_ = self->priv->_folder_entries;
	gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), path, NULL);
	_g_object_unref0 (entry);
}

static void
folder_list_account_branch_on_entry_removed (FolderListAccountBranch* self,
                                             SidebarEntry* entry)
{
	FolderListFolderEntry* folder_entry = NULL;
	FolderListFolderEntry* _tmp0_;
	gboolean _tmp1_ = FALSE;
	FolderListFolderEntry* _tmp2_;
	g_return_if_fail (FOLDER_LIST_IS_ACCOUNT_BRANCH (self));
	g_return_if_fail (SIDEBAR_IS_ENTRY (entry));
	_tmp0_ = _g_object_ref0 (FOLDER_LIST_IS_FOLDER_ENTRY (entry) ? ((FolderListFolderEntry*) entry) : NULL);
	folder_entry = _tmp0_;
	_tmp2_ = folder_entry;
	if (_tmp2_ != NULL) {
		GeeHashMap* _tmp3_;
		FolderListFolderEntry* _tmp4_;
		GearyFolder* _tmp5_;
		GearyFolder* _tmp6_;
		GearyFolderPath* _tmp7_;
		GearyFolderPath* _tmp8_;
		_tmp3_ = self->priv->_folder_entries;
		_tmp4_ = folder_entry;
		_tmp5_ = folder_list_abstract_folder_entry_get_folder (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, FOLDER_LIST_TYPE_ABSTRACT_FOLDER_ENTRY, FolderListAbstractFolderEntry));
		_tmp6_ = _tmp5_;
		_tmp7_ = geary_folder_get_path (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp1_ = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp8_);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GeeHashMap* _tmp9_;
		FolderListFolderEntry* _tmp10_;
		GearyFolder* _tmp11_;
		GearyFolder* _tmp12_;
		GearyFolderPath* _tmp13_;
		GearyFolderPath* _tmp14_;
		_tmp9_ = self->priv->_folder_entries;
		_tmp10_ = folder_entry;
		_tmp11_ = folder_list_abstract_folder_entry_get_folder (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, FOLDER_LIST_TYPE_ABSTRACT_FOLDER_ENTRY, FolderListAbstractFolderEntry));
		_tmp12_ = _tmp11_;
		_tmp13_ = geary_folder_get_path (_tmp12_);
		_tmp14_ = _tmp13_;
		gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp14_, NULL);
	}
	folder_list_account_branch_check_user_folders (self, entry);
	_g_object_unref0 (folder_entry);
}

static void
folder_list_account_branch_check_user_folders (FolderListAccountBranch* self,
                                               SidebarEntry* entry)
{
	FolderListSpecialGrouping* _tmp0_;
	g_return_if_fail (FOLDER_LIST_IS_ACCOUNT_BRANCH (self));
	g_return_if_fail (SIDEBAR_IS_ENTRY (entry));
	_tmp0_ = self->priv->_user_folder_group;
	if (entry != G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, SIDEBAR_TYPE_ENTRY, SidebarEntry)) {
		gboolean _tmp1_ = FALSE;
		FolderListSpecialGrouping* _tmp2_;
		_tmp2_ = self->priv->_user_folder_group;
		if (sidebar_branch_has_entry (G_TYPE_CHECK_INSTANCE_CAST (self, SIDEBAR_TYPE_BRANCH, SidebarBranch), G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, SIDEBAR_TYPE_ENTRY, SidebarEntry))) {
			FolderListSpecialGrouping* _tmp3_;
			_tmp3_ = self->priv->_user_folder_group;
			_tmp1_ = sidebar_branch_get_child_count (G_TYPE_CHECK_INSTANCE_CAST (self, SIDEBAR_TYPE_BRANCH, SidebarBranch), G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, SIDEBAR_TYPE_ENTRY, SidebarEntry)) == 0;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			FolderListSpecialGrouping* _tmp4_;
			_tmp4_ = self->priv->_user_folder_group;
			sidebar_branch_prune (G_TYPE_CHECK_INSTANCE_CAST (self, SIDEBAR_TYPE_BRANCH, SidebarBranch), G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, SIDEBAR_TYPE_ENTRY, SidebarEntry));
		}
	}
}

static void
folder_list_account_branch_class_init (FolderListAccountBranchClass * klass,
                                       gpointer klass_data)
{
	folder_list_account_branch_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FolderListAccountBranch_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_folder_list_account_branch_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folder_list_account_branch_set_property;
	G_OBJECT_CLASS (klass)->finalize = folder_list_account_branch_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLDER_LIST_ACCOUNT_BRANCH_ACCOUNT_PROPERTY, folder_list_account_branch_properties[FOLDER_LIST_ACCOUNT_BRANCH_ACCOUNT_PROPERTY] = g_param_spec_object ("account", "account", "account", GEARY_TYPE_ACCOUNT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLDER_LIST_ACCOUNT_BRANCH_USER_FOLDER_GROUP_PROPERTY, folder_list_account_branch_properties[FOLDER_LIST_ACCOUNT_BRANCH_USER_FOLDER_GROUP_PROPERTY] = g_param_spec_object ("user-folder-group", "user-folder-group", "user-folder-group", FOLDER_LIST_TYPE_SPECIAL_GROUPING, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLDER_LIST_ACCOUNT_BRANCH_FOLDER_ENTRIES_PROPERTY, folder_list_account_branch_properties[FOLDER_LIST_ACCOUNT_BRANCH_FOLDER_ENTRIES_PROPERTY] = g_param_spec_object ("folder-entries", "folder-entries", "folder-entries", GEE_TYPE_HASH_MAP, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
folder_list_account_branch_instance_init (FolderListAccountBranch * self,
                                          gpointer klass)
{
	gchar* _tmp0_;
	self->priv = folder_list_account_branch_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->display_name = _tmp0_;
}

static void
folder_list_account_branch_finalize (GObject * obj)
{
	FolderListAccountBranch * self;
	GearyAccount* _tmp0_;
	GearyAccountInformation* _tmp1_;
	GearyAccountInformation* _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	guint _tmp5_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLDER_LIST_TYPE_ACCOUNT_BRANCH, FolderListAccountBranch);
	_tmp0_ = self->priv->_account;
	_tmp1_ = geary_account_get_information (_tmp0_);
	_tmp2_ = _tmp1_;
	g_signal_parse_name ("changed", GEARY_TYPE_ACCOUNT_INFORMATION, &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _folder_list_account_branch_on_information_changed_geary_account_information_changed, self);
	g_signal_parse_name ("entry-removed", SIDEBAR_TYPE_BRANCH, &_tmp4_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (self, SIDEBAR_TYPE_BRANCH, SidebarBranch), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _folder_list_account_branch_on_entry_removed_sidebar_branch_entry_removed, self);
	g_signal_parse_name ("entry-moved", SIDEBAR_TYPE_BRANCH, &_tmp5_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (self, SIDEBAR_TYPE_BRANCH, SidebarBranch), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _folder_list_account_branch_check_user_folders_sidebar_branch_entry_moved, self);
	_g_object_unref0 (self->priv->_account);
	_g_object_unref0 (self->priv->_user_folder_group);
	_g_object_unref0 (self->priv->_folder_entries);
	_g_free0 (self->priv->display_name);
	G_OBJECT_CLASS (folder_list_account_branch_parent_class)->finalize (obj);
}

static GType
folder_list_account_branch_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FolderListAccountBranchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folder_list_account_branch_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolderListAccountBranch), 0, (GInstanceInitFunc) folder_list_account_branch_instance_init, NULL };
	GType folder_list_account_branch_type_id;
	folder_list_account_branch_type_id = g_type_register_static (SIDEBAR_TYPE_BRANCH, "FolderListAccountBranch", &g_define_type_info, 0);
	FolderListAccountBranch_private_offset = g_type_add_instance_private (folder_list_account_branch_type_id, sizeof (FolderListAccountBranchPrivate));
	return folder_list_account_branch_type_id;
}

GType
folder_list_account_branch_get_type (void)
{
	static volatile gsize folder_list_account_branch_type_id__once = 0;
	if (g_once_init_enter (&folder_list_account_branch_type_id__once)) {
		GType folder_list_account_branch_type_id;
		folder_list_account_branch_type_id = folder_list_account_branch_get_type_once ();
		g_once_init_leave (&folder_list_account_branch_type_id__once, folder_list_account_branch_type_id);
	}
	return folder_list_account_branch_type_id__once;
}

static void
_vala_folder_list_account_branch_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec)
{
	FolderListAccountBranch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLDER_LIST_TYPE_ACCOUNT_BRANCH, FolderListAccountBranch);
	switch (property_id) {
		case FOLDER_LIST_ACCOUNT_BRANCH_ACCOUNT_PROPERTY:
		g_value_set_object (value, folder_list_account_branch_get_account (self));
		break;
		case FOLDER_LIST_ACCOUNT_BRANCH_USER_FOLDER_GROUP_PROPERTY:
		g_value_set_object (value, folder_list_account_branch_get_user_folder_group (self));
		break;
		case FOLDER_LIST_ACCOUNT_BRANCH_FOLDER_ENTRIES_PROPERTY:
		g_value_set_object (value, folder_list_account_branch_get_folder_entries (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_folder_list_account_branch_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec)
{
	FolderListAccountBranch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLDER_LIST_TYPE_ACCOUNT_BRANCH, FolderListAccountBranch);
	switch (property_id) {
		case FOLDER_LIST_ACCOUNT_BRANCH_ACCOUNT_PROPERTY:
		folder_list_account_branch_set_account (self, g_value_get_object (value));
		break;
		case FOLDER_LIST_ACCOUNT_BRANCH_USER_FOLDER_GROUP_PROPERTY:
		folder_list_account_branch_set_user_folder_group (self, g_value_get_object (value));
		break;
		case FOLDER_LIST_ACCOUNT_BRANCH_FOLDER_ENTRIES_PROPERTY:
		folder_list_account_branch_set_folder_entries (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

