/* sidebar-common.c generated by valac 0.56.3, the Vala compiler
 * generated from sidebar-common.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */
/* A simple grouping Entry that is only expandable*/

#include "geary-client-43.0.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "geary-engine.h"
#include <gdk/gdk.h>
#include <gtk/gtk.h>

enum  {
	SIDEBAR_GROUPING_0_PROPERTY,
	SIDEBAR_GROUPING_NUM_PROPERTIES
};
static GParamSpec* sidebar_grouping_properties[SIDEBAR_GROUPING_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	SIDEBAR_ROOT_ONLY_BRANCH_0_PROPERTY,
	SIDEBAR_ROOT_ONLY_BRANCH_NUM_PROPERTIES
};
static GParamSpec* sidebar_root_only_branch_properties[SIDEBAR_ROOT_ONLY_BRANCH_NUM_PROPERTIES];
enum  {
	SIDEBAR_HEADER_0_PROPERTY,
	SIDEBAR_HEADER_NUM_PROPERTIES
};
static GParamSpec* sidebar_header_properties[SIDEBAR_HEADER_NUM_PROPERTIES];

struct _SidebarGroupingPrivate {
	gchar* name;
	gchar* tooltip;
	gchar* icon;
};

struct _SidebarHeaderPrivate {
	gboolean emphasized;
};

static gint SidebarGrouping_private_offset;
static gpointer sidebar_grouping_parent_class = NULL;
static SidebarEntryIface * sidebar_grouping_sidebar_entry_parent_iface = NULL;
static SidebarExpandableEntryIface * sidebar_grouping_sidebar_expandable_entry_parent_iface = NULL;
static SidebarRenameableEntryIface * sidebar_grouping_sidebar_renameable_entry_parent_iface = NULL;
static gpointer sidebar_root_only_branch_parent_class = NULL;
static gint SidebarHeader_private_offset;
static gpointer sidebar_header_parent_class = NULL;
static SidebarEmphasizableEntryIface * sidebar_header_sidebar_emphasizable_entry_parent_iface = NULL;

static void sidebar_grouping_real_rename (SidebarRenameableEntry* base,
                                   const gchar* name);
static gboolean sidebar_grouping_real_is_user_renameable (SidebarRenameableEntry* base);
static gchar* sidebar_grouping_real_get_sidebar_name (SidebarEntry* base);
static gchar* sidebar_grouping_real_get_sidebar_tooltip (SidebarEntry* base);
static gchar* sidebar_grouping_real_get_sidebar_icon (SidebarEntry* base);
static gint sidebar_grouping_real_get_count (SidebarEntry* base);
static gchar* sidebar_grouping_real_to_string (SidebarEntry* base);
static gboolean sidebar_grouping_real_expand_on_select (SidebarExpandableEntry* base);
static void sidebar_grouping_finalize (GObject * obj);
static GType sidebar_grouping_get_type_once (void);
static gint sidebar_root_only_branch_null_comparator (SidebarEntry* a,
                                               SidebarEntry* b);
static gint _sidebar_root_only_branch_null_comparator_gcompare_func (gconstpointer a,
                                                              gconstpointer b);
static GType sidebar_root_only_branch_get_type_once (void);
static gboolean sidebar_header_real_is_emphasized (SidebarEmphasizableEntry* base);
static void sidebar_header_finalize (GObject * obj);
static GType sidebar_header_get_type_once (void);
static GType sidebar_contextable_get_type_once (void);

static inline gpointer
sidebar_grouping_get_instance_private (SidebarGrouping* self)
{
	return G_STRUCT_MEMBER_P (self, SidebarGrouping_private_offset);
}

SidebarGrouping*
sidebar_grouping_construct (GType object_type,
                            const gchar* name,
                            const gchar* icon,
                            const gchar* tooltip)
{
	SidebarGrouping * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (name != NULL, NULL);
	self = (SidebarGrouping*) geary_base_object_construct (object_type);
	_tmp0_ = g_strdup (name);
	_g_free0 (self->priv->name);
	self->priv->name = _tmp0_;
	_tmp1_ = g_strdup (icon);
	_g_free0 (self->priv->icon);
	self->priv->icon = _tmp1_;
	_tmp2_ = g_strdup (tooltip);
	_g_free0 (self->priv->tooltip);
	self->priv->tooltip = _tmp2_;
	return self;
}

SidebarGrouping*
sidebar_grouping_new (const gchar* name,
                      const gchar* icon,
                      const gchar* tooltip)
{
	return sidebar_grouping_construct (SIDEBAR_TYPE_GROUPING, name, icon, tooltip);
}

static void
sidebar_grouping_real_rename (SidebarRenameableEntry* base,
                              const gchar* name)
{
	SidebarGrouping * self;
	gchar* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, SIDEBAR_TYPE_GROUPING, SidebarGrouping);
	g_return_if_fail (name != NULL);
	_tmp0_ = g_strdup (name);
	_g_free0 (self->priv->name);
	self->priv->name = _tmp0_;
	g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (self, SIDEBAR_TYPE_ENTRY, SidebarEntry), "entry-changed");
}

static gboolean
sidebar_grouping_real_is_user_renameable (SidebarRenameableEntry* base)
{
	SidebarGrouping * self;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, SIDEBAR_TYPE_GROUPING, SidebarGrouping);
	result = FALSE;
	return result;
}

static gchar*
sidebar_grouping_real_get_sidebar_name (SidebarEntry* base)
{
	SidebarGrouping * self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, SIDEBAR_TYPE_GROUPING, SidebarGrouping);
	_tmp0_ = self->priv->name;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static gchar*
sidebar_grouping_real_get_sidebar_tooltip (SidebarEntry* base)
{
	SidebarGrouping * self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, SIDEBAR_TYPE_GROUPING, SidebarGrouping);
	_tmp0_ = self->priv->tooltip;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static gchar*
sidebar_grouping_real_get_sidebar_icon (SidebarEntry* base)
{
	SidebarGrouping * self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, SIDEBAR_TYPE_GROUPING, SidebarGrouping);
	_tmp0_ = self->priv->icon;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static gint
sidebar_grouping_real_get_count (SidebarEntry* base)
{
	SidebarGrouping * self;
	gint result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, SIDEBAR_TYPE_GROUPING, SidebarGrouping);
	result = -1;
	return result;
}

static gchar*
sidebar_grouping_real_to_string (SidebarEntry* base)
{
	SidebarGrouping * self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, SIDEBAR_TYPE_GROUPING, SidebarGrouping);
	_tmp0_ = self->priv->name;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static gboolean
sidebar_grouping_real_expand_on_select (SidebarExpandableEntry* base)
{
	SidebarGrouping * self;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, SIDEBAR_TYPE_GROUPING, SidebarGrouping);
	result = TRUE;
	return result;
}

static void
sidebar_grouping_class_init (SidebarGroupingClass * klass,
                             gpointer klass_data)
{
	sidebar_grouping_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SidebarGrouping_private_offset);
	G_OBJECT_CLASS (klass)->finalize = sidebar_grouping_finalize;
}

static void
sidebar_grouping_sidebar_entry_interface_init (SidebarEntryIface * iface,
                                               gpointer iface_data)
{
	sidebar_grouping_sidebar_entry_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_sidebar_name = (gchar* (*) (SidebarEntry*)) sidebar_grouping_real_get_sidebar_name;
	iface->get_sidebar_tooltip = (gchar* (*) (SidebarEntry*)) sidebar_grouping_real_get_sidebar_tooltip;
	iface->get_sidebar_icon = (gchar* (*) (SidebarEntry*)) sidebar_grouping_real_get_sidebar_icon;
	iface->get_count = (gint (*) (SidebarEntry*)) sidebar_grouping_real_get_count;
	iface->to_string = (gchar* (*) (SidebarEntry*)) sidebar_grouping_real_to_string;
}

static void
sidebar_grouping_sidebar_expandable_entry_interface_init (SidebarExpandableEntryIface * iface,
                                                          gpointer iface_data)
{
	sidebar_grouping_sidebar_expandable_entry_parent_iface = g_type_interface_peek_parent (iface);
	iface->expand_on_select = (gboolean (*) (SidebarExpandableEntry*)) sidebar_grouping_real_expand_on_select;
}

static void
sidebar_grouping_sidebar_renameable_entry_interface_init (SidebarRenameableEntryIface * iface,
                                                          gpointer iface_data)
{
	sidebar_grouping_sidebar_renameable_entry_parent_iface = g_type_interface_peek_parent (iface);
	iface->rename = (void (*) (SidebarRenameableEntry*, const gchar*)) sidebar_grouping_real_rename;
	iface->is_user_renameable = (gboolean (*) (SidebarRenameableEntry*)) sidebar_grouping_real_is_user_renameable;
}

static void
sidebar_grouping_instance_init (SidebarGrouping * self,
                                gpointer klass)
{
	self->priv = sidebar_grouping_get_instance_private (self);
}

static void
sidebar_grouping_finalize (GObject * obj)
{
	SidebarGrouping * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SIDEBAR_TYPE_GROUPING, SidebarGrouping);
	_g_free0 (self->priv->name);
	_g_free0 (self->priv->tooltip);
	_g_free0 (self->priv->icon);
	G_OBJECT_CLASS (sidebar_grouping_parent_class)->finalize (obj);
}

static GType
sidebar_grouping_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SidebarGroupingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sidebar_grouping_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SidebarGrouping), 0, (GInstanceInitFunc) sidebar_grouping_instance_init, NULL };
	static const GInterfaceInfo sidebar_entry_info = { (GInterfaceInitFunc) sidebar_grouping_sidebar_entry_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo sidebar_expandable_entry_info = { (GInterfaceInitFunc) sidebar_grouping_sidebar_expandable_entry_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo sidebar_renameable_entry_info = { (GInterfaceInitFunc) sidebar_grouping_sidebar_renameable_entry_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType sidebar_grouping_type_id;
	sidebar_grouping_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "SidebarGrouping", &g_define_type_info, 0);
	g_type_add_interface_static (sidebar_grouping_type_id, SIDEBAR_TYPE_ENTRY, &sidebar_entry_info);
	g_type_add_interface_static (sidebar_grouping_type_id, SIDEBAR_TYPE_EXPANDABLE_ENTRY, &sidebar_expandable_entry_info);
	g_type_add_interface_static (sidebar_grouping_type_id, SIDEBAR_TYPE_RENAMEABLE_ENTRY, &sidebar_renameable_entry_info);
	SidebarGrouping_private_offset = g_type_add_instance_private (sidebar_grouping_type_id, sizeof (SidebarGroupingPrivate));
	return sidebar_grouping_type_id;
}

GType
sidebar_grouping_get_type (void)
{
	static volatile gsize sidebar_grouping_type_id__once = 0;
	if (g_once_init_enter (&sidebar_grouping_type_id__once)) {
		GType sidebar_grouping_type_id;
		sidebar_grouping_type_id = sidebar_grouping_get_type_once ();
		g_once_init_leave (&sidebar_grouping_type_id__once, sidebar_grouping_type_id);
	}
	return sidebar_grouping_type_id__once;
}

static gint
_sidebar_root_only_branch_null_comparator_gcompare_func (gconstpointer a,
                                                         gconstpointer b)
{
	gint result;
	result = sidebar_root_only_branch_null_comparator ((SidebarEntry*) a, (SidebarEntry*) b);
	return result;
}

SidebarRootOnlyBranch*
sidebar_root_only_branch_construct (GType object_type,
                                    SidebarEntry* root)
{
	SidebarRootOnlyBranch * self = NULL;
	g_return_val_if_fail (SIDEBAR_IS_ENTRY (root), NULL);
	self = (SidebarRootOnlyBranch*) sidebar_branch_construct (object_type, root, SIDEBAR_BRANCH_OPTIONS_NONE, _sidebar_root_only_branch_null_comparator_gcompare_func, NULL);
	return self;
}

SidebarRootOnlyBranch*
sidebar_root_only_branch_new (SidebarEntry* root)
{
	return sidebar_root_only_branch_construct (SIDEBAR_TYPE_ROOT_ONLY_BRANCH, root);
}

static gint
sidebar_root_only_branch_null_comparator (SidebarEntry* a,
                                          SidebarEntry* b)
{
	gint _tmp0_ = 0;
	gint result;
	g_return_val_if_fail (SIDEBAR_IS_ENTRY (a), 0);
	g_return_val_if_fail (SIDEBAR_IS_ENTRY (b), 0);
	if (a != b) {
		_tmp0_ = -1;
	} else {
		_tmp0_ = 0;
	}
	result = _tmp0_;
	return result;
}

static void
sidebar_root_only_branch_class_init (SidebarRootOnlyBranchClass * klass,
                                     gpointer klass_data)
{
	sidebar_root_only_branch_parent_class = g_type_class_peek_parent (klass);
}

static void
sidebar_root_only_branch_instance_init (SidebarRootOnlyBranch * self,
                                        gpointer klass)
{
}

static GType
sidebar_root_only_branch_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SidebarRootOnlyBranchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sidebar_root_only_branch_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SidebarRootOnlyBranch), 0, (GInstanceInitFunc) sidebar_root_only_branch_instance_init, NULL };
	GType sidebar_root_only_branch_type_id;
	sidebar_root_only_branch_type_id = g_type_register_static (SIDEBAR_TYPE_BRANCH, "SidebarRootOnlyBranch", &g_define_type_info, 0);
	return sidebar_root_only_branch_type_id;
}

GType
sidebar_root_only_branch_get_type (void)
{
	static volatile gsize sidebar_root_only_branch_type_id__once = 0;
	if (g_once_init_enter (&sidebar_root_only_branch_type_id__once)) {
		GType sidebar_root_only_branch_type_id;
		sidebar_root_only_branch_type_id = sidebar_root_only_branch_get_type_once ();
		g_once_init_leave (&sidebar_root_only_branch_type_id__once, sidebar_root_only_branch_type_id);
	}
	return sidebar_root_only_branch_type_id__once;
}

static inline gpointer
sidebar_header_get_instance_private (SidebarHeader* self)
{
	return G_STRUCT_MEMBER_P (self, SidebarHeader_private_offset);
}

SidebarHeader*
sidebar_header_construct (GType object_type,
                          const gchar* name,
                          gboolean emphasized)
{
	SidebarHeader * self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (SidebarHeader*) sidebar_grouping_construct (object_type, name, NULL, NULL);
	self->priv->emphasized = emphasized;
	return self;
}

SidebarHeader*
sidebar_header_new (const gchar* name,
                    gboolean emphasized)
{
	return sidebar_header_construct (SIDEBAR_TYPE_HEADER, name, emphasized);
}

static gboolean
sidebar_header_real_is_emphasized (SidebarEmphasizableEntry* base)
{
	SidebarHeader * self;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, SIDEBAR_TYPE_HEADER, SidebarHeader);
	result = self->priv->emphasized;
	return result;
}

static void
sidebar_header_class_init (SidebarHeaderClass * klass,
                           gpointer klass_data)
{
	sidebar_header_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SidebarHeader_private_offset);
	G_OBJECT_CLASS (klass)->finalize = sidebar_header_finalize;
}

static void
sidebar_header_sidebar_emphasizable_entry_interface_init (SidebarEmphasizableEntryIface * iface,
                                                          gpointer iface_data)
{
	sidebar_header_sidebar_emphasizable_entry_parent_iface = g_type_interface_peek_parent (iface);
	iface->is_emphasized = (gboolean (*) (SidebarEmphasizableEntry*)) sidebar_header_real_is_emphasized;
}

static void
sidebar_header_instance_init (SidebarHeader * self,
                              gpointer klass)
{
	self->priv = sidebar_header_get_instance_private (self);
}

static void
sidebar_header_finalize (GObject * obj)
{
	SidebarHeader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SIDEBAR_TYPE_HEADER, SidebarHeader);
	G_OBJECT_CLASS (sidebar_header_parent_class)->finalize (obj);
}

/**
 * A header is an entry that is visually distinguished from its children. Bug 6397 recommends
 * headers to appear bolded and without any icons. To prevent the icons from rendering, we set the
 * icons to null in the base class @see Sidebar.Grouping. But we also go a step further by
 * using a custom cell_data_function (@see Sidebar.Tree::icon_renderer_function) which ensures that
 * header icons won't be rendered. This approach avoids the blank icon spacing issues.
 */
static GType
sidebar_header_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SidebarHeaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sidebar_header_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SidebarHeader), 0, (GInstanceInitFunc) sidebar_header_instance_init, NULL };
	static const GInterfaceInfo sidebar_emphasizable_entry_info = { (GInterfaceInitFunc) sidebar_header_sidebar_emphasizable_entry_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType sidebar_header_type_id;
	sidebar_header_type_id = g_type_register_static (SIDEBAR_TYPE_GROUPING, "SidebarHeader", &g_define_type_info, 0);
	g_type_add_interface_static (sidebar_header_type_id, SIDEBAR_TYPE_EMPHASIZABLE_ENTRY, &sidebar_emphasizable_entry_info);
	SidebarHeader_private_offset = g_type_add_instance_private (sidebar_header_type_id, sizeof (SidebarHeaderPrivate));
	return sidebar_header_type_id;
}

GType
sidebar_header_get_type (void)
{
	static volatile gsize sidebar_header_type_id__once = 0;
	if (g_once_init_enter (&sidebar_header_type_id__once)) {
		GType sidebar_header_type_id;
		sidebar_header_type_id = sidebar_header_get_type_once ();
		g_once_init_leave (&sidebar_header_type_id__once, sidebar_header_type_id);
	}
	return sidebar_header_type_id__once;
}

GtkMenu*
sidebar_contextable_get_sidebar_context_menu (SidebarContextable* self,
                                              GdkEventButton* event)
{
	SidebarContextableIface* _iface_;
	g_return_val_if_fail (SIDEBAR_IS_CONTEXTABLE (self), NULL);
	_iface_ = SIDEBAR_CONTEXTABLE_GET_INTERFACE (self);
	if (_iface_->get_sidebar_context_menu) {
		return _iface_->get_sidebar_context_menu (self, event);
	}
	return NULL;
}

static void
sidebar_contextable_default_init (SidebarContextableIface * iface,
                                  gpointer iface_data)
{
}

static GType
sidebar_contextable_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SidebarContextableIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sidebar_contextable_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType sidebar_contextable_type_id;
	sidebar_contextable_type_id = g_type_register_static (G_TYPE_INTERFACE, "SidebarContextable", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (sidebar_contextable_type_id, G_TYPE_OBJECT);
	return sidebar_contextable_type_id;
}

GType
sidebar_contextable_get_type (void)
{
	static volatile gsize sidebar_contextable_type_id__once = 0;
	if (g_once_init_enter (&sidebar_contextable_type_id__once)) {
		GType sidebar_contextable_type_id;
		sidebar_contextable_type_id = sidebar_contextable_get_type_once ();
		g_once_init_leave (&sidebar_contextable_type_id__once, sidebar_contextable_type_id);
	}
	return sidebar_contextable_type_id__once;
}

