/* geary-folder.c generated by valac 0.56.3, the Vala compiler
 * generated from geary-folder.vala, do not modify */

/*
 * Copyright 2016 Software Freedom Conservancy Inc.
 * Copyright 2018 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>

enum  {
	GEARY_FOLDER_0_PROPERTY,
	GEARY_FOLDER_ACCOUNT_PROPERTY,
	GEARY_FOLDER_PROPERTIES_PROPERTY,
	GEARY_FOLDER_PATH_PROPERTY,
	GEARY_FOLDER_USED_AS_PROPERTY,
	GEARY_FOLDER_OPENING_MONITOR_PROPERTY,
	GEARY_FOLDER_LOGGING_PARENT_PROPERTY,
	GEARY_FOLDER_NUM_PROPERTIES
};
static GParamSpec* geary_folder_properties[GEARY_FOLDER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	GEARY_FOLDER_OPENED_SIGNAL,
	GEARY_FOLDER_OPEN_FAILED_SIGNAL,
	GEARY_FOLDER_CLOSED_SIGNAL,
	GEARY_FOLDER_EMAIL_APPENDED_SIGNAL,
	GEARY_FOLDER_EMAIL_LOCALLY_APPENDED_SIGNAL,
	GEARY_FOLDER_EMAIL_INSERTED_SIGNAL,
	GEARY_FOLDER_EMAIL_LOCALLY_INSERTED_SIGNAL,
	GEARY_FOLDER_EMAIL_REMOVED_SIGNAL,
	GEARY_FOLDER_EMAIL_LOCALLY_REMOVED_SIGNAL,
	GEARY_FOLDER_EMAIL_COUNT_CHANGED_SIGNAL,
	GEARY_FOLDER_EMAIL_FLAGS_CHANGED_SIGNAL,
	GEARY_FOLDER_EMAIL_LOCALLY_COMPLETE_SIGNAL,
	GEARY_FOLDER_USE_CHANGED_SIGNAL,
	GEARY_FOLDER_NUM_SIGNALS
};
static guint geary_folder_signals[GEARY_FOLDER_NUM_SIGNALS] = {0};

static gpointer geary_folder_parent_class = NULL;
static GearyLoggingSourceIface * geary_folder_geary_logging_source_parent_iface = NULL;

static void g_cclosure_user_marshal_VOID__ENUM_INT (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__ENUM_POINTER (GClosure * closure,
                                                 GValue * return_value,
                                                 guint n_param_values,
                                                 const GValue * param_values,
                                                 gpointer invocation_hint,
                                                 gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__INT_FLAGS (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__ENUM_ENUM (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data);
static void geary_folder_real_notify_opened (GearyFolder* self,
                                      GearyFolderOpenState state,
                                      gint count);
static void geary_folder_real_notify_open_failed (GearyFolder* self,
                                           GearyFolderOpenFailed failure,
                                           GError* err);
static void geary_folder_real_notify_closed (GearyFolder* self,
                                      GearyFolderCloseReason reason);
static void geary_folder_real_notify_email_appended (GearyFolder* self,
                                              GeeCollection* ids);
static void geary_folder_real_notify_email_locally_appended (GearyFolder* self,
                                                      GeeCollection* ids);
static void geary_folder_real_notify_email_inserted (GearyFolder* self,
                                              GeeCollection* ids);
static void geary_folder_real_notify_email_locally_inserted (GearyFolder* self,
                                                      GeeCollection* ids);
static void geary_folder_real_notify_email_removed (GearyFolder* self,
                                             GeeCollection* ids);
static void geary_folder_real_notify_email_count_changed (GearyFolder* self,
                                                   gint new_count,
                                                   GearyFolderCountChangeReason reason);
static void geary_folder_real_notify_email_flags_changed (GearyFolder* self,
                                                   GeeMap* flag_map);
static void geary_folder_real_notify_email_locally_complete (GearyFolder* self,
                                                      GeeCollection* ids);
static void geary_folder_real_notify_use_changed (GearyFolder* self,
                                           GearyFolderSpecialUse old_use,
                                           GearyFolderSpecialUse new_use);
static GearyFolderOpenState geary_folder_real_get_open_state (GearyFolder* self);
static void geary_folder_real_set_used_as_custom (GearyFolder* self,
                                           gboolean enabled,
                                           GError** error);
static GearyLoggingState* geary_folder_real_to_logging_state (GearyFolder* self);
static GType geary_folder_get_type_once (void);
static void _vala_geary_folder_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);

/**
     * Specifies the use of a specific folder.
     *
     * These are populated from a number of sources, including mailbox
     * names, protocol hints, and special folder implementations.
     */
gboolean
geary_folder_special_use_is_outgoing (GearyFolderSpecialUse self)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	if (self == GEARY_FOLDER_SPECIAL_USE_SENT) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self == GEARY_FOLDER_SPECIAL_USE_OUTBOX;
	}
	result = _tmp0_;
	return result;
}

 G_GNUC_NO_INLINE static GType
geary_folder_special_use_get_type_once (void)
{
	static const GEnumValue values[] = {{GEARY_FOLDER_SPECIAL_USE_NONE, "GEARY_FOLDER_SPECIAL_USE_NONE", "none"}, {GEARY_FOLDER_SPECIAL_USE_INBOX, "GEARY_FOLDER_SPECIAL_USE_INBOX", "inbox"}, {GEARY_FOLDER_SPECIAL_USE_ARCHIVE, "GEARY_FOLDER_SPECIAL_USE_ARCHIVE", "archive"}, {GEARY_FOLDER_SPECIAL_USE_DRAFTS, "GEARY_FOLDER_SPECIAL_USE_DRAFTS", "drafts"}, {GEARY_FOLDER_SPECIAL_USE_JUNK, "GEARY_FOLDER_SPECIAL_USE_JUNK", "junk"}, {GEARY_FOLDER_SPECIAL_USE_OUTBOX, "GEARY_FOLDER_SPECIAL_USE_OUTBOX", "outbox"}, {GEARY_FOLDER_SPECIAL_USE_SENT, "GEARY_FOLDER_SPECIAL_USE_SENT", "sent"}, {GEARY_FOLDER_SPECIAL_USE_TRASH, "GEARY_FOLDER_SPECIAL_USE_TRASH", "trash"}, {GEARY_FOLDER_SPECIAL_USE_ALL_MAIL, "GEARY_FOLDER_SPECIAL_USE_ALL_MAIL", "all-mail"}, {GEARY_FOLDER_SPECIAL_USE_FLAGGED, "GEARY_FOLDER_SPECIAL_USE_FLAGGED", "flagged"}, {GEARY_FOLDER_SPECIAL_USE_IMPORTANT, "GEARY_FOLDER_SPECIAL_USE_IMPORTANT", "important"}, {GEARY_FOLDER_SPECIAL_USE_SEARCH, "GEARY_FOLDER_SPECIAL_USE_SEARCH", "search"}, {GEARY_FOLDER_SPECIAL_USE_CUSTOM, "GEARY_FOLDER_SPECIAL_USE_CUSTOM", "custom"}, {0, NULL, NULL}};
	GType geary_folder_special_use_type_id;
	geary_folder_special_use_type_id = g_enum_register_static ("GearyFolderSpecialUse", values);
	return geary_folder_special_use_type_id;
}

GType
geary_folder_special_use_get_type (void)
{
	static gsize geary_folder_special_use_type_id__once = 0;
	if (g_once_init_enter (&geary_folder_special_use_type_id__once)) {
		GType geary_folder_special_use_type_id;
		geary_folder_special_use_type_id = geary_folder_special_use_get_type_once ();
		g_once_init_leave (&geary_folder_special_use_type_id__once, geary_folder_special_use_type_id);
	}
	return geary_folder_special_use_type_id__once;
}

/**
     * Indicates if a folder has been opened, and if so in which way.
     */
 G_GNUC_NO_INLINE static GType
geary_folder_open_state_get_type_once (void)
{
	static const GEnumValue values[] = {{GEARY_FOLDER_OPEN_STATE_CLOSED, "GEARY_FOLDER_OPEN_STATE_CLOSED", "closed"}, {GEARY_FOLDER_OPEN_STATE_LOCAL, "GEARY_FOLDER_OPEN_STATE_LOCAL", "local"}, {GEARY_FOLDER_OPEN_STATE_REMOTE, "GEARY_FOLDER_OPEN_STATE_REMOTE", "remote"}, {0, NULL, NULL}};
	GType geary_folder_open_state_type_id;
	geary_folder_open_state_type_id = g_enum_register_static ("GearyFolderOpenState", values);
	return geary_folder_open_state_type_id;
}

GType
geary_folder_open_state_get_type (void)
{
	static gsize geary_folder_open_state_type_id__once = 0;
	if (g_once_init_enter (&geary_folder_open_state_type_id__once)) {
		GType geary_folder_open_state_type_id;
		geary_folder_open_state_type_id = geary_folder_open_state_get_type_once ();
		g_once_init_leave (&geary_folder_open_state_type_id__once, geary_folder_open_state_type_id);
	}
	return geary_folder_open_state_type_id__once;
}

 G_GNUC_NO_INLINE static GType
geary_folder_open_failed_get_type_once (void)
{
	static const GEnumValue values[] = {{GEARY_FOLDER_OPEN_FAILED_LOCAL_ERROR, "GEARY_FOLDER_OPEN_FAILED_LOCAL_ERROR", "local-error"}, {GEARY_FOLDER_OPEN_FAILED_REMOTE_ERROR, "GEARY_FOLDER_OPEN_FAILED_REMOTE_ERROR", "remote-error"}, {0, NULL, NULL}};
	GType geary_folder_open_failed_type_id;
	geary_folder_open_failed_type_id = g_enum_register_static ("GearyFolderOpenFailed", values);
	return geary_folder_open_failed_type_id;
}

GType
geary_folder_open_failed_get_type (void)
{
	static gsize geary_folder_open_failed_type_id__once = 0;
	if (g_once_init_enter (&geary_folder_open_failed_type_id__once)) {
		GType geary_folder_open_failed_type_id;
		geary_folder_open_failed_type_id = geary_folder_open_failed_get_type_once ();
		g_once_init_leave (&geary_folder_open_failed_type_id__once, geary_folder_open_failed_type_id);
	}
	return geary_folder_open_failed_type_id__once;
}

/**
     * Provides the reason why the folder is closing or closed when the {@link closed} signal
     * is fired.
     *
     * The closed signal will be fired multiple times after a Folder is opened.  It is fired
     * after the remote and local sessions close for various reasons, and fires once and only
     * once when the folder is completely closed.
     *
     * LOCAL_CLOSE or LOCAL_ERROR is only called once, depending on the situation determining the
     * value.  The same is true for REMOTE_CLOSE and REMOTE_ERROR.  A REMOTE_ERROR can trigger
     * a LOCAL_CLOSE and vice-versa.  The values may be called in any order.
     *
     * When the local and remote stores have closed (either normally or due to errors), FOLDER_CLOSED
     * will be sent.
     */
gboolean
geary_folder_close_reason_is_error (GearyFolderCloseReason self)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	if (self == GEARY_FOLDER_CLOSE_REASON_LOCAL_ERROR) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self == GEARY_FOLDER_CLOSE_REASON_REMOTE_ERROR;
	}
	result = _tmp0_;
	return result;
}

 G_GNUC_NO_INLINE static GType
geary_folder_close_reason_get_type_once (void)
{
	static const GEnumValue values[] = {{GEARY_FOLDER_CLOSE_REASON_LOCAL_CLOSE, "GEARY_FOLDER_CLOSE_REASON_LOCAL_CLOSE", "local-close"}, {GEARY_FOLDER_CLOSE_REASON_LOCAL_ERROR, "GEARY_FOLDER_CLOSE_REASON_LOCAL_ERROR", "local-error"}, {GEARY_FOLDER_CLOSE_REASON_REMOTE_CLOSE, "GEARY_FOLDER_CLOSE_REASON_REMOTE_CLOSE", "remote-close"}, {GEARY_FOLDER_CLOSE_REASON_REMOTE_ERROR, "GEARY_FOLDER_CLOSE_REASON_REMOTE_ERROR", "remote-error"}, {GEARY_FOLDER_CLOSE_REASON_FOLDER_CLOSED, "GEARY_FOLDER_CLOSE_REASON_FOLDER_CLOSED", "folder-closed"}, {0, NULL, NULL}};
	GType geary_folder_close_reason_type_id;
	geary_folder_close_reason_type_id = g_enum_register_static ("GearyFolderCloseReason", values);
	return geary_folder_close_reason_type_id;
}

GType
geary_folder_close_reason_get_type (void)
{
	static gsize geary_folder_close_reason_type_id__once = 0;
	if (g_once_init_enter (&geary_folder_close_reason_type_id__once)) {
		GType geary_folder_close_reason_type_id;
		geary_folder_close_reason_type_id = geary_folder_close_reason_get_type_once ();
		g_once_init_leave (&geary_folder_close_reason_type_id__once, geary_folder_close_reason_type_id);
	}
	return geary_folder_close_reason_type_id__once;
}

 G_GNUC_NO_INLINE static GType
geary_folder_count_change_reason_get_type_once (void)
{
	static const GFlagsValue values[] = {{GEARY_FOLDER_COUNT_CHANGE_REASON_NONE, "GEARY_FOLDER_COUNT_CHANGE_REASON_NONE", "none"}, {GEARY_FOLDER_COUNT_CHANGE_REASON_APPENDED, "GEARY_FOLDER_COUNT_CHANGE_REASON_APPENDED", "appended"}, {GEARY_FOLDER_COUNT_CHANGE_REASON_INSERTED, "GEARY_FOLDER_COUNT_CHANGE_REASON_INSERTED", "inserted"}, {GEARY_FOLDER_COUNT_CHANGE_REASON_REMOVED, "GEARY_FOLDER_COUNT_CHANGE_REASON_REMOVED", "removed"}, {0, NULL, NULL}};
	GType geary_folder_count_change_reason_type_id;
	geary_folder_count_change_reason_type_id = g_flags_register_static ("GearyFolderCountChangeReason", values);
	return geary_folder_count_change_reason_type_id;
}

GType
geary_folder_count_change_reason_get_type (void)
{
	static gsize geary_folder_count_change_reason_type_id__once = 0;
	if (g_once_init_enter (&geary_folder_count_change_reason_type_id__once)) {
		GType geary_folder_count_change_reason_type_id;
		geary_folder_count_change_reason_type_id = geary_folder_count_change_reason_get_type_once ();
		g_once_init_leave (&geary_folder_count_change_reason_type_id__once, geary_folder_count_change_reason_type_id);
	}
	return geary_folder_count_change_reason_type_id__once;
}

/**
     * Flags that modify the behavior of {@link open_async}.
     */
/** Determines if any one of the given //flags// are set. */
gboolean
geary_folder_open_flags_is_any_set (GearyFolderOpenFlags self,
                                    GearyFolderOpenFlags flags)
{
	gboolean result;
	result = (self & flags) != 0;
	return result;
}

/** Determines all of the given //flags// are set. */
gboolean
geary_folder_open_flags_is_all_set (GearyFolderOpenFlags self,
                                    GearyFolderOpenFlags flags)
{
	gboolean result;
	result = (self & flags) == flags;
	return result;
}

 G_GNUC_NO_INLINE static GType
geary_folder_open_flags_get_type_once (void)
{
	static const GFlagsValue values[] = {{GEARY_FOLDER_OPEN_FLAGS_NONE, "GEARY_FOLDER_OPEN_FLAGS_NONE", "none"}, {GEARY_FOLDER_OPEN_FLAGS_NO_DELAY, "GEARY_FOLDER_OPEN_FLAGS_NO_DELAY", "no-delay"}, {0, NULL, NULL}};
	GType geary_folder_open_flags_type_id;
	geary_folder_open_flags_type_id = g_flags_register_static ("GearyFolderOpenFlags", values);
	return geary_folder_open_flags_type_id;
}

GType
geary_folder_open_flags_get_type (void)
{
	static gsize geary_folder_open_flags_type_id__once = 0;
	if (g_once_init_enter (&geary_folder_open_flags_type_id__once)) {
		GType geary_folder_open_flags_type_id;
		geary_folder_open_flags_type_id = geary_folder_open_flags_get_type_once ();
		g_once_init_leave (&geary_folder_open_flags_type_id__once, geary_folder_open_flags_type_id);
	}
	return geary_folder_open_flags_type_id__once;
}

/**
     * Flags modifying how email is retrieved.
     */
gboolean
geary_folder_list_flags_is_any_set (GearyFolderListFlags self,
                                    GearyFolderListFlags flags)
{
	gboolean result;
	result = (self & flags) != 0;
	return result;
}

gboolean
geary_folder_list_flags_is_all_set (GearyFolderListFlags self,
                                    GearyFolderListFlags flags)
{
	gboolean result;
	result = (self & flags) == flags;
	return result;
}

gboolean
geary_folder_list_flags_is_local_only (GearyFolderListFlags self)
{
	gboolean result;
	result = geary_folder_list_flags_is_all_set (self, GEARY_FOLDER_LIST_FLAGS_LOCAL_ONLY);
	return result;
}

gboolean
geary_folder_list_flags_is_force_update (GearyFolderListFlags self)
{
	gboolean result;
	result = geary_folder_list_flags_is_all_set (self, GEARY_FOLDER_LIST_FLAGS_FORCE_UPDATE);
	return result;
}

gboolean
geary_folder_list_flags_is_including_id (GearyFolderListFlags self)
{
	gboolean result;
	result = geary_folder_list_flags_is_all_set (self, GEARY_FOLDER_LIST_FLAGS_INCLUDING_ID);
	return result;
}

gboolean
geary_folder_list_flags_is_oldest_to_newest (GearyFolderListFlags self)
{
	gboolean result;
	result = geary_folder_list_flags_is_all_set (self, GEARY_FOLDER_LIST_FLAGS_OLDEST_TO_NEWEST);
	return result;
}

gboolean
geary_folder_list_flags_is_newest_to_oldest (GearyFolderListFlags self)
{
	gboolean result;
	result = !geary_folder_list_flags_is_oldest_to_newest (self);
	return result;
}

 G_GNUC_NO_INLINE static GType
geary_folder_list_flags_get_type_once (void)
{
	static const GFlagsValue values[] = {{GEARY_FOLDER_LIST_FLAGS_NONE, "GEARY_FOLDER_LIST_FLAGS_NONE", "none"}, {GEARY_FOLDER_LIST_FLAGS_LOCAL_ONLY, "GEARY_FOLDER_LIST_FLAGS_LOCAL_ONLY", "local-only"}, {GEARY_FOLDER_LIST_FLAGS_FORCE_UPDATE, "GEARY_FOLDER_LIST_FLAGS_FORCE_UPDATE", "force-update"}, {GEARY_FOLDER_LIST_FLAGS_INCLUDING_ID, "GEARY_FOLDER_LIST_FLAGS_INCLUDING_ID", "including-id"}, {GEARY_FOLDER_LIST_FLAGS_OLDEST_TO_NEWEST, "GEARY_FOLDER_LIST_FLAGS_OLDEST_TO_NEWEST", "oldest-to-newest"}, {GEARY_FOLDER_LIST_FLAGS_NO_UNREAD_UPDATE, "GEARY_FOLDER_LIST_FLAGS_NO_UNREAD_UPDATE", "no-unread-update"}, {0, NULL, NULL}};
	GType geary_folder_list_flags_type_id;
	geary_folder_list_flags_type_id = g_flags_register_static ("GearyFolderListFlags", values);
	return geary_folder_list_flags_type_id;
}

GType
geary_folder_list_flags_get_type (void)
{
	static gsize geary_folder_list_flags_type_id__once = 0;
	if (g_once_init_enter (&geary_folder_list_flags_type_id__once)) {
		GType geary_folder_list_flags_type_id;
		geary_folder_list_flags_type_id = geary_folder_list_flags_get_type_once ();
		g_once_init_leave (&geary_folder_list_flags_type_id__once, geary_folder_list_flags_type_id);
	}
	return geary_folder_list_flags_type_id__once;
}

GearyAccount*
geary_folder_get_account (GearyFolder* self)
{
	GearyFolderClass* _klass_;
	g_return_val_if_fail (GEARY_IS_FOLDER (self), NULL);
	_klass_ = GEARY_FOLDER_GET_CLASS (self);
	if (_klass_->get_account) {
		return _klass_->get_account (self);
	}
	return NULL;
}

GearyFolderProperties*
geary_folder_get_properties (GearyFolder* self)
{
	GearyFolderClass* _klass_;
	g_return_val_if_fail (GEARY_IS_FOLDER (self), NULL);
	_klass_ = GEARY_FOLDER_GET_CLASS (self);
	if (_klass_->get_properties) {
		return _klass_->get_properties (self);
	}
	return NULL;
}

GearyFolderPath*
geary_folder_get_path (GearyFolder* self)
{
	GearyFolderClass* _klass_;
	g_return_val_if_fail (GEARY_IS_FOLDER (self), NULL);
	_klass_ = GEARY_FOLDER_GET_CLASS (self);
	if (_klass_->get_path) {
		return _klass_->get_path (self);
	}
	return NULL;
}

GearyFolderSpecialUse
geary_folder_get_used_as (GearyFolder* self)
{
	GearyFolderClass* _klass_;
	g_return_val_if_fail (GEARY_IS_FOLDER (self), 0);
	_klass_ = GEARY_FOLDER_GET_CLASS (self);
	if (_klass_->get_used_as) {
		return _klass_->get_used_as (self);
	}
	return 0;
}

GearyProgressMonitor*
geary_folder_get_opening_monitor (GearyFolder* self)
{
	GearyFolderClass* _klass_;
	g_return_val_if_fail (GEARY_IS_FOLDER (self), NULL);
	_klass_ = GEARY_FOLDER_GET_CLASS (self);
	if (_klass_->get_opening_monitor) {
		return _klass_->get_opening_monitor (self);
	}
	return NULL;
}

static GearyLoggingSource*
geary_folder_real_get_logging_parent (GearyLoggingSource* base)
{
	GearyLoggingSource* result;
	GearyFolder* self;
	GearyAccount* _tmp0_;
	GearyAccount* _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_TYPE_FOLDER, GearyFolder);
	_tmp0_ = geary_folder_get_account (self);
	_tmp1_ = _tmp0_;
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource);
	return result;
}

static void
g_cclosure_user_marshal_VOID__ENUM_INT (GClosure * closure,
                                        GValue * return_value,
                                        guint n_param_values,
                                        const GValue * param_values,
                                        gpointer invocation_hint,
                                        gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__ENUM_INT) (gpointer data1, gint arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__ENUM_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__ENUM_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_enum (param_values + 1), g_value_get_int (param_values + 2), data2);
}

static void
g_cclosure_user_marshal_VOID__ENUM_POINTER (GClosure * closure,
                                            GValue * return_value,
                                            guint n_param_values,
                                            const GValue * param_values,
                                            gpointer invocation_hint,
                                            gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__ENUM_POINTER) (gpointer data1, gint arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__ENUM_POINTER callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__ENUM_POINTER) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_enum (param_values + 1), g_value_get_pointer (param_values + 2), data2);
}

static void
g_cclosure_user_marshal_VOID__INT_FLAGS (GClosure * closure,
                                         GValue * return_value,
                                         guint n_param_values,
                                         const GValue * param_values,
                                         gpointer invocation_hint,
                                         gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__INT_FLAGS) (gpointer data1, gint arg_1, guint arg_2, gpointer data2);
	register GMarshalFunc_VOID__INT_FLAGS callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__INT_FLAGS) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_int (param_values + 1), g_value_get_flags (param_values + 2), data2);
}

static void
g_cclosure_user_marshal_VOID__ENUM_ENUM (GClosure * closure,
                                         GValue * return_value,
                                         guint n_param_values,
                                         const GValue * param_values,
                                         gpointer invocation_hint,
                                         gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__ENUM_ENUM) (gpointer data1, gint arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__ENUM_ENUM callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__ENUM_ENUM) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_enum (param_values + 1), g_value_get_enum (param_values + 2), data2);
}

static void
geary_folder_real_notify_opened (GearyFolder* self,
                                 GearyFolderOpenState state,
                                 gint count)
{
	g_signal_emit (self, geary_folder_signals[GEARY_FOLDER_OPENED_SIGNAL], 0, state, count);
}

void
geary_folder_notify_opened (GearyFolder* self,
                            GearyFolderOpenState state,
                            gint count)
{
	GearyFolderClass* _klass_;
	g_return_if_fail (GEARY_IS_FOLDER (self));
	_klass_ = GEARY_FOLDER_GET_CLASS (self);
	if (_klass_->notify_opened) {
		_klass_->notify_opened (self, state, count);
	}
}

static void
geary_folder_real_notify_open_failed (GearyFolder* self,
                                      GearyFolderOpenFailed failure,
                                      GError* err)
{
	g_signal_emit (self, geary_folder_signals[GEARY_FOLDER_OPEN_FAILED_SIGNAL], 0, failure, err);
}

void
geary_folder_notify_open_failed (GearyFolder* self,
                                 GearyFolderOpenFailed failure,
                                 GError* err)
{
	GearyFolderClass* _klass_;
	g_return_if_fail (GEARY_IS_FOLDER (self));
	_klass_ = GEARY_FOLDER_GET_CLASS (self);
	if (_klass_->notify_open_failed) {
		_klass_->notify_open_failed (self, failure, err);
	}
}

static void
geary_folder_real_notify_closed (GearyFolder* self,
                                 GearyFolderCloseReason reason)
{
	g_signal_emit (self, geary_folder_signals[GEARY_FOLDER_CLOSED_SIGNAL], 0, reason);
}

void
geary_folder_notify_closed (GearyFolder* self,
                            GearyFolderCloseReason reason)
{
	GearyFolderClass* _klass_;
	g_return_if_fail (GEARY_IS_FOLDER (self));
	_klass_ = GEARY_FOLDER_GET_CLASS (self);
	if (_klass_->notify_closed) {
		_klass_->notify_closed (self, reason);
	}
}

static void
geary_folder_real_notify_email_appended (GearyFolder* self,
                                         GeeCollection* ids)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (ids, GEE_TYPE_COLLECTION));
	g_signal_emit (self, geary_folder_signals[GEARY_FOLDER_EMAIL_APPENDED_SIGNAL], 0, ids);
}

void
geary_folder_notify_email_appended (GearyFolder* self,
                                    GeeCollection* ids)
{
	GearyFolderClass* _klass_;
	g_return_if_fail (GEARY_IS_FOLDER (self));
	_klass_ = GEARY_FOLDER_GET_CLASS (self);
	if (_klass_->notify_email_appended) {
		_klass_->notify_email_appended (self, ids);
	}
}

static void
geary_folder_real_notify_email_locally_appended (GearyFolder* self,
                                                 GeeCollection* ids)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (ids, GEE_TYPE_COLLECTION));
	g_signal_emit (self, geary_folder_signals[GEARY_FOLDER_EMAIL_LOCALLY_APPENDED_SIGNAL], 0, ids);
}

void
geary_folder_notify_email_locally_appended (GearyFolder* self,
                                            GeeCollection* ids)
{
	GearyFolderClass* _klass_;
	g_return_if_fail (GEARY_IS_FOLDER (self));
	_klass_ = GEARY_FOLDER_GET_CLASS (self);
	if (_klass_->notify_email_locally_appended) {
		_klass_->notify_email_locally_appended (self, ids);
	}
}

static void
geary_folder_real_notify_email_inserted (GearyFolder* self,
                                         GeeCollection* ids)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (ids, GEE_TYPE_COLLECTION));
	g_signal_emit (self, geary_folder_signals[GEARY_FOLDER_EMAIL_INSERTED_SIGNAL], 0, ids);
}

void
geary_folder_notify_email_inserted (GearyFolder* self,
                                    GeeCollection* ids)
{
	GearyFolderClass* _klass_;
	g_return_if_fail (GEARY_IS_FOLDER (self));
	_klass_ = GEARY_FOLDER_GET_CLASS (self);
	if (_klass_->notify_email_inserted) {
		_klass_->notify_email_inserted (self, ids);
	}
}

static void
geary_folder_real_notify_email_locally_inserted (GearyFolder* self,
                                                 GeeCollection* ids)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (ids, GEE_TYPE_COLLECTION));
	g_signal_emit (self, geary_folder_signals[GEARY_FOLDER_EMAIL_LOCALLY_INSERTED_SIGNAL], 0, ids);
}

void
geary_folder_notify_email_locally_inserted (GearyFolder* self,
                                            GeeCollection* ids)
{
	GearyFolderClass* _klass_;
	g_return_if_fail (GEARY_IS_FOLDER (self));
	_klass_ = GEARY_FOLDER_GET_CLASS (self);
	if (_klass_->notify_email_locally_inserted) {
		_klass_->notify_email_locally_inserted (self, ids);
	}
}

static void
geary_folder_real_notify_email_removed (GearyFolder* self,
                                        GeeCollection* ids)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (ids, GEE_TYPE_COLLECTION));
	g_signal_emit (self, geary_folder_signals[GEARY_FOLDER_EMAIL_REMOVED_SIGNAL], 0, ids);
}

void
geary_folder_notify_email_removed (GearyFolder* self,
                                   GeeCollection* ids)
{
	GearyFolderClass* _klass_;
	g_return_if_fail (GEARY_IS_FOLDER (self));
	_klass_ = GEARY_FOLDER_GET_CLASS (self);
	if (_klass_->notify_email_removed) {
		_klass_->notify_email_removed (self, ids);
	}
}

static void
geary_folder_real_notify_email_count_changed (GearyFolder* self,
                                              gint new_count,
                                              GearyFolderCountChangeReason reason)
{
	g_signal_emit (self, geary_folder_signals[GEARY_FOLDER_EMAIL_COUNT_CHANGED_SIGNAL], 0, new_count, reason);
}

void
geary_folder_notify_email_count_changed (GearyFolder* self,
                                         gint new_count,
                                         GearyFolderCountChangeReason reason)
{
	GearyFolderClass* _klass_;
	g_return_if_fail (GEARY_IS_FOLDER (self));
	_klass_ = GEARY_FOLDER_GET_CLASS (self);
	if (_klass_->notify_email_count_changed) {
		_klass_->notify_email_count_changed (self, new_count, reason);
	}
}

static void
geary_folder_real_notify_email_flags_changed (GearyFolder* self,
                                              GeeMap* flag_map)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (flag_map, GEE_TYPE_MAP));
	g_signal_emit (self, geary_folder_signals[GEARY_FOLDER_EMAIL_FLAGS_CHANGED_SIGNAL], 0, flag_map);
}

void
geary_folder_notify_email_flags_changed (GearyFolder* self,
                                         GeeMap* flag_map)
{
	GearyFolderClass* _klass_;
	g_return_if_fail (GEARY_IS_FOLDER (self));
	_klass_ = GEARY_FOLDER_GET_CLASS (self);
	if (_klass_->notify_email_flags_changed) {
		_klass_->notify_email_flags_changed (self, flag_map);
	}
}

static void
geary_folder_real_notify_email_locally_complete (GearyFolder* self,
                                                 GeeCollection* ids)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (ids, GEE_TYPE_COLLECTION));
	g_signal_emit (self, geary_folder_signals[GEARY_FOLDER_EMAIL_LOCALLY_COMPLETE_SIGNAL], 0, ids);
}

void
geary_folder_notify_email_locally_complete (GearyFolder* self,
                                            GeeCollection* ids)
{
	GearyFolderClass* _klass_;
	g_return_if_fail (GEARY_IS_FOLDER (self));
	_klass_ = GEARY_FOLDER_GET_CLASS (self);
	if (_klass_->notify_email_locally_complete) {
		_klass_->notify_email_locally_complete (self, ids);
	}
}

static void
geary_folder_real_notify_use_changed (GearyFolder* self,
                                      GearyFolderSpecialUse old_use,
                                      GearyFolderSpecialUse new_use)
{
	g_signal_emit (self, geary_folder_signals[GEARY_FOLDER_USE_CHANGED_SIGNAL], 0, old_use, new_use);
}

void
geary_folder_notify_use_changed (GearyFolder* self,
                                 GearyFolderSpecialUse old_use,
                                 GearyFolderSpecialUse new_use)
{
	GearyFolderClass* _klass_;
	g_return_if_fail (GEARY_IS_FOLDER (self));
	_klass_ = GEARY_FOLDER_GET_CLASS (self);
	if (_klass_->notify_use_changed) {
		_klass_->notify_use_changed (self, old_use, new_use);
	}
}

/** Determines if a folder has been opened, and if so in which way. */
static GearyFolderOpenState
geary_folder_real_get_open_state (GearyFolder* self)
{
	g_critical ("Type `%s' does not implement abstract method `geary_folder_get_open_state'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return 0;
}

GearyFolderOpenState
geary_folder_get_open_state (GearyFolder* self)
{
	GearyFolderClass* _klass_;
	g_return_val_if_fail (GEARY_IS_FOLDER (self), 0);
	_klass_ = GEARY_FOLDER_GET_CLASS (self);
	if (_klass_->get_open_state) {
		return _klass_->get_open_state (self);
	}
	return 0;
}

void
geary_folder_open_async (GearyFolder* self,
                         GearyFolderOpenFlags open_flags,
                         GCancellable* cancellable,
                         GAsyncReadyCallback _callback_,
                         gpointer _user_data_)
{
	GearyFolderClass* _klass_;
	_klass_ = GEARY_FOLDER_GET_CLASS (self);
	if (_klass_->open_async) {
		_klass_->open_async (self, open_flags, cancellable, _callback_, _user_data_);
	}
}

gboolean
geary_folder_open_finish (GearyFolder* self,
                          GAsyncResult* _res_,
                          GError** error)
{
	GearyFolderClass* _klass_;
	_klass_ = GEARY_FOLDER_GET_CLASS (self);
	if (_klass_->open_finish) {
		return _klass_->open_finish (self, _res_, error);
	}
	return FALSE;
}

void
geary_folder_close_async (GearyFolder* self,
                          GCancellable* cancellable,
                          GAsyncReadyCallback _callback_,
                          gpointer _user_data_)
{
	GearyFolderClass* _klass_;
	_klass_ = GEARY_FOLDER_GET_CLASS (self);
	if (_klass_->close_async) {
		_klass_->close_async (self, cancellable, _callback_, _user_data_);
	}
}

gboolean
geary_folder_close_finish (GearyFolder* self,
                           GAsyncResult* _res_,
                           GError** error)
{
	GearyFolderClass* _klass_;
	_klass_ = GEARY_FOLDER_GET_CLASS (self);
	if (_klass_->close_finish) {
		return _klass_->close_finish (self, _res_, error);
	}
	return FALSE;
}

void
geary_folder_wait_for_close_async (GearyFolder* self,
                                   GCancellable* cancellable,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	GearyFolderClass* _klass_;
	_klass_ = GEARY_FOLDER_GET_CLASS (self);
	if (_klass_->wait_for_close_async) {
		_klass_->wait_for_close_async (self, cancellable, _callback_, _user_data_);
	}
}

void
geary_folder_wait_for_close_finish (GearyFolder* self,
                                    GAsyncResult* _res_,
                                    GError** error)
{
	GearyFolderClass* _klass_;
	_klass_ = GEARY_FOLDER_GET_CLASS (self);
	if (_klass_->wait_for_close_finish) {
		_klass_->wait_for_close_finish (self, _res_, error);
	}
}

void
geary_folder_synchronise_remote (GearyFolder* self,
                                 GCancellable* cancellable,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	GearyFolderClass* _klass_;
	_klass_ = GEARY_FOLDER_GET_CLASS (self);
	if (_klass_->synchronise_remote) {
		_klass_->synchronise_remote (self, cancellable, _callback_, _user_data_);
	}
}

void
geary_folder_synchronise_remote_finish (GearyFolder* self,
                                        GAsyncResult* _res_,
                                        GError** error)
{
	GearyFolderClass* _klass_;
	_klass_ = GEARY_FOLDER_GET_CLASS (self);
	if (_klass_->synchronise_remote_finish) {
		_klass_->synchronise_remote_finish (self, _res_, error);
	}
}

void
geary_folder_contains_identifiers (GearyFolder* self,
                                   GeeCollection* ids,
                                   GCancellable* cancellable,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	GearyFolderClass* _klass_;
	_klass_ = GEARY_FOLDER_GET_CLASS (self);
	if (_klass_->contains_identifiers) {
		_klass_->contains_identifiers (self, ids, cancellable, _callback_, _user_data_);
	}
}

GeeCollection*
geary_folder_contains_identifiers_finish (GearyFolder* self,
                                          GAsyncResult* _res_,
                                          GError** error)
{
	GearyFolderClass* _klass_;
	_klass_ = GEARY_FOLDER_GET_CLASS (self);
	if (_klass_->contains_identifiers_finish) {
		return _klass_->contains_identifiers_finish (self, _res_, error);
	}
	return NULL;
}

void
geary_folder_list_email_by_id_async (GearyFolder* self,
                                     GearyEmailIdentifier* initial_id,
                                     gint count,
                                     GearyEmailField required_fields,
                                     GearyFolderListFlags flags,
                                     GCancellable* cancellable,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	GearyFolderClass* _klass_;
	_klass_ = GEARY_FOLDER_GET_CLASS (self);
	if (_klass_->list_email_by_id_async) {
		_klass_->list_email_by_id_async (self, initial_id, count, required_fields, flags, cancellable, _callback_, _user_data_);
	}
}

GeeList*
geary_folder_list_email_by_id_finish (GearyFolder* self,
                                      GAsyncResult* _res_,
                                      GError** error)
{
	GearyFolderClass* _klass_;
	_klass_ = GEARY_FOLDER_GET_CLASS (self);
	if (_klass_->list_email_by_id_finish) {
		return _klass_->list_email_by_id_finish (self, _res_, error);
	}
	return NULL;
}

void
geary_folder_list_email_by_sparse_id_async (GearyFolder* self,
                                            GeeCollection* ids,
                                            GearyEmailField required_fields,
                                            GearyFolderListFlags flags,
                                            GCancellable* cancellable,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_)
{
	GearyFolderClass* _klass_;
	_klass_ = GEARY_FOLDER_GET_CLASS (self);
	if (_klass_->list_email_by_sparse_id_async) {
		_klass_->list_email_by_sparse_id_async (self, ids, required_fields, flags, cancellable, _callback_, _user_data_);
	}
}

GeeList*
geary_folder_list_email_by_sparse_id_finish (GearyFolder* self,
                                             GAsyncResult* _res_,
                                             GError** error)
{
	GearyFolderClass* _klass_;
	_klass_ = GEARY_FOLDER_GET_CLASS (self);
	if (_klass_->list_email_by_sparse_id_finish) {
		return _klass_->list_email_by_sparse_id_finish (self, _res_, error);
	}
	return NULL;
}

void
geary_folder_fetch_email_async (GearyFolder* self,
                                GearyEmailIdentifier* email_id,
                                GearyEmailField required_fields,
                                GearyFolderListFlags flags,
                                GCancellable* cancellable,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	GearyFolderClass* _klass_;
	_klass_ = GEARY_FOLDER_GET_CLASS (self);
	if (_klass_->fetch_email_async) {
		_klass_->fetch_email_async (self, email_id, required_fields, flags, cancellable, _callback_, _user_data_);
	}
}

GearyEmail*
geary_folder_fetch_email_finish (GearyFolder* self,
                                 GAsyncResult* _res_,
                                 GError** error)
{
	GearyFolderClass* _klass_;
	_klass_ = GEARY_FOLDER_GET_CLASS (self);
	if (_klass_->fetch_email_finish) {
		return _klass_->fetch_email_finish (self, _res_, error);
	}
	return NULL;
}

/**
     * Sets whether this folder has a custom special use.
     *
     * If `true`, this set a folder's {@link used_as} property so that
     * it returns {@link SpecialUse.CUSTOM}. If the folder's existing
     * special use is not currently set to {@link SpecialUse.NONE}
     * then {@link EngineError.UNSUPPORTED} is thrown.
     *
     * If `false` and the folder's use is currently {@link
     * SpecialUse.CUSTOM} then it is reset to be {@link
     * SpecialUse.NONE}, otherwise if the folder's use is something
     * other than {@link SpecialUse.NONE} then {@link
     * EngineError.UNSUPPORTED} is thrown.
     *
     * If some other engine process causes this folder's use to be
     * something other than {@link SpecialUse.NONE}, this will
     * override the custom use.
     *
     * @see used_as
     */
static void
geary_folder_real_set_used_as_custom (GearyFolder* self,
                                      gboolean enabled,
                                      GError** error)
{
	g_critical ("Type `%s' does not implement abstract method `geary_folder_set_used_as_custom'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
geary_folder_set_used_as_custom (GearyFolder* self,
                                 gboolean enabled,
                                 GError** error)
{
	GearyFolderClass* _klass_;
	g_return_if_fail (GEARY_IS_FOLDER (self));
	_klass_ = GEARY_FOLDER_GET_CLASS (self);
	if (_klass_->set_used_as_custom) {
		_klass_->set_used_as_custom (self, enabled, error);
	}
}

/** {@inheritDoc} */
static GearyLoggingState*
geary_folder_real_to_logging_state (GearyFolder* self)
{
	GearyFolderPath* _tmp0_;
	GearyFolderPath* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GearyLoggingState* _tmp4_;
	GearyLoggingState* _tmp5_;
	GearyLoggingState* result;
	_tmp0_ = geary_folder_get_path (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = geary_folder_path_to_string (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = geary_logging_state_new (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "%s", _tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	result = _tmp5_;
	return result;
}

GearyLoggingState*
geary_folder_to_logging_state (GearyFolder* self)
{
	GearyFolderClass* _klass_;
	g_return_val_if_fail (GEARY_IS_FOLDER (self), NULL);
	_klass_ = GEARY_FOLDER_GET_CLASS (self);
	if (_klass_->to_logging_state) {
		return _klass_->to_logging_state (self);
	}
	return NULL;
}

GearyFolder*
geary_folder_construct (GType object_type)
{
	GearyFolder * self = NULL;
	self = (GearyFolder*) geary_base_object_construct (object_type);
	return self;
}

static void
geary_folder_class_init (GearyFolderClass * klass,
                         gpointer klass_data)
{
	geary_folder_parent_class = g_type_class_peek_parent (klass);
	((GearyFolderClass *) klass)->notify_opened = (void (*) (GearyFolder*, GearyFolderOpenState, gint)) geary_folder_real_notify_opened;
	((GearyFolderClass *) klass)->notify_open_failed = (void (*) (GearyFolder*, GearyFolderOpenFailed, GError*)) geary_folder_real_notify_open_failed;
	((GearyFolderClass *) klass)->notify_closed = (void (*) (GearyFolder*, GearyFolderCloseReason)) geary_folder_real_notify_closed;
	((GearyFolderClass *) klass)->notify_email_appended = (void (*) (GearyFolder*, GeeCollection*)) geary_folder_real_notify_email_appended;
	((GearyFolderClass *) klass)->notify_email_locally_appended = (void (*) (GearyFolder*, GeeCollection*)) geary_folder_real_notify_email_locally_appended;
	((GearyFolderClass *) klass)->notify_email_inserted = (void (*) (GearyFolder*, GeeCollection*)) geary_folder_real_notify_email_inserted;
	((GearyFolderClass *) klass)->notify_email_locally_inserted = (void (*) (GearyFolder*, GeeCollection*)) geary_folder_real_notify_email_locally_inserted;
	((GearyFolderClass *) klass)->notify_email_removed = (void (*) (GearyFolder*, GeeCollection*)) geary_folder_real_notify_email_removed;
	((GearyFolderClass *) klass)->notify_email_count_changed = (void (*) (GearyFolder*, gint, GearyFolderCountChangeReason)) geary_folder_real_notify_email_count_changed;
	((GearyFolderClass *) klass)->notify_email_flags_changed = (void (*) (GearyFolder*, GeeMap*)) geary_folder_real_notify_email_flags_changed;
	((GearyFolderClass *) klass)->notify_email_locally_complete = (void (*) (GearyFolder*, GeeCollection*)) geary_folder_real_notify_email_locally_complete;
	((GearyFolderClass *) klass)->notify_use_changed = (void (*) (GearyFolder*, GearyFolderSpecialUse, GearyFolderSpecialUse)) geary_folder_real_notify_use_changed;
	((GearyFolderClass *) klass)->get_open_state = (GearyFolderOpenState (*) (GearyFolder*)) geary_folder_real_get_open_state;
	((GearyFolderClass *) klass)->set_used_as_custom = (void (*) (GearyFolder*, gboolean, GError**)) geary_folder_real_set_used_as_custom;
	((GearyFolderClass *) klass)->to_logging_state = (GearyLoggingState* (*) (GearyFolder*)) geary_folder_real_to_logging_state;
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_folder_get_property;
	/** The account that owns this folder. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_FOLDER_ACCOUNT_PROPERTY, geary_folder_properties[GEARY_FOLDER_ACCOUNT_PROPERTY] = g_param_spec_object ("account", "account", "account", GEARY_TYPE_ACCOUNT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** Current properties for this folder. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_FOLDER_PROPERTIES_PROPERTY, geary_folder_properties[GEARY_FOLDER_PROPERTIES_PROPERTY] = g_param_spec_object ("properties", "properties", "properties", GEARY_TYPE_FOLDER_PROPERTIES, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** The folder path represented by this object. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_FOLDER_PATH_PROPERTY, geary_folder_properties[GEARY_FOLDER_PATH_PROPERTY] = g_param_spec_object ("path", "path", "path", GEARY_TYPE_FOLDER_PATH, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Determines the special use of this folder.
	     *
	     * This will be set by the engine and updated as information about
	     * a folders use is discovered and changed.
	     *
	     * @see use_changed
	     * @see set_used_as_custom
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_FOLDER_USED_AS_PROPERTY, geary_folder_properties[GEARY_FOLDER_USED_AS_PROPERTY] = g_param_spec_enum ("used-as", "used-as", "used-as", GEARY_FOLDER_TYPE_SPECIAL_USE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** Monitor for notifying of progress when opening the folder. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_FOLDER_OPENING_MONITOR_PROPERTY, geary_folder_properties[GEARY_FOLDER_OPENING_MONITOR_PROPERTY] = g_param_spec_object ("opening-monitor", "opening-monitor", "opening-monitor", GEARY_TYPE_PROGRESS_MONITOR, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** {@inheritDoc} */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_FOLDER_LOGGING_PARENT_PROPERTY, geary_folder_properties[GEARY_FOLDER_LOGGING_PARENT_PROPERTY] = g_param_spec_object ("logging-parent", "logging-parent", "logging-parent", GEARY_LOGGING_TYPE_SOURCE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Fired when the folder moves through stages of being opened.
	     *
	     * It will fire at least once if the folder successfully opens,
	     * with the {@link OpenState} indicating what has been opened and
	     * the count indicating the number of messages in the folder. it
	     * may fire additional times as remote sessions are established
	     * and re-established after being lost.
	     *
	     * If //state// is {@link OpenState.LOCAL}, the local store for
	     * the folder has opened and the count reflects the number of
	     * messages in the local store.
	     *
	     * If //state// is {@link OpenState.REMOTE}, it indicates both the
	     * local store and a remote session has been established, and the
	     * count reflects the number of messages on the remote. This
	     * signal will not be fired with this value for a local-only folder.
	     *
	     * This signal will never fire with {@link OpenState.CLOSED} as a
	     * parameter.
	     *
	     * @see get_open_state
	     */
	geary_folder_signals[GEARY_FOLDER_OPENED_SIGNAL] = g_signal_new ("opened", GEARY_TYPE_FOLDER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__ENUM_INT, G_TYPE_NONE, 2, GEARY_FOLDER_TYPE_OPEN_STATE, G_TYPE_INT);
	/**
	     * Fired when {@link open_async} fails for one or more reasons.
	     *
	     * See open_async and {@link opened} for more information on how
	     * opening a Folder works, in particular how open_async may return
	     * immediately although the remote has not completely opened.
	     * This signal may be called in the context of, or after
	     * completion of, open_async.  It will ''not'' be called after
	     * {@link close_async} has completed, however.
	     *
	     * Note that this signal may be fired ''and'' open_async throw an
	     * Error.
	     *
	     * This signal may be fired more than once before the Folder is
	     * closed, especially in the case of a remote session
	     */
	geary_folder_signals[GEARY_FOLDER_OPEN_FAILED_SIGNAL] = g_signal_new ("open-failed", GEARY_TYPE_FOLDER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__ENUM_POINTER, G_TYPE_NONE, 2, GEARY_FOLDER_TYPE_OPEN_FAILED, G_TYPE_POINTER);
	/**
	     * Fired when the Folder is closed, either by the caller or due to
	     * errors in the local or remote store(s).
	     *
	     * It will fire a number of times: to report how the local store
	     * closed (gracefully or due to error), how the remote closed
	     * (similarly) and finally with {@link CloseReason.FOLDER_CLOSED}.
	     * The first two may come in either order; the third is always the
	     * last.
	     */
	geary_folder_signals[GEARY_FOLDER_CLOSED_SIGNAL] = g_signal_new ("closed", GEARY_TYPE_FOLDER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__ENUM, G_TYPE_NONE, 1, GEARY_FOLDER_TYPE_CLOSE_REASON);
	/**
	     * Fired when email has been appended to the list of messages in the folder.
	     *
	     * The {@link EmailIdentifier} for all appended messages is supplied as a signal parameter.
	     *
	     * @see email_locally_appended
	     */
	geary_folder_signals[GEARY_FOLDER_EMAIL_APPENDED_SIGNAL] = g_signal_new ("email-appended", GEARY_TYPE_FOLDER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_COLLECTION);
	/**
	     * Fired when previously unknown messages have been appended to the list of email in the folder.
	     *
	     * This is similar to {@link email_appended}, but that signal lists ''all'' messages appended
	     * to the folder.  email_locally_appended only reports email that have not been downloaded
	     * prior to the database (and not removed permanently since).  Hence, an email that is removed
	     * from the folder and returned later will not be listed here (unless it was removed from the
	     * local store in the meantime).
	     *
	     * @see email_appended
	     */
	geary_folder_signals[GEARY_FOLDER_EMAIL_LOCALLY_APPENDED_SIGNAL] = g_signal_new ("email-locally-appended", GEARY_TYPE_FOLDER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_COLLECTION);
	/**
	     * Fired when email has been inserted into the list of messages in the folder.
	     *
	     * The {@link EmailIdentifier} for all inserted messages is supplied as a signal parameter.
	     * Inserted messages are not added to the "top" of the vector of messages, but rather into
	     * the middle or beginning.  This can happen for a number of reasons.  Newly received messages
	     * are appended.
	     *
	     * @see email_locally_inserted
	     */
	geary_folder_signals[GEARY_FOLDER_EMAIL_INSERTED_SIGNAL] = g_signal_new ("email-inserted", GEARY_TYPE_FOLDER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_COLLECTION);
	/**
	     * Fired when previously unknown messages have been appended to the list of email in the folder.
	     *
	     * This is similar to {@link email_inserted}, but that signal lists ''all'' messages inserted
	     * to the folder.  email_locally_inserted only reports email that have not been downloaded
	     * prior to the database (and not removed permanently since).  Hence, an email that is removed
	     * from the folder and returned later will not be listed here (unless it was removed from the
	     * local store in the meantime).
	     *
	     * @see email_inserted
	     * @see email_locally_inserted
	     */
	geary_folder_signals[GEARY_FOLDER_EMAIL_LOCALLY_INSERTED_SIGNAL] = g_signal_new ("email-locally-inserted", GEARY_TYPE_FOLDER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_COLLECTION);
	/**
	     * Fired when email has been removed (deleted or moved) from the folder.
	     *
	     * This may occur due to the local user's action or reported from the server (i.e. another
	     * client has performed the action).  Email positions greater than the removed emails are
	     * affected.
	     *
	     * ''Note:'' It's possible for the remote server to report a message has been removed that is not
	     * known locally (and therefore the caller could not have record of).  If this happens, this
	     * signal will ''not'' fire, although {@link email_count_changed} will.
	     */
	geary_folder_signals[GEARY_FOLDER_EMAIL_REMOVED_SIGNAL] = g_signal_new ("email-removed", GEARY_TYPE_FOLDER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_COLLECTION);
	/**
	     * Fired when emails are removed from the local folder.
	     */
	geary_folder_signals[GEARY_FOLDER_EMAIL_LOCALLY_REMOVED_SIGNAL] = g_signal_new ("email-locally-removed", GEARY_TYPE_FOLDER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_COLLECTION);
	/**
	     * Fired when the total count of email in a folder has changed in any way.
	     *
	     * Note that this signal will fire after {@link email_appended}, {@link email_locally_appended},
	     * and {@link email_removed} (although see the note at email_removed).
	     */
	geary_folder_signals[GEARY_FOLDER_EMAIL_COUNT_CHANGED_SIGNAL] = g_signal_new ("email-count-changed", GEARY_TYPE_FOLDER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_FLAGS, G_TYPE_NONE, 2, G_TYPE_INT, GEARY_FOLDER_TYPE_COUNT_CHANGE_REASON);
	/**
	     * Fired when the supplied email flags have changed, whether due to local action or reported by
	     * the server.
	     */
	geary_folder_signals[GEARY_FOLDER_EMAIL_FLAGS_CHANGED_SIGNAL] = g_signal_new ("email-flags-changed", GEARY_TYPE_FOLDER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_MAP);
	/**
	     * Fired when one or more emails have been locally saved with the full set
	     * of Fields.
	     */
	geary_folder_signals[GEARY_FOLDER_EMAIL_LOCALLY_COMPLETE_SIGNAL] = g_signal_new ("email-locally-complete", GEARY_TYPE_FOLDER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_COLLECTION);
	/**
	    * Fired when the folder's special use has changed.
	    *
	    * This will usually happen when the local object has been updated
	    * with data discovered from the remote account.
	    */
	geary_folder_signals[GEARY_FOLDER_USE_CHANGED_SIGNAL] = g_signal_new ("use-changed", GEARY_TYPE_FOLDER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__ENUM_ENUM, G_TYPE_NONE, 2, GEARY_FOLDER_TYPE_SPECIAL_USE, GEARY_FOLDER_TYPE_SPECIAL_USE);
}

static void
geary_folder_geary_logging_source_interface_init (GearyLoggingSourceIface * iface,
                                                  gpointer iface_data)
{
	geary_folder_geary_logging_source_parent_iface = g_type_interface_peek_parent (iface);
	iface->to_logging_state = (GearyLoggingState* (*) (GearyLoggingSource*)) geary_folder_to_logging_state;
	iface->get_logging_parent = geary_folder_real_get_logging_parent;
}

static void
geary_folder_instance_init (GearyFolder * self,
                            gpointer klass)
{
}

/**
 * A Folder represents the basic unit of organization for email.
 *
 * Each {@link Account} provides a hierarchical listing of Folders.
 * Note that while most folders are able to store email messages, some
 * folders may not and may exist purely to group together folders
 * below it in the account's folder hierarchy. Folders that can
 * contain email messages either store these messages purely locally
 * (for example, in the case of an ''outbox'' for mail queued for
 * sending), or as a representation of those found in a mailbox on a
 * remote mail server, such as those provided by an IMAP server. Email
 * messages are represented by the {@link Email} class, and many
 * folder methods will return collections of these. For folders that
 * represent a remote mailbox, the mailbox's email are cached locally,
 * and the set of cached messages may be a subset of those available
 * in the mailbox, depending on an account's settings. Email messages
 * may be partially cached, in the case of a new message having just
 * arrived or a message with many large attachments that was not
 * completely downloaded.
 *
 * Folder objects must be opened (with {@link open_async} before using
 * most of its methods and should be closed with {@link close_async}
 * when completed, even if a previous method call has failed with an
 * IOError. Folders offer various open states indicating when its
 * "local" (disk or database) connection and "remote" (network)
 * connections are ready.  Generally the local connection opens first
 * and the remote connection takes time to establish. When in this
 * state, Folder's methods still operate, but will only return locally
 * stored information.
 *
 * The set of locally stored messages is called the folder's
 * ''vector'', and contains generally the most recent message in the
 * mailbox at the upper end, back through to some older message at the
 * start or lower end of the vector. Thus the ordering of the vector
 * is the ''natural'' ordering, based on the order in which messages
 * were appended to the folder, not when messages were sent or some
 * other criteria. For remote-backed folders, the engine will maintain
 * the vector in accordance with the value of {@link
 * AccountInformation.prefetch_period_days}, however the start of the
 * vector will be extended back past that over time and in response to
 * certain operations that cause the vector to be ''expanded'' ---
 * that is for additional messages to be loaded from the remote
 * server, extending the vector. The upper end of the vector is
 * similarly extended as new messages are appended to the folder by
 * another on the server or in response to user operations such as
 * moving a message.
 *
 * This class only offers a small selection of guaranteed
 * functionality (in particular, the ability to list its {@link
 * Email}).  Additional functionality for Folders is indicated by the
 * presence of {@link FolderSupport} interfaces, include {@link
 * FolderSupport.Remove}, {@link FolderSupport.Copy}, and so forth.
 */
 G_GNUC_NO_INLINE static GType
geary_folder_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyFolderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_folder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyFolder), 0, (GInstanceInitFunc) geary_folder_instance_init, NULL };
	static const GInterfaceInfo geary_logging_source_info = { (GInterfaceInitFunc) geary_folder_geary_logging_source_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType geary_folder_type_id;
	geary_folder_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "GearyFolder", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	g_type_add_interface_static (geary_folder_type_id, GEARY_LOGGING_TYPE_SOURCE, &geary_logging_source_info);
	return geary_folder_type_id;
}

GType
geary_folder_get_type (void)
{
	static gsize geary_folder_type_id__once = 0;
	if (g_once_init_enter (&geary_folder_type_id__once)) {
		GType geary_folder_type_id;
		geary_folder_type_id = geary_folder_get_type_once ();
		g_once_init_leave (&geary_folder_type_id__once, geary_folder_type_id);
	}
	return geary_folder_type_id__once;
}

static void
_vala_geary_folder_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	GearyFolder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_TYPE_FOLDER, GearyFolder);
	switch (property_id) {
		case GEARY_FOLDER_LOGGING_PARENT_PROPERTY:
		g_value_set_object (value, geary_logging_source_get_logging_parent (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource)));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

