/* geary-problem-report.c generated by valac 0.56.3, the Vala compiler
 * generated from geary-problem-report.vala, do not modify */

/*
 * Copyright 2016 Software Freedom Conservancy Inc.
 * Copyright 2017-2019 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

enum  {
	GEARY_PROBLEM_REPORT_0_PROPERTY,
	GEARY_PROBLEM_REPORT_ERROR_PROPERTY,
	GEARY_PROBLEM_REPORT_EARLIEST_LOG_PROPERTY,
	GEARY_PROBLEM_REPORT_LATEST_LOG_PROPERTY,
	GEARY_PROBLEM_REPORT_NUM_PROPERTIES
};
static GParamSpec* geary_problem_report_properties[GEARY_PROBLEM_REPORT_NUM_PROPERTIES];
#define _geary_logging_record_unref0(var) ((var == NULL) ? NULL : (var = (geary_logging_record_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	GEARY_ACCOUNT_PROBLEM_REPORT_0_PROPERTY,
	GEARY_ACCOUNT_PROBLEM_REPORT_ACCOUNT_PROPERTY,
	GEARY_ACCOUNT_PROBLEM_REPORT_NUM_PROPERTIES
};
static GParamSpec* geary_account_problem_report_properties[GEARY_ACCOUNT_PROBLEM_REPORT_NUM_PROPERTIES];
enum  {
	GEARY_SERVICE_PROBLEM_REPORT_0_PROPERTY,
	GEARY_SERVICE_PROBLEM_REPORT_SERVICE_PROPERTY,
	GEARY_SERVICE_PROBLEM_REPORT_NUM_PROPERTIES
};
static GParamSpec* geary_service_problem_report_properties[GEARY_SERVICE_PROBLEM_REPORT_NUM_PROPERTIES];

struct _GearyProblemReportPrivate {
	GearyErrorContext* _error;
	GearyLoggingRecord* _earliest_log;
	GearyLoggingRecord* _latest_log;
};

struct _GearyAccountProblemReportPrivate {
	GearyAccountInformation* _account;
};

struct _GearyServiceProblemReportPrivate {
	GearyServiceInformation* _service;
};

static gint GearyProblemReport_private_offset;
static gpointer geary_problem_report_parent_class = NULL;
static gint GearyAccountProblemReport_private_offset;
static gpointer geary_account_problem_report_parent_class = NULL;
static gint GearyServiceProblemReport_private_offset;
static gpointer geary_service_problem_report_parent_class = NULL;

static void geary_problem_report_set_earliest_log (GearyProblemReport* self,
                                            GearyLoggingRecord* value);
static void geary_problem_report_set_latest_log (GearyProblemReport* self,
                                          GearyLoggingRecord* value);
static void geary_problem_report_set_error (GearyProblemReport* self,
                                     GearyErrorContext* value);
VALA_EXTERN void geary_logging_record_set_next (GearyLoggingRecord* self,
                                    GearyLoggingRecord* value);
static void geary_problem_report_finalize (GObject * obj);
static GType geary_problem_report_get_type_once (void);
static void _vala_geary_problem_report_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_geary_problem_report_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);
static void geary_account_problem_report_set_account (GearyAccountProblemReport* self,
                                               GearyAccountInformation* value);
static void geary_account_problem_report_finalize (GObject * obj);
static GType geary_account_problem_report_get_type_once (void);
static void _vala_geary_account_problem_report_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec);
static void _vala_geary_account_problem_report_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec);
static void geary_service_problem_report_set_service (GearyServiceProblemReport* self,
                                               GearyServiceInformation* value);
static void geary_service_problem_report_finalize (GObject * obj);
static GType geary_service_problem_report_get_type_once (void);
static void _vala_geary_service_problem_report_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec);
static void _vala_geary_service_problem_report_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec);

static inline gpointer
geary_problem_report_get_instance_private (GearyProblemReport* self)
{
	return G_STRUCT_MEMBER_P (self, GearyProblemReport_private_offset);
}

static gpointer
_geary_logging_record_ref0 (gpointer self)
{
	return self ? geary_logging_record_ref (self) : NULL;
}

GearyErrorContext*
geary_problem_report_get_error (GearyProblemReport* self)
{
	GearyErrorContext* result;
	GearyErrorContext* _tmp0_;
	g_return_val_if_fail (GEARY_IS_PROBLEM_REPORT (self), NULL);
	_tmp0_ = self->priv->_error;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
geary_problem_report_set_error (GearyProblemReport* self,
                                GearyErrorContext* value)
{
	GearyErrorContext* old_value;
	g_return_if_fail (GEARY_IS_PROBLEM_REPORT (self));
	old_value = geary_problem_report_get_error (self);
	if (old_value != value) {
		GearyErrorContext* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_error);
		self->priv->_error = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_problem_report_properties[GEARY_PROBLEM_REPORT_ERROR_PROPERTY]);
	}
}

GearyLoggingRecord*
geary_problem_report_get_earliest_log (GearyProblemReport* self)
{
	GearyLoggingRecord* result;
	GearyLoggingRecord* _tmp0_;
	g_return_val_if_fail (GEARY_IS_PROBLEM_REPORT (self), NULL);
	_tmp0_ = self->priv->_earliest_log;
	result = _tmp0_;
	return result;
}

static void
geary_problem_report_set_earliest_log (GearyProblemReport* self,
                                       GearyLoggingRecord* value)
{
	GearyLoggingRecord* old_value;
	g_return_if_fail (GEARY_IS_PROBLEM_REPORT (self));
	old_value = geary_problem_report_get_earliest_log (self);
	if (old_value != value) {
		GearyLoggingRecord* _tmp0_;
		_tmp0_ = _geary_logging_record_ref0 (value);
		_geary_logging_record_unref0 (self->priv->_earliest_log);
		self->priv->_earliest_log = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_problem_report_properties[GEARY_PROBLEM_REPORT_EARLIEST_LOG_PROPERTY]);
	}
}

GearyLoggingRecord*
geary_problem_report_get_latest_log (GearyProblemReport* self)
{
	GearyLoggingRecord* result;
	GearyLoggingRecord* _tmp0_;
	g_return_val_if_fail (GEARY_IS_PROBLEM_REPORT (self), NULL);
	_tmp0_ = self->priv->_latest_log;
	result = _tmp0_;
	return result;
}

static void
geary_problem_report_set_latest_log (GearyProblemReport* self,
                                     GearyLoggingRecord* value)
{
	GearyLoggingRecord* old_value;
	g_return_if_fail (GEARY_IS_PROBLEM_REPORT (self));
	old_value = geary_problem_report_get_latest_log (self);
	if (old_value != value) {
		GearyLoggingRecord* _tmp0_;
		_tmp0_ = _geary_logging_record_ref0 (value);
		_geary_logging_record_unref0 (self->priv->_latest_log);
		self->priv->_latest_log = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_problem_report_properties[GEARY_PROBLEM_REPORT_LATEST_LOG_PROPERTY]);
	}
}

GearyProblemReport*
geary_problem_report_construct (GType object_type,
                                GError* _error_)
{
	GearyProblemReport * self = NULL;
	GearyLoggingRecord* next_original = NULL;
	GearyLoggingRecord* _tmp2_;
	GearyLoggingRecord* last_original = NULL;
	GearyLoggingRecord* _tmp3_;
	GearyLoggingRecord* _tmp4_;
	self = (GearyProblemReport*) g_object_new (object_type, NULL);
	if (_error_ != NULL) {
		GearyErrorContext* _tmp0_;
		GearyErrorContext* _tmp1_;
		_tmp0_ = geary_error_context_new (_error_);
		_tmp1_ = _tmp0_;
		geary_problem_report_set_error (self, _tmp1_);
		_g_object_unref0 (_tmp1_);
	}
	_tmp2_ = geary_logging_get_earliest_record ();
	next_original = _tmp2_;
	_tmp3_ = geary_logging_get_latest_record ();
	last_original = _tmp3_;
	_tmp4_ = next_original;
	if (_tmp4_ != NULL) {
		GearyLoggingRecord* copy = NULL;
		GearyLoggingRecord* _tmp5_;
		GearyLoggingRecord* _tmp6_;
		GearyLoggingRecord* _tmp7_;
		GearyLoggingRecord* _tmp8_;
		GearyLoggingRecord* _tmp9_;
		GearyLoggingRecord* _tmp10_;
		GearyLoggingRecord* _tmp11_;
		GearyLoggingRecord* _tmp12_;
		GearyLoggingRecord* _tmp13_;
		GearyLoggingRecord* _tmp30_;
		_tmp5_ = next_original;
		_tmp6_ = geary_logging_record_new_copy (_tmp5_);
		_tmp7_ = _tmp6_;
		geary_problem_report_set_earliest_log (self, _tmp7_);
		_tmp8_ = _geary_logging_record_ref0 (_tmp7_);
		_tmp9_ = _tmp8_;
		_geary_logging_record_unref0 (_tmp7_);
		copy = _tmp9_;
		_tmp10_ = next_original;
		_tmp11_ = geary_logging_record_get_next (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = _geary_logging_record_ref0 (_tmp12_);
		_geary_logging_record_unref0 (next_original);
		next_original = _tmp13_;
		while (TRUE) {
			gboolean _tmp14_ = FALSE;
			GearyLoggingRecord* _tmp15_;
			GearyLoggingRecord* _tmp18_;
			GearyLoggingRecord* _tmp19_;
			GearyLoggingRecord* _tmp20_;
			GearyLoggingRecord* _tmp21_;
			GearyLoggingRecord* _tmp22_;
			GearyLoggingRecord* _tmp23_;
			GearyLoggingRecord* _tmp24_;
			GearyLoggingRecord* _tmp25_;
			GearyLoggingRecord* _tmp26_;
			GearyLoggingRecord* _tmp27_;
			GearyLoggingRecord* _tmp28_;
			GearyLoggingRecord* _tmp29_;
			_tmp15_ = next_original;
			if (_tmp15_ != NULL) {
				GearyLoggingRecord* _tmp16_;
				GearyLoggingRecord* _tmp17_;
				_tmp16_ = next_original;
				_tmp17_ = last_original;
				_tmp14_ = _tmp16_ != _tmp17_;
			} else {
				_tmp14_ = FALSE;
			}
			if (!_tmp14_) {
				break;
			}
			_tmp18_ = copy;
			_tmp19_ = next_original;
			_tmp20_ = geary_logging_record_new_copy (_tmp19_);
			_tmp21_ = _tmp20_;
			geary_logging_record_set_next (_tmp18_, _tmp21_);
			_geary_logging_record_unref0 (_tmp21_);
			_tmp22_ = copy;
			_tmp23_ = geary_logging_record_get_next (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = _geary_logging_record_ref0 (_tmp24_);
			_geary_logging_record_unref0 (copy);
			copy = _tmp25_;
			_tmp26_ = next_original;
			_tmp27_ = geary_logging_record_get_next (_tmp26_);
			_tmp28_ = _tmp27_;
			_tmp29_ = _geary_logging_record_ref0 (_tmp28_);
			_geary_logging_record_unref0 (next_original);
			next_original = _tmp29_;
		}
		_tmp30_ = copy;
		geary_problem_report_set_latest_log (self, _tmp30_);
		_geary_logging_record_unref0 (copy);
	}
	_geary_logging_record_unref0 (last_original);
	_geary_logging_record_unref0 (next_original);
	return self;
}

GearyProblemReport*
geary_problem_report_new (GError* _error_)
{
	return geary_problem_report_construct (GEARY_TYPE_PROBLEM_REPORT, _error_);
}

/** Returns a string representation of the report, for debugging only. */
gchar*
geary_problem_report_to_string (GearyProblemReport* self)
{
	gchar* _tmp0_ = NULL;
	GearyErrorContext* _tmp1_;
	gchar* _tmp5_;
	gchar* result;
	g_return_val_if_fail (GEARY_IS_PROBLEM_REPORT (self), NULL);
	_tmp1_ = self->priv->_error;
	if (_tmp1_ != NULL) {
		GearyErrorContext* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = self->priv->_error;
		_tmp3_ = geary_error_context_format_full_error (_tmp2_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp3_;
	} else {
		gchar* _tmp4_;
		_tmp4_ = g_strdup ("no error reported");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp4_;
	}
	_tmp5_ = g_strdup_printf ("%s", _tmp0_);
	result = _tmp5_;
	_g_free0 (_tmp0_);
	return result;
}

static void
geary_problem_report_class_init (GearyProblemReportClass * klass,
                                 gpointer klass_data)
{
	geary_problem_report_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyProblemReport_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_problem_report_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_problem_report_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_problem_report_finalize;
	/** The exception caused the problem, if any. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_PROBLEM_REPORT_ERROR_PROPERTY, geary_problem_report_properties[GEARY_PROBLEM_REPORT_ERROR_PROPERTY] = g_param_spec_object ("error", "error", "error", GEARY_TYPE_ERROR_CONTEXT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** The oldest log record when the report was first created. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_PROBLEM_REPORT_EARLIEST_LOG_PROPERTY, geary_problem_report_properties[GEARY_PROBLEM_REPORT_EARLIEST_LOG_PROPERTY] = geary_logging_param_spec_record ("earliest-log", "earliest-log", "earliest-log", GEARY_LOGGING_TYPE_RECORD, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** The newest log record when the report was first created. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_PROBLEM_REPORT_LATEST_LOG_PROPERTY, geary_problem_report_properties[GEARY_PROBLEM_REPORT_LATEST_LOG_PROPERTY] = geary_logging_param_spec_record ("latest-log", "latest-log", "latest-log", GEARY_LOGGING_TYPE_RECORD, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_problem_report_instance_init (GearyProblemReport * self,
                                    gpointer klass)
{
	self->priv = geary_problem_report_get_instance_private (self);
	self->priv->_error = NULL;
	self->priv->_earliest_log = NULL;
	self->priv->_latest_log = NULL;
}

static void
geary_problem_report_finalize (GObject * obj)
{
	GearyProblemReport * self;
	GearyLoggingRecord* earliest = NULL;
	GearyLoggingRecord* _tmp0_;
	GearyLoggingRecord* _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_TYPE_PROBLEM_REPORT, GearyProblemReport);
	_tmp0_ = self->priv->_earliest_log;
	_tmp1_ = _geary_logging_record_ref0 (_tmp0_);
	earliest = _tmp1_;
	geary_problem_report_set_earliest_log (self, NULL);
	geary_problem_report_set_latest_log (self, NULL);
	while (TRUE) {
		GearyLoggingRecord* _tmp2_;
		GearyLoggingRecord* _tmp3_;
		GearyLoggingRecord* _tmp4_;
		GearyLoggingRecord* _tmp5_;
		GearyLoggingRecord* _tmp6_;
		_tmp2_ = earliest;
		if (!(_tmp2_ != NULL)) {
			break;
		}
		_tmp3_ = earliest;
		_tmp4_ = geary_logging_record_get_next (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = _geary_logging_record_ref0 (_tmp5_);
		_geary_logging_record_unref0 (earliest);
		earliest = _tmp6_;
	}
	_geary_logging_record_unref0 (earliest);
	_g_object_unref0 (self->priv->_error);
	_geary_logging_record_unref0 (self->priv->_earliest_log);
	_geary_logging_record_unref0 (self->priv->_latest_log);
	G_OBJECT_CLASS (geary_problem_report_parent_class)->finalize (obj);
}

/**
 * Describes a error that the engine encountered, for reporting to the client.
 */
 G_GNUC_NO_INLINE static GType
geary_problem_report_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyProblemReportClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_problem_report_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyProblemReport), 0, (GInstanceInitFunc) geary_problem_report_instance_init, NULL };
	GType geary_problem_report_type_id;
	geary_problem_report_type_id = g_type_register_static (G_TYPE_OBJECT, "GearyProblemReport", &g_define_type_info, 0);
	GearyProblemReport_private_offset = g_type_add_instance_private (geary_problem_report_type_id, sizeof (GearyProblemReportPrivate));
	return geary_problem_report_type_id;
}

GType
geary_problem_report_get_type (void)
{
	static gsize geary_problem_report_type_id__once = 0;
	if (g_once_init_enter (&geary_problem_report_type_id__once)) {
		GType geary_problem_report_type_id;
		geary_problem_report_type_id = geary_problem_report_get_type_once ();
		g_once_init_leave (&geary_problem_report_type_id__once, geary_problem_report_type_id);
	}
	return geary_problem_report_type_id__once;
}

static void
_vala_geary_problem_report_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	GearyProblemReport * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_TYPE_PROBLEM_REPORT, GearyProblemReport);
	switch (property_id) {
		case GEARY_PROBLEM_REPORT_ERROR_PROPERTY:
		g_value_set_object (value, geary_problem_report_get_error (self));
		break;
		case GEARY_PROBLEM_REPORT_EARLIEST_LOG_PROPERTY:
		geary_logging_value_set_record (value, geary_problem_report_get_earliest_log (self));
		break;
		case GEARY_PROBLEM_REPORT_LATEST_LOG_PROPERTY:
		geary_logging_value_set_record (value, geary_problem_report_get_latest_log (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_problem_report_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	GearyProblemReport * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_TYPE_PROBLEM_REPORT, GearyProblemReport);
	switch (property_id) {
		case GEARY_PROBLEM_REPORT_ERROR_PROPERTY:
		geary_problem_report_set_error (self, g_value_get_object (value));
		break;
		case GEARY_PROBLEM_REPORT_EARLIEST_LOG_PROPERTY:
		geary_problem_report_set_earliest_log (self, geary_logging_value_get_record (value));
		break;
		case GEARY_PROBLEM_REPORT_LATEST_LOG_PROPERTY:
		geary_problem_report_set_latest_log (self, geary_logging_value_get_record (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
geary_account_problem_report_get_instance_private (GearyAccountProblemReport* self)
{
	return G_STRUCT_MEMBER_P (self, GearyAccountProblemReport_private_offset);
}

GearyAccountInformation*
geary_account_problem_report_get_account (GearyAccountProblemReport* self)
{
	GearyAccountInformation* result;
	GearyAccountInformation* _tmp0_;
	g_return_val_if_fail (GEARY_IS_ACCOUNT_PROBLEM_REPORT (self), NULL);
	_tmp0_ = self->priv->_account;
	result = _tmp0_;
	return result;
}

static void
geary_account_problem_report_set_account (GearyAccountProblemReport* self,
                                          GearyAccountInformation* value)
{
	GearyAccountInformation* old_value;
	g_return_if_fail (GEARY_IS_ACCOUNT_PROBLEM_REPORT (self));
	old_value = geary_account_problem_report_get_account (self);
	if (old_value != value) {
		GearyAccountInformation* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_account);
		self->priv->_account = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_account_problem_report_properties[GEARY_ACCOUNT_PROBLEM_REPORT_ACCOUNT_PROPERTY]);
	}
}

GearyAccountProblemReport*
geary_account_problem_report_construct (GType object_type,
                                        GearyAccountInformation* account,
                                        GError* _error_)
{
	GearyAccountProblemReport * self = NULL;
	g_return_val_if_fail (GEARY_IS_ACCOUNT_INFORMATION (account), NULL);
	self = (GearyAccountProblemReport*) geary_problem_report_construct (object_type, _error_);
	geary_account_problem_report_set_account (self, account);
	return self;
}

GearyAccountProblemReport*
geary_account_problem_report_new (GearyAccountInformation* account,
                                  GError* _error_)
{
	return geary_account_problem_report_construct (GEARY_TYPE_ACCOUNT_PROBLEM_REPORT, account, _error_);
}

/** Returns a string representation of the report, for debugging only. */
gchar*
geary_account_problem_report_to_string (GearyAccountProblemReport* self)
{
	GearyAccountInformation* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* result;
	g_return_val_if_fail (GEARY_IS_ACCOUNT_PROBLEM_REPORT (self), NULL);
	_tmp0_ = self->priv->_account;
	_tmp1_ = geary_account_information_get_id (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = geary_problem_report_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_PROBLEM_REPORT, GearyProblemReport));
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("%s: %s", _tmp2_, _tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	result = _tmp6_;
	return result;
}

static void
geary_account_problem_report_class_init (GearyAccountProblemReportClass * klass,
                                         gpointer klass_data)
{
	geary_account_problem_report_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyAccountProblemReport_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_account_problem_report_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_account_problem_report_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_account_problem_report_finalize;
	/** The account related to the problem report. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_ACCOUNT_PROBLEM_REPORT_ACCOUNT_PROPERTY, geary_account_problem_report_properties[GEARY_ACCOUNT_PROBLEM_REPORT_ACCOUNT_PROPERTY] = g_param_spec_object ("account", "account", "account", GEARY_TYPE_ACCOUNT_INFORMATION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_account_problem_report_instance_init (GearyAccountProblemReport * self,
                                            gpointer klass)
{
	self->priv = geary_account_problem_report_get_instance_private (self);
}

static void
geary_account_problem_report_finalize (GObject * obj)
{
	GearyAccountProblemReport * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_TYPE_ACCOUNT_PROBLEM_REPORT, GearyAccountProblemReport);
	_g_object_unref0 (self->priv->_account);
	G_OBJECT_CLASS (geary_account_problem_report_parent_class)->finalize (obj);
}

/**
 * Describes an account-related error that the engine encountered.
 */
 G_GNUC_NO_INLINE static GType
geary_account_problem_report_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyAccountProblemReportClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_account_problem_report_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyAccountProblemReport), 0, (GInstanceInitFunc) geary_account_problem_report_instance_init, NULL };
	GType geary_account_problem_report_type_id;
	geary_account_problem_report_type_id = g_type_register_static (GEARY_TYPE_PROBLEM_REPORT, "GearyAccountProblemReport", &g_define_type_info, 0);
	GearyAccountProblemReport_private_offset = g_type_add_instance_private (geary_account_problem_report_type_id, sizeof (GearyAccountProblemReportPrivate));
	return geary_account_problem_report_type_id;
}

GType
geary_account_problem_report_get_type (void)
{
	static gsize geary_account_problem_report_type_id__once = 0;
	if (g_once_init_enter (&geary_account_problem_report_type_id__once)) {
		GType geary_account_problem_report_type_id;
		geary_account_problem_report_type_id = geary_account_problem_report_get_type_once ();
		g_once_init_leave (&geary_account_problem_report_type_id__once, geary_account_problem_report_type_id);
	}
	return geary_account_problem_report_type_id__once;
}

static void
_vala_geary_account_problem_report_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec)
{
	GearyAccountProblemReport * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_TYPE_ACCOUNT_PROBLEM_REPORT, GearyAccountProblemReport);
	switch (property_id) {
		case GEARY_ACCOUNT_PROBLEM_REPORT_ACCOUNT_PROPERTY:
		g_value_set_object (value, geary_account_problem_report_get_account (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_account_problem_report_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec)
{
	GearyAccountProblemReport * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_TYPE_ACCOUNT_PROBLEM_REPORT, GearyAccountProblemReport);
	switch (property_id) {
		case GEARY_ACCOUNT_PROBLEM_REPORT_ACCOUNT_PROPERTY:
		geary_account_problem_report_set_account (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
geary_service_problem_report_get_instance_private (GearyServiceProblemReport* self)
{
	return G_STRUCT_MEMBER_P (self, GearyServiceProblemReport_private_offset);
}

GearyServiceInformation*
geary_service_problem_report_get_service (GearyServiceProblemReport* self)
{
	GearyServiceInformation* result;
	GearyServiceInformation* _tmp0_;
	g_return_val_if_fail (GEARY_IS_SERVICE_PROBLEM_REPORT (self), NULL);
	_tmp0_ = self->priv->_service;
	result = _tmp0_;
	return result;
}

static void
geary_service_problem_report_set_service (GearyServiceProblemReport* self,
                                          GearyServiceInformation* value)
{
	GearyServiceInformation* old_value;
	g_return_if_fail (GEARY_IS_SERVICE_PROBLEM_REPORT (self));
	old_value = geary_service_problem_report_get_service (self);
	if (old_value != value) {
		GearyServiceInformation* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_service);
		self->priv->_service = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_service_problem_report_properties[GEARY_SERVICE_PROBLEM_REPORT_SERVICE_PROPERTY]);
	}
}

GearyServiceProblemReport*
geary_service_problem_report_construct (GType object_type,
                                        GearyAccountInformation* account,
                                        GearyServiceInformation* service,
                                        GError* _error_)
{
	GearyServiceProblemReport * self = NULL;
	g_return_val_if_fail (GEARY_IS_ACCOUNT_INFORMATION (account), NULL);
	g_return_val_if_fail (GEARY_IS_SERVICE_INFORMATION (service), NULL);
	self = (GearyServiceProblemReport*) geary_account_problem_report_construct (object_type, account, _error_);
	geary_service_problem_report_set_service (self, service);
	return self;
}

GearyServiceProblemReport*
geary_service_problem_report_new (GearyAccountInformation* account,
                                  GearyServiceInformation* service,
                                  GError* _error_)
{
	return geary_service_problem_report_construct (GEARY_TYPE_SERVICE_PROBLEM_REPORT, account, service, _error_);
}

/** Returns a string representation of the report, for debugging only. */
gchar*
geary_service_problem_report_to_string (GearyServiceProblemReport* self)
{
	gchar* _tmp0_ = NULL;
	GearyErrorContext* _tmp1_;
	GearyErrorContext* _tmp2_;
	GearyAccountInformation* _tmp7_;
	GearyAccountInformation* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	GearyServiceInformation* _tmp11_;
	GearyProtocol _tmp12_;
	GearyProtocol _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* result;
	g_return_val_if_fail (GEARY_IS_SERVICE_PROBLEM_REPORT (self), NULL);
	_tmp1_ = geary_problem_report_get_error (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_PROBLEM_REPORT, GearyProblemReport));
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		GearyErrorContext* _tmp3_;
		GearyErrorContext* _tmp4_;
		gchar* _tmp5_;
		_tmp3_ = geary_problem_report_get_error (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_PROBLEM_REPORT, GearyProblemReport));
		_tmp4_ = _tmp3_;
		_tmp5_ = geary_error_context_format_full_error (_tmp4_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp5_;
	} else {
		gchar* _tmp6_;
		_tmp6_ = g_strdup ("no error reported");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp6_;
	}
	_tmp7_ = geary_account_problem_report_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_ACCOUNT_PROBLEM_REPORT, GearyAccountProblemReport));
	_tmp8_ = _tmp7_;
	_tmp9_ = geary_account_information_get_id (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = self->priv->_service;
	_tmp12_ = geary_service_information_get_protocol (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_enum_to_string (GEARY_TYPE_PROTOCOL, _tmp13_);
	_tmp15_ = g_strdup_printf ("%s: %s: %s", _tmp10_, _tmp14_, _tmp0_);
	_tmp16_ = _tmp15_;
	_g_free0 (_tmp14_);
	result = _tmp16_;
	_g_free0 (_tmp0_);
	return result;
}

static void
geary_service_problem_report_class_init (GearyServiceProblemReportClass * klass,
                                         gpointer klass_data)
{
	geary_service_problem_report_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyServiceProblemReport_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_service_problem_report_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_service_problem_report_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_service_problem_report_finalize;
	/** The service related to the problem report. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_SERVICE_PROBLEM_REPORT_SERVICE_PROPERTY, geary_service_problem_report_properties[GEARY_SERVICE_PROBLEM_REPORT_SERVICE_PROPERTY] = g_param_spec_object ("service", "service", "service", GEARY_TYPE_SERVICE_INFORMATION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_service_problem_report_instance_init (GearyServiceProblemReport * self,
                                            gpointer klass)
{
	self->priv = geary_service_problem_report_get_instance_private (self);
}

static void
geary_service_problem_report_finalize (GObject * obj)
{
	GearyServiceProblemReport * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_TYPE_SERVICE_PROBLEM_REPORT, GearyServiceProblemReport);
	_g_object_unref0 (self->priv->_service);
	G_OBJECT_CLASS (geary_service_problem_report_parent_class)->finalize (obj);
}

/**
 * Describes a service-related error that the engine encountered.
 */
 G_GNUC_NO_INLINE static GType
geary_service_problem_report_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyServiceProblemReportClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_service_problem_report_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyServiceProblemReport), 0, (GInstanceInitFunc) geary_service_problem_report_instance_init, NULL };
	GType geary_service_problem_report_type_id;
	geary_service_problem_report_type_id = g_type_register_static (GEARY_TYPE_ACCOUNT_PROBLEM_REPORT, "GearyServiceProblemReport", &g_define_type_info, 0);
	GearyServiceProblemReport_private_offset = g_type_add_instance_private (geary_service_problem_report_type_id, sizeof (GearyServiceProblemReportPrivate));
	return geary_service_problem_report_type_id;
}

GType
geary_service_problem_report_get_type (void)
{
	static gsize geary_service_problem_report_type_id__once = 0;
	if (g_once_init_enter (&geary_service_problem_report_type_id__once)) {
		GType geary_service_problem_report_type_id;
		geary_service_problem_report_type_id = geary_service_problem_report_get_type_once ();
		g_once_init_leave (&geary_service_problem_report_type_id__once, geary_service_problem_report_type_id);
	}
	return geary_service_problem_report_type_id__once;
}

static void
_vala_geary_service_problem_report_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec)
{
	GearyServiceProblemReport * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_TYPE_SERVICE_PROBLEM_REPORT, GearyServiceProblemReport);
	switch (property_id) {
		case GEARY_SERVICE_PROBLEM_REPORT_SERVICE_PROPERTY:
		g_value_set_object (value, geary_service_problem_report_get_service (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_service_problem_report_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec)
{
	GearyServiceProblemReport * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_TYPE_SERVICE_PROBLEM_REPORT, GearyServiceProblemReport);
	switch (property_id) {
		case GEARY_SERVICE_PROBLEM_REPORT_SERVICE_PROPERTY:
		geary_service_problem_report_set_service (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

