/* geary-service-information.c generated by valac 0.56.3, the Vala compiler
 * generated from geary-service-information.vala, do not modify */

/*
 * Copyright 2017 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gee.h>

#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	GEARY_SERVICE_INFORMATION_0_PROPERTY,
	GEARY_SERVICE_INFORMATION_PROTOCOL_PROPERTY,
	GEARY_SERVICE_INFORMATION_HOST_PROPERTY,
	GEARY_SERVICE_INFORMATION_PORT_PROPERTY,
	GEARY_SERVICE_INFORMATION_TRANSPORT_SECURITY_PROPERTY,
	GEARY_SERVICE_INFORMATION_CREDENTIALS_REQUIREMENT_PROPERTY,
	GEARY_SERVICE_INFORMATION_CREDENTIALS_PROPERTY,
	GEARY_SERVICE_INFORMATION_REMEMBER_PASSWORD_PROPERTY,
	GEARY_SERVICE_INFORMATION_NUM_PROPERTIES
};
static GParamSpec* geary_service_information_properties[GEARY_SERVICE_INFORMATION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _GearyServiceInformationPrivate {
	GearyProtocol _protocol;
	gchar* _host;
	guint16 _port;
	GearyTlsNegotiationMethod _transport_security;
	GearyCredentialsRequirement _credentials_requirement;
	GearyCredentials* _credentials;
	gboolean _remember_password;
};

static gint GearyServiceInformation_private_offset;
static gpointer geary_service_information_parent_class = NULL;

static void geary_service_information_set_protocol (GearyServiceInformation* self,
                                             GearyProtocol value);
static void geary_service_information_finalize (GObject * obj);
static GType geary_service_information_get_type_once (void);
static void _vala_geary_service_information_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);
static void _vala_geary_service_information_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec);

/**
 * The network protocols supported by the engine for email services.
 */
GearyProtocol
geary_protocol_for_value (const gchar* value,
                          GError** error)
{
	GearyProtocol _tmp0_ = 0;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gpointer _tmp3_;
	GearyProtocol _tmp4_;
	GError* _inner_error0_ = NULL;
	GearyProtocol result;
	g_return_val_if_fail (value != NULL, 0);
	_tmp1_ = g_ascii_strdown (value, (gssize) -1);
	_tmp2_ = _tmp1_;
	_tmp3_ = geary_object_utils_from_enum_nick (GEARY_TYPE_PROTOCOL, NULL, NULL, GEARY_TYPE_PROTOCOL, _tmp2_, &_inner_error0_);
	_tmp4_ = (GearyProtocol) ((gintptr) _tmp3_);
	_g_free0 (_tmp2_);
	_tmp0_ = _tmp4_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return 0;
		}
	}
	result = _tmp0_;
	return result;
}

gchar*
geary_protocol_to_value (GearyProtocol self)
{
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = geary_object_utils_to_enum_nick (GEARY_TYPE_PROTOCOL, NULL, NULL, GEARY_TYPE_PROTOCOL, (gpointer) ((gintptr) self));
	result = _tmp0_;
	return result;
}

 G_GNUC_NO_INLINE static GType
geary_protocol_get_type_once (void)
{
	static const GEnumValue values[] = {{GEARY_PROTOCOL_IMAP, "GEARY_PROTOCOL_IMAP", "imap"}, {GEARY_PROTOCOL_SMTP, "GEARY_PROTOCOL_SMTP", "smtp"}, {0, NULL, NULL}};
	GType geary_protocol_type_id;
	geary_protocol_type_id = g_enum_register_static ("GearyProtocol", values);
	return geary_protocol_type_id;
}

GType
geary_protocol_get_type (void)
{
	static gsize geary_protocol_type_id__once = 0;
	if (g_once_init_enter (&geary_protocol_type_id__once)) {
		GType geary_protocol_type_id;
		geary_protocol_type_id = geary_protocol_get_type_once ();
		g_once_init_leave (&geary_protocol_type_id__once, geary_protocol_type_id);
	}
	return geary_protocol_type_id__once;
}

/** The method used to negotiate a TLS session, if any. */
GearyTlsNegotiationMethod
geary_tls_negotiation_method_for_value (const gchar* value,
                                        GError** error)
{
	GearyTlsNegotiationMethod _tmp0_ = 0;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gpointer _tmp3_;
	GearyTlsNegotiationMethod _tmp4_;
	GError* _inner_error0_ = NULL;
	GearyTlsNegotiationMethod result;
	g_return_val_if_fail (value != NULL, 0);
	_tmp1_ = g_ascii_strdown (value, (gssize) -1);
	_tmp2_ = _tmp1_;
	_tmp3_ = geary_object_utils_from_enum_nick (GEARY_TYPE_TLS_NEGOTIATION_METHOD, NULL, NULL, GEARY_TYPE_TLS_NEGOTIATION_METHOD, _tmp2_, &_inner_error0_);
	_tmp4_ = (GearyTlsNegotiationMethod) ((gintptr) _tmp3_);
	_g_free0 (_tmp2_);
	_tmp0_ = _tmp4_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return 0;
		}
	}
	result = _tmp0_;
	return result;
}

gchar*
geary_tls_negotiation_method_to_value (GearyTlsNegotiationMethod self)
{
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = geary_object_utils_to_enum_nick (GEARY_TYPE_TLS_NEGOTIATION_METHOD, NULL, NULL, GEARY_TYPE_TLS_NEGOTIATION_METHOD, (gpointer) ((gintptr) self));
	result = _tmp0_;
	return result;
}

 G_GNUC_NO_INLINE static GType
geary_tls_negotiation_method_get_type_once (void)
{
	static const GEnumValue values[] = {{GEARY_TLS_NEGOTIATION_METHOD_NONE, "GEARY_TLS_NEGOTIATION_METHOD_NONE", "none"}, {GEARY_TLS_NEGOTIATION_METHOD_START_TLS, "GEARY_TLS_NEGOTIATION_METHOD_START_TLS", "start-tls"}, {GEARY_TLS_NEGOTIATION_METHOD_TRANSPORT, "GEARY_TLS_NEGOTIATION_METHOD_TRANSPORT", "transport"}, {0, NULL, NULL}};
	GType geary_tls_negotiation_method_type_id;
	geary_tls_negotiation_method_type_id = g_enum_register_static ("GearyTlsNegotiationMethod", values);
	return geary_tls_negotiation_method_type_id;
}

GType
geary_tls_negotiation_method_get_type (void)
{
	static gsize geary_tls_negotiation_method_type_id__once = 0;
	if (g_once_init_enter (&geary_tls_negotiation_method_type_id__once)) {
		GType geary_tls_negotiation_method_type_id;
		geary_tls_negotiation_method_type_id = geary_tls_negotiation_method_get_type_once ();
		g_once_init_leave (&geary_tls_negotiation_method_type_id__once, geary_tls_negotiation_method_type_id);
	}
	return geary_tls_negotiation_method_type_id__once;
}

static inline gpointer
geary_service_information_get_instance_private (GearyServiceInformation* self)
{
	return G_STRUCT_MEMBER_P (self, GearyServiceInformation_private_offset);
}

GearyProtocol
geary_service_information_get_protocol (GearyServiceInformation* self)
{
	GearyProtocol result;
	g_return_val_if_fail (GEARY_IS_SERVICE_INFORMATION (self), 0);
	result = self->priv->_protocol;
	return result;
}

static void
geary_service_information_set_protocol (GearyServiceInformation* self,
                                        GearyProtocol value)
{
	GearyProtocol old_value;
	g_return_if_fail (GEARY_IS_SERVICE_INFORMATION (self));
	old_value = geary_service_information_get_protocol (self);
	if (old_value != value) {
		self->priv->_protocol = value;
		g_object_notify_by_pspec ((GObject *) self, geary_service_information_properties[GEARY_SERVICE_INFORMATION_PROTOCOL_PROPERTY]);
	}
}

const gchar*
geary_service_information_get_host (GearyServiceInformation* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_IS_SERVICE_INFORMATION (self), NULL);
	_tmp0_ = self->priv->_host;
	result = _tmp0_;
	return result;
}

void
geary_service_information_set_host (GearyServiceInformation* self,
                                    const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (GEARY_IS_SERVICE_INFORMATION (self));
	old_value = geary_service_information_get_host (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_host);
		self->priv->_host = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_service_information_properties[GEARY_SERVICE_INFORMATION_HOST_PROPERTY]);
	}
}

guint16
geary_service_information_get_port (GearyServiceInformation* self)
{
	guint16 result;
	g_return_val_if_fail (GEARY_IS_SERVICE_INFORMATION (self), 0U);
	result = self->priv->_port;
	return result;
}

void
geary_service_information_set_port (GearyServiceInformation* self,
                                    guint16 value)
{
	guint16 old_value;
	g_return_if_fail (GEARY_IS_SERVICE_INFORMATION (self));
	old_value = geary_service_information_get_port (self);
	if (old_value != value) {
		self->priv->_port = value;
		g_object_notify_by_pspec ((GObject *) self, geary_service_information_properties[GEARY_SERVICE_INFORMATION_PORT_PROPERTY]);
	}
}

GearyTlsNegotiationMethod
geary_service_information_get_transport_security (GearyServiceInformation* self)
{
	GearyTlsNegotiationMethod result;
	g_return_val_if_fail (GEARY_IS_SERVICE_INFORMATION (self), 0);
	result = self->priv->_transport_security;
	return result;
}

void
geary_service_information_set_transport_security (GearyServiceInformation* self,
                                                  GearyTlsNegotiationMethod value)
{
	GearyTlsNegotiationMethod old_value;
	g_return_if_fail (GEARY_IS_SERVICE_INFORMATION (self));
	old_value = geary_service_information_get_transport_security (self);
	if (old_value != value) {
		self->priv->_transport_security = value;
		g_object_notify_by_pspec ((GObject *) self, geary_service_information_properties[GEARY_SERVICE_INFORMATION_TRANSPORT_SECURITY_PROPERTY]);
	}
}

GearyCredentialsRequirement
geary_service_information_get_credentials_requirement (GearyServiceInformation* self)
{
	GearyCredentialsRequirement result;
	g_return_val_if_fail (GEARY_IS_SERVICE_INFORMATION (self), 0);
	result = self->priv->_credentials_requirement;
	return result;
}

void
geary_service_information_set_credentials_requirement (GearyServiceInformation* self,
                                                       GearyCredentialsRequirement value)
{
	GearyCredentialsRequirement old_value;
	g_return_if_fail (GEARY_IS_SERVICE_INFORMATION (self));
	old_value = geary_service_information_get_credentials_requirement (self);
	if (old_value != value) {
		self->priv->_credentials_requirement = value;
		g_object_notify_by_pspec ((GObject *) self, geary_service_information_properties[GEARY_SERVICE_INFORMATION_CREDENTIALS_REQUIREMENT_PROPERTY]);
	}
}

GearyCredentials*
geary_service_information_get_credentials (GearyServiceInformation* self)
{
	GearyCredentials* result;
	GearyCredentials* _tmp0_;
	g_return_val_if_fail (GEARY_IS_SERVICE_INFORMATION (self), NULL);
	_tmp0_ = self->priv->_credentials;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
geary_service_information_set_credentials (GearyServiceInformation* self,
                                           GearyCredentials* value)
{
	GearyCredentials* old_value;
	g_return_if_fail (GEARY_IS_SERVICE_INFORMATION (self));
	old_value = geary_service_information_get_credentials (self);
	if (old_value != value) {
		GearyCredentials* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_credentials);
		self->priv->_credentials = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_service_information_properties[GEARY_SERVICE_INFORMATION_CREDENTIALS_PROPERTY]);
	}
}

gboolean
geary_service_information_get_remember_password (GearyServiceInformation* self)
{
	gboolean result;
	g_return_val_if_fail (GEARY_IS_SERVICE_INFORMATION (self), FALSE);
	result = self->priv->_remember_password;
	return result;
}

void
geary_service_information_set_remember_password (GearyServiceInformation* self,
                                                 gboolean value)
{
	gboolean old_value;
	g_return_if_fail (GEARY_IS_SERVICE_INFORMATION (self));
	old_value = geary_service_information_get_remember_password (self);
	if (old_value != value) {
		self->priv->_remember_password = value;
		g_object_notify_by_pspec ((GObject *) self, geary_service_information_properties[GEARY_SERVICE_INFORMATION_REMEMBER_PASSWORD_PROPERTY]);
	}
}

/**
     * Constructs a new configuration for a specific service.
     */
GearyServiceInformation*
geary_service_information_construct (GType object_type,
                                     GearyProtocol proto,
                                     GearyServiceProvider provider)
{
	GearyServiceInformation * self = NULL;
	GearyTlsNegotiationMethod _tmp0_ = 0;
	GearyCredentialsRequirement _tmp1_ = 0;
	self = (GearyServiceInformation*) g_object_new (object_type, NULL);
	geary_service_information_set_protocol (self, proto);
	if (proto == GEARY_PROTOCOL_SMTP) {
		_tmp0_ = GEARY_TLS_NEGOTIATION_METHOD_START_TLS;
	} else {
		_tmp0_ = GEARY_TLS_NEGOTIATION_METHOD_TRANSPORT;
	}
	geary_service_information_set_transport_security (self, _tmp0_);
	if (proto == GEARY_PROTOCOL_SMTP) {
		_tmp1_ = GEARY_CREDENTIALS_REQUIREMENT_USE_INCOMING;
	} else {
		_tmp1_ = GEARY_CREDENTIALS_REQUIREMENT_CUSTOM;
	}
	geary_service_information_set_credentials_requirement (self, _tmp1_);
	geary_service_provider_set_service_defaults (provider, self);
	return self;
}

GearyServiceInformation*
geary_service_information_new (GearyProtocol proto,
                               GearyServiceProvider provider)
{
	return geary_service_information_construct (GEARY_TYPE_SERVICE_INFORMATION, proto, provider);
}

/**
     * Constructs a copy of the given service configuration.
     */
GearyServiceInformation*
geary_service_information_construct_copy (GType object_type,
                                          GearyServiceInformation* other)
{
	GearyServiceInformation * self = NULL;
	GearyProtocol _tmp0_;
	const gchar* _tmp1_;
	guint16 _tmp2_;
	GearyTlsNegotiationMethod _tmp3_;
	GearyCredentials* _tmp4_ = NULL;
	GearyCredentials* _tmp5_;
	GearyCredentialsRequirement _tmp8_;
	gboolean _tmp9_;
	g_return_val_if_fail (GEARY_IS_SERVICE_INFORMATION (other), NULL);
	_tmp0_ = other->priv->_protocol;
	self = (GearyServiceInformation*) geary_service_information_construct (object_type, _tmp0_, GEARY_SERVICE_PROVIDER_OTHER);
	_tmp1_ = other->priv->_host;
	geary_service_information_set_host (self, _tmp1_);
	_tmp2_ = other->priv->_port;
	geary_service_information_set_port (self, _tmp2_);
	_tmp3_ = other->priv->_transport_security;
	geary_service_information_set_transport_security (self, _tmp3_);
	_tmp5_ = other->priv->_credentials;
	if (_tmp5_ != NULL) {
		GearyCredentials* _tmp6_;
		GearyCredentials* _tmp7_;
		_tmp6_ = other->priv->_credentials;
		_tmp7_ = geary_credentials_copy (_tmp6_);
		_g_object_unref0 (_tmp4_);
		_tmp4_ = _tmp7_;
	} else {
		_g_object_unref0 (_tmp4_);
		_tmp4_ = NULL;
	}
	geary_service_information_set_credentials (self, _tmp4_);
	_tmp8_ = other->priv->_credentials_requirement;
	geary_service_information_set_credentials_requirement (self, _tmp8_);
	_tmp9_ = other->priv->_remember_password;
	geary_service_information_set_remember_password (self, _tmp9_);
	_g_object_unref0 (_tmp4_);
	return self;
}

GearyServiceInformation*
geary_service_information_new_copy (GearyServiceInformation* other)
{
	return geary_service_information_construct_copy (GEARY_TYPE_SERVICE_INFORMATION, other);
}

/**
     * Returns the default port for this service type and settings.
     */
guint16
geary_service_information_get_default_port (GearyServiceInformation* self)
{
	guint16 port = 0U;
	GearyProtocol _tmp0_;
	guint16 result;
	g_return_val_if_fail (GEARY_IS_SERVICE_INFORMATION (self), 0U);
	port = (guint16) 0;
	_tmp0_ = self->priv->_protocol;
	switch (_tmp0_) {
		case GEARY_PROTOCOL_IMAP:
		{
			guint16 _tmp1_ = 0U;
			GearyTlsNegotiationMethod _tmp2_;
			_tmp2_ = self->priv->_transport_security;
			if (_tmp2_ == GEARY_TLS_NEGOTIATION_METHOD_TRANSPORT) {
				_tmp1_ = GEARY_IMAP_IMAP_TLS_PORT;
			} else {
				_tmp1_ = GEARY_IMAP_IMAP_PORT;
			}
			port = _tmp1_;
			break;
		}
		case GEARY_PROTOCOL_SMTP:
		{
			GearyTlsNegotiationMethod _tmp3_;
			_tmp3_ = self->priv->_transport_security;
			if (_tmp3_ == GEARY_TLS_NEGOTIATION_METHOD_TRANSPORT) {
				port = GEARY_SMTP_SUBMISSION_TLS_PORT;
			} else {
				GearyCredentialsRequirement _tmp4_;
				_tmp4_ = self->priv->_credentials_requirement;
				if (_tmp4_ == GEARY_CREDENTIALS_REQUIREMENT_NONE) {
					port = GEARY_SMTP_SMTP_PORT;
				} else {
					port = GEARY_SMTP_SUBMISSION_PORT;
				}
			}
			break;
		}
		default:
		break;
	}
	result = port;
	return result;
}

/**
     * Returns true if another object is equal to this one.
     */
gboolean
geary_service_information_equal_to (GearyServiceInformation* self,
                                    GearyServiceInformation* other)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (GEARY_IS_SERVICE_INFORMATION (self), FALSE);
	g_return_val_if_fail (GEARY_IS_SERVICE_INFORMATION (other), FALSE);
	if (self == other) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp6_ = self->priv->_host;
		_tmp7_ = other->priv->_host;
		if (g_strcmp0 (_tmp6_, _tmp7_) == 0) {
			guint16 _tmp8_;
			guint16 _tmp9_;
			_tmp8_ = self->priv->_port;
			_tmp9_ = other->priv->_port;
			_tmp5_ = _tmp8_ == _tmp9_;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			GearyTlsNegotiationMethod _tmp10_;
			GearyTlsNegotiationMethod _tmp11_;
			_tmp10_ = self->priv->_transport_security;
			_tmp11_ = other->priv->_transport_security;
			_tmp4_ = _tmp10_ == _tmp11_;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			gboolean _tmp12_ = FALSE;
			gboolean _tmp13_ = FALSE;
			GearyCredentials* _tmp14_;
			_tmp14_ = self->priv->_credentials;
			if (_tmp14_ == NULL) {
				GearyCredentials* _tmp15_;
				_tmp15_ = other->priv->_credentials;
				_tmp13_ = _tmp15_ == NULL;
			} else {
				_tmp13_ = FALSE;
			}
			if (_tmp13_) {
				_tmp12_ = TRUE;
			} else {
				gboolean _tmp16_ = FALSE;
				gboolean _tmp17_ = FALSE;
				GearyCredentials* _tmp18_;
				_tmp18_ = self->priv->_credentials;
				if (_tmp18_ != NULL) {
					GearyCredentials* _tmp19_;
					_tmp19_ = other->priv->_credentials;
					_tmp17_ = _tmp19_ != NULL;
				} else {
					_tmp17_ = FALSE;
				}
				if (_tmp17_) {
					GearyCredentials* _tmp20_;
					GearyCredentials* _tmp21_;
					_tmp20_ = self->priv->_credentials;
					_tmp21_ = other->priv->_credentials;
					_tmp16_ = gee_hashable_equal_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, GEE_TYPE_HASHABLE, GeeHashable), _tmp21_);
				} else {
					_tmp16_ = FALSE;
				}
				_tmp12_ = _tmp16_;
			}
			_tmp3_ = _tmp12_;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			GearyCredentialsRequirement _tmp22_;
			GearyCredentialsRequirement _tmp23_;
			_tmp22_ = self->priv->_credentials_requirement;
			_tmp23_ = other->priv->_credentials_requirement;
			_tmp2_ = _tmp22_ == _tmp23_;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			gboolean _tmp24_;
			gboolean _tmp25_;
			_tmp24_ = self->priv->_remember_password;
			_tmp25_ = other->priv->_remember_password;
			_tmp1_ = _tmp24_ == _tmp25_;
		} else {
			_tmp1_ = FALSE;
		}
		_tmp0_ = _tmp1_;
	}
	result = _tmp0_;
	return result;
}

static void
geary_service_information_class_init (GearyServiceInformationClass * klass,
                                      gpointer klass_data)
{
	geary_service_information_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyServiceInformation_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_service_information_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_service_information_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_service_information_finalize;
	/** Specifies the network protocol for this service. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_SERVICE_INFORMATION_PROTOCOL_PROPERTY, geary_service_information_properties[GEARY_SERVICE_INFORMATION_PROTOCOL_PROPERTY] = g_param_spec_enum ("protocol", "protocol", "protocol", GEARY_TYPE_PROTOCOL, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** The server's address. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_SERVICE_INFORMATION_HOST_PROPERTY, geary_service_information_properties[GEARY_SERVICE_INFORMATION_HOST_PROPERTY] = g_param_spec_string ("host", "host", "host", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/** The server's port. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_SERVICE_INFORMATION_PORT_PROPERTY, geary_service_information_properties[GEARY_SERVICE_INFORMATION_PORT_PROPERTY] = g_param_spec_uint ("port", "port", "port", 0, G_MAXUINT, (guint16) 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/** The transport security method to use */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_SERVICE_INFORMATION_TRANSPORT_SECURITY_PROPERTY, geary_service_information_properties[GEARY_SERVICE_INFORMATION_TRANSPORT_SECURITY_PROPERTY] = g_param_spec_enum ("transport-security", "transport-security", "transport-security", GEARY_TYPE_TLS_NEGOTIATION_METHOD, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Determines the source of auth credentials for SMTP services.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_SERVICE_INFORMATION_CREDENTIALS_REQUIREMENT_PROPERTY, geary_service_information_properties[GEARY_SERVICE_INFORMATION_CREDENTIALS_REQUIREMENT_PROPERTY] = g_param_spec_enum ("credentials-requirement", "credentials-requirement", "credentials-requirement", GEARY_CREDENTIALS_TYPE_REQUIREMENT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/** The credentials used for authenticating. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_SERVICE_INFORMATION_CREDENTIALS_PROPERTY, geary_service_information_properties[GEARY_SERVICE_INFORMATION_CREDENTIALS_PROPERTY] = g_param_spec_object ("credentials", "credentials", "credentials", GEARY_TYPE_CREDENTIALS, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Whether the password should be remembered.
	     *
	     * This only makes sense with providers that support saving the
	     * password.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_SERVICE_INFORMATION_REMEMBER_PASSWORD_PROPERTY, geary_service_information_properties[GEARY_SERVICE_INFORMATION_REMEMBER_PASSWORD_PROPERTY] = g_param_spec_boolean ("remember-password", "remember-password", "remember-password", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
geary_service_information_instance_init (GearyServiceInformation * self,
                                         gpointer klass)
{
	gchar* _tmp0_;
	self->priv = geary_service_information_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->_host = _tmp0_;
	self->priv->_port = (guint16) 0;
	self->priv->_credentials = NULL;
	self->priv->_remember_password = TRUE;
}

static void
geary_service_information_finalize (GObject * obj)
{
	GearyServiceInformation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_TYPE_SERVICE_INFORMATION, GearyServiceInformation);
	_g_free0 (self->priv->_host);
	_g_object_unref0 (self->priv->_credentials);
	G_OBJECT_CLASS (geary_service_information_parent_class)->finalize (obj);
}

/**
 * Encapsulates configuration information for a network service.
 */
 G_GNUC_NO_INLINE static GType
geary_service_information_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyServiceInformationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_service_information_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyServiceInformation), 0, (GInstanceInitFunc) geary_service_information_instance_init, NULL };
	GType geary_service_information_type_id;
	geary_service_information_type_id = g_type_register_static (G_TYPE_OBJECT, "GearyServiceInformation", &g_define_type_info, 0);
	GearyServiceInformation_private_offset = g_type_add_instance_private (geary_service_information_type_id, sizeof (GearyServiceInformationPrivate));
	return geary_service_information_type_id;
}

GType
geary_service_information_get_type (void)
{
	static gsize geary_service_information_type_id__once = 0;
	if (g_once_init_enter (&geary_service_information_type_id__once)) {
		GType geary_service_information_type_id;
		geary_service_information_type_id = geary_service_information_get_type_once ();
		g_once_init_leave (&geary_service_information_type_id__once, geary_service_information_type_id);
	}
	return geary_service_information_type_id__once;
}

static void
_vala_geary_service_information_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	GearyServiceInformation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_TYPE_SERVICE_INFORMATION, GearyServiceInformation);
	switch (property_id) {
		case GEARY_SERVICE_INFORMATION_PROTOCOL_PROPERTY:
		g_value_set_enum (value, geary_service_information_get_protocol (self));
		break;
		case GEARY_SERVICE_INFORMATION_HOST_PROPERTY:
		g_value_set_string (value, geary_service_information_get_host (self));
		break;
		case GEARY_SERVICE_INFORMATION_PORT_PROPERTY:
		g_value_set_uint (value, geary_service_information_get_port (self));
		break;
		case GEARY_SERVICE_INFORMATION_TRANSPORT_SECURITY_PROPERTY:
		g_value_set_enum (value, geary_service_information_get_transport_security (self));
		break;
		case GEARY_SERVICE_INFORMATION_CREDENTIALS_REQUIREMENT_PROPERTY:
		g_value_set_enum (value, geary_service_information_get_credentials_requirement (self));
		break;
		case GEARY_SERVICE_INFORMATION_CREDENTIALS_PROPERTY:
		g_value_set_object (value, geary_service_information_get_credentials (self));
		break;
		case GEARY_SERVICE_INFORMATION_REMEMBER_PASSWORD_PROPERTY:
		g_value_set_boolean (value, geary_service_information_get_remember_password (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_service_information_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec)
{
	GearyServiceInformation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_TYPE_SERVICE_INFORMATION, GearyServiceInformation);
	switch (property_id) {
		case GEARY_SERVICE_INFORMATION_PROTOCOL_PROPERTY:
		geary_service_information_set_protocol (self, g_value_get_enum (value));
		break;
		case GEARY_SERVICE_INFORMATION_HOST_PROPERTY:
		geary_service_information_set_host (self, g_value_get_string (value));
		break;
		case GEARY_SERVICE_INFORMATION_PORT_PROPERTY:
		geary_service_information_set_port (self, g_value_get_uint (value));
		break;
		case GEARY_SERVICE_INFORMATION_TRANSPORT_SECURITY_PROPERTY:
		geary_service_information_set_transport_security (self, g_value_get_enum (value));
		break;
		case GEARY_SERVICE_INFORMATION_CREDENTIALS_REQUIREMENT_PROPERTY:
		geary_service_information_set_credentials_requirement (self, g_value_get_enum (value));
		break;
		case GEARY_SERVICE_INFORMATION_CREDENTIALS_PROPERTY:
		geary_service_information_set_credentials (self, g_value_get_object (value));
		break;
		case GEARY_SERVICE_INFORMATION_REMEMBER_PASSWORD_PROPERTY:
		geary_service_information_set_remember_password (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

