/* db-statement.c generated by valac 0.56.3, the Vala compiler
 * generated from db-statement.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <sqlite3.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>

enum  {
	GEARY_DB_STATEMENT_0_PROPERTY,
	GEARY_DB_STATEMENT_SQL_PROPERTY,
	GEARY_DB_STATEMENT_LOGGING_PARENT_PROPERTY,
	GEARY_DB_STATEMENT_CONNECTION_PROPERTY,
	GEARY_DB_STATEMENT_NUM_PROPERTIES
};
static GParamSpec* geary_db_statement_properties[GEARY_DB_STATEMENT_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
enum  {
	GEARY_DB_STATEMENT_EXECUTED_SIGNAL,
	GEARY_DB_STATEMENT_WAS_RESET_SIGNAL,
	GEARY_DB_STATEMENT_BINDINGS_CLEARED_SIGNAL,
	GEARY_DB_STATEMENT_NUM_SIGNALS
};
static guint geary_db_statement_signals[GEARY_DB_STATEMENT_NUM_SIGNALS] = {0};

struct _GearyDbStatementPrivate {
	gchar* _sql;
	GearyDbDatabaseConnection* _connection;
	GeeHashMap* column_map;
	GeeHashSet* held_buffers;
};

static gint GearyDbStatement_private_offset;
static gpointer geary_db_statement_parent_class = NULL;

VALA_EXTERN GearyDbStatement* geary_db_context_get_statement (GearyDbContext* self);
static void geary_db_statement_set_sql (GearyDbStatement* self,
                                 const gchar* value);
VALA_EXTERN GearyDbDatabaseConnection* geary_db_statement_get_connection (GearyDbStatement* self);
static void geary_db_statement_set_connection (GearyDbStatement* self,
                                        GearyDbDatabaseConnection* value);
VALA_EXTERN GearyDbStatement* geary_db_statement_new (GearyDbDatabaseConnection* connection,
                                          const gchar* sql,
                                          GError** error);
VALA_EXTERN GearyDbStatement* geary_db_statement_construct (GType object_type,
                                                GearyDbDatabaseConnection* connection,
                                                const gchar* sql,
                                                GError** error);
VALA_EXTERN sqlite3* geary_db_connection_get_db (GearyDbConnection* self);
static guint _geary_string_stri_hash_gee_hash_data_func (gconstpointer v,
                                                  gpointer self);
static gboolean _geary_string_stri_equal_gee_equal_data_func (gconstpointer a,
                                                       gconstpointer b,
                                                       gpointer self);
VALA_EXTERN GearyDbResult* geary_db_result_new (GearyDbStatement* statement,
                                    GCancellable* cancellable,
                                    GError** error);
VALA_EXTERN GearyDbResult* geary_db_result_construct (GType object_type,
                                          GearyDbStatement* statement,
                                          GCancellable* cancellable,
                                          GError** error);
static GearyLoggingState* geary_db_statement_real_to_logging_state (GearyDbContext* base);
static GearyDbStatement* geary_db_statement_real_get_statement (GearyDbContext* base);
static void geary_db_statement_finalize (GObject * obj);
static GType geary_db_statement_get_type_once (void);
static void _vala_geary_db_statement_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_geary_db_statement_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);

static inline gpointer
geary_db_statement_get_instance_private (GearyDbStatement* self)
{
	return G_STRUCT_MEMBER_P (self, GearyDbStatement_private_offset);
}

const gchar*
geary_db_statement_get_sql (GearyDbStatement* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_DB_IS_STATEMENT (self), NULL);
	_tmp0_ = self->priv->_sql;
	result = _tmp0_;
	return result;
}

static void
geary_db_statement_set_sql (GearyDbStatement* self,
                            const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (GEARY_DB_IS_STATEMENT (self));
	old_value = geary_db_statement_get_sql (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_sql);
		self->priv->_sql = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_db_statement_properties[GEARY_DB_STATEMENT_SQL_PROPERTY]);
	}
}

static GearyLoggingSource*
geary_db_statement_real_get_logging_parent (GearyDbContext* base)
{
	GearyLoggingSource* result;
	GearyDbStatement* self;
	GearyDbDatabaseConnection* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_DB_TYPE_STATEMENT, GearyDbStatement);
	_tmp0_ = self->priv->_connection;
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource);
	return result;
}

GearyDbDatabaseConnection*
geary_db_statement_get_connection (GearyDbStatement* self)
{
	GearyDbDatabaseConnection* result;
	GearyDbDatabaseConnection* _tmp0_;
	g_return_val_if_fail (GEARY_DB_IS_STATEMENT (self), NULL);
	_tmp0_ = self->priv->_connection;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
geary_db_statement_set_connection (GearyDbStatement* self,
                                   GearyDbDatabaseConnection* value)
{
	GearyDbDatabaseConnection* old_value;
	g_return_if_fail (GEARY_DB_IS_STATEMENT (self));
	old_value = geary_db_statement_get_connection (self);
	if (old_value != value) {
		GearyDbDatabaseConnection* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_connection);
		self->priv->_connection = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_db_statement_properties[GEARY_DB_STATEMENT_CONNECTION_PROPERTY]);
	}
}

GearyDbStatement*
geary_db_statement_construct (GType object_type,
                              GearyDbDatabaseConnection* connection,
                              const gchar* sql,
                              GError** error)
{
	GearyDbStatement * self = NULL;
	sqlite3* _tmp0_;
	sqlite3* _tmp1_;
	sqlite3_stmt* _tmp2_ = NULL;
	gint _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (GEARY_DB_IS_DATABASE_CONNECTION (connection), NULL);
	g_return_val_if_fail (sql != NULL, NULL);
	self = (GearyDbStatement*) geary_db_context_construct (object_type);
	geary_db_statement_set_connection (self, connection);
	geary_db_statement_set_sql (self, sql);
	_tmp0_ = geary_db_connection_get_db (G_TYPE_CHECK_INSTANCE_CAST (connection, GEARY_DB_TYPE_CONNECTION, GearyDbConnection));
	_tmp1_ = _tmp0_;
	_tmp3_ = sqlite3_prepare_v2 (_tmp1_, sql, -1, &_tmp2_, NULL);
	_sqlite3_finalize0 (self->stmt);
	self->stmt = _tmp2_;
	geary_db_context_throw_on_error (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_DB_TYPE_CONTEXT, GearyDbContext), "Statement.ctor", _tmp3_, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	return self;
}

GearyDbStatement*
geary_db_statement_new (GearyDbDatabaseConnection* connection,
                        const gchar* sql,
                        GError** error)
{
	return geary_db_statement_construct (GEARY_DB_TYPE_STATEMENT, connection, sql, error);
}

/** Returns SQL for the statement with bound parameters expanded. */
static gchar*
vala_sqlite3_expanded_sql (sqlite3_stmt* self)
{
	const gchar* sqlite = NULL;
	gchar* _tmp0_;
	gchar* sql = NULL;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = sqlite3_expanded_sql (self);
	sqlite = _tmp0_;
	_tmp1_ = g_strdup ((gchar*) sqlite);
	sql = _tmp1_;
	sqlite3_free ((void*) sqlite);
	result = sql;
	return result;
}

gchar*
geary_db_statement_get_expanded_sql (GearyDbStatement* self)
{
	gchar* _tmp0_ = NULL;
	sqlite3_stmt* _tmp1_;
	gchar* result;
	g_return_val_if_fail (GEARY_DB_IS_STATEMENT (self), NULL);
	_tmp1_ = self->stmt;
	if (_tmp1_ != NULL) {
		sqlite3_stmt* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = self->stmt;
		_tmp3_ = vala_sqlite3_expanded_sql (_tmp2_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp3_;
	} else {
		_g_free0 (_tmp0_);
		_tmp0_ = NULL;
	}
	result = _tmp0_;
	return result;
}

/**
     * Reset the Statement for reuse, optionally clearing all bindings as well.  If bindings are
     * not cleared, valued bound previously will be maintained.
     *
     * See http://www.sqlite.org/c3ref/reset.html and http://www.sqlite.org/c3ref/clear_bindings.html
     */
GearyDbStatement*
geary_db_statement_reset (GearyDbStatement* self,
                          GearyDbResetScope reset_scope,
                          GError** error)
{
	sqlite3_stmt* _tmp1_;
	GearyDbStatement* _tmp2_;
	GError* _inner_error0_ = NULL;
	GearyDbStatement* result;
	g_return_val_if_fail (GEARY_DB_IS_STATEMENT (self), NULL);
	if (reset_scope == GEARY_DB_RESET_SCOPE_CLEAR_BINDINGS) {
		sqlite3_stmt* _tmp0_;
		_tmp0_ = self->stmt;
		geary_db_context_throw_on_error (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_DB_TYPE_CONTEXT, GearyDbContext), "Statement.clear_bindings", sqlite3_clear_bindings (_tmp0_), NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == GEARY_DATABASE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
	}
	_tmp1_ = self->stmt;
	geary_db_context_throw_on_error (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_DB_TYPE_CONTEXT, GearyDbContext), "Statement.reset", sqlite3_reset (_tmp1_), NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	if (reset_scope == GEARY_DB_RESET_SCOPE_CLEAR_BINDINGS) {
		g_signal_emit (self, geary_db_statement_signals[GEARY_DB_STATEMENT_BINDINGS_CLEARED_SIGNAL], 0);
	}
	g_signal_emit (self, geary_db_statement_signals[GEARY_DB_STATEMENT_WAS_RESET_SIGNAL], 0);
	_tmp2_ = _g_object_ref0 (self);
	result = _tmp2_;
	return result;
}

/**
     * Returns the number of columns the Statement will return in a Result.
     */
gint
geary_db_statement_get_column_count (GearyDbStatement* self)
{
	sqlite3_stmt* _tmp0_;
	gint result;
	g_return_val_if_fail (GEARY_DB_IS_STATEMENT (self), 0);
	_tmp0_ = self->stmt;
	result = sqlite3_column_count (_tmp0_);
	return result;
}

/**
     * Returns the column name for column at the zero-based index.
     *
     * The name may be used with Result.int_for() (and other *_for() variants).
     */
const gchar*
geary_db_statement_get_column_name (GearyDbStatement* self,
                                    gint index)
{
	sqlite3_stmt* _tmp0_;
	const gchar* _tmp1_;
	const gchar* result;
	g_return_val_if_fail (GEARY_DB_IS_STATEMENT (self), NULL);
	_tmp0_ = self->stmt;
	_tmp1_ = sqlite3_column_name (_tmp0_, index);
	result = _tmp1_;
	return result;
}

/**
     * Returns the zero-based column index matching the column name.  Column names are
     * case-insensitive.
     *
     * Returns -1 if column name is unknown.
     */
static guint
_geary_string_stri_hash_gee_hash_data_func (gconstpointer v,
                                            gpointer self)
{
	guint result;
	result = geary_string_stri_hash ((const gchar*) v);
	return result;
}

static gboolean
_geary_string_stri_equal_gee_equal_data_func (gconstpointer a,
                                              gconstpointer b,
                                              gpointer self)
{
	gboolean result;
	result = geary_string_stri_equal ((const gchar*) a, (const gchar*) b);
	return result;
}

gint
geary_db_statement_get_column_index (GearyDbStatement* self,
                                     const gchar* name)
{
	GeeHashMap* _tmp0_;
	gint _tmp11_ = 0;
	GeeHashMap* _tmp12_;
	gint result;
	g_return_val_if_fail (GEARY_DB_IS_STATEMENT (self), 0);
	g_return_val_if_fail (name != NULL, 0);
	_tmp0_ = self->priv->column_map;
	if (_tmp0_ == NULL) {
		GeeHashMap* _tmp1_;
		gint cols = 0;
		sqlite3_stmt* _tmp2_;
		_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_INT, NULL, NULL, _geary_string_stri_hash_gee_hash_data_func, NULL, NULL, _geary_string_stri_equal_gee_equal_data_func, NULL, NULL, NULL, NULL, NULL);
		_g_object_unref0 (self->priv->column_map);
		self->priv->column_map = _tmp1_;
		_tmp2_ = self->stmt;
		cols = sqlite3_column_count (_tmp2_);
		{
			gint ctr = 0;
			ctr = 0;
			{
				gboolean _tmp3_ = FALSE;
				_tmp3_ = TRUE;
				while (TRUE) {
					gchar* column_name = NULL;
					sqlite3_stmt* _tmp5_;
					const gchar* _tmp6_;
					gchar* _tmp7_;
					const gchar* _tmp8_;
					if (!_tmp3_) {
						gint _tmp4_;
						_tmp4_ = ctr;
						ctr = _tmp4_ + 1;
					}
					_tmp3_ = FALSE;
					if (!(ctr < cols)) {
						break;
					}
					_tmp5_ = self->stmt;
					_tmp6_ = sqlite3_column_name (_tmp5_, ctr);
					_tmp7_ = g_strdup (_tmp6_);
					column_name = _tmp7_;
					_tmp8_ = column_name;
					if (!geary_string_is_empty (_tmp8_)) {
						GeeHashMap* _tmp9_;
						const gchar* _tmp10_;
						_tmp9_ = self->priv->column_map;
						_tmp10_ = column_name;
						gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp10_, (gpointer) ((gintptr) ctr));
					}
					_g_free0 (column_name);
				}
			}
		}
	}
	_tmp12_ = self->priv->column_map;
	if (gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), name)) {
		GeeHashMap* _tmp13_;
		gpointer _tmp14_;
		_tmp13_ = self->priv->column_map;
		_tmp14_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), name);
		_tmp11_ = (gint) ((gintptr) _tmp14_);
	} else {
		_tmp11_ = -1;
	}
	result = _tmp11_;
	return result;
}

/**
     * Executes the Statement and returns a Result object.  The Result starts pointing at the first
     * row in the result set.  If empty, Result.finished will be true.
     */
GearyDbResult*
geary_db_statement_exec (GearyDbStatement* self,
                         GCancellable* cancellable,
                         GError** error)
{
	GearyDbResult* results = NULL;
	GearyDbResult* _tmp2_;
	GError* _inner_error0_ = NULL;
	GearyDbResult* result;
	g_return_val_if_fail (GEARY_DB_IS_STATEMENT (self), NULL);
	g_return_val_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()), NULL);
	if (geary_db_context_enable_sql_logging) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = geary_db_statement_get_expanded_sql (self);
		_tmp1_ = _tmp0_;
		geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "%s", _tmp1_);
		_g_free0 (_tmp1_);
	}
	_tmp2_ = geary_db_result_new (self, cancellable, &_inner_error0_);
	results = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	g_signal_emit (self, geary_db_statement_signals[GEARY_DB_STATEMENT_EXECUTED_SIGNAL], 0);
	result = results;
	return result;
}

/**
     * Executes the Statement and returns the last inserted rowid.  If this Statement is not
     * an INSERT, it will return the rowid of the last prior INSERT.
     *
     * See Connection.last_insert_rowid.
     */
gint64
geary_db_statement_exec_insert (GearyDbStatement* self,
                                GCancellable* cancellable,
                                GError** error)
{
	GearyDbResult* _tmp2_;
	GearyDbResult* _tmp3_;
	gint64 rowid = 0LL;
	GearyDbDatabaseConnection* _tmp5_;
	gint64 _tmp6_;
	gint64 _tmp7_;
	GError* _inner_error0_ = NULL;
	gint64 result;
	g_return_val_if_fail (GEARY_DB_IS_STATEMENT (self), 0LL);
	g_return_val_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()), 0LL);
	if (geary_db_context_enable_sql_logging) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = geary_db_statement_get_expanded_sql (self);
		_tmp1_ = _tmp0_;
		geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "%s", _tmp1_);
		_g_free0 (_tmp1_);
	}
	_tmp2_ = geary_db_result_new (self, cancellable, &_inner_error0_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp3_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint64 _tmp4_ = -1LL;
		g_propagate_error (error, _inner_error0_);
		return _tmp4_;
	}
	_tmp5_ = self->priv->_connection;
	_tmp6_ = geary_db_connection_get_last_insert_rowid (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEARY_DB_TYPE_CONNECTION, GearyDbConnection));
	_tmp7_ = _tmp6_;
	rowid = _tmp7_;
	g_signal_emit (self, geary_db_statement_signals[GEARY_DB_STATEMENT_EXECUTED_SIGNAL], 0);
	result = rowid;
	return result;
}

/**
     * Executes the Statement and returns the number of rows modified by the operation.  This
     * Statement should be an INSERT, UPDATE, or DELETE, otherwise this will return the number
     * of modified rows from the last INSERT, UPDATE, or DELETE.
     *
     * See Connection.last_modified_rows.
     */
gint
geary_db_statement_exec_get_modified (GearyDbStatement* self,
                                      GCancellable* cancellable,
                                      GError** error)
{
	GearyDbResult* _tmp2_;
	GearyDbResult* _tmp3_;
	gint modified = 0;
	GearyDbDatabaseConnection* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	GError* _inner_error0_ = NULL;
	gint result;
	g_return_val_if_fail (GEARY_DB_IS_STATEMENT (self), 0);
	g_return_val_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()), 0);
	if (geary_db_context_enable_sql_logging) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = geary_db_statement_get_expanded_sql (self);
		_tmp1_ = _tmp0_;
		geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "%s", _tmp1_);
		_g_free0 (_tmp1_);
	}
	_tmp2_ = geary_db_result_new (self, cancellable, &_inner_error0_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp3_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp4_ = -1;
		g_propagate_error (error, _inner_error0_);
		return _tmp4_;
	}
	_tmp5_ = self->priv->_connection;
	_tmp6_ = geary_db_connection_get_last_modified_rows (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEARY_DB_TYPE_CONNECTION, GearyDbConnection));
	_tmp7_ = _tmp6_;
	modified = _tmp7_;
	g_signal_emit (self, geary_db_statement_signals[GEARY_DB_STATEMENT_EXECUTED_SIGNAL], 0);
	result = modified;
	return result;
}

/**
     * index is zero-based.
     */
GearyDbStatement*
geary_db_statement_bind_double (GearyDbStatement* self,
                                gint index,
                                gdouble d,
                                GError** error)
{
	sqlite3_stmt* _tmp0_;
	GearyDbStatement* _tmp1_;
	GError* _inner_error0_ = NULL;
	GearyDbStatement* result;
	g_return_val_if_fail (GEARY_DB_IS_STATEMENT (self), NULL);
	_tmp0_ = self->stmt;
	geary_db_context_throw_on_error (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_DB_TYPE_CONTEXT, GearyDbContext), "Statement.bind_double", sqlite3_bind_double (_tmp0_, index + 1, d), NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp1_ = _g_object_ref0 (self);
	result = _tmp1_;
	return result;
}

/**
     * index is zero-based.
     */
GearyDbStatement*
geary_db_statement_bind_int (GearyDbStatement* self,
                             gint index,
                             gint i,
                             GError** error)
{
	sqlite3_stmt* _tmp0_;
	GearyDbStatement* _tmp1_;
	GError* _inner_error0_ = NULL;
	GearyDbStatement* result;
	g_return_val_if_fail (GEARY_DB_IS_STATEMENT (self), NULL);
	_tmp0_ = self->stmt;
	geary_db_context_throw_on_error (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_DB_TYPE_CONTEXT, GearyDbContext), "Statement.bind_int", sqlite3_bind_int (_tmp0_, index + 1, i), NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp1_ = _g_object_ref0 (self);
	result = _tmp1_;
	return result;
}

/**
     * index is zero-based.
     */
GearyDbStatement*
geary_db_statement_bind_uint (GearyDbStatement* self,
                              gint index,
                              guint u,
                              GError** error)
{
	GearyDbStatement* _tmp0_ = NULL;
	GearyDbStatement* _tmp1_;
	GearyDbStatement* _tmp2_;
	GError* _inner_error0_ = NULL;
	GearyDbStatement* result;
	g_return_val_if_fail (GEARY_DB_IS_STATEMENT (self), NULL);
	_tmp1_ = geary_db_statement_bind_int64 (self, index, (gint64) u, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp2_;
	_g_object_unref0 (_tmp0_);
	return result;
}

/**
     * index is zero-based.
     */
GearyDbStatement*
geary_db_statement_bind_long (GearyDbStatement* self,
                              gint index,
                              glong l,
                              GError** error)
{
	GearyDbStatement* _tmp0_ = NULL;
	GearyDbStatement* _tmp1_;
	GearyDbStatement* _tmp2_;
	GError* _inner_error0_ = NULL;
	GearyDbStatement* result;
	g_return_val_if_fail (GEARY_DB_IS_STATEMENT (self), NULL);
	_tmp1_ = geary_db_statement_bind_int64 (self, index, (gint64) l, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp2_;
	_g_object_unref0 (_tmp0_);
	return result;
}

/**
     * index is zero-based.
     */
GearyDbStatement*
geary_db_statement_bind_int64 (GearyDbStatement* self,
                               gint index,
                               gint64 i64,
                               GError** error)
{
	sqlite3_stmt* _tmp0_;
	GearyDbStatement* _tmp1_;
	GError* _inner_error0_ = NULL;
	GearyDbStatement* result;
	g_return_val_if_fail (GEARY_DB_IS_STATEMENT (self), NULL);
	_tmp0_ = self->stmt;
	geary_db_context_throw_on_error (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_DB_TYPE_CONTEXT, GearyDbContext), "Statement.bind_int64", sqlite3_bind_int64 (_tmp0_, index + 1, i64), NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp1_ = _g_object_ref0 (self);
	result = _tmp1_;
	return result;
}

/**
     * Binds a bool to the column.  A bool is stored as an integer, false == 0, true == 1.  Note
     * that fetching a bool via Result is more lenient; see Result.bool_at() and Result.bool_from().
     *
     * index is zero-based.
     */
GearyDbStatement*
geary_db_statement_bind_bool (GearyDbStatement* self,
                              gint index,
                              gboolean b,
                              GError** error)
{
	gint _tmp0_ = 0;
	GearyDbStatement* _tmp1_ = NULL;
	GearyDbStatement* _tmp2_;
	GearyDbStatement* _tmp3_;
	GError* _inner_error0_ = NULL;
	GearyDbStatement* result;
	g_return_val_if_fail (GEARY_DB_IS_STATEMENT (self), NULL);
	if (b) {
		_tmp0_ = 1;
	} else {
		_tmp0_ = 0;
	}
	_tmp2_ = geary_db_statement_bind_int (self, index, _tmp0_, &_inner_error0_);
	_tmp1_ = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp3_ = _tmp1_;
	_tmp1_ = NULL;
	result = _tmp3_;
	_g_object_unref0 (_tmp1_);
	return result;
}

/**
     * index is zero-based.
     *
     * This will bind the value to the column as an int64 unless it's INVALID_ROWID, in which case
     * the column is bound as NULL.  WARNING: This does *not* work in WHERE clauses. For WHERE, you
     * must use "field IS NULL".
     */
GearyDbStatement*
geary_db_statement_bind_rowid (GearyDbStatement* self,
                               gint index,
                               gint64 rowid,
                               GError** error)
{
	GearyDbStatement* _tmp0_ = NULL;
	GError* _inner_error0_ = NULL;
	GearyDbStatement* result;
	g_return_val_if_fail (GEARY_DB_IS_STATEMENT (self), NULL);
	if (rowid != GEARY_DB_INVALID_ROWID) {
		GearyDbStatement* _tmp1_;
		_tmp1_ = geary_db_statement_bind_int64 (self, index, rowid, &_inner_error0_);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == GEARY_DATABASE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (_tmp0_);
				return NULL;
			} else {
				_g_object_unref0 (_tmp0_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
	} else {
		GearyDbStatement* _tmp2_;
		_tmp2_ = geary_db_statement_bind_null (self, index, &_inner_error0_);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == GEARY_DATABASE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (_tmp0_);
				return NULL;
			} else {
				_g_object_unref0 (_tmp0_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
	}
	result = _tmp0_;
	return result;
}

/**
     * index is zero-based.
     *
     * WARNING: This does *not* work in WHERE clauses. For WHERE, you must use "field IS NULL".
     */
GearyDbStatement*
geary_db_statement_bind_null (GearyDbStatement* self,
                              gint index,
                              GError** error)
{
	sqlite3_stmt* _tmp0_;
	GearyDbStatement* _tmp1_;
	GError* _inner_error0_ = NULL;
	GearyDbStatement* result;
	g_return_val_if_fail (GEARY_DB_IS_STATEMENT (self), NULL);
	_tmp0_ = self->stmt;
	geary_db_context_throw_on_error (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_DB_TYPE_CONTEXT, GearyDbContext), "Statement.bind_null", sqlite3_bind_null (_tmp0_, index + 1), NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp1_ = _g_object_ref0 (self);
	result = _tmp1_;
	return result;
}

/**
     * index is zero-based.
     */
GearyDbStatement*
geary_db_statement_bind_string (GearyDbStatement* self,
                                gint index,
                                const gchar* s,
                                GError** error)
{
	sqlite3_stmt* _tmp0_;
	gchar* _tmp1_;
	GDestroyNotify _tmp2_;
	GearyDbStatement* _tmp3_;
	GError* _inner_error0_ = NULL;
	GearyDbStatement* result;
	g_return_val_if_fail (GEARY_DB_IS_STATEMENT (self), NULL);
	_tmp0_ = self->stmt;
	_tmp1_ = g_strdup (s);
	_tmp2_ = g_free;
	geary_db_context_throw_on_error (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_DB_TYPE_CONTEXT, GearyDbContext), "Statement.bind_string", sqlite3_bind_text (_tmp0_, index + 1, _tmp1_, -1, _tmp2_), NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp3_ = _g_object_ref0 (self);
	result = _tmp3_;
	return result;
}

/**
     * Binds the string representation of a {@link Memory.Buffer} to the replacement value
     * in the {@link Statement}.
     *
     * If buffer supports {@link Memory.UnownedStringBuffer}, the unowned string will be used
     * to avoid a memory copy.  However, this means the Statement will hold a reference to the
     * buffer until the Statement is destroyed.
     *
     * index is zero-based.
     */
GearyDbStatement*
geary_db_statement_bind_string_buffer (GearyDbStatement* self,
                                       gint index,
                                       GearyMemoryBuffer* buffer,
                                       GError** error)
{
	GearyMemoryUnownedStringBuffer* unowned_buffer = NULL;
	GearyMemoryUnownedStringBuffer* _tmp3_;
	GearyMemoryUnownedStringBuffer* _tmp4_;
	GeeHashSet* _tmp9_;
	GearyMemoryUnownedStringBuffer* _tmp10_;
	sqlite3_stmt* _tmp11_;
	GearyMemoryUnownedStringBuffer* _tmp12_;
	const gchar* _tmp13_;
	GearyDbStatement* _tmp14_;
	GError* _inner_error0_ = NULL;
	GearyDbStatement* result;
	g_return_val_if_fail (GEARY_DB_IS_STATEMENT (self), NULL);
	g_return_val_if_fail ((buffer == NULL) || GEARY_MEMORY_IS_BUFFER (buffer), NULL);
	if (buffer == NULL) {
		GearyDbStatement* _tmp0_ = NULL;
		GearyDbStatement* _tmp1_;
		GearyDbStatement* _tmp2_;
		_tmp1_ = geary_db_statement_bind_string (self, index, NULL, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == GEARY_DATABASE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		result = _tmp2_;
		_g_object_unref0 (_tmp0_);
		return result;
	}
	_tmp3_ = _g_object_ref0 (GEARY_MEMORY_IS_UNOWNED_STRING_BUFFER (buffer) ? ((GearyMemoryUnownedStringBuffer*) buffer) : NULL);
	unowned_buffer = _tmp3_;
	_tmp4_ = unowned_buffer;
	if (_tmp4_ == NULL) {
		sqlite3_stmt* _tmp5_;
		gchar* _tmp6_;
		GDestroyNotify _tmp7_;
		GearyDbStatement* _tmp8_;
		_tmp5_ = self->stmt;
		_tmp6_ = geary_memory_buffer_to_string (buffer);
		_tmp7_ = g_free;
		geary_db_context_throw_on_error (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_DB_TYPE_CONTEXT, GearyDbContext), "Statement.bind_string_buffer", sqlite3_bind_text (_tmp5_, index + 1, _tmp6_, -1, _tmp7_), NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == GEARY_DATABASE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (unowned_buffer);
				return NULL;
			} else {
				_g_object_unref0 (unowned_buffer);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp8_ = _g_object_ref0 (self);
		result = _tmp8_;
		_g_object_unref0 (unowned_buffer);
		return result;
	}
	_tmp9_ = self->priv->held_buffers;
	_tmp10_ = unowned_buffer;
	gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEARY_MEMORY_TYPE_BUFFER, GearyMemoryBuffer));
	_tmp11_ = self->stmt;
	_tmp12_ = unowned_buffer;
	_tmp13_ = geary_memory_unowned_string_buffer_to_unowned_string (_tmp12_);
	sqlite3_bind_text (_tmp11_, index + 1, _tmp13_, -1, NULL);
	_tmp14_ = _g_object_ref0 (self);
	result = _tmp14_;
	_g_object_unref0 (unowned_buffer);
	return result;
}

/** {@inheritDoc} */
static GearyLoggingState*
geary_db_statement_real_to_logging_state (GearyDbContext* base)
{
	GearyDbStatement * self;
	const gchar* _tmp0_;
	GearyLoggingState* _tmp1_;
	GearyLoggingState* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_DB_TYPE_STATEMENT, GearyDbStatement);
	_tmp0_ = self->priv->_sql;
	_tmp1_ = geary_logging_state_new (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "%s", _tmp0_);
	result = _tmp1_;
	return result;
}

static GearyDbStatement*
geary_db_statement_real_get_statement (GearyDbContext* base)
{
	GearyDbStatement * self;
	GearyDbStatement* _tmp0_;
	GearyDbStatement* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_DB_TYPE_STATEMENT, GearyDbStatement);
	_tmp0_ = _g_object_ref0 (self);
	result = _tmp0_;
	return result;
}

static void
geary_db_statement_class_init (GearyDbStatementClass * klass,
                               gpointer klass_data)
{
	geary_db_statement_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyDbStatement_private_offset);
	((GearyDbContextClass *) klass)->to_logging_state = (GearyLoggingState* (*) (GearyDbContext*)) geary_db_statement_real_to_logging_state;
	((GearyDbContextClass *) klass)->get_statement = (GearyDbStatement* (*) (GearyDbContext*)) geary_db_statement_real_get_statement;
	GEARY_DB_CONTEXT_CLASS (klass)->get_logging_parent = geary_db_statement_real_get_logging_parent;
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_db_statement_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_db_statement_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_db_statement_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_DB_STATEMENT_SQL_PROPERTY, geary_db_statement_properties[GEARY_DB_STATEMENT_SQL_PROPERTY] = g_param_spec_string ("sql", "sql", "sql", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** {@inheritDoc} */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_DB_STATEMENT_LOGGING_PARENT_PROPERTY, geary_db_statement_properties[GEARY_DB_STATEMENT_LOGGING_PARENT_PROPERTY] = g_param_spec_object ("logging-parent", "logging-parent", "logging-parent", GEARY_LOGGING_TYPE_SOURCE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_DB_STATEMENT_CONNECTION_PROPERTY, geary_db_statement_properties[GEARY_DB_STATEMENT_CONNECTION_PROPERTY] = g_param_spec_object ("connection", "connection", "connection", GEARY_DB_TYPE_DATABASE_CONNECTION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Fired when the Statement is executed the first time (after creation or after a reset).
	     */
	geary_db_statement_signals[GEARY_DB_STATEMENT_EXECUTED_SIGNAL] = g_signal_new ("executed", GEARY_DB_TYPE_STATEMENT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	/**
	     * Fired when the Statement is reset.
	     */
	geary_db_statement_signals[GEARY_DB_STATEMENT_WAS_RESET_SIGNAL] = g_signal_new ("was-reset", GEARY_DB_TYPE_STATEMENT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	/**
	     * Fired when the Statement's bindings are cleared.
	     */
	geary_db_statement_signals[GEARY_DB_STATEMENT_BINDINGS_CLEARED_SIGNAL] = g_signal_new ("bindings-cleared", GEARY_DB_TYPE_STATEMENT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
geary_db_statement_instance_init (GearyDbStatement * self,
                                  gpointer klass)
{
	GeeHashSet* _tmp0_;
	self->priv = geary_db_statement_get_instance_private (self);
	self->priv->column_map = NULL;
	_tmp0_ = gee_hash_set_new (GEARY_MEMORY_TYPE_BUFFER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->held_buffers = _tmp0_;
}

static void
geary_db_statement_finalize (GObject * obj)
{
	GearyDbStatement * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_DB_TYPE_STATEMENT, GearyDbStatement);
	_g_free0 (self->priv->_sql);
	_g_object_unref0 (self->priv->_connection);
	_sqlite3_finalize0 (self->stmt);
	_g_object_unref0 (self->priv->column_map);
	_g_object_unref0 (self->priv->held_buffers);
	G_OBJECT_CLASS (geary_db_statement_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
geary_db_statement_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyDbStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_db_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyDbStatement), 0, (GInstanceInitFunc) geary_db_statement_instance_init, NULL };
	GType geary_db_statement_type_id;
	geary_db_statement_type_id = g_type_register_static (GEARY_DB_TYPE_CONTEXT, "GearyDbStatement", &g_define_type_info, 0);
	GearyDbStatement_private_offset = g_type_add_instance_private (geary_db_statement_type_id, sizeof (GearyDbStatementPrivate));
	return geary_db_statement_type_id;
}

GType
geary_db_statement_get_type (void)
{
	static gsize geary_db_statement_type_id__once = 0;
	if (g_once_init_enter (&geary_db_statement_type_id__once)) {
		GType geary_db_statement_type_id;
		geary_db_statement_type_id = geary_db_statement_get_type_once ();
		g_once_init_leave (&geary_db_statement_type_id__once, geary_db_statement_type_id);
	}
	return geary_db_statement_type_id__once;
}

static void
_vala_geary_db_statement_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	GearyDbStatement * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_DB_TYPE_STATEMENT, GearyDbStatement);
	switch (property_id) {
		case GEARY_DB_STATEMENT_SQL_PROPERTY:
		g_value_set_string (value, geary_db_statement_get_sql (self));
		break;
		case GEARY_DB_STATEMENT_LOGGING_PARENT_PROPERTY:
		g_value_set_object (value, geary_db_context_get_logging_parent (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_DB_TYPE_CONTEXT, GearyDbContext)));
		break;
		case GEARY_DB_STATEMENT_CONNECTION_PROPERTY:
		g_value_set_object (value, geary_db_statement_get_connection (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_db_statement_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	GearyDbStatement * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_DB_TYPE_STATEMENT, GearyDbStatement);
	switch (property_id) {
		case GEARY_DB_STATEMENT_SQL_PROPERTY:
		geary_db_statement_set_sql (self, g_value_get_string (value));
		break;
		case GEARY_DB_STATEMENT_CONNECTION_PROPERTY:
		geary_db_statement_set_connection (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

