/* imap-authenticate-command.c generated by valac 0.56.3, the Vala compiler
 * generated from imap-authenticate-command.vala, do not modify */

/*
 * Copyright 2018 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>

#define GEARY_IMAP_AUTHENTICATE_COMMAND_OAUTH2_METHOD "xoauth2"
#define GEARY_IMAP_AUTHENTICATE_COMMAND_OAUTH2_RESP "user=%s\001auth=Bearer %s\001\001"

enum  {
	GEARY_IMAP_AUTHENTICATE_COMMAND_0_PROPERTY,
	GEARY_IMAP_AUTHENTICATE_COMMAND_METHOD_PROPERTY,
	GEARY_IMAP_AUTHENTICATE_COMMAND_NUM_PROPERTIES
};
static GParamSpec* geary_imap_authenticate_command_properties[GEARY_IMAP_AUTHENTICATE_COMMAND_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _GearyImapAuthenticateCommandSendData GearyImapAuthenticateCommandSendData;
typedef struct _GearyImapAuthenticateCommandSendWaitData GearyImapAuthenticateCommandSendWaitData;

struct _GearyImapAuthenticateCommandPrivate {
	gchar* _method;
	GearyImapLiteralParameter* response_literal;
	gboolean serialised;
	GearyNonblockingSpinlock* error_lock;
	GCancellable* error_cancellable;
};

struct _GearyImapAuthenticateCommandSendData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapAuthenticateCommand* self;
	GearyImapSerializer* ser;
	GCancellable* cancellable;
	GError* _inner_error0_;
};

struct _GearyImapAuthenticateCommandSendWaitData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapAuthenticateCommand* self;
	GearyImapSerializer* ser;
	GCancellable* cancellable;
	GearyNonblockingSpinlock* _tmp0_;
	GearyImapLiteralParameter* _tmp1_;
	GearyImapLiteralParameter* _tmp2_;
	GearyMemoryBuffer* _tmp3_;
	GearyMemoryBuffer* _tmp4_;
	gint _tmp5_;
	guint8* _tmp6_;
	guint8* _tmp7_;
	gint _tmp7__length1;
	GError* _inner_error0_;
};

static gint GearyImapAuthenticateCommand_private_offset;
static gpointer geary_imap_authenticate_command_parent_class = NULL;

VALA_EXTERN void geary_imap_command_send (GearyImapCommand* self,
                              GearyImapSerializer* ser,
                              GCancellable* cancellable,
                              GAsyncReadyCallback _callback_,
                              gpointer _user_data_);
VALA_EXTERN void geary_imap_command_send_finish (GearyImapCommand* self,
                                     GAsyncResult* _res_,
                                     GError** error);
VALA_EXTERN void geary_imap_command_send_wait (GearyImapCommand* self,
                                   GearyImapSerializer* ser,
                                   GCancellable* cancellable,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_);
VALA_EXTERN void geary_imap_command_send_wait_finish (GearyImapCommand* self,
                                          GAsyncResult* _res_,
                                          GError** error);
VALA_EXTERN void geary_imap_command_completed (GearyImapCommand* self,
                                   GearyImapStatusResponse* new_status,
                                   GError** error);
VALA_EXTERN void geary_imap_command_continuation_requested (GearyImapCommand* self,
                                                GearyImapContinuationResponse* continuation,
                                                GError** error);
static void geary_imap_authenticate_command_set_method (GearyImapAuthenticateCommand* self,
                                                 const gchar* value);
static GearyImapAuthenticateCommand* geary_imap_authenticate_command_new (const gchar* method,
                                                                   const gchar* data,
                                                                   GCancellable* should_send);
static GearyImapAuthenticateCommand* geary_imap_authenticate_command_construct (GType object_type,
                                                                         const gchar* method,
                                                                         const gchar* data,
                                                                         GCancellable* should_send);
static void geary_imap_authenticate_command_real_send_data_free (gpointer _data);
static void geary_imap_authenticate_command_real_send (GearyImapCommand* base,
                                                GearyImapSerializer* ser,
                                                GCancellable* cancellable,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
static gboolean geary_imap_authenticate_command_real_send_co (GearyImapAuthenticateCommandSendData* _data_);
static void geary_imap_authenticate_command_send_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_);
static gchar* geary_imap_authenticate_command_real_to_string (GearyImapCommand* base);
static void geary_imap_authenticate_command_real_send_wait_data_free (gpointer _data);
static void geary_imap_authenticate_command_real_send_wait (GearyImapCommand* base,
                                                     GearyImapSerializer* ser,
                                                     GCancellable* cancellable,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_);
static gboolean geary_imap_authenticate_command_real_send_wait_co (GearyImapAuthenticateCommandSendWaitData* _data_);
static void geary_imap_authenticate_command_send_wait_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_);
static void geary_imap_authenticate_command_real_completed (GearyImapCommand* base,
                                                     GearyImapStatusResponse* new_status,
                                                     GError** error);
static void geary_imap_authenticate_command_real_continuation_requested (GearyImapCommand* base,
                                                                  GearyImapContinuationResponse* response,
                                                                  GError** error);
static void geary_imap_authenticate_command_real_stop_serialisation (GearyImapCommand* base);
static void geary_imap_authenticate_command_finalize (GObject * obj);
static GType geary_imap_authenticate_command_get_type_once (void);
static void _vala_geary_imap_authenticate_command_get_property (GObject * object,
                                                         guint property_id,
                                                         GValue * value,
                                                         GParamSpec * pspec);
static void _vala_geary_imap_authenticate_command_set_property (GObject * object,
                                                         guint property_id,
                                                         const GValue * value,
                                                         GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
geary_imap_authenticate_command_get_instance_private (GearyImapAuthenticateCommand* self)
{
	return G_STRUCT_MEMBER_P (self, GearyImapAuthenticateCommand_private_offset);
}

const gchar*
geary_imap_authenticate_command_get_method (GearyImapAuthenticateCommand* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_IMAP_IS_AUTHENTICATE_COMMAND (self), NULL);
	_tmp0_ = self->priv->_method;
	result = _tmp0_;
	return result;
}

static void
geary_imap_authenticate_command_set_method (GearyImapAuthenticateCommand* self,
                                            const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (GEARY_IMAP_IS_AUTHENTICATE_COMMAND (self));
	old_value = geary_imap_authenticate_command_get_method (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_method);
		self->priv->_method = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_authenticate_command_properties[GEARY_IMAP_AUTHENTICATE_COMMAND_METHOD_PROPERTY]);
	}
}

static GearyImapAuthenticateCommand*
geary_imap_authenticate_command_construct (GType object_type,
                                           const gchar* method,
                                           const gchar* data,
                                           GCancellable* should_send)
{
	GearyImapAuthenticateCommand * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	GCancellable* _tmp4_;
	GearyNonblockingSpinlock* _tmp5_;
	g_return_val_if_fail (method != NULL, NULL);
	g_return_val_if_fail (data != NULL, NULL);
	g_return_val_if_fail ((should_send == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (should_send, g_cancellable_get_type ()), NULL);
	_tmp0_ = g_strdup (method);
	_tmp1_ = g_strdup (data);
	_tmp2_ = g_new0 (gchar*, 2 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp3__length1 = 2;
	self = (GearyImapAuthenticateCommand*) geary_imap_command_construct (object_type, GEARY_IMAP_AUTHENTICATE_COMMAND_NAME, _tmp3_, (gint) 2, should_send);
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
	geary_imap_authenticate_command_set_method (self, method);
	_tmp4_ = self->priv->error_cancellable;
	_tmp5_ = geary_nonblocking_spinlock_new (_tmp4_);
	_g_object_unref0 (self->priv->error_lock);
	self->priv->error_lock = _tmp5_;
	return self;
}

static GearyImapAuthenticateCommand*
geary_imap_authenticate_command_new (const gchar* method,
                                     const gchar* data,
                                     GCancellable* should_send)
{
	return geary_imap_authenticate_command_construct (GEARY_IMAP_TYPE_AUTHENTICATE_COMMAND, method, data, should_send);
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

GearyImapAuthenticateCommand*
geary_imap_authenticate_command_construct_oauth2 (GType object_type,
                                                  const gchar* user,
                                                  const gchar* token,
                                                  GCancellable* should_send)
{
	GearyImapAuthenticateCommand * self = NULL;
	gchar* encoded_token = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	gint _tmp3_ = 0;
	guint8* _tmp4_;
	gint _tmp4__length1;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_val_if_fail (user != NULL, NULL);
	g_return_val_if_fail (token != NULL, NULL);
	g_return_val_if_fail ((should_send == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (should_send, g_cancellable_get_type ()), NULL);
	_tmp0_ = g_strdup_printf (GEARY_IMAP_AUTHENTICATE_COMMAND_OAUTH2_RESP, user, token);
	_tmp1_ = _tmp0_;
	_tmp2_ = string_get_data (_tmp1_, &_tmp3_);
	_tmp2__length1 = _tmp3_;
	_tmp4_ = _tmp2_;
	_tmp4__length1 = _tmp2__length1;
	_tmp5_ = g_base64_encode (_tmp4_, (gint) _tmp4__length1);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp1_);
	encoded_token = _tmp6_;
	self = (GearyImapAuthenticateCommand*) geary_imap_authenticate_command_construct (object_type, GEARY_IMAP_AUTHENTICATE_COMMAND_OAUTH2_METHOD, encoded_token, should_send);
	_g_free0 (encoded_token);
	return self;
}

GearyImapAuthenticateCommand*
geary_imap_authenticate_command_new_oauth2 (const gchar* user,
                                            const gchar* token,
                                            GCancellable* should_send)
{
	return geary_imap_authenticate_command_construct_oauth2 (GEARY_IMAP_TYPE_AUTHENTICATE_COMMAND, user, token, should_send);
}

static void
geary_imap_authenticate_command_real_send_data_free (gpointer _data)
{
	GearyImapAuthenticateCommandSendData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->ser);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapAuthenticateCommandSendData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
geary_imap_authenticate_command_real_send (GearyImapCommand* base,
                                           GearyImapSerializer* ser,
                                           GCancellable* cancellable,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	GearyImapAuthenticateCommand * self;
	GearyImapAuthenticateCommandSendData* _data_;
	GearyImapAuthenticateCommand* _tmp0_;
	GearyImapSerializer* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (GEARY_IMAP_IS_SERIALIZER (ser));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_TYPE_AUTHENTICATE_COMMAND, GearyImapAuthenticateCommand);
	_data_ = g_slice_new0 (GearyImapAuthenticateCommandSendData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_authenticate_command_real_send_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (ser);
	_g_object_unref0 (_data_->ser);
	_data_->ser = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	geary_imap_authenticate_command_real_send_co (_data_);
}

static void
geary_imap_authenticate_command_send_finish (GearyImapCommand* base,
                                             GAsyncResult* _res_,
                                             GError** error)
{
	GearyImapAuthenticateCommandSendData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
geary_imap_authenticate_command_send_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_)
{
	GearyImapAuthenticateCommandSendData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_authenticate_command_real_send_co (_data_);
}

static gboolean
geary_imap_authenticate_command_real_send_co (GearyImapAuthenticateCommandSendData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	GEARY_IMAP_COMMAND_CLASS (geary_imap_authenticate_command_parent_class)->send (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_IMAP_TYPE_COMMAND, GearyImapCommand), _data_->ser, _data_->cancellable, geary_imap_authenticate_command_send_ready, _data_);
	return FALSE;
	_state_1:
	GEARY_IMAP_COMMAND_CLASS (geary_imap_authenticate_command_parent_class)->send_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_IMAP_TYPE_COMMAND, GearyImapCommand), _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->self->priv->serialised = TRUE;
	_data_->_state_ = 2;
	geary_imap_serializer_flush_stream (_data_->ser, _data_->cancellable, geary_imap_authenticate_command_send_ready, _data_);
	return FALSE;
	_state_2:
	geary_imap_serializer_flush_stream_finish (_data_->ser, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gchar*
geary_imap_authenticate_command_real_to_string (GearyImapCommand* base)
{
	GearyImapAuthenticateCommand * self;
	GearyImapTag* _tmp0_;
	GearyImapTag* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_TYPE_AUTHENTICATE_COMMAND, GearyImapAuthenticateCommand);
	_tmp0_ = geary_imap_command_get_tag (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_COMMAND, GearyImapCommand));
	_tmp1_ = _tmp0_;
	_tmp2_ = geary_imap_parameter_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
	_tmp3_ = _tmp2_;
	_tmp4_ = geary_imap_command_get_name (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_COMMAND, GearyImapCommand));
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->_method;
	_tmp7_ = g_strdup_printf ("%s %s %s <token>", _tmp3_, _tmp5_, _tmp6_);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp3_);
	result = _tmp8_;
	return result;
}

static void
geary_imap_authenticate_command_real_send_wait_data_free (gpointer _data)
{
	GearyImapAuthenticateCommandSendWaitData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->ser);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapAuthenticateCommandSendWaitData, _data_);
}

static void
geary_imap_authenticate_command_real_send_wait (GearyImapCommand* base,
                                                GearyImapSerializer* ser,
                                                GCancellable* cancellable,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	GearyImapAuthenticateCommand * self;
	GearyImapAuthenticateCommandSendWaitData* _data_;
	GearyImapAuthenticateCommand* _tmp0_;
	GearyImapSerializer* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (GEARY_IMAP_IS_SERIALIZER (ser));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_TYPE_AUTHENTICATE_COMMAND, GearyImapAuthenticateCommand);
	_data_ = g_slice_new0 (GearyImapAuthenticateCommandSendWaitData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_authenticate_command_real_send_wait_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (ser);
	_g_object_unref0 (_data_->ser);
	_data_->ser = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	geary_imap_authenticate_command_real_send_wait_co (_data_);
}

static void
geary_imap_authenticate_command_send_wait_finish (GearyImapCommand* base,
                                                  GAsyncResult* _res_,
                                                  GError** error)
{
	GearyImapAuthenticateCommandSendWaitData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
geary_imap_authenticate_command_send_wait_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_)
{
	GearyImapAuthenticateCommandSendWaitData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_authenticate_command_real_send_wait_co (_data_);
}

static gboolean
geary_imap_authenticate_command_real_send_wait_co (GearyImapAuthenticateCommandSendWaitData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->error_lock;
	_data_->_state_ = 1;
	geary_nonblocking_lock_wait_async (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp0_, GEARY_NONBLOCKING_TYPE_LOCK, GearyNonblockingLock), _data_->cancellable, geary_imap_authenticate_command_send_wait_ready, _data_);
	return FALSE;
	_state_1:
	geary_nonblocking_lock_wait_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp0_, GEARY_NONBLOCKING_TYPE_LOCK, GearyNonblockingLock), _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = _data_->self->priv->response_literal;
	if (_data_->_tmp1_ != NULL) {
		_data_->_tmp2_ = _data_->self->priv->response_literal;
		_data_->_tmp3_ = geary_imap_literal_parameter_get_value (_data_->_tmp2_);
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_tmp5_ = 0;
		_data_->_tmp6_ = geary_memory_buffer_get_uint8_array (_data_->_tmp4_, &_data_->_tmp5_);
		_data_->_tmp7_ = _data_->_tmp6_;
		_data_->_tmp7__length1 = _data_->_tmp5_;
		_data_->_state_ = 2;
		geary_imap_serializer_push_literal_data (_data_->ser, _data_->_tmp7_, (gint) _data_->_tmp5_, _data_->cancellable, geary_imap_authenticate_command_send_wait_ready, _data_);
		return FALSE;
		_state_2:
		geary_imap_serializer_push_literal_data_finish (_data_->ser, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp7_ = (g_free (_data_->_tmp7_), NULL);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		geary_imap_serializer_push_eol (_data_->ser, _data_->cancellable, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_state_ = 3;
		geary_imap_serializer_flush_stream (_data_->ser, _data_->cancellable, geary_imap_authenticate_command_send_wait_ready, _data_);
		return FALSE;
		_state_3:
		geary_imap_serializer_flush_stream_finish (_data_->ser, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_state_ = 4;
	geary_imap_command_wait_until_complete (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_IMAP_TYPE_COMMAND, GearyImapCommand), _data_->cancellable, geary_imap_authenticate_command_send_wait_ready, _data_);
	return FALSE;
	_state_4:
	geary_imap_command_wait_until_complete_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_IMAP_TYPE_COMMAND, GearyImapCommand), _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_imap_authenticate_command_real_completed (GearyImapCommand* base,
                                                GearyImapStatusResponse* new_status,
                                                GError** error)
{
	GearyImapAuthenticateCommand * self;
	GearyNonblockingSpinlock* _tmp0_;
	GError* _inner_error0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_TYPE_AUTHENTICATE_COMMAND, GearyImapAuthenticateCommand);
	g_return_if_fail (GEARY_IMAP_IS_STATUS_RESPONSE (new_status));
	_tmp0_ = self->priv->error_lock;
	geary_nonblocking_lock_blind_notify (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEARY_NONBLOCKING_TYPE_LOCK, GearyNonblockingLock));
	GEARY_IMAP_COMMAND_CLASS (geary_imap_authenticate_command_parent_class)->completed (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_COMMAND, GearyImapCommand), new_status, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
geary_imap_authenticate_command_real_continuation_requested (GearyImapCommand* base,
                                                             GearyImapContinuationResponse* response,
                                                             GError** error)
{
	GearyImapAuthenticateCommand * self;
	GError* _inner_error0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_TYPE_AUTHENTICATE_COMMAND, GearyImapAuthenticateCommand);
	g_return_if_fail (GEARY_IMAP_IS_CONTINUATION_RESPONSE (response));
	if (!self->priv->serialised) {
		GEARY_IMAP_COMMAND_CLASS (geary_imap_authenticate_command_parent_class)->continuation_requested (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_COMMAND, GearyImapCommand), response, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	} else {
		gboolean _tmp0_ = FALSE;
		const gchar* _tmp1_;
		GearyMemoryEmptyBuffer* _tmp4_;
		GearyMemoryEmptyBuffer* _tmp5_;
		GearyImapLiteralParameter* _tmp6_;
		GearyNonblockingSpinlock* _tmp7_;
		_tmp1_ = self->priv->_method;
		if (g_strcmp0 (_tmp1_, GEARY_IMAP_AUTHENTICATE_COMMAND_OAUTH2_METHOD) != 0) {
			_tmp0_ = TRUE;
		} else {
			GearyImapLiteralParameter* _tmp2_;
			_tmp2_ = self->priv->response_literal;
			_tmp0_ = _tmp2_ != NULL;
		}
		if (_tmp0_) {
			GError* _tmp3_;
			geary_imap_command_stop_serialisation (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_COMMAND, GearyImapCommand));
			_tmp3_ = g_error_new_literal (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_INVALID, "Unexpected AUTHENTICATE continuation request");
			_inner_error0_ = _tmp3_;
			if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		_tmp4_ = geary_memory_empty_buffer_get_instance ();
		_tmp5_ = _tmp4_;
		_tmp6_ = geary_imap_literal_parameter_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEARY_MEMORY_TYPE_BUFFER, GearyMemoryBuffer));
		_g_object_unref0 (self->priv->response_literal);
		self->priv->response_literal = _tmp6_;
		_tmp7_ = self->priv->error_lock;
		geary_nonblocking_lock_blind_notify (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEARY_NONBLOCKING_TYPE_LOCK, GearyNonblockingLock));
	}
}

static void
geary_imap_authenticate_command_real_stop_serialisation (GearyImapCommand* base)
{
	GearyImapAuthenticateCommand * self;
	GCancellable* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_TYPE_AUTHENTICATE_COMMAND, GearyImapAuthenticateCommand);
	GEARY_IMAP_COMMAND_CLASS (geary_imap_authenticate_command_parent_class)->stop_serialisation (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_COMMAND, GearyImapCommand));
	_tmp0_ = self->priv->error_cancellable;
	g_cancellable_cancel (_tmp0_);
}

static void
geary_imap_authenticate_command_class_init (GearyImapAuthenticateCommandClass * klass,
                                            gpointer klass_data)
{
	geary_imap_authenticate_command_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyImapAuthenticateCommand_private_offset);
	((GearyImapCommandClass *) klass)->send = (void (*) (GearyImapCommand*, GearyImapSerializer*, GCancellable*, GAsyncReadyCallback, gpointer)) geary_imap_authenticate_command_real_send;
	((GearyImapCommandClass *) klass)->send_finish = (void (*) (GearyImapCommand*, GAsyncResult*, GError**)) geary_imap_authenticate_command_send_finish;
	((GearyImapCommandClass *) klass)->to_string = (gchar* (*) (GearyImapCommand*)) geary_imap_authenticate_command_real_to_string;
	((GearyImapCommandClass *) klass)->send_wait = (void (*) (GearyImapCommand*, GearyImapSerializer*, GCancellable*, GAsyncReadyCallback, gpointer)) geary_imap_authenticate_command_real_send_wait;
	((GearyImapCommandClass *) klass)->send_wait_finish = (void (*) (GearyImapCommand*, GAsyncResult*, GError**)) geary_imap_authenticate_command_send_wait_finish;
	((GearyImapCommandClass *) klass)->completed = (void (*) (GearyImapCommand*, GearyImapStatusResponse*, GError**)) geary_imap_authenticate_command_real_completed;
	((GearyImapCommandClass *) klass)->continuation_requested = (void (*) (GearyImapCommand*, GearyImapContinuationResponse*, GError**)) geary_imap_authenticate_command_real_continuation_requested;
	((GearyImapCommandClass *) klass)->stop_serialisation = (void (*) (GearyImapCommand*)) geary_imap_authenticate_command_real_stop_serialisation;
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_imap_authenticate_command_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_imap_authenticate_command_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_imap_authenticate_command_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_AUTHENTICATE_COMMAND_METHOD_PROPERTY, geary_imap_authenticate_command_properties[GEARY_IMAP_AUTHENTICATE_COMMAND_METHOD_PROPERTY] = g_param_spec_string ("method", "method", "method", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_imap_authenticate_command_instance_init (GearyImapAuthenticateCommand * self,
                                               gpointer klass)
{
	GCancellable* _tmp0_;
	self->priv = geary_imap_authenticate_command_get_instance_private (self);
	self->priv->response_literal = NULL;
	self->priv->serialised = FALSE;
	_tmp0_ = g_cancellable_new ();
	self->priv->error_cancellable = _tmp0_;
}

static void
geary_imap_authenticate_command_finalize (GObject * obj)
{
	GearyImapAuthenticateCommand * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_IMAP_TYPE_AUTHENTICATE_COMMAND, GearyImapAuthenticateCommand);
	_g_free0 (self->priv->_method);
	_g_object_unref0 (self->priv->response_literal);
	_g_object_unref0 (self->priv->error_lock);
	_g_object_unref0 (self->priv->error_cancellable);
	G_OBJECT_CLASS (geary_imap_authenticate_command_parent_class)->finalize (obj);
}

/**
 * The IMAP AUTHENTICATE command.
 *
 * See [[http://tools.ietf.org/html/rfc3501#section-6.2.2]]
 */
 G_GNUC_NO_INLINE static GType
geary_imap_authenticate_command_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapAuthenticateCommandClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_authenticate_command_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapAuthenticateCommand), 0, (GInstanceInitFunc) geary_imap_authenticate_command_instance_init, NULL };
	GType geary_imap_authenticate_command_type_id;
	geary_imap_authenticate_command_type_id = g_type_register_static (GEARY_IMAP_TYPE_COMMAND, "GearyImapAuthenticateCommand", &g_define_type_info, 0);
	GearyImapAuthenticateCommand_private_offset = g_type_add_instance_private (geary_imap_authenticate_command_type_id, sizeof (GearyImapAuthenticateCommandPrivate));
	return geary_imap_authenticate_command_type_id;
}

GType
geary_imap_authenticate_command_get_type (void)
{
	static gsize geary_imap_authenticate_command_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_authenticate_command_type_id__once)) {
		GType geary_imap_authenticate_command_type_id;
		geary_imap_authenticate_command_type_id = geary_imap_authenticate_command_get_type_once ();
		g_once_init_leave (&geary_imap_authenticate_command_type_id__once, geary_imap_authenticate_command_type_id);
	}
	return geary_imap_authenticate_command_type_id__once;
}

static void
_vala_geary_imap_authenticate_command_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec)
{
	GearyImapAuthenticateCommand * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_TYPE_AUTHENTICATE_COMMAND, GearyImapAuthenticateCommand);
	switch (property_id) {
		case GEARY_IMAP_AUTHENTICATE_COMMAND_METHOD_PROPERTY:
		g_value_set_string (value, geary_imap_authenticate_command_get_method (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_imap_authenticate_command_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec)
{
	GearyImapAuthenticateCommand * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_TYPE_AUTHENTICATE_COMMAND, GearyImapAuthenticateCommand);
	switch (property_id) {
		case GEARY_IMAP_AUTHENTICATE_COMMAND_METHOD_PROPERTY:
		geary_imap_authenticate_command_set_method (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

