/*
 * Decompiled with CFR 0.152.
 */
package jspecview.source;

import java.io.BufferedReader;
import java.io.IOException;
import javajs.util.SB;
import org.jmol.util.Logger;

public class JDXSourceStreamTokenizer {
    private BufferedReader br;
    String rawLabel;
    private String value;
    int labelLineNo = 0;
    String line;
    private int lineNo;
    public String rawLine;

    JDXSourceStreamTokenizer(BufferedReader bufferedReader) {
        this.br = bufferedReader;
    }

    String peakLabel() {
        return this.nextLabel(false);
    }

    String getLabel() {
        return this.nextLabel(true);
    }

    private String nextLabel(boolean bl) {
        this.rawLabel = null;
        this.value = null;
        while (this.line == null || this.line.length() == 0) {
            block10: {
                try {
                    this.readLine();
                    if (this.line != null) break block10;
                    this.line = "";
                    return null;
                }
                catch (IOException iOException) {
                    this.line = "";
                    return null;
                }
            }
            this.line = this.line.trim();
            if (this.line.startsWith("##")) break;
            this.line = null;
        }
        this.rawLine = this.line;
        int n = this.line.indexOf("=");
        if (n < 0) {
            if (bl) {
                Logger.info("BAD JDX LINE -- no '=' (line " + this.lineNo + "): " + this.line);
            }
            this.rawLabel = this.line;
            if (!bl) {
                this.line = "";
            }
        } else {
            this.rawLabel = this.line.substring(0, n).trim();
            if (bl) {
                this.line = this.line.substring(n + 1);
            }
        }
        this.labelLineNo = this.lineNo;
        if (Logger.debugging) {
            Logger.info(this.rawLabel);
        }
        return JDXSourceStreamTokenizer.cleanLabel(this.rawLabel);
    }

    public static String cleanLabel(String string) {
        if (string == null) {
            return null;
        }
        SB sB = new SB();
        int n = 0;
        while (n < string.length()) {
            switch (string.charAt(n)) {
                case ' ': 
                case '-': 
                case '/': 
                case '\\': 
                case '_': {
                    break;
                }
                default: {
                    sB.appendC(string.charAt(n));
                }
            }
            ++n;
        }
        return sB.toString().toUpperCase();
    }

    public String getValue() {
        if (this.value != null) {
            return this.value;
        }
        SB sB = new SB().append(this.line);
        if (sB.length() > 0) {
            sB.appendC('\n');
        }
        try {
            while (this.readLine() != null) {
                if (this.line.indexOf("##") < 0 || !this.line.trim().startsWith("##")) {
                    sB.append(this.line).appendC('\n');
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            Logger.info(iOException.toString());
        }
        String string = this.value = this.rawLabel.startsWith("##$") ? sB.toString().trim() : JDXSourceStreamTokenizer.trimLines(sB);
        if (Logger.debugging) {
            Logger.info(this.value);
        }
        return this.value;
    }

    public String readLineTrimmed() throws IOException {
        this.readLine();
        if (this.line == null) {
            return null;
        }
        if (this.line.indexOf("$$") < 0) {
            return this.line.trim();
        }
        SB sB = new SB().append(this.line);
        return JDXSourceStreamTokenizer.trimLines(sB);
    }

    String flushLine() {
        SB sB = new SB().append(this.line);
        this.line = null;
        return JDXSourceStreamTokenizer.trimLines(sB);
    }

    private String readLine() throws IOException {
        this.line = this.br.readLine();
        ++this.lineNo;
        return this.line;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String trimLines(SB sB) {
        int n = sB.length();
        int n2 = n - 1;
        int n3 = JDXSourceStreamTokenizer.ptNonWhite(sB, 0, n);
        if (n3 >= n) {
            return "";
        }
        char[] cArray = new char[n - n3];
        int n4 = 0;
        while (n3 < n) {
            block12: {
                int n5 = sB.charAt(n3);
                switch (n5) {
                    case 13: {
                        if (n3 >= n2 || sB.charAt(n3 + 1) != '\n') {
                            n5 = 10;
                            break;
                        }
                        break block12;
                    }
                    case 10: {
                        if (n4 > 0 && cArray[n4 - 1] != '\n') {
                            n4 -= n3 - JDXSourceStreamTokenizer.ptNonSpaceRev(sB, n3) - 1;
                        }
                        ++n3;
                        n3 = JDXSourceStreamTokenizer.ptNonSpace(sB, n3, n) - 1;
                        break;
                    }
                    case 36: {
                        if (n3 >= n2 || sB.charAt(n3 + 1) != '$') break;
                        ++n3;
                        while (++n3 < n && "\n\r".indexOf(sB.charAt(n3)) < 0) {
                        }
                        break block12;
                    }
                }
                if (n5 != 10 || n4 <= 0 || cArray[n4 - 1] != '\n') {
                    cArray[n4++] = n5;
                }
            }
            ++n3;
        }
        if (n4 > 0 && cArray[n4 - 1] == '\n') {
            --n4;
        }
        return new String(cArray).substring(0, n4).trim();
    }

    private static int ptNonWhite(SB sB, int n, int n2) {
        while (n < n2 && Character.isWhitespace(sB.charAt(n))) {
            ++n;
        }
        return n;
    }

    private static int ptNonSpace(SB sB, int n, int n2) {
        while (n < n2 && (sB.charAt(n) == ' ' || sB.charAt(n) == '\t')) {
            ++n;
        }
        return n;
    }

    private static int ptNonSpaceRev(SB sB, int n) {
        while (--n >= 0 && (sB.charAt(n) == ' ' || sB.charAt(n) == '\t')) {
        }
        return n;
    }
}

