/*
 * Decompiled with CFR 0.152.
 */
package jspecview.application;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javajs.util.CU;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jspecview.application.DisplaySchemesProcessor;
import jspecview.common.ColorParameters;
import jspecview.common.JSViewer;
import jspecview.common.ScriptToken;
import jspecview.common.Spectrum;
import jspecview.exception.JSVException;
import jspecview.java.AwtColor;
import jspecview.java.AwtPanel;
import jspecview.java.AwtParameters;
import jspecview.source.JDXReader;
import jspecview.source.JDXSource;

public class PreferencesDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    JPanel contentpanel = new JPanel();
    BorderLayout contentBorderLayout = new BorderLayout();
    JTabbedPane preferencesTabbedPane = new JTabbedPane();
    JPanel generalPanel = new JPanel();
    JPanel displayPanel = new JPanel();
    TitledBorder fontTitledBorder;
    TitledBorder contentTitledBorder;
    JCheckBox confirmExitCheckBox = new JCheckBox();
    JCheckBox statusBarCheckBox = new JCheckBox();
    JCheckBox toolbarCheckBox = new JCheckBox();
    JCheckBox sidePanelCheckBox = new JCheckBox();
    JCheckBox exportDirCheckBox = new JCheckBox();
    JCheckBox openedDirCheckBox = new JCheckBox();
    JCheckBox legendCheckBox = new JCheckBox();
    JCheckBox overlayCheckBox = new JCheckBox();
    JButton clearRecentButton = new JButton();
    JButton cancelButton = new JButton();
    JPanel buttonPanel = new JPanel();
    JButton okButton = new JButton();
    private BorderLayout borderLayout6 = new BorderLayout();
    private DefaultListModel<String> elModel = new DefaultListModel();
    private JPanel topPanel = new JPanel();
    private JPanel displayFontPanel = new JPanel();
    private JPanel colorSchemePanel = new JPanel();
    private JPanel elementPanel = new JPanel();
    private JLabel elementLabel = new JLabel();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JCheckBox defaultFontCheckBox = new JCheckBox();
    private JComboBox<String> fontComboBox = new JComboBox();
    private GridBagLayout gridBagLayout2 = new GridBagLayout();
    private JPanel colorPanel = new JPanel();
    private JComboBox<String> schemeComboBox = new JComboBox();
    private GridLayout gridLayout1 = new GridLayout();
    private JCheckBox defaultColorCheckBox = new JCheckBox();
    private JButton customButton = new JButton();
    private GridBagLayout gridBagLayout3 = new GridBagLayout();
    private JScrollPane listScrollPane = new JScrollPane();
    JList<String> elementList = new JList();
    private JButton colorButton8 = new JButton();
    private JButton colorButton7 = new JButton();
    private JButton colorButton6 = new JButton();
    private JButton colorButton5 = new JButton();
    private JButton colorButton4 = new JButton();
    private JButton colorButton3 = new JButton();
    private JButton colorButton2 = new JButton();
    private JButton colorButton1 = new JButton();
    JButton currentColorButton = new JButton();
    private JPanel processingPanel = new JPanel();
    private GridBagLayout gridBagLayout4 = new GridBagLayout();
    private JButton saveButton = new JButton();
    private GridBagLayout gridBagLayout5 = new GridBagLayout();
    private JPanel integrationPanel = new JPanel();
    private JPanel absTransPanel = new JPanel();
    private GridBagLayout gridBagLayout6 = new GridBagLayout();
    private TitledBorder integratinTitledBorder;
    private JLabel jLabel1 = new JLabel();
    private JTextField minYTextField = new JTextField();
    private JLabel jLabel2 = new JLabel();
    private JTextField integFactorTextField = new JTextField();
    private JLabel jLabel3 = new JLabel();
    private JLabel jLabel4 = new JLabel();
    private JButton processingCustomButton = new JButton();
    private JCheckBox autoIntegrateCheckBox = new JCheckBox();
    private JTextField integOffsetTextField = new JTextField();
    private TitledBorder absTransTitledBorder;
    private JCheckBox separateWindowCheckBox = new JCheckBox();
    private JLabel jLabel5 = new JLabel();
    private JLabel jLabel6 = new JLabel();
    private JLabel jLabel7 = new JLabel();
    private GridBagLayout gridBagLayout7 = new GridBagLayout();
    private JRadioButton TtoARadioButton = new JRadioButton();
    private JRadioButton AtoTRadioButton = new JRadioButton();
    private ButtonGroup conversionButtonGroup = new ButtonGroup();
    ColorParameters currentDS = (ColorParameters)new AwtParameters().setName("Current");
    private DisplaySchemesProcessor dsp;
    private AwtPanel previewPanel = null;
    private String defaultDSName = "";
    private JLabel jLabel8 = new JLabel();
    private JLabel jLabel9 = new JLabel();
    private JCheckBox AutoConvertCheckBox = new JCheckBox();
    JButton plotColorButton = new JButton();
    private JPanel colorPanel1 = new JPanel();
    private JButton procColorButton8 = new JButton();
    private JButton procColorButton7 = new JButton();
    private JButton procColorButton6 = new JButton();
    private JButton procColorButton5 = new JButton();
    private JButton procColorButton4 = new JButton();
    private JButton procColorButton3 = new JButton();
    private JButton procColorButton2 = new JButton();
    private GridLayout gridLayout2 = new GridLayout();
    private JButton procColorButton1 = new JButton();
    private JCheckBox gridCheckBox = new JCheckBox();
    private JCheckBox coordinatesCheckBox = new JCheckBox();
    private JCheckBox scaleXCheckBox = new JCheckBox();
    private JCheckBox svgForInkscapeCheckBox = new JCheckBox();
    private JPanel applicationPanel;
    private JPanel uiPanel;
    private final JPanel spectrumPanel = new JPanel();
    private final JCheckBox spectrumDisplayApplyNowCheckBox = new JCheckBox("Apply to currently opened spectra");
    private Properties preferences;
    private boolean isSpectrumDisplayApplyNowEnabled = false;
    private final JCheckBox scaleYCheckBox = new JCheckBox();
    private final JPanel panel = new JPanel();
    private final JButton deleteButton = new JButton("Delete Scheme");

    public PreferencesDialog(Frame frame, JSViewer viewer, String title, boolean modal, DisplaySchemesProcessor dsp) {
        super(frame, title, modal);
        this.setSize(new Dimension(480, 571));
        this.setLocationRelativeTo(frame);
        this.preferences = viewer.properties;
        this.dsp = dsp;
        this.elModel.addElement("Title");
        this.elModel.addElement("Plot");
        this.elModel.addElement("Scale");
        this.elModel.addElement("Units");
        this.elModel.addElement("Coordinates");
        this.elModel.addElement("PlotArea");
        this.elModel.addElement("Background");
        this.elModel.addElement("Grid");
        try {
            this.jbInit();
            if (dsp != null) {
                this.initDisplayTab(viewer);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.initProcessingTab();
        this.initGeneralTab();
        this.elementList.addListSelectionListener(new ElementListSelectionListener());
        this.elementList.getSelectionModel().setSelectionInterval(0, 0);
        this.setVisible(true);
    }

    void jbInit() throws Exception {
        this.fontTitledBorder = new TitledBorder("");
        this.contentTitledBorder = new TitledBorder("");
        this.integratinTitledBorder = new TitledBorder("");
        this.absTransTitledBorder = new TitledBorder("");
        this.contentpanel.setLayout(this.contentBorderLayout);
        this.fontTitledBorder.setTitle("Font");
        this.fontTitledBorder.setTitleJustification(2);
        this.contentTitledBorder.setTitle("Content");
        this.contentTitledBorder.setTitleJustification(2);
        this.gridCheckBox.setToolTipText("");
        this.gridCheckBox.setText("Show grid");
        this.coordinatesCheckBox.setText("Show coordinates");
        this.scaleXCheckBox.setText("Show X scale");
        this.svgForInkscapeCheckBox.setText("SVG export for Inkscape");
        this.generalPanel.setBorder(BorderFactory.createEtchedBorder());
        this.statusBarCheckBox.setText("Show status bar");
        this.toolbarCheckBox.setText("Show toolbar");
        this.exportDirCheckBox.setText("Remember directory of last exported file");
        this.openedDirCheckBox.setText("Remember directory of last opened file");
        this.legendCheckBox.setText("Automatically show legend when spectra are overlaid");
        this.confirmExitCheckBox.setText("Confirm before exiting");
        this.sidePanelCheckBox.setText("Show side panel");
        this.applicationPanel = new JPanel();
        this.applicationPanel.setLayout(null);
        this.applicationPanel.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "Application", 2, 2, null, Color.BLACK));
        this.applicationPanel.setBounds(12, 5, 437, 157);
        this.generalPanel.add(this.applicationPanel);
        this.uiPanel = new JPanel();
        this.uiPanel.setLayout(null);
        this.uiPanel.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "User Interface", 2, 2, null, Color.BLACK));
        this.uiPanel.setBounds(12, 164, 437, 101);
        this.generalPanel.add(this.uiPanel);
        this.confirmExitCheckBox.setBounds(6, 19, 133, 23);
        this.applicationPanel.add(this.confirmExitCheckBox);
        this.openedDirCheckBox.setBounds(6, 45, 211, 23);
        this.applicationPanel.add(this.openedDirCheckBox);
        this.exportDirCheckBox.setBounds(6, 71, 219, 23);
        this.applicationPanel.add(this.exportDirCheckBox);
        this.svgForInkscapeCheckBox.setBounds(6, 97, 143, 23);
        this.applicationPanel.add(this.svgForInkscapeCheckBox);
        this.clearRecentButton.setBounds(6, 127, 119, 23);
        this.applicationPanel.add(this.clearRecentButton);
        this.clearRecentButton.setText("Clear Recent Files");
        this.overlayCheckBox.setBounds(6, 150, 241, 23);
        this.spectrumPanel.add(this.overlayCheckBox);
        this.legendCheckBox.setBounds(6, 126, 291, 23);
        this.spectrumPanel.add(this.legendCheckBox);
        this.gridCheckBox.setBounds(6, 22, 73, 23);
        this.spectrumPanel.add(this.gridCheckBox);
        this.scaleXCheckBox.setBounds(6, 48, 97, 23);
        this.spectrumPanel.add(this.scaleXCheckBox);
        this.coordinatesCheckBox.setBounds(142, 22, 111, 23);
        this.spectrumPanel.add(this.coordinatesCheckBox);
        this.clearRecentButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferencesDialog.this.clearRecentButton_actionPerformed(e);
            }
        });
        this.sidePanelCheckBox.setBounds(6, 21, 103, 23);
        this.uiPanel.add(this.sidePanelCheckBox);
        this.toolbarCheckBox.setBounds(6, 47, 89, 23);
        this.uiPanel.add(this.toolbarCheckBox);
        this.statusBarCheckBox.setBounds(6, 73, 114, 23);
        this.uiPanel.add(this.statusBarCheckBox);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferencesDialog.this.cancelButton_actionPerformed(e);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferencesDialog.this.okButton_actionPerformed(e);
            }
        });
        this.displayPanel.setLayout(this.borderLayout6);
        this.gridBagLayout4.rowWeights = new double[]{0.0, 1.0};
        this.gridBagLayout4.columnWeights = new double[]{0.0, 0.0, 1.0};
        this.topPanel.setLayout(this.gridBagLayout4);
        this.elementPanel.setBorder(BorderFactory.createEtchedBorder());
        this.elementPanel.setLayout(this.gridBagLayout1);
        this.colorSchemePanel.setBorder(BorderFactory.createEtchedBorder());
        this.colorSchemePanel.setLayout(this.gridBagLayout3);
        this.displayFontPanel.setBorder(BorderFactory.createEtchedBorder());
        this.displayFontPanel.setLayout(this.gridBagLayout2);
        this.elementLabel.setText("Element:");
        this.defaultFontCheckBox.setText("Use Default");
        this.defaultFontCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferencesDialog.this.defaultFontCheckBox_actionPerformed(e);
            }
        });
        this.colorPanel.setLayout(this.gridLayout1);
        this.schemeComboBox.setMaximumSize(new Dimension(200, 21));
        this.schemeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferencesDialog.this.schemeComboBox_actionPerformed(e);
            }
        });
        this.gridLayout1.setHgap(2);
        this.gridLayout1.setRows(2);
        this.gridLayout1.setVgap(2);
        this.defaultColorCheckBox.setText("Use Default");
        this.defaultColorCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferencesDialog.this.defaultColorCheckBox_actionPerformed(e);
            }
        });
        this.customButton.setText("Custom...");
        this.customButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferencesDialog.this.customButton_actionPerformed(e);
            }
        });
        this.elementList.setToolTipText("");
        this.elementList.setModel(this.elModel);
        this.elementList.setSelectionMode(0);
        this.elementList.setVisibleRowCount(4);
        this.listScrollPane.setMinimumSize(new Dimension(125, 110));
        this.listScrollPane.setPreferredSize(new Dimension(125, 110));
        this.addColorButton(this.colorButton1, Color.black);
        this.addColorButton(this.colorButton2, Color.white);
        this.addColorButton(this.colorButton3, Color.gray);
        this.addColorButton(this.colorButton4, Color.blue);
        this.addColorButton(this.colorButton5, Color.red);
        this.addColorButton(this.colorButton6, new Color(0, 0, 64));
        this.addColorButton(this.colorButton7, new Color(0, 92, 0));
        this.addColorButton(this.colorButton8, Color.magenta);
        this.colorButton3.setText(" ");
        this.currentColorButton.setBorder(BorderFactory.createLoweredBevelBorder());
        this.currentColorButton.setMaximumSize(new Dimension(50, 11));
        this.currentColorButton.setMinimumSize(new Dimension(50, 11));
        this.currentColorButton.setPreferredSize(new Dimension(50, 11));
        this.currentColorButton.setMnemonic('0');
        this.processingPanel.setLayout(this.gridBagLayout5);
        this.integrationPanel.setLayout(this.gridBagLayout6);
        this.integrationPanel.setBorder(this.integratinTitledBorder);
        this.integratinTitledBorder.setTitle("Integration");
        this.integratinTitledBorder.setTitleJustification(2);
        this.jLabel1.setText("Integral Factor");
        this.jLabel2.setText("Minimum Y");
        this.jLabel3.setText("Integral Offset");
        this.jLabel4.setText("Plot Color");
        this.processingCustomButton.setPreferredSize(new Dimension(87, 21));
        this.processingCustomButton.setText("Custom...");
        this.processingCustomButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferencesDialog.this.processingCustomButton_actionPerformed(e);
            }
        });
        this.autoIntegrateCheckBox.setText("Automatically Integrate HNMR Spectra");
        this.minYTextField.setMinimumSize(new Dimension(40, 21));
        this.minYTextField.setPreferredSize(new Dimension(40, 21));
        this.integFactorTextField.setMinimumSize(new Dimension(40, 21));
        this.integFactorTextField.setPreferredSize(new Dimension(40, 21));
        this.integOffsetTextField.setMinimumSize(new Dimension(40, 21));
        this.integOffsetTextField.setPreferredSize(new Dimension(40, 21));
        this.absTransPanel.setBorder(this.absTransTitledBorder);
        this.absTransPanel.setLayout(this.gridBagLayout7);
        this.absTransTitledBorder.setTitle("Absorbance/Transmittance");
        this.absTransTitledBorder.setTitleJustification(2);
        this.separateWindowCheckBox.setEnabled(false);
        this.separateWindowCheckBox.setText("Show converted Spectrum in a separate window");
        this.jLabel5.setText("%");
        this.jLabel6.setText("%");
        this.jLabel7.setText("%");
        this.TtoARadioButton.setSelected(true);
        this.TtoARadioButton.setText("Transmittance to Absorbance");
        this.AtoTRadioButton.setText("Absorbance to Transmittance");
        this.colorPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        this.jLabel8.setText("Color Scheme:");
        this.jLabel9.setText("Font:");
        this.fontComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferencesDialog.this.fontComboBox_actionPerformed(e);
            }
        });
        this.AutoConvertCheckBox.setToolTipText("");
        this.AutoConvertCheckBox.setText("Automatically Convert");
        this.plotColorButton.setBackground(Color.green);
        this.plotColorButton.setBorder(null);
        this.plotColorButton.setPreferredSize(new Dimension(30, 21));
        this.colorPanel1.setBorder(BorderFactory.createRaisedBevelBorder());
        this.colorPanel1.setLayout(this.gridLayout2);
        this.addProcColorButton(this.procColorButton1, Color.black);
        this.addProcColorButton(this.procColorButton2, Color.white);
        this.addProcColorButton(this.procColorButton3, Color.gray);
        this.addProcColorButton(this.procColorButton4, Color.blue);
        this.addProcColorButton(this.procColorButton5, Color.red);
        this.addProcColorButton(this.procColorButton6, new Color(0, 0, 64));
        this.addProcColorButton(this.procColorButton7, new Color(0, 92, 0));
        this.addProcColorButton(this.procColorButton8, Color.magenta);
        this.gridLayout2.setHgap(2);
        this.gridLayout2.setRows(2);
        this.gridLayout2.setVgap(2);
        this.displayFontPanel.add(this.fontComboBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.displayFontPanel.add((Component)this.defaultFontCheckBox, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.displayFontPanel.add((Component)this.jLabel9, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 0, 0), 0, 5));
        this.getContentPane().add(this.contentpanel);
        this.contentpanel.add((Component)this.preferencesTabbedPane, "Center");
        this.preferencesTabbedPane.add((Component)this.generalPanel, "General");
        this.preferencesTabbedPane.add((Component)this.displayPanel, "Display Scheme");
        this.displayPanel.add((Component)this.topPanel, "North");
        this.topPanel.add((Component)this.elementPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 5, 5), 13, 0));
        this.elementPanel.add((Component)this.listScrollPane, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 11, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.listScrollPane.setViewportView(this.elementList);
        this.elementPanel.add((Component)this.elementLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.colorSchemePanel.add(this.schemeComboBox, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.colorSchemePanel.add((Component)this.defaultColorCheckBox, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.colorSchemePanel.add((Component)this.customButton, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.colorSchemePanel.add((Component)this.colorPanel, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.colorSchemePanel.add((Component)this.currentColorButton, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 3, new Insets(0, 0, 0, 0), -16, 0));
        this.colorSchemePanel.add((Component)this.jLabel8, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 0, 0), 0, 5));
        this.topPanel.add((Component)this.colorSchemePanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 10, 5, 5), 8, 17));
        this.topPanel.add((Component)this.displayFontPanel, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 10, 5, 1), 8, 36));
        this.preferencesTabbedPane.add((Component)this.processingPanel, "Processing");
        this.processingPanel.add((Component)this.integrationPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 10, 0), 0, 30));
        this.contentpanel.add((Component)this.buttonPanel, "South");
        this.buttonPanel.add((Component)this.okButton, null);
        this.buttonPanel.add((Component)this.cancelButton, null);
        this.generalPanel.setLayout(null);
        this.spectrumPanel.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "Default Spectrum Display Settings", 2, 2, null, new Color(0, 0, 0)));
        this.spectrumPanel.setBounds(12, 266, 437, 184);
        this.generalPanel.add(this.spectrumPanel);
        this.spectrumPanel.setLayout(null);
        this.overlayCheckBox.setText("Show compound files as overlaid if possible");
        JLabel lblTheFollowingProperties = new JLabel("The spectrum display properties above will apply for new spectra");
        lblTheFollowingProperties.setFont(new Font("Tahoma", 2, 11));
        lblTheFollowingProperties.setForeground(Color.DARK_GRAY);
        lblTheFollowingProperties.setBounds(6, 74, 389, 14);
        this.spectrumPanel.add(lblTheFollowingProperties);
        this.spectrumDisplayApplyNowCheckBox.setFont(new Font("Tahoma", 2, 11));
        this.spectrumDisplayApplyNowCheckBox.setForeground(Color.DARK_GRAY);
        this.spectrumDisplayApplyNowCheckBox.setBounds(6, 87, 220, 23);
        this.spectrumPanel.add(this.spectrumDisplayApplyNowCheckBox);
        this.scaleYCheckBox.setText("Show Y scale");
        this.scaleYCheckBox.setSelected(false);
        this.scaleYCheckBox.setBounds(142, 48, 105, 23);
        this.spectrumPanel.add(this.scaleYCheckBox);
        JSeparator separator = new JSeparator();
        separator.setBounds(6, 117, 421, 2);
        this.spectrumPanel.add(separator);
        GridBagConstraints gbc_panel = new GridBagConstraints();
        gbc_panel.gridwidth = 5;
        gbc_panel.fill = 1;
        gbc_panel.gridx = 0;
        gbc_panel.gridy = 1;
        this.topPanel.add((Component)this.panel, gbc_panel);
        this.panel.add(this.saveButton);
        this.saveButton.setText("Save Scheme");
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PreferencesDialog.this.deleteButton_actionPerformed(arg0);
            }
        });
        this.panel.add(this.deleteButton);
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferencesDialog.this.saveButton_actionPerformed(e);
            }
        });
        this.processingPanel.add((Component)this.absTransPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.integrationPanel.add((Component)this.jLabel2, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 10, 0), 0, 0));
        this.integrationPanel.add((Component)this.jLabel1, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 10, 0), 0, 0));
        this.integrationPanel.add((Component)this.autoIntegrateCheckBox, new GridBagConstraints(0, 5, 4, 1, 0.0, 1.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.integrationPanel.add((Component)this.minYTextField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 50, 0, 0), 0, 0));
        this.integrationPanel.add((Component)this.integFactorTextField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 50, 0, 0), 0, 0));
        this.integrationPanel.add((Component)this.jLabel3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.integrationPanel.add((Component)this.integOffsetTextField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 50, 0, 0), 0, 0));
        this.integrationPanel.add((Component)this.jLabel5, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.integrationPanel.add((Component)this.jLabel6, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.integrationPanel.add((Component)this.jLabel7, new GridBagConstraints(2, 2, 1, 2, 0.0, 0.0, 18, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.integrationPanel.add((Component)this.colorPanel1, new GridBagConstraints(2, 3, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.integrationPanel.add((Component)this.jLabel4, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.integrationPanel.add((Component)this.processingCustomButton, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 16, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.integrationPanel.add((Component)this.plotColorButton, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 50, 0, 0), 0, 0));
        this.absTransPanel.add((Component)this.separateWindowCheckBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 147, 0));
        this.absTransPanel.add((Component)this.TtoARadioButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 0), 0, 0));
        this.absTransPanel.add((Component)this.AtoTRadioButton, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 20, 0, 0), 0, 0));
        this.absTransPanel.add((Component)this.AutoConvertCheckBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.conversionButtonGroup.add(this.TtoARadioButton);
        this.conversionButtonGroup.add(this.AtoTRadioButton);
    }

    private void addProcColorButton(JButton btn, Color c) {
        this.colorPanel1.add((Component)btn, null);
        btn.setBackground(c);
        btn.setBorder(BorderFactory.createLoweredBevelBorder());
        btn.setName("pcb");
        btn.addActionListener(this);
        btn.setText(" ");
        btn.setMaximumSize(new Dimension(20, 20));
        btn.setMinimumSize(new Dimension(20, 20));
        btn.setPreferredSize(new Dimension(20, 20));
    }

    private void addColorButton(JButton btn, Color c) {
        this.colorPanel.add((Component)btn, null);
        btn.setBackground(c);
        btn.setBorder(BorderFactory.createLoweredBevelBorder());
        btn.setName("cb");
        btn.addActionListener(this);
    }

    private void initDisplayTab(JSViewer viewer) {
        TreeMap<String, ColorParameters> displaySchemes = this.dsp.getDisplaySchemes();
        this.defaultDSName = this.preferences.getProperty("defaultDisplaySchemeName");
        for (String key : displaySchemes.keySet()) {
            this.schemeComboBox.addItem(key);
        }
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] allFontNames = ge.getAvailableFontFamilyNames();
        for (int i = 0; i < allFontNames.length; ++i) {
            this.fontComboBox.addItem(allFontNames[i]);
        }
        this.schemeComboBox.setSelectedItem(this.defaultDSName);
        try {
            JDXSource source = JDXReader.createJDXSourceFromStream(this.getClass().getResourceAsStream("resources/sample.jdx"), false, false, Float.NaN);
            this.previewPanel = AwtPanel.getPanelOne(viewer, (Spectrum)source.getSpectra().get(0));
            this.previewPanel.getPanelData().setBoolean(ScriptToken.ENABLEZOOM, false);
            this.previewPanel.getPanelData().setBoolean(ScriptToken.GRIDON, true);
            this.previewPanel.getPanelData().setBoolean(ScriptToken.TITLEON, true);
            this.previewPanel.getPanelData().setBoolean(ScriptToken.COORDINATESON, true);
        }
        catch (JSVException ex) {
            ex.printStackTrace();
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
            return;
        }
        if (this.previewPanel != null) {
            this.displayPanel.add((Component)this.previewPanel, "Center");
        } else {
            this.displayPanel.add((Component)new JButton("Error Loading Sample File!"), "Center");
        }
        this.schemeComboBox.setSelectedItem(this.currentDS.name);
        this.fontComboBox.setSelectedItem(this.currentDS.displayFontName);
        this.repaint();
    }

    private void initProcessingTab() {
        this.minYTextField.setText(this.preferences.getProperty("integralMinY"));
        this.integFactorTextField.setText(this.preferences.getProperty("integralFactor"));
        this.integOffsetTextField.setText(this.preferences.getProperty("integralOffset"));
        this.plotColorButton.setBackground(new Color(CU.getArgbFromString(this.preferences.getProperty("integralPlotColor"))));
        this.autoIntegrateCheckBox.setSelected(Boolean.parseBoolean(this.preferences.getProperty("automaticallyIntegrate")));
        String autoConvert = this.preferences.getProperty("automaticTAConversion");
        if (autoConvert.equals("TtoA")) {
            this.TtoARadioButton.setSelected(true);
            this.autoIntegrateCheckBox.setSelected(true);
        } else if (autoConvert.equals("AtoT")) {
            this.AtoTRadioButton.setSelected(true);
            this.autoIntegrateCheckBox.setSelected(true);
        } else {
            this.autoIntegrateCheckBox.setSelected(false);
        }
        this.separateWindowCheckBox.setSelected(Boolean.parseBoolean(this.preferences.getProperty("AtoTSeparateWindow")));
    }

    private void initGeneralTab() {
        this.confirmExitCheckBox.setSelected(Boolean.parseBoolean(this.preferences.getProperty("confirmBeforeExit")));
        this.openedDirCheckBox.setSelected(Boolean.parseBoolean(this.preferences.getProperty("useDirectoryLastOpenedFile")));
        this.exportDirCheckBox.setSelected(Boolean.parseBoolean(this.preferences.getProperty("useDirectoryLastExportedFile")));
        this.svgForInkscapeCheckBox.setSelected(Boolean.parseBoolean(this.preferences.getProperty("svgForInkscape")));
        this.overlayCheckBox.setSelected(Boolean.parseBoolean(this.preferences.getProperty("automaticallyOverlay")));
        this.legendCheckBox.setSelected(Boolean.parseBoolean(this.preferences.getProperty("automaticallyShowLegend")));
        this.gridCheckBox.setSelected(Boolean.parseBoolean(this.preferences.getProperty("showGrid")));
        this.coordinatesCheckBox.setSelected(Boolean.parseBoolean(this.preferences.getProperty("showCoordinates")));
        this.scaleXCheckBox.setSelected(Boolean.parseBoolean(this.preferences.getProperty("showXScale")));
        this.scaleYCheckBox.setSelected(Boolean.parseBoolean(this.preferences.getProperty("showYScale")));
        this.sidePanelCheckBox.setSelected(Boolean.parseBoolean(this.preferences.getProperty("showSidePanel")));
        this.toolbarCheckBox.setSelected(Boolean.parseBoolean(this.preferences.getProperty("showToolBar")));
        this.statusBarCheckBox.setSelected(Boolean.parseBoolean(this.preferences.getProperty("showStatusBar")));
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        JButton button = (JButton)ae.getSource();
        Color color = button.getBackground();
        if (button.getName().equals("cb")) {
            this.currentColorButton.setBackground(color);
            String element = this.elementList.getSelectedValue();
            this.setCurrentColor(element, color);
            this.currentDS.name = "Current";
            this.updatePreviewPanel();
        } else {
            this.plotColorButton.setBackground(color);
        }
    }

    void cancelButton_actionPerformed(ActionEvent e) {
        this.dispose();
    }

    public void setCurrentColor(String element, Color color) {
        this.currentDS.setColor(ScriptToken.getScriptToken(element + "COLOR"), new AwtColor(color.getRGB()));
    }

    void okButton_actionPerformed(ActionEvent e) {
        this.preferences.setProperty("confirmBeforeExit", Boolean.toString(this.confirmExitCheckBox.isSelected()));
        this.preferences.setProperty("automaticallyOverlay", Boolean.toString(this.overlayCheckBox.isSelected()));
        this.preferences.setProperty("automaticallyShowLegend", Boolean.toString(this.legendCheckBox.isSelected()));
        this.preferences.setProperty("useDirectoryLastOpenedFile", Boolean.toString(this.openedDirCheckBox.isSelected()));
        this.preferences.setProperty("useDirectoryLastExportedFile", Boolean.toString(this.exportDirCheckBox.isSelected()));
        this.preferences.setProperty("showSidePanel", Boolean.toString(this.sidePanelCheckBox.isSelected()));
        this.preferences.setProperty("showToolBar", Boolean.toString(this.toolbarCheckBox.isSelected()));
        this.preferences.setProperty("showStatusBar", Boolean.toString(this.statusBarCheckBox.isSelected()));
        this.preferences.setProperty("showGrid", Boolean.toString(this.gridCheckBox.isSelected()));
        this.preferences.setProperty("showCoordinates", Boolean.toString(this.coordinatesCheckBox.isSelected()));
        this.preferences.setProperty("showXScale", Boolean.toString(this.scaleXCheckBox.isSelected()));
        this.preferences.setProperty("showYScale", Boolean.toString(this.scaleYCheckBox.isSelected()));
        this.preferences.setProperty("svgForInkscape", Boolean.toString(this.svgForInkscapeCheckBox.isSelected()));
        this.isSpectrumDisplayApplyNowEnabled = this.spectrumDisplayApplyNowCheckBox.isSelected();
        this.preferences.setProperty("automaticallyIntegrate", Boolean.toString(this.autoIntegrateCheckBox.isSelected()));
        boolean autoTACovert = this.AutoConvertCheckBox.isSelected();
        if (autoTACovert) {
            if (this.TtoARadioButton.isSelected()) {
                this.preferences.setProperty("automaticTAConversion", "TtoA");
            } else {
                this.preferences.setProperty("automaticTAConversion", "AtoT");
            }
        } else {
            this.preferences.setProperty("automaticTAConversion", "false");
        }
        this.preferences.setProperty("AtoTSeparateWindow", Boolean.toString(this.separateWindowCheckBox.isSelected()));
        this.preferences.setProperty("integralMinY", this.minYTextField.getText());
        this.preferences.setProperty("integralFactor", this.integFactorTextField.getText());
        this.preferences.setProperty("integralOffset", this.integOffsetTextField.getText());
        this.preferences.setProperty("integralPlotColor", CU.toRGBHexString(new AwtColor(this.plotColorButton.getBackground().getRGB())));
        this.preferences.setProperty("defaultDisplaySchemeName", this.currentDS.name);
        if (this.currentDS.name.equals("Current")) {
            TreeMap<String, ColorParameters> dispSchemes = this.dsp.getDisplaySchemes();
            dispSchemes.put("Current", this.currentDS);
        }
        this.dispose();
    }

    public Properties getPreferences() {
        return this.preferences;
    }

    void customButton_actionPerformed(ActionEvent e) {
        Color color = JColorChooser.showDialog(this, "Choose Color", Color.BLACK);
        if (color != null) {
            this.currentColorButton.setBackground(color);
            this.setCurrentColor(this.elementList.getSelectedValue(), color);
            this.currentDS.name = "Current";
            this.updatePreviewPanel();
        }
    }

    void deleteButton_actionPerformed(ActionEvent e) {
        int option = JOptionPane.showConfirmDialog(this, "Do you really want to delete '" + this.currentDS.name + "'? This cannot be undone.", "Delete Scheme", 0, 2);
        if (option == 0) {
            TreeMap<String, ColorParameters> dispSchemes = this.dsp.getDisplaySchemes();
            dispSchemes.remove(this.currentDS.name);
            int selectedIndex = this.schemeComboBox.getSelectedIndex();
            this.schemeComboBox.removeItemAt(selectedIndex);
            try {
                this.dsp.store();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "There was an error deleting the Display Scheme", "Error Deleting Scheme", 0);
            }
        }
    }

    void saveButton_actionPerformed(ActionEvent e) {
        String input = "";
        while (input != null && input.equals("")) {
            input = JOptionPane.showInputDialog(this, "Enter the Name of the Display Scheme", "Display Scheme Name", -1);
        }
        if (input == null) {
            return;
        }
        this.currentDS.name = input;
        boolean isdefault = this.defaultFontCheckBox.isSelected();
        if (!isdefault) {
            String fontName;
            this.currentDS.displayFontName = fontName = (String)this.fontComboBox.getSelectedItem();
        }
        TreeMap<String, ColorParameters> dispSchemes = this.dsp.getDisplaySchemes();
        dispSchemes.put(input, this.currentDS);
        try {
            this.dsp.store();
            boolean found = false;
            for (int i = 0; i < this.schemeComboBox.getItemCount(); ++i) {
                String item = this.schemeComboBox.getItemAt(i);
                if (!item.equals(input)) continue;
                found = true;
                break;
            }
            if (!found) {
                this.schemeComboBox.addItem(input);
            }
            this.schemeComboBox.setSelectedItem(input);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "There was an error saving the Display Scheme", "Error Saving Scheme", 0);
        }
    }

    void schemeComboBox_actionPerformed(ActionEvent e) {
        JComboBox schemeCB = (JComboBox)e.getSource();
        String schemeName = (String)schemeCB.getSelectedItem();
        ColorParameters ds = null;
        TreeMap<String, ColorParameters> schemes = this.dsp.getDisplaySchemes();
        for (Map.Entry<String, ColorParameters> entry : schemes.entrySet()) {
            ds = entry.getValue();
            if (!ds.name.equals(schemeName)) continue;
            this.currentDS = ds.copy();
            break;
        }
        this.elementList.getSelectionModel().setSelectionInterval(0, 0);
        String fontName = this.currentDS.displayFontName;
        this.fontComboBox.setSelectedItem(fontName);
        this.currentDS.name = ds.name;
        this.updatePreviewPanel();
    }

    void updatePreviewPanel() {
        if (this.previewPanel != null) {
            this.previewPanel.setColorOrFont(this.currentDS, null);
            this.repaint();
        }
    }

    void fontComboBox_actionPerformed(ActionEvent e) {
        String fontName;
        this.currentDS.displayFontName = fontName = (String)((JComboBox)e.getSource()).getSelectedItem();
        this.currentDS.name = "Current";
        this.updatePreviewPanel();
    }

    void defaultFontCheckBox_actionPerformed(ActionEvent e) {
        JCheckBox cb = (JCheckBox)e.getSource();
        if (cb.isSelected()) {
            this.fontComboBox.setSelectedItem("Default");
            this.fontComboBox.setEnabled(false);
            this.currentDS.displayFontName = "Default";
            this.currentDS.name = "Current";
            this.updatePreviewPanel();
        } else {
            this.fontComboBox.setEnabled(true);
        }
    }

    void defaultColorCheckBox_actionPerformed(ActionEvent e) {
        JCheckBox cb = (JCheckBox)e.getSource();
        if (cb.isSelected()) {
            this.schemeComboBox.setSelectedItem("Default");
            this.schemeComboBox.setEnabled(false);
            this.customButton.setEnabled(false);
            this.saveButton.setEnabled(false);
            this.colorButton1.setEnabled(false);
            this.colorButton2.setEnabled(false);
            this.colorButton3.setEnabled(false);
            this.colorButton4.setEnabled(false);
            this.colorButton5.setEnabled(false);
            this.colorButton6.setEnabled(false);
            this.colorButton7.setEnabled(false);
            this.colorButton8.setEnabled(false);
            this.updatePreviewPanel();
        } else {
            this.schemeComboBox.setEnabled(true);
            this.colorPanel.setEnabled(true);
            this.customButton.setEnabled(true);
            this.saveButton.setEnabled(true);
            this.colorButton1.setEnabled(true);
            this.colorButton2.setEnabled(true);
            this.colorButton3.setEnabled(true);
            this.colorButton4.setEnabled(true);
            this.colorButton5.setEnabled(true);
            this.colorButton6.setEnabled(true);
            this.colorButton7.setEnabled(true);
            this.colorButton8.setEnabled(true);
        }
    }

    public ColorParameters getSelectedDisplayScheme() {
        return this.currentDS;
    }

    void clearRecentButton_actionPerformed(ActionEvent e) {
        int option = JOptionPane.showConfirmDialog(this, "Recent File Paths will be cleared!", "Warning", 2, 2);
        if (option == 0) {
            this.preferences.setProperty("recentFilePaths", "");
        }
    }

    void processingCustomButton_actionPerformed(ActionEvent e) {
        Color color = JColorChooser.showDialog(this, "Choose Color", Color.BLACK);
        if (color != null) {
            this.plotColorButton.setBackground(color);
        }
    }

    public boolean shouldApplySpectrumDisplaySettingsNow() {
        return this.isSpectrumDisplayApplyNowEnabled;
    }

    class ElementListSelectionListener
    implements ListSelectionListener {
        ElementListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent lse) {
            PreferencesDialog.this.currentColorButton.setBackground((Color)((Object)PreferencesDialog.this.currentDS.getElementColor(ScriptToken.getScriptToken((String)((JList)lse.getSource()).getSelectedValue()))));
        }
    }
}

