/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.render;

import org.jmol.modelset.Atom;
import org.jmol.render.ShapeRenderer;
import org.jmol.shape.Shape;
import org.jmol.shape.Stars;

public class StarsRenderer
extends ShapeRenderer {
    private int mar;
    private int width;

    @Override
    protected boolean render() {
        Stars stars = (Stars)this.shape;
        if (stars.mads == null) {
            return false;
        }
        boolean needTranslucent = false;
        this.mar = (int)(this.vwr.getFloat(570425403) * 1000.0f);
        if (this.mar == 0 && (this.g3d.isAntialiased() || this.isExport)) {
            this.mar = 50;
        }
        Atom[] atoms = this.ms.at;
        int i = this.ms.ac;
        while (--i >= 0) {
            Atom atom = atoms[i];
            if (!this.isVisibleForMe(atom)) continue;
            this.colix = Shape.getColix(stars.colixes, i, atom);
            if (this.g3d.setC(this.colix)) {
                this.render1(atom, stars.mads[i]);
                continue;
            }
            needTranslucent = true;
        }
        return needTranslucent;
    }

    private void render1(Atom atom, short mad) {
        int r;
        int x = atom.sX;
        int y = atom.sY;
        int z = atom.sZ;
        int d = (int)this.vwr.tm.scaleToScreen(z, mad);
        if ((r = (d -= d & 1 ^ 1) / 2) < 1) {
            r = 1;
        }
        if (this.mar > 0) {
            this.width = (int)this.vwr.tm.scaleToScreen(z, this.mar);
            if (this.width == 0) {
                this.width = 1;
            }
            if (this.width == 1 && this.g3d.isAntialiased()) {
                this.width = 2;
            }
        } else {
            this.drawLine(x - r - 1, y + 1, z, x - r - 1 + d, y + 1, z);
            this.drawLine(x + 1, y + 1 - r, z, x + 1, y + 1 - r + d, z);
        }
        this.drawLine(x - r, y, z, x - r + d, y, z);
        this.drawLine(x, y - r, z, x, y - r + d, z);
        this.drawLine(x, y, z - r, x, y, z - r + d);
    }

    private void drawLine(int xA, int yA, int zA, int xB, int yB, int zB) {
        if (this.mar > 0) {
            this.g3d.fillCylinderXYZ(this.colix, this.colix, (byte)2, this.width, xA, yA, zA, xB, yB, zB);
        } else {
            this.g3d.drawLineXYZ(xA, yA, zA, xB, yB, zB);
        }
    }
}

