/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.VolumeFileReader;

class ApbsReader
extends VolumeFileReader {
    ApbsReader() {
    }

    @Override
    void init2(SurfaceGenerator sg, BufferedReader br) {
        this.init2VFR(sg, br);
        if (this.params.thePlane == null) {
            this.params.insideOut = !this.params.insideOut;
        }
        this.isAngstroms = true;
        this.nSurfaces = 1;
    }

    @Override
    protected void readParameters() throws Exception {
        this.jvxlFileHeaderBuffer = SB.newS(this.skipComments(false));
        while (this.line != null && this.line.length() == 0) {
            this.rd();
        }
        this.jvxlFileHeaderBuffer.append("APBS OpenDx DATA ").append(this.line).append("\n");
        this.jvxlFileHeaderBuffer.append("see http://apbs.sourceforge.net\n");
        String atomLine = this.rd();
        String[] tokens = PT.getTokens(atomLine);
        if (tokens.length >= 4) {
            this.volumetricOrigin.set(this.parseFloatStr(tokens[1]), this.parseFloatStr(tokens[2]), this.parseFloatStr(tokens[3]));
        }
        VolumeFileReader.checkAtomLine(this.isXLowToHigh, this.isAngstroms, tokens[0], atomLine, this.jvxlFileHeaderBuffer);
        this.readVoxelVector(0);
        this.readVoxelVector(1);
        this.readVoxelVector(2);
        this.rd();
        tokens = this.getTokens();
        for (int i = 0; i < 3; ++i) {
            this.voxelCounts[i] = this.parseIntStr(tokens[i + 5]);
        }
        this.rd();
    }
}

