/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.io.PrintStream;
import org.jmol.util.Logger;
import org.jmol.util.LoggerInterface;

public class DefaultLogger
implements LoggerInterface {
    protected String log(PrintStream out, int level, String txt, Throwable e) {
        if (out == System.err) {
            System.out.flush();
        }
        if (out != null && (txt != null || e != null)) {
            StackTraceElement[] elements;
            txt = txt != null ? txt : "";
            txt = (Logger.logLevel() ? "[" + Logger.getLevel(level) + "] " : "") + txt + (e != null ? ": " + e.toString() : "");
            out.println(txt);
            if (e != null && (elements = e.getStackTrace()) != null) {
                for (int i = 0; i < elements.length; ++i) {
                    out.println(elements[i].getClassName() + " - " + elements[i].getLineNumber() + " - " + elements[i].getMethodName());
                }
            }
        }
        if (out == System.err) {
            System.err.flush();
        }
        return txt;
    }

    @Override
    public void debug(String txt) {
        this.log(System.out, 5, txt, null);
    }

    @Override
    public void info(String txt) {
        this.log(System.out, 4, txt, null);
    }

    @Override
    public void warn(String txt) {
        this.log(System.out, 3, txt, null);
    }

    @Override
    public void warnEx(String txt, Throwable e) {
        this.log(System.out, 3, txt, e);
    }

    @Override
    public void error(String txt) {
        this.log(System.err, 2, txt, null);
    }

    @Override
    public void errorEx(String txt, Throwable e) {
        this.log(System.err, 2, txt, e);
    }

    @Override
    public void fatal(String txt) {
        this.log(System.err, 1, txt, null);
    }

    @Override
    public void fatalEx(String txt, Throwable e) {
        this.log(System.err, 1, txt, e);
    }
}

