##
## This file is part of the libsigrokdecode project.
##
## Copyright (C) 2013-2016 Uwe Hermann <uwe@hermann-uwe.de>
## Copyright (C) 2016 Chris Dreher <chrisdreher@hotmail.com>
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, see <http://www.gnu.org/licenses/>.
##

# Each status byte has 3 string names, each shorter than the previous
status_bytes = {
    # Channel voice messages
    0x80: ['note off', 'note off', 'N off'],
    0x90: ['note on', 'note on', 'N on'], # However, velocity = 0 means "note off".
    0xa0: ['polyphonic key pressure / aftertouch', 'key pressure', 'KP' ],
    0xb0: ['control change', 'ctrl chg', 'CC'],
    0xc0: ['program change', 'prgm chg', 'PC'],
    0xd0: ['channel pressure / aftertouch', 'channel pressure', 'CP'],
    0xe0: ['pitch bend change', 'pitch bend', 'PB'],

    # Channel mode messages
    # 0xb0: 'select channel mode', # Note: Same as 'control change'.

    # System exclusive messages
    0xf0: ['system exclusive', 'SysEx', 'SE'],

    # System common messages
    0xf1: ['MIDI time code quarter frame', 'MIDI time code', 'MIDI time'],
    0xf2: ['song position pointer', 'song position', 'song pos'],
    0xf3: ['song select', 'song select', 'song sel'],
    0xf4: ['undefined 0xf4', 'undef 0xf4', 'undef'],
    0xf5: ['undefined 0xf5', 'undef 0xf5', 'undef'],
    0xf6: ['tune request', 'tune request', 'tune req'],
    0xf7: ['end of system exclusive (EOX)', 'end of SysEx', 'EOX'],

    # System real time messages
    0xf8: ['timing clock', 'timing clock', 'clock'],
    0xf9: ['undefined 0xf9', 'undef 0xf9', 'undef'],
    0xfa: ['start', 'start', 's'],
    0xfb: ['continue', 'continue', 'cont'],
    0xfc: ['stop', 'stop', 'st'],
    0xfd: ['undefined 0xfd', 'undef 0xfd', 'undef'],
    0xfe: ['active sensing', 'active sensing', 'sensing'],
    0xff: ['system reset', 'reset', 'rst'],
}

# Universal system exclusive (SysEx) messages, non-realtime (0x7e)
universal_sysex_nonrealtime = {
    (0x00, None): 'unused',
    (0x01, None): 'sample dump header',
    (0x02, None): 'sample data packet',
    (0x03, None): 'sample dump request',

    (0x04, None): 'MIDI time code',
    (0x04, 0x00): 'special',
    (0x04, 0x01): 'punch in points',
    (0x04, 0x02): 'punch out points',
    (0x04, 0x03): 'delete punch in point',
    (0x04, 0x04): 'delete punch out point',
    (0x04, 0x05): 'event start point',
    (0x04, 0x06): 'event stop point',
    (0x04, 0x07): 'event start points with additional info',
    (0x04, 0x08): 'event stop points with additional info',
    (0x04, 0x09): 'delete event start point',
    (0x04, 0x0a): 'delete event stop point',
    (0x04, 0x0b): 'cue points',
    (0x04, 0x0c): 'cue points with additional info',
    (0x04, 0x0d): 'delete cue point',
    (0x04, 0x0e): 'event name in additional info',

    (0x05, None): 'sample dump extensions',
    (0x05, 0x01): 'multiple loop points',
    (0x05, 0x02): 'loop points request',

    (0x06, None): 'general information',
    (0x06, 0x01): 'identity request',
    (0x06, 0x02): 'identity reply',

    (0x07, None): 'file dump',
    (0x07, 0x01): 'header',
    (0x07, 0x02): 'data packet',
    (0x07, 0x03): 'request',

    (0x08, None): 'MIDI tuning standard',
    (0x08, 0x00): 'bulk dump request',
    (0x08, 0x01): 'bulk dump reply',

    (0x09, None): 'general MIDI',
    (0x09, 0x01): 'general MIDI system on',
    (0x09, 0x02): 'general MIDI system off',

    (0x7b, None): 'end of file',
    (0x7c, None): 'wait',
    (0x7d, None): 'cancel',
    (0x7e, None): 'nak',
    (0x7f, None): 'ack',
}

# Universal system exclusive (SysEx) messages, realtime (0x7f)
universal_sysex_realtime = {
    (0x00, None): 'unused',

    (0x01, None): 'MIDI time code',
    (0x01, 0x01): 'full message',
    (0x01, 0x02): 'user bits',

    (0x02, None): 'MIDI show control',
    (0x02, 0x00): 'MSC extensions',
    # (0x02, TODO): 'TODO', # 0x01 - 0x7f: MSC commands.

    (0x03, None): 'notation information',
    (0x03, 0x01): 'bar number',
    (0x03, 0x02): 'time signature (immediate)',
    (0x03, 0x42): 'time signature (delayed)',

    (0x04, None): 'device control',
    (0x04, 0x01): 'master volume',
    (0x04, 0x02): 'master balance',

    (0x05, None): 'real time MTC cueing',
    (0x05, 0x00): 'special',
    (0x05, 0x01): 'punch in points',
    (0x05, 0x02): 'punch out points',
    (0x05, 0x03): 'reserved',
    (0x05, 0x04): 'reserved',
    (0x05, 0x05): 'event start points',
    (0x05, 0x06): 'event stop points',
    (0x05, 0x07): 'event start points with additional info',
    (0x05, 0x08): 'event stop points with additional info',
    (0x05, 0x09): 'reserved',
    (0x05, 0x0a): 'reserved',
    (0x05, 0x0b): 'cue points',
    (0x05, 0x0c): 'cue points with additional info',
    (0x05, 0x0d): 'reserved',
    (0x05, 0x0e): 'event name in additional info',

    (0x06, None): 'MIDI machine control commands',
    # (0x06, TODO): 'TODO', # 0x00 - 0x7f: MMC commands.

    (0x07, None): 'MIDI machine control responses',
    # (0x07, TODO): 'TODO', # 0x00 - 0x7f: MMC commands.

    (0x08, None): 'MIDI tuning standard',
    (0x85, 0x02): 'note change',
}

# Note: Not all IDs are used/listed, i.e. there are some "holes".
sysex_manufacturer_ids = {
    # American group (range 01-1f, 000001-001f7f)
    (0x01,): 'Sequential',
    (0x02,): 'IDP',
    (0x03,): 'Voyetra/Octave-Plateau',
    (0x04,): 'Moog',
    (0x05,): 'Passport Designs',
    (0x06,): 'Lexicon',
    (0x07,): 'Kurzweil',
    (0x08,): 'Fender',
    (0x09,): 'Gulbransen',
    (0x0a,): 'AKG Acoustics',
    (0x0b,): 'Voyce Music',
    (0x0c,): 'Waveframe Corp',
    (0x0d,): 'ADA Signal Processors',
    (0x0e,): 'Garfield Electronics',
    (0x0f,): 'Ensoniq',
    (0x10,): 'Oberheim',
    (0x11,): 'Apple Computer',
    (0x12,): 'Grey Matter Response',
    (0x13,): 'Digidesign',
    (0x14,): 'Palm Tree Instruments',
    (0x15,): 'JLCooper Electronics',
    (0x16,): 'Lowrey',
    (0x17,): 'Adams-Smith',
    (0x18,): 'Emu Systems',
    (0x19,): 'Harmony Systems',
    (0x1a,): 'ART',
    (0x1b,): 'Baldwin',
    (0x1c,): 'Eventide',
    (0x1d,): 'Inventronics',
    (0x1f,): 'Clarity',

    (0x00, 0x00, 0x01): 'Time Warner Interactive',
    (0x00, 0x00, 0x07): 'Digital Music Corp.',
    (0x00, 0x00, 0x08): 'IOTA Systems',
    (0x00, 0x00, 0x09): 'New England Digital',
    (0x00, 0x00, 0x0a): 'Artisyn',
    (0x00, 0x00, 0x0b): 'IVL Technologies',
    (0x00, 0x00, 0x0c): 'Southern Music Systems',
    (0x00, 0x00, 0x0d): 'Lake Butler Sound Company',
    (0x00, 0x00, 0x0e): 'Alesis',
    (0x00, 0x00, 0x10): 'DOD Electronics',
    (0x00, 0x00, 0x11): 'Studer-Editech',
    (0x00, 0x00, 0x14): 'Perfect Fretworks',
    (0x00, 0x00, 0x15): 'KAT',
    (0x00, 0x00, 0x16): 'Opcode',
    (0x00, 0x00, 0x17): 'Rane Corp.',
    (0x00, 0x00, 0x18): 'Anadi Inc.',
    (0x00, 0x00, 0x19): 'KMX',
    (0x00, 0x00, 0x1a): 'Allen & Heath Brenell',
    (0x00, 0x00, 0x1b): 'Peavy Electronics',
    (0x00, 0x00, 0x1c): '360 Systems',
    (0x00, 0x00, 0x1d): 'Spectrum Design and Development',
    (0x00, 0x00, 0x1e): 'Marquis Music',
    (0x00, 0x00, 0x1f): 'Zeta Systems',

    (0x00, 0x00, 0x20): 'Axxes',
    (0x00, 0x00, 0x21): 'Orban',
    (0x00, 0x00, 0x24): 'KTI',
    (0x00, 0x00, 0x25): 'Breakaway Technologies',
    (0x00, 0x00, 0x26): 'CAE',
    (0x00, 0x00, 0x29): 'Rocktron Corp.',
    (0x00, 0x00, 0x2a): 'PianoDisc',
    (0x00, 0x00, 0x2b): 'Cannon Research Group',
    (0x00, 0x00, 0x2d): 'Rogers Instrument Corp.',
    (0x00, 0x00, 0x2e): 'Blue Sky Logic',
    (0x00, 0x00, 0x2f): 'Encore Electronics',

    (0x00, 0x00, 0x30): 'Uptown',
    (0x00, 0x00, 0x31): 'Voce',
    (0x00, 0x00, 0x32): 'CTI Audio, Inc. (Music. Intel Dev.)',
    (0x00, 0x00, 0x33): 'S&S Research',
    (0x00, 0x00, 0x34): 'Broderbund Software, Inc.',
    (0x00, 0x00, 0x35): 'Allen Organ Co.',
    (0x00, 0x00, 0x37): 'Music Quest',
    (0x00, 0x00, 0x38): 'APHEX',
    (0x00, 0x00, 0x39): 'Gallien Krueger',
    (0x00, 0x00, 0x3a): 'IBM',
    (0x00, 0x00, 0x3c): 'Hotz Instruments Technologies',
    (0x00, 0x00, 0x3d): 'ETA Lighting',
    (0x00, 0x00, 0x3e): 'NSI Corporation',
    (0x00, 0x00, 0x3f): 'Ad Lib, Inc.',

    (0x00, 0x00, 0x40): 'Richmond Sound Design',
    (0x00, 0x00, 0x41): 'Microsoft',
    (0x00, 0x00, 0x42): 'The Software Toolworks',
    (0x00, 0x00, 0x43): 'Niche/RJMG',
    (0x00, 0x00, 0x44): 'Intone',
    (0x00, 0x00, 0x47): 'GT Electronics / Groove Tubes',
    (0x00, 0x00, 0x49): 'Timeline Vista',
    (0x00, 0x00, 0x4a): 'Mesa Boogie',
    (0x00, 0x00, 0x4c): 'Sequoia Development',
    (0x00, 0x00, 0x4d): 'Studio Electronics',
    (0x00, 0x00, 0x4e): 'Euphonix',
    (0x00, 0x00, 0x4f): 'InterMIDI, Inc.',

    (0x00, 0x00, 0x50): 'MIDI Solutions',
    (0x00, 0x00, 0x51): '3DO Company',
    (0x00, 0x00, 0x52): 'Lightwave Research',
    (0x00, 0x00, 0x53): 'Micro-W',
    (0x00, 0x00, 0x54): 'Spectral Synthesis',
    (0x00, 0x00, 0x55): 'Lone Wolf',
    (0x00, 0x00, 0x56): 'Studio Technologies',
    (0x00, 0x00, 0x57): 'Peterson EMP',
    (0x00, 0x00, 0x58): 'Atari',
    (0x00, 0x00, 0x59): 'Marion Systems',
    (0x00, 0x00, 0x5a): 'Design Event',
    (0x00, 0x00, 0x5b): 'Winjammer Software',
    (0x00, 0x00, 0x5c): 'AT&T Bell Labs',
    (0x00, 0x00, 0x5e): 'Symetrix',
    (0x00, 0x00, 0x5f): 'MIDI the World',

    (0x00, 0x00, 0x60): 'Desper Products',
    (0x00, 0x00, 0x61): 'Micros\'N MIDI',
    (0x00, 0x00, 0x62): 'Accordians Intl',
    (0x00, 0x00, 0x63): 'EuPhonics',
    (0x00, 0x00, 0x64): 'Musonix',
    (0x00, 0x00, 0x65): 'Turtle Beach Systems',
    (0x00, 0x00, 0x66): 'Mackie Designs',
    (0x00, 0x00, 0x67): 'Compuserve',
    (0x00, 0x00, 0x68): 'BES Technologies',
    (0x00, 0x00, 0x69): 'QRS Music Rolls',
    (0x00, 0x00, 0x6a): 'P G Music',
    (0x00, 0x00, 0x6b): 'Sierra Semiconductor',
    (0x00, 0x00, 0x6c): 'EpiGraf Audio Visual',
    (0x00, 0x00, 0x6d): 'Electronics Deiversified',
    (0x00, 0x00, 0x6e): 'Tune 1000',
    (0x00, 0x00, 0x6f): 'Advanced Micro Devices',

    (0x00, 0x00, 0x70): 'Mediamation',
    (0x00, 0x00, 0x71): 'Sabine Music',
    (0x00, 0x00, 0x72): 'Woog Labs',
    (0x00, 0x00, 0x73): 'Micropolis',
    (0x00, 0x00, 0x74): 'Ta Horng Musical Inst.',
    (0x00, 0x00, 0x75): 'eTek (formerly Forte)',
    (0x00, 0x00, 0x76): 'Electrovoice',
    (0x00, 0x00, 0x77): 'Midisoft',
    (0x00, 0x00, 0x78): 'Q-Sound Labs',
    (0x00, 0x00, 0x79): 'Westrex',
    (0x00, 0x00, 0x7a): 'NVidia',
    (0x00, 0x00, 0x7b): 'ESS Technology',
    (0x00, 0x00, 0x7c): 'MediaTrix Peripherals',
    (0x00, 0x00, 0x7d): 'Brooktree',
    (0x00, 0x00, 0x7e): 'Otari',
    (0x00, 0x00, 0x7f): 'Key Electronics',

    (0x00, 0x01, 0x01): 'Crystalake Multimedia',
    (0x00, 0x01, 0x02): 'Crystal Semiconductor',
    (0x00, 0x01, 0x03): 'Rockwell Semiconductor',

    # European group (range 20-3f, 002000-003f7f)
    (0x20,): 'Passac',
    (0x21,): 'SIEL',
    (0x22,): 'Synthaxe',
    (0x24,): 'Hohner',
    (0x25,): 'Twister',
    (0x26,): 'Solton',
    (0x27,): 'Jellinghaus MS',
    (0x28,): 'Southworth Music Systems',
    (0x29,): 'PPG',
    (0x2a,): 'JEN',
    (0x2b,): 'SSL Limited',
    (0x2c,): 'Audio Veritrieb',
    (0x2f,): 'Elka',

    (0x30,): 'Dynacord',
    (0x31,): 'Viscount',
    (0x33,): 'Clavia Digital Instruments',
    (0x34,): 'Audio Architecture',
    (0x35,): 'GeneralMusic Corp.',
    (0x39,): 'Soundcraft Electronics',
    (0x3b,): 'Wersi',
    (0x3c,): 'Avab Elektronik Ab',
    (0x3d,): 'Digigram',
    (0x3e,): 'Waldorf Electronics',
    (0x3f,): 'Quasimidi',

    (0x00, 0x20, 0x00): 'Dream',
    (0x00, 0x20, 0x01): 'Strand Lighting',
    (0x00, 0x20, 0x02): 'Amek Systems',
    (0x00, 0x20, 0x04): 'Böhm Electronic',
    (0x00, 0x20, 0x06): 'Trident Audio',
    (0x00, 0x20, 0x07): 'Real World Studio',
    (0x00, 0x20, 0x09): 'Yes Technology',
    (0x00, 0x20, 0x0a): 'Audiomatica',
    (0x00, 0x20, 0x0b): 'Bontempi/Farfisa',
    (0x00, 0x20, 0x0c): 'F.B.T. Elettronica',
    (0x00, 0x20, 0x0d): 'MidiTemp',
    (0x00, 0x20, 0x0e): 'LA Audio (Larking Audio)',
    (0x00, 0x20, 0x0f): 'Zero 88 Lighting Limited',

    (0x00, 0x20, 0x10): 'Micon Audio Electronics GmbH',
    (0x00, 0x20, 0x11): 'Forefront Technology',
    (0x00, 0x20, 0x13): 'Kenton Electronics',
    (0x00, 0x20, 0x15): 'ADB',
    (0x00, 0x20, 0x16): 'Marshall Products',
    (0x00, 0x20, 0x17): 'DDA',
    (0x00, 0x20, 0x18): 'BSS',
    (0x00, 0x20, 0x19): 'MA Lighting Technology',
    (0x00, 0x20, 0x1a): 'Fatar',
    (0x00, 0x20, 0x1b): 'QSC Audio',
    (0x00, 0x20, 0x1c): 'Artisan Classic Organ',
    (0x00, 0x20, 0x1d): 'Orla Spa',
    (0x00, 0x20, 0x1e): 'Pinnacle Audio',
    (0x00, 0x20, 0x1f): 'TC Electronics',

    (0x00, 0x20, 0x20): 'Doepfer Musikelektronik',
    (0x00, 0x20, 0x21): 'Creative Technology Pte',
    (0x00, 0x20, 0x22): 'Minami/Seiyddo',
    (0x00, 0x20, 0x23): 'Goldstar',
    (0x00, 0x20, 0x24): 'Midisoft s.a.s di M. Cima',
    (0x00, 0x20, 0x25): 'Samick',
    (0x00, 0x20, 0x26): 'Penny and Giles',
    (0x00, 0x20, 0x27): 'Acorn Computer',
    (0x00, 0x20, 0x28): 'LSC Electronics',
    (0x00, 0x20, 0x29): 'Novation EMS',
    (0x00, 0x20, 0x2a): 'Samkyung Mechatronics',
    (0x00, 0x20, 0x2b): 'Medeli Electronics',
    (0x00, 0x20, 0x2c): 'Charlie Lab',
    (0x00, 0x20, 0x2d): 'Blue Chip Music Tech',
    (0x00, 0x20, 0x2e): 'BEE OH Corp',

    # Japanese group (range 40-5f, 004000-005f7f)
    (0x40,): 'Kawai',
    (0x41,): 'Roland',
    (0x42,): 'Korg',
    (0x43,): 'Yamaha',
    (0x44,): 'Casio',
    (0x46,): 'Kamiya Studio',
    (0x47,): 'Akai',
    (0x48,): 'Japan Victor',
    (0x49,): 'Mesosha',
    (0x4a,): 'Hoshino Gakki',
    (0x4b,): 'Fujitsu Elect',
    (0x4c,): 'Sony',
    (0x4d,): 'Nisshin Onpa',
    (0x4e,): 'TEAC',
    (0x50,): 'Matsushita Electric',
    (0x51,): 'Fostex',
    (0x52,): 'Zoom',
    (0x53,): 'Midori Electronics',
    (0x54,): 'Matsushita Communication Industrial',
    (0x55,): 'Suzuki Musical Inst. Mfg.',

    # Other (range 60-7c, 006000-007f7f)

    # Special (7d-7f)
    (0x7d,): 'Non-Commercial',
    (0x7e,): 'Universal Non-Realtime',
    (0x7f,): 'Universal Realtime',
}

control_functions = {
    0x00: ['bank select MSB', 'bank MSB', 'bank-M'],
    0x01: ['modulation wheel/lever MSB', 'modulation MSB', 'mod-M'],
    0x02: ['breath controller MSB', 'breath MSB', 'breath-M'],
    # 0x03: undefined MSB
    0x04: ['foot controller MSB', 'foot MSB', 'foot-M'],
    0x05: ['portamento time MSB', 'portamento MSB', 'porta-M'],
    0x06: ['data entry MSB', 'data entry MSB', 'data-M'],
    0x07: ['channel volume MSB (formerly main volume)', 'channel volume MSB', 'ch vol-M'],
    0x08: ['balance MSB', 'bal MSB', 'bal-M'],
    # 0x09: undefined MSB
    0x0a: ['pan MSB', 'pan MSB', 'pan-M'],
    0x0b: ['expression controller MSB', 'expression MSB', 'expr-M'],
    0x0c: ['effect control 1 MSB', 'effect 1 MSB', 'eff-1-M'],
    0x0d: ['effect control 2 MSB', 'effect 2 MSB', 'eff-2-M'],
    # 0x0e-0x0f: undefined MSB
    0x10: ['general purpose controller 1 MSB', 'GP ctrl 1 MSB', 'GPC-1-M'],
    0x11: ['general purpose controller 2 MSB', 'GP ctrl 2 MSB', 'GPC-2-M'],
    0x12: ['general purpose controller 3 MSB', 'GP ctrl 3 MSB', 'GPC-3-M'],
    0x13: ['general purpose controller 4 MSB', 'GP ctrl 4 MSB', 'GPC-4-M'],
    # 0x14-0x1f: undefined MSB
    0x20: ['bank select LSB', 'bank LSB', 'bank-L'],
    0x21: ['modulation wheel/lever LSB', 'modulation LSB', 'mod-L'],
    0x22: ['breath controller LSB', 'breath LSB', 'breath-L'],
    # 0x23: undefined LSB
    0x24: ['foot controller LSB', 'foot LSB', 'foot-L'],
    0x25: ['portamento time LSB', 'portamento LSB', 'porta-L'],
    0x26: ['data entry LSB', 'data entry LSB', 'data-L'],
    0x27: ['channel volume LSB (formerly main volume)', 'channel volume LSB', 'ch vol-L'],
    0x28: ['balance LSB', 'bal LSB', 'bal-L'],
    # 0x29: undefined LSB
    0x2a: ['pan LSB', 'pan LSB', 'pan-L'],
    0x2b: ['expression controller LSB', 'expression LSB', 'expr-L'],
    0x2c: ['effect control 1 LSB', 'effect 1 LSB', 'eff-1-L'],
    0x2d: ['effect control 2 LSB', 'effect 2 LSB', 'eff-2-L'],
    # 0x2e-0x2f: undefined LSB
    0x30: ['general purpose controller 1 LSB', 'GP ctrl 1 LSB', 'GPC-1-L'],
    0x31: ['general purpose controller 2 LSB', 'GP ctrl 2 LSB', 'GPC-2-L'],
    0x32: ['general purpose controller 3 LSB', 'GP ctrl 3 LSB', 'GPC-3-L'],
    0x33: ['general purpose controller 4 LSB', 'GP ctrl 4 LSB', 'GPC-4-L'],
    # 0x34-0x3f: undefined LSB
    0x40: ['damper pedal (sustain)', 'sustain', 'sust'],
    0x41: ['portamento on/off', 'porta on/off', 'porta on/off'],
    0x42: ['sostenuto', 'sostenuto', 'sostenuto'],
    0x43: ['soft pedal', 'soft pedal', 'soft pedal'],
    0x44: ['legato footswitch', 'legato switch', 'legato'], # vv: 00-3f = normal, 40-7f = legato
    0x45: ['hold 2', 'hold 2', 'hold 2'],
    0x46: ['sound controller 1 (default: sound variation)', 'sound ctrl 1', 'snd ctrl 1'],
    0x47: ['sound controller 2 (default: timbre / harmonic intensity)', 'sound ctrl 2', 'snd ctrl 2'],
    0x48: ['sound controller 3 (default: release time)', 'sound ctrl 3', 'snd ctrl 3'],
    0x49: ['sound controller 4 (default: attack time)', 'sound ctrl 4', 'snd ctrl 4'],
    0x4a: ['sound controller 5 (default: brightness)', 'sound ctrl 5', 'snd ctrl 5'],
    0x4b: ['sound controller 6 (GM2 default: decay time)', 'sound ctrl 6', 'snd ctrl 6'],
    0x4c: ['sound controller 7 (GM2 default: vibrato rate)', 'sound ctrl 7', 'snd ctrl 7'],
    0x4d: ['sound controller 8 (GM2 default: vibrato depth)', 'sound ctrl 8', 'snd ctrl 8'],
    0x4e: ['sound controller 9 (GM2 default: vibrato delay)', 'sound ctrl 9', 'snd ctrl 9'],
    0x4f: ['sound controller 10', 'sound ctrl 10', 'snd ctrl 10'],
    0x50: ['general purpose controller 5', 'GP controller 5', 'GPC-5'],
    0x51: ['general purpose controller 6', 'GP controller 6', 'GPC-6'],
    0x52: ['general purpose controller 7', 'GP controller 7', 'GPC-7'],
    0x53: ['general purpose controller 8', 'GP controller 8', 'GPC-8'],
    0x54: ['portamento control', 'portamento ctrl', 'porta ctrl'],
    # 0x55-0x5a: undefined
    0x5b: ['effects 1 depth (formerly external effects depth)', 'effects 1 depth', 'eff 1 depth'],
    0x5c: ['effects 2 depth (formerly tremolo depth)', 'effects 2 depth', 'eff 2 depth'],
    0x5d: ['effects 3 depth (formerly chorus depth)', 'effects 3 depth', 'eff 3 depth'],
    0x5e: ['effects 4 depth (formerly celeste/detune depth)', 'effects 4 depth', 'eff 4 depth'],
    0x5f: ['effects 5 depth (formerly phaser depth)', 'effects 5 depth', 'eff 5 depth'],
    0x60: ['data increment', 'data inc', 'data++'],
    0x61: ['data decrement', 'data dec', 'data--'],
    0x62: ['Non-Registered Parameter Number LSB', 'NRPN LSB', 'NRPN-L'],
    0x63: ['Non-Registered Parameter Number MSB', 'NRPN MSB', 'NRPN-M'],
    0x64: ['Registered Parameter Number LSB', 'RPN LSB', 'RPN-L'],
    0x65: ['Registered Parameter Number MSB', 'RPN MSB', 'RPN-M'],
    # 0x66-0x77: undefined
    # 0x78-0x7f: reserved for channel mode messages
    0x78: ['all sound off', 'all snd off', 'snd off'],
    0x79: ['reset all controllers', 'reset all ctrls', 'reset ctrls'],
    0x7a: ['local control', 'local ctrl', 'local ctrl'],
    0x7b: ['all notes off', 'notes off', 'notes off'],
    0x7c: ['omni mode off', 'omni off', 'omni off'], # all notes off
    0x7d: ['omni mode on', 'omni on', 'omni on'], # all notes off
    0x7e: ['mono mode on', 'mono on', 'mono'], # mono mode on, all notes off
    0x7f: ['poly mode on', 'poly on', 'poly'], # mono mode off, all notes off
}

gm_instruments = {
    1:   'Acoustic Grand Piano',
    2:   'Bright Acoustic Piano',
    3:   'Electric Grand Piano',
    4:   'Honky-tonk Piano',
    5:   'Electric Piano 1',
    6:   'Electric Piano 2',
    7:   'Harpsichord',
    8:   'Clavi',
    9:   'Celesta',
    10:  'Glockenspiel',
    11:  'Music Box',
    12:  'Vibraphone',
    13:  'Marimba',
    14:  'Xylophone',
    15:  'Tubular Bells',
    16:  'Dulcimer',
    17:  'Drawbar Organ',
    18:  'Percussive Organ',
    19:  'Rock Organ',
    20:  'Church Organ',
    21:  'Reed Organ',
    22:  'Accordion',
    23:  'Harmonica',
    24:  'Tango Accordion',
    25:  'Acoustic Guitar (nylon)',
    26:  'Acoustic Guitar (steel)',
    27:  'Electric Guitar (jazz)',
    28:  'Electric Guitar (clean)',
    29:  'Electric Guitar (muted)',
    30:  'Overdriven Guitar',
    31:  'Distortion Guitar',
    32:  'Guitar harmonics',
    33:  'Acoustic Bass',
    34:  'Electric Bass (finger)',
    35:  'Electric Bass (pick)',
    36:  'Fretless Bass',
    37:  'Slap Bass 1',
    38:  'Slap Bass 2',
    39:  'Synth Bass 1',
    40:  'Synth Bass 2',
    41:  'Violin',
    42:  'Viola',
    43:  'Cello',
    44:  'Contrabass',
    45:  'Tremolo Strings',
    46:  'Pizzicato Strings',
    47:  'Orchestral Harp',
    48:  'Timpani',
    49:  'String Ensemble 1',
    50:  'String Ensemble 2',
    51:  'SynthStrings 1',
    52:  'SynthStrings 2',
    53:  'Choir Aahs',
    54:  'Voice Oohs',
    55:  'Synth Voice',
    56:  'Orchestra Hit',
    57:  'Trumpet',
    58:  'Trombone',
    59:  'Tuba',
    60:  'Muted Trumpet',
    61:  'French Horn',
    62:  'Brass Section',
    63:  'SynthBrass 1',
    64:  'SynthBrass 2',
    65:  'Soprano Sax',
    66:  'Alto Sax',
    67:  'Tenor Sax',
    68:  'Baritone Sax',
    69:  'Oboe',
    70:  'English Horn',
    71:  'Bassoon',
    72:  'Clarinet',
    73:  'Piccolo',
    74:  'Flute',
    75:  'Recorder',
    76:  'Pan Flute',
    77:  'Blown Bottle',
    78:  'Shakuhachi',
    79:  'Whistle',
    80:  'Ocarina',
    81:  'Lead 1 (square)',
    82:  'Lead 2 (sawtooth)',
    83:  'Lead 3 (calliope)',
    84:  'Lead 4 (chiff)',
    85:  'Lead 5 (charang)',
    86:  'Lead 6 (voice)',
    87:  'Lead 7 (fifths)',
    88:  'Lead 8 (bass + lead)',
    89:  'Pad 1 (new age)',
    90:  'Pad 2 (warm)',
    91:  'Pad 3 (polysynth)',
    92:  'Pad 4 (choir)',
    93:  'Pad 5 (bowed)',
    94:  'Pad 6 (metallic)',
    95:  'Pad 7 (halo)',
    96:  'Pad 8 (sweep)',
    97:  'FX 1 (rain)',
    98:  'FX 2 (soundtrack)',
    99:  'FX 3 (crystal)',
    100: 'FX 4 (atmosphere)',
    101: 'FX 5 (brightness)',
    102: 'FX 6 (goblins)',
    103: 'FX 7 (echoes)',
    104: 'FX 8 (sci-fi)',
    105: 'Sitar',
    106: 'Banjo',
    107: 'Shamisen',
    108: 'Koto',
    109: 'Kalimba',
    110: 'Bag pipe',
    111: 'Fiddle',
    112: 'Shanai',
    113: 'Tinkle Bell',
    114: 'Agogo',
    115: 'Steel Drums',
    116: 'Woodblock',
    117: 'Taiko Drum',
    118: 'Melodic Tom',
    119: 'Synth Drum',
    120: 'Reverse Cymbal',
    121: 'Guitar Fret Noise',
    122: 'Breath Noise',
    123: 'Seashore',
    124: 'Bird Tweet',
    125: 'Telephone Ring',
    126: 'Helicopter',
    127: 'Applause',
    128: 'Gunshot',
}

drum_kit = {
    1:   'GM Standard Kit',
    9:   'GS Room Kit',
    17:  'GS Power Kit',
    25:  'GS Power Kit',
    26:  'GS TR-808 Kit',
    33:  'GS Jazz Kit',
    41:  'GS Brush Kit',
    49:  'GS Orchestra Kit',
    57:  'GS Sound FX Kit',
    128: 'GS CM-64/CM-32 Kit',
}

# Each quarter frame type has 2 string names, each shorter than the previous
quarter_frame_type = {
    0: ['frame count LS nibble', 'frame LSN'],
    1: ['frame count MS nibble', 'frame MSN'],
    2: ['seconds LS nibble', 'sec LSN'],
    3: ['seconds MS nibble', 'sec MSN'],
    4: ['minutes LS nibble', 'min LSN'],
    5: ['minutes MS nibble', 'min MSN'],
    6: ['hours LS nibble', 'hrs LSN'],
    7: ['hours MS nibble and SMPTE type', 'hrs MSN'],
}

smpte_type = {
    0: '24 fps',
    1: '25 fps',
    2: '30 fps (drop-frame)',
    3: '30 fps (non-drop)',
}

chromatic_notes = {
    0: 'C-1',
    1: 'C#-1',
    2: 'D-1',
    3: 'D#-1',
    4: 'E-1',
    5: 'F-1',
    6: 'F#-1',
    7: 'G-1',
    8: 'G#-1',
    9: 'A-1',
    10: 'A#-1',
    11: 'B-1',
    12: 'C0',
    13: 'C#0',
    14: 'D0',
    15: 'D#0',
    16: 'E0',
    17: 'F0',
    18: 'F#0',
    19: 'G0',
    20: 'G#0',
    21: 'A0',
    22: 'A#0',
    23: 'B0',
    24: 'C1',
    25: 'C#1',
    26: 'D1',
    27: 'D#1',
    28: 'E1',
    29: 'F1',
    30: 'F#1',
    31: 'G1',
    32: 'G#1',
    33: 'A1',
    34: 'A#1',
    35: 'B1',
    36: 'C2',
    37: 'C#2',
    38: 'D2',
    39: 'D#2',
    40: 'E2',
    41: 'F2',
    42: 'F#2',
    43: 'G2',
    44: 'G#2',
    45: 'A2',
    46: 'A#2',
    47: 'B2',
    48: 'C3',
    49: 'C#3',
    50: 'D3',
    51: 'D#3',
    52: 'E3',
    53: 'F3',
    54: 'F#3',
    55: 'G3',
    56: 'G#3',
    57: 'A3',
    58: 'A#3',
    59: 'B3',
    60: 'C4',
    61: 'C#4',
    62: 'D4',
    63: 'D#4',
    64: 'E4',
    65: 'F4',
    66: 'F#4',
    67: 'G4',
    68: 'G#4',
    69: 'A4',
    70: 'A#4',
    71: 'B4',
    72: 'C5',
    73: 'C#5',
    74: 'D5',
    75: 'D#5',
    76: 'E5',
    77: 'F5',
    78: 'F#5',
    79: 'G5',
    80: 'G#5',
    81: 'A5',
    82: 'A#5',
    83: 'B5',
    84: 'C6',
    85: 'C#6',
    86: 'D6',
    87: 'D#6',
    88: 'E6',
    89: 'F6',
    90: 'F#6',
    91: 'G6',
    92: 'G#6',
    93: 'A6',
    94: 'A#6',
    95: 'B6',
    96: 'C7',
    97: 'C#7',
    98: 'D7',
    99: 'D#7',
    100: 'E7',
    101: 'F7',
    102: 'F#7',
    103: 'G7',
    104: 'G#7',
    105: 'A7',
    106: 'A#7',
    107: 'B7',
    108: 'C8',
    109: 'C#8',
    110: 'D8',
    111: 'D#8',
    112: 'E8',
    113: 'F8',
    114: 'F#8',
    115: 'G8',
    116: 'G#8',
    117: 'A8',
    118: 'A#8',
    119: 'B8',
    120: 'C9',
    121: 'C#9',
    122: 'D9',
    123: 'D#9',
    124: 'E9',
    125: 'F9',
    126: 'F#9',
    127: 'G9',
}

percussion_notes = {
    35: 'Acoustic Bass Drum',
    36: 'Bass Drum 1',
    37: 'Side Stick',
    38: 'Acoustic Snare',
    39: 'Hand Clap',
    40: 'Electric Snare',
    41: 'Low Floor Tom',
    42: 'Closed Hi Hat',
    43: 'High Floor Tom',
    44: 'Pedal Hi-Hat',
    45: 'Low Tom',
    46: 'Open Hi-Hat',
    47: 'Low-Mid Tom',
    48: 'Hi Mid Tom',
    49: 'Crash Cymbal 1',
    50: 'High Tom',
    51: 'Ride Cymbal 1',
    52: 'Chinese Cymbal',
    53: 'Ride Bell',
    54: 'Tambourine',
    55: 'Splash Cymbal',
    56: 'Cowbell',
    57: 'Crash Cymbal 2',
    58: 'Vibraslap',
    59: 'Ride Cymbal 2',
    60: 'Hi Bongo',
    61: 'Low Bongo',
    62: 'Mute Hi Conga',
    63: 'Open Hi Conga',
    64: 'Low Conga',
    65: 'High Timbale',
    66: 'Low Timbale',
    67: 'High Agogo',
    68: 'Low Agogo',
    69: 'Cabasa',
    70: 'Maracas',
    71: 'Short Whistle',
    72: 'Long Whistle',
    73: 'Short Guiro',
    74: 'Long Guiro',
    75: 'Claves',
    76: 'Hi Wood Block',
    77: 'Low Wood Block',
    78: 'Mute Cuica',
    79: 'Open Cuica',
    80: 'Mute Triangle',
    81: 'Open Triangle',
}
