import { OlmMachine } from "@matrix-org/matrix-sdk-crypto-nodejs";
import { MatrixClient } from "../MatrixClient";
import { ICryptoRoomInformation } from "./ICryptoRoomInformation";
/**
 * @internal
 */
export declare const SYNC_LOCK_NAME = "sync";
/**
 * @internal
 */
export declare class RustEngine {
    readonly machine: OlmMachine;
    private client;
    readonly lock: any;
    constructor(machine: OlmMachine, client: MatrixClient);
    run(): Promise<void>;
    addTrackedUsers(userIds: string[]): Promise<void>;
    prepareEncrypt(roomId: string, roomInfo: ICryptoRoomInformation): Promise<void>;
    private processKeysClaimRequest;
    private processKeysUploadRequest;
    private processKeysQueryRequest;
    private processToDeviceRequest;
    private actuallyProcessToDeviceRequest;
}
