"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SdkOlmEngine = void 0;
/**
 * A representation of a rust-sdk OlmEngine for the bot-sdk. You should not need to
 * instantiate this yourself.
 * @category Encryption
 */
class SdkOlmEngine {
    constructor(client) {
        this.client = client;
    }
    claimOneTimeKeys(claim) {
        const reconstructed = {};
        for (const userId of Object.keys(claim)) {
            if (!reconstructed[userId])
                reconstructed[userId] = {};
            for (const deviceId of Object.keys(claim[userId])) {
                reconstructed[userId][deviceId] = claim[userId][deviceId];
            }
        }
        return this.client.claimOneTimeKeys(reconstructed);
    }
    queryOneTimeKeys(userIds) {
        return this.client.getUserDevices(userIds);
    }
    uploadOneTimeKeys(body) {
        return this.client.doRequest("POST", "/_matrix/client/r0/keys/upload", null, body);
    }
    getEffectiveJoinedUsersInRoom(roomId) {
        // TODO: Handle pre-shared invite keys too
        return this.client.getJoinedRoomMembers(roomId);
    }
    sendToDevices(eventType, messages) {
        return this.client.sendToDevices(eventType, messages);
    }
}
exports.SdkOlmEngine = SdkOlmEngine;
