import { ICryptoStorageProvider } from "./ICryptoStorageProvider";
import { IAppserviceCryptoStorageProvider } from "./IAppserviceStorageProvider";
import { ICryptoRoomInformation } from "../e2ee/ICryptoRoomInformation";
/**
 * A crypto storage provider for the default rust-sdk store (sled, file-based).
 * @category Storage providers
 */
export declare class RustSdkCryptoStorageProvider implements ICryptoStorageProvider {
    readonly storagePath: string;
    private db;
    /**
     * Creates a new rust-sdk storage provider.
     * @param {string} storagePath The *directory* to persist database details to.
     */
    constructor(storagePath: string);
    getDeviceId(): Promise<string>;
    setDeviceId(deviceId: string): Promise<void>;
    getRoom(roomId: string): Promise<ICryptoRoomInformation>;
    storeRoom(roomId: string, config: ICryptoRoomInformation): Promise<void>;
}
/**
 * An appservice crypto storage provider for the default rust-sdk store (sled, file-based).
 * @category Storage providers
 */
export declare class RustSdkAppserviceCryptoStorageProvider extends RustSdkCryptoStorageProvider implements IAppserviceCryptoStorageProvider {
    private baseStoragePath;
    /**
     * Creates a new rust-sdk storage provider.
     * @param {string} baseStoragePath The *directory* to persist database details to.
     */
    constructor(baseStoragePath: string);
    storageForUser(userId: string): ICryptoStorageProvider;
}
