import { IrcServer } from "../irc/IrcServer";
import { IrcBridge } from "./IrcBridge";
import { MatrixRoom, Intent } from "matrix-appservice-bridge";
import { BridgeRequest } from "../models/BridgeRequest";
import { RoomOrigin } from "../datastore/DataStore";
import { IrcRoom } from "../models/IrcRoom";
interface TrackChannelOpts {
    server: IrcServer;
    ircChannel: string;
    key?: string;
    inviteList?: string[];
    origin: RoomOrigin;
    roomAliasName?: string;
    intent?: Intent;
}
/**
 * Track an IRC channel and create a room for it.
 * @param ircBridge The ircBridge instance
 * @param req The request that triggered the room creation
 * @param opts Information about the room creation request.
 */
export declare function trackChannelAndCreateRoom(ircBridge: IrcBridge, req: BridgeRequest, opts: TrackChannelOpts): Promise<{
    ircRoom: IrcRoom;
    mxRoom: MatrixRoom;
}>;
export {};
