"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InternalOlmMachineFactory = void 0;
const matrix_sdk_crypto_nodejs_1 = require("@turt2live/matrix-sdk-crypto-nodejs");
/**
 * @internal
 */
class InternalOlmMachineFactory {
    constructor(userId, deviceId, engine, storagePath) {
        this.userId = userId;
        this.deviceId = deviceId;
        this.engine = engine;
        this.storagePath = storagePath;
    }
    build() {
        if (InternalOlmMachineFactory.FACTORY_OVERRIDE) {
            return InternalOlmMachineFactory.FACTORY_OVERRIDE(this.userId, this.deviceId, this.engine, this.storagePath);
        }
        return matrix_sdk_crypto_nodejs_1.OlmMachine.withSledBackend(this.userId, this.deviceId, this.engine, this.storagePath);
    }
}
exports.InternalOlmMachineFactory = InternalOlmMachineFactory;
