/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.skins;

import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.fonts.Fonts;
import eu.hansolo.tilesfx.skins.TileSkin;
import eu.hansolo.tilesfx.tools.Helper;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.Text;

public class ClockTileSkin
extends TileSkin {
    private DateTimeFormatter timeFormatter;
    private DateTimeFormatter dateFormatter;
    private DateTimeFormatter dayOfWeekFormatter;
    private Text titleText;
    private Text text;
    private Rectangle timeRect;
    private Text timeText;
    private Text dayOfWeekText;
    private Text dateText;

    public ClockTileSkin(Tile TILE) {
        super(TILE);
    }

    @Override
    protected void initGraphics() {
        super.initGraphics();
        this.currentValueListener = o -> {
            if (this.tile.isRunning()) {
                return;
            }
            this.updateTime(ZonedDateTime.ofInstant(Instant.ofEpochSecond(this.tile.getCurrentTime()), ZoneId.of(ZoneId.systemDefault().getId())));
        };
        this.timeListener = o -> this.updateTime(this.tile.getTime());
        this.timeFormatter = DateTimeFormatter.ofPattern("HH:mm", this.tile.getLocale());
        this.dateFormatter = DateTimeFormatter.ofPattern("dd MMM YYYY", this.tile.getLocale());
        this.dayOfWeekFormatter = DateTimeFormatter.ofPattern("EEEE", this.tile.getLocale());
        this.titleText = new Text("");
        this.titleText.setTextOrigin(VPos.TOP);
        Helper.enableNode((Node)this.titleText, !this.tile.getTitle().isEmpty());
        this.text = new Text(this.tile.getText());
        this.text.setFill((Paint)this.tile.getUnitColor());
        Helper.enableNode((Node)this.text, this.tile.isTextVisible());
        this.timeRect = new Rectangle();
        this.timeText = new Text(this.timeFormatter.format(this.tile.getTime()));
        this.timeText.setTextOrigin(VPos.CENTER);
        this.dateText = new Text(this.dateFormatter.format(this.tile.getTime()));
        this.dayOfWeekText = new Text(this.dayOfWeekFormatter.format(this.tile.getTime()));
        this.getPane().getChildren().addAll((Object[])new Node[]{this.titleText, this.text, this.timeRect, this.timeText, this.dateText, this.dayOfWeekText});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        if (!this.tile.isAnimated()) {
            this.tile.timeProperty().addListener(this.timeListener);
        }
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if ("VISIBILITY".equals(EVENT_TYPE)) {
            Helper.enableNode((Node)this.titleText, !this.tile.getTitle().isEmpty());
            Helper.enableNode((Node)this.text, this.tile.isTextVisible());
        }
    }

    public void updateTime(ZonedDateTime TIME) {
        this.timeText.setText(this.timeFormatter.format(this.tile.getTime()));
        this.timeText.setX((this.width - this.timeText.getLayoutBounds().getWidth()) * 0.5);
        this.timeText.setY(this.height * 0.35);
        this.dayOfWeekText.setText(this.dayOfWeekFormatter.format(TIME));
        this.dayOfWeekText.setX(this.size * 0.05);
        this.dateText.setText(this.dateFormatter.format(TIME));
        this.dateText.setX(this.size * 0.05);
    }

    @Override
    public void dispose() {
        if (!this.tile.isAnimated()) {
            this.tile.timeProperty().removeListener(this.timeListener);
        }
        super.dispose();
    }

    @Override
    protected void resizeDynamicText() {
        double maxWidth = this.width - this.size * 0.1;
        double fontSize = this.size * 0.3;
        this.timeText.setFont(Fonts.latoRegular(fontSize));
        this.timeText.setText(this.timeFormatter.format(this.tile.getTime()));
        Helper.adjustTextSize(this.timeText, maxWidth, fontSize);
        this.timeText.setX((this.width - this.timeText.getLayoutBounds().getWidth()) * 0.5);
        this.timeText.setY(this.size * 0.35);
        fontSize = this.size * 0.1;
        this.dayOfWeekText.setFont(Fonts.latoRegular(fontSize));
        if (this.dayOfWeekText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.dayOfWeekText, maxWidth, fontSize);
        }
        this.dayOfWeekText.setX(this.size * 0.05);
        this.dayOfWeekText.setY(this.height - this.size * 0.275);
        this.dayOfWeekText.setY(this.timeRect.getLayoutBounds().getMaxY() + this.size * 0.11);
        this.dateText.setFont(Fonts.latoRegular(fontSize));
        if (this.dateText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.dateText, maxWidth, fontSize);
        }
        this.dateText.setX(this.size * 0.05);
        this.dateText.setY(this.height - this.size * 0.15);
        this.dateText.setY(this.timeRect.getLayoutBounds().getMaxY() + this.size * 0.235);
    }

    @Override
    protected void resizeStaticText() {
        double maxWidth = this.size * 0.9;
        double fontSize = this.size * this.textSize.factor;
        boolean customFontEnabled = this.tile.isCustomFontEnabled();
        Font customFont = this.tile.getCustomFont();
        Font font = customFontEnabled && customFont != null ? Font.font((String)customFont.getFamily(), (double)fontSize) : Fonts.latoRegular(fontSize);
        this.titleText.setFont(font);
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        switch (this.tile.getTitleAlignment()) {
            default: {
                this.titleText.relocate(this.size * 0.05, this.size * 0.05);
                break;
            }
            case CENTER: {
                this.titleText.relocate((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.05);
                break;
            }
            case RIGHT: {
                this.titleText.relocate(this.width - this.size * 0.05 - this.titleText.getLayoutBounds().getWidth(), this.size * 0.05);
            }
        }
        maxWidth = this.size * 0.9;
        this.text.setText(this.tile.getText());
        this.text.setFont(font);
        if (this.text.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.text, maxWidth, fontSize);
        }
        switch (this.tile.getTextAlignment()) {
            default: {
                this.text.setX(this.size * 0.05);
                break;
            }
            case CENTER: {
                this.text.setX((this.width - this.text.getLayoutBounds().getWidth()) * 0.5);
                break;
            }
            case RIGHT: {
                this.text.setX(this.width - this.size * 0.05 - this.text.getLayoutBounds().getWidth());
            }
        }
        this.text.setY(this.height - this.size * 0.05);
    }

    @Override
    protected void resize() {
        super.resize();
        this.timeRect.setWidth(this.width);
        this.timeRect.setHeight(this.height * 0.4);
        this.timeRect.setX(0.0);
        this.timeRect.setY(this.contentBounds.getY());
    }

    @Override
    protected void redraw() {
        super.redraw();
        this.titleText.setText(this.tile.getTitle());
        this.text.setText(this.tile.getText());
        this.timeFormatter = DateTimeFormatter.ofPattern("HH:mm", this.tile.getLocale());
        this.dateFormatter = DateTimeFormatter.ofPattern("dd MMM YYYY", this.tile.getLocale());
        this.dayOfWeekFormatter = DateTimeFormatter.ofPattern("EEEE", this.tile.getLocale());
        ZonedDateTime time = this.tile.getTime();
        this.updateTime(time);
        this.resizeStaticText();
        this.resizeDynamicText();
        this.titleText.setFill((Paint)this.tile.getTitleColor());
        this.text.setFill((Paint)this.tile.getTextColor());
        this.timeRect.setFill((Paint)this.tile.getBackgroundColor().darker());
        this.timeText.setFill((Paint)this.tile.getTitleColor());
        this.dateText.setFill((Paint)this.tile.getDateColor());
        this.dayOfWeekText.setFill((Paint)this.tile.getDateColor());
    }
}

