/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.skins;

import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.chart.ChartData;
import eu.hansolo.tilesfx.chart.SmoothedChart;
import eu.hansolo.tilesfx.chart.TilesFXSeries;
import eu.hansolo.tilesfx.events.SmoothedChartEvent;
import eu.hansolo.tilesfx.events.TileEvt;
import eu.hansolo.tilesfx.fonts.Fonts;
import eu.hansolo.tilesfx.skins.TileSkin;
import eu.hansolo.tilesfx.tools.Helper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.chart.Axis;
import javafx.scene.chart.XYChart;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.Text;

public class SmoothedChartTileSkin
extends TileSkin {
    private Text titleText;
    private SmoothedChart<String, Number> chart;
    private Axis xAxis;
    private Axis yAxis;
    private EventHandler<SmoothedChartEvent> chartEventEventHandler;

    public SmoothedChartTileSkin(Tile TILE) {
        super(TILE);
    }

    @Override
    protected void initGraphics() {
        super.initGraphics();
        this.chartEventEventHandler = e -> this.tile.fireTileEvt(new TileEvt((Object)this.tile, TileEvt.SELECTED_CHART_DATA, new ChartData(e.getValue())));
        this.titleText = new Text();
        this.titleText.setFill((Paint)this.tile.getTitleColor());
        Helper.enableNode((Node)this.titleText, !this.tile.getTitle().isEmpty());
        this.xAxis = this.tile.getXAxis();
        this.xAxis.setTickLabelsVisible(this.tile.getTickLabelsXVisible());
        this.yAxis = this.tile.getYAxis();
        this.yAxis.setTickLabelsVisible(this.tile.getTickLabelsYVisible());
        this.chart = new SmoothedChart(this.xAxis, this.yAxis);
        this.chart.setSmoothed(this.tile.isSmoothing());
        this.chart.setAnimated(this.tile.isAnimated());
        this.chart.setLegendSide(Side.TOP);
        this.chart.setVerticalZeroLineVisible(false);
        this.chart.setCreateSymbols(false);
        this.chart.setSnapToTicks(this.tile.isSnapToTicks());
        this.chart.setSymbolsVisible(this.tile.getDataPointsVisible());
        if (this.tile.getChartType() == Tile.ChartType.AREA) {
            this.chart.setChartType(SmoothedChart.ChartType.AREA);
        } else {
            this.chart.setChartType(SmoothedChart.ChartType.LINE);
        }
        this.getPane().getChildren().addAll((Object[])new Node[]{this.titleText, this.chart});
        this.chart.getData().setAll((Collection)this.tile.getTilesFXSeries().stream().map(tilesFxSeries -> tilesFxSeries.getSeries()).collect(Collectors.toList()));
        this.tile.getTilesFXSeries().stream().forEach(series -> this.chart.setSeriesColor(series.getSeries(), series.getStroke(), series.getFill(), series.getSymbolBackground(), series.getLegendSymbolFill()));
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        this.chart.addEventHandler(SmoothedChartEvent.DATA_SELECTED, this.chartEventEventHandler);
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if (TileEvt.VISIBILITY.getName().equals(EVENT_TYPE)) {
            this.chart.setSymbolsVisible(this.tile.getDataPointsVisible());
            this.xAxis.setTickLabelsVisible(this.tile.getTickLabelsXVisible());
            this.yAxis.setTickLabelsVisible(this.tile.getTickLabelsYVisible());
        } else if (TileEvt.SERIES.getName().equals(EVENT_TYPE)) {
            if (this.tile.getChartType() == Tile.ChartType.AREA) {
                this.chart.setChartType(SmoothedChart.ChartType.AREA);
            } else {
                this.chart.setChartType(SmoothedChart.ChartType.LINE);
            }
        } else if (TileEvt.SERIES_SET.getName().equals(EVENT_TYPE)) {
            this.chart.getData().setAll((Collection)this.tile.getTilesFXSeries().stream().map(tilesFxSeries -> tilesFxSeries.getSeries()).collect(Collectors.toList()));
            this.tile.getTilesFXSeries().stream().forEach(series -> this.chart.setSeriesColor(series.getSeries(), series.getStroke(), series.getFill(), series.getSymbolBackground(), series.getLegendSymbolFill()));
        } else if (TileEvt.SERIES_ADD.getName().equals(EVENT_TYPE)) {
            List seriesToAdd = this.tile.getTilesFXSeries().stream().map(tilesFxSeries -> tilesFxSeries.getSeries()).collect(Collectors.toList());
            this.chart.getData().addAll((Collection)seriesToAdd.stream().filter(s2 -> !this.chart.getData().contains(s2)).collect(Collectors.toList()));
        } else if (TileEvt.SERIES_REMOVE.getName().equals(EVENT_TYPE)) {
            ArrayList<XYChart.Series> seriesToRemove = new ArrayList<XYChart.Series>();
            for (XYChart.Series series2 : this.chart.getData()) {
                TilesFXSeries tfxs = this.tile.getTilesFXSeries().stream().filter(tfxSeries -> tfxSeries.getSeries().equals(series2)).findFirst().orElse(null);
                if (null != tfxs) continue;
                seriesToRemove.add(series2);
            }
            this.chart.getData().removeAll(seriesToRemove);
        }
    }

    @Override
    public void dispose() {
        this.chart.dispose();
        this.chart.removeEventHandler(SmoothedChartEvent.DATA_SELECTED, this.chartEventEventHandler);
        super.dispose();
    }

    @Override
    protected void resizeStaticText() {
        double maxWidth = this.width - this.size * 0.1;
        double fontSize = this.size * this.textSize.factor;
        boolean customFontEnabled = this.tile.isCustomFontEnabled();
        Font customFont = this.tile.getCustomFont();
        Font font = customFontEnabled && customFont != null ? Font.font((String)customFont.getFamily(), (double)fontSize) : Fonts.latoRegular(fontSize);
        this.titleText.setFont(font);
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        switch (this.tile.getTitleAlignment()) {
            default: {
                this.titleText.relocate(this.size * 0.05, this.size * 0.05);
                break;
            }
            case CENTER: {
                this.titleText.relocate((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.05);
                break;
            }
            case RIGHT: {
                this.titleText.relocate(this.width - this.size * 0.05 - this.titleText.getLayoutBounds().getWidth(), this.size * 0.05);
            }
        }
    }

    @Override
    protected void resize() {
        super.resize();
        this.chart.setMinSize(this.contentBounds.getWidth(), this.contentBounds.getHeight());
        this.chart.setPrefSize(this.contentBounds.getWidth(), this.contentBounds.getHeight());
        this.chart.setMaxSize(this.contentBounds.getWidth(), this.contentBounds.getHeight());
        if (this.titleText.isVisible()) {
            this.chart.setPadding(new Insets(this.titleText.getLayoutBounds().getHeight() + this.contentBounds.getX(), 0.0, 0.0, 0.0));
        }
        this.chart.relocate(this.contentBounds.getX(), this.contentBounds.getY());
    }

    @Override
    protected void redraw() {
        super.redraw();
        this.titleText.setText(this.tile.getTitle());
        this.resizeStaticText();
        this.chart.setSelectorStrokeColor(this.tile.getForegroundColor());
        this.chart.setSelectorFillColor(this.tile.getBackgroundColor());
        this.chart.setSmoothed(this.tile.isSmoothing());
        this.chart.setAnimated(this.tile.isAnimated());
        this.chart.setTooltipTimeout(this.tile.getTooltipTimeout());
        this.chart.setSymbolsVisible(this.tile.getDataPointsVisible());
        this.titleText.setFill((Paint)this.tile.getTitleColor());
    }
}

