/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.toolbox.properties;

import eu.hansolo.toolbox.evt.type.PropertyChangeEvt;
import eu.hansolo.toolbox.properties.ReadOnlyCharProperty;

public class CharProperty
extends ReadOnlyCharProperty {
    protected ReadOnlyCharProperty propertyBoundTo = null;
    protected boolean bound = false;

    public CharProperty() {
        this((Object)null, (String)null, ' ');
    }

    public CharProperty(char value) {
        this((Object)null, (String)null, value);
    }

    public CharProperty(String name, char value) {
        this((Object)null, name, value);
    }

    public CharProperty(Object bean, String name, char value) {
        super(bean, name, value);
    }

    public void setValue(Character value) {
        if (this.bound && !this.bidirectional) {
            throw new IllegalArgumentException("A bound value cannot be set.");
        }
        this.setValue(value, null);
    }

    public void set(char value) {
        this.setValue(Character.valueOf(value));
    }

    protected void setValue(Character value, CharProperty property) {
        this.willChange((Character)this.value, value);
        Character oldValue = (Character)this.value;
        this.value = value;
        if (null == property && null != this.propertyToUpdate) {
            this.propertyToUpdate.setValue(value, this);
        }
        this.fireEvent(new PropertyChangeEvt<Object>(this, PropertyChangeEvt.CHANGED, oldValue, this.value));
        this.didChange(oldValue, (Character)this.value);
        this.invalidated();
    }

    public void unset() {
        this.setValue((Character)this.getInitialValue());
    }

    public void setInitialValue(Character initialValue) {
        this.initialValue = initialValue;
    }

    public void bind(ReadOnlyCharProperty property) {
        this.propertyBoundTo = property;
        this.value = this.propertyBoundTo.getValue();
        this.propertyBoundTo.setPropertyToUpdate(this);
        this.propertyToUpdate = null;
        this.bound = true;
    }

    public boolean isBound() {
        return this.bound;
    }

    public void bindBidirectional(CharProperty property) {
        this.setPropertyToUpdate(property, true);
        property.setPropertyToUpdate(this, true);
        this.propertyBoundTo = property;
        this.bound = true;
    }

    public boolean isBoundBidirectional() {
        return this.bidirectional;
    }

    public void unbind() {
        if (null != this.propertyToUpdate) {
            this.propertyToUpdate.unsetPropertyToUpdate();
            this.propertyToUpdate.unbind();
            this.propertyToUpdate = null;
        }
        if (null != this.propertyBoundTo) {
            this.propertyBoundTo.unsetPropertyToUpdate();
            this.propertyBoundTo = null;
        }
        this.bound = false;
        this.bidirectional = false;
    }

    protected void setPropertyToUpdate(CharProperty property, boolean bidirectional) {
        this.propertyToUpdate = property;
        if (null == property) {
            this.bidirectional = false;
        } else {
            this.value = property.getValue();
            this.bidirectional = bidirectional;
        }
    }
}

