/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.tableview2;

import impl.org.controlsfx.tableview2.TableRow2;
import impl.org.controlsfx.tableview2.TableView2Skin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.TableCell;
import javafx.scene.control.skin.VirtualFlow;
import javafx.scene.layout.Region;
import org.controlsfx.control.tableview2.TableView2;

final class TableView2VirtualFlow<T extends IndexedCell<?>>
extends VirtualFlow<T> {
    private final TableView2<?> tableView;
    private final TableView2Skin<?> skin;
    private final ArrayList<T> myFixedCells = new ArrayList();
    public final List<Node> sheetChildren;
    private boolean adjusting;
    private final DoubleProperty adjustedPixels = new SimpleDoubleProperty(){

        protected void invalidated() {
            if (!TableView2VirtualFlow.this.adjusting && this.get() > 0.0 && TableView2VirtualFlow.this.myFixedCells.size() < TableView2VirtualFlow.this.tableView.getFixedRows().size()) {
                TableView2VirtualFlow.this.layoutChildren();
            }
            TableView2VirtualFlow.this.adjusting = false;
        }
    };
    private final ChangeListener<Number> hBarValueChangeListener = new ChangeListener<Number>(){

        public void changed(ObservableValue<? extends Number> ov, Number t, Number t1) {
            TableView2VirtualFlow.this.skin.hBarValue.clear();
        }
    };

    public TableView2VirtualFlow(TableView2Skin<?> skin) {
        this.skin = skin;
        this.tableView = (TableView2)skin.getSkinnable();
        ChangeListener listenerY = (ov, t, t1) -> this.layoutTotal();
        this.getVbar().valueProperty().addListener(listenerY);
        this.getHbar().valueProperty().addListener(this.hBarValueChangeListener);
        this.widthProperty().addListener(this.hBarValueChangeListener);
        this.sheetChildren = this.findSheetChildren();
    }

    public void init() {
        this.getHbar().maxProperty().addListener((observable2, oldValue, newValue) -> {
            this.getHbar().setBlockIncrement(this.getWidth());
            this.getHbar().setUnitIncrement(newValue.doubleValue() / 20.0);
        });
        this.tableView.getFixedRows().addListener(observable2 -> {
            ArrayList<IndexedCell> toRemove = new ArrayList<IndexedCell>();
            for (IndexedCell cell : this.myFixedCells) {
                if (this.tableView.getFixedRows().contains((Object)cell.getIndex())) continue;
                cell.setManaged(false);
                cell.setVisible(false);
                toRemove.add(cell);
            }
            this.myFixedCells.removeAll(toRemove);
        });
    }

    public void scrollTo(int index) {
        if (!this.getCells().isEmpty() && !this.tableView.getFixedRows().isEmpty()) {
            for (double offset = this.skin.getFixedRowHeight(); offset >= 0.0 && index > 0; offset -= this.skin.getRowHeight(--index)) {
            }
        }
        super.scrollTo(index);
        this.layoutTotal();
        this.layoutFixedRows();
    }

    public double scrollPixels(double delta) {
        double returnValue = super.scrollPixels(delta);
        this.adjusting = true;
        this.adjustedPixels.set(delta);
        this.layoutTotal();
        this.layoutFixedRows();
        return returnValue;
    }

    List<T> getFixedCells() {
        return this.myFixedCells;
    }

    void rebuildFixedCells() {
        this.myFixedCells.clear();
    }

    DoubleProperty adjustedPixelsProperty() {
        return this.adjustedPixels;
    }

    protected void layoutChildren() {
        if (this.tableView != null) {
            this.sortRows();
            super.layoutChildren();
            this.layoutTotal();
            this.layoutFixedRows();
            if (this.getVbar().getVisibleAmount() == 0.0 && this.getVbar().isVisible() && this.getCells().size() != this.getCellCount()) {
                this.getVbar().setMax(1.0);
                this.getVbar().setVisibleAmount((double)((float)this.getCells().size() / (float)this.getCellCount()));
            }
        }
    }

    protected void layoutTotal() {
        this.sortRows();
        this.removeDeportedCells();
        if (this.getCells().isEmpty()) {
            this.reconfigureCells();
        }
        for (IndexedCell cell : this.getCells()) {
            if (cell == null) continue;
            cell.getProperties().put((Object)"fixed", (Object)false);
            if (cell.getIndex() < 0 || this.skin.hBarValue.get(cell.getIndex()) && !this.skin.rowToLayout.get(cell.getIndex())) continue;
            if (this.skin.rowToLayout.get(cell.getIndex())) {
                cell.getProperties().put((Object)"fixed", (Object)true);
            }
            cell.requestLayout();
        }
    }

    private <S> void removeDeportedCells() {
        ArrayList rowToRemove = new ArrayList();
        Iterator<Map.Entry<TableRow2<Object>, Set<Object>>> iterator2 = this.skin.deportedCells.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator2.next();
            ArrayList toRemove = new ArrayList();
            for (TableCell cell : entry2.getValue()) {
                if (cell.isEditing() || this.getCells().contains(cell.getTableRow())) continue;
                entry2.getKey().removeCell(cell);
                toRemove.add(cell);
            }
            entry2.getValue().removeAll(toRemove);
            if (!entry2.getValue().isEmpty()) continue;
            rowToRemove.add(entry2.getKey());
        }
        for (TableRow2 tableRow2 : rowToRemove) {
            this.skin.deportedCells.remove((Object)tableRow2);
        }
    }

    protected ScrollBar getVerticalBar() {
        return this.getVbar();
    }

    protected ScrollBar getHorizontalBar() {
        return this.getHbar();
    }

    protected List<T> getCells() {
        return super.getCells();
    }

    private List<Node> findSheetChildren() {
        Region region;
        if (!this.getChildren().isEmpty() && this.getChildren().get(0) instanceof Region && !(region = (Region)this.getChildren().get(0)).getChildrenUnmodifiable().isEmpty() && region.getChildrenUnmodifiable().get(0) instanceof Group) {
            return ((Group)region.getChildrenUnmodifiable().get(0)).getChildren();
        }
        return new ArrayList<Node>();
    }

    private void layoutFixedRows() {
        if (!this.tableView.getFixedRows().isEmpty() && this.tableView.isRowFixingEnabled() && this.getFirstVisibleCellWithinViewport() != null) {
            this.sortRows();
            Object row = null;
            block0: for (int i = this.tableView.getFixedRows().size() - 1; i >= 0; --i) {
                IndexedCell virtualFlowCells;
                Integer fixedRowIndex = (Integer)this.tableView.getFixedRows().get(i);
                IndexedCell lastCell = this.getLastVisibleCellWithinViewport();
                if (lastCell != null && fixedRowIndex > lastCell.getIndex()) {
                    if (row == null) continue;
                    row.setVisible(false);
                    row.setManaged(false);
                    row.getProperties().put((Object)"fixed", (Object)false);
                    this.sheetChildren.remove(row);
                    continue;
                }
                Iterator<T> iterator2 = this.getCells().iterator();
                while (iterator2.hasNext() && (virtualFlowCells = (IndexedCell)iterator2.next()).getIndex() <= fixedRowIndex) {
                    if (virtualFlowCells.getIndex() != fixedRowIndex.intValue()) continue;
                    row = this.containsRows(fixedRowIndex);
                    if (row != null) {
                        row.setVisible(false);
                        row.setManaged(false);
                        row.getProperties().put((Object)"fixed", (Object)false);
                        this.sheetChildren.remove(row);
                    }
                    virtualFlowCells.toFront();
                    continue block0;
                }
                row = this.containsRows(fixedRowIndex);
                if (row == null) {
                    row = (IndexedCell)this.getCellFactory().call((Object)this);
                    row.getProperties().put((Object)"newcell", null);
                    this.setCellIndex((IndexedCell)row, fixedRowIndex);
                    this.resizeCell((IndexedCell)row);
                    this.myFixedCells.add(row);
                }
                if (!this.sheetChildren.contains(row)) {
                    this.sheetChildren.add((Node)row);
                }
                row.setManaged(true);
                row.setVisible(true);
                row.getProperties().put((Object)"fixed", (Object)true);
                row.toFront();
                row.requestLayout();
            }
        }
    }

    private T containsRows(int i) {
        for (IndexedCell cell : this.myFixedCells) {
            if (cell.getIndex() != i) continue;
            return (T)cell;
        }
        return null;
    }

    private void sortRows() {
        List<T> temp = this.getCells();
        ArrayList<T> tset = new ArrayList<T>(temp);
        Collections.sort(tset, (i1, i2) -> i2.getIndex() - i1.getIndex());
        for (IndexedCell r : tset) {
            r.toFront();
        }
    }
}

