/*
 * Decompiled with CFR 0.152.
 */
package mediathek.daten.blacklist;

import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import mediathek.config.Daten;
import mediathek.config.MVConfig;
import mediathek.daten.DatenFilm;
import mediathek.daten.ListeFilme;
import mediathek.daten.blacklist.ApplyBlacklistFilterPredicate;
import mediathek.daten.blacklist.BlacklistRule;
import mediathek.gui.messages.BlacklistChangedEvent;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.Filter;
import mediathek.tool.MessageBus;
import org.apache.commons.configuration2.Configuration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ListeBlacklist
extends ArrayList<BlacklistRule> {
    private static final Logger logger = LogManager.getLogger(ListeBlacklist.class);
    private final GeoblockingPredicate geoblockingPredicate = new GeoblockingPredicate();
    private long days_lower_boundary;
    private boolean doNotShowFutureFilms;
    private boolean doNotShowGeoBlockedFilms;
    private boolean blacklistIsActive;
    private long minimumFilmLength;
    private static final String[] EMPTY_STRING_ARRAY = new String[]{""};

    public synchronized void addWithoutNotification(BlacklistRule b) {
        super.add(b);
    }

    @Override
    public synchronized boolean add(BlacklistRule b) {
        boolean ret = super.add(b);
        this.filterListAndNotifyListeners();
        return ret;
    }

    @Override
    public synchronized boolean remove(Object b) {
        boolean ret = super.remove(b);
        this.filterListAndNotifyListeners();
        return ret;
    }

    public synchronized void remove(List<BlacklistRule> ruleList) {
        for (BlacklistRule rule : ruleList) {
            super.remove(rule);
        }
        this.filterListAndNotifyListeners();
    }

    @Override
    public synchronized BlacklistRule remove(int idx) {
        BlacklistRule ret = (BlacklistRule)super.remove(idx);
        this.filterListAndNotifyListeners();
        return ret;
    }

    @Override
    public synchronized BlacklistRule get(int idx) {
        return (BlacklistRule)super.get(idx);
    }

    @Override
    public synchronized void clear() {
        super.clear();
        this.filterListAndNotifyListeners();
    }

    public synchronized void filterListe() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        Daten daten = Daten.getInstance();
        ListeFilme completeFilmList = daten.getListeFilme();
        ListeFilme filteredList = daten.getListeFilmeNachBlackList();
        filteredList.clear();
        this.loadCurrentFilterSettings();
        if (completeFilmList != null && !completeFilmList.isEmpty()) {
            filteredList.setMetaData(completeFilmList.metaData());
            this.parallelStream().forEach((? super T entry) -> {
                entry.convertToLowerCase();
                entry.checkPatterns();
            });
            Predicate<DatenFilm> pred = this.createPredicate();
            completeFilmList.parallelStream().filter(pred).forEachOrdered(filteredList::add);
            this.setupNewEntries();
        }
        stopwatch.stop();
        logger.trace("Complete filtering took: {}", (Object)stopwatch);
    }

    private Predicate<DatenFilm> createPredicate() {
        ArrayList<Predicate<DatenFilm>> filterList = new ArrayList<Predicate<DatenFilm>>();
        if (this.days_lower_boundary != 0L) {
            filterList.add(this::checkDate);
        }
        if (this.blacklistIsActive) {
            if (this.doNotShowGeoBlockedFilms) {
                filterList.add(this.geoblockingPredicate);
            }
            if (this.doNotShowFutureFilms) {
                filterList.add(this::checkIfFilmIsInFuture);
            }
            if (this.minimumFilmLength != 0L) {
                filterList.add(this::checkFilmLength);
            }
            if (!this.isEmpty()) {
                ApplyBlacklistFilterPredicate predicate = new ApplyBlacklistFilterPredicate(this);
                filterList.add(predicate);
            }
        }
        Predicate<DatenFilm> pred = filterList.stream().reduce(Predicate::and).orElse(x -> true);
        filterList.clear();
        return pred;
    }

    private void setupNewEntries() {
        Daten daten = Daten.getInstance();
        daten.getListeFilmeNachBlackList().stream().filter(DatenFilm::isNew).findAny().ifPresent(ignored -> {
            daten.getListeFilmeNachBlackList().neueFilme = true;
        });
    }

    public synchronized boolean checkBlackOkFilme_Downloads(DatenFilm film) {
        this.loadCurrentFilterSettings();
        this.days_lower_boundary = 0L;
        this.blacklistIsActive = true;
        return this.applyFiltersForAbos(film);
    }

    public synchronized void filterListAndNotifyListeners() {
        this.filterListe();
        MessageBus.getMessageBus().publishAsync(new BlacklistChangedEvent());
    }

    private long daysToMilliseconds(int days) {
        return 86400000L * (long)days;
    }

    private void loadCurrentFilterSettings() {
        try {
            String val = (String)MediathekGui.ui().tabFilme.filmActionPanel.zeitraumProperty.getValue();
            this.days_lower_boundary = val.equals("\u221e") ? 0L : System.currentTimeMillis() - this.daysToMilliseconds(Integer.parseInt(val));
        }
        catch (Exception ex) {
            this.days_lower_boundary = 0L;
        }
        try {
            this.minimumFilmLength = Long.parseLong(MVConfig.get(MVConfig.Configs.SYSTEM_BLACKLIST_FILMLAENGE)) * 60L;
        }
        catch (Exception ex) {
            this.minimumFilmLength = 0L;
        }
        this.blacklistIsActive = Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_BLACKLIST_ON));
        this.doNotShowFutureFilms = Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_BLACKLIST_ZUKUNFT_NICHT_ANZEIGEN));
        Configuration config = ApplicationConfiguration.getConfiguration();
        this.doNotShowGeoBlockedFilms = config.getBoolean("blacklist.show_geoblocked", false);
        this.geoblockingPredicate.updateLocation();
    }

    private boolean applyFiltersForAbos(DatenFilm film) {
        if (!this.checkDate(film)) {
            return false;
        }
        if (!this.blacklistIsActive) {
            return true;
        }
        if (this.doNotShowGeoBlockedFilms && !this.geoblockingPredicate.test(film)) {
            return false;
        }
        if (this.doNotShowFutureFilms && !this.checkIfFilmIsInFuture(film)) {
            return false;
        }
        if (this.minimumFilmLength != 0L && !this.checkFilmLength(film)) {
            return false;
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean bl_is_whitelist = Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_BLACKLIST_IST_WHITELIST));
        for (BlacklistRule rule : this) {
            if (!Filter.filterAufFilmPruefenWithLength(rule.getSender(), rule.getThema(), this.makePattern(rule.getTitel()), this.makePattern(rule.getThema_titel()), EMPTY_STRING_ARRAY, 0, true, film, true)) continue;
            return bl_is_whitelist;
        }
        return !bl_is_whitelist;
    }

    private String[] makePattern(String input) {
        String[] stringArray;
        if (Filter.isPattern(input)) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = input;
        } else {
            stringArray = input.toLowerCase().split(",");
        }
        return stringArray;
    }

    private boolean checkDate(@NotNull DatenFilm film) {
        if (film.isLivestream()) {
            return true;
        }
        if (this.days_lower_boundary != 0L) {
            long filmTime = film.getDatumFilm().getTime();
            return filmTime == 0L || filmTime >= this.days_lower_boundary;
        }
        return true;
    }

    private boolean checkIfFilmIsInFuture(@NotNull DatenFilm film) {
        return film.getDatumFilm().getTime() <= System.currentTimeMillis();
    }

    private boolean checkFilmLength(@NotNull DatenFilm film) {
        long filmLength = film.getFilmLength();
        return filmLength == 0L || this.minimumFilmLength <= filmLength;
    }

    static class GeoblockingPredicate
    implements Predicate<DatenFilm> {
        private String geoLocation;

        public GeoblockingPredicate() {
            this.setLocationData();
        }

        public void updateLocation() {
            this.setLocationData();
        }

        private void setLocationData() {
            this.geoLocation = ApplicationConfiguration.getConfiguration().getString("geo.location");
        }

        @Override
        public boolean test(DatenFilm film) {
            Optional<String> geoOpt = film.getGeo();
            if (geoOpt.isEmpty()) {
                return true;
            }
            return geoOpt.orElse("").contains(this.geoLocation);
        }
    }
}

