/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.actions;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import mediathek.config.StandardLocations;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DeleteLocalFilmlistAction
extends AbstractAction {
    private final JFrame owner;
    private static final Logger logger = LogManager.getLogger();

    public DeleteLocalFilmlistAction(MediathekGui parent) {
        this.owner = parent;
        this.putValue("Name", "Lokale Filmliste l\u00f6schen");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            String filmlistPathStr = StandardLocations.getFilmlistFilePath();
            Path fimlistPath = Paths.get(filmlistPathStr, new String[0]);
            FileUtils.moveToTrash(fimlistPath);
            JOptionPane.showMessageDialog(this.owner, "Filmliste wurde gel\u00f6scht.\nDas Programm wird nun beendet.", "MediathekView", 1);
            MediathekGui.ui().beenden(false, false);
        }
        catch (IOException ex) {
            logger.error("Failed to delete filmlist", (Throwable)ex);
            JOptionPane.showMessageDialog(this.owner, "Es trat ein Fehler beim L\u00f6schen der Filmliste auf.\nWeitere Informationen finden Sie in der Logdatei.\nDas Programm wird nun beendet.", "MediathekView", 0);
        }
    }
}

