/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialog;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import javafx.application.Platform;
import javafx.scene.control.Alert;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import jiconfont.icons.font_awesome.FontAwesome;
import jiconfont.swing.IconFontSwing;
import mediathek.config.Daten;
import mediathek.config.MVConfig;
import mediathek.config.StandardLocations;
import mediathek.daten.DatenFilm;
import mediathek.daten.DatenPset;
import mediathek.daten.ListePset;
import mediathek.javafx.tool.JFXHiddenApplication;
import mediathek.javafx.tool.JavaFxUtils;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.EscapeKeyHandler;
import mediathek.tool.FileDialogs;
import mediathek.tool.FilenameUtils;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.MVInfoFile;
import mediathek.tool.javafx.FXErrorDialog;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import okhttp3.HttpUrl;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DialogFilmBeschreibung
extends JDialog {
    private static final String TITLE = "Beschreibung \u00e4ndern";
    private static final Logger logger = LogManager.getLogger();
    private JButton jButtonOk;
    private JButton jButtonHilfe;
    private JButton jButtonSpeichern;
    private JTextArea jTextArea1;
    private JTextField jTextFieldTitel;

    public DialogFilmBeschreibung(JFrame parent, DatenFilm datenFilm) {
        super((Frame)parent, true);
        this.initComponents();
        this.setTitle(TITLE);
        if (parent != null) {
            this.setLocationRelativeTo(parent);
        }
        EscapeKeyHandler.installHandler(this, this::dispose);
        this.jTextArea1.setText(datenFilm.getDescription());
        this.jTextFieldTitel.setText(datenFilm.getTitle());
        this.jButtonOk.addActionListener(e -> {
            datenFilm.setDescription(this.jTextArea1.getText());
            this.dispose();
        });
        this.jButtonHilfe.setIcon(IconFontSwing.buildIcon(FontAwesome.QUESTION_CIRCLE_O, 16.0f));
        this.jButtonHilfe.addActionListener(e -> Platform.runLater(() -> {
            Alert alert = new Alert(Alert.AlertType.INFORMATION);
            alert.setHeaderText("Hilfe zu Beschreibung \u00e4ndern");
            alert.setContentText("Diese Funktion richtet sich z.B. an Benutzer,welche eine angepasste Beschreibung der Sendung in Form der Infodatei (\"Filmname.txt\") anlegen und durch Drittprogramme einlesen lassen wollen.\n\nAchtung: Diese \u00c4nderungen gehen nach dem Neuladen einer Filmliste verloren.");
            JFXHiddenApplication.showAlert(alert, MediathekGui.ui());
        }));
        this.jButtonSpeichern.addActionListener(e -> {
            datenFilm.setDescription(this.jTextArea1.getText());
            Object titel = FilenameUtils.replaceLeerDateiname(datenFilm.getTitle(), false, Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_USE_REPLACETABLE)), Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_ONLY_ASCII)));
            String pfad = "";
            ListePset lp = Daten.listePset.getListeSpeichern();
            if (!lp.isEmpty()) {
                DatenPset p = (DatenPset)lp.get(0);
                pfad = p.getZielPfad();
            }
            if (pfad.isEmpty()) {
                pfad = StandardLocations.getStandardDownloadPath();
            }
            titel = ((String)titel).isEmpty() ? StringUtils.replace(datenFilm.getSender(), " ", "-") + ".txt" : (String)titel + ".txt";
            pfad = GuiFunktionen.addsPfad(pfad, (String)titel);
            File destFile = FileDialogs.chooseSaveFileLocation(MediathekGui.ui(), "Infos speichern", pfad);
            if (destFile != null) {
                Path path = destFile.toPath();
                try {
                    MVInfoFile file = new MVInfoFile();
                    HttpUrl url = HttpUrl.parse(datenFilm.getUrlNormalQuality());
                    file.writeInfoFile(datenFilm, path, url);
                    JavaFxUtils.invokeInFxThreadAndWait(() -> {
                        Alert alert = new Alert(Alert.AlertType.INFORMATION);
                        alert.setHeaderText("Infodatei schreiben");
                        alert.setContentText("Infodatei wurde erfolgreich geschrieben.");
                        JFXHiddenApplication.showAlert(alert, MediathekGui.ui());
                    });
                }
                catch (IOException ex) {
                    JavaFxUtils.invokeInFxThreadAndWait(() -> FXErrorDialog.showErrorDialog("MediathekView", "Infodatei schreiben", "Ein unbekannter Fehler ist aufgetreten!", ex));
                    logger.error("Ziel: {}", (Object)path.toAbsolutePath().toString(), (Object)ex);
                }
            }
        });
    }

    private void initComponents() {
        JPanel panel1 = new JPanel();
        this.jButtonOk = new JButton();
        this.jButtonHilfe = new JButton();
        this.jButtonSpeichern = new JButton();
        JScrollPane jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        JPanel panel2 = new JPanel();
        JLabel jLabel2 = new JLabel();
        this.jTextFieldTitel = new JTextField();
        this.setDefaultCloseOperation(2);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new MigLayout(new LC().fill().insets("5").hideMode(3).gridGap("5", "5"), new AC().grow().fill(), new AC().fill().gap().grow().fill().gap().fill()));
        panel1.setLayout(new MigLayout(new LC().insets("0").hideMode(3).gridGap("5", "5"), new AC().fill().gap().grow().fill().gap().fill().gap().fill(), new AC().fill()));
        this.jButtonOk.setText("Ok");
        panel1.add((Component)this.jButtonOk, new CC().cell(3, 0));
        this.jButtonHilfe.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-help.png")));
        this.jButtonHilfe.setToolTipText("Hilfe anzeigen");
        panel1.add((Component)this.jButtonHilfe, new CC().cell(2, 0));
        this.jButtonSpeichern.setText("Speichern");
        panel1.add((Component)this.jButtonSpeichern, new CC().cell(0, 0));
        contentPane.add((Component)panel1, new CC().cell(0, 2));
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setRows(5);
        this.jTextArea1.setWrapStyleWord(true);
        jScrollPane1.setViewportView(this.jTextArea1);
        contentPane.add((Component)jScrollPane1, new CC().cell(0, 1));
        panel2.setLayout(new MigLayout(new LC().insets("0").hideMode(3).gridGap("5", "5"), new AC().fill().gap().grow().fill(), new AC().fill()));
        jLabel2.setText("Filmtitel:");
        panel2.add((Component)jLabel2, new CC().cell(0, 0));
        this.jTextFieldTitel.setEditable(false);
        panel2.add((Component)this.jTextFieldTitel, new CC().cell(1, 0));
        contentPane.add((Component)panel2, new CC().cell(0, 0));
        this.setSize(490, 185);
        this.setLocationRelativeTo(this.getOwner());
    }
}

