/*
 * Decompiled with CFR 0.152.
 */
package mediathek.javafx.filterpanel;

import impl.org.controlsfx.autocompletion.SuggestionProvider;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javafx.animation.PauseTransition;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Tooltip;
import javafx.util.Duration;
import javafx.util.StringConverter;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import mediathek.config.Daten;
import mediathek.daten.ListeFilme;
import mediathek.filmeSuchen.ListenerFilmeLaden;
import mediathek.filmeSuchen.ListenerFilmeLadenEvent;
import mediathek.gui.actions.ManageAboAction;
import mediathek.gui.messages.FilmListWriteStartEvent;
import mediathek.gui.messages.FilmListWriteStopEvent;
import mediathek.javafx.filterpanel.CommonViewSettingsPane;
import mediathek.javafx.filterpanel.FXFilmToolBar;
import mediathek.javafx.filterpanel.FXSearchControlFieldMode;
import mediathek.javafx.filterpanel.SwingFilterDialog;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.Filter;
import mediathek.tool.FilterConfiguration;
import mediathek.tool.FilterDTO;
import mediathek.tool.GermanStringSorter;
import mediathek.tool.MessageBus;
import net.engio.mbassy.listener.Handler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.controlsfx.control.RangeSlider;
import org.controlsfx.control.textfield.TextFields;

public class FilmActionPanel {
    private static final Logger logger = LogManager.getLogger();
    private final PauseTransition finalActionTrans = new PauseTransition(Duration.seconds((double)1.0));
    private final Tooltip tooltipSearchIrgendwo = new Tooltip("Suche in Beschreibung aktiviert");
    private final Tooltip tooltipSearchRegular = new Tooltip("Suche in Beschreibung deaktiviert");
    private final Tooltip bookmarklistSelected = new Tooltip("Alle Filme anzeigen");
    private final Tooltip bookmarklistDeselected = new Tooltip("Gemerkte Filme anzeigen");
    private final FilterConfiguration filterConfig;
    private final ObservableList<FilterDTO> availableFilters;
    public ReadOnlyStringWrapper roSearchStringProperty = new ReadOnlyStringWrapper();
    public BooleanProperty showOnlyHd;
    public BooleanProperty showSubtitlesOnly;
    public BooleanProperty showNewOnly;
    public BooleanProperty showBookMarkedOnly;
    public BooleanProperty showUnseenOnly;
    public BooleanProperty showLivestreamsOnly;
    public BooleanProperty dontShowAbos;
    public BooleanProperty dontShowTrailers;
    public BooleanProperty dontShowSignLanguage;
    public BooleanProperty dontShowAudioVersions;
    public BooleanProperty searchThroughDescription;
    public ReadOnlyObjectProperty<String> zeitraumProperty;
    public ComboBox<String> themaBox;
    public RangeSlider filmLengthSlider;
    public JDialog filterDialog;
    public ManageAboAction manageAboAction;
    private SuggestionProvider<String> themaSuggestionProvider;
    private FXFilmToolBar toolBar;
    private CommonViewSettingsPane viewSettingsPane;
    private final PauseTransition reloadTableDataTransition;

    public FilmActionPanel(PauseTransition reloadTableDataTransition) {
        this.filterConfig = new FilterConfiguration();
        this.reloadTableDataTransition = reloadTableDataTransition;
        this.setupViewSettingsPane();
        this.setupDeleteFilterButton();
        SwingUtilities.invokeLater(() -> {
            this.filterDialog = new SwingFilterDialog((Frame)MediathekGui.ui(), this.viewSettingsPane);
        });
        this.restoreConfigSettings();
        this.setupConfigListeners();
        this.availableFilters = FXCollections.observableArrayList(this.filterConfig.getAvailableFilters());
        this.setupFilterSelection();
        this.setupDeleteCurrentFilterButton();
        this.setupAddNewFilterButton();
        MessageBus.getMessageBus().subscribe(this);
    }

    private void setupAddNewFilterButton() {
        this.viewSettingsPane.setAddNewFilterButtonEventHandler((EventHandler<ActionEvent>)((EventHandler)event -> {
            FilterDTO newFilter = new FilterDTO(UUID.randomUUID(), String.format("Filter %d", this.availableFilters.size() + 1));
            this.filterConfig.addNewFilter(newFilter);
            this.viewSettingsPane.disableDeleteCurrentFilterButton(false);
            this.viewSettingsPane.selectFilter(newFilter);
        }));
    }

    private void setupDeleteCurrentFilterButton() {
        if (this.availableFilters.size() <= 1) {
            this.viewSettingsPane.disableDeleteCurrentFilterButton(true);
        }
        this.viewSettingsPane.btnDeleteCurrentFilter.setOnAction(event -> {
            FilterDTO filterToDelete = this.filterConfig.getCurrentFilter();
            this.filterConfig.deleteFilter(filterToDelete);
            if (this.availableFilters.size() <= 1) {
                this.viewSettingsPane.disableDeleteCurrentFilterButton(true);
            }
        });
    }

    private void setupFilterSelection() {
        this.viewSettingsPane.setAvailableFilters(this.availableFilters);
        FilterConfiguration.addAvailableFiltersObserver(() -> {
            this.availableFilters.clear();
            this.availableFilters.addAll(this.filterConfig.getAvailableFilters());
        });
        FilterConfiguration.addCurrentFiltersObserver(filter -> {
            this.viewSettingsPane.selectFilter((FilterDTO)filter);
            this.restoreConfigSettings();
        });
        this.viewSettingsPane.setFilterSelectionChangeListener((ChangeListener<FilterDTO>)((ChangeListener)(observableValue, oldValue, newValue) -> {
            if (newValue != null && !newValue.equals(oldValue)) {
                this.filterConfig.setCurrentFilter((FilterDTO)newValue);
            }
        }));
        this.viewSettingsPane.setFilterSelectionStringConverter(new StringConverter<FilterDTO>(){

            public String toString(FilterDTO filter) {
                if (filter == null) {
                    return null;
                }
                return filter.name();
            }

            public FilterDTO fromString(String name) {
                return FilmActionPanel.this.filterConfig.findFilterForName(name).orElseGet(() -> FilmActionPanel.this.renameCurrentFilter(name));
            }
        });
    }

    private FilterDTO renameCurrentFilter(String newValue) {
        FilterDTO currentFilter = this.filterConfig.getCurrentFilter();
        if (logger.isDebugEnabled()) {
            logger.debug("Can't find a filter with name \"{}\". Renaming the current filter \"{}\" to it.", (Object)newValue, (Object)currentFilter.name());
        }
        this.filterConfig.renameCurrentFilter(newValue);
        return this.filterConfig.getCurrentFilter();
    }

    private void setupDeleteFilterButton() {
        this.viewSettingsPane.btnDeleteFilterSettings.setOnAction(e -> {
            this.filterConfig.clearCurrentFilter();
            this.restoreConfigSettings();
        });
    }

    private void setupViewSettingsPane() {
        this.viewSettingsPane = new CommonViewSettingsPane();
        this.showOnlyHd = this.viewSettingsPane.cbShowOnlyHd.selectedProperty();
        this.showSubtitlesOnly = this.viewSettingsPane.cbShowSubtitlesOnly.selectedProperty();
        this.showNewOnly = this.viewSettingsPane.cbShowNewOnly.selectedProperty();
        this.showBookMarkedOnly = this.viewSettingsPane.cbShowBookMarkedOnly.selectedProperty();
        this.showLivestreamsOnly = this.viewSettingsPane.cbShowOnlyLivestreams.selectedProperty();
        this.showUnseenOnly = this.viewSettingsPane.cbShowUnseenOnly.selectedProperty();
        this.dontShowAbos = this.viewSettingsPane.cbDontShowAbos.selectedProperty();
        this.dontShowSignLanguage = this.viewSettingsPane.cbDontShowGebaerdensprache.selectedProperty();
        this.dontShowTrailers = this.viewSettingsPane.cbDontShowTrailers.selectedProperty();
        this.dontShowAudioVersions = this.viewSettingsPane.cbDontShowAudioVersions.selectedProperty();
        this.viewSettingsPane.senderCheckList.pauseTransition.setOnFinished(e -> this.updateThemaBox());
        this.themaBox = this.viewSettingsPane.themaComboBox;
        this.themaSuggestionProvider = SuggestionProvider.create(this.themaBox.getItems());
        TextFields.bindAutoCompletion(this.themaBox.getEditor(), this.themaSuggestionProvider);
        this.filmLengthSlider = this.viewSettingsPane.filmLengthSliderNode._filmLengthSlider;
        this.zeitraumProperty = this.viewSettingsPane.zeitraumSpinner.valueProperty();
    }

    public CommonViewSettingsPane getViewSettingsPane() {
        return this.viewSettingsPane;
    }

    private void restoreConfigSettings() {
        this.viewSettingsPane.selectFilter(this.filterConfig.getCurrentFilter());
        this.showOnlyHd.set(this.filterConfig.isShowHdOnly());
        this.showSubtitlesOnly.set(this.filterConfig.isShowSubtitlesOnly());
        this.showNewOnly.set(this.filterConfig.isShowNewOnly());
        this.showBookMarkedOnly.set(this.filterConfig.isShowBookMarkedOnly());
        this.showUnseenOnly.set(this.filterConfig.isShowUnseenOnly());
        this.showLivestreamsOnly.set(this.filterConfig.isShowLivestreamsOnly());
        this.dontShowAbos.set(this.filterConfig.isDontShowAbos());
        this.dontShowTrailers.set(this.filterConfig.isDontShowTrailers());
        this.dontShowSignLanguage.set(this.filterConfig.isDontShowSignLanguage());
        this.dontShowAudioVersions.set(this.filterConfig.isDontShowAudioVersions());
        try {
            double loadedMin = this.filterConfig.getFilmLengthMin();
            if (loadedMin > this.filmLengthSlider.getHighValue()) {
                this.filmLengthSlider.setHighValueChanging(true);
                this.filmLengthSlider.setHighValue(this.filterConfig.getFilmLengthMax());
                this.filmLengthSlider.setHighValueChanging(false);
                this.filmLengthSlider.setLowValueChanging(true);
                this.filmLengthSlider.setLowValue(loadedMin);
                this.filmLengthSlider.setLowValueChanging(false);
            } else {
                this.filmLengthSlider.setLowValueChanging(true);
                this.filmLengthSlider.setLowValue(loadedMin);
                this.filmLengthSlider.setLowValueChanging(false);
                this.filmLengthSlider.setHighValueChanging(true);
                this.filmLengthSlider.setHighValue(this.filterConfig.getFilmLengthMax());
                this.filmLengthSlider.setHighValueChanging(false);
            }
        }
        catch (Exception exception) {
            logger.debug("Beim wiederherstellen der Filter Einstellungen f\u00fcr die Filml\u00e4nge ist ein Fehler aufgetreten!", (Throwable)exception);
        }
        try {
            this.viewSettingsPane.zeitraumSpinner.getValueFactory().setValue((Object)this.filterConfig.getZeitraum());
        }
        catch (Exception exception) {
            logger.debug("Beim wiederherstellen der Filter Einstellungen f\u00fcr den Zeitraum ist ein Fehler aufgetreten!", (Throwable)exception);
        }
    }

    private void setupConfigListeners() {
        this.showOnlyHd.addListener((observable2, oldValue, newValue) -> this.filterConfig.setShowHdOnly((boolean)newValue));
        this.showSubtitlesOnly.addListener((observable2, oldValue, newValue) -> this.filterConfig.setShowSubtitlesOnly((boolean)newValue));
        this.showBookMarkedOnly.addListener((observable2, oldValue, newValue) -> this.filterConfig.setShowBookMarkedOnly((boolean)newValue));
        this.showNewOnly.addListener((observable2, oldValue, newValue) -> this.filterConfig.setShowNewOnly((boolean)newValue));
        this.showUnseenOnly.addListener((observable2, oldValue, newValue) -> this.filterConfig.setShowUnseenOnly((boolean)newValue));
        this.showLivestreamsOnly.addListener((observable2, oldValue, newValue) -> this.filterConfig.setShowLivestreamsOnly((boolean)newValue));
        this.dontShowAbos.addListener((observable2, oldValue, newValue) -> this.filterConfig.setDontShowAbos((boolean)newValue));
        this.dontShowTrailers.addListener((observable2, oldValue, newValue) -> this.filterConfig.setDontShowTrailers((boolean)newValue));
        this.dontShowSignLanguage.addListener((observable2, oldValue, newValue) -> this.filterConfig.setDontShowSignLanguage((boolean)newValue));
        this.dontShowAudioVersions.addListener((observable2, oldValue, newValue) -> this.filterConfig.setDontShowAudioVersions((boolean)newValue));
        this.filmLengthSlider.lowValueProperty().addListener((observable2, oldValue, newValue) -> this.filterConfig.setFilmLengthMin(newValue.doubleValue()));
        this.filmLengthSlider.highValueProperty().addListener((observable2, oldValue, newValue) -> this.filterConfig.setFilmLengthMax(newValue.doubleValue()));
        this.viewSettingsPane.zeitraumSpinner.valueProperty().addListener((observable2, oldValue, newValue) -> this.filterConfig.setZeitraum((String)newValue));
    }

    @Handler
    private void handleFilmlistWriteStartEvent(FilmListWriteStartEvent e) {
        Platform.runLater(() -> this.toolBar.btnDownloadFilmList.setDisable(true));
    }

    @Handler
    private void handleFilmlistWriteStopEvent(FilmListWriteStopEvent e) {
        Platform.runLater(() -> this.toolBar.btnDownloadFilmList.setDisable(false));
    }

    private void searchFieldFinalAction() {
        String text = this.toolBar.jfxSearchField.getText();
        boolean invokeTableFiltering = false;
        if (Filter.isPattern(text)) {
            if (Filter.makePatternNoCache(text) != null) {
                invokeTableFiltering = true;
            }
        } else {
            invokeTableFiltering = true;
        }
        if (invokeTableFiltering) {
            this.reloadTableDataTransition.playFromStart();
        }
    }

    private void setupSearchField() {
        this.toolBar.jfxSearchField.setMode(FXSearchControlFieldMode.THEMA_TITEL);
        StringProperty textProperty = this.toolBar.jfxSearchField.textProperty();
        this.roSearchStringProperty.bind((ObservableValue)textProperty);
        this.finalActionTrans.setOnFinished(e -> this.searchFieldFinalAction());
        textProperty.addListener((observable2, oldValue, newValue) -> this.finalActionTrans.playFromStart());
    }

    private void setupSearchThroughDescriptionButton() {
        boolean enabled = ApplicationConfiguration.getConfiguration().getBoolean("searchfield.film.search_through_description", false);
        this.toolBar.btnSearchThroughDescription.setSelected(enabled);
        if (enabled) {
            this.setupForIrgendwoSearch();
        } else {
            this.setupForRegularSearch();
        }
        this.toolBar.btnSearchThroughDescription.setOnAction(e -> {
            boolean bSearchThroughDescription = this.toolBar.btnSearchThroughDescription.isSelected();
            ApplicationConfiguration.getConfiguration().setProperty("searchfield.film.search_through_description", bSearchThroughDescription);
            if (bSearchThroughDescription) {
                this.setupForIrgendwoSearch();
            } else {
                this.setupForRegularSearch();
            }
        });
        this.searchThroughDescription = this.toolBar.btnSearchThroughDescription.selectedProperty();
    }

    private void setupForRegularSearch() {
        this.toolBar.jfxSearchField.setMode(FXSearchControlFieldMode.THEMA_TITEL);
        this.toolBar.btnSearchThroughDescription.setTooltip(this.tooltipSearchRegular);
    }

    private void setupForIrgendwoSearch() {
        this.toolBar.jfxSearchField.setMode(FXSearchControlFieldMode.IRGENDWO);
        this.toolBar.btnSearchThroughDescription.setTooltip(this.tooltipSearchIrgendwo);
    }

    private void setupShowBookmarkedMoviesButton() {
        this.toolBar.btnShowBookmarkedMovies.setSelected(false);
        this.toolBar.btnShowBookmarkedMovies.setTooltip(this.bookmarklistDeselected);
        this.toolBar.btnShowBookmarkedMovies.setOnAction(event -> this.viewSettingsPane.cbShowBookMarkedOnly.selectedProperty().set(this.toolBar.btnShowBookmarkedMovies.isSelected()));
        this.showBookMarkedOnly.addListener((observable2, oldValue, benabled) -> {
            this.toolBar.btnShowBookmarkedMovies.setTooltip(benabled != false ? this.bookmarklistSelected : this.bookmarklistDeselected);
            this.toolBar.btnShowBookmarkedMovies.setSelected(benabled.booleanValue());
            if (benabled.booleanValue()) {
                this.toolBar.jfxSearchField.clear();
            }
        });
    }

    public void updateThemaBox() {
        ObservableList items = this.themaBox.getItems();
        items.clear();
        items.add((Object)"");
        ArrayList<String> finalList = new ArrayList<String>();
        ObservableList selectedSenders = this.viewSettingsPane.senderCheckList.getCheckModel().getCheckedItems();
        ListeFilme blackList = Daten.getInstance().getListeFilmeNachBlackList();
        if (selectedSenders.isEmpty()) {
            List<String> lst = blackList.getThemen("");
            finalList.addAll(lst);
            lst.clear();
        } else {
            for (String sender : selectedSenders) {
                List<String> lst = blackList.getThemen(sender);
                finalList.addAll(lst);
                lst.clear();
            }
        }
        items.addAll(finalList.stream().distinct().sorted(GermanStringSorter.getInstance()).toList());
        finalList.clear();
        this.themaSuggestionProvider.clearSuggestions();
        this.themaSuggestionProvider.addPossibleSuggestions((Collection<String>)items);
        this.themaBox.getSelectionModel().select(0);
    }

    private void setupToolBar() {
        this.toolBar = new FXFilmToolBar();
        this.toolBar.btnDownloadFilmList.setOnAction(e -> SwingUtilities.invokeLater(() -> MediathekGui.ui().performFilmListLoadOperation(false)));
        this.toolBar.btnFilmInfo.setOnAction(e -> SwingUtilities.invokeLater(MediathekGui.ui().getFilmInfoDialog()::showInfo));
        this.toolBar.btnPlay.setOnAction(evt -> SwingUtilities.invokeLater(() -> MediathekGui.ui().tabFilme.playAction.actionPerformed(null)));
        this.toolBar.btnRecord.setOnAction(e -> SwingUtilities.invokeLater(() -> MediathekGui.ui().tabFilme.saveFilmAction.actionPerformed(null)));
        this.toolBar.btnBookmark.setOnAction(e -> SwingUtilities.invokeLater(() -> MediathekGui.ui().tabFilme.bookmarkFilmAction.actionPerformed(null)));
        this.toolBar.btnManageBookMarks.setOnAction(e -> SwingUtilities.invokeLater(() -> MediathekGui.ui().tabFilme.bookmarkManageListAction.actionPerformed(null)));
        this.toolBar.btnManageAbos.setOnAction(e -> SwingUtilities.invokeLater(() -> {
            if (this.manageAboAction.isEnabled()) {
                this.manageAboAction.actionPerformed(null);
            }
        }));
        this.toolBar.btnShowFilter.setOnAction(e -> SwingUtilities.invokeLater(() -> {
            if (this.filterDialog != null) {
                this.filterDialog.setVisible(!this.filterDialog.isVisible());
            }
        }));
    }

    public Scene getFilmActionPanelScene() {
        this.setupToolBar();
        this.setupSearchField();
        this.setupSearchThroughDescriptionButton();
        this.setupShowBookmarkedMoviesButton();
        Daten.getInstance().getFilmeLaden().addAdListener(new ListenerFilmeLaden(){

            @Override
            public void start(ListenerFilmeLadenEvent event) {
                Platform.runLater(() -> FilmActionPanel.this.toolBar.setDisable(true));
            }

            @Override
            public void fertig(ListenerFilmeLadenEvent event) {
                Platform.runLater(() -> FilmActionPanel.this.toolBar.setDisable(false));
            }
        });
        return new Scene((Parent)this.toolBar);
    }
}

