/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool.models;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import mediathek.daten.DatenFilm;
import mediathek.tool.FilmSize;
import mediathek.tool.datum.DatumFilm;

public class TModelFilm
extends AbstractTableModel {
    private static final int COLUMN_COUNT = 15;
    private final List<DatenFilm> dataList;

    public TModelFilm() {
        this.dataList = new ArrayList<DatenFilm>();
    }

    public TModelFilm(int capacity) {
        this.dataList = new ArrayList<DatenFilm>(capacity);
    }

    @Override
    public boolean isCellEditable(int i, int j) {
        return false;
    }

    public int getModelRowForFilmNumber(int reqFilmNr) {
        int ret = 0;
        for (DatenFilm film : this.dataList) {
            if (film.getFilmNr() == reqFilmNr) {
                return ret;
            }
            ++ret;
        }
        return -1;
    }

    @Override
    public int getRowCount() {
        return this.dataList.size();
    }

    @Override
    public int getColumnCount() {
        return 15;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return switch (columnIndex) {
            case 0, 9 -> Integer.class;
            case 7 -> DatumFilm.class;
            case 10 -> FilmSize.class;
            case 11, 12 -> Boolean.class;
            case 15 -> Long.class;
            default -> String.class;
        };
    }

    @Override
    public String getColumnName(int column) {
        return switch (column) {
            case 4, 5, 6 -> "";
            case 0 -> "Nr";
            case 1 -> "Sender";
            case 2 -> "Thema";
            case 3 -> "Titel";
            case 7 -> "Datum";
            case 8 -> "Zeit";
            case 9 -> "Dauer";
            case 10 -> "Gr\u00f6\u00dfe [MB]";
            case 11 -> "HQ";
            case 12 -> "UT";
            case 13 -> "Geo";
            case 14 -> "URL";
            default -> throw new IndexOutOfBoundsException("UNKNOWN COLUMN NAME: " + column);
        };
    }

    @Override
    public Object getValueAt(int row, int column) {
        DatenFilm film = this.dataList.get(row);
        return switch (column) {
            case 0 -> film.getFilmNr();
            case 1 -> film.getSender();
            case 2 -> film.getThema();
            case 3 -> film.getTitle();
            case 4, 5, 6 -> "";
            case 7 -> film.getDatumFilm();
            case 8 -> film.getSendeZeit();
            case 9 -> film.getDuration();
            case 10 -> film.getFilmSize();
            case 11 -> film.isHighQuality();
            case 12 -> film.hasSubtitle();
            case 13 -> film.getGeo().orElse("");
            case 14 -> film.getUrlNormalQuality();
            case 16 -> film;
            default -> throw new IndexOutOfBoundsException("UNKNOWN COLUMN VALUE: " + column);
        };
    }

    public void addAll(List<DatenFilm> listeFilme) {
        int oldRowCount = this.dataList.size();
        this.dataList.addAll(listeFilme);
        this.fireTableRowsInserted(oldRowCount, oldRowCount + this.dataList.size());
    }
}

