/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.table;

import java.lang.reflect.Field;
import java.util.function.Consumer;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.TableView;
import javafx.scene.control.TreeTableView;
import javafx.scene.control.skin.TableHeaderRow;
import javafx.scene.control.skin.TableViewSkin;
import javafx.scene.control.skin.TableViewSkinBase;

final class TableViewUtils {
    TableViewUtils() {
    }

    public static void modifyTableMenu(TableView<?> tableView, Consumer<ContextMenu> consumer) {
        TableViewUtils.modifyTableMenu(tableView, consumer);
    }

    public static void modifyTableMenu(TreeTableView<?> treeTableView, Consumer<ContextMenu> consumer) {
        TableViewUtils.modifyTableMenu(treeTableView, consumer);
    }

    private static void modifyTableMenu(final Control control, final Consumer<ContextMenu> consumer) {
        if (control.getScene() == null) {
            control.sceneProperty().addListener(new InvalidationListener(){

                public void invalidated(Observable o) {
                    control.sceneProperty().removeListener((InvalidationListener)this);
                    TableViewUtils.modifyTableMenu(control, (Consumer<ContextMenu>)consumer);
                }
            });
            return;
        }
        Skin skin = control.getSkin();
        if (skin == null) {
            control.skinProperty().addListener(new InvalidationListener(){

                public void invalidated(Observable o) {
                    control.skinProperty().removeListener((InvalidationListener)this);
                    TableViewUtils.modifyTableMenu(control, (Consumer<ContextMenu>)consumer);
                }
            });
            return;
        }
        TableViewUtils.doModify(skin, consumer);
    }

    private static void doModify(Skin<?> skin, Consumer<ContextMenu> consumer) {
        if (!(skin instanceof TableViewSkinBase)) {
            return;
        }
        TableViewSkin tableSkin = (TableViewSkin)skin;
        TableHeaderRow headerRow = TableViewUtils.getHeaderRow(tableSkin);
        if (headerRow == null) {
            return;
        }
        ContextMenu contextMenu = TableViewUtils.getContextMenu(headerRow);
        consumer.accept(contextMenu);
    }

    private static TableHeaderRow getHeaderRow(TableViewSkin<?> tableSkin) {
        ObservableList children = tableSkin.getChildren();
        int max = children.size();
        for (int i = 0; i < max; ++i) {
            Node child = (Node)children.get(i);
            if (!(child instanceof TableHeaderRow)) continue;
            return (TableHeaderRow)child;
        }
        return null;
    }

    private static ContextMenu getContextMenu(TableHeaderRow headerRow) {
        try {
            Field privateContextMenuField = TableHeaderRow.class.getDeclaredField("columnPopupMenu");
            privateContextMenuField.setAccessible(true);
            ContextMenu contextMenu = (ContextMenu)privateContextMenuField.get(headerRow);
            return contextMenu;
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        catch (NoSuchFieldException ex) {
            ex.printStackTrace();
        }
        catch (SecurityException ex) {
            ex.printStackTrace();
        }
        return null;
    }
}

